// third_party/blink/public/mojom/media/renderer_audio_output_stream_factory.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/media/renderer_audio_output_stream_factory.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/media/renderer_audio_output_stream_factory.mojom-params-data.h"
#include "third_party/blink/public/mojom/media/renderer_audio_output_stream_factory.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/media/renderer_audio_output_stream_factory.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/media/renderer_audio_output_stream_factory.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
// The declaration includes the definition on other builds.

RendererAudioOutputStreamFactory::IPCStableHashFunction RendererAudioOutputStreamFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::RendererAudioOutputStreamFactory>(message.name())) {
    case messages::RendererAudioOutputStreamFactory::kRequestDeviceAuthorization: {
      return &RendererAudioOutputStreamFactory::RequestDeviceAuthorization_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* RendererAudioOutputStreamFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::RendererAudioOutputStreamFactory>(message.name())) {
      case messages::RendererAudioOutputStreamFactory::kRequestDeviceAuthorization:
            return "Receive blink::mojom::RendererAudioOutputStreamFactory::RequestDeviceAuthorization";
    }
  } else {
    switch (static_cast<messages::RendererAudioOutputStreamFactory>(message.name())) {
      case messages::RendererAudioOutputStreamFactory::kRequestDeviceAuthorization:
            return "Receive reply blink::mojom::RendererAudioOutputStreamFactory::RequestDeviceAuthorization";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t RendererAudioOutputStreamFactory::RequestDeviceAuthorization_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x626d41fb;  // IPCStableHash for blink::mojom::RendererAudioOutputStreamFactory::RequestDeviceAuthorization
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ForwardToCallback(
      RendererAudioOutputStreamFactory::RequestDeviceAuthorizationCallback callback
      ) : callback_(std::move(callback)) {
  }

  RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ForwardToCallback(const RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ForwardToCallback&) = delete;
  RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ForwardToCallback& operator=(const RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  RendererAudioOutputStreamFactory::RequestDeviceAuthorizationCallback callback_;
};

RendererAudioOutputStreamFactoryProxy::RendererAudioOutputStreamFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RendererAudioOutputStreamFactoryProxy::RequestDeviceAuthorization(
    ::mojo::PendingReceiver<::media::mojom::blink::AudioOutputStreamProvider> in_stream_provider_receiver, const std::optional<::base::UnguessableToken>& in_session_id, const ::blink::String& in_device_id, RequestDeviceAuthorizationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::RendererAudioOutputStreamFactory::RequestDeviceAuthorization", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream_provider_receiver"), in_stream_provider_receiver,
                        "<value of type ::mojo::PendingReceiver<::media::mojom::blink::AudioOutputStreamProvider>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_id"), in_session_id,
                        "<value of type const std::optional<::base::UnguessableToken>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_id"), in_device_id,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RendererAudioOutputStreamFactory::kRequestDeviceAuthorization), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RendererAudioOutputStreamFactory_RequestDeviceAuthorization_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::AudioOutputStreamProviderInterfaceBase>>(
    in_stream_provider_receiver,
    &params->stream_provider_receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->stream_provider_receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid stream_provider_receiver in RendererAudioOutputStreamFactory.RequestDeviceAuthorization request");
  mojo::internal::MessageFragment<
      typename decltype(params->session_id)::BaseType> session_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_session_id,
    session_id_fragment);

  params->session_id.Set(
      session_id_fragment.is_null() ? nullptr : session_id_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->device_id)::BaseType> device_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_device_id,
    device_id_fragment);

  params->device_id.Set(
      device_id_fragment.is_null() ? nullptr : device_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->device_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null device_id in RendererAudioOutputStreamFactory.RequestDeviceAuthorization request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererAudioOutputStreamFactory::Name_);
  message.set_method_name("RequestDeviceAuthorization");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static RendererAudioOutputStreamFactory::RequestDeviceAuthorizationCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ProxyToResponder> proxy(
        new RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "RendererAudioOutputStreamFactory::RequestDeviceAuthorizationCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::media::mojom::blink::OutputDeviceStatus in_state, const ::media::AudioParameters& in_output_params, const ::blink::String& in_matched_device_id);
};

bool RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ResponseParams_Data* params =
      reinterpret_cast<
          internal::RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for RendererAudioOutputStreamFactory.0
  bool success = true;
  ::media::mojom::blink::OutputDeviceStatus p_state{};
  ::media::AudioParameters p_output_params{};
  ::blink::String p_matched_device_id{};
  RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadState(&p_state))
    success = false;
  if (success && !input_data_view.ReadOutputParams(&p_output_params))
    success = false;
  if (success && !input_data_view.ReadMatchedDeviceId(&p_matched_device_id))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RendererAudioOutputStreamFactory::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_state), 
std::move(p_output_params), 
std::move(p_matched_device_id));
  }
  return true;
}

void RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ProxyToResponder::Run(
    ::media::mojom::blink::OutputDeviceStatus in_state, const ::media::AudioParameters& in_output_params, const ::blink::String& in_matched_device_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::RendererAudioOutputStreamFactory::RequestDeviceAuthorization", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type ::media::mojom::blink::OutputDeviceStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("output_params"), in_output_params,
                        "<value of type const ::media::AudioParameters&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("matched_device_id"), in_matched_device_id,
                        "<value of type const ::blink::String&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RendererAudioOutputStreamFactory::kRequestDeviceAuthorization), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media::mojom::OutputDeviceStatus>(
    in_state,
    &params->state);
  mojo::internal::MessageFragment<
      typename decltype(params->output_params)::BaseType> output_params_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::AudioParametersDataView>(
    in_output_params,
    output_params_fragment);

  params->output_params.Set(
      output_params_fragment.is_null() ? nullptr : output_params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->output_params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null output_params in ");
  mojo::internal::MessageFragment<
      typename decltype(params->matched_device_id)::BaseType> matched_device_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_matched_device_id,
    matched_device_id_fragment);

  params->matched_device_id.Set(
      matched_device_id_fragment.is_null() ? nullptr : matched_device_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->matched_device_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null matched_device_id in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererAudioOutputStreamFactory::Name_);
  message.set_method_name("RequestDeviceAuthorization");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool RendererAudioOutputStreamFactoryStubDispatch::Accept(
    RendererAudioOutputStreamFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::RendererAudioOutputStreamFactory>(message->header()->name)) {
    case messages::RendererAudioOutputStreamFactory::kRequestDeviceAuthorization: {
      break;
    }
  }
  return false;
}

// static
bool RendererAudioOutputStreamFactoryStubDispatch::AcceptWithResponder(
    RendererAudioOutputStreamFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::RendererAudioOutputStreamFactory>(message->header()->name)) {
    case messages::RendererAudioOutputStreamFactory::kRequestDeviceAuthorization: {
      internal::RendererAudioOutputStreamFactory_RequestDeviceAuthorization_Params_Data* params =
          reinterpret_cast<
              internal::RendererAudioOutputStreamFactory_RequestDeviceAuthorization_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for RendererAudioOutputStreamFactory.0
      bool success = true;
      ::mojo::PendingReceiver<::media::mojom::blink::AudioOutputStreamProvider> p_stream_provider_receiver{};
      std::optional<::base::UnguessableToken> p_session_id{};
      ::blink::String p_device_id{};
      RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_stream_provider_receiver =
            input_data_view.TakeStreamProviderReceiver<decltype(p_stream_provider_receiver)>();
      }
      if (success && !input_data_view.ReadSessionId(&p_session_id))
        success = false;
      if (success && !input_data_view.ReadDeviceId(&p_device_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RendererAudioOutputStreamFactory::Name_, 0, false);
        return false;
      }
      auto callback =
          RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestDeviceAuthorization(        
        std::move(p_stream_provider_receiver), 
        std::move(p_session_id), 
        std::move(p_device_id), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kRendererAudioOutputStreamFactoryValidationInfo[] = {
    { &internal::RendererAudioOutputStreamFactory_RequestDeviceAuthorization_Params_Data::Validate,
     &internal::RendererAudioOutputStreamFactory_RequestDeviceAuthorization_ResponseParams_Data::Validate},
};

bool RendererAudioOutputStreamFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::RendererAudioOutputStreamFactory::Name_,
    kRendererAudioOutputStreamFactoryValidationInfo);
}

bool RendererAudioOutputStreamFactoryResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::RendererAudioOutputStreamFactory::Name_,
    kRendererAudioOutputStreamFactoryValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void RendererAudioOutputStreamFactoryInterceptorForTesting::RequestDeviceAuthorization(::mojo::PendingReceiver<::media::mojom::blink::AudioOutputStreamProvider> stream_provider_receiver, const std::optional<::base::UnguessableToken>& session_id, const ::blink::String& device_id, RequestDeviceAuthorizationCallback callback) {
  GetForwardingInterface()->RequestDeviceAuthorization(
    std::move(stream_provider_receiver)
    , 
    std::move(session_id)
    , 
    std::move(device_id)
    , std::move(callback));
}
RendererAudioOutputStreamFactoryAsyncWaiter::RendererAudioOutputStreamFactoryAsyncWaiter(
    RendererAudioOutputStreamFactory* proxy) : proxy_(proxy) {}

RendererAudioOutputStreamFactoryAsyncWaiter::~RendererAudioOutputStreamFactoryAsyncWaiter() = default;


void RendererAudioOutputStreamFactoryAsyncWaiter::RequestDeviceAuthorization(
    ::mojo::PendingReceiver<::media::mojom::blink::AudioOutputStreamProvider> stream_provider_receiver, const std::optional<::base::UnguessableToken>& session_id, const ::blink::String& device_id, ::media::mojom::blink::OutputDeviceStatus* out_state, ::media::AudioParameters* out_output_params, ::blink::String* out_matched_device_id) {
  base::RunLoop loop;
  proxy_->RequestDeviceAuthorization(
      std::move(stream_provider_receiver),
      std::move(session_id),
      std::move(device_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::media::mojom::blink::OutputDeviceStatus* out_state
,
             ::media::AudioParameters* out_output_params
,
             ::blink::String* out_matched_device_id
,
             ::media::mojom::blink::OutputDeviceStatus state,
             const ::media::AudioParameters& output_params,
             const ::blink::String& matched_device_id) {*out_state = std::move(state);*out_output_params = std::move(output_params);*out_matched_device_id = std::move(matched_device_id);
            loop->Quit();
          },
          &loop,
          out_state,
          out_output_params,
          out_matched_device_id));
  loop.Run();
}








}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif