// third_party/blink/public/mojom/locks/lock_manager.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const LockModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const LockMode = {
  
  SHARED: 0,
  EXCLUSIVE: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class LockHandlePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.LockHandle', scope);
  }
}

/** @interface */
export class LockHandleInterface {
}

/**
 * @implements { LockHandleInterface }
 */
export class LockHandleRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!LockHandlePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          LockHandlePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!LockHandlePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }
}

/**
 * An object which receives request messages for the LockHandle
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class LockHandleReceiver {
  /**
   * @param {!LockHandleInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!LockHandleRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        LockHandleRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!LockHandleRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class LockHandle {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.LockHandle";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!LockHandleRemote}
   */
  static getRemote() {
    let remote = new LockHandleRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the LockHandle
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class LockHandleCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      LockHandleRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!LockHandleRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class LockRequestPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.LockRequest', scope);
  }
}

/** @interface */
export class LockRequestInterface {
  
  /**
   * @param { !Object } lockHandle
   */

  granted(lockHandle) {}
  
  /**
   */

  failed() {}
}

/**
 * @implements { LockRequestInterface }
 */
export class LockRequestRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!LockRequestPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          LockRequestPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!LockRequestPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Object } lockHandle
   */

  granted(
      lockHandle) {
    this.proxy.sendMessage(
        0,
        LockRequest_Granted_ParamsSpec.$,
        null,
        [
          lockHandle
        ],
        false);
  }

  
  /**
   */

  failed() {
    this.proxy.sendMessage(
        1,
        LockRequest_Failed_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the LockRequest
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class LockRequestReceiver {
  /**
   * @param {!LockRequestInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!LockRequestRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        LockRequestRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!LockRequestRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        LockRequest_Granted_ParamsSpec.$,
        null,
        impl.granted.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        LockRequest_Failed_ParamsSpec.$,
        null,
        impl.failed.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class LockRequest {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.LockRequest";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!LockRequestRemote}
   */
  static getRemote() {
    let remote = new LockRequestRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the LockRequest
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class LockRequestCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      LockRequestRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!LockRequestRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.granted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        LockRequest_Granted_ParamsSpec.$,
        null,
        this.granted.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.failed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        LockRequest_Failed_ParamsSpec.$,
        null,
        this.failed.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class LockManagerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.LockManager', scope);
  }
}

/** @interface */
export class LockManagerInterface {
  
  /**
   * @param { !string } name
   * @param { !LockMode } mode
   * @param { !LockManager_WaitMode } wait
   * @param { !Object } request
   */

  requestLock(name, mode, wait, request) {}
  
  /**
   * @return {!Promise<{
        requested: !Array<!LockInfo>,
        held: !Array<!LockInfo>,
   *  }>}
   */

  queryState() {}
}

/**
 * @implements { LockManagerInterface }
 */
export class LockManagerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!LockManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          LockManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!LockManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } name
   * @param { !LockMode } mode
   * @param { !LockManager_WaitMode } wait
   * @param { !Object } request
   */

  requestLock(
      name,
      mode,
      wait,
      request) {
    this.proxy.sendMessage(
        0,
        LockManager_RequestLock_ParamsSpec.$,
        null,
        [
          name,
          mode,
          wait,
          request
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        requested: !Array<!LockInfo>,
        held: !Array<!LockInfo>,
   *  }>}
   */

  queryState() {
    return this.proxy.sendMessage(
        1,
        LockManager_QueryState_ParamsSpec.$,
        LockManager_QueryState_ResponseParamsSpec.$,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the LockManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class LockManagerReceiver {
  /**
   * @param {!LockManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!LockManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        LockManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!LockManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        LockManager_RequestLock_ParamsSpec.$,
        null,
        impl.requestLock.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        LockManager_QueryState_ParamsSpec.$,
        LockManager_QueryState_ResponseParamsSpec.$,
        impl.queryState.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class LockManager {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.LockManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!LockManagerRemote}
   */
  static getRemote() {
    let remote = new LockManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const LockManager_WaitModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const LockManager_WaitMode = {
  
  WAIT: 0,
  NO_WAIT: 1,
  PREEMPT: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * An object which receives request messages for the LockManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class LockManagerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      LockManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!LockManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestLock =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        LockManager_RequestLock_ParamsSpec.$,
        null,
        this.requestLock.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.queryState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        LockManager_QueryState_ParamsSpec.$,
        LockManager_QueryState_ResponseParamsSpec.$,
        this.queryState.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LockInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LockRequest_Granted_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LockRequest_Failed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LockManager_RequestLock_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LockManager_QueryState_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LockManager_QueryState_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    LockInfoSpec.$,
    'LockInfo',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mode', 8,
        0,
        LockModeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'clientId', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class LockInfo {
  constructor() {
    /** @type { !string } */
    this.name;
    /** @type { !LockMode } */
    this.mode;
    /** @type { !string } */
    this.clientId;
  }
}



mojo.internal.Struct(
    LockRequest_Granted_ParamsSpec.$,
    'LockRequest_Granted_Params',
    [
      mojo.internal.StructField(
        'lockHandle', 0,
        0,
        mojo.internal.AssociatedInterfaceProxy(LockHandleRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class LockRequest_Granted_Params {
  constructor() {
    /** @type { !Object } */
    this.lockHandle;
  }
}



mojo.internal.Struct(
    LockRequest_Failed_ParamsSpec.$,
    'LockRequest_Failed_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class LockRequest_Failed_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    LockManager_RequestLock_ParamsSpec.$,
    'LockManager_RequestLock_Params',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mode', 8,
        0,
        LockModeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'wait', 12,
        0,
        LockManager_WaitModeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'request', 16,
        0,
        mojo.internal.AssociatedInterfaceProxy(LockRequestRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class LockManager_RequestLock_Params {
  constructor() {
    /** @type { !string } */
    this.name;
    /** @type { !LockMode } */
    this.mode;
    /** @type { !LockManager_WaitMode } */
    this.wait;
    /** @type { !Object } */
    this.request;
  }
}



mojo.internal.Struct(
    LockManager_QueryState_ParamsSpec.$,
    'LockManager_QueryState_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class LockManager_QueryState_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    LockManager_QueryState_ResponseParamsSpec.$,
    'LockManager_QueryState_ResponseParams',
    [
      mojo.internal.StructField(
        'requested', 0,
        0,
        mojo.internal.Array(LockInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'held', 8,
        0,
        mojo.internal.Array(LockInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class LockManager_QueryState_ResponseParams {
  constructor() {
    /** @type { !Array<!LockInfo> } */
    this.requested;
    /** @type { !Array<!LockInfo> } */
    this.held;
  }
}

