// third_party/blink/public/mojom/loader/navigation_predictor.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/loader/navigation_predictor.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../../mojo/public/mojom/base/time.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../../url/mojom/url.mojom.js');
  }
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }
  var anchor_element_interaction_host$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/preloading/anchor_element_interaction_host.mojom', '../preloading/anchor_element_interaction_host.mojom.js');
  }


  var AnchorElementUserInteractionEventForMLModelType = {};
  AnchorElementUserInteractionEventForMLModelType.kPointerOver = 0;
  AnchorElementUserInteractionEventForMLModelType.kPointerOut = 1;
  AnchorElementUserInteractionEventForMLModelType.kEnteredViewport = 2;
  AnchorElementUserInteractionEventForMLModelType.kLeftViewport = 3;
  AnchorElementUserInteractionEventForMLModelType.kUnknown = 4;
  AnchorElementUserInteractionEventForMLModelType.MIN_VALUE = 0;
  AnchorElementUserInteractionEventForMLModelType.MAX_VALUE = 4;

  AnchorElementUserInteractionEventForMLModelType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
      return true;
    }
    return false;
  };

  AnchorElementUserInteractionEventForMLModelType.toKnownEnumValue = function(value) {
    return value;
  };

  AnchorElementUserInteractionEventForMLModelType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function AnchorElementMetrics(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AnchorElementMetrics.prototype.initDefaults_ = function() {
    this.anchorId = 0;
    this.ratioArea = 0;
    this.ratioDistanceTopToVisibleTop = 0;
    this.ratioDistanceRootTop = 0;
    this.isInIframe = false;
    this.containsImage = false;
    this.isSameHost = false;
    this.isUrlIncrementedByOne = false;
    this.hasTextSibling = false;
    this.fontSizePx = 0;
    this.fontWeight = 0;
    this.targetUrl = null;
    this.viewportSize = null;
  };
  AnchorElementMetrics.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AnchorElementMetrics.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;













    // validate AnchorElementMetrics.targetUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AnchorElementMetrics.viewportSize
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AnchorElementMetrics.encodedSize = codec.kStructHeaderSize + 48;

  AnchorElementMetrics.decode = function(decoder) {
    var packed;
    var val = new AnchorElementMetrics();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.anchorId =
        decoder.decodeStruct(codec.Uint32);
    val.ratioArea =
        decoder.decodeStruct(codec.Float);
    val.ratioDistanceTopToVisibleTop =
        decoder.decodeStruct(codec.Float);
    val.ratioDistanceRootTop =
        decoder.decodeStruct(codec.Float);
    packed = decoder.readUint8();
    val.isInIframe = (packed >> 0) & 1 ? true : false;
    val.containsImage = (packed >> 1) & 1 ? true : false;
    val.isSameHost = (packed >> 2) & 1 ? true : false;
    val.isUrlIncrementedByOne = (packed >> 3) & 1 ? true : false;
    val.hasTextSibling = (packed >> 4) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.fontSizePx =
        decoder.decodeStruct(codec.Uint32);
    val.fontWeight =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.targetUrl =
        decoder.decodeStructPointer(url$.Url);
    val.viewportSize =
        decoder.decodeStructPointer(geometry$.Size);
    return val;
  };

  AnchorElementMetrics.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AnchorElementMetrics.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.anchorId);
    encoder.encodeStruct(codec.Float, val.ratioArea);
    encoder.encodeStruct(codec.Float, val.ratioDistanceTopToVisibleTop);
    encoder.encodeStruct(codec.Float, val.ratioDistanceRootTop);
    packed = 0;
    packed |= (val.isInIframe & 1) << 0
    packed |= (val.containsImage & 1) << 1
    packed |= (val.isSameHost & 1) << 2
    packed |= (val.isUrlIncrementedByOne & 1) << 3
    packed |= (val.hasTextSibling & 1) << 4
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint32, val.fontSizePx);
    encoder.encodeStruct(codec.Uint32, val.fontWeight);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(url$.Url, val.targetUrl);
    encoder.encodeStructPointer(geometry$.Size, val.viewportSize);
  };
  function AnchorElementClick(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AnchorElementClick.prototype.initDefaults_ = function() {
    this.anchorId = 0;
    this.targetUrl = null;
    this.navigationStartToClick = null;
  };
  AnchorElementClick.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AnchorElementClick.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate AnchorElementClick.targetUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AnchorElementClick.navigationStartToClick
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AnchorElementClick.encodedSize = codec.kStructHeaderSize + 24;

  AnchorElementClick.decode = function(decoder) {
    var packed;
    var val = new AnchorElementClick();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.anchorId =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.targetUrl =
        decoder.decodeStructPointer(url$.Url);
    val.navigationStartToClick =
        decoder.decodeStructPointer(time$.TimeDelta);
    return val;
  };

  AnchorElementClick.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AnchorElementClick.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.anchorId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(url$.Url, val.targetUrl);
    encoder.encodeStructPointer(time$.TimeDelta, val.navigationStartToClick);
  };
  function AnchorElementPointerDataOnHoverTimerFired(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AnchorElementPointerDataOnHoverTimerFired.prototype.initDefaults_ = function() {
    this.anchorId = 0;
    this.pointerData = null;
  };
  AnchorElementPointerDataOnHoverTimerFired.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AnchorElementPointerDataOnHoverTimerFired.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate AnchorElementPointerDataOnHoverTimerFired.pointerData
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, anchor_element_interaction_host$.AnchorElementPointerData, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AnchorElementPointerDataOnHoverTimerFired.encodedSize = codec.kStructHeaderSize + 16;

  AnchorElementPointerDataOnHoverTimerFired.decode = function(decoder) {
    var packed;
    var val = new AnchorElementPointerDataOnHoverTimerFired();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.anchorId =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.pointerData =
        decoder.decodeStructPointer(anchor_element_interaction_host$.AnchorElementPointerData);
    return val;
  };

  AnchorElementPointerDataOnHoverTimerFired.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AnchorElementPointerDataOnHoverTimerFired.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.anchorId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(anchor_element_interaction_host$.AnchorElementPointerData, val.pointerData);
  };
  function AnchorElementEnteredViewport(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AnchorElementEnteredViewport.prototype.initDefaults_ = function() {
    this.anchorId = 0;
    this.navigationStartToEnteredViewport = null;
  };
  AnchorElementEnteredViewport.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AnchorElementEnteredViewport.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate AnchorElementEnteredViewport.navigationStartToEnteredViewport
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AnchorElementEnteredViewport.encodedSize = codec.kStructHeaderSize + 16;

  AnchorElementEnteredViewport.decode = function(decoder) {
    var packed;
    var val = new AnchorElementEnteredViewport();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.anchorId =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.navigationStartToEnteredViewport =
        decoder.decodeStructPointer(time$.TimeDelta);
    return val;
  };

  AnchorElementEnteredViewport.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AnchorElementEnteredViewport.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.anchorId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(time$.TimeDelta, val.navigationStartToEnteredViewport);
  };
  function AnchorElementLeftViewport(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AnchorElementLeftViewport.prototype.initDefaults_ = function() {
    this.anchorId = 0;
    this.timeInViewport = null;
  };
  AnchorElementLeftViewport.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AnchorElementLeftViewport.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate AnchorElementLeftViewport.timeInViewport
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AnchorElementLeftViewport.encodedSize = codec.kStructHeaderSize + 16;

  AnchorElementLeftViewport.decode = function(decoder) {
    var packed;
    var val = new AnchorElementLeftViewport();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.anchorId =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.timeInViewport =
        decoder.decodeStructPointer(time$.TimeDelta);
    return val;
  };

  AnchorElementLeftViewport.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AnchorElementLeftViewport.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.anchorId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(time$.TimeDelta, val.timeInViewport);
  };
  function AnchorElementPointerOver(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AnchorElementPointerOver.prototype.initDefaults_ = function() {
    this.anchorId = 0;
    this.navigationStartToPointerOver = null;
  };
  AnchorElementPointerOver.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AnchorElementPointerOver.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate AnchorElementPointerOver.navigationStartToPointerOver
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AnchorElementPointerOver.encodedSize = codec.kStructHeaderSize + 16;

  AnchorElementPointerOver.decode = function(decoder) {
    var packed;
    var val = new AnchorElementPointerOver();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.anchorId =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.navigationStartToPointerOver =
        decoder.decodeStructPointer(time$.TimeDelta);
    return val;
  };

  AnchorElementPointerOver.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AnchorElementPointerOver.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.anchorId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(time$.TimeDelta, val.navigationStartToPointerOver);
  };
  function AnchorElementPointerOut(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AnchorElementPointerOut.prototype.initDefaults_ = function() {
    this.anchorId = 0;
    this.hoverDwellTime = null;
  };
  AnchorElementPointerOut.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AnchorElementPointerOut.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate AnchorElementPointerOut.hoverDwellTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AnchorElementPointerOut.encodedSize = codec.kStructHeaderSize + 16;

  AnchorElementPointerOut.decode = function(decoder) {
    var packed;
    var val = new AnchorElementPointerOut();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.anchorId =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.hoverDwellTime =
        decoder.decodeStructPointer(time$.TimeDelta);
    return val;
  };

  AnchorElementPointerOut.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AnchorElementPointerOut.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.anchorId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(time$.TimeDelta, val.hoverDwellTime);
  };
  function AnchorElementPointerEventForMLModel(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AnchorElementPointerEventForMLModel.prototype.initDefaults_ = function() {
    this.anchorId = 0;
    this.isMouse = false;
    this.userInteractionEventType = 0;
  };
  AnchorElementPointerEventForMLModel.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AnchorElementPointerEventForMLModel.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate AnchorElementPointerEventForMLModel.userInteractionEventType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, AnchorElementUserInteractionEventForMLModelType);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AnchorElementPointerEventForMLModel.encodedSize = codec.kStructHeaderSize + 16;

  AnchorElementPointerEventForMLModel.decode = function(decoder) {
    var packed;
    var val = new AnchorElementPointerEventForMLModel();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.anchorId =
        decoder.decodeStruct(codec.Uint32);
    packed = decoder.readUint8();
    val.isMouse = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.userInteractionEventType =
        decoder.decodeStruct(new codec.Enum(AnchorElementUserInteractionEventForMLModelType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  AnchorElementPointerEventForMLModel.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AnchorElementPointerEventForMLModel.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.anchorId);
    packed = 0;
    packed |= (val.isMouse & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.userInteractionEventType);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function AnchorElementPointerDown(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AnchorElementPointerDown.prototype.initDefaults_ = function() {
    this.anchorId = 0;
    this.navigationStartToPointerDown = null;
  };
  AnchorElementPointerDown.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AnchorElementPointerDown.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate AnchorElementPointerDown.navigationStartToPointerDown
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AnchorElementPointerDown.encodedSize = codec.kStructHeaderSize + 16;

  AnchorElementPointerDown.decode = function(decoder) {
    var packed;
    var val = new AnchorElementPointerDown();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.anchorId =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.navigationStartToPointerDown =
        decoder.decodeStructPointer(time$.TimeDelta);
    return val;
  };

  AnchorElementPointerDown.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AnchorElementPointerDown.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.anchorId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(time$.TimeDelta, val.navigationStartToPointerDown);
  };
  function AnchorElementPositionUpdate(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AnchorElementPositionUpdate.prototype.initDefaults_ = function() {
    this.anchorId = 0;
    this.verticalPositionRatio = 0;
    this.distance_from_pointer_down_ratio_$flag = false;
    this.distance_from_pointer_down_ratio_$value = 0;
  };
  AnchorElementPositionUpdate.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AnchorElementPositionUpdate.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;





    return validator.validationError.NONE;
  };

  AnchorElementPositionUpdate.encodedSize = codec.kStructHeaderSize + 16;

  AnchorElementPositionUpdate.decode = function(decoder) {
    var packed;
    var val = new AnchorElementPositionUpdate();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.anchorId =
        decoder.decodeStruct(codec.Uint32);
    val.verticalPositionRatio =
        decoder.decodeStruct(codec.Float);
    packed = decoder.readUint8();
    val.distance_from_pointer_down_ratio_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.distance_from_pointer_down_ratio_$value =
        decoder.decodeStruct(codec.Float);
    return val;
  };

  AnchorElementPositionUpdate.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AnchorElementPositionUpdate.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.anchorId);
    encoder.encodeStruct(codec.Float, val.verticalPositionRatio);
    packed = 0;
    packed |= (val.distance_from_pointer_down_ratio_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Float, val.distance_from_pointer_down_ratio_$value);
  };
  function AnchorElementMetricsHost_ReportAnchorElementClick_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AnchorElementMetricsHost_ReportAnchorElementClick_Params.prototype.initDefaults_ = function() {
    this.clicked = null;
  };
  AnchorElementMetricsHost_ReportAnchorElementClick_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AnchorElementMetricsHost_ReportAnchorElementClick_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AnchorElementMetricsHost_ReportAnchorElementClick_Params.clicked
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, AnchorElementClick, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AnchorElementMetricsHost_ReportAnchorElementClick_Params.encodedSize = codec.kStructHeaderSize + 8;

  AnchorElementMetricsHost_ReportAnchorElementClick_Params.decode = function(decoder) {
    var packed;
    var val = new AnchorElementMetricsHost_ReportAnchorElementClick_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.clicked =
        decoder.decodeStructPointer(AnchorElementClick);
    return val;
  };

  AnchorElementMetricsHost_ReportAnchorElementClick_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AnchorElementMetricsHost_ReportAnchorElementClick_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(AnchorElementClick, val.clicked);
  };
  function AnchorElementMetricsHost_ReportNewAnchorElements_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AnchorElementMetricsHost_ReportNewAnchorElements_Params.prototype.initDefaults_ = function() {
    this.metrics = null;
    this.removedElements = null;
  };
  AnchorElementMetricsHost_ReportNewAnchorElements_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AnchorElementMetricsHost_ReportNewAnchorElements_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AnchorElementMetricsHost_ReportNewAnchorElements_Params.metrics
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(AnchorElementMetrics), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AnchorElementMetricsHost_ReportNewAnchorElements_Params.removedElements
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 4, codec.Uint32, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AnchorElementMetricsHost_ReportNewAnchorElements_Params.encodedSize = codec.kStructHeaderSize + 16;

  AnchorElementMetricsHost_ReportNewAnchorElements_Params.decode = function(decoder) {
    var packed;
    var val = new AnchorElementMetricsHost_ReportNewAnchorElements_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.metrics =
        decoder.decodeArrayPointer(new codec.PointerTo(AnchorElementMetrics));
    val.removedElements =
        decoder.decodeArrayPointer(codec.Uint32);
    return val;
  };

  AnchorElementMetricsHost_ReportNewAnchorElements_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AnchorElementMetricsHost_ReportNewAnchorElements_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(AnchorElementMetrics), val.metrics);
    encoder.encodeArrayPointer(codec.Uint32, val.removedElements);
  };
  function AnchorElementMetricsHost_ReportAnchorElementsEnteredViewport_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AnchorElementMetricsHost_ReportAnchorElementsEnteredViewport_Params.prototype.initDefaults_ = function() {
    this.elements = null;
  };
  AnchorElementMetricsHost_ReportAnchorElementsEnteredViewport_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AnchorElementMetricsHost_ReportAnchorElementsEnteredViewport_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AnchorElementMetricsHost_ReportAnchorElementsEnteredViewport_Params.elements
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(AnchorElementEnteredViewport), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AnchorElementMetricsHost_ReportAnchorElementsEnteredViewport_Params.encodedSize = codec.kStructHeaderSize + 8;

  AnchorElementMetricsHost_ReportAnchorElementsEnteredViewport_Params.decode = function(decoder) {
    var packed;
    var val = new AnchorElementMetricsHost_ReportAnchorElementsEnteredViewport_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.elements =
        decoder.decodeArrayPointer(new codec.PointerTo(AnchorElementEnteredViewport));
    return val;
  };

  AnchorElementMetricsHost_ReportAnchorElementsEnteredViewport_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AnchorElementMetricsHost_ReportAnchorElementsEnteredViewport_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(AnchorElementEnteredViewport), val.elements);
  };
  function AnchorElementMetricsHost_ReportAnchorElementsLeftViewport_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AnchorElementMetricsHost_ReportAnchorElementsLeftViewport_Params.prototype.initDefaults_ = function() {
    this.elements = null;
  };
  AnchorElementMetricsHost_ReportAnchorElementsLeftViewport_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AnchorElementMetricsHost_ReportAnchorElementsLeftViewport_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AnchorElementMetricsHost_ReportAnchorElementsLeftViewport_Params.elements
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(AnchorElementLeftViewport), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AnchorElementMetricsHost_ReportAnchorElementsLeftViewport_Params.encodedSize = codec.kStructHeaderSize + 8;

  AnchorElementMetricsHost_ReportAnchorElementsLeftViewport_Params.decode = function(decoder) {
    var packed;
    var val = new AnchorElementMetricsHost_ReportAnchorElementsLeftViewport_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.elements =
        decoder.decodeArrayPointer(new codec.PointerTo(AnchorElementLeftViewport));
    return val;
  };

  AnchorElementMetricsHost_ReportAnchorElementsLeftViewport_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AnchorElementMetricsHost_ReportAnchorElementsLeftViewport_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(AnchorElementLeftViewport), val.elements);
  };
  function AnchorElementMetricsHost_ReportAnchorElementsPositionUpdate_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AnchorElementMetricsHost_ReportAnchorElementsPositionUpdate_Params.prototype.initDefaults_ = function() {
    this.elements = null;
  };
  AnchorElementMetricsHost_ReportAnchorElementsPositionUpdate_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AnchorElementMetricsHost_ReportAnchorElementsPositionUpdate_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AnchorElementMetricsHost_ReportAnchorElementsPositionUpdate_Params.elements
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(AnchorElementPositionUpdate), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AnchorElementMetricsHost_ReportAnchorElementsPositionUpdate_Params.encodedSize = codec.kStructHeaderSize + 8;

  AnchorElementMetricsHost_ReportAnchorElementsPositionUpdate_Params.decode = function(decoder) {
    var packed;
    var val = new AnchorElementMetricsHost_ReportAnchorElementsPositionUpdate_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.elements =
        decoder.decodeArrayPointer(new codec.PointerTo(AnchorElementPositionUpdate));
    return val;
  };

  AnchorElementMetricsHost_ReportAnchorElementsPositionUpdate_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AnchorElementMetricsHost_ReportAnchorElementsPositionUpdate_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(AnchorElementPositionUpdate), val.elements);
  };
  function AnchorElementMetricsHost_ReportAnchorElementPointerOver_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AnchorElementMetricsHost_ReportAnchorElementPointerOver_Params.prototype.initDefaults_ = function() {
    this.pointerOverEvent = null;
  };
  AnchorElementMetricsHost_ReportAnchorElementPointerOver_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AnchorElementMetricsHost_ReportAnchorElementPointerOver_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AnchorElementMetricsHost_ReportAnchorElementPointerOver_Params.pointerOverEvent
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, AnchorElementPointerOver, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AnchorElementMetricsHost_ReportAnchorElementPointerOver_Params.encodedSize = codec.kStructHeaderSize + 8;

  AnchorElementMetricsHost_ReportAnchorElementPointerOver_Params.decode = function(decoder) {
    var packed;
    var val = new AnchorElementMetricsHost_ReportAnchorElementPointerOver_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.pointerOverEvent =
        decoder.decodeStructPointer(AnchorElementPointerOver);
    return val;
  };

  AnchorElementMetricsHost_ReportAnchorElementPointerOver_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AnchorElementMetricsHost_ReportAnchorElementPointerOver_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(AnchorElementPointerOver, val.pointerOverEvent);
  };
  function AnchorElementMetricsHost_ReportAnchorElementPointerOut_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AnchorElementMetricsHost_ReportAnchorElementPointerOut_Params.prototype.initDefaults_ = function() {
    this.hoverEvent = null;
  };
  AnchorElementMetricsHost_ReportAnchorElementPointerOut_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AnchorElementMetricsHost_ReportAnchorElementPointerOut_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AnchorElementMetricsHost_ReportAnchorElementPointerOut_Params.hoverEvent
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, AnchorElementPointerOut, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AnchorElementMetricsHost_ReportAnchorElementPointerOut_Params.encodedSize = codec.kStructHeaderSize + 8;

  AnchorElementMetricsHost_ReportAnchorElementPointerOut_Params.decode = function(decoder) {
    var packed;
    var val = new AnchorElementMetricsHost_ReportAnchorElementPointerOut_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.hoverEvent =
        decoder.decodeStructPointer(AnchorElementPointerOut);
    return val;
  };

  AnchorElementMetricsHost_ReportAnchorElementPointerOut_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AnchorElementMetricsHost_ReportAnchorElementPointerOut_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(AnchorElementPointerOut, val.hoverEvent);
  };
  function AnchorElementMetricsHost_ReportAnchorElementPointerDown_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AnchorElementMetricsHost_ReportAnchorElementPointerDown_Params.prototype.initDefaults_ = function() {
    this.pointerDownEvent = null;
  };
  AnchorElementMetricsHost_ReportAnchorElementPointerDown_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AnchorElementMetricsHost_ReportAnchorElementPointerDown_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AnchorElementMetricsHost_ReportAnchorElementPointerDown_Params.pointerDownEvent
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, AnchorElementPointerDown, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AnchorElementMetricsHost_ReportAnchorElementPointerDown_Params.encodedSize = codec.kStructHeaderSize + 8;

  AnchorElementMetricsHost_ReportAnchorElementPointerDown_Params.decode = function(decoder) {
    var packed;
    var val = new AnchorElementMetricsHost_ReportAnchorElementPointerDown_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.pointerDownEvent =
        decoder.decodeStructPointer(AnchorElementPointerDown);
    return val;
  };

  AnchorElementMetricsHost_ReportAnchorElementPointerDown_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AnchorElementMetricsHost_ReportAnchorElementPointerDown_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(AnchorElementPointerDown, val.pointerDownEvent);
  };
  function AnchorElementMetricsHost_ReportAnchorElementPointerDataOnHoverTimerFired_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AnchorElementMetricsHost_ReportAnchorElementPointerDataOnHoverTimerFired_Params.prototype.initDefaults_ = function() {
    this.pointerData = null;
  };
  AnchorElementMetricsHost_ReportAnchorElementPointerDataOnHoverTimerFired_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AnchorElementMetricsHost_ReportAnchorElementPointerDataOnHoverTimerFired_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AnchorElementMetricsHost_ReportAnchorElementPointerDataOnHoverTimerFired_Params.pointerData
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, AnchorElementPointerDataOnHoverTimerFired, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AnchorElementMetricsHost_ReportAnchorElementPointerDataOnHoverTimerFired_Params.encodedSize = codec.kStructHeaderSize + 8;

  AnchorElementMetricsHost_ReportAnchorElementPointerDataOnHoverTimerFired_Params.decode = function(decoder) {
    var packed;
    var val = new AnchorElementMetricsHost_ReportAnchorElementPointerDataOnHoverTimerFired_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.pointerData =
        decoder.decodeStructPointer(AnchorElementPointerDataOnHoverTimerFired);
    return val;
  };

  AnchorElementMetricsHost_ReportAnchorElementPointerDataOnHoverTimerFired_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AnchorElementMetricsHost_ReportAnchorElementPointerDataOnHoverTimerFired_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(AnchorElementPointerDataOnHoverTimerFired, val.pointerData);
  };
  function AnchorElementMetricsHost_ProcessPointerEventUsingMLModel_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AnchorElementMetricsHost_ProcessPointerEventUsingMLModel_Params.prototype.initDefaults_ = function() {
    this.pointerEvent = null;
  };
  AnchorElementMetricsHost_ProcessPointerEventUsingMLModel_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AnchorElementMetricsHost_ProcessPointerEventUsingMLModel_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AnchorElementMetricsHost_ProcessPointerEventUsingMLModel_Params.pointerEvent
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, AnchorElementPointerEventForMLModel, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AnchorElementMetricsHost_ProcessPointerEventUsingMLModel_Params.encodedSize = codec.kStructHeaderSize + 8;

  AnchorElementMetricsHost_ProcessPointerEventUsingMLModel_Params.decode = function(decoder) {
    var packed;
    var val = new AnchorElementMetricsHost_ProcessPointerEventUsingMLModel_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.pointerEvent =
        decoder.decodeStructPointer(AnchorElementPointerEventForMLModel);
    return val;
  };

  AnchorElementMetricsHost_ProcessPointerEventUsingMLModel_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AnchorElementMetricsHost_ProcessPointerEventUsingMLModel_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(AnchorElementPointerEventForMLModel, val.pointerEvent);
  };
  function AnchorElementMetricsHost_ShouldSkipUpdateDelays_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AnchorElementMetricsHost_ShouldSkipUpdateDelays_Params.prototype.initDefaults_ = function() {
  };
  AnchorElementMetricsHost_ShouldSkipUpdateDelays_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AnchorElementMetricsHost_ShouldSkipUpdateDelays_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AnchorElementMetricsHost_ShouldSkipUpdateDelays_Params.encodedSize = codec.kStructHeaderSize + 0;

  AnchorElementMetricsHost_ShouldSkipUpdateDelays_Params.decode = function(decoder) {
    var packed;
    var val = new AnchorElementMetricsHost_ShouldSkipUpdateDelays_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  AnchorElementMetricsHost_ShouldSkipUpdateDelays_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AnchorElementMetricsHost_ShouldSkipUpdateDelays_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function AnchorElementMetricsHost_ShouldSkipUpdateDelays_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AnchorElementMetricsHost_ShouldSkipUpdateDelays_ResponseParams.prototype.initDefaults_ = function() {
    this.shouldSkipForTesting = false;
  };
  AnchorElementMetricsHost_ShouldSkipUpdateDelays_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AnchorElementMetricsHost_ShouldSkipUpdateDelays_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  AnchorElementMetricsHost_ShouldSkipUpdateDelays_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  AnchorElementMetricsHost_ShouldSkipUpdateDelays_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new AnchorElementMetricsHost_ShouldSkipUpdateDelays_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.shouldSkipForTesting = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  AnchorElementMetricsHost_ShouldSkipUpdateDelays_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AnchorElementMetricsHost_ShouldSkipUpdateDelays_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.shouldSkipForTesting & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kAnchorElementMetricsHost_ReportAnchorElementClick_Name = 0;
  var kAnchorElementMetricsHost_ReportNewAnchorElements_Name = 1;
  var kAnchorElementMetricsHost_ReportAnchorElementsEnteredViewport_Name = 2;
  var kAnchorElementMetricsHost_ReportAnchorElementsLeftViewport_Name = 3;
  var kAnchorElementMetricsHost_ReportAnchorElementsPositionUpdate_Name = 4;
  var kAnchorElementMetricsHost_ReportAnchorElementPointerOver_Name = 5;
  var kAnchorElementMetricsHost_ReportAnchorElementPointerOut_Name = 6;
  var kAnchorElementMetricsHost_ReportAnchorElementPointerDown_Name = 7;
  var kAnchorElementMetricsHost_ReportAnchorElementPointerDataOnHoverTimerFired_Name = 8;
  var kAnchorElementMetricsHost_ProcessPointerEventUsingMLModel_Name = 9;
  var kAnchorElementMetricsHost_ShouldSkipUpdateDelays_Name = 10;

  function AnchorElementMetricsHostPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(AnchorElementMetricsHost,
                                                   handleOrPtrInfo);
  }

  function AnchorElementMetricsHostAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        AnchorElementMetricsHost, associatedInterfacePtrInfo);
  }

  AnchorElementMetricsHostAssociatedPtr.prototype =
      Object.create(AnchorElementMetricsHostPtr.prototype);
  AnchorElementMetricsHostAssociatedPtr.prototype.constructor =
      AnchorElementMetricsHostAssociatedPtr;

  function AnchorElementMetricsHostProxy(receiver) {
    this.receiver_ = receiver;
  }
  AnchorElementMetricsHostPtr.prototype.reportAnchorElementClick = function() {
    return AnchorElementMetricsHostProxy.prototype.reportAnchorElementClick
        .apply(this.ptr.getProxy(), arguments);
  };

  AnchorElementMetricsHostProxy.prototype.reportAnchorElementClick = function(clicked) {
    var params_ = new AnchorElementMetricsHost_ReportAnchorElementClick_Params();
    params_.clicked = clicked;
    var builder = new codec.MessageV0Builder(
        kAnchorElementMetricsHost_ReportAnchorElementClick_Name,
        codec.align(AnchorElementMetricsHost_ReportAnchorElementClick_Params.encodedSize));
    builder.encodeStruct(AnchorElementMetricsHost_ReportAnchorElementClick_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AnchorElementMetricsHostPtr.prototype.reportNewAnchorElements = function() {
    return AnchorElementMetricsHostProxy.prototype.reportNewAnchorElements
        .apply(this.ptr.getProxy(), arguments);
  };

  AnchorElementMetricsHostProxy.prototype.reportNewAnchorElements = function(metrics, removedElements) {
    var params_ = new AnchorElementMetricsHost_ReportNewAnchorElements_Params();
    params_.metrics = metrics;
    params_.removedElements = removedElements;
    var builder = new codec.MessageV0Builder(
        kAnchorElementMetricsHost_ReportNewAnchorElements_Name,
        codec.align(AnchorElementMetricsHost_ReportNewAnchorElements_Params.encodedSize));
    builder.encodeStruct(AnchorElementMetricsHost_ReportNewAnchorElements_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AnchorElementMetricsHostPtr.prototype.reportAnchorElementsEnteredViewport = function() {
    return AnchorElementMetricsHostProxy.prototype.reportAnchorElementsEnteredViewport
        .apply(this.ptr.getProxy(), arguments);
  };

  AnchorElementMetricsHostProxy.prototype.reportAnchorElementsEnteredViewport = function(elements) {
    var params_ = new AnchorElementMetricsHost_ReportAnchorElementsEnteredViewport_Params();
    params_.elements = elements;
    var builder = new codec.MessageV0Builder(
        kAnchorElementMetricsHost_ReportAnchorElementsEnteredViewport_Name,
        codec.align(AnchorElementMetricsHost_ReportAnchorElementsEnteredViewport_Params.encodedSize));
    builder.encodeStruct(AnchorElementMetricsHost_ReportAnchorElementsEnteredViewport_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AnchorElementMetricsHostPtr.prototype.reportAnchorElementsLeftViewport = function() {
    return AnchorElementMetricsHostProxy.prototype.reportAnchorElementsLeftViewport
        .apply(this.ptr.getProxy(), arguments);
  };

  AnchorElementMetricsHostProxy.prototype.reportAnchorElementsLeftViewport = function(elements) {
    var params_ = new AnchorElementMetricsHost_ReportAnchorElementsLeftViewport_Params();
    params_.elements = elements;
    var builder = new codec.MessageV0Builder(
        kAnchorElementMetricsHost_ReportAnchorElementsLeftViewport_Name,
        codec.align(AnchorElementMetricsHost_ReportAnchorElementsLeftViewport_Params.encodedSize));
    builder.encodeStruct(AnchorElementMetricsHost_ReportAnchorElementsLeftViewport_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AnchorElementMetricsHostPtr.prototype.reportAnchorElementsPositionUpdate = function() {
    return AnchorElementMetricsHostProxy.prototype.reportAnchorElementsPositionUpdate
        .apply(this.ptr.getProxy(), arguments);
  };

  AnchorElementMetricsHostProxy.prototype.reportAnchorElementsPositionUpdate = function(elements) {
    var params_ = new AnchorElementMetricsHost_ReportAnchorElementsPositionUpdate_Params();
    params_.elements = elements;
    var builder = new codec.MessageV0Builder(
        kAnchorElementMetricsHost_ReportAnchorElementsPositionUpdate_Name,
        codec.align(AnchorElementMetricsHost_ReportAnchorElementsPositionUpdate_Params.encodedSize));
    builder.encodeStruct(AnchorElementMetricsHost_ReportAnchorElementsPositionUpdate_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AnchorElementMetricsHostPtr.prototype.reportAnchorElementPointerOver = function() {
    return AnchorElementMetricsHostProxy.prototype.reportAnchorElementPointerOver
        .apply(this.ptr.getProxy(), arguments);
  };

  AnchorElementMetricsHostProxy.prototype.reportAnchorElementPointerOver = function(pointerOverEvent) {
    var params_ = new AnchorElementMetricsHost_ReportAnchorElementPointerOver_Params();
    params_.pointerOverEvent = pointerOverEvent;
    var builder = new codec.MessageV0Builder(
        kAnchorElementMetricsHost_ReportAnchorElementPointerOver_Name,
        codec.align(AnchorElementMetricsHost_ReportAnchorElementPointerOver_Params.encodedSize));
    builder.encodeStruct(AnchorElementMetricsHost_ReportAnchorElementPointerOver_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AnchorElementMetricsHostPtr.prototype.reportAnchorElementPointerOut = function() {
    return AnchorElementMetricsHostProxy.prototype.reportAnchorElementPointerOut
        .apply(this.ptr.getProxy(), arguments);
  };

  AnchorElementMetricsHostProxy.prototype.reportAnchorElementPointerOut = function(hoverEvent) {
    var params_ = new AnchorElementMetricsHost_ReportAnchorElementPointerOut_Params();
    params_.hoverEvent = hoverEvent;
    var builder = new codec.MessageV0Builder(
        kAnchorElementMetricsHost_ReportAnchorElementPointerOut_Name,
        codec.align(AnchorElementMetricsHost_ReportAnchorElementPointerOut_Params.encodedSize));
    builder.encodeStruct(AnchorElementMetricsHost_ReportAnchorElementPointerOut_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AnchorElementMetricsHostPtr.prototype.reportAnchorElementPointerDown = function() {
    return AnchorElementMetricsHostProxy.prototype.reportAnchorElementPointerDown
        .apply(this.ptr.getProxy(), arguments);
  };

  AnchorElementMetricsHostProxy.prototype.reportAnchorElementPointerDown = function(pointerDownEvent) {
    var params_ = new AnchorElementMetricsHost_ReportAnchorElementPointerDown_Params();
    params_.pointerDownEvent = pointerDownEvent;
    var builder = new codec.MessageV0Builder(
        kAnchorElementMetricsHost_ReportAnchorElementPointerDown_Name,
        codec.align(AnchorElementMetricsHost_ReportAnchorElementPointerDown_Params.encodedSize));
    builder.encodeStruct(AnchorElementMetricsHost_ReportAnchorElementPointerDown_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AnchorElementMetricsHostPtr.prototype.reportAnchorElementPointerDataOnHoverTimerFired = function() {
    return AnchorElementMetricsHostProxy.prototype.reportAnchorElementPointerDataOnHoverTimerFired
        .apply(this.ptr.getProxy(), arguments);
  };

  AnchorElementMetricsHostProxy.prototype.reportAnchorElementPointerDataOnHoverTimerFired = function(pointerData) {
    var params_ = new AnchorElementMetricsHost_ReportAnchorElementPointerDataOnHoverTimerFired_Params();
    params_.pointerData = pointerData;
    var builder = new codec.MessageV0Builder(
        kAnchorElementMetricsHost_ReportAnchorElementPointerDataOnHoverTimerFired_Name,
        codec.align(AnchorElementMetricsHost_ReportAnchorElementPointerDataOnHoverTimerFired_Params.encodedSize));
    builder.encodeStruct(AnchorElementMetricsHost_ReportAnchorElementPointerDataOnHoverTimerFired_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AnchorElementMetricsHostPtr.prototype.processPointerEventUsingMLModel = function() {
    return AnchorElementMetricsHostProxy.prototype.processPointerEventUsingMLModel
        .apply(this.ptr.getProxy(), arguments);
  };

  AnchorElementMetricsHostProxy.prototype.processPointerEventUsingMLModel = function(pointerEvent) {
    var params_ = new AnchorElementMetricsHost_ProcessPointerEventUsingMLModel_Params();
    params_.pointerEvent = pointerEvent;
    var builder = new codec.MessageV0Builder(
        kAnchorElementMetricsHost_ProcessPointerEventUsingMLModel_Name,
        codec.align(AnchorElementMetricsHost_ProcessPointerEventUsingMLModel_Params.encodedSize));
    builder.encodeStruct(AnchorElementMetricsHost_ProcessPointerEventUsingMLModel_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AnchorElementMetricsHostPtr.prototype.shouldSkipUpdateDelays = function() {
    return AnchorElementMetricsHostProxy.prototype.shouldSkipUpdateDelays
        .apply(this.ptr.getProxy(), arguments);
  };

  AnchorElementMetricsHostProxy.prototype.shouldSkipUpdateDelays = function() {
    var params_ = new AnchorElementMetricsHost_ShouldSkipUpdateDelays_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kAnchorElementMetricsHost_ShouldSkipUpdateDelays_Name,
          codec.align(AnchorElementMetricsHost_ShouldSkipUpdateDelays_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(AnchorElementMetricsHost_ShouldSkipUpdateDelays_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(AnchorElementMetricsHost_ShouldSkipUpdateDelays_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function AnchorElementMetricsHostStub(delegate) {
    this.delegate_ = delegate;
  }
  AnchorElementMetricsHostStub.prototype.reportAnchorElementClick = function(clicked) {
    return this.delegate_ && this.delegate_.reportAnchorElementClick && this.delegate_.reportAnchorElementClick(clicked);
  }
  AnchorElementMetricsHostStub.prototype.reportNewAnchorElements = function(metrics, removedElements) {
    return this.delegate_ && this.delegate_.reportNewAnchorElements && this.delegate_.reportNewAnchorElements(metrics, removedElements);
  }
  AnchorElementMetricsHostStub.prototype.reportAnchorElementsEnteredViewport = function(elements) {
    return this.delegate_ && this.delegate_.reportAnchorElementsEnteredViewport && this.delegate_.reportAnchorElementsEnteredViewport(elements);
  }
  AnchorElementMetricsHostStub.prototype.reportAnchorElementsLeftViewport = function(elements) {
    return this.delegate_ && this.delegate_.reportAnchorElementsLeftViewport && this.delegate_.reportAnchorElementsLeftViewport(elements);
  }
  AnchorElementMetricsHostStub.prototype.reportAnchorElementsPositionUpdate = function(elements) {
    return this.delegate_ && this.delegate_.reportAnchorElementsPositionUpdate && this.delegate_.reportAnchorElementsPositionUpdate(elements);
  }
  AnchorElementMetricsHostStub.prototype.reportAnchorElementPointerOver = function(pointerOverEvent) {
    return this.delegate_ && this.delegate_.reportAnchorElementPointerOver && this.delegate_.reportAnchorElementPointerOver(pointerOverEvent);
  }
  AnchorElementMetricsHostStub.prototype.reportAnchorElementPointerOut = function(hoverEvent) {
    return this.delegate_ && this.delegate_.reportAnchorElementPointerOut && this.delegate_.reportAnchorElementPointerOut(hoverEvent);
  }
  AnchorElementMetricsHostStub.prototype.reportAnchorElementPointerDown = function(pointerDownEvent) {
    return this.delegate_ && this.delegate_.reportAnchorElementPointerDown && this.delegate_.reportAnchorElementPointerDown(pointerDownEvent);
  }
  AnchorElementMetricsHostStub.prototype.reportAnchorElementPointerDataOnHoverTimerFired = function(pointerData) {
    return this.delegate_ && this.delegate_.reportAnchorElementPointerDataOnHoverTimerFired && this.delegate_.reportAnchorElementPointerDataOnHoverTimerFired(pointerData);
  }
  AnchorElementMetricsHostStub.prototype.processPointerEventUsingMLModel = function(pointerEvent) {
    return this.delegate_ && this.delegate_.processPointerEventUsingMLModel && this.delegate_.processPointerEventUsingMLModel(pointerEvent);
  }
  AnchorElementMetricsHostStub.prototype.shouldSkipUpdateDelays = function() {
    return this.delegate_ && this.delegate_.shouldSkipUpdateDelays && this.delegate_.shouldSkipUpdateDelays();
  }

  AnchorElementMetricsHostStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kAnchorElementMetricsHost_ReportAnchorElementClick_Name:
      var params = reader.decodeStruct(AnchorElementMetricsHost_ReportAnchorElementClick_Params);
      this.reportAnchorElementClick(params.clicked);
      return true;
    case kAnchorElementMetricsHost_ReportNewAnchorElements_Name:
      var params = reader.decodeStruct(AnchorElementMetricsHost_ReportNewAnchorElements_Params);
      this.reportNewAnchorElements(params.metrics, params.removedElements);
      return true;
    case kAnchorElementMetricsHost_ReportAnchorElementsEnteredViewport_Name:
      var params = reader.decodeStruct(AnchorElementMetricsHost_ReportAnchorElementsEnteredViewport_Params);
      this.reportAnchorElementsEnteredViewport(params.elements);
      return true;
    case kAnchorElementMetricsHost_ReportAnchorElementsLeftViewport_Name:
      var params = reader.decodeStruct(AnchorElementMetricsHost_ReportAnchorElementsLeftViewport_Params);
      this.reportAnchorElementsLeftViewport(params.elements);
      return true;
    case kAnchorElementMetricsHost_ReportAnchorElementsPositionUpdate_Name:
      var params = reader.decodeStruct(AnchorElementMetricsHost_ReportAnchorElementsPositionUpdate_Params);
      this.reportAnchorElementsPositionUpdate(params.elements);
      return true;
    case kAnchorElementMetricsHost_ReportAnchorElementPointerOver_Name:
      var params = reader.decodeStruct(AnchorElementMetricsHost_ReportAnchorElementPointerOver_Params);
      this.reportAnchorElementPointerOver(params.pointerOverEvent);
      return true;
    case kAnchorElementMetricsHost_ReportAnchorElementPointerOut_Name:
      var params = reader.decodeStruct(AnchorElementMetricsHost_ReportAnchorElementPointerOut_Params);
      this.reportAnchorElementPointerOut(params.hoverEvent);
      return true;
    case kAnchorElementMetricsHost_ReportAnchorElementPointerDown_Name:
      var params = reader.decodeStruct(AnchorElementMetricsHost_ReportAnchorElementPointerDown_Params);
      this.reportAnchorElementPointerDown(params.pointerDownEvent);
      return true;
    case kAnchorElementMetricsHost_ReportAnchorElementPointerDataOnHoverTimerFired_Name:
      var params = reader.decodeStruct(AnchorElementMetricsHost_ReportAnchorElementPointerDataOnHoverTimerFired_Params);
      this.reportAnchorElementPointerDataOnHoverTimerFired(params.pointerData);
      return true;
    case kAnchorElementMetricsHost_ProcessPointerEventUsingMLModel_Name:
      var params = reader.decodeStruct(AnchorElementMetricsHost_ProcessPointerEventUsingMLModel_Params);
      this.processPointerEventUsingMLModel(params.pointerEvent);
      return true;
    default:
      return false;
    }
  };

  AnchorElementMetricsHostStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kAnchorElementMetricsHost_ShouldSkipUpdateDelays_Name:
      var params = reader.decodeStruct(AnchorElementMetricsHost_ShouldSkipUpdateDelays_Params);
      this.shouldSkipUpdateDelays().then(function(response) {
        var responseParams =
            new AnchorElementMetricsHost_ShouldSkipUpdateDelays_ResponseParams();
        responseParams.shouldSkipForTesting = response.shouldSkipForTesting;
        var builder = new codec.MessageV1Builder(
            kAnchorElementMetricsHost_ShouldSkipUpdateDelays_Name,
            codec.align(AnchorElementMetricsHost_ShouldSkipUpdateDelays_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(AnchorElementMetricsHost_ShouldSkipUpdateDelays_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateAnchorElementMetricsHostRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kAnchorElementMetricsHost_ReportAnchorElementClick_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AnchorElementMetricsHost_ReportAnchorElementClick_Params;
      break;
      case kAnchorElementMetricsHost_ReportNewAnchorElements_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AnchorElementMetricsHost_ReportNewAnchorElements_Params;
      break;
      case kAnchorElementMetricsHost_ReportAnchorElementsEnteredViewport_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AnchorElementMetricsHost_ReportAnchorElementsEnteredViewport_Params;
      break;
      case kAnchorElementMetricsHost_ReportAnchorElementsLeftViewport_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AnchorElementMetricsHost_ReportAnchorElementsLeftViewport_Params;
      break;
      case kAnchorElementMetricsHost_ReportAnchorElementsPositionUpdate_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AnchorElementMetricsHost_ReportAnchorElementsPositionUpdate_Params;
      break;
      case kAnchorElementMetricsHost_ReportAnchorElementPointerOver_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AnchorElementMetricsHost_ReportAnchorElementPointerOver_Params;
      break;
      case kAnchorElementMetricsHost_ReportAnchorElementPointerOut_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AnchorElementMetricsHost_ReportAnchorElementPointerOut_Params;
      break;
      case kAnchorElementMetricsHost_ReportAnchorElementPointerDown_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AnchorElementMetricsHost_ReportAnchorElementPointerDown_Params;
      break;
      case kAnchorElementMetricsHost_ReportAnchorElementPointerDataOnHoverTimerFired_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AnchorElementMetricsHost_ReportAnchorElementPointerDataOnHoverTimerFired_Params;
      break;
      case kAnchorElementMetricsHost_ProcessPointerEventUsingMLModel_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AnchorElementMetricsHost_ProcessPointerEventUsingMLModel_Params;
      break;
      case kAnchorElementMetricsHost_ShouldSkipUpdateDelays_Name:
        if (message.expectsResponse())
          paramsClass = AnchorElementMetricsHost_ShouldSkipUpdateDelays_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateAnchorElementMetricsHostResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kAnchorElementMetricsHost_ShouldSkipUpdateDelays_Name:
        if (message.isResponse())
          paramsClass = AnchorElementMetricsHost_ShouldSkipUpdateDelays_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var AnchorElementMetricsHost = {
    name: 'blink.mojom.AnchorElementMetricsHost',
    kVersion: 0,
    ptrClass: AnchorElementMetricsHostPtr,
    proxyClass: AnchorElementMetricsHostProxy,
    stubClass: AnchorElementMetricsHostStub,
    validateRequest: validateAnchorElementMetricsHostRequest,
    validateResponse: validateAnchorElementMetricsHostResponse,
  };
  AnchorElementMetricsHostStub.prototype.validator = validateAnchorElementMetricsHostRequest;
  AnchorElementMetricsHostProxy.prototype.validator = validateAnchorElementMetricsHostResponse;
  exports.AnchorElementUserInteractionEventForMLModelType = AnchorElementUserInteractionEventForMLModelType;
  exports.AnchorElementMetrics = AnchorElementMetrics;
  exports.AnchorElementClick = AnchorElementClick;
  exports.AnchorElementPointerDataOnHoverTimerFired = AnchorElementPointerDataOnHoverTimerFired;
  exports.AnchorElementEnteredViewport = AnchorElementEnteredViewport;
  exports.AnchorElementLeftViewport = AnchorElementLeftViewport;
  exports.AnchorElementPointerOver = AnchorElementPointerOver;
  exports.AnchorElementPointerOut = AnchorElementPointerOut;
  exports.AnchorElementPointerEventForMLModel = AnchorElementPointerEventForMLModel;
  exports.AnchorElementPointerDown = AnchorElementPointerDown;
  exports.AnchorElementPositionUpdate = AnchorElementPositionUpdate;
  exports.AnchorElementMetricsHost = AnchorElementMetricsHost;
  exports.AnchorElementMetricsHostPtr = AnchorElementMetricsHostPtr;
  exports.AnchorElementMetricsHostAssociatedPtr = AnchorElementMetricsHostAssociatedPtr;
})();