// third_party/blink/public/mojom/link_to_text/link_to_text.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/link_to_text/link_to_text.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/link_to_text/link_to_text.mojom-params-data.h"
#include "third_party/blink/public/mojom/link_to_text/link_to_text.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/link_to_text/link_to_text.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/link_to_text/link_to_text.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
// The declaration includes the definition on other builds.

TextFragmentReceiver::IPCStableHashFunction TextFragmentReceiver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::TextFragmentReceiver>(message.name())) {
    case messages::TextFragmentReceiver::kCancel: {
      return &TextFragmentReceiver::Cancel_Sym::IPCStableHash;
    }
    case messages::TextFragmentReceiver::kRequestSelector: {
      return &TextFragmentReceiver::RequestSelector_Sym::IPCStableHash;
    }
    case messages::TextFragmentReceiver::kRemoveFragments: {
      return &TextFragmentReceiver::RemoveFragments_Sym::IPCStableHash;
    }
    case messages::TextFragmentReceiver::kExtractTextFragmentsMatches: {
      return &TextFragmentReceiver::ExtractTextFragmentsMatches_Sym::IPCStableHash;
    }
    case messages::TextFragmentReceiver::kGetExistingSelectors: {
      return &TextFragmentReceiver::GetExistingSelectors_Sym::IPCStableHash;
    }
    case messages::TextFragmentReceiver::kExtractFirstFragmentRect: {
      return &TextFragmentReceiver::ExtractFirstFragmentRect_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* TextFragmentReceiver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::TextFragmentReceiver>(message.name())) {
      case messages::TextFragmentReceiver::kCancel:
            return "Receive blink::mojom::TextFragmentReceiver::Cancel";
      case messages::TextFragmentReceiver::kRequestSelector:
            return "Receive blink::mojom::TextFragmentReceiver::RequestSelector";
      case messages::TextFragmentReceiver::kRemoveFragments:
            return "Receive blink::mojom::TextFragmentReceiver::RemoveFragments";
      case messages::TextFragmentReceiver::kExtractTextFragmentsMatches:
            return "Receive blink::mojom::TextFragmentReceiver::ExtractTextFragmentsMatches";
      case messages::TextFragmentReceiver::kGetExistingSelectors:
            return "Receive blink::mojom::TextFragmentReceiver::GetExistingSelectors";
      case messages::TextFragmentReceiver::kExtractFirstFragmentRect:
            return "Receive blink::mojom::TextFragmentReceiver::ExtractFirstFragmentRect";
    }
  } else {
    switch (static_cast<messages::TextFragmentReceiver>(message.name())) {
      case messages::TextFragmentReceiver::kCancel:
            return "Receive reply blink::mojom::TextFragmentReceiver::Cancel";
      case messages::TextFragmentReceiver::kRequestSelector:
            return "Receive reply blink::mojom::TextFragmentReceiver::RequestSelector";
      case messages::TextFragmentReceiver::kRemoveFragments:
            return "Receive reply blink::mojom::TextFragmentReceiver::RemoveFragments";
      case messages::TextFragmentReceiver::kExtractTextFragmentsMatches:
            return "Receive reply blink::mojom::TextFragmentReceiver::ExtractTextFragmentsMatches";
      case messages::TextFragmentReceiver::kGetExistingSelectors:
            return "Receive reply blink::mojom::TextFragmentReceiver::GetExistingSelectors";
      case messages::TextFragmentReceiver::kExtractFirstFragmentRect:
            return "Receive reply blink::mojom::TextFragmentReceiver::ExtractFirstFragmentRect";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t TextFragmentReceiver::Cancel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfd9f7096;  // IPCStableHash for blink::mojom::TextFragmentReceiver::Cancel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TextFragmentReceiver::RequestSelector_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdbefcf6b;  // IPCStableHash for blink::mojom::TextFragmentReceiver::RequestSelector
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TextFragmentReceiver::RemoveFragments_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0b6fb828;  // IPCStableHash for blink::mojom::TextFragmentReceiver::RemoveFragments
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TextFragmentReceiver::ExtractTextFragmentsMatches_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x29866d5e;  // IPCStableHash for blink::mojom::TextFragmentReceiver::ExtractTextFragmentsMatches
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TextFragmentReceiver::GetExistingSelectors_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7f0d8185;  // IPCStableHash for blink::mojom::TextFragmentReceiver::GetExistingSelectors
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TextFragmentReceiver::ExtractFirstFragmentRect_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xeb654b5a;  // IPCStableHash for blink::mojom::TextFragmentReceiver::ExtractFirstFragmentRect
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class TextFragmentReceiver_RequestSelector_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TextFragmentReceiver_RequestSelector_ForwardToCallback(
      TextFragmentReceiver::RequestSelectorCallback callback
      ) : callback_(std::move(callback)) {
  }

  TextFragmentReceiver_RequestSelector_ForwardToCallback(const TextFragmentReceiver_RequestSelector_ForwardToCallback&) = delete;
  TextFragmentReceiver_RequestSelector_ForwardToCallback& operator=(const TextFragmentReceiver_RequestSelector_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  TextFragmentReceiver::RequestSelectorCallback callback_;
};

class TextFragmentReceiver_ExtractTextFragmentsMatches_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TextFragmentReceiver_ExtractTextFragmentsMatches_ForwardToCallback(
      TextFragmentReceiver::ExtractTextFragmentsMatchesCallback callback
      ) : callback_(std::move(callback)) {
  }

  TextFragmentReceiver_ExtractTextFragmentsMatches_ForwardToCallback(const TextFragmentReceiver_ExtractTextFragmentsMatches_ForwardToCallback&) = delete;
  TextFragmentReceiver_ExtractTextFragmentsMatches_ForwardToCallback& operator=(const TextFragmentReceiver_ExtractTextFragmentsMatches_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  TextFragmentReceiver::ExtractTextFragmentsMatchesCallback callback_;
};

class TextFragmentReceiver_GetExistingSelectors_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TextFragmentReceiver_GetExistingSelectors_ForwardToCallback(
      TextFragmentReceiver::GetExistingSelectorsCallback callback
      ) : callback_(std::move(callback)) {
  }

  TextFragmentReceiver_GetExistingSelectors_ForwardToCallback(const TextFragmentReceiver_GetExistingSelectors_ForwardToCallback&) = delete;
  TextFragmentReceiver_GetExistingSelectors_ForwardToCallback& operator=(const TextFragmentReceiver_GetExistingSelectors_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  TextFragmentReceiver::GetExistingSelectorsCallback callback_;
};

class TextFragmentReceiver_ExtractFirstFragmentRect_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TextFragmentReceiver_ExtractFirstFragmentRect_ForwardToCallback(
      TextFragmentReceiver::ExtractFirstFragmentRectCallback callback
      ) : callback_(std::move(callback)) {
  }

  TextFragmentReceiver_ExtractFirstFragmentRect_ForwardToCallback(const TextFragmentReceiver_ExtractFirstFragmentRect_ForwardToCallback&) = delete;
  TextFragmentReceiver_ExtractFirstFragmentRect_ForwardToCallback& operator=(const TextFragmentReceiver_ExtractFirstFragmentRect_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  TextFragmentReceiver::ExtractFirstFragmentRectCallback callback_;
};

TextFragmentReceiverProxy::TextFragmentReceiverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void TextFragmentReceiverProxy::Cancel(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::TextFragmentReceiver::Cancel");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextFragmentReceiver::kCancel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::TextFragmentReceiver_Cancel_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextFragmentReceiver::Name_);
  message.set_method_name("Cancel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void TextFragmentReceiverProxy::RequestSelector(
    RequestSelectorCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::TextFragmentReceiver::RequestSelector");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextFragmentReceiver::kRequestSelector), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::TextFragmentReceiver_RequestSelector_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextFragmentReceiver::Name_);
  message.set_method_name("RequestSelector");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TextFragmentReceiver_RequestSelector_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void TextFragmentReceiverProxy::RemoveFragments(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::TextFragmentReceiver::RemoveFragments");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextFragmentReceiver::kRemoveFragments), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::TextFragmentReceiver_RemoveFragments_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextFragmentReceiver::Name_);
  message.set_method_name("RemoveFragments");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void TextFragmentReceiverProxy::ExtractTextFragmentsMatches(
    ExtractTextFragmentsMatchesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::TextFragmentReceiver::ExtractTextFragmentsMatches");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextFragmentReceiver::kExtractTextFragmentsMatches), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::TextFragmentReceiver_ExtractTextFragmentsMatches_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextFragmentReceiver::Name_);
  message.set_method_name("ExtractTextFragmentsMatches");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TextFragmentReceiver_ExtractTextFragmentsMatches_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void TextFragmentReceiverProxy::GetExistingSelectors(
    GetExistingSelectorsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::TextFragmentReceiver::GetExistingSelectors");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextFragmentReceiver::kGetExistingSelectors), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::TextFragmentReceiver_GetExistingSelectors_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextFragmentReceiver::Name_);
  message.set_method_name("GetExistingSelectors");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TextFragmentReceiver_GetExistingSelectors_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void TextFragmentReceiverProxy::ExtractFirstFragmentRect(
    ExtractFirstFragmentRectCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::TextFragmentReceiver::ExtractFirstFragmentRect");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextFragmentReceiver::kExtractFirstFragmentRect), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::TextFragmentReceiver_ExtractFirstFragmentRect_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextFragmentReceiver::Name_);
  message.set_method_name("ExtractFirstFragmentRect");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TextFragmentReceiver_ExtractFirstFragmentRect_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class TextFragmentReceiver_RequestSelector_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static TextFragmentReceiver::RequestSelectorCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<TextFragmentReceiver_RequestSelector_ProxyToResponder> proxy(
        new TextFragmentReceiver_RequestSelector_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&TextFragmentReceiver_RequestSelector_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~TextFragmentReceiver_RequestSelector_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  TextFragmentReceiver_RequestSelector_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "TextFragmentReceiver::RequestSelectorCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::blink::String& in_selector, ::shared_highlighting::LinkGenerationError in_error, ::shared_highlighting::LinkGenerationReadyStatus in_ready_status);
};

bool TextFragmentReceiver_RequestSelector_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::TextFragmentReceiver_RequestSelector_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TextFragmentReceiver_RequestSelector_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for TextFragmentReceiver.1
  bool success = true;
  ::blink::String p_selector{};
  ::shared_highlighting::LinkGenerationError p_error{};
  ::shared_highlighting::LinkGenerationReadyStatus p_ready_status{};
  TextFragmentReceiver_RequestSelector_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadSelector(&p_selector))
    success = false;
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadReadyStatus(&p_ready_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TextFragmentReceiver::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_selector), 
std::move(p_error), 
std::move(p_ready_status));
  }
  return true;
}

void TextFragmentReceiver_RequestSelector_ProxyToResponder::Run(
    const ::blink::String& in_selector, ::shared_highlighting::LinkGenerationError in_error, ::shared_highlighting::LinkGenerationReadyStatus in_ready_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::TextFragmentReceiver::RequestSelector", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("selector"), in_selector,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::shared_highlighting::LinkGenerationError>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ready_status"), in_ready_status,
                        "<value of type ::shared_highlighting::LinkGenerationReadyStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextFragmentReceiver::kRequestSelector), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::TextFragmentReceiver_RequestSelector_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->selector)::BaseType> selector_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_selector,
    selector_fragment);

  params->selector.Set(
      selector_fragment.is_null() ? nullptr : selector_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->selector.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null selector in ");

  
  mojo::internal::Serialize<::blink::mojom::LinkGenerationError>(
    in_error,
    &params->error);

  
  mojo::internal::Serialize<::blink::mojom::LinkGenerationReadyStatus>(
    in_ready_status,
    &params->ready_status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextFragmentReceiver::Name_);
  message.set_method_name("RequestSelector");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class TextFragmentReceiver_ExtractTextFragmentsMatches_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static TextFragmentReceiver::ExtractTextFragmentsMatchesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<TextFragmentReceiver_ExtractTextFragmentsMatches_ProxyToResponder> proxy(
        new TextFragmentReceiver_ExtractTextFragmentsMatches_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&TextFragmentReceiver_ExtractTextFragmentsMatches_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~TextFragmentReceiver_ExtractTextFragmentsMatches_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  TextFragmentReceiver_ExtractTextFragmentsMatches_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "TextFragmentReceiver::ExtractTextFragmentsMatchesCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::blink::Vector<::blink::String>& in_text);
};

bool TextFragmentReceiver_ExtractTextFragmentsMatches_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::TextFragmentReceiver_ExtractTextFragmentsMatches_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TextFragmentReceiver_ExtractTextFragmentsMatches_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for TextFragmentReceiver.3
  bool success = true;
  ::blink::Vector<::blink::String> p_text{};
  TextFragmentReceiver_ExtractTextFragmentsMatches_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadText(&p_text))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TextFragmentReceiver::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_text));
  }
  return true;
}

void TextFragmentReceiver_ExtractTextFragmentsMatches_ProxyToResponder::Run(
    const ::blink::Vector<::blink::String>& in_text) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::TextFragmentReceiver::ExtractTextFragmentsMatches", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text"), in_text,
                        "<value of type const ::blink::Vector<::blink::String>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextFragmentReceiver::kExtractTextFragmentsMatches), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::TextFragmentReceiver_ExtractTextFragmentsMatches_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->text)::BaseType>
      text_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& text_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_text,
    text_fragment,
    &text_validate_params);

  params->text.Set(
      text_fragment.is_null() ? nullptr : text_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->text.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null text in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextFragmentReceiver::Name_);
  message.set_method_name("ExtractTextFragmentsMatches");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class TextFragmentReceiver_GetExistingSelectors_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static TextFragmentReceiver::GetExistingSelectorsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<TextFragmentReceiver_GetExistingSelectors_ProxyToResponder> proxy(
        new TextFragmentReceiver_GetExistingSelectors_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&TextFragmentReceiver_GetExistingSelectors_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~TextFragmentReceiver_GetExistingSelectors_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  TextFragmentReceiver_GetExistingSelectors_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "TextFragmentReceiver::GetExistingSelectorsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::blink::Vector<::blink::String>& in_selectors);
};

bool TextFragmentReceiver_GetExistingSelectors_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::TextFragmentReceiver_GetExistingSelectors_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TextFragmentReceiver_GetExistingSelectors_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for TextFragmentReceiver.4
  bool success = true;
  ::blink::Vector<::blink::String> p_selectors{};
  TextFragmentReceiver_GetExistingSelectors_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadSelectors(&p_selectors))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TextFragmentReceiver::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_selectors));
  }
  return true;
}

void TextFragmentReceiver_GetExistingSelectors_ProxyToResponder::Run(
    const ::blink::Vector<::blink::String>& in_selectors) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::TextFragmentReceiver::GetExistingSelectors", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("selectors"), in_selectors,
                        "<value of type const ::blink::Vector<::blink::String>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextFragmentReceiver::kGetExistingSelectors), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::TextFragmentReceiver_GetExistingSelectors_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->selectors)::BaseType>
      selectors_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& selectors_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_selectors,
    selectors_fragment,
    &selectors_validate_params);

  params->selectors.Set(
      selectors_fragment.is_null() ? nullptr : selectors_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->selectors.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null selectors in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextFragmentReceiver::Name_);
  message.set_method_name("GetExistingSelectors");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class TextFragmentReceiver_ExtractFirstFragmentRect_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static TextFragmentReceiver::ExtractFirstFragmentRectCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<TextFragmentReceiver_ExtractFirstFragmentRect_ProxyToResponder> proxy(
        new TextFragmentReceiver_ExtractFirstFragmentRect_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&TextFragmentReceiver_ExtractFirstFragmentRect_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~TextFragmentReceiver_ExtractFirstFragmentRect_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  TextFragmentReceiver_ExtractFirstFragmentRect_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "TextFragmentReceiver::ExtractFirstFragmentRectCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::gfx::Rect& in_bounds);
};

bool TextFragmentReceiver_ExtractFirstFragmentRect_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::TextFragmentReceiver_ExtractFirstFragmentRect_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TextFragmentReceiver_ExtractFirstFragmentRect_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for TextFragmentReceiver.5
  bool success = true;
  ::gfx::Rect p_bounds{};
  TextFragmentReceiver_ExtractFirstFragmentRect_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadBounds(&p_bounds))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TextFragmentReceiver::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_bounds));
  }
  return true;
}

void TextFragmentReceiver_ExtractFirstFragmentRect_ProxyToResponder::Run(
    const ::gfx::Rect& in_bounds) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::TextFragmentReceiver::ExtractFirstFragmentRect", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bounds"), in_bounds,
                        "<value of type const ::gfx::Rect&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextFragmentReceiver::kExtractFirstFragmentRect), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::TextFragmentReceiver_ExtractFirstFragmentRect_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bounds)::BaseType> bounds_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_bounds,
    bounds_fragment);

  params->bounds.Set(
      bounds_fragment.is_null() ? nullptr : bounds_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->bounds.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null bounds in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextFragmentReceiver::Name_);
  message.set_method_name("ExtractFirstFragmentRect");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool TextFragmentReceiverStubDispatch::Accept(
    TextFragmentReceiver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::TextFragmentReceiver>(message->header()->name)) {
    case messages::TextFragmentReceiver::kCancel: {
      DCHECK(message->is_serialized());
      internal::TextFragmentReceiver_Cancel_Params_Data* params =
          reinterpret_cast<internal::TextFragmentReceiver_Cancel_Params_Data*>(
              message->mutable_payload());
      

      // Validation for TextFragmentReceiver.0
      bool success = true;
      TextFragmentReceiver_Cancel_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextFragmentReceiver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Cancel(        );
      return true;
    }
    case messages::TextFragmentReceiver::kRequestSelector: {
      break;
    }
    case messages::TextFragmentReceiver::kRemoveFragments: {
      DCHECK(message->is_serialized());
      internal::TextFragmentReceiver_RemoveFragments_Params_Data* params =
          reinterpret_cast<internal::TextFragmentReceiver_RemoveFragments_Params_Data*>(
              message->mutable_payload());
      

      // Validation for TextFragmentReceiver.2
      bool success = true;
      TextFragmentReceiver_RemoveFragments_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextFragmentReceiver::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveFragments(        );
      return true;
    }
    case messages::TextFragmentReceiver::kExtractTextFragmentsMatches: {
      break;
    }
    case messages::TextFragmentReceiver::kGetExistingSelectors: {
      break;
    }
    case messages::TextFragmentReceiver::kExtractFirstFragmentRect: {
      break;
    }
  }
  return false;
}

// static
bool TextFragmentReceiverStubDispatch::AcceptWithResponder(
    TextFragmentReceiver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::TextFragmentReceiver>(message->header()->name)) {
    case messages::TextFragmentReceiver::kCancel: {
      break;
    }
    case messages::TextFragmentReceiver::kRequestSelector: {
      internal::TextFragmentReceiver_RequestSelector_Params_Data* params =
          reinterpret_cast<
              internal::TextFragmentReceiver_RequestSelector_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for TextFragmentReceiver.1
      bool success = true;
      TextFragmentReceiver_RequestSelector_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextFragmentReceiver::Name_, 1, false);
        return false;
      }
      auto callback =
          TextFragmentReceiver_RequestSelector_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestSelector(std::move(callback));
      return true;
    }
    case messages::TextFragmentReceiver::kRemoveFragments: {
      break;
    }
    case messages::TextFragmentReceiver::kExtractTextFragmentsMatches: {
      internal::TextFragmentReceiver_ExtractTextFragmentsMatches_Params_Data* params =
          reinterpret_cast<
              internal::TextFragmentReceiver_ExtractTextFragmentsMatches_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for TextFragmentReceiver.3
      bool success = true;
      TextFragmentReceiver_ExtractTextFragmentsMatches_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextFragmentReceiver::Name_, 3, false);
        return false;
      }
      auto callback =
          TextFragmentReceiver_ExtractTextFragmentsMatches_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExtractTextFragmentsMatches(std::move(callback));
      return true;
    }
    case messages::TextFragmentReceiver::kGetExistingSelectors: {
      internal::TextFragmentReceiver_GetExistingSelectors_Params_Data* params =
          reinterpret_cast<
              internal::TextFragmentReceiver_GetExistingSelectors_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for TextFragmentReceiver.4
      bool success = true;
      TextFragmentReceiver_GetExistingSelectors_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextFragmentReceiver::Name_, 4, false);
        return false;
      }
      auto callback =
          TextFragmentReceiver_GetExistingSelectors_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetExistingSelectors(std::move(callback));
      return true;
    }
    case messages::TextFragmentReceiver::kExtractFirstFragmentRect: {
      internal::TextFragmentReceiver_ExtractFirstFragmentRect_Params_Data* params =
          reinterpret_cast<
              internal::TextFragmentReceiver_ExtractFirstFragmentRect_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for TextFragmentReceiver.5
      bool success = true;
      TextFragmentReceiver_ExtractFirstFragmentRect_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextFragmentReceiver::Name_, 5, false);
        return false;
      }
      auto callback =
          TextFragmentReceiver_ExtractFirstFragmentRect_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExtractFirstFragmentRect(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kTextFragmentReceiverValidationInfo[] = {
    { &internal::TextFragmentReceiver_Cancel_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::TextFragmentReceiver_RequestSelector_Params_Data::Validate,
     &internal::TextFragmentReceiver_RequestSelector_ResponseParams_Data::Validate},
    { &internal::TextFragmentReceiver_RemoveFragments_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::TextFragmentReceiver_ExtractTextFragmentsMatches_Params_Data::Validate,
     &internal::TextFragmentReceiver_ExtractTextFragmentsMatches_ResponseParams_Data::Validate},
    { &internal::TextFragmentReceiver_GetExistingSelectors_Params_Data::Validate,
     &internal::TextFragmentReceiver_GetExistingSelectors_ResponseParams_Data::Validate},
    { &internal::TextFragmentReceiver_ExtractFirstFragmentRect_Params_Data::Validate,
     &internal::TextFragmentReceiver_ExtractFirstFragmentRect_ResponseParams_Data::Validate},
};

bool TextFragmentReceiverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::TextFragmentReceiver::Name_,
    kTextFragmentReceiverValidationInfo);
}

bool TextFragmentReceiverResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::TextFragmentReceiver::Name_,
    kTextFragmentReceiverValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void TextFragmentReceiverInterceptorForTesting::Cancel() {
  GetForwardingInterface()->Cancel();
}
void TextFragmentReceiverInterceptorForTesting::RequestSelector(RequestSelectorCallback callback) {
  GetForwardingInterface()->RequestSelector(std::move(callback));
}
void TextFragmentReceiverInterceptorForTesting::RemoveFragments() {
  GetForwardingInterface()->RemoveFragments();
}
void TextFragmentReceiverInterceptorForTesting::ExtractTextFragmentsMatches(ExtractTextFragmentsMatchesCallback callback) {
  GetForwardingInterface()->ExtractTextFragmentsMatches(std::move(callback));
}
void TextFragmentReceiverInterceptorForTesting::GetExistingSelectors(GetExistingSelectorsCallback callback) {
  GetForwardingInterface()->GetExistingSelectors(std::move(callback));
}
void TextFragmentReceiverInterceptorForTesting::ExtractFirstFragmentRect(ExtractFirstFragmentRectCallback callback) {
  GetForwardingInterface()->ExtractFirstFragmentRect(std::move(callback));
}
TextFragmentReceiverAsyncWaiter::TextFragmentReceiverAsyncWaiter(
    TextFragmentReceiver* proxy) : proxy_(proxy) {}

TextFragmentReceiverAsyncWaiter::~TextFragmentReceiverAsyncWaiter() = default;


void TextFragmentReceiverAsyncWaiter::RequestSelector(
    ::blink::String* out_selector, ::shared_highlighting::LinkGenerationError* out_error, ::shared_highlighting::LinkGenerationReadyStatus* out_ready_status) {
  base::RunLoop loop;
  proxy_->RequestSelector(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::String* out_selector
,
             ::shared_highlighting::LinkGenerationError* out_error
,
             ::shared_highlighting::LinkGenerationReadyStatus* out_ready_status
,
             const ::blink::String& selector,
             ::shared_highlighting::LinkGenerationError error,
             ::shared_highlighting::LinkGenerationReadyStatus ready_status) {*out_selector = std::move(selector);*out_error = std::move(error);*out_ready_status = std::move(ready_status);
            loop->Quit();
          },
          &loop,
          out_selector,
          out_error,
          out_ready_status));
  loop.Run();
}



void TextFragmentReceiverAsyncWaiter::ExtractTextFragmentsMatches(
    ::blink::Vector<::blink::String>* out_text) {
  base::RunLoop loop;
  proxy_->ExtractTextFragmentsMatches(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::Vector<::blink::String>* out_text
,
             const ::blink::Vector<::blink::String>& text) {*out_text = std::move(text);
            loop->Quit();
          },
          &loop,
          out_text));
  loop.Run();
}

::blink::Vector<::blink::String> TextFragmentReceiverAsyncWaiter::ExtractTextFragmentsMatches(
    ) {
  ::blink::Vector<::blink::String> async_wait_result;
  ExtractTextFragmentsMatches(&async_wait_result);
  return async_wait_result;
}

void TextFragmentReceiverAsyncWaiter::GetExistingSelectors(
    ::blink::Vector<::blink::String>* out_selectors) {
  base::RunLoop loop;
  proxy_->GetExistingSelectors(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::Vector<::blink::String>* out_selectors
,
             const ::blink::Vector<::blink::String>& selectors) {*out_selectors = std::move(selectors);
            loop->Quit();
          },
          &loop,
          out_selectors));
  loop.Run();
}

::blink::Vector<::blink::String> TextFragmentReceiverAsyncWaiter::GetExistingSelectors(
    ) {
  ::blink::Vector<::blink::String> async_wait_result;
  GetExistingSelectors(&async_wait_result);
  return async_wait_result;
}

void TextFragmentReceiverAsyncWaiter::ExtractFirstFragmentRect(
    ::gfx::Rect* out_bounds) {
  base::RunLoop loop;
  proxy_->ExtractFirstFragmentRect(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::gfx::Rect* out_bounds
,
             const ::gfx::Rect& bounds) {*out_bounds = std::move(bounds);
            loop->Quit();
          },
          &loop,
          out_bounds));
  loop.Run();
}

::gfx::Rect TextFragmentReceiverAsyncWaiter::ExtractFirstFragmentRect(
    ) {
  ::gfx::Rect async_wait_result;
  ExtractFirstFragmentRect(&async_wait_result);
  return async_wait_result;
}






}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif