// third_party/blink/public/mojom/lcp_critical_path_predictor/lcp_critical_path_predictor.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/lcp_critical_path_predictor/lcp_critical_path_predictor.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/lcp_critical_path_predictor/lcp_critical_path_predictor.mojom-params-data.h"
#include "third_party/blink/public/mojom/lcp_critical_path_predictor/lcp_critical_path_predictor.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/lcp_critical_path_predictor/lcp_critical_path_predictor.mojom-import-headers.h"
#include "third_party/blink/public/mojom/lcp_critical_path_predictor/lcp_critical_path_predictor.mojom-test-utils.h"


namespace blink::mojom {
LcpElement::LcpElement()
    : locator(),
      is_image(),
      predicted_index() {}

LcpElement::LcpElement(
    const std::optional<std::string>& locator_in,
    bool is_image_in,
    std::optional<uint32_t> predicted_index_in)
    : locator(std::move(locator_in)),
      is_image(std::move(is_image_in)),
      predicted_index(std::move(predicted_index_in)) {}

LcpElement::~LcpElement() = default;

void LcpElement::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "locator"), this->locator,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_image"), this->is_image,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "predicted_index"), this->predicted_index,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<uint32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool LcpElement::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
LCPCriticalPathPredictorNavigationTimeHint::LCPCriticalPathPredictorNavigationTimeHint()
    : lcp_element_locators(),
      lcp_element_locators_all(),
      lcp_influencer_scripts(),
      fetched_fonts(),
      preconnect_origins(),
      unused_preloads(),
      for_testing() {}

LCPCriticalPathPredictorNavigationTimeHint::LCPCriticalPathPredictorNavigationTimeHint(
    std::vector<std::string> lcp_element_locators_in,
    std::vector<std::string> lcp_element_locators_all_in,
    std::vector<::GURL> lcp_influencer_scripts_in,
    std::vector<::GURL> fetched_fonts_in,
    std::vector<::url::Origin> preconnect_origins_in,
    std::vector<::GURL> unused_preloads_in,
    bool for_testing_in)
    : lcp_element_locators(std::move(lcp_element_locators_in)),
      lcp_element_locators_all(std::move(lcp_element_locators_all_in)),
      lcp_influencer_scripts(std::move(lcp_influencer_scripts_in)),
      fetched_fonts(std::move(fetched_fonts_in)),
      preconnect_origins(std::move(preconnect_origins_in)),
      unused_preloads(std::move(unused_preloads_in)),
      for_testing(std::move(for_testing_in)) {}

LCPCriticalPathPredictorNavigationTimeHint::~LCPCriticalPathPredictorNavigationTimeHint() = default;

void LCPCriticalPathPredictorNavigationTimeHint::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "lcp_element_locators"), this->lcp_element_locators,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "lcp_element_locators_all"), this->lcp_element_locators_all,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "lcp_influencer_scripts"), this->lcp_influencer_scripts,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fetched_fonts"), this->fetched_fonts,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "preconnect_origins"), this->preconnect_origins,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::url::Origin>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "unused_preloads"), this->unused_preloads,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "for_testing"), this->for_testing,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool LCPCriticalPathPredictorNavigationTimeHint::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

LCPCriticalPathPredictorHost::IPCStableHashFunction LCPCriticalPathPredictorHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::LCPCriticalPathPredictorHost>(message.name())) {
    case messages::LCPCriticalPathPredictorHost::kOnLcpUpdated: {
      return &LCPCriticalPathPredictorHost::OnLcpUpdated_Sym::IPCStableHash;
    }
    case messages::LCPCriticalPathPredictorHost::kOnLcpTimingPredictedForTesting: {
      return &LCPCriticalPathPredictorHost::OnLcpTimingPredictedForTesting_Sym::IPCStableHash;
    }
    case messages::LCPCriticalPathPredictorHost::kSetLcpInfluencerScriptUrls: {
      return &LCPCriticalPathPredictorHost::SetLcpInfluencerScriptUrls_Sym::IPCStableHash;
    }
    case messages::LCPCriticalPathPredictorHost::kAddPreconnectOrigin: {
      return &LCPCriticalPathPredictorHost::AddPreconnectOrigin_Sym::IPCStableHash;
    }
    case messages::LCPCriticalPathPredictorHost::kNotifyFetchedFont: {
      return &LCPCriticalPathPredictorHost::NotifyFetchedFont_Sym::IPCStableHash;
    }
    case messages::LCPCriticalPathPredictorHost::kNotifyFetchedSubresource: {
      return &LCPCriticalPathPredictorHost::NotifyFetchedSubresource_Sym::IPCStableHash;
    }
    case messages::LCPCriticalPathPredictorHost::kSetUnusedPreloads: {
      return &LCPCriticalPathPredictorHost::SetUnusedPreloads_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* LCPCriticalPathPredictorHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::LCPCriticalPathPredictorHost>(message.name())) {
      case messages::LCPCriticalPathPredictorHost::kOnLcpUpdated:
            return "Receive blink::mojom::LCPCriticalPathPredictorHost::OnLcpUpdated";
      case messages::LCPCriticalPathPredictorHost::kOnLcpTimingPredictedForTesting:
            return "Receive blink::mojom::LCPCriticalPathPredictorHost::OnLcpTimingPredictedForTesting";
      case messages::LCPCriticalPathPredictorHost::kSetLcpInfluencerScriptUrls:
            return "Receive blink::mojom::LCPCriticalPathPredictorHost::SetLcpInfluencerScriptUrls";
      case messages::LCPCriticalPathPredictorHost::kAddPreconnectOrigin:
            return "Receive blink::mojom::LCPCriticalPathPredictorHost::AddPreconnectOrigin";
      case messages::LCPCriticalPathPredictorHost::kNotifyFetchedFont:
            return "Receive blink::mojom::LCPCriticalPathPredictorHost::NotifyFetchedFont";
      case messages::LCPCriticalPathPredictorHost::kNotifyFetchedSubresource:
            return "Receive blink::mojom::LCPCriticalPathPredictorHost::NotifyFetchedSubresource";
      case messages::LCPCriticalPathPredictorHost::kSetUnusedPreloads:
            return "Receive blink::mojom::LCPCriticalPathPredictorHost::SetUnusedPreloads";
    }
  } else {
    switch (static_cast<messages::LCPCriticalPathPredictorHost>(message.name())) {
      case messages::LCPCriticalPathPredictorHost::kOnLcpUpdated:
            return "Receive reply blink::mojom::LCPCriticalPathPredictorHost::OnLcpUpdated";
      case messages::LCPCriticalPathPredictorHost::kOnLcpTimingPredictedForTesting:
            return "Receive reply blink::mojom::LCPCriticalPathPredictorHost::OnLcpTimingPredictedForTesting";
      case messages::LCPCriticalPathPredictorHost::kSetLcpInfluencerScriptUrls:
            return "Receive reply blink::mojom::LCPCriticalPathPredictorHost::SetLcpInfluencerScriptUrls";
      case messages::LCPCriticalPathPredictorHost::kAddPreconnectOrigin:
            return "Receive reply blink::mojom::LCPCriticalPathPredictorHost::AddPreconnectOrigin";
      case messages::LCPCriticalPathPredictorHost::kNotifyFetchedFont:
            return "Receive reply blink::mojom::LCPCriticalPathPredictorHost::NotifyFetchedFont";
      case messages::LCPCriticalPathPredictorHost::kNotifyFetchedSubresource:
            return "Receive reply blink::mojom::LCPCriticalPathPredictorHost::NotifyFetchedSubresource";
      case messages::LCPCriticalPathPredictorHost::kSetUnusedPreloads:
            return "Receive reply blink::mojom::LCPCriticalPathPredictorHost::SetUnusedPreloads";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t LCPCriticalPathPredictorHost::OnLcpUpdated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa8144986;  // IPCStableHash for blink::mojom::LCPCriticalPathPredictorHost::OnLcpUpdated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LCPCriticalPathPredictorHost::OnLcpTimingPredictedForTesting_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x13e232e6;  // IPCStableHash for blink::mojom::LCPCriticalPathPredictorHost::OnLcpTimingPredictedForTesting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LCPCriticalPathPredictorHost::SetLcpInfluencerScriptUrls_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9834e1a2;  // IPCStableHash for blink::mojom::LCPCriticalPathPredictorHost::SetLcpInfluencerScriptUrls
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LCPCriticalPathPredictorHost::AddPreconnectOrigin_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb362edac;  // IPCStableHash for blink::mojom::LCPCriticalPathPredictorHost::AddPreconnectOrigin
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LCPCriticalPathPredictorHost::NotifyFetchedFont_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd1c67f2e;  // IPCStableHash for blink::mojom::LCPCriticalPathPredictorHost::NotifyFetchedFont
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LCPCriticalPathPredictorHost::NotifyFetchedSubresource_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe7ff80e4;  // IPCStableHash for blink::mojom::LCPCriticalPathPredictorHost::NotifyFetchedSubresource
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LCPCriticalPathPredictorHost::SetUnusedPreloads_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x266bdaeb;  // IPCStableHash for blink::mojom::LCPCriticalPathPredictorHost::SetUnusedPreloads
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

LCPCriticalPathPredictorHostProxy::LCPCriticalPathPredictorHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void LCPCriticalPathPredictorHostProxy::OnLcpUpdated(
    LcpElementPtr in_lcp_element) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LCPCriticalPathPredictorHost::OnLcpUpdated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("lcp_element"), in_lcp_element,
                        "<value of type LcpElementPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LCPCriticalPathPredictorHost::kOnLcpUpdated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LCPCriticalPathPredictorHost_OnLcpUpdated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->lcp_element)::BaseType> lcp_element_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::LcpElementDataView>(
    in_lcp_element,
    lcp_element_fragment);

  params->lcp_element.Set(
      lcp_element_fragment.is_null() ? nullptr : lcp_element_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->lcp_element.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null lcp_element in LCPCriticalPathPredictorHost.OnLcpUpdated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LCPCriticalPathPredictorHost::Name_);
  message.set_method_name("OnLcpUpdated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LCPCriticalPathPredictorHostProxy::OnLcpTimingPredictedForTesting(
    const std::optional<std::string>& in_element_locator) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LCPCriticalPathPredictorHost::OnLcpTimingPredictedForTesting", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("element_locator"), in_element_locator,
                        "<value of type const std::optional<std::string>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LCPCriticalPathPredictorHost::kOnLcpTimingPredictedForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LCPCriticalPathPredictorHost_OnLcpTimingPredictedForTesting_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->element_locator)::BaseType> element_locator_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ByteStringDataView>(
    in_element_locator,
    element_locator_fragment);

  params->element_locator.Set(
      element_locator_fragment.is_null() ? nullptr : element_locator_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LCPCriticalPathPredictorHost::Name_);
  message.set_method_name("OnLcpTimingPredictedForTesting");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LCPCriticalPathPredictorHostProxy::SetLcpInfluencerScriptUrls(
    const std::vector<::GURL>& in_lcp_influencer_scripts) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LCPCriticalPathPredictorHost::SetLcpInfluencerScriptUrls", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("lcp_influencer_scripts"), in_lcp_influencer_scripts,
                        "<value of type const std::vector<::GURL>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LCPCriticalPathPredictorHost::kSetLcpInfluencerScriptUrls), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LCPCriticalPathPredictorHost_SetLcpInfluencerScriptUrls_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->lcp_influencer_scripts)::BaseType>
      lcp_influencer_scripts_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& lcp_influencer_scripts_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
    in_lcp_influencer_scripts,
    lcp_influencer_scripts_fragment,
    &lcp_influencer_scripts_validate_params);

  params->lcp_influencer_scripts.Set(
      lcp_influencer_scripts_fragment.is_null() ? nullptr : lcp_influencer_scripts_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->lcp_influencer_scripts.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null lcp_influencer_scripts in LCPCriticalPathPredictorHost.SetLcpInfluencerScriptUrls request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LCPCriticalPathPredictorHost::Name_);
  message.set_method_name("SetLcpInfluencerScriptUrls");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LCPCriticalPathPredictorHostProxy::AddPreconnectOrigin(
    const ::url::Origin& in_origin) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LCPCriticalPathPredictorHost::AddPreconnectOrigin", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), in_origin,
                        "<value of type const ::url::Origin&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LCPCriticalPathPredictorHost::kAddPreconnectOrigin), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LCPCriticalPathPredictorHost_AddPreconnectOrigin_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    in_origin,
    origin_fragment);

  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->origin.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null origin in LCPCriticalPathPredictorHost.AddPreconnectOrigin request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LCPCriticalPathPredictorHost::Name_);
  message.set_method_name("AddPreconnectOrigin");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LCPCriticalPathPredictorHostProxy::NotifyFetchedFont(
    const ::GURL& in_font_url, bool in_hit) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LCPCriticalPathPredictorHost::NotifyFetchedFont", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("font_url"), in_font_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("hit"), in_hit,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LCPCriticalPathPredictorHost::kNotifyFetchedFont), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LCPCriticalPathPredictorHost_NotifyFetchedFont_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->font_url)::BaseType> font_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_font_url,
    font_url_fragment);

  params->font_url.Set(
      font_url_fragment.is_null() ? nullptr : font_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->font_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null font_url in LCPCriticalPathPredictorHost.NotifyFetchedFont request");

  params->hit = in_hit;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LCPCriticalPathPredictorHost::Name_);
  message.set_method_name("NotifyFetchedFont");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LCPCriticalPathPredictorHostProxy::NotifyFetchedSubresource(
    const ::GURL& in_subresource_url, ::base::TimeDelta in_subresource_load_start, ::network::mojom::RequestDestination in_request_destination) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LCPCriticalPathPredictorHost::NotifyFetchedSubresource", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subresource_url"), in_subresource_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subresource_load_start"), in_subresource_load_start,
                        "<value of type ::base::TimeDelta>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_destination"), in_request_destination,
                        "<value of type ::network::mojom::RequestDestination>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LCPCriticalPathPredictorHost::kNotifyFetchedSubresource), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LCPCriticalPathPredictorHost_NotifyFetchedSubresource_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->subresource_url)::BaseType> subresource_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_subresource_url,
    subresource_url_fragment);

  params->subresource_url.Set(
      subresource_url_fragment.is_null() ? nullptr : subresource_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->subresource_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null subresource_url in LCPCriticalPathPredictorHost.NotifyFetchedSubresource request");
  mojo::internal::MessageFragment<
      typename decltype(params->subresource_load_start)::BaseType> subresource_load_start_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_subresource_load_start,
    subresource_load_start_fragment);

  params->subresource_load_start.Set(
      subresource_load_start_fragment.is_null() ? nullptr : subresource_load_start_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->subresource_load_start.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null subresource_load_start in LCPCriticalPathPredictorHost.NotifyFetchedSubresource request");

  
  mojo::internal::Serialize<::network::mojom::RequestDestination>(
    in_request_destination,
    &params->request_destination);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LCPCriticalPathPredictorHost::Name_);
  message.set_method_name("NotifyFetchedSubresource");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LCPCriticalPathPredictorHostProxy::SetUnusedPreloads(
    const std::vector<::GURL>& in_unused_preloads) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::LCPCriticalPathPredictorHost::SetUnusedPreloads", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("unused_preloads"), in_unused_preloads,
                        "<value of type const std::vector<::GURL>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LCPCriticalPathPredictorHost::kSetUnusedPreloads), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LCPCriticalPathPredictorHost_SetUnusedPreloads_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->unused_preloads)::BaseType>
      unused_preloads_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& unused_preloads_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
    in_unused_preloads,
    unused_preloads_fragment,
    &unused_preloads_validate_params);

  params->unused_preloads.Set(
      unused_preloads_fragment.is_null() ? nullptr : unused_preloads_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->unused_preloads.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null unused_preloads in LCPCriticalPathPredictorHost.SetUnusedPreloads request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LCPCriticalPathPredictorHost::Name_);
  message.set_method_name("SetUnusedPreloads");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool LCPCriticalPathPredictorHostStubDispatch::Accept(
    LCPCriticalPathPredictorHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::LCPCriticalPathPredictorHost>(message->header()->name)) {
    case messages::LCPCriticalPathPredictorHost::kOnLcpUpdated: {
      DCHECK(message->is_serialized());
      internal::LCPCriticalPathPredictorHost_OnLcpUpdated_Params_Data* params =
          reinterpret_cast<internal::LCPCriticalPathPredictorHost_OnLcpUpdated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LCPCriticalPathPredictorHost.0
      bool success = true;
      LcpElementPtr p_lcp_element{};
      LCPCriticalPathPredictorHost_OnLcpUpdated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLcpElement(&p_lcp_element))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LCPCriticalPathPredictorHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnLcpUpdated(        
        std::move(p_lcp_element));
      return true;
    }
    case messages::LCPCriticalPathPredictorHost::kOnLcpTimingPredictedForTesting: {
      DCHECK(message->is_serialized());
      internal::LCPCriticalPathPredictorHost_OnLcpTimingPredictedForTesting_Params_Data* params =
          reinterpret_cast<internal::LCPCriticalPathPredictorHost_OnLcpTimingPredictedForTesting_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LCPCriticalPathPredictorHost.1
      bool success = true;
      std::optional<std::string> p_element_locator{};
      LCPCriticalPathPredictorHost_OnLcpTimingPredictedForTesting_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadElementLocator(&p_element_locator))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LCPCriticalPathPredictorHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnLcpTimingPredictedForTesting(        
        std::move(p_element_locator));
      return true;
    }
    case messages::LCPCriticalPathPredictorHost::kSetLcpInfluencerScriptUrls: {
      DCHECK(message->is_serialized());
      internal::LCPCriticalPathPredictorHost_SetLcpInfluencerScriptUrls_Params_Data* params =
          reinterpret_cast<internal::LCPCriticalPathPredictorHost_SetLcpInfluencerScriptUrls_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LCPCriticalPathPredictorHost.2
      bool success = true;
      std::vector<::GURL> p_lcp_influencer_scripts{};
      LCPCriticalPathPredictorHost_SetLcpInfluencerScriptUrls_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLcpInfluencerScripts(&p_lcp_influencer_scripts))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LCPCriticalPathPredictorHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetLcpInfluencerScriptUrls(        
        std::move(p_lcp_influencer_scripts));
      return true;
    }
    case messages::LCPCriticalPathPredictorHost::kAddPreconnectOrigin: {
      DCHECK(message->is_serialized());
      internal::LCPCriticalPathPredictorHost_AddPreconnectOrigin_Params_Data* params =
          reinterpret_cast<internal::LCPCriticalPathPredictorHost_AddPreconnectOrigin_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LCPCriticalPathPredictorHost.3
      bool success = true;
      ::url::Origin p_origin{};
      LCPCriticalPathPredictorHost_AddPreconnectOrigin_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LCPCriticalPathPredictorHost::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddPreconnectOrigin(        
        std::move(p_origin));
      return true;
    }
    case messages::LCPCriticalPathPredictorHost::kNotifyFetchedFont: {
      DCHECK(message->is_serialized());
      internal::LCPCriticalPathPredictorHost_NotifyFetchedFont_Params_Data* params =
          reinterpret_cast<internal::LCPCriticalPathPredictorHost_NotifyFetchedFont_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LCPCriticalPathPredictorHost.4
      bool success = true;
      ::GURL p_font_url{};
      bool p_hit{};
      LCPCriticalPathPredictorHost_NotifyFetchedFont_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFontUrl(&p_font_url))
        success = false;
      if (success)
        p_hit = input_data_view.hit();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LCPCriticalPathPredictorHost::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyFetchedFont(        
        std::move(p_font_url), 
        std::move(p_hit));
      return true;
    }
    case messages::LCPCriticalPathPredictorHost::kNotifyFetchedSubresource: {
      DCHECK(message->is_serialized());
      internal::LCPCriticalPathPredictorHost_NotifyFetchedSubresource_Params_Data* params =
          reinterpret_cast<internal::LCPCriticalPathPredictorHost_NotifyFetchedSubresource_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LCPCriticalPathPredictorHost.5
      bool success = true;
      ::GURL p_subresource_url{};
      ::base::TimeDelta p_subresource_load_start{};
      ::network::mojom::RequestDestination p_request_destination{};
      LCPCriticalPathPredictorHost_NotifyFetchedSubresource_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSubresourceUrl(&p_subresource_url))
        success = false;
      if (success && !input_data_view.ReadSubresourceLoadStart(&p_subresource_load_start))
        success = false;
      if (success && !input_data_view.ReadRequestDestination(&p_request_destination))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LCPCriticalPathPredictorHost::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyFetchedSubresource(        
        std::move(p_subresource_url), 
        std::move(p_subresource_load_start), 
        std::move(p_request_destination));
      return true;
    }
    case messages::LCPCriticalPathPredictorHost::kSetUnusedPreloads: {
      DCHECK(message->is_serialized());
      internal::LCPCriticalPathPredictorHost_SetUnusedPreloads_Params_Data* params =
          reinterpret_cast<internal::LCPCriticalPathPredictorHost_SetUnusedPreloads_Params_Data*>(
              message->mutable_payload());
      

      // Validation for LCPCriticalPathPredictorHost.6
      bool success = true;
      std::vector<::GURL> p_unused_preloads{};
      LCPCriticalPathPredictorHost_SetUnusedPreloads_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUnusedPreloads(&p_unused_preloads))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LCPCriticalPathPredictorHost::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetUnusedPreloads(        
        std::move(p_unused_preloads));
      return true;
    }
  }
  return false;
}

// static
bool LCPCriticalPathPredictorHostStubDispatch::AcceptWithResponder(
    LCPCriticalPathPredictorHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::LCPCriticalPathPredictorHost>(message->header()->name)) {
    case messages::LCPCriticalPathPredictorHost::kOnLcpUpdated: {
      break;
    }
    case messages::LCPCriticalPathPredictorHost::kOnLcpTimingPredictedForTesting: {
      break;
    }
    case messages::LCPCriticalPathPredictorHost::kSetLcpInfluencerScriptUrls: {
      break;
    }
    case messages::LCPCriticalPathPredictorHost::kAddPreconnectOrigin: {
      break;
    }
    case messages::LCPCriticalPathPredictorHost::kNotifyFetchedFont: {
      break;
    }
    case messages::LCPCriticalPathPredictorHost::kNotifyFetchedSubresource: {
      break;
    }
    case messages::LCPCriticalPathPredictorHost::kSetUnusedPreloads: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kLCPCriticalPathPredictorHostValidationInfo[] = {
    { &internal::LCPCriticalPathPredictorHost_OnLcpUpdated_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LCPCriticalPathPredictorHost_OnLcpTimingPredictedForTesting_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LCPCriticalPathPredictorHost_SetLcpInfluencerScriptUrls_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LCPCriticalPathPredictorHost_AddPreconnectOrigin_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LCPCriticalPathPredictorHost_NotifyFetchedFont_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LCPCriticalPathPredictorHost_NotifyFetchedSubresource_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::LCPCriticalPathPredictorHost_SetUnusedPreloads_Params_Data::Validate,
     nullptr /* no response */},
};

bool LCPCriticalPathPredictorHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::LCPCriticalPathPredictorHost::Name_,
    kLCPCriticalPathPredictorHostValidationInfo);
}



}  // blink::mojom


namespace mojo {


// static
bool StructTraits<::blink::mojom::LcpElement::DataView, ::blink::mojom::LcpElementPtr>::Read(
    ::blink::mojom::LcpElement::DataView input,
    ::blink::mojom::LcpElementPtr* output) {
  bool success = true;
  ::blink::mojom::LcpElementPtr result(::blink::mojom::LcpElement::New());
  
      if (success && !input.ReadLocator(&result->locator))
        success = false;
      if (success)
        result->is_image = input.is_image();
      if (success) {
        result->predicted_index = input.predicted_index();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::LCPCriticalPathPredictorNavigationTimeHint::DataView, ::blink::mojom::LCPCriticalPathPredictorNavigationTimeHintPtr>::Read(
    ::blink::mojom::LCPCriticalPathPredictorNavigationTimeHint::DataView input,
    ::blink::mojom::LCPCriticalPathPredictorNavigationTimeHintPtr* output) {
  bool success = true;
  ::blink::mojom::LCPCriticalPathPredictorNavigationTimeHintPtr result(::blink::mojom::LCPCriticalPathPredictorNavigationTimeHint::New());
  
      if (success && !input.ReadLcpElementLocators(&result->lcp_element_locators))
        success = false;
      if (success && !input.ReadLcpElementLocatorsAll(&result->lcp_element_locators_all))
        success = false;
      if (success && !input.ReadLcpInfluencerScripts(&result->lcp_influencer_scripts))
        success = false;
      if (success && !input.ReadFetchedFonts(&result->fetched_fonts))
        success = false;
      if (success && !input.ReadPreconnectOrigins(&result->preconnect_origins))
        success = false;
      if (success && !input.ReadUnusedPreloads(&result->unused_preloads))
        success = false;
      if (success)
        result->for_testing = input.for_testing();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void LCPCriticalPathPredictorHostInterceptorForTesting::OnLcpUpdated(LcpElementPtr lcp_element) {
  GetForwardingInterface()->OnLcpUpdated(
    std::move(lcp_element)
    );
}
void LCPCriticalPathPredictorHostInterceptorForTesting::OnLcpTimingPredictedForTesting(const std::optional<std::string>& element_locator) {
  GetForwardingInterface()->OnLcpTimingPredictedForTesting(
    std::move(element_locator)
    );
}
void LCPCriticalPathPredictorHostInterceptorForTesting::SetLcpInfluencerScriptUrls(const std::vector<::GURL>& lcp_influencer_scripts) {
  GetForwardingInterface()->SetLcpInfluencerScriptUrls(
    std::move(lcp_influencer_scripts)
    );
}
void LCPCriticalPathPredictorHostInterceptorForTesting::AddPreconnectOrigin(const ::url::Origin& origin) {
  GetForwardingInterface()->AddPreconnectOrigin(
    std::move(origin)
    );
}
void LCPCriticalPathPredictorHostInterceptorForTesting::NotifyFetchedFont(const ::GURL& font_url, bool hit) {
  GetForwardingInterface()->NotifyFetchedFont(
    std::move(font_url)
    , 
    std::move(hit)
    );
}
void LCPCriticalPathPredictorHostInterceptorForTesting::NotifyFetchedSubresource(const ::GURL& subresource_url, ::base::TimeDelta subresource_load_start, ::network::mojom::RequestDestination request_destination) {
  GetForwardingInterface()->NotifyFetchedSubresource(
    std::move(subresource_url)
    , 
    std::move(subresource_load_start)
    , 
    std::move(request_destination)
    );
}
void LCPCriticalPathPredictorHostInterceptorForTesting::SetUnusedPreloads(const std::vector<::GURL>& unused_preloads) {
  GetForwardingInterface()->SetUnusedPreloads(
    std::move(unused_preloads)
    );
}
LCPCriticalPathPredictorHostAsyncWaiter::LCPCriticalPathPredictorHostAsyncWaiter(
    LCPCriticalPathPredictorHost* proxy) : proxy_(proxy) {}

LCPCriticalPathPredictorHostAsyncWaiter::~LCPCriticalPathPredictorHostAsyncWaiter() = default;







}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif