// third_party/blink/public/mojom/lcp_critical_path_predictor/lcp_critical_path_predictor.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.LCPCriticalPathPredictorHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.LCPCriticalPathPredictorHost.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.LCPCriticalPathPredictorHostInterface }
 */
blink.mojom.LCPCriticalPathPredictorHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.LCPCriticalPathPredictorHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.LCPCriticalPathPredictorHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.LCPCriticalPathPredictorHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.LcpElement } lcpElement
   */

  onLcpUpdated(
      lcpElement) {
    this.proxy.sendMessage(
        0,
        blink.mojom.LCPCriticalPathPredictorHost_OnLcpUpdated_ParamsSpec.$,
        null,
        [
          lcpElement
        ],
        false);
  }

  
  /**
   * @param { ?mojoBase.mojom.ByteString } elementLocator
   */

  onLcpTimingPredictedForTesting(
      elementLocator) {
    this.proxy.sendMessage(
        1,
        blink.mojom.LCPCriticalPathPredictorHost_OnLcpTimingPredictedForTesting_ParamsSpec.$,
        null,
        [
          elementLocator
        ],
        false);
  }

  
  /**
   * @param { !Array<!url.mojom.Url> } lcpInfluencerScripts
   */

  setLcpInfluencerScriptUrls(
      lcpInfluencerScripts) {
    this.proxy.sendMessage(
        2,
        blink.mojom.LCPCriticalPathPredictorHost_SetLcpInfluencerScriptUrls_ParamsSpec.$,
        null,
        [
          lcpInfluencerScripts
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Origin } origin
   */

  addPreconnectOrigin(
      origin) {
    this.proxy.sendMessage(
        3,
        blink.mojom.LCPCriticalPathPredictorHost_AddPreconnectOrigin_ParamsSpec.$,
        null,
        [
          origin
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } fontUrl
   * @param { !boolean } hit
   */

  notifyFetchedFont(
      fontUrl,
      hit) {
    this.proxy.sendMessage(
        4,
        blink.mojom.LCPCriticalPathPredictorHost_NotifyFetchedFont_ParamsSpec.$,
        null,
        [
          fontUrl,
          hit
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } subresourceUrl
   * @param { !mojoBase.mojom.TimeDelta } subresourceLoadStart
   * @param { !network.mojom.RequestDestination } requestDestination
   */

  notifyFetchedSubresource(
      subresourceUrl,
      subresourceLoadStart,
      requestDestination) {
    this.proxy.sendMessage(
        5,
        blink.mojom.LCPCriticalPathPredictorHost_NotifyFetchedSubresource_ParamsSpec.$,
        null,
        [
          subresourceUrl,
          subresourceLoadStart,
          requestDestination
        ],
        false);
  }

  
  /**
   * @param { !Array<!url.mojom.Url> } unusedPreloads
   */

  setUnusedPreloads(
      unusedPreloads) {
    this.proxy.sendMessage(
        6,
        blink.mojom.LCPCriticalPathPredictorHost_SetUnusedPreloads_ParamsSpec.$,
        null,
        [
          unusedPreloads
        ],
        false);
  }
};

/**
 * An object which receives request messages for the LCPCriticalPathPredictorHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.LCPCriticalPathPredictorHostReceiver = class {
  /**
   * @param {!blink.mojom.LCPCriticalPathPredictorHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.LCPCriticalPathPredictorHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.LCPCriticalPathPredictorHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.LCPCriticalPathPredictorHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.LCPCriticalPathPredictorHost_OnLcpUpdated_ParamsSpec.$,
        null,
        impl.onLcpUpdated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.LCPCriticalPathPredictorHost_OnLcpTimingPredictedForTesting_ParamsSpec.$,
        null,
        impl.onLcpTimingPredictedForTesting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.LCPCriticalPathPredictorHost_SetLcpInfluencerScriptUrls_ParamsSpec.$,
        null,
        impl.setLcpInfluencerScriptUrls.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.LCPCriticalPathPredictorHost_AddPreconnectOrigin_ParamsSpec.$,
        null,
        impl.addPreconnectOrigin.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.LCPCriticalPathPredictorHost_NotifyFetchedFont_ParamsSpec.$,
        null,
        impl.notifyFetchedFont.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        blink.mojom.LCPCriticalPathPredictorHost_NotifyFetchedSubresource_ParamsSpec.$,
        null,
        impl.notifyFetchedSubresource.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        blink.mojom.LCPCriticalPathPredictorHost_SetUnusedPreloads_ParamsSpec.$,
        null,
        impl.setUnusedPreloads.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.LCPCriticalPathPredictorHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.LCPCriticalPathPredictorHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.LCPCriticalPathPredictorHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.LCPCriticalPathPredictorHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the LCPCriticalPathPredictorHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.LCPCriticalPathPredictorHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.LCPCriticalPathPredictorHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.LCPCriticalPathPredictorHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onLcpUpdated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.LCPCriticalPathPredictorHost_OnLcpUpdated_ParamsSpec.$,
        null,
        this.onLcpUpdated.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onLcpTimingPredictedForTesting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.LCPCriticalPathPredictorHost_OnLcpTimingPredictedForTesting_ParamsSpec.$,
        null,
        this.onLcpTimingPredictedForTesting.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setLcpInfluencerScriptUrls =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.LCPCriticalPathPredictorHost_SetLcpInfluencerScriptUrls_ParamsSpec.$,
        null,
        this.setLcpInfluencerScriptUrls.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addPreconnectOrigin =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.LCPCriticalPathPredictorHost_AddPreconnectOrigin_ParamsSpec.$,
        null,
        this.addPreconnectOrigin.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.notifyFetchedFont =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.LCPCriticalPathPredictorHost_NotifyFetchedFont_ParamsSpec.$,
        null,
        this.notifyFetchedFont.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.notifyFetchedSubresource =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        blink.mojom.LCPCriticalPathPredictorHost_NotifyFetchedSubresource_ParamsSpec.$,
        null,
        this.notifyFetchedSubresource.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setUnusedPreloads =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        blink.mojom.LCPCriticalPathPredictorHost_SetUnusedPreloads_ParamsSpec.$,
        null,
        this.setUnusedPreloads.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LcpElementSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LCPCriticalPathPredictorNavigationTimeHintSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LCPCriticalPathPredictorHost_OnLcpUpdated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LCPCriticalPathPredictorHost_OnLcpTimingPredictedForTesting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LCPCriticalPathPredictorHost_SetLcpInfluencerScriptUrls_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LCPCriticalPathPredictorHost_AddPreconnectOrigin_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LCPCriticalPathPredictorHost_NotifyFetchedFont_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LCPCriticalPathPredictorHost_NotifyFetchedSubresource_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LCPCriticalPathPredictorHost_SetUnusedPreloads_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.LcpElementSpec.$,
    'LcpElement',
    [
      mojo.internal.StructField(
        'locator', 0,
        0,
        mojoBase.mojom.ByteStringSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isImage', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'predicted_index_$flag', 8,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "predicted_index_$value",
          originalFieldName: "predictedIndex",
        }
      ),
      mojo.internal.StructField(
        'predicted_index_$value', 12,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "predictedIndex",
        }
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.LcpElement = class {
  constructor() {
    /** @export { (mojoBase.mojom.ByteString|undefined) } */
    this.locator;
    /** @export { !boolean } */
    this.isImage;
    /** @export { (number|undefined) } */
    this.predictedIndex;
  }
};



mojo.internal.Struct(
    blink.mojom.LCPCriticalPathPredictorNavigationTimeHintSpec.$,
    'LCPCriticalPathPredictorNavigationTimeHint',
    [
      mojo.internal.StructField(
        'lcpElementLocators', 0,
        0,
        mojo.internal.Array(mojoBase.mojom.ByteStringSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'lcpElementLocatorsAll', 8,
        0,
        mojo.internal.Array(mojoBase.mojom.ByteStringSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'lcpInfluencerScripts', 16,
        0,
        mojo.internal.Array(url.mojom.UrlSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fetchedFonts', 24,
        0,
        mojo.internal.Array(url.mojom.UrlSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'preconnectOrigins', 32,
        0,
        mojo.internal.Array(url.mojom.OriginSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'unusedPreloads', 40,
        0,
        mojo.internal.Array(url.mojom.UrlSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'forTesting', 48,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 64],]);





/** @record */
blink.mojom.LCPCriticalPathPredictorNavigationTimeHint = class {
  constructor() {
    /** @export { !Array<!mojoBase.mojom.ByteString> } */
    this.lcpElementLocators;
    /** @export { !Array<!mojoBase.mojom.ByteString> } */
    this.lcpElementLocatorsAll;
    /** @export { !Array<!url.mojom.Url> } */
    this.lcpInfluencerScripts;
    /** @export { !Array<!url.mojom.Url> } */
    this.fetchedFonts;
    /** @export { !Array<!url.mojom.Origin> } */
    this.preconnectOrigins;
    /** @export { !Array<!url.mojom.Url> } */
    this.unusedPreloads;
    /** @export { !boolean } */
    this.forTesting;
  }
};



mojo.internal.Struct(
    blink.mojom.LCPCriticalPathPredictorHost_OnLcpUpdated_ParamsSpec.$,
    'LCPCriticalPathPredictorHost_OnLcpUpdated_Params',
    [
      mojo.internal.StructField(
        'lcpElement', 0,
        0,
        blink.mojom.LcpElementSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LCPCriticalPathPredictorHost_OnLcpUpdated_Params = class {
  constructor() {
    /** @export { !blink.mojom.LcpElement } */
    this.lcpElement;
  }
};



mojo.internal.Struct(
    blink.mojom.LCPCriticalPathPredictorHost_OnLcpTimingPredictedForTesting_ParamsSpec.$,
    'LCPCriticalPathPredictorHost_OnLcpTimingPredictedForTesting_Params',
    [
      mojo.internal.StructField(
        'elementLocator', 0,
        0,
        mojoBase.mojom.ByteStringSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LCPCriticalPathPredictorHost_OnLcpTimingPredictedForTesting_Params = class {
  constructor() {
    /** @export { (mojoBase.mojom.ByteString|undefined) } */
    this.elementLocator;
  }
};



mojo.internal.Struct(
    blink.mojom.LCPCriticalPathPredictorHost_SetLcpInfluencerScriptUrls_ParamsSpec.$,
    'LCPCriticalPathPredictorHost_SetLcpInfluencerScriptUrls_Params',
    [
      mojo.internal.StructField(
        'lcpInfluencerScripts', 0,
        0,
        mojo.internal.Array(url.mojom.UrlSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LCPCriticalPathPredictorHost_SetLcpInfluencerScriptUrls_Params = class {
  constructor() {
    /** @export { !Array<!url.mojom.Url> } */
    this.lcpInfluencerScripts;
  }
};



mojo.internal.Struct(
    blink.mojom.LCPCriticalPathPredictorHost_AddPreconnectOrigin_ParamsSpec.$,
    'LCPCriticalPathPredictorHost_AddPreconnectOrigin_Params',
    [
      mojo.internal.StructField(
        'origin', 0,
        0,
        url.mojom.OriginSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LCPCriticalPathPredictorHost_AddPreconnectOrigin_Params = class {
  constructor() {
    /** @export { !url.mojom.Origin } */
    this.origin;
  }
};



mojo.internal.Struct(
    blink.mojom.LCPCriticalPathPredictorHost_NotifyFetchedFont_ParamsSpec.$,
    'LCPCriticalPathPredictorHost_NotifyFetchedFont_Params',
    [
      mojo.internal.StructField(
        'fontUrl', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hit', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.LCPCriticalPathPredictorHost_NotifyFetchedFont_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.fontUrl;
    /** @export { !boolean } */
    this.hit;
  }
};



mojo.internal.Struct(
    blink.mojom.LCPCriticalPathPredictorHost_NotifyFetchedSubresource_ParamsSpec.$,
    'LCPCriticalPathPredictorHost_NotifyFetchedSubresource_Params',
    [
      mojo.internal.StructField(
        'subresourceUrl', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'subresourceLoadStart', 8,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requestDestination', 16,
        0,
        network.mojom.RequestDestinationSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.LCPCriticalPathPredictorHost_NotifyFetchedSubresource_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.subresourceUrl;
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.subresourceLoadStart;
    /** @export { !network.mojom.RequestDestination } */
    this.requestDestination;
  }
};



mojo.internal.Struct(
    blink.mojom.LCPCriticalPathPredictorHost_SetUnusedPreloads_ParamsSpec.$,
    'LCPCriticalPathPredictorHost_SetUnusedPreloads_Params',
    [
      mojo.internal.StructField(
        'unusedPreloads', 0,
        0,
        mojo.internal.Array(url.mojom.UrlSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.LCPCriticalPathPredictorHost_SetUnusedPreloads_Params = class {
  constructor() {
    /** @export { !Array<!url.mojom.Url> } */
    this.unusedPreloads;
  }
};

