// third_party/blink/public/mojom/keyboard_lock/keyboard_lock.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');





goog.provide('blink.mojom.KeyboardLockRequestResult');
goog.provide('blink.mojom.KeyboardLockRequestResultSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.KeyboardLockRequestResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.KeyboardLockRequestResult = {
  
  kSuccess: 0,
  kFrameDetachedError: 1,
  kNoValidKeyCodesError: 2,
  kChildFrameError: 3,
  kRequestFailedError: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};

goog.provide('blink.mojom.GetKeyboardLayoutMapStatus');
goog.provide('blink.mojom.GetKeyboardLayoutMapStatusSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.GetKeyboardLayoutMapStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.GetKeyboardLayoutMapStatus = {
  
  kSuccess: 0,
  kFail: 1,
  kDenied: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};



goog.provide('blink.mojom.KeyboardLockService');
goog.provide('blink.mojom.KeyboardLockServiceReceiver');
goog.provide('blink.mojom.KeyboardLockServiceCallbackRouter');
goog.provide('blink.mojom.KeyboardLockServiceInterface');
goog.provide('blink.mojom.KeyboardLockServiceRemote');
goog.provide('blink.mojom.KeyboardLockServicePendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.KeyboardLockServicePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.KeyboardLockService.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.KeyboardLockServiceInterface = class {
  
  /**
   * @param { !Array<!string> } keyCodes
   * @return {!Promise<{
        result: !blink.mojom.KeyboardLockRequestResult,
   *  }>}
   */

  requestKeyboardLock(keyCodes) {}
  
  /**
   */

  cancelKeyboardLock() {}
  
  /**
   * @return {!Promise<{
        result: !blink.mojom.GetKeyboardLayoutMapResult,
   *  }>}
   */

  getKeyboardLayoutMap() {}
};

/**
 * @export
 * @implements { blink.mojom.KeyboardLockServiceInterface }
 */
blink.mojom.KeyboardLockServiceRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.KeyboardLockServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.KeyboardLockServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.KeyboardLockServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!string> } keyCodes
   * @return {!Promise<{
        result: !blink.mojom.KeyboardLockRequestResult,
   *  }>}
   */

  requestKeyboardLock(
      keyCodes) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.KeyboardLockService_RequestKeyboardLock_ParamsSpec.$,
        blink.mojom.KeyboardLockService_RequestKeyboardLock_ResponseParamsSpec.$,
        [
          keyCodes
        ],
        false);
  }

  
  /**
   */

  cancelKeyboardLock() {
    this.proxy.sendMessage(
        1,
        blink.mojom.KeyboardLockService_CancelKeyboardLock_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        result: !blink.mojom.GetKeyboardLayoutMapResult,
   *  }>}
   */

  getKeyboardLayoutMap() {
    return this.proxy.sendMessage(
        2,
        blink.mojom.KeyboardLockService_GetKeyboardLayoutMap_ParamsSpec.$,
        blink.mojom.KeyboardLockService_GetKeyboardLayoutMap_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the KeyboardLockService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.KeyboardLockServiceReceiver = class {
  /**
   * @param {!blink.mojom.KeyboardLockServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.KeyboardLockServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.KeyboardLockServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.KeyboardLockServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.KeyboardLockService_RequestKeyboardLock_ParamsSpec.$,
        blink.mojom.KeyboardLockService_RequestKeyboardLock_ResponseParamsSpec.$,
        impl.requestKeyboardLock.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.KeyboardLockService_CancelKeyboardLock_ParamsSpec.$,
        null,
        impl.cancelKeyboardLock.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.KeyboardLockService_GetKeyboardLayoutMap_ParamsSpec.$,
        blink.mojom.KeyboardLockService_GetKeyboardLayoutMap_ResponseParamsSpec.$,
        impl.getKeyboardLayoutMap.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.KeyboardLockService = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.KeyboardLockService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.KeyboardLockServiceRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.KeyboardLockServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the KeyboardLockService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.KeyboardLockServiceCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.KeyboardLockServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.KeyboardLockServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestKeyboardLock =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.KeyboardLockService_RequestKeyboardLock_ParamsSpec.$,
        blink.mojom.KeyboardLockService_RequestKeyboardLock_ResponseParamsSpec.$,
        this.requestKeyboardLock.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cancelKeyboardLock =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.KeyboardLockService_CancelKeyboardLock_ParamsSpec.$,
        null,
        this.cancelKeyboardLock.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getKeyboardLayoutMap =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.KeyboardLockService_GetKeyboardLayoutMap_ParamsSpec.$,
        blink.mojom.KeyboardLockService_GetKeyboardLayoutMap_ResponseParamsSpec.$,
        this.getKeyboardLayoutMap.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.GetKeyboardLayoutMapResultSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.GetKeyboardLayoutMapResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.KeyboardLockService_RequestKeyboardLock_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.KeyboardLockService_RequestKeyboardLock_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.KeyboardLockService_RequestKeyboardLock_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.KeyboardLockService_RequestKeyboardLock_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.KeyboardLockService_CancelKeyboardLock_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.KeyboardLockService_CancelKeyboardLock_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.KeyboardLockService_GetKeyboardLayoutMap_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.KeyboardLockService_GetKeyboardLayoutMap_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.KeyboardLockService_GetKeyboardLayoutMap_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.KeyboardLockService_GetKeyboardLayoutMap_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.GetKeyboardLayoutMapResultSpec.$,
    'GetKeyboardLayoutMapResult',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink.mojom.GetKeyboardLayoutMapStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'layoutMap', 8,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.GetKeyboardLayoutMapResult');

/** @record */
blink.mojom.GetKeyboardLayoutMapResult = class {
  constructor() {
    /** @export { !blink.mojom.GetKeyboardLayoutMapStatus } */
    this.status;
    /** @export { !Object<!string, !string> } */
    this.layoutMap;
  }
};



mojo.internal.Struct(
    blink.mojom.KeyboardLockService_RequestKeyboardLock_ParamsSpec.$,
    'KeyboardLockService_RequestKeyboardLock_Params',
    [
      mojo.internal.StructField(
        'keyCodes', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.KeyboardLockService_RequestKeyboardLock_Params');

/** @record */
blink.mojom.KeyboardLockService_RequestKeyboardLock_Params = class {
  constructor() {
    /** @export { !Array<!string> } */
    this.keyCodes;
  }
};



mojo.internal.Struct(
    blink.mojom.KeyboardLockService_RequestKeyboardLock_ResponseParamsSpec.$,
    'KeyboardLockService_RequestKeyboardLock_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.KeyboardLockRequestResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.KeyboardLockService_RequestKeyboardLock_ResponseParams');

/** @record */
blink.mojom.KeyboardLockService_RequestKeyboardLock_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.KeyboardLockRequestResult } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.KeyboardLockService_CancelKeyboardLock_ParamsSpec.$,
    'KeyboardLockService_CancelKeyboardLock_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.KeyboardLockService_CancelKeyboardLock_Params');

/** @record */
blink.mojom.KeyboardLockService_CancelKeyboardLock_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.KeyboardLockService_GetKeyboardLayoutMap_ParamsSpec.$,
    'KeyboardLockService_GetKeyboardLayoutMap_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.KeyboardLockService_GetKeyboardLayoutMap_Params');

/** @record */
blink.mojom.KeyboardLockService_GetKeyboardLayoutMap_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.KeyboardLockService_GetKeyboardLayoutMap_ResponseParamsSpec.$,
    'KeyboardLockService_GetKeyboardLayoutMap_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.GetKeyboardLayoutMapResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.KeyboardLockService_GetKeyboardLayoutMap_ResponseParams');

/** @record */
blink.mojom.KeyboardLockService_GetKeyboardLayoutMap_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.GetKeyboardLayoutMapResult } */
    this.result;
  }
};

