// third_party/blink/public/mojom/interest_group/interest_group_types.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/interest_group/interest_group_types.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/interest_group/interest_group_types.mojom-params-data.h"
#include "third_party/blink/public/mojom/interest_group/interest_group_types.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/interest_group/interest_group_types.mojom-import-headers.h"
#include "third_party/blink/public/mojom/interest_group/interest_group_types.mojom-test-utils.h"


namespace blink::mojom {
InterestGroupAd::InterestGroupAd()
    : render_url(),
      size_group(),
      buyer_reporting_id(),
      buyer_and_seller_reporting_id(),
      selectable_buyer_and_seller_reporting_ids(),
      metadata(),
      ad_render_id(),
      allowed_reporting_origins(),
      creative_scanning_metadata() {}

InterestGroupAd::InterestGroupAd(
    const std::string& render_url_in,
    const std::optional<std::string>& size_group_in,
    const std::optional<std::string>& buyer_reporting_id_in,
    const std::optional<std::string>& buyer_and_seller_reporting_id_in,
    std::optional<std::vector<std::string>> selectable_buyer_and_seller_reporting_ids_in,
    const std::optional<std::string>& metadata_in,
    const std::optional<std::string>& ad_render_id_in,
    std::optional<std::vector<::url::Origin>> allowed_reporting_origins_in,
    const std::optional<std::string>& creative_scanning_metadata_in)
    : render_url(std::move(render_url_in)),
      size_group(std::move(size_group_in)),
      buyer_reporting_id(std::move(buyer_reporting_id_in)),
      buyer_and_seller_reporting_id(std::move(buyer_and_seller_reporting_id_in)),
      selectable_buyer_and_seller_reporting_ids(std::move(selectable_buyer_and_seller_reporting_ids_in)),
      metadata(std::move(metadata_in)),
      ad_render_id(std::move(ad_render_id_in)),
      allowed_reporting_origins(std::move(allowed_reporting_origins_in)),
      creative_scanning_metadata(std::move(creative_scanning_metadata_in)) {}

InterestGroupAd::~InterestGroupAd() = default;

void InterestGroupAd::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "render_url"), this->render_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "size_group"), this->size_group,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "buyer_reporting_id"), this->buyer_reporting_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "buyer_and_seller_reporting_id"), this->buyer_and_seller_reporting_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "selectable_buyer_and_seller_reporting_ids"), this->selectable_buyer_and_seller_reporting_ids,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::vector<std::string>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "metadata"), this->metadata,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ad_render_id"), this->ad_render_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allowed_reporting_origins"), this->allowed_reporting_origins,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::vector<::url::Origin>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "creative_scanning_metadata"), this->creative_scanning_metadata,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool InterestGroupAd::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SellerCapabilities::SellerCapabilities()
    : allows_interest_group_counts(false),
      allows_latency_stats(false) {}

SellerCapabilities::SellerCapabilities(
    bool allows_interest_group_counts_in,
    bool allows_latency_stats_in)
    : allows_interest_group_counts(std::move(allows_interest_group_counts_in)),
      allows_latency_stats(std::move(allows_latency_stats_in)) {}

SellerCapabilities::~SellerCapabilities() = default;
size_t SellerCapabilities::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->allows_interest_group_counts);
  seed = mojo::internal::Hash(seed, this->allows_latency_stats);
  return seed;
}

void SellerCapabilities::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allows_interest_group_counts"), this->allows_interest_group_counts,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allows_latency_stats"), this->allows_latency_stats,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SellerCapabilities::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AuctionServerRequestFlags::AuctionServerRequestFlags()
    : omit_ads(false),
      include_full_ads(false),
      omit_user_bidding_signals(false) {}

AuctionServerRequestFlags::AuctionServerRequestFlags(
    bool omit_ads_in,
    bool include_full_ads_in,
    bool omit_user_bidding_signals_in)
    : omit_ads(std::move(omit_ads_in)),
      include_full_ads(std::move(include_full_ads_in)),
      omit_user_bidding_signals(std::move(omit_user_bidding_signals_in)) {}

AuctionServerRequestFlags::~AuctionServerRequestFlags() = default;
size_t AuctionServerRequestFlags::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->omit_ads);
  seed = mojo::internal::Hash(seed, this->include_full_ads);
  seed = mojo::internal::Hash(seed, this->omit_user_bidding_signals);
  return seed;
}

void AuctionServerRequestFlags::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "omit_ads"), this->omit_ads,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "include_full_ads"), this->include_full_ads,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "omit_user_bidding_signals"), this->omit_user_bidding_signals,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AuctionServerRequestFlags::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AdKeywordReplacement::AdKeywordReplacement()
    : match(),
      replacement() {}

AdKeywordReplacement::AdKeywordReplacement(
    const std::string& match_in,
    const std::string& replacement_in)
    : match(std::move(match_in)),
      replacement(std::move(replacement_in)) {}

AdKeywordReplacement::~AdKeywordReplacement() = default;

void AdKeywordReplacement::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "match"), this->match,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "replacement"), this->replacement,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AdKeywordReplacement::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
InterestGroup::InterestGroup()
    : expiry(),
      owner(),
      name(),
      priority(0.0),
      enable_bidding_signals_prioritization(),
      priority_vector(),
      priority_signals_overrides(),
      seller_capabilities(),
      all_sellers_capabilities(),
      execution_mode(InterestGroup_ExecutionMode::kCompatibilityMode),
      trusted_bidding_signals_slot_size_mode(InterestGroup_TrustedBiddingSignalsSlotSizeMode::kNone),
      bidding_url(),
      bidding_wasm_helper_url(),
      update_url(),
      trusted_bidding_signals_url(),
      trusted_bidding_signals_keys(),
      max_trusted_bidding_signals_url_length(0),
      trusted_bidding_signals_coordinator(),
      view_and_click_counts_providers(),
      user_bidding_signals(),
      ads(),
      ad_components(),
      ad_sizes(),
      size_groups(),
      auction_server_request_flags(),
      additional_bid_key(),
      aggregation_coordinator_origin() {}

InterestGroup::InterestGroup(
    ::base::Time expiry_in,
    const ::url::Origin& owner_in,
    const std::string& name_in,
    double priority_in,
    bool enable_bidding_signals_prioritization_in,
    const std::optional<base::flat_map<std::string, double>>& priority_vector_in,
    const std::optional<base::flat_map<std::string, double>>& priority_signals_overrides_in,
    std::optional<base::flat_map<::url::Origin, SellerCapabilitiesPtr>> seller_capabilities_in,
    SellerCapabilitiesPtr all_sellers_capabilities_in,
    InterestGroup::ExecutionMode execution_mode_in,
    InterestGroup::TrustedBiddingSignalsSlotSizeMode trusted_bidding_signals_slot_size_mode_in,
    const std::optional<::GURL>& bidding_url_in,
    const std::optional<::GURL>& bidding_wasm_helper_url_in,
    const std::optional<::GURL>& update_url_in,
    const std::optional<::GURL>& trusted_bidding_signals_url_in,
    std::optional<std::vector<std::string>> trusted_bidding_signals_keys_in,
    int32_t max_trusted_bidding_signals_url_length_in,
    const std::optional<::url::Origin>& trusted_bidding_signals_coordinator_in,
    std::optional<std::vector<::url::Origin>> view_and_click_counts_providers_in,
    const std::optional<std::string>& user_bidding_signals_in,
    std::optional<std::vector<::blink::InterestGroup::Ad>> ads_in,
    std::optional<std::vector<::blink::InterestGroup::Ad>> ad_components_in,
    const std::optional<base::flat_map<std::string, ::blink::AdSize>>& ad_sizes_in,
    const std::optional<base::flat_map<std::string, std::vector<std::string>>>& size_groups_in,
    AuctionServerRequestFlagsPtr auction_server_request_flags_in,
    std::optional<std::vector<uint8_t>> additional_bid_key_in,
    const std::optional<::url::Origin>& aggregation_coordinator_origin_in)
    : expiry(std::move(expiry_in)),
      owner(std::move(owner_in)),
      name(std::move(name_in)),
      priority(std::move(priority_in)),
      enable_bidding_signals_prioritization(std::move(enable_bidding_signals_prioritization_in)),
      priority_vector(std::move(priority_vector_in)),
      priority_signals_overrides(std::move(priority_signals_overrides_in)),
      seller_capabilities(std::move(seller_capabilities_in)),
      all_sellers_capabilities(std::move(all_sellers_capabilities_in)),
      execution_mode(std::move(execution_mode_in)),
      trusted_bidding_signals_slot_size_mode(std::move(trusted_bidding_signals_slot_size_mode_in)),
      bidding_url(std::move(bidding_url_in)),
      bidding_wasm_helper_url(std::move(bidding_wasm_helper_url_in)),
      update_url(std::move(update_url_in)),
      trusted_bidding_signals_url(std::move(trusted_bidding_signals_url_in)),
      trusted_bidding_signals_keys(std::move(trusted_bidding_signals_keys_in)),
      max_trusted_bidding_signals_url_length(std::move(max_trusted_bidding_signals_url_length_in)),
      trusted_bidding_signals_coordinator(std::move(trusted_bidding_signals_coordinator_in)),
      view_and_click_counts_providers(std::move(view_and_click_counts_providers_in)),
      user_bidding_signals(std::move(user_bidding_signals_in)),
      ads(std::move(ads_in)),
      ad_components(std::move(ad_components_in)),
      ad_sizes(std::move(ad_sizes_in)),
      size_groups(std::move(size_groups_in)),
      auction_server_request_flags(std::move(auction_server_request_flags_in)),
      additional_bid_key(std::move(additional_bid_key_in)),
      aggregation_coordinator_origin(std::move(aggregation_coordinator_origin_in)) {}

InterestGroup::~InterestGroup() = default;

void InterestGroup::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "expiry"), this->expiry,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "owner"), this->owner,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::url::Origin&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "priority"), this->priority,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_bidding_signals_prioritization"), this->enable_bidding_signals_prioritization,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "priority_vector"), this->priority_vector,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<base::flat_map<std::string, double>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "priority_signals_overrides"), this->priority_signals_overrides,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<base::flat_map<std::string, double>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "seller_capabilities"), this->seller_capabilities,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<base::flat_map<::url::Origin, SellerCapabilitiesPtr>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "all_sellers_capabilities"), this->all_sellers_capabilities,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SellerCapabilitiesPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "execution_mode"), this->execution_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type InterestGroup::ExecutionMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trusted_bidding_signals_slot_size_mode"), this->trusted_bidding_signals_slot_size_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type InterestGroup::TrustedBiddingSignalsSlotSizeMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bidding_url"), this->bidding_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bidding_wasm_helper_url"), this->bidding_wasm_helper_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "update_url"), this->update_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trusted_bidding_signals_url"), this->trusted_bidding_signals_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trusted_bidding_signals_keys"), this->trusted_bidding_signals_keys,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::vector<std::string>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_trusted_bidding_signals_url_length"), this->max_trusted_bidding_signals_url_length,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trusted_bidding_signals_coordinator"), this->trusted_bidding_signals_coordinator,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::url::Origin>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "view_and_click_counts_providers"), this->view_and_click_counts_providers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::vector<::url::Origin>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "user_bidding_signals"), this->user_bidding_signals,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ads"), this->ads,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::vector<::blink::InterestGroup::Ad>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ad_components"), this->ad_components,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::vector<::blink::InterestGroup::Ad>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ad_sizes"), this->ad_sizes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<base::flat_map<std::string, ::blink::AdSize>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "size_groups"), this->size_groups,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<base::flat_map<std::string, std::vector<std::string>>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "auction_server_request_flags"), this->auction_server_request_flags,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AuctionServerRequestFlagsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "additional_bid_key"), this->additional_bid_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "aggregation_coordinator_origin"), this->aggregation_coordinator_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::url::Origin>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool InterestGroup::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PreviousWin::PreviousWin()
    : time(),
      ad_json() {}

PreviousWin::PreviousWin(
    ::base::Time time_in,
    const std::string& ad_json_in)
    : time(std::move(time_in)),
      ad_json(std::move(ad_json_in)) {}

PreviousWin::~PreviousWin() = default;

void PreviousWin::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "time"), this->time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ad_json"), this->ad_json,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PreviousWin::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ViewOrClickCounts::ViewOrClickCounts()
    : past_hour(0),
      past_day(0),
      past_week(0),
      past_30_days(0),
      past_90_days(0) {}

ViewOrClickCounts::ViewOrClickCounts(
    int32_t past_hour_in,
    int32_t past_day_in,
    int32_t past_week_in,
    int32_t past_30_days_in,
    int32_t past_90_days_in)
    : past_hour(std::move(past_hour_in)),
      past_day(std::move(past_day_in)),
      past_week(std::move(past_week_in)),
      past_30_days(std::move(past_30_days_in)),
      past_90_days(std::move(past_90_days_in)) {}

ViewOrClickCounts::~ViewOrClickCounts() = default;
size_t ViewOrClickCounts::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->past_hour);
  seed = mojo::internal::Hash(seed, this->past_day);
  seed = mojo::internal::Hash(seed, this->past_week);
  seed = mojo::internal::Hash(seed, this->past_30_days);
  seed = mojo::internal::Hash(seed, this->past_90_days);
  return seed;
}

void ViewOrClickCounts::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "past_hour"), this->past_hour,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "past_day"), this->past_day,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "past_week"), this->past_week,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "past_30_days"), this->past_30_days,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "past_90_days"), this->past_90_days,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ViewOrClickCounts::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ViewAndClickCounts::ViewAndClickCounts()
    : view_counts(),
      click_counts() {}

ViewAndClickCounts::ViewAndClickCounts(
    ViewOrClickCountsPtr view_counts_in,
    ViewOrClickCountsPtr click_counts_in)
    : view_counts(std::move(view_counts_in)),
      click_counts(std::move(click_counts_in)) {}

ViewAndClickCounts::~ViewAndClickCounts() = default;
size_t ViewAndClickCounts::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->view_counts);
  seed = mojo::internal::Hash(seed, this->click_counts);
  return seed;
}

void ViewAndClickCounts::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "view_counts"), this->view_counts,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ViewOrClickCountsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "click_counts"), this->click_counts,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ViewOrClickCountsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ViewAndClickCounts::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BiddingBrowserSignals::BiddingBrowserSignals()
    : join_count(),
      bid_count(),
      prev_wins(),
      for_debugging_only_in_cooldown_or_lockout(),
      view_and_click_counts() {}

BiddingBrowserSignals::BiddingBrowserSignals(
    int32_t join_count_in,
    int32_t bid_count_in,
    std::vector<PreviousWinPtr> prev_wins_in,
    bool for_debugging_only_in_cooldown_or_lockout_in,
    ViewAndClickCountsPtr view_and_click_counts_in)
    : join_count(std::move(join_count_in)),
      bid_count(std::move(bid_count_in)),
      prev_wins(std::move(prev_wins_in)),
      for_debugging_only_in_cooldown_or_lockout(std::move(for_debugging_only_in_cooldown_or_lockout_in)),
      view_and_click_counts(std::move(view_and_click_counts_in)) {}

BiddingBrowserSignals::~BiddingBrowserSignals() = default;

void BiddingBrowserSignals::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "join_count"), this->join_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bid_count"), this->bid_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "prev_wins"), this->prev_wins,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<PreviousWinPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "for_debugging_only_in_cooldown_or_lockout"), this->for_debugging_only_in_cooldown_or_lockout,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "view_and_click_counts"), this->view_and_click_counts,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ViewAndClickCountsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BiddingBrowserSignals::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
StorageInterestGroup::StorageInterestGroup()
    : interest_group(),
      bidding_browser_signals(),
      joining_origin(),
      join_time(),
      last_updated(),
      next_update_after(),
      estimated_size() {}

StorageInterestGroup::StorageInterestGroup(
    const ::blink::InterestGroup& interest_group_in,
    BiddingBrowserSignalsPtr bidding_browser_signals_in,
    const ::url::Origin& joining_origin_in,
    ::base::Time join_time_in,
    ::base::Time last_updated_in,
    ::base::Time next_update_after_in,
    uint64_t estimated_size_in)
    : interest_group(std::move(interest_group_in)),
      bidding_browser_signals(std::move(bidding_browser_signals_in)),
      joining_origin(std::move(joining_origin_in)),
      join_time(std::move(join_time_in)),
      last_updated(std::move(last_updated_in)),
      next_update_after(std::move(next_update_after_in)),
      estimated_size(std::move(estimated_size_in)) {}

StorageInterestGroup::~StorageInterestGroup() = default;

void StorageInterestGroup::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "interest_group"), this->interest_group,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::InterestGroup&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bidding_browser_signals"), this->bidding_browser_signals,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type BiddingBrowserSignalsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "joining_origin"), this->joining_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::url::Origin&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "join_time"), this->join_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "last_updated"), this->last_updated,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "next_update_after"), this->next_update_after,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "estimated_size"), this->estimated_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool StorageInterestGroup::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DirectFromSellerSignalsSubresource::DirectFromSellerSignalsSubresource()
    : bundle_url(),
      token() {}

DirectFromSellerSignalsSubresource::DirectFromSellerSignalsSubresource(
    const ::GURL& bundle_url_in,
    const ::base::UnguessableToken& token_in)
    : bundle_url(std::move(bundle_url_in)),
      token(std::move(token_in)) {}

DirectFromSellerSignalsSubresource::~DirectFromSellerSignalsSubresource() = default;

void DirectFromSellerSignalsSubresource::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bundle_url"), this->bundle_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "token"), this->token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::UnguessableToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DirectFromSellerSignalsSubresource::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DirectFromSellerSignals::DirectFromSellerSignals()
    : prefix(),
      per_buyer_signals(),
      seller_signals(),
      auction_signals() {}

DirectFromSellerSignals::DirectFromSellerSignals(
    const ::GURL& prefix_in,
    const base::flat_map<::url::Origin, ::blink::DirectFromSellerSignalsSubresource>& per_buyer_signals_in,
    const std::optional<::blink::DirectFromSellerSignalsSubresource>& seller_signals_in,
    const std::optional<::blink::DirectFromSellerSignalsSubresource>& auction_signals_in)
    : prefix(std::move(prefix_in)),
      per_buyer_signals(std::move(per_buyer_signals_in)),
      seller_signals(std::move(seller_signals_in)),
      auction_signals(std::move(auction_signals_in)) {}

DirectFromSellerSignals::~DirectFromSellerSignals() = default;

void DirectFromSellerSignals::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "prefix"), this->prefix,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "per_buyer_signals"), this->per_buyer_signals,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<::url::Origin, ::blink::DirectFromSellerSignalsSubresource>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "seller_signals"), this->seller_signals,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::DirectFromSellerSignalsSubresource>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "auction_signals"), this->auction_signals,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::DirectFromSellerSignalsSubresource>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DirectFromSellerSignals::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AuctionAdConfigBuyerTimeouts::AuctionAdConfigBuyerTimeouts()
    : all_buyers_timeout(),
      per_buyer_timeouts() {}

AuctionAdConfigBuyerTimeouts::AuctionAdConfigBuyerTimeouts(
    std::optional<::base::TimeDelta> all_buyers_timeout_in,
    const std::optional<base::flat_map<::url::Origin, ::base::TimeDelta>>& per_buyer_timeouts_in)
    : all_buyers_timeout(std::move(all_buyers_timeout_in)),
      per_buyer_timeouts(std::move(per_buyer_timeouts_in)) {}

AuctionAdConfigBuyerTimeouts::~AuctionAdConfigBuyerTimeouts() = default;

void AuctionAdConfigBuyerTimeouts::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "all_buyers_timeout"), this->all_buyers_timeout,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "per_buyer_timeouts"), this->per_buyer_timeouts,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<base::flat_map<::url::Origin, ::base::TimeDelta>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AuctionAdConfigBuyerTimeouts::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AdCurrency::AdCurrency()
    : currency_code() {}

AdCurrency::AdCurrency(
    const std::string& currency_code_in)
    : currency_code(std::move(currency_code_in)) {}

AdCurrency::~AdCurrency() = default;

void AdCurrency::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "currency_code"), this->currency_code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AdCurrency::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AuctionAdConfigBuyerCurrencies::AuctionAdConfigBuyerCurrencies()
    : all_buyers_currency(),
      per_buyer_currencies() {}

AuctionAdConfigBuyerCurrencies::AuctionAdConfigBuyerCurrencies(
    const std::optional<::blink::AdCurrency>& all_buyers_currency_in,
    const std::optional<base::flat_map<::url::Origin, ::blink::AdCurrency>>& per_buyer_currencies_in)
    : all_buyers_currency(std::move(all_buyers_currency_in)),
      per_buyer_currencies(std::move(per_buyer_currencies_in)) {}

AuctionAdConfigBuyerCurrencies::~AuctionAdConfigBuyerCurrencies() = default;

void AuctionAdConfigBuyerCurrencies::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "all_buyers_currency"), this->all_buyers_currency,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::AdCurrency>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "per_buyer_currencies"), this->per_buyer_currencies,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<base::flat_map<::url::Origin, ::blink::AdCurrency>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AuctionAdConfigBuyerCurrencies::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AuctionAdServerResponseConfig::AuctionAdServerResponseConfig()
    : request_id() {}

AuctionAdServerResponseConfig::AuctionAdServerResponseConfig(
    const ::base::Uuid& request_id_in)
    : request_id(std::move(request_id_in)) {}

AuctionAdServerResponseConfig::~AuctionAdServerResponseConfig() = default;

void AuctionAdServerResponseConfig::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request_id"), this->request_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::Uuid&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AuctionAdServerResponseConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AuctionReportBuyerDebugModeConfig::AuctionReportBuyerDebugModeConfig()
    : is_enabled(false),
      debug_key() {}

AuctionReportBuyerDebugModeConfig::AuctionReportBuyerDebugModeConfig(
    bool is_enabled_in,
    std::optional<uint64_t> debug_key_in)
    : is_enabled(std::move(is_enabled_in)),
      debug_key(std::move(debug_key_in)) {}

AuctionReportBuyerDebugModeConfig::~AuctionReportBuyerDebugModeConfig() = default;

void AuctionReportBuyerDebugModeConfig::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_enabled"), this->is_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "debug_key"), this->debug_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<uint64_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AuctionReportBuyerDebugModeConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AuctionReportBuyersConfig::AuctionReportBuyersConfig()
    : bucket(),
      scale() {}

AuctionReportBuyersConfig::AuctionReportBuyersConfig(
    const ::absl::uint128& bucket_in,
    double scale_in)
    : bucket(std::move(bucket_in)),
      scale(std::move(scale_in)) {}

AuctionReportBuyersConfig::~AuctionReportBuyersConfig() = default;

void AuctionReportBuyersConfig::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bucket"), this->bucket,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::absl::uint128&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scale"), this->scale,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AuctionReportBuyersConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AuctionAdConfigNonSharedParams::AuctionAdConfigNonSharedParams()
    : interest_group_buyers(),
      auction_signals(),
      seller_signals(),
      seller_tkv_signals(),
      seller_timeout(),
      per_buyer_signals(),
      per_buyer_tkv_signals(),
      buyer_timeouts(),
      reporting_timeout(),
      seller_currency(),
      buyer_currencies(),
      buyer_cumulative_timeouts(),
      per_buyer_group_limits(),
      per_buyer_priority_signals(),
      all_buyers_priority_signals(),
      all_buyers_group_limit(65535U),
      auction_report_buyer_keys(),
      auction_report_buyers(),
      auction_report_buyer_debug_mode_config(),
      required_seller_capabilities(),
      requested_size(),
      all_slots_requested_sizes(),
      per_buyer_multi_bid_limits(),
      all_buyers_multi_bid_limit(),
      auction_nonce(),
      seller_real_time_reporting_type(),
      per_buyer_real_time_reporting_types(),
      component_auctions(),
      deprecated_render_url_replacements(),
      max_trusted_scoring_signals_url_length(0),
      trusted_scoring_signals_coordinator(),
      execution_mode(InterestGroup_ExecutionMode::kCompatibilityMode) {}

AuctionAdConfigNonSharedParams::AuctionAdConfigNonSharedParams(
    std::optional<std::vector<::url::Origin>> interest_group_buyers_in,
    const ::blink::AuctionConfig::MaybePromiseJson& auction_signals_in,
    const ::blink::AuctionConfig::MaybePromiseJson& seller_signals_in,
    const ::blink::AuctionConfig::MaybePromiseJson& seller_tkv_signals_in,
    std::optional<::base::TimeDelta> seller_timeout_in,
    const ::blink::AuctionConfig::MaybePromisePerBuyerSignals& per_buyer_signals_in,
    const base::flat_map<::url::Origin, ::blink::AuctionConfig::MaybePromiseJson>& per_buyer_tkv_signals_in,
    const ::blink::AuctionConfig::MaybePromiseBuyerTimeouts& buyer_timeouts_in,
    std::optional<::base::TimeDelta> reporting_timeout_in,
    const std::optional<::blink::AdCurrency>& seller_currency_in,
    const ::blink::AuctionConfig::MaybePromiseBuyerCurrencies& buyer_currencies_in,
    const ::blink::AuctionConfig::MaybePromiseBuyerTimeouts& buyer_cumulative_timeouts_in,
    const base::flat_map<::url::Origin, uint16_t>& per_buyer_group_limits_in,
    const std::optional<base::flat_map<::url::Origin, base::flat_map<std::string, double>>>& per_buyer_priority_signals_in,
    const std::optional<base::flat_map<std::string, double>>& all_buyers_priority_signals_in,
    uint16_t all_buyers_group_limit_in,
    std::optional<std::vector<::absl::uint128>> auction_report_buyer_keys_in,
    std::optional<base::flat_map<AuctionAdConfigNonSharedParams::BuyerReportType, AuctionReportBuyersConfigPtr>> auction_report_buyers_in,
    AuctionReportBuyerDebugModeConfigPtr auction_report_buyer_debug_mode_config_in,
    SellerCapabilitiesPtr required_seller_capabilities_in,
    const std::optional<::blink::AdSize>& requested_size_in,
    std::optional<std::vector<::blink::AdSize>> all_slots_requested_sizes_in,
    const base::flat_map<::url::Origin, uint16_t>& per_buyer_multi_bid_limits_in,
    uint16_t all_buyers_multi_bid_limit_in,
    const std::optional<::base::Uuid>& auction_nonce_in,
    std::optional<AuctionAdConfigNonSharedParams::RealTimeReportingType> seller_real_time_reporting_type_in,
    const std::optional<base::flat_map<::url::Origin, AuctionAdConfigNonSharedParams::RealTimeReportingType>>& per_buyer_real_time_reporting_types_in,
    std::vector<::blink::AuctionConfig> component_auctions_in,
    const ::blink::AuctionConfig::MaybePromiseDeprecatedRenderURLReplacements& deprecated_render_url_replacements_in,
    int32_t max_trusted_scoring_signals_url_length_in,
    const std::optional<::url::Origin>& trusted_scoring_signals_coordinator_in,
    InterestGroup::ExecutionMode execution_mode_in)
    : interest_group_buyers(std::move(interest_group_buyers_in)),
      auction_signals(std::move(auction_signals_in)),
      seller_signals(std::move(seller_signals_in)),
      seller_tkv_signals(std::move(seller_tkv_signals_in)),
      seller_timeout(std::move(seller_timeout_in)),
      per_buyer_signals(std::move(per_buyer_signals_in)),
      per_buyer_tkv_signals(std::move(per_buyer_tkv_signals_in)),
      buyer_timeouts(std::move(buyer_timeouts_in)),
      reporting_timeout(std::move(reporting_timeout_in)),
      seller_currency(std::move(seller_currency_in)),
      buyer_currencies(std::move(buyer_currencies_in)),
      buyer_cumulative_timeouts(std::move(buyer_cumulative_timeouts_in)),
      per_buyer_group_limits(std::move(per_buyer_group_limits_in)),
      per_buyer_priority_signals(std::move(per_buyer_priority_signals_in)),
      all_buyers_priority_signals(std::move(all_buyers_priority_signals_in)),
      all_buyers_group_limit(std::move(all_buyers_group_limit_in)),
      auction_report_buyer_keys(std::move(auction_report_buyer_keys_in)),
      auction_report_buyers(std::move(auction_report_buyers_in)),
      auction_report_buyer_debug_mode_config(std::move(auction_report_buyer_debug_mode_config_in)),
      required_seller_capabilities(std::move(required_seller_capabilities_in)),
      requested_size(std::move(requested_size_in)),
      all_slots_requested_sizes(std::move(all_slots_requested_sizes_in)),
      per_buyer_multi_bid_limits(std::move(per_buyer_multi_bid_limits_in)),
      all_buyers_multi_bid_limit(std::move(all_buyers_multi_bid_limit_in)),
      auction_nonce(std::move(auction_nonce_in)),
      seller_real_time_reporting_type(std::move(seller_real_time_reporting_type_in)),
      per_buyer_real_time_reporting_types(std::move(per_buyer_real_time_reporting_types_in)),
      component_auctions(std::move(component_auctions_in)),
      deprecated_render_url_replacements(std::move(deprecated_render_url_replacements_in)),
      max_trusted_scoring_signals_url_length(std::move(max_trusted_scoring_signals_url_length_in)),
      trusted_scoring_signals_coordinator(std::move(trusted_scoring_signals_coordinator_in)),
      execution_mode(std::move(execution_mode_in)) {}

AuctionAdConfigNonSharedParams::~AuctionAdConfigNonSharedParams() = default;

void AuctionAdConfigNonSharedParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "interest_group_buyers"), this->interest_group_buyers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::vector<::url::Origin>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "auction_signals"), this->auction_signals,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::AuctionConfig::MaybePromiseJson&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "seller_signals"), this->seller_signals,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::AuctionConfig::MaybePromiseJson&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "seller_tkv_signals"), this->seller_tkv_signals,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::AuctionConfig::MaybePromiseJson&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "seller_timeout"), this->seller_timeout,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "per_buyer_signals"), this->per_buyer_signals,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::AuctionConfig::MaybePromisePerBuyerSignals&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "per_buyer_tkv_signals"), this->per_buyer_tkv_signals,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<::url::Origin, ::blink::AuctionConfig::MaybePromiseJson>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "buyer_timeouts"), this->buyer_timeouts,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::AuctionConfig::MaybePromiseBuyerTimeouts&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reporting_timeout"), this->reporting_timeout,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "seller_currency"), this->seller_currency,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::AdCurrency>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "buyer_currencies"), this->buyer_currencies,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::AuctionConfig::MaybePromiseBuyerCurrencies&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "buyer_cumulative_timeouts"), this->buyer_cumulative_timeouts,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::AuctionConfig::MaybePromiseBuyerTimeouts&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "per_buyer_group_limits"), this->per_buyer_group_limits,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<::url::Origin, uint16_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "per_buyer_priority_signals"), this->per_buyer_priority_signals,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<base::flat_map<::url::Origin, base::flat_map<std::string, double>>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "all_buyers_priority_signals"), this->all_buyers_priority_signals,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<base::flat_map<std::string, double>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "all_buyers_group_limit"), this->all_buyers_group_limit,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint16_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "auction_report_buyer_keys"), this->auction_report_buyer_keys,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::vector<::absl::uint128>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "auction_report_buyers"), this->auction_report_buyers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<base::flat_map<AuctionAdConfigNonSharedParams::BuyerReportType, AuctionReportBuyersConfigPtr>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "auction_report_buyer_debug_mode_config"), this->auction_report_buyer_debug_mode_config,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AuctionReportBuyerDebugModeConfigPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "required_seller_capabilities"), this->required_seller_capabilities,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SellerCapabilitiesPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "requested_size"), this->requested_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::AdSize>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "all_slots_requested_sizes"), this->all_slots_requested_sizes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::vector<::blink::AdSize>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "per_buyer_multi_bid_limits"), this->per_buyer_multi_bid_limits,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<::url::Origin, uint16_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "all_buyers_multi_bid_limit"), this->all_buyers_multi_bid_limit,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint16_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "auction_nonce"), this->auction_nonce,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::base::Uuid>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "seller_real_time_reporting_type"), this->seller_real_time_reporting_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<AuctionAdConfigNonSharedParams::RealTimeReportingType>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "per_buyer_real_time_reporting_types"), this->per_buyer_real_time_reporting_types,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<base::flat_map<::url::Origin, AuctionAdConfigNonSharedParams::RealTimeReportingType>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "component_auctions"), this->component_auctions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::blink::AuctionConfig>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "deprecated_render_url_replacements"), this->deprecated_render_url_replacements,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::AuctionConfig::MaybePromiseDeprecatedRenderURLReplacements&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_trusted_scoring_signals_url_length"), this->max_trusted_scoring_signals_url_length,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trusted_scoring_signals_coordinator"), this->trusted_scoring_signals_coordinator,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::url::Origin>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "execution_mode"), this->execution_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type InterestGroup::ExecutionMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AuctionAdConfigNonSharedParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AuctionAdConfig::AuctionAdConfig()
    : seller(),
      server_response(),
      decision_logic_url(),
      trusted_scoring_signals_url(),
      auction_ad_config_non_shared_params(),
      direct_from_seller_signals(),
      expects_direct_from_seller_signals_header_ad_slot(false),
      seller_experiment_group_id(),
      all_buyer_experiment_group_id(),
      per_buyer_experiment_group_ids(),
      expects_additional_bids(false),
      aggregation_coordinator_origin(),
      send_creative_scanning_metadata() {}

AuctionAdConfig::AuctionAdConfig(
    const ::url::Origin& seller_in,
    const std::optional<::blink::AuctionConfig::ServerResponseConfig>& server_response_in,
    const std::optional<::GURL>& decision_logic_url_in,
    const std::optional<::GURL>& trusted_scoring_signals_url_in,
    const ::blink::AuctionConfig::NonSharedParams& auction_ad_config_non_shared_params_in,
    const ::blink::AuctionConfig::MaybePromiseDirectFromSellerSignals& direct_from_seller_signals_in,
    bool expects_direct_from_seller_signals_header_ad_slot_in,
    std::optional<uint16_t> seller_experiment_group_id_in,
    std::optional<uint16_t> all_buyer_experiment_group_id_in,
    const base::flat_map<::url::Origin, uint16_t>& per_buyer_experiment_group_ids_in,
    bool expects_additional_bids_in,
    const std::optional<::url::Origin>& aggregation_coordinator_origin_in,
    std::optional<bool> send_creative_scanning_metadata_in)
    : seller(std::move(seller_in)),
      server_response(std::move(server_response_in)),
      decision_logic_url(std::move(decision_logic_url_in)),
      trusted_scoring_signals_url(std::move(trusted_scoring_signals_url_in)),
      auction_ad_config_non_shared_params(std::move(auction_ad_config_non_shared_params_in)),
      direct_from_seller_signals(std::move(direct_from_seller_signals_in)),
      expects_direct_from_seller_signals_header_ad_slot(std::move(expects_direct_from_seller_signals_header_ad_slot_in)),
      seller_experiment_group_id(std::move(seller_experiment_group_id_in)),
      all_buyer_experiment_group_id(std::move(all_buyer_experiment_group_id_in)),
      per_buyer_experiment_group_ids(std::move(per_buyer_experiment_group_ids_in)),
      expects_additional_bids(std::move(expects_additional_bids_in)),
      aggregation_coordinator_origin(std::move(aggregation_coordinator_origin_in)),
      send_creative_scanning_metadata(std::move(send_creative_scanning_metadata_in)) {}

AuctionAdConfig::~AuctionAdConfig() = default;

void AuctionAdConfig::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "seller"), this->seller,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::url::Origin&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "server_response"), this->server_response,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::AuctionConfig::ServerResponseConfig>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "decision_logic_url"), this->decision_logic_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trusted_scoring_signals_url"), this->trusted_scoring_signals_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "auction_ad_config_non_shared_params"), this->auction_ad_config_non_shared_params,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::AuctionConfig::NonSharedParams&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "direct_from_seller_signals"), this->direct_from_seller_signals,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::AuctionConfig::MaybePromiseDirectFromSellerSignals&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "expects_direct_from_seller_signals_header_ad_slot"), this->expects_direct_from_seller_signals_header_ad_slot,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "seller_experiment_group_id"), this->seller_experiment_group_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<uint16_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "all_buyer_experiment_group_id"), this->all_buyer_experiment_group_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<uint16_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "per_buyer_experiment_group_ids"), this->per_buyer_experiment_group_ids,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<::url::Origin, uint16_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "expects_additional_bids"), this->expects_additional_bids,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "aggregation_coordinator_origin"), this->aggregation_coordinator_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::url::Origin>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "send_creative_scanning_metadata"), this->send_creative_scanning_metadata,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<bool>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AuctionAdConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AuctionDataBuyerConfig::AuctionDataBuyerConfig()
    : target_size() {}

AuctionDataBuyerConfig::AuctionDataBuyerConfig(
    std::optional<uint32_t> target_size_in)
    : target_size(std::move(target_size_in)) {}

AuctionDataBuyerConfig::~AuctionDataBuyerConfig() = default;

void AuctionDataBuyerConfig::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "target_size"), this->target_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<uint32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AuctionDataBuyerConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AuctionDataConfig::AuctionDataConfig()
    : per_buyer_configs(),
      request_size() {}

AuctionDataConfig::AuctionDataConfig(
    base::flat_map<::url::Origin, AuctionDataBuyerConfigPtr> per_buyer_configs_in,
    std::optional<uint32_t> request_size_in)
    : per_buyer_configs(std::move(per_buyer_configs_in)),
      request_size(std::move(request_size_in)) {}

AuctionDataConfig::~AuctionDataConfig() = default;

void AuctionDataConfig::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "per_buyer_configs"), this->per_buyer_configs,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type base::flat_map<::url::Origin, AuctionDataBuyerConfigPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request_size"), this->request_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<uint32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AuctionDataConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AdAuctionPerSellerRequest::AdAuctionPerSellerRequest()
    : seller(),
      data() {}

AdAuctionPerSellerRequest::AdAuctionPerSellerRequest(
    const ::url::Origin& seller_in,
    AdAuctionRequestOrErrorPtr data_in)
    : seller(std::move(seller_in)),
      data(std::move(data_in)) {}

AdAuctionPerSellerRequest::~AdAuctionPerSellerRequest() = default;

void AdAuctionPerSellerRequest::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "seller"), this->seller,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::url::Origin&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AdAuctionRequestOrErrorPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AdAuctionPerSellerRequest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AuctionAdConfigMaybePromiseJsonPtr
AuctionAdConfigMaybePromiseJson::NewPromise(
    uint32_t value) {
  return AuctionAdConfigMaybePromiseJsonPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kPromise)>,
      std::move(value));
}

AuctionAdConfigMaybePromiseJsonPtr
AuctionAdConfigMaybePromiseJson::NewValue(
    const std::optional<std::string>& value) {
  return AuctionAdConfigMaybePromiseJsonPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kValue)>,
      std::move(value));
}

AuctionAdConfigMaybePromiseJson::AuctionAdConfigMaybePromiseJson(
    std::in_place_index_t<static_cast<size_t>(Tag::kPromise)>,
    uint32_t value)
    : tag_(Tag::kPromise),
      data_(std::in_place_index<static_cast<size_t>(Tag::kPromise)>,
            std::move(value)) {}

AuctionAdConfigMaybePromiseJson::AuctionAdConfigMaybePromiseJson(
    std::in_place_index_t<static_cast<size_t>(Tag::kValue)>,
    const std::optional<std::string>& value)
    : tag_(Tag::kValue),
      data_(std::in_place_index<static_cast<size_t>(Tag::kValue)>,
            std::move(value)) {}
AuctionAdConfigMaybePromiseJson::~AuctionAdConfigMaybePromiseJson() {
  DestroyActive();
}

void AuctionAdConfigMaybePromiseJson::set_promise(uint32_t promise) {
  if (tag_ != Tag::kPromise) {
    DestroyActive();
    tag_ = Tag::kPromise;
  }
  data_.promise = promise;
}

void AuctionAdConfigMaybePromiseJson::set_value(const std::optional<std::string>& value) {
  if (tag_ == Tag::kValue) {
    data_.value = std::move(value);
  } else {
    DestroyActive();
    tag_ = Tag::kValue;
    new (&data_.value) std::optional<std::string>(
        std::move(value));
  }
}


AuctionAdConfigMaybePromiseJson::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kPromise)>,
    uint32_t value)
    : promise(std::move(value)) {}

AuctionAdConfigMaybePromiseJson::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kValue)>,
    const std::optional<std::string>& value)
    : value(std::move(value)) {}

void AuctionAdConfigMaybePromiseJson::DestroyActive() {
  switch (tag_) {

    case Tag::kPromise:
      std::destroy_at(&data_.promise);
      break;
    case Tag::kValue:
      std::destroy_at(&data_.value);
      break;
  }
}

bool AuctionAdConfigMaybePromiseJson::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
AuctionAdConfigMaybePromisePerBuyerSignalsPtr
AuctionAdConfigMaybePromisePerBuyerSignals::NewPromise(
    uint32_t value) {
  return AuctionAdConfigMaybePromisePerBuyerSignalsPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kPromise)>,
      std::move(value));
}

AuctionAdConfigMaybePromisePerBuyerSignalsPtr
AuctionAdConfigMaybePromisePerBuyerSignals::NewValue(
    const std::optional<base::flat_map<::url::Origin, std::string>>& value) {
  return AuctionAdConfigMaybePromisePerBuyerSignalsPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kValue)>,
      std::move(value));
}

AuctionAdConfigMaybePromisePerBuyerSignals::AuctionAdConfigMaybePromisePerBuyerSignals(
    std::in_place_index_t<static_cast<size_t>(Tag::kPromise)>,
    uint32_t value)
    : tag_(Tag::kPromise),
      data_(std::in_place_index<static_cast<size_t>(Tag::kPromise)>,
            std::move(value)) {}

AuctionAdConfigMaybePromisePerBuyerSignals::AuctionAdConfigMaybePromisePerBuyerSignals(
    std::in_place_index_t<static_cast<size_t>(Tag::kValue)>,
    const std::optional<base::flat_map<::url::Origin, std::string>>& value)
    : tag_(Tag::kValue),
      data_(std::in_place_index<static_cast<size_t>(Tag::kValue)>,
            std::move(value)) {}
AuctionAdConfigMaybePromisePerBuyerSignals::~AuctionAdConfigMaybePromisePerBuyerSignals() {
  DestroyActive();
}

void AuctionAdConfigMaybePromisePerBuyerSignals::set_promise(uint32_t promise) {
  if (tag_ != Tag::kPromise) {
    DestroyActive();
    tag_ = Tag::kPromise;
  }
  data_.promise = promise;
}

void AuctionAdConfigMaybePromisePerBuyerSignals::set_value(const std::optional<base::flat_map<::url::Origin, std::string>>& value) {
  if (tag_ == Tag::kValue) {
    data_.value = std::move(value);
  } else {
    DestroyActive();
    tag_ = Tag::kValue;
    new (&data_.value) std::optional<base::flat_map<::url::Origin, std::string>>(
        std::move(value));
  }
}


AuctionAdConfigMaybePromisePerBuyerSignals::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kPromise)>,
    uint32_t value)
    : promise(std::move(value)) {}

AuctionAdConfigMaybePromisePerBuyerSignals::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kValue)>,
    const std::optional<base::flat_map<::url::Origin, std::string>>& value)
    : value(std::move(value)) {}

void AuctionAdConfigMaybePromisePerBuyerSignals::DestroyActive() {
  switch (tag_) {

    case Tag::kPromise:
      std::destroy_at(&data_.promise);
      break;
    case Tag::kValue:
      std::destroy_at(&data_.value);
      break;
  }
}

bool AuctionAdConfigMaybePromisePerBuyerSignals::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
AuctionAdConfigMaybePromiseBuyerTimeoutsPtr
AuctionAdConfigMaybePromiseBuyerTimeouts::NewPromise(
    uint32_t value) {
  return AuctionAdConfigMaybePromiseBuyerTimeoutsPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kPromise)>,
      std::move(value));
}

AuctionAdConfigMaybePromiseBuyerTimeoutsPtr
AuctionAdConfigMaybePromiseBuyerTimeouts::NewValue(
    const ::blink::AuctionConfig::BuyerTimeouts& value) {
  return AuctionAdConfigMaybePromiseBuyerTimeoutsPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kValue)>,
      std::move(value));
}

AuctionAdConfigMaybePromiseBuyerTimeouts::AuctionAdConfigMaybePromiseBuyerTimeouts(
    std::in_place_index_t<static_cast<size_t>(Tag::kPromise)>,
    uint32_t value)
    : tag_(Tag::kPromise),
      data_(std::in_place_index<static_cast<size_t>(Tag::kPromise)>,
            std::move(value)) {}

AuctionAdConfigMaybePromiseBuyerTimeouts::AuctionAdConfigMaybePromiseBuyerTimeouts(
    std::in_place_index_t<static_cast<size_t>(Tag::kValue)>,
    const ::blink::AuctionConfig::BuyerTimeouts& value)
    : tag_(Tag::kValue),
      data_(std::in_place_index<static_cast<size_t>(Tag::kValue)>,
            std::move(value)) {}
AuctionAdConfigMaybePromiseBuyerTimeouts::~AuctionAdConfigMaybePromiseBuyerTimeouts() {
  DestroyActive();
}

void AuctionAdConfigMaybePromiseBuyerTimeouts::set_promise(uint32_t promise) {
  if (tag_ != Tag::kPromise) {
    DestroyActive();
    tag_ = Tag::kPromise;
  }
  data_.promise = promise;
}

void AuctionAdConfigMaybePromiseBuyerTimeouts::set_value(const ::blink::AuctionConfig::BuyerTimeouts& value) {
  if (tag_ == Tag::kValue) {
    data_.value = std::move(value);
  } else {
    DestroyActive();
    tag_ = Tag::kValue;
    new (&data_.value) ::blink::AuctionConfig::BuyerTimeouts(
        std::move(value));
  }
}


AuctionAdConfigMaybePromiseBuyerTimeouts::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kPromise)>,
    uint32_t value)
    : promise(std::move(value)) {}

AuctionAdConfigMaybePromiseBuyerTimeouts::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kValue)>,
    const ::blink::AuctionConfig::BuyerTimeouts& value)
    : value(std::move(value)) {}

void AuctionAdConfigMaybePromiseBuyerTimeouts::DestroyActive() {
  switch (tag_) {

    case Tag::kPromise:
      std::destroy_at(&data_.promise);
      break;
    case Tag::kValue:
      std::destroy_at(&data_.value);
      break;
  }
}

bool AuctionAdConfigMaybePromiseBuyerTimeouts::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
AuctionAdConfigMaybePromiseBuyerCurrenciesPtr
AuctionAdConfigMaybePromiseBuyerCurrencies::NewPromise(
    uint32_t value) {
  return AuctionAdConfigMaybePromiseBuyerCurrenciesPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kPromise)>,
      std::move(value));
}

AuctionAdConfigMaybePromiseBuyerCurrenciesPtr
AuctionAdConfigMaybePromiseBuyerCurrencies::NewValue(
    const ::blink::AuctionConfig::BuyerCurrencies& value) {
  return AuctionAdConfigMaybePromiseBuyerCurrenciesPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kValue)>,
      std::move(value));
}

AuctionAdConfigMaybePromiseBuyerCurrencies::AuctionAdConfigMaybePromiseBuyerCurrencies(
    std::in_place_index_t<static_cast<size_t>(Tag::kPromise)>,
    uint32_t value)
    : tag_(Tag::kPromise),
      data_(std::in_place_index<static_cast<size_t>(Tag::kPromise)>,
            std::move(value)) {}

AuctionAdConfigMaybePromiseBuyerCurrencies::AuctionAdConfigMaybePromiseBuyerCurrencies(
    std::in_place_index_t<static_cast<size_t>(Tag::kValue)>,
    const ::blink::AuctionConfig::BuyerCurrencies& value)
    : tag_(Tag::kValue),
      data_(std::in_place_index<static_cast<size_t>(Tag::kValue)>,
            std::move(value)) {}
AuctionAdConfigMaybePromiseBuyerCurrencies::~AuctionAdConfigMaybePromiseBuyerCurrencies() {
  DestroyActive();
}

void AuctionAdConfigMaybePromiseBuyerCurrencies::set_promise(uint32_t promise) {
  if (tag_ != Tag::kPromise) {
    DestroyActive();
    tag_ = Tag::kPromise;
  }
  data_.promise = promise;
}

void AuctionAdConfigMaybePromiseBuyerCurrencies::set_value(const ::blink::AuctionConfig::BuyerCurrencies& value) {
  if (tag_ == Tag::kValue) {
    data_.value = std::move(value);
  } else {
    DestroyActive();
    tag_ = Tag::kValue;
    new (&data_.value) ::blink::AuctionConfig::BuyerCurrencies(
        std::move(value));
  }
}


AuctionAdConfigMaybePromiseBuyerCurrencies::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kPromise)>,
    uint32_t value)
    : promise(std::move(value)) {}

AuctionAdConfigMaybePromiseBuyerCurrencies::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kValue)>,
    const ::blink::AuctionConfig::BuyerCurrencies& value)
    : value(std::move(value)) {}

void AuctionAdConfigMaybePromiseBuyerCurrencies::DestroyActive() {
  switch (tag_) {

    case Tag::kPromise:
      std::destroy_at(&data_.promise);
      break;
    case Tag::kValue:
      std::destroy_at(&data_.value);
      break;
  }
}

bool AuctionAdConfigMaybePromiseBuyerCurrencies::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
AuctionAdConfigMaybePromiseDirectFromSellerSignalsPtr
AuctionAdConfigMaybePromiseDirectFromSellerSignals::NewPromise(
    uint32_t value) {
  return AuctionAdConfigMaybePromiseDirectFromSellerSignalsPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kPromise)>,
      std::move(value));
}

AuctionAdConfigMaybePromiseDirectFromSellerSignalsPtr
AuctionAdConfigMaybePromiseDirectFromSellerSignals::NewValue(
    const std::optional<::blink::DirectFromSellerSignals>& value) {
  return AuctionAdConfigMaybePromiseDirectFromSellerSignalsPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kValue)>,
      std::move(value));
}

AuctionAdConfigMaybePromiseDirectFromSellerSignals::AuctionAdConfigMaybePromiseDirectFromSellerSignals(
    std::in_place_index_t<static_cast<size_t>(Tag::kPromise)>,
    uint32_t value)
    : tag_(Tag::kPromise),
      data_(std::in_place_index<static_cast<size_t>(Tag::kPromise)>,
            std::move(value)) {}

AuctionAdConfigMaybePromiseDirectFromSellerSignals::AuctionAdConfigMaybePromiseDirectFromSellerSignals(
    std::in_place_index_t<static_cast<size_t>(Tag::kValue)>,
    const std::optional<::blink::DirectFromSellerSignals>& value)
    : tag_(Tag::kValue),
      data_(std::in_place_index<static_cast<size_t>(Tag::kValue)>,
            std::move(value)) {}
AuctionAdConfigMaybePromiseDirectFromSellerSignals::~AuctionAdConfigMaybePromiseDirectFromSellerSignals() {
  DestroyActive();
}

void AuctionAdConfigMaybePromiseDirectFromSellerSignals::set_promise(uint32_t promise) {
  if (tag_ != Tag::kPromise) {
    DestroyActive();
    tag_ = Tag::kPromise;
  }
  data_.promise = promise;
}

void AuctionAdConfigMaybePromiseDirectFromSellerSignals::set_value(const std::optional<::blink::DirectFromSellerSignals>& value) {
  if (tag_ == Tag::kValue) {
    data_.value = std::move(value);
  } else {
    DestroyActive();
    tag_ = Tag::kValue;
    new (&data_.value) std::optional<::blink::DirectFromSellerSignals>(
        std::move(value));
  }
}


AuctionAdConfigMaybePromiseDirectFromSellerSignals::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kPromise)>,
    uint32_t value)
    : promise(std::move(value)) {}

AuctionAdConfigMaybePromiseDirectFromSellerSignals::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kValue)>,
    const std::optional<::blink::DirectFromSellerSignals>& value)
    : value(std::move(value)) {}

void AuctionAdConfigMaybePromiseDirectFromSellerSignals::DestroyActive() {
  switch (tag_) {

    case Tag::kPromise:
      std::destroy_at(&data_.promise);
      break;
    case Tag::kValue:
      std::destroy_at(&data_.value);
      break;
  }
}

bool AuctionAdConfigMaybePromiseDirectFromSellerSignals::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacementsPtr
AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements::NewPromise(
    uint32_t value) {
  return AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacementsPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kPromise)>,
      std::move(value));
}

AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacementsPtr
AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements::NewValue(
    std::vector<::blink::AuctionConfig::AdKeywordReplacement> value) {
  return AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacementsPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kValue)>,
      std::move(value));
}

AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements::AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements(
    std::in_place_index_t<static_cast<size_t>(Tag::kPromise)>,
    uint32_t value)
    : tag_(Tag::kPromise),
      data_(std::in_place_index<static_cast<size_t>(Tag::kPromise)>,
            std::move(value)) {}

AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements::AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements(
    std::in_place_index_t<static_cast<size_t>(Tag::kValue)>,
    std::vector<::blink::AuctionConfig::AdKeywordReplacement> value)
    : tag_(Tag::kValue),
      data_(std::in_place_index<static_cast<size_t>(Tag::kValue)>,
            std::move(value)) {}
AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements::~AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements() {
  DestroyActive();
}

void AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements::set_promise(uint32_t promise) {
  if (tag_ != Tag::kPromise) {
    DestroyActive();
    tag_ = Tag::kPromise;
  }
  data_.promise = promise;
}

void AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements::set_value(std::vector<::blink::AuctionConfig::AdKeywordReplacement> value) {
  if (tag_ == Tag::kValue) {
    data_.value = std::move(value);
  } else {
    DestroyActive();
    tag_ = Tag::kValue;
    new (&data_.value) std::vector<::blink::AuctionConfig::AdKeywordReplacement>(
        std::move(value));
  }
}


AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kPromise)>,
    uint32_t value)
    : promise(std::move(value)) {}

AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kValue)>,
    std::vector<::blink::AuctionConfig::AdKeywordReplacement> value)
    : value(std::move(value)) {}

void AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements::DestroyActive() {
  switch (tag_) {

    case Tag::kPromise:
      std::destroy_at(&data_.promise);
      break;
    case Tag::kValue:
      std::destroy_at(&data_.value);
      break;
  }
}

bool AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
AdAuctionRequestOrErrorPtr
AdAuctionRequestOrError::NewRequest(
    ::mojo_base::BigBuffer value) {
  return AdAuctionRequestOrErrorPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kRequest)>,
      std::move(value));
}

AdAuctionRequestOrErrorPtr
AdAuctionRequestOrError::NewError(
    const std::string& value) {
  return AdAuctionRequestOrErrorPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kError)>,
      std::move(value));
}

AdAuctionRequestOrError::AdAuctionRequestOrError(
    std::in_place_index_t<static_cast<size_t>(Tag::kRequest)>,
    ::mojo_base::BigBuffer value)
    : tag_(Tag::kRequest),
      data_(std::in_place_index<static_cast<size_t>(Tag::kRequest)>,
            std::move(value)) {}

AdAuctionRequestOrError::AdAuctionRequestOrError(
    std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
    const std::string& value)
    : tag_(Tag::kError),
      data_(std::in_place_index<static_cast<size_t>(Tag::kError)>,
            std::move(value)) {}
AdAuctionRequestOrError::~AdAuctionRequestOrError() {
  DestroyActive();
}

void AdAuctionRequestOrError::set_request(::mojo_base::BigBuffer request) {
  if (tag_ == Tag::kRequest) {
    data_.request = std::move(request);
  } else {
    DestroyActive();
    tag_ = Tag::kRequest;
    new (&data_.request) ::mojo_base::BigBuffer(
        std::move(request));
  }
}

void AdAuctionRequestOrError::set_error(const std::string& error) {
  if (tag_ == Tag::kError) {
    data_.error = std::move(error);
  } else {
    DestroyActive();
    tag_ = Tag::kError;
    new (&data_.error) std::string(
        std::move(error));
  }
}


AdAuctionRequestOrError::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kRequest)>,
    ::mojo_base::BigBuffer value)
    : request(std::move(value)) {}

AdAuctionRequestOrError::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
    const std::string& value)
    : error(std::move(value)) {}

void AdAuctionRequestOrError::DestroyActive() {
  switch (tag_) {

    case Tag::kRequest:
      std::destroy_at(&data_.request);
      break;
    case Tag::kError:
      std::destroy_at(&data_.error);
      break;
  }
}

bool AdAuctionRequestOrError::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}


}  // blink::mojom


namespace mojo {


// static
bool StructTraits<::blink::mojom::InterestGroupAd::DataView, ::blink::mojom::InterestGroupAdPtr>::Read(
    ::blink::mojom::InterestGroupAd::DataView input,
    ::blink::mojom::InterestGroupAdPtr* output) {
  bool success = true;
  ::blink::mojom::InterestGroupAdPtr result(::blink::mojom::InterestGroupAd::New());
  
      if (success && !input.ReadRenderUrl(&result->render_url))
        success = false;
      if (success && !input.ReadSizeGroup(&result->size_group))
        success = false;
      if (success && !input.ReadBuyerReportingId(&result->buyer_reporting_id))
        success = false;
      if (success && !input.ReadBuyerAndSellerReportingId(&result->buyer_and_seller_reporting_id))
        success = false;
      if (success && !input.ReadSelectableBuyerAndSellerReportingIds(&result->selectable_buyer_and_seller_reporting_ids))
        success = false;
      if (success && !input.ReadMetadata(&result->metadata))
        success = false;
      if (success && !input.ReadAdRenderId(&result->ad_render_id))
        success = false;
      if (success && !input.ReadAllowedReportingOrigins(&result->allowed_reporting_origins))
        success = false;
      if (success && !input.ReadCreativeScanningMetadata(&result->creative_scanning_metadata))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::SellerCapabilities::DataView, ::blink::mojom::SellerCapabilitiesPtr>::Read(
    ::blink::mojom::SellerCapabilities::DataView input,
    ::blink::mojom::SellerCapabilitiesPtr* output) {
  bool success = true;
  ::blink::mojom::SellerCapabilitiesPtr result(::blink::mojom::SellerCapabilities::New());
  
      if (success)
        result->allows_interest_group_counts = input.allows_interest_group_counts();
      if (success)
        result->allows_latency_stats = input.allows_latency_stats();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::AuctionServerRequestFlags::DataView, ::blink::mojom::AuctionServerRequestFlagsPtr>::Read(
    ::blink::mojom::AuctionServerRequestFlags::DataView input,
    ::blink::mojom::AuctionServerRequestFlagsPtr* output) {
  bool success = true;
  ::blink::mojom::AuctionServerRequestFlagsPtr result(::blink::mojom::AuctionServerRequestFlags::New());
  
      if (success)
        result->omit_ads = input.omit_ads();
      if (success)
        result->include_full_ads = input.include_full_ads();
      if (success)
        result->omit_user_bidding_signals = input.omit_user_bidding_signals();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::AdKeywordReplacement::DataView, ::blink::mojom::AdKeywordReplacementPtr>::Read(
    ::blink::mojom::AdKeywordReplacement::DataView input,
    ::blink::mojom::AdKeywordReplacementPtr* output) {
  bool success = true;
  ::blink::mojom::AdKeywordReplacementPtr result(::blink::mojom::AdKeywordReplacement::New());
  
      if (success && !input.ReadMatch(&result->match))
        success = false;
      if (success && !input.ReadReplacement(&result->replacement))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::InterestGroup::DataView, ::blink::mojom::InterestGroupPtr>::Read(
    ::blink::mojom::InterestGroup::DataView input,
    ::blink::mojom::InterestGroupPtr* output) {
  bool success = true;
  ::blink::mojom::InterestGroupPtr result(::blink::mojom::InterestGroup::New());
  
      if (success && !input.ReadExpiry(&result->expiry))
        success = false;
      if (success && !input.ReadOwner(&result->owner))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success)
        result->priority = input.priority();
      if (success)
        result->enable_bidding_signals_prioritization = input.enable_bidding_signals_prioritization();
      if (success && !input.ReadPriorityVector(&result->priority_vector))
        success = false;
      if (success && !input.ReadPrioritySignalsOverrides(&result->priority_signals_overrides))
        success = false;
      if (success && !input.ReadSellerCapabilities(&result->seller_capabilities))
        success = false;
      if (success && !input.ReadAllSellersCapabilities(&result->all_sellers_capabilities))
        success = false;
      if (success && !input.ReadExecutionMode(&result->execution_mode))
        success = false;
      if (success && !input.ReadTrustedBiddingSignalsSlotSizeMode(&result->trusted_bidding_signals_slot_size_mode))
        success = false;
      if (success && !input.ReadBiddingUrl(&result->bidding_url))
        success = false;
      if (success && !input.ReadBiddingWasmHelperUrl(&result->bidding_wasm_helper_url))
        success = false;
      if (success && !input.ReadUpdateUrl(&result->update_url))
        success = false;
      if (success && !input.ReadTrustedBiddingSignalsUrl(&result->trusted_bidding_signals_url))
        success = false;
      if (success && !input.ReadTrustedBiddingSignalsKeys(&result->trusted_bidding_signals_keys))
        success = false;
      if (success)
        result->max_trusted_bidding_signals_url_length = input.max_trusted_bidding_signals_url_length();
      if (success && !input.ReadTrustedBiddingSignalsCoordinator(&result->trusted_bidding_signals_coordinator))
        success = false;
      if (success && !input.ReadViewAndClickCountsProviders(&result->view_and_click_counts_providers))
        success = false;
      if (success && !input.ReadUserBiddingSignals(&result->user_bidding_signals))
        success = false;
      if (success && !input.ReadAds(&result->ads))
        success = false;
      if (success && !input.ReadAdComponents(&result->ad_components))
        success = false;
      if (success && !input.ReadAdSizes(&result->ad_sizes))
        success = false;
      if (success && !input.ReadSizeGroups(&result->size_groups))
        success = false;
      if (success && !input.ReadAuctionServerRequestFlags(&result->auction_server_request_flags))
        success = false;
      if (success && !input.ReadAdditionalBidKey(&result->additional_bid_key))
        success = false;
      if (success && !input.ReadAggregationCoordinatorOrigin(&result->aggregation_coordinator_origin))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::PreviousWin::DataView, ::blink::mojom::PreviousWinPtr>::Read(
    ::blink::mojom::PreviousWin::DataView input,
    ::blink::mojom::PreviousWinPtr* output) {
  bool success = true;
  ::blink::mojom::PreviousWinPtr result(::blink::mojom::PreviousWin::New());
  
      if (success && !input.ReadTime(&result->time))
        success = false;
      if (success && !input.ReadAdJson(&result->ad_json))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ViewOrClickCounts::DataView, ::blink::mojom::ViewOrClickCountsPtr>::Read(
    ::blink::mojom::ViewOrClickCounts::DataView input,
    ::blink::mojom::ViewOrClickCountsPtr* output) {
  bool success = true;
  ::blink::mojom::ViewOrClickCountsPtr result(::blink::mojom::ViewOrClickCounts::New());
  
      if (success)
        result->past_hour = input.past_hour();
      if (success)
        result->past_day = input.past_day();
      if (success)
        result->past_week = input.past_week();
      if (success)
        result->past_30_days = input.past_30_days();
      if (success)
        result->past_90_days = input.past_90_days();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ViewAndClickCounts::DataView, ::blink::mojom::ViewAndClickCountsPtr>::Read(
    ::blink::mojom::ViewAndClickCounts::DataView input,
    ::blink::mojom::ViewAndClickCountsPtr* output) {
  bool success = true;
  ::blink::mojom::ViewAndClickCountsPtr result(::blink::mojom::ViewAndClickCounts::New());
  
      if (success && !input.ReadViewCounts(&result->view_counts))
        success = false;
      if (success && !input.ReadClickCounts(&result->click_counts))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::BiddingBrowserSignals::DataView, ::blink::mojom::BiddingBrowserSignalsPtr>::Read(
    ::blink::mojom::BiddingBrowserSignals::DataView input,
    ::blink::mojom::BiddingBrowserSignalsPtr* output) {
  bool success = true;
  ::blink::mojom::BiddingBrowserSignalsPtr result(::blink::mojom::BiddingBrowserSignals::New());
  
      if (success)
        result->join_count = input.join_count();
      if (success)
        result->bid_count = input.bid_count();
      if (success && !input.ReadPrevWins(&result->prev_wins))
        success = false;
      if (success)
        result->for_debugging_only_in_cooldown_or_lockout = input.for_debugging_only_in_cooldown_or_lockout();
      if (success && !input.ReadViewAndClickCounts(&result->view_and_click_counts))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::StorageInterestGroup::DataView, ::blink::mojom::StorageInterestGroupPtr>::Read(
    ::blink::mojom::StorageInterestGroup::DataView input,
    ::blink::mojom::StorageInterestGroupPtr* output) {
  bool success = true;
  ::blink::mojom::StorageInterestGroupPtr result(::blink::mojom::StorageInterestGroup::New());
  
      if (success && !input.ReadInterestGroup(&result->interest_group))
        success = false;
      if (success && !input.ReadBiddingBrowserSignals(&result->bidding_browser_signals))
        success = false;
      if (success && !input.ReadJoiningOrigin(&result->joining_origin))
        success = false;
      if (success && !input.ReadJoinTime(&result->join_time))
        success = false;
      if (success && !input.ReadLastUpdated(&result->last_updated))
        success = false;
      if (success && !input.ReadNextUpdateAfter(&result->next_update_after))
        success = false;
      if (success)
        result->estimated_size = input.estimated_size();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::DirectFromSellerSignalsSubresource::DataView, ::blink::mojom::DirectFromSellerSignalsSubresourcePtr>::Read(
    ::blink::mojom::DirectFromSellerSignalsSubresource::DataView input,
    ::blink::mojom::DirectFromSellerSignalsSubresourcePtr* output) {
  bool success = true;
  ::blink::mojom::DirectFromSellerSignalsSubresourcePtr result(::blink::mojom::DirectFromSellerSignalsSubresource::New());
  
      if (success && !input.ReadBundleUrl(&result->bundle_url))
        success = false;
      if (success && !input.ReadToken(&result->token))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::DirectFromSellerSignals::DataView, ::blink::mojom::DirectFromSellerSignalsPtr>::Read(
    ::blink::mojom::DirectFromSellerSignals::DataView input,
    ::blink::mojom::DirectFromSellerSignalsPtr* output) {
  bool success = true;
  ::blink::mojom::DirectFromSellerSignalsPtr result(::blink::mojom::DirectFromSellerSignals::New());
  
      if (success && !input.ReadPrefix(&result->prefix))
        success = false;
      if (success && !input.ReadPerBuyerSignals(&result->per_buyer_signals))
        success = false;
      if (success && !input.ReadSellerSignals(&result->seller_signals))
        success = false;
      if (success && !input.ReadAuctionSignals(&result->auction_signals))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::AuctionAdConfigBuyerTimeouts::DataView, ::blink::mojom::AuctionAdConfigBuyerTimeoutsPtr>::Read(
    ::blink::mojom::AuctionAdConfigBuyerTimeouts::DataView input,
    ::blink::mojom::AuctionAdConfigBuyerTimeoutsPtr* output) {
  bool success = true;
  ::blink::mojom::AuctionAdConfigBuyerTimeoutsPtr result(::blink::mojom::AuctionAdConfigBuyerTimeouts::New());
  
      if (success && !input.ReadAllBuyersTimeout(&result->all_buyers_timeout))
        success = false;
      if (success && !input.ReadPerBuyerTimeouts(&result->per_buyer_timeouts))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::AdCurrency::DataView, ::blink::mojom::AdCurrencyPtr>::Read(
    ::blink::mojom::AdCurrency::DataView input,
    ::blink::mojom::AdCurrencyPtr* output) {
  bool success = true;
  ::blink::mojom::AdCurrencyPtr result(::blink::mojom::AdCurrency::New());
  
      if (success && !input.ReadCurrencyCode(&result->currency_code))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::AuctionAdConfigBuyerCurrencies::DataView, ::blink::mojom::AuctionAdConfigBuyerCurrenciesPtr>::Read(
    ::blink::mojom::AuctionAdConfigBuyerCurrencies::DataView input,
    ::blink::mojom::AuctionAdConfigBuyerCurrenciesPtr* output) {
  bool success = true;
  ::blink::mojom::AuctionAdConfigBuyerCurrenciesPtr result(::blink::mojom::AuctionAdConfigBuyerCurrencies::New());
  
      if (success && !input.ReadAllBuyersCurrency(&result->all_buyers_currency))
        success = false;
      if (success && !input.ReadPerBuyerCurrencies(&result->per_buyer_currencies))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::AuctionAdServerResponseConfig::DataView, ::blink::mojom::AuctionAdServerResponseConfigPtr>::Read(
    ::blink::mojom::AuctionAdServerResponseConfig::DataView input,
    ::blink::mojom::AuctionAdServerResponseConfigPtr* output) {
  bool success = true;
  ::blink::mojom::AuctionAdServerResponseConfigPtr result(::blink::mojom::AuctionAdServerResponseConfig::New());
  
      if (success && !input.ReadRequestId(&result->request_id))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::AuctionReportBuyerDebugModeConfig::DataView, ::blink::mojom::AuctionReportBuyerDebugModeConfigPtr>::Read(
    ::blink::mojom::AuctionReportBuyerDebugModeConfig::DataView input,
    ::blink::mojom::AuctionReportBuyerDebugModeConfigPtr* output) {
  bool success = true;
  ::blink::mojom::AuctionReportBuyerDebugModeConfigPtr result(::blink::mojom::AuctionReportBuyerDebugModeConfig::New());
  
      if (success)
        result->is_enabled = input.is_enabled();
      if (success) {
        result->debug_key = input.debug_key();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::AuctionReportBuyersConfig::DataView, ::blink::mojom::AuctionReportBuyersConfigPtr>::Read(
    ::blink::mojom::AuctionReportBuyersConfig::DataView input,
    ::blink::mojom::AuctionReportBuyersConfigPtr* output) {
  bool success = true;
  ::blink::mojom::AuctionReportBuyersConfigPtr result(::blink::mojom::AuctionReportBuyersConfig::New());
  
      if (success && !input.ReadBucket(&result->bucket))
        success = false;
      if (success)
        result->scale = input.scale();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::AuctionAdConfigNonSharedParams::DataView, ::blink::mojom::AuctionAdConfigNonSharedParamsPtr>::Read(
    ::blink::mojom::AuctionAdConfigNonSharedParams::DataView input,
    ::blink::mojom::AuctionAdConfigNonSharedParamsPtr* output) {
  bool success = true;
  ::blink::mojom::AuctionAdConfigNonSharedParamsPtr result(::blink::mojom::AuctionAdConfigNonSharedParams::New());
  
      if (success && !input.ReadInterestGroupBuyers(&result->interest_group_buyers))
        success = false;
      if (success && !input.ReadAuctionSignals(&result->auction_signals))
        success = false;
      if (success && !input.ReadSellerSignals(&result->seller_signals))
        success = false;
      if (success && !input.ReadSellerTkvSignals(&result->seller_tkv_signals))
        success = false;
      if (success && !input.ReadSellerTimeout(&result->seller_timeout))
        success = false;
      if (success && !input.ReadPerBuyerSignals(&result->per_buyer_signals))
        success = false;
      if (success && !input.ReadPerBuyerTkvSignals(&result->per_buyer_tkv_signals))
        success = false;
      if (success && !input.ReadBuyerTimeouts(&result->buyer_timeouts))
        success = false;
      if (success && !input.ReadReportingTimeout(&result->reporting_timeout))
        success = false;
      if (success && !input.ReadSellerCurrency(&result->seller_currency))
        success = false;
      if (success && !input.ReadBuyerCurrencies(&result->buyer_currencies))
        success = false;
      if (success && !input.ReadBuyerCumulativeTimeouts(&result->buyer_cumulative_timeouts))
        success = false;
      if (success && !input.ReadPerBuyerGroupLimits(&result->per_buyer_group_limits))
        success = false;
      if (success && !input.ReadPerBuyerPrioritySignals(&result->per_buyer_priority_signals))
        success = false;
      if (success && !input.ReadAllBuyersPrioritySignals(&result->all_buyers_priority_signals))
        success = false;
      if (success)
        result->all_buyers_group_limit = input.all_buyers_group_limit();
      if (success && !input.ReadAuctionReportBuyerKeys(&result->auction_report_buyer_keys))
        success = false;
      if (success && !input.ReadAuctionReportBuyers(&result->auction_report_buyers))
        success = false;
      if (success && !input.ReadAuctionReportBuyerDebugModeConfig(&result->auction_report_buyer_debug_mode_config))
        success = false;
      if (success && !input.ReadRequiredSellerCapabilities(&result->required_seller_capabilities))
        success = false;
      if (success && !input.ReadRequestedSize(&result->requested_size))
        success = false;
      if (success && !input.ReadAllSlotsRequestedSizes(&result->all_slots_requested_sizes))
        success = false;
      if (success && !input.ReadPerBuyerMultiBidLimits(&result->per_buyer_multi_bid_limits))
        success = false;
      if (success)
        result->all_buyers_multi_bid_limit = input.all_buyers_multi_bid_limit();
      if (success && !input.ReadAuctionNonce(&result->auction_nonce))
        success = false;
      if (success && !input.ReadSellerRealTimeReportingType(&result->seller_real_time_reporting_type)) {
        success = false;
      }
      if (success && !input.ReadPerBuyerRealTimeReportingTypes(&result->per_buyer_real_time_reporting_types))
        success = false;
      if (success && !input.ReadComponentAuctions(&result->component_auctions))
        success = false;
      if (success && !input.ReadDeprecatedRenderUrlReplacements(&result->deprecated_render_url_replacements))
        success = false;
      if (success)
        result->max_trusted_scoring_signals_url_length = input.max_trusted_scoring_signals_url_length();
      if (success && !input.ReadTrustedScoringSignalsCoordinator(&result->trusted_scoring_signals_coordinator))
        success = false;
      if (success && !input.ReadExecutionMode(&result->execution_mode))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::AuctionAdConfig::DataView, ::blink::mojom::AuctionAdConfigPtr>::Read(
    ::blink::mojom::AuctionAdConfig::DataView input,
    ::blink::mojom::AuctionAdConfigPtr* output) {
  bool success = true;
  ::blink::mojom::AuctionAdConfigPtr result(::blink::mojom::AuctionAdConfig::New());
  
      if (success && !input.ReadSeller(&result->seller))
        success = false;
      if (success && !input.ReadServerResponse(&result->server_response))
        success = false;
      if (success && !input.ReadDecisionLogicUrl(&result->decision_logic_url))
        success = false;
      if (success && !input.ReadTrustedScoringSignalsUrl(&result->trusted_scoring_signals_url))
        success = false;
      if (success && !input.ReadAuctionAdConfigNonSharedParams(&result->auction_ad_config_non_shared_params))
        success = false;
      if (success && !input.ReadDirectFromSellerSignals(&result->direct_from_seller_signals))
        success = false;
      if (success)
        result->expects_direct_from_seller_signals_header_ad_slot = input.expects_direct_from_seller_signals_header_ad_slot();
      if (success) {
        result->seller_experiment_group_id = input.seller_experiment_group_id();
      }
      if (success) {
        result->all_buyer_experiment_group_id = input.all_buyer_experiment_group_id();
      }
      if (success && !input.ReadPerBuyerExperimentGroupIds(&result->per_buyer_experiment_group_ids))
        success = false;
      if (success)
        result->expects_additional_bids = input.expects_additional_bids();
      if (success && !input.ReadAggregationCoordinatorOrigin(&result->aggregation_coordinator_origin))
        success = false;
      if (success) {
        result->send_creative_scanning_metadata = input.send_creative_scanning_metadata();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::AuctionDataBuyerConfig::DataView, ::blink::mojom::AuctionDataBuyerConfigPtr>::Read(
    ::blink::mojom::AuctionDataBuyerConfig::DataView input,
    ::blink::mojom::AuctionDataBuyerConfigPtr* output) {
  bool success = true;
  ::blink::mojom::AuctionDataBuyerConfigPtr result(::blink::mojom::AuctionDataBuyerConfig::New());
  
      if (success) {
        result->target_size = input.target_size();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::AuctionDataConfig::DataView, ::blink::mojom::AuctionDataConfigPtr>::Read(
    ::blink::mojom::AuctionDataConfig::DataView input,
    ::blink::mojom::AuctionDataConfigPtr* output) {
  bool success = true;
  ::blink::mojom::AuctionDataConfigPtr result(::blink::mojom::AuctionDataConfig::New());
  
      if (success && !input.ReadPerBuyerConfigs(&result->per_buyer_configs))
        success = false;
      if (success) {
        result->request_size = input.request_size();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::AdAuctionPerSellerRequest::DataView, ::blink::mojom::AdAuctionPerSellerRequestPtr>::Read(
    ::blink::mojom::AdAuctionPerSellerRequest::DataView input,
    ::blink::mojom::AdAuctionPerSellerRequestPtr* output) {
  bool success = true;
  ::blink::mojom::AdAuctionPerSellerRequestPtr result(::blink::mojom::AdAuctionPerSellerRequest::New());
  
      if (success && !input.ReadSeller(&result->seller))
        success = false;
      if (success && !input.ReadData(&result->data))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::blink::mojom::AuctionAdConfigMaybePromiseJson::DataView, ::blink::mojom::AuctionAdConfigMaybePromiseJsonPtr>::Read(
    ::blink::mojom::AuctionAdConfigMaybePromiseJson::DataView input,
    ::blink::mojom::AuctionAdConfigMaybePromiseJsonPtr* output) {
  using UnionType = ::blink::mojom::AuctionAdConfigMaybePromiseJson;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kPromise: {
      *output = UnionType::NewPromise(input.promise());
      break;
    }
    case Tag::kValue: {
      std::optional<std::string> result_value{};
      if (!input.ReadValue(&result_value))
        return false;

      *output = UnionType::NewValue(
          std::move(result_value));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::blink::mojom::AuctionAdConfigMaybePromisePerBuyerSignals::DataView, ::blink::mojom::AuctionAdConfigMaybePromisePerBuyerSignalsPtr>::Read(
    ::blink::mojom::AuctionAdConfigMaybePromisePerBuyerSignals::DataView input,
    ::blink::mojom::AuctionAdConfigMaybePromisePerBuyerSignalsPtr* output) {
  using UnionType = ::blink::mojom::AuctionAdConfigMaybePromisePerBuyerSignals;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kPromise: {
      *output = UnionType::NewPromise(input.promise());
      break;
    }
    case Tag::kValue: {
      std::optional<base::flat_map<::url::Origin, std::string>> result_value{};
      if (!input.ReadValue(&result_value))
        return false;

      *output = UnionType::NewValue(
          std::move(result_value));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::blink::mojom::AuctionAdConfigMaybePromiseBuyerTimeouts::DataView, ::blink::mojom::AuctionAdConfigMaybePromiseBuyerTimeoutsPtr>::Read(
    ::blink::mojom::AuctionAdConfigMaybePromiseBuyerTimeouts::DataView input,
    ::blink::mojom::AuctionAdConfigMaybePromiseBuyerTimeoutsPtr* output) {
  using UnionType = ::blink::mojom::AuctionAdConfigMaybePromiseBuyerTimeouts;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kPromise: {
      *output = UnionType::NewPromise(input.promise());
      break;
    }
    case Tag::kValue: {
      ::blink::AuctionConfig::BuyerTimeouts result_value{};
      if (!input.ReadValue(&result_value))
        return false;

      *output = UnionType::NewValue(
          std::move(result_value));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::blink::mojom::AuctionAdConfigMaybePromiseBuyerCurrencies::DataView, ::blink::mojom::AuctionAdConfigMaybePromiseBuyerCurrenciesPtr>::Read(
    ::blink::mojom::AuctionAdConfigMaybePromiseBuyerCurrencies::DataView input,
    ::blink::mojom::AuctionAdConfigMaybePromiseBuyerCurrenciesPtr* output) {
  using UnionType = ::blink::mojom::AuctionAdConfigMaybePromiseBuyerCurrencies;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kPromise: {
      *output = UnionType::NewPromise(input.promise());
      break;
    }
    case Tag::kValue: {
      ::blink::AuctionConfig::BuyerCurrencies result_value{};
      if (!input.ReadValue(&result_value))
        return false;

      *output = UnionType::NewValue(
          std::move(result_value));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::blink::mojom::AuctionAdConfigMaybePromiseDirectFromSellerSignals::DataView, ::blink::mojom::AuctionAdConfigMaybePromiseDirectFromSellerSignalsPtr>::Read(
    ::blink::mojom::AuctionAdConfigMaybePromiseDirectFromSellerSignals::DataView input,
    ::blink::mojom::AuctionAdConfigMaybePromiseDirectFromSellerSignalsPtr* output) {
  using UnionType = ::blink::mojom::AuctionAdConfigMaybePromiseDirectFromSellerSignals;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kPromise: {
      *output = UnionType::NewPromise(input.promise());
      break;
    }
    case Tag::kValue: {
      std::optional<::blink::DirectFromSellerSignals> result_value{};
      if (!input.ReadValue(&result_value))
        return false;

      *output = UnionType::NewValue(
          std::move(result_value));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::blink::mojom::AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements::DataView, ::blink::mojom::AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacementsPtr>::Read(
    ::blink::mojom::AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements::DataView input,
    ::blink::mojom::AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacementsPtr* output) {
  using UnionType = ::blink::mojom::AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kPromise: {
      *output = UnionType::NewPromise(input.promise());
      break;
    }
    case Tag::kValue: {
      std::vector<::blink::AuctionConfig::AdKeywordReplacement> result_value{};
      if (!input.ReadValue(&result_value))
        return false;

      *output = UnionType::NewValue(
          std::move(result_value));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::blink::mojom::AdAuctionRequestOrError::DataView, ::blink::mojom::AdAuctionRequestOrErrorPtr>::Read(
    ::blink::mojom::AdAuctionRequestOrError::DataView input,
    ::blink::mojom::AdAuctionRequestOrErrorPtr* output) {
  using UnionType = ::blink::mojom::AdAuctionRequestOrError;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kRequest: {
      ::mojo_base::BigBuffer result_request{};
      if (!input.ReadRequest(&result_request))
        return false;

      *output = UnionType::NewRequest(
          std::move(result_request));
      break;
    }
    case Tag::kError: {
      std::string result_error{};
      if (!input.ReadError(&result_error))
        return false;

      *output = UnionType::NewError(
          std::move(result_error));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {




}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif