// third_party/blink/public/mojom/installedapp/installed_app_provider.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/installedapp/installed_app_provider.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/installedapp/installed_app_provider.mojom-params-data.h"
#include "third_party/blink/public/mojom/installedapp/installed_app_provider.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/installedapp/installed_app_provider.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/installedapp/installed_app_provider.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
// The declaration includes the definition on other builds.

InstalledAppProvider::IPCStableHashFunction InstalledAppProvider::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::InstalledAppProvider>(message.name())) {
    case messages::InstalledAppProvider::kFilterInstalledApps: {
      return &InstalledAppProvider::FilterInstalledApps_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* InstalledAppProvider::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::InstalledAppProvider>(message.name())) {
      case messages::InstalledAppProvider::kFilterInstalledApps:
            return "Receive blink::mojom::InstalledAppProvider::FilterInstalledApps";
    }
  } else {
    switch (static_cast<messages::InstalledAppProvider>(message.name())) {
      case messages::InstalledAppProvider::kFilterInstalledApps:
            return "Receive reply blink::mojom::InstalledAppProvider::FilterInstalledApps";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t InstalledAppProvider::FilterInstalledApps_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1585444d;  // IPCStableHash for blink::mojom::InstalledAppProvider::FilterInstalledApps
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class InstalledAppProvider_FilterInstalledApps_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  InstalledAppProvider_FilterInstalledApps_ForwardToCallback(
      InstalledAppProvider::FilterInstalledAppsCallback callback
      ) : callback_(std::move(callback)) {
  }

  InstalledAppProvider_FilterInstalledApps_ForwardToCallback(const InstalledAppProvider_FilterInstalledApps_ForwardToCallback&) = delete;
  InstalledAppProvider_FilterInstalledApps_ForwardToCallback& operator=(const InstalledAppProvider_FilterInstalledApps_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  InstalledAppProvider::FilterInstalledAppsCallback callback_;
};

InstalledAppProviderProxy::InstalledAppProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void InstalledAppProviderProxy::FilterInstalledApps(
    ::blink::Vector<::blink::mojom::blink::RelatedApplicationPtr> in_related_apps, const ::blink::KURL& in_manifest_url, bool in_add_saved_related_applications, FilterInstalledAppsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::InstalledAppProvider::FilterInstalledApps", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("related_apps"), in_related_apps,
                        "<value of type ::blink::Vector<::blink::mojom::blink::RelatedApplicationPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("manifest_url"), in_manifest_url,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("add_saved_related_applications"), in_add_saved_related_applications,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::InstalledAppProvider::kFilterInstalledApps), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::InstalledAppProvider_FilterInstalledApps_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->related_apps)::BaseType>
      related_apps_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& related_apps_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::RelatedApplicationDataView>>(
    in_related_apps,
    related_apps_fragment,
    &related_apps_validate_params);

  params->related_apps.Set(
      related_apps_fragment.is_null() ? nullptr : related_apps_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->related_apps.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null related_apps in InstalledAppProvider.FilterInstalledApps request");
  mojo::internal::MessageFragment<
      typename decltype(params->manifest_url)::BaseType> manifest_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_manifest_url,
    manifest_url_fragment);

  params->manifest_url.Set(
      manifest_url_fragment.is_null() ? nullptr : manifest_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->manifest_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null manifest_url in InstalledAppProvider.FilterInstalledApps request");

  params->add_saved_related_applications = in_add_saved_related_applications;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(InstalledAppProvider::Name_);
  message.set_method_name("FilterInstalledApps");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new InstalledAppProvider_FilterInstalledApps_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class InstalledAppProvider_FilterInstalledApps_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static InstalledAppProvider::FilterInstalledAppsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<InstalledAppProvider_FilterInstalledApps_ProxyToResponder> proxy(
        new InstalledAppProvider_FilterInstalledApps_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&InstalledAppProvider_FilterInstalledApps_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~InstalledAppProvider_FilterInstalledApps_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  InstalledAppProvider_FilterInstalledApps_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "InstalledAppProvider::FilterInstalledAppsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::Vector<::blink::mojom::blink::RelatedApplicationPtr> in_installed_apps);
};

bool InstalledAppProvider_FilterInstalledApps_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::InstalledAppProvider_FilterInstalledApps_ResponseParams_Data* params =
      reinterpret_cast<
          internal::InstalledAppProvider_FilterInstalledApps_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for InstalledAppProvider.0
  bool success = true;
  ::blink::Vector<::blink::mojom::blink::RelatedApplicationPtr> p_installed_apps{};
  InstalledAppProvider_FilterInstalledApps_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadInstalledApps(&p_installed_apps))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        InstalledAppProvider::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_installed_apps));
  }
  return true;
}

void InstalledAppProvider_FilterInstalledApps_ProxyToResponder::Run(
    ::blink::Vector<::blink::mojom::blink::RelatedApplicationPtr> in_installed_apps) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::InstalledAppProvider::FilterInstalledApps", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("installed_apps"), in_installed_apps,
                        "<value of type ::blink::Vector<::blink::mojom::blink::RelatedApplicationPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::InstalledAppProvider::kFilterInstalledApps), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::InstalledAppProvider_FilterInstalledApps_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->installed_apps)::BaseType>
      installed_apps_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& installed_apps_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::RelatedApplicationDataView>>(
    in_installed_apps,
    installed_apps_fragment,
    &installed_apps_validate_params);

  params->installed_apps.Set(
      installed_apps_fragment.is_null() ? nullptr : installed_apps_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->installed_apps.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null installed_apps in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(InstalledAppProvider::Name_);
  message.set_method_name("FilterInstalledApps");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool InstalledAppProviderStubDispatch::Accept(
    InstalledAppProvider* impl,
    mojo::Message* message) {
  switch (static_cast<messages::InstalledAppProvider>(message->header()->name)) {
    case messages::InstalledAppProvider::kFilterInstalledApps: {
      break;
    }
  }
  return false;
}

// static
bool InstalledAppProviderStubDispatch::AcceptWithResponder(
    InstalledAppProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::InstalledAppProvider>(message->header()->name)) {
    case messages::InstalledAppProvider::kFilterInstalledApps: {
      internal::InstalledAppProvider_FilterInstalledApps_Params_Data* params =
          reinterpret_cast<
              internal::InstalledAppProvider_FilterInstalledApps_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for InstalledAppProvider.0
      bool success = true;
      ::blink::Vector<::blink::mojom::blink::RelatedApplicationPtr> p_related_apps{};
      ::blink::KURL p_manifest_url{};
      bool p_add_saved_related_applications{};
      InstalledAppProvider_FilterInstalledApps_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRelatedApps(&p_related_apps))
        success = false;
      if (success && !input_data_view.ReadManifestUrl(&p_manifest_url))
        success = false;
      if (success)
        p_add_saved_related_applications = input_data_view.add_saved_related_applications();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            InstalledAppProvider::Name_, 0, false);
        return false;
      }
      auto callback =
          InstalledAppProvider_FilterInstalledApps_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FilterInstalledApps(        
        std::move(p_related_apps), 
        std::move(p_manifest_url), 
        std::move(p_add_saved_related_applications), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kInstalledAppProviderValidationInfo[] = {
    { &internal::InstalledAppProvider_FilterInstalledApps_Params_Data::Validate,
     &internal::InstalledAppProvider_FilterInstalledApps_ResponseParams_Data::Validate},
};

bool InstalledAppProviderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::InstalledAppProvider::Name_,
    kInstalledAppProviderValidationInfo);
}

bool InstalledAppProviderResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::InstalledAppProvider::Name_,
    kInstalledAppProviderValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void InstalledAppProviderInterceptorForTesting::FilterInstalledApps(::blink::Vector<::blink::mojom::blink::RelatedApplicationPtr> related_apps, const ::blink::KURL& manifest_url, bool add_saved_related_applications, FilterInstalledAppsCallback callback) {
  GetForwardingInterface()->FilterInstalledApps(
    std::move(related_apps)
    , 
    std::move(manifest_url)
    , 
    std::move(add_saved_related_applications)
    , std::move(callback));
}
InstalledAppProviderAsyncWaiter::InstalledAppProviderAsyncWaiter(
    InstalledAppProvider* proxy) : proxy_(proxy) {}

InstalledAppProviderAsyncWaiter::~InstalledAppProviderAsyncWaiter() = default;


void InstalledAppProviderAsyncWaiter::FilterInstalledApps(
    ::blink::Vector<::blink::mojom::blink::RelatedApplicationPtr> related_apps, const ::blink::KURL& manifest_url, bool add_saved_related_applications, ::blink::Vector<::blink::mojom::blink::RelatedApplicationPtr>* out_installed_apps) {
  base::RunLoop loop;
  proxy_->FilterInstalledApps(
      std::move(related_apps),
      std::move(manifest_url),
      std::move(add_saved_related_applications),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::Vector<::blink::mojom::blink::RelatedApplicationPtr>* out_installed_apps
,
             ::blink::Vector<::blink::mojom::blink::RelatedApplicationPtr> installed_apps) {*out_installed_apps = std::move(installed_apps);
            loop->Quit();
          },
          &loop,
          out_installed_apps));
  loop.Run();
}

::blink::Vector<::blink::mojom::blink::RelatedApplicationPtr> InstalledAppProviderAsyncWaiter::FilterInstalledApps(
    ::blink::Vector<::blink::mojom::blink::RelatedApplicationPtr> related_apps, const ::blink::KURL& manifest_url, bool add_saved_related_applications) {
  ::blink::Vector<::blink::mojom::blink::RelatedApplicationPtr> async_wait_result;
  FilterInstalledApps(std::move(related_apps),std::move(manifest_url),std::move(add_saved_related_applications),&async_wait_result);
  return async_wait_result;
}






}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif