// third_party/blink/public/mojom/input/text_input_host.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/input/text_input_host.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/input/text_input_host.mojom-params-data.h"
#include "third_party/blink/public/mojom/input/text_input_host.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/input/text_input_host.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/input/text_input_host.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
// The declaration includes the definition on other builds.

TextInputHost::IPCStableHashFunction TextInputHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::TextInputHost>(message.name())) {
    case messages::TextInputHost::kGotCharacterIndexAtPoint: {
      return &TextInputHost::GotCharacterIndexAtPoint_Sym::IPCStableHash;
    }
    case messages::TextInputHost::kGotFirstRectForRange: {
      return &TextInputHost::GotFirstRectForRange_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* TextInputHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::TextInputHost>(message.name())) {
      case messages::TextInputHost::kGotCharacterIndexAtPoint:
            return "Receive blink::mojom::TextInputHost::GotCharacterIndexAtPoint";
      case messages::TextInputHost::kGotFirstRectForRange:
            return "Receive blink::mojom::TextInputHost::GotFirstRectForRange";
    }
  } else {
    switch (static_cast<messages::TextInputHost>(message.name())) {
      case messages::TextInputHost::kGotCharacterIndexAtPoint:
            return "Receive reply blink::mojom::TextInputHost::GotCharacterIndexAtPoint";
      case messages::TextInputHost::kGotFirstRectForRange:
            return "Receive reply blink::mojom::TextInputHost::GotFirstRectForRange";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t TextInputHost::GotCharacterIndexAtPoint_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x13cf88dd;  // IPCStableHash for blink::mojom::TextInputHost::GotCharacterIndexAtPoint
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TextInputHost::GotFirstRectForRange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x41f15ef5;  // IPCStableHash for blink::mojom::TextInputHost::GotFirstRectForRange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

TextInputHostProxy::TextInputHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void TextInputHostProxy::GotCharacterIndexAtPoint(
    uint32_t in_index) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::TextInputHost::GotCharacterIndexAtPoint", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("index"), in_index,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextInputHost::kGotCharacterIndexAtPoint), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::TextInputHost_GotCharacterIndexAtPoint_Params_Data> params(
          message);
  params.Allocate();

  params->index = in_index;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextInputHost::Name_);
  message.set_method_name("GotCharacterIndexAtPoint");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void TextInputHostProxy::GotFirstRectForRange(
    const ::gfx::Rect& in_rect) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::TextInputHost::GotFirstRectForRange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("rect"), in_rect,
                        "<value of type const ::gfx::Rect&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextInputHost::kGotFirstRectForRange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::TextInputHost_GotFirstRectForRange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->rect)::BaseType> rect_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_rect,
    rect_fragment);

  params->rect.Set(
      rect_fragment.is_null() ? nullptr : rect_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->rect.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null rect in TextInputHost.GotFirstRectForRange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextInputHost::Name_);
  message.set_method_name("GotFirstRectForRange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool TextInputHostStubDispatch::Accept(
    TextInputHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::TextInputHost>(message->header()->name)) {
    case messages::TextInputHost::kGotCharacterIndexAtPoint: {
      DCHECK(message->is_serialized());
      internal::TextInputHost_GotCharacterIndexAtPoint_Params_Data* params =
          reinterpret_cast<internal::TextInputHost_GotCharacterIndexAtPoint_Params_Data*>(
              message->mutable_payload());
      

      // Validation for TextInputHost.0
      bool success = true;
      uint32_t p_index{};
      TextInputHost_GotCharacterIndexAtPoint_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_index = input_data_view.index();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextInputHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GotCharacterIndexAtPoint(        
        std::move(p_index));
      return true;
    }
    case messages::TextInputHost::kGotFirstRectForRange: {
      DCHECK(message->is_serialized());
      internal::TextInputHost_GotFirstRectForRange_Params_Data* params =
          reinterpret_cast<internal::TextInputHost_GotFirstRectForRange_Params_Data*>(
              message->mutable_payload());
      

      // Validation for TextInputHost.1
      bool success = true;
      ::gfx::Rect p_rect{};
      TextInputHost_GotFirstRectForRange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRect(&p_rect))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextInputHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GotFirstRectForRange(        
        std::move(p_rect));
      return true;
    }
  }
  return false;
}

// static
bool TextInputHostStubDispatch::AcceptWithResponder(
    TextInputHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::TextInputHost>(message->header()->name)) {
    case messages::TextInputHost::kGotCharacterIndexAtPoint: {
      break;
    }
    case messages::TextInputHost::kGotFirstRectForRange: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kTextInputHostValidationInfo[] = {
    { &internal::TextInputHost_GotCharacterIndexAtPoint_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::TextInputHost_GotFirstRectForRange_Params_Data::Validate,
     nullptr /* no response */},
};

bool TextInputHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::TextInputHost::Name_,
    kTextInputHostValidationInfo);
}



}  // blink::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void TextInputHostInterceptorForTesting::GotCharacterIndexAtPoint(uint32_t index) {
  GetForwardingInterface()->GotCharacterIndexAtPoint(
    std::move(index)
    );
}
void TextInputHostInterceptorForTesting::GotFirstRectForRange(const ::gfx::Rect& rect) {
  GetForwardingInterface()->GotFirstRectForRange(
    std::move(rect)
    );
}
TextInputHostAsyncWaiter::TextInputHostAsyncWaiter(
    TextInputHost* proxy) : proxy_(proxy) {}

TextInputHostAsyncWaiter::~TextInputHostAsyncWaiter() = default;







}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif