// third_party/blink/public/mojom/input/pointer_lock_context.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/input/pointer_lock_context.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/input/pointer_lock_context.mojom-params-data.h"
#include "third_party/blink/public/mojom/input/pointer_lock_context.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/input/pointer_lock_context.mojom-import-headers.h"
#include "third_party/blink/public/mojom/input/pointer_lock_context.mojom-test-utils.h"


namespace blink::mojom {
// The declaration includes the definition on other builds.

PointerLockContext::IPCStableHashFunction PointerLockContext::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PointerLockContext>(message.name())) {
    case messages::PointerLockContext::kRequestMouseLockChange: {
      return &PointerLockContext::RequestMouseLockChange_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PointerLockContext::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PointerLockContext>(message.name())) {
      case messages::PointerLockContext::kRequestMouseLockChange:
            return "Receive blink::mojom::PointerLockContext::RequestMouseLockChange";
    }
  } else {
    switch (static_cast<messages::PointerLockContext>(message.name())) {
      case messages::PointerLockContext::kRequestMouseLockChange:
            return "Receive reply blink::mojom::PointerLockContext::RequestMouseLockChange";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PointerLockContext::RequestMouseLockChange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xab074761;  // IPCStableHash for blink::mojom::PointerLockContext::RequestMouseLockChange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PointerLockContext_RequestMouseLockChange_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PointerLockContext_RequestMouseLockChange_ForwardToCallback(
      PointerLockContext::RequestMouseLockChangeCallback callback
      ) : callback_(std::move(callback)) {
  }

  PointerLockContext_RequestMouseLockChange_ForwardToCallback(const PointerLockContext_RequestMouseLockChange_ForwardToCallback&) = delete;
  PointerLockContext_RequestMouseLockChange_ForwardToCallback& operator=(const PointerLockContext_RequestMouseLockChange_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PointerLockContext::RequestMouseLockChangeCallback callback_;
};

PointerLockContextProxy::PointerLockContextProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PointerLockContextProxy::RequestMouseLockChange(
    bool in_unadjusted_movement, RequestMouseLockChangeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PointerLockContext::RequestMouseLockChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("unadjusted_movement"), in_unadjusted_movement,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PointerLockContext::kRequestMouseLockChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PointerLockContext_RequestMouseLockChange_Params_Data> params(
          message);
  params.Allocate();

  params->unadjusted_movement = in_unadjusted_movement;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PointerLockContext::Name_);
  message.set_method_name("RequestMouseLockChange");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PointerLockContext_RequestMouseLockChange_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class PointerLockContext_RequestMouseLockChange_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PointerLockContext::RequestMouseLockChangeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PointerLockContext_RequestMouseLockChange_ProxyToResponder> proxy(
        new PointerLockContext_RequestMouseLockChange_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PointerLockContext_RequestMouseLockChange_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PointerLockContext_RequestMouseLockChange_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PointerLockContext_RequestMouseLockChange_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PointerLockContext::RequestMouseLockChangeCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::PointerLockResult in_result);
};

bool PointerLockContext_RequestMouseLockChange_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PointerLockContext_RequestMouseLockChange_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PointerLockContext_RequestMouseLockChange_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PointerLockContext.0
  bool success = true;
  ::blink::mojom::PointerLockResult p_result{};
  PointerLockContext_RequestMouseLockChange_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PointerLockContext::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void PointerLockContext_RequestMouseLockChange_ProxyToResponder::Run(
    ::blink::mojom::PointerLockResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::PointerLockContext::RequestMouseLockChange", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::blink::mojom::PointerLockResult>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PointerLockContext::kRequestMouseLockChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PointerLockContext_RequestMouseLockChange_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::PointerLockResult>(
    in_result,
    &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PointerLockContext::Name_);
  message.set_method_name("RequestMouseLockChange");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PointerLockContextStubDispatch::Accept(
    PointerLockContext* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PointerLockContext>(message->header()->name)) {
    case messages::PointerLockContext::kRequestMouseLockChange: {
      break;
    }
  }
  return false;
}

// static
bool PointerLockContextStubDispatch::AcceptWithResponder(
    PointerLockContext* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PointerLockContext>(message->header()->name)) {
    case messages::PointerLockContext::kRequestMouseLockChange: {
      internal::PointerLockContext_RequestMouseLockChange_Params_Data* params =
          reinterpret_cast<
              internal::PointerLockContext_RequestMouseLockChange_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PointerLockContext.0
      bool success = true;
      bool p_unadjusted_movement{};
      PointerLockContext_RequestMouseLockChange_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_unadjusted_movement = input_data_view.unadjusted_movement();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PointerLockContext::Name_, 0, false);
        return false;
      }
      auto callback =
          PointerLockContext_RequestMouseLockChange_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestMouseLockChange(        
        std::move(p_unadjusted_movement), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPointerLockContextValidationInfo[] = {
    { &internal::PointerLockContext_RequestMouseLockChange_Params_Data::Validate,
     &internal::PointerLockContext_RequestMouseLockChange_ResponseParams_Data::Validate},
};

bool PointerLockContextRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::PointerLockContext::Name_,
    kPointerLockContextValidationInfo);
}

bool PointerLockContextResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::PointerLockContext::Name_,
    kPointerLockContextValidationInfo);
}


}  // blink::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void PointerLockContextInterceptorForTesting::RequestMouseLockChange(bool unadjusted_movement, RequestMouseLockChangeCallback callback) {
  GetForwardingInterface()->RequestMouseLockChange(
    std::move(unadjusted_movement)
    , std::move(callback));
}
PointerLockContextAsyncWaiter::PointerLockContextAsyncWaiter(
    PointerLockContext* proxy) : proxy_(proxy) {}

PointerLockContextAsyncWaiter::~PointerLockContextAsyncWaiter() = default;


void PointerLockContextAsyncWaiter::RequestMouseLockChange(
    bool unadjusted_movement, ::blink::mojom::PointerLockResult* out_result) {
  base::RunLoop loop;
  proxy_->RequestMouseLockChange(
      std::move(unadjusted_movement),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::PointerLockResult* out_result
,
             ::blink::mojom::PointerLockResult result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

::blink::mojom::PointerLockResult PointerLockContextAsyncWaiter::RequestMouseLockChange(
    bool unadjusted_movement) {
  ::blink::mojom::PointerLockResult async_wait_result;
  RequestMouseLockChange(std::move(unadjusted_movement),&async_wait_result);
  return async_wait_result;
}






}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif