// third_party/blink/public/mojom/input/pointer_lock_context.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_POINTER_LOCK_CONTEXT_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_POINTER_LOCK_CONTEXT_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/input/pointer_lock_context.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/input/pointer_lock_context.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/input/pointer_lock_context.mojom-blink-forward.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/input/pointer_lock_result.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {

class PointerLockContextProxy;

template <typename ImplRefTraits>
class PointerLockContextStub;

class PointerLockContextRequestValidator;
class PointerLockContextResponseValidator;


class PLATFORM_EXPORT PointerLockContext
    : public PointerLockContextInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.PointerLockContext";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PointerLockContextInterfaceBase;
  using Proxy_ = PointerLockContextProxy;

  template <typename ImplRefTraits>
  using Stub_ = PointerLockContextStub<ImplRefTraits>;

  using RequestValidator_ = PointerLockContextRequestValidator;
  using ResponseValidator_ = PointerLockContextResponseValidator;
  enum MethodMinVersions : uint32_t {
    kRequestMouseLockChangeMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct RequestMouseLockChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PointerLockContext() = default;

  using RequestMouseLockChangeCallback = base::OnceCallback<void(::blink::mojom::blink::PointerLockResult)>;
  using RequestMouseLockChangeMojoCallback = base::OnceCallback<void(::blink::mojom::blink::PointerLockResult)>;

  virtual void RequestMouseLockChange(bool unadjusted_movement, RequestMouseLockChangeCallback callback) = 0;
};



class PLATFORM_EXPORT PointerLockContextProxy
    : public PointerLockContext {
 public:
  using InterfaceType = PointerLockContext;

  explicit PointerLockContextProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RequestMouseLockChange(bool unadjusted_movement, RequestMouseLockChangeCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT PointerLockContextStubDispatch {
 public:
  static bool Accept(PointerLockContext* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PointerLockContext* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PointerLockContext>>
class PointerLockContextStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PointerLockContextStub() = default;
  ~PointerLockContextStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PointerLockContextStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PointerLockContextStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT PointerLockContextRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT PointerLockContextResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // blink::mojom::blink

namespace mojo {

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_POINTER_LOCK_CONTEXT_MOJOM_BLINK_H_