// third_party/blink/public/mojom/input/input_messages.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/input/input_messages.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/input/input_messages.mojom-params-data.h"
#include "third_party/blink/public/mojom/input/input_messages.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/input/input_messages.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/input/input_messages.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
// The declaration includes the definition on other builds.

TextSuggestionBackend::IPCStableHashFunction TextSuggestionBackend::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::TextSuggestionBackend>(message.name())) {
    case messages::TextSuggestionBackend::kApplySpellCheckSuggestion: {
      return &TextSuggestionBackend::ApplySpellCheckSuggestion_Sym::IPCStableHash;
    }
    case messages::TextSuggestionBackend::kApplyTextSuggestion: {
      return &TextSuggestionBackend::ApplyTextSuggestion_Sym::IPCStableHash;
    }
    case messages::TextSuggestionBackend::kDeleteActiveSuggestionRange: {
      return &TextSuggestionBackend::DeleteActiveSuggestionRange_Sym::IPCStableHash;
    }
    case messages::TextSuggestionBackend::kOnNewWordAddedToDictionary: {
      return &TextSuggestionBackend::OnNewWordAddedToDictionary_Sym::IPCStableHash;
    }
    case messages::TextSuggestionBackend::kOnSuggestionMenuClosed: {
      return &TextSuggestionBackend::OnSuggestionMenuClosed_Sym::IPCStableHash;
    }
    case messages::TextSuggestionBackend::kSuggestionMenuTimeoutCallback: {
      return &TextSuggestionBackend::SuggestionMenuTimeoutCallback_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* TextSuggestionBackend::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::TextSuggestionBackend>(message.name())) {
      case messages::TextSuggestionBackend::kApplySpellCheckSuggestion:
            return "Receive blink::mojom::TextSuggestionBackend::ApplySpellCheckSuggestion";
      case messages::TextSuggestionBackend::kApplyTextSuggestion:
            return "Receive blink::mojom::TextSuggestionBackend::ApplyTextSuggestion";
      case messages::TextSuggestionBackend::kDeleteActiveSuggestionRange:
            return "Receive blink::mojom::TextSuggestionBackend::DeleteActiveSuggestionRange";
      case messages::TextSuggestionBackend::kOnNewWordAddedToDictionary:
            return "Receive blink::mojom::TextSuggestionBackend::OnNewWordAddedToDictionary";
      case messages::TextSuggestionBackend::kOnSuggestionMenuClosed:
            return "Receive blink::mojom::TextSuggestionBackend::OnSuggestionMenuClosed";
      case messages::TextSuggestionBackend::kSuggestionMenuTimeoutCallback:
            return "Receive blink::mojom::TextSuggestionBackend::SuggestionMenuTimeoutCallback";
    }
  } else {
    switch (static_cast<messages::TextSuggestionBackend>(message.name())) {
      case messages::TextSuggestionBackend::kApplySpellCheckSuggestion:
            return "Receive reply blink::mojom::TextSuggestionBackend::ApplySpellCheckSuggestion";
      case messages::TextSuggestionBackend::kApplyTextSuggestion:
            return "Receive reply blink::mojom::TextSuggestionBackend::ApplyTextSuggestion";
      case messages::TextSuggestionBackend::kDeleteActiveSuggestionRange:
            return "Receive reply blink::mojom::TextSuggestionBackend::DeleteActiveSuggestionRange";
      case messages::TextSuggestionBackend::kOnNewWordAddedToDictionary:
            return "Receive reply blink::mojom::TextSuggestionBackend::OnNewWordAddedToDictionary";
      case messages::TextSuggestionBackend::kOnSuggestionMenuClosed:
            return "Receive reply blink::mojom::TextSuggestionBackend::OnSuggestionMenuClosed";
      case messages::TextSuggestionBackend::kSuggestionMenuTimeoutCallback:
            return "Receive reply blink::mojom::TextSuggestionBackend::SuggestionMenuTimeoutCallback";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t TextSuggestionBackend::ApplySpellCheckSuggestion_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x12072198;  // IPCStableHash for blink::mojom::TextSuggestionBackend::ApplySpellCheckSuggestion
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TextSuggestionBackend::ApplyTextSuggestion_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf70c5a3b;  // IPCStableHash for blink::mojom::TextSuggestionBackend::ApplyTextSuggestion
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TextSuggestionBackend::DeleteActiveSuggestionRange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5af0163d;  // IPCStableHash for blink::mojom::TextSuggestionBackend::DeleteActiveSuggestionRange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TextSuggestionBackend::OnNewWordAddedToDictionary_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3edf04e3;  // IPCStableHash for blink::mojom::TextSuggestionBackend::OnNewWordAddedToDictionary
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TextSuggestionBackend::OnSuggestionMenuClosed_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7cf54e43;  // IPCStableHash for blink::mojom::TextSuggestionBackend::OnSuggestionMenuClosed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TextSuggestionBackend::SuggestionMenuTimeoutCallback_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbec306a6;  // IPCStableHash for blink::mojom::TextSuggestionBackend::SuggestionMenuTimeoutCallback
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

TextSuggestionBackendProxy::TextSuggestionBackendProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void TextSuggestionBackendProxy::ApplySpellCheckSuggestion(
    const ::blink::String& in_suggestion) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::TextSuggestionBackend::ApplySpellCheckSuggestion", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("suggestion"), in_suggestion,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextSuggestionBackend::kApplySpellCheckSuggestion), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::TextSuggestionBackend_ApplySpellCheckSuggestion_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->suggestion)::BaseType> suggestion_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_suggestion,
    suggestion_fragment);

  params->suggestion.Set(
      suggestion_fragment.is_null() ? nullptr : suggestion_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->suggestion.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null suggestion in TextSuggestionBackend.ApplySpellCheckSuggestion request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextSuggestionBackend::Name_);
  message.set_method_name("ApplySpellCheckSuggestion");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void TextSuggestionBackendProxy::ApplyTextSuggestion(
    int32_t in_marker_tag, int32_t in_suggestion_index) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::TextSuggestionBackend::ApplyTextSuggestion", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("marker_tag"), in_marker_tag,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("suggestion_index"), in_suggestion_index,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextSuggestionBackend::kApplyTextSuggestion), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::TextSuggestionBackend_ApplyTextSuggestion_Params_Data> params(
          message);
  params.Allocate();

  params->marker_tag = in_marker_tag;

  params->suggestion_index = in_suggestion_index;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextSuggestionBackend::Name_);
  message.set_method_name("ApplyTextSuggestion");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void TextSuggestionBackendProxy::DeleteActiveSuggestionRange(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::TextSuggestionBackend::DeleteActiveSuggestionRange");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextSuggestionBackend::kDeleteActiveSuggestionRange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::TextSuggestionBackend_DeleteActiveSuggestionRange_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextSuggestionBackend::Name_);
  message.set_method_name("DeleteActiveSuggestionRange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void TextSuggestionBackendProxy::OnNewWordAddedToDictionary(
    const ::blink::String& in_suggestion) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::TextSuggestionBackend::OnNewWordAddedToDictionary", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("suggestion"), in_suggestion,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextSuggestionBackend::kOnNewWordAddedToDictionary), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::TextSuggestionBackend_OnNewWordAddedToDictionary_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->suggestion)::BaseType> suggestion_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_suggestion,
    suggestion_fragment);

  params->suggestion.Set(
      suggestion_fragment.is_null() ? nullptr : suggestion_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->suggestion.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null suggestion in TextSuggestionBackend.OnNewWordAddedToDictionary request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextSuggestionBackend::Name_);
  message.set_method_name("OnNewWordAddedToDictionary");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void TextSuggestionBackendProxy::OnSuggestionMenuClosed(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::TextSuggestionBackend::OnSuggestionMenuClosed");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextSuggestionBackend::kOnSuggestionMenuClosed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::TextSuggestionBackend_OnSuggestionMenuClosed_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextSuggestionBackend::Name_);
  message.set_method_name("OnSuggestionMenuClosed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void TextSuggestionBackendProxy::SuggestionMenuTimeoutCallback(
    int32_t in_max_number_of_suggestions) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::TextSuggestionBackend::SuggestionMenuTimeoutCallback", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("max_number_of_suggestions"), in_max_number_of_suggestions,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextSuggestionBackend::kSuggestionMenuTimeoutCallback), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::TextSuggestionBackend_SuggestionMenuTimeoutCallback_Params_Data> params(
          message);
  params.Allocate();

  params->max_number_of_suggestions = in_max_number_of_suggestions;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextSuggestionBackend::Name_);
  message.set_method_name("SuggestionMenuTimeoutCallback");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool TextSuggestionBackendStubDispatch::Accept(
    TextSuggestionBackend* impl,
    mojo::Message* message) {
  switch (static_cast<messages::TextSuggestionBackend>(message->header()->name)) {
    case messages::TextSuggestionBackend::kApplySpellCheckSuggestion: {
      DCHECK(message->is_serialized());
      internal::TextSuggestionBackend_ApplySpellCheckSuggestion_Params_Data* params =
          reinterpret_cast<internal::TextSuggestionBackend_ApplySpellCheckSuggestion_Params_Data*>(
              message->mutable_payload());
      

      // Validation for TextSuggestionBackend.0
      bool success = true;
      ::blink::String p_suggestion{};
      TextSuggestionBackend_ApplySpellCheckSuggestion_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSuggestion(&p_suggestion))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextSuggestionBackend::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ApplySpellCheckSuggestion(        
        std::move(p_suggestion));
      return true;
    }
    case messages::TextSuggestionBackend::kApplyTextSuggestion: {
      DCHECK(message->is_serialized());
      internal::TextSuggestionBackend_ApplyTextSuggestion_Params_Data* params =
          reinterpret_cast<internal::TextSuggestionBackend_ApplyTextSuggestion_Params_Data*>(
              message->mutable_payload());
      

      // Validation for TextSuggestionBackend.1
      bool success = true;
      int32_t p_marker_tag{};
      int32_t p_suggestion_index{};
      TextSuggestionBackend_ApplyTextSuggestion_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_marker_tag = input_data_view.marker_tag();
      if (success)
        p_suggestion_index = input_data_view.suggestion_index();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextSuggestionBackend::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ApplyTextSuggestion(        
        std::move(p_marker_tag), 
        std::move(p_suggestion_index));
      return true;
    }
    case messages::TextSuggestionBackend::kDeleteActiveSuggestionRange: {
      DCHECK(message->is_serialized());
      internal::TextSuggestionBackend_DeleteActiveSuggestionRange_Params_Data* params =
          reinterpret_cast<internal::TextSuggestionBackend_DeleteActiveSuggestionRange_Params_Data*>(
              message->mutable_payload());
      

      // Validation for TextSuggestionBackend.2
      bool success = true;
      TextSuggestionBackend_DeleteActiveSuggestionRange_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextSuggestionBackend::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteActiveSuggestionRange(        );
      return true;
    }
    case messages::TextSuggestionBackend::kOnNewWordAddedToDictionary: {
      DCHECK(message->is_serialized());
      internal::TextSuggestionBackend_OnNewWordAddedToDictionary_Params_Data* params =
          reinterpret_cast<internal::TextSuggestionBackend_OnNewWordAddedToDictionary_Params_Data*>(
              message->mutable_payload());
      

      // Validation for TextSuggestionBackend.3
      bool success = true;
      ::blink::String p_suggestion{};
      TextSuggestionBackend_OnNewWordAddedToDictionary_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSuggestion(&p_suggestion))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextSuggestionBackend::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnNewWordAddedToDictionary(        
        std::move(p_suggestion));
      return true;
    }
    case messages::TextSuggestionBackend::kOnSuggestionMenuClosed: {
      DCHECK(message->is_serialized());
      internal::TextSuggestionBackend_OnSuggestionMenuClosed_Params_Data* params =
          reinterpret_cast<internal::TextSuggestionBackend_OnSuggestionMenuClosed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for TextSuggestionBackend.4
      bool success = true;
      TextSuggestionBackend_OnSuggestionMenuClosed_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextSuggestionBackend::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSuggestionMenuClosed(        );
      return true;
    }
    case messages::TextSuggestionBackend::kSuggestionMenuTimeoutCallback: {
      DCHECK(message->is_serialized());
      internal::TextSuggestionBackend_SuggestionMenuTimeoutCallback_Params_Data* params =
          reinterpret_cast<internal::TextSuggestionBackend_SuggestionMenuTimeoutCallback_Params_Data*>(
              message->mutable_payload());
      

      // Validation for TextSuggestionBackend.5
      bool success = true;
      int32_t p_max_number_of_suggestions{};
      TextSuggestionBackend_SuggestionMenuTimeoutCallback_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_max_number_of_suggestions = input_data_view.max_number_of_suggestions();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextSuggestionBackend::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SuggestionMenuTimeoutCallback(        
        std::move(p_max_number_of_suggestions));
      return true;
    }
  }
  return false;
}

// static
bool TextSuggestionBackendStubDispatch::AcceptWithResponder(
    TextSuggestionBackend* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::TextSuggestionBackend>(message->header()->name)) {
    case messages::TextSuggestionBackend::kApplySpellCheckSuggestion: {
      break;
    }
    case messages::TextSuggestionBackend::kApplyTextSuggestion: {
      break;
    }
    case messages::TextSuggestionBackend::kDeleteActiveSuggestionRange: {
      break;
    }
    case messages::TextSuggestionBackend::kOnNewWordAddedToDictionary: {
      break;
    }
    case messages::TextSuggestionBackend::kOnSuggestionMenuClosed: {
      break;
    }
    case messages::TextSuggestionBackend::kSuggestionMenuTimeoutCallback: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kTextSuggestionBackendValidationInfo[] = {
    { &internal::TextSuggestionBackend_ApplySpellCheckSuggestion_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::TextSuggestionBackend_ApplyTextSuggestion_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::TextSuggestionBackend_DeleteActiveSuggestionRange_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::TextSuggestionBackend_OnNewWordAddedToDictionary_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::TextSuggestionBackend_OnSuggestionMenuClosed_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::TextSuggestionBackend_SuggestionMenuTimeoutCallback_Params_Data::Validate,
     nullptr /* no response */},
};

bool TextSuggestionBackendRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::TextSuggestionBackend::Name_,
    kTextSuggestionBackendValidationInfo);
}



}  // blink::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void TextSuggestionBackendInterceptorForTesting::ApplySpellCheckSuggestion(const ::blink::String& suggestion) {
  GetForwardingInterface()->ApplySpellCheckSuggestion(
    std::move(suggestion)
    );
}
void TextSuggestionBackendInterceptorForTesting::ApplyTextSuggestion(int32_t marker_tag, int32_t suggestion_index) {
  GetForwardingInterface()->ApplyTextSuggestion(
    std::move(marker_tag)
    , 
    std::move(suggestion_index)
    );
}
void TextSuggestionBackendInterceptorForTesting::DeleteActiveSuggestionRange() {
  GetForwardingInterface()->DeleteActiveSuggestionRange();
}
void TextSuggestionBackendInterceptorForTesting::OnNewWordAddedToDictionary(const ::blink::String& suggestion) {
  GetForwardingInterface()->OnNewWordAddedToDictionary(
    std::move(suggestion)
    );
}
void TextSuggestionBackendInterceptorForTesting::OnSuggestionMenuClosed() {
  GetForwardingInterface()->OnSuggestionMenuClosed();
}
void TextSuggestionBackendInterceptorForTesting::SuggestionMenuTimeoutCallback(int32_t max_number_of_suggestions) {
  GetForwardingInterface()->SuggestionMenuTimeoutCallback(
    std::move(max_number_of_suggestions)
    );
}
TextSuggestionBackendAsyncWaiter::TextSuggestionBackendAsyncWaiter(
    TextSuggestionBackend* proxy) : proxy_(proxy) {}

TextSuggestionBackendAsyncWaiter::~TextSuggestionBackendAsyncWaiter() = default;







}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif