// third_party/blink/public/mojom/input/input_host.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_INPUT_HOST_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_INPUT_HOST_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/input/input_host.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "third_party/blink/public/mojom/input/input_host.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SpellCheckSuggestionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::SpellCheckSuggestionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::SpellCheckSuggestion_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::suggestion(input)) in_suggestion = Traits::suggestion(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->suggestion)::BaseType> suggestion_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_suggestion,
      suggestion_fragment);

    fragment->suggestion.Set(
        suggestion_fragment.is_null() ? nullptr : suggestion_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->suggestion.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null suggestion in SpellCheckSuggestion struct");
  }

  static bool Deserialize(::blink::mojom::internal::SpellCheckSuggestion_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::SpellCheckSuggestionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::TextSuggestionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::TextSuggestionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::TextSuggestion_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->marker_tag = Traits::marker_tag(input);

    fragment->suggestion_index = Traits::suggestion_index(input);

    decltype(Traits::prefix(input)) in_prefix = Traits::prefix(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->prefix)::BaseType> prefix_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_prefix,
      prefix_fragment);

    fragment->prefix.Set(
        prefix_fragment.is_null() ? nullptr : prefix_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->prefix.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null prefix in TextSuggestion struct");

    decltype(Traits::suggestion(input)) in_suggestion = Traits::suggestion(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->suggestion)::BaseType> suggestion_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_suggestion,
      suggestion_fragment);

    fragment->suggestion.Set(
        suggestion_fragment.is_null() ? nullptr : suggestion_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->suggestion.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null suggestion in TextSuggestion struct");

    decltype(Traits::suffix(input)) in_suffix = Traits::suffix(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->suffix)::BaseType> suffix_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_suffix,
      suffix_fragment);

    fragment->suffix.Set(
        suffix_fragment.is_null() ? nullptr : suffix_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->suffix.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null suffix in TextSuggestion struct");
  }

  static bool Deserialize(::blink::mojom::internal::TextSuggestion_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::TextSuggestionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void SpellCheckSuggestionDataView::GetSuggestionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->suggestion.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void TextSuggestionDataView::GetPrefixDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->prefix.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void TextSuggestionDataView::GetSuggestionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->suggestion.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void TextSuggestionDataView::GetSuffixDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->suffix.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_INPUT_HOST_MOJOM_SHARED_H_