// third_party/blink/public/mojom/input/input_handler.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('cc.mojom.BrowserControlsState');
goog.require('blink.mojom.Button');
goog.require('blink.mojom.DispatchType');
goog.require('ui.mojom.EventPointerType');
goog.require('blink.mojom.EventType');
goog.require('blink.mojom.GestureDevice');
goog.require('blink.mojom.HandwritingGestureResult');
goog.require('ui.mojom.ImeTextSpanType');
goog.require('blink.mojom.InertialPhaseState');
goog.require('blink.mojom.InputEventResultSource');
goog.require('blink.mojom.InputEventResultState');
goog.require('blink.mojom.InputSource');
goog.require('blink.mojom.PointerLockResult');
goog.require('ui.mojom.ScrollGranularity');
goog.require('blink.mojom.SelectionMenuBehavior');
goog.require('cc.mojom.TouchAction');
goog.require('blink.mojom.TouchState');
goog.require('blink.mojom.PointerLockContext');
goog.require('cc.mojom.BrowserControlsOffsetTagModifications');
goog.require('ui.mojom.EventLatencyMetadata');
goog.require('ui.mojom.ImeTextSpan');
goog.require('ui.mojom.LatencyInfo');
goog.require('cc.mojom.OverscrollBehavior');
goog.require('gfx.mojom.Point');
goog.require('gfx.mojom.PointF');
goog.require('gfx.mojom.Range');
goog.require('gfx.mojom.Rect');
goog.require('gfx.mojom.Size');
goog.require('mojoBase.mojom.String16');
goog.require('blink.mojom.StylusWritingGestureData');
goog.require('mojoBase.mojom.TimeTicks');
goog.require('gfx.mojom.Vector2dF');




goog.provide('blink.mojom.SelectionGranularity');
goog.provide('blink.mojom.SelectionGranularitySpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.SelectionGranularitySpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.SelectionGranularity = {
  
  kWord: 0,
  kSentence: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

goog.provide('blink.mojom.PanAction');
goog.provide('blink.mojom.PanActionSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.PanActionSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.PanAction = {
  
  kNone: 0,
  kScroll: 1,
  kMoveCursorOrScroll: 2,
  kStylusWritable: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

goog.provide('blink.mojom.FocusState');
goog.provide('blink.mojom.FocusStateSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.FocusStateSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.FocusState = {
  
  kFocused: 0,
  kNotFocusedAndActive: 1,
  kNotFocusedAndNotActive: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};



goog.provide('blink.mojom.WidgetInputHandlerHost');
goog.provide('blink.mojom.WidgetInputHandlerHostReceiver');
goog.provide('blink.mojom.WidgetInputHandlerHostCallbackRouter');
goog.provide('blink.mojom.WidgetInputHandlerHostInterface');
goog.provide('blink.mojom.WidgetInputHandlerHostRemote');
goog.provide('blink.mojom.WidgetInputHandlerHostPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.WidgetInputHandlerHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.WidgetInputHandlerHost.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.WidgetInputHandlerHostInterface = class {
  
  /**
   * @param { !cc.mojom.TouchAction } touchAction
   */

  setTouchActionFromMain(touchAction) {}
  
  /**
   * @param { !blink.mojom.PanAction } panAction
   */

  setPanAction(panAction) {}
  
  /**
   * @param { !blink.mojom.DidOverscrollParams } params
   */

  didOverscroll(params) {}
  
  /**
   */

  didStartScrollingViewport() {}
  
  /**
   */

  imeCancelComposition() {}
  
  /**
   * @param { !gfx.mojom.Range } range
   * @param { ?Array<!gfx.mojom.Rect> } characterBounds
   */

  imeCompositionRangeChanged(range, characterBounds) {}
  
  /**
   * @param { !boolean } capture
   */

  setMouseCapture(capture) {}
  
  /**
   * @param { !boolean } autoscrollSelection
   */

  setAutoscrollSelectionActiveInMainFrame(autoscrollSelection) {}
  
  /**
   * @param { !boolean } fromUserGesture
   * @param { !boolean } unadjustedMovement
   * @return {!Promise<{
        result: !blink.mojom.PointerLockResult,
        context: ?blink.mojom.PointerLockContextRemote,
   *  }>}
   */

  requestMouseLock(fromUserGesture, unadjustedMovement) {}
};

/**
 * @export
 * @implements { blink.mojom.WidgetInputHandlerHostInterface }
 */
blink.mojom.WidgetInputHandlerHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.WidgetInputHandlerHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.WidgetInputHandlerHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.WidgetInputHandlerHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !cc.mojom.TouchAction } touchAction
   */

  setTouchActionFromMain(
      touchAction) {
    this.proxy.sendMessage(
        0,
        blink.mojom.WidgetInputHandlerHost_SetTouchActionFromMain_ParamsSpec.$,
        null,
        [
          touchAction
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.PanAction } panAction
   */

  setPanAction(
      panAction) {
    this.proxy.sendMessage(
        1,
        blink.mojom.WidgetInputHandlerHost_SetPanAction_ParamsSpec.$,
        null,
        [
          panAction
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.DidOverscrollParams } params
   */

  didOverscroll(
      params) {
    this.proxy.sendMessage(
        2,
        blink.mojom.WidgetInputHandlerHost_DidOverscroll_ParamsSpec.$,
        null,
        [
          params
        ],
        false);
  }

  
  /**
   */

  didStartScrollingViewport() {
    this.proxy.sendMessage(
        3,
        blink.mojom.WidgetInputHandlerHost_DidStartScrollingViewport_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  imeCancelComposition() {
    this.proxy.sendMessage(
        4,
        blink.mojom.WidgetInputHandlerHost_ImeCancelComposition_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !gfx.mojom.Range } range
   * @param { ?Array<!gfx.mojom.Rect> } characterBounds
   */

  imeCompositionRangeChanged(
      range,
      characterBounds) {
    this.proxy.sendMessage(
        5,
        blink.mojom.WidgetInputHandlerHost_ImeCompositionRangeChanged_ParamsSpec.$,
        null,
        [
          range,
          characterBounds
        ],
        false);
  }

  
  /**
   * @param { !boolean } capture
   */

  setMouseCapture(
      capture) {
    this.proxy.sendMessage(
        6,
        blink.mojom.WidgetInputHandlerHost_SetMouseCapture_ParamsSpec.$,
        null,
        [
          capture
        ],
        false);
  }

  
  /**
   * @param { !boolean } autoscrollSelection
   */

  setAutoscrollSelectionActiveInMainFrame(
      autoscrollSelection) {
    this.proxy.sendMessage(
        7,
        blink.mojom.WidgetInputHandlerHost_SetAutoscrollSelectionActiveInMainFrame_ParamsSpec.$,
        null,
        [
          autoscrollSelection
        ],
        false);
  }

  
  /**
   * @param { !boolean } fromUserGesture
   * @param { !boolean } unadjustedMovement
   * @return {!Promise<{
        result: !blink.mojom.PointerLockResult,
        context: ?blink.mojom.PointerLockContextRemote,
   *  }>}
   */

  requestMouseLock(
      fromUserGesture,
      unadjustedMovement) {
    return this.proxy.sendMessage(
        8,
        blink.mojom.WidgetInputHandlerHost_RequestMouseLock_ParamsSpec.$,
        blink.mojom.WidgetInputHandlerHost_RequestMouseLock_ResponseParamsSpec.$,
        [
          fromUserGesture,
          unadjustedMovement
        ],
        false);
  }
};

/**
 * An object which receives request messages for the WidgetInputHandlerHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.WidgetInputHandlerHostReceiver = class {
  /**
   * @param {!blink.mojom.WidgetInputHandlerHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.WidgetInputHandlerHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.WidgetInputHandlerHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.WidgetInputHandlerHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.WidgetInputHandlerHost_SetTouchActionFromMain_ParamsSpec.$,
        null,
        impl.setTouchActionFromMain.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.WidgetInputHandlerHost_SetPanAction_ParamsSpec.$,
        null,
        impl.setPanAction.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.WidgetInputHandlerHost_DidOverscroll_ParamsSpec.$,
        null,
        impl.didOverscroll.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.WidgetInputHandlerHost_DidStartScrollingViewport_ParamsSpec.$,
        null,
        impl.didStartScrollingViewport.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.WidgetInputHandlerHost_ImeCancelComposition_ParamsSpec.$,
        null,
        impl.imeCancelComposition.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        blink.mojom.WidgetInputHandlerHost_ImeCompositionRangeChanged_ParamsSpec.$,
        null,
        impl.imeCompositionRangeChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        blink.mojom.WidgetInputHandlerHost_SetMouseCapture_ParamsSpec.$,
        null,
        impl.setMouseCapture.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        blink.mojom.WidgetInputHandlerHost_SetAutoscrollSelectionActiveInMainFrame_ParamsSpec.$,
        null,
        impl.setAutoscrollSelectionActiveInMainFrame.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        blink.mojom.WidgetInputHandlerHost_RequestMouseLock_ParamsSpec.$,
        blink.mojom.WidgetInputHandlerHost_RequestMouseLock_ResponseParamsSpec.$,
        impl.requestMouseLock.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.WidgetInputHandlerHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.WidgetInputHandlerHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.WidgetInputHandlerHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.WidgetInputHandlerHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the WidgetInputHandlerHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.WidgetInputHandlerHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.WidgetInputHandlerHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.WidgetInputHandlerHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setTouchActionFromMain =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.WidgetInputHandlerHost_SetTouchActionFromMain_ParamsSpec.$,
        null,
        this.setTouchActionFromMain.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setPanAction =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.WidgetInputHandlerHost_SetPanAction_ParamsSpec.$,
        null,
        this.setPanAction.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didOverscroll =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.WidgetInputHandlerHost_DidOverscroll_ParamsSpec.$,
        null,
        this.didOverscroll.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didStartScrollingViewport =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.WidgetInputHandlerHost_DidStartScrollingViewport_ParamsSpec.$,
        null,
        this.didStartScrollingViewport.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.imeCancelComposition =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.WidgetInputHandlerHost_ImeCancelComposition_ParamsSpec.$,
        null,
        this.imeCancelComposition.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.imeCompositionRangeChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        blink.mojom.WidgetInputHandlerHost_ImeCompositionRangeChanged_ParamsSpec.$,
        null,
        this.imeCompositionRangeChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setMouseCapture =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        blink.mojom.WidgetInputHandlerHost_SetMouseCapture_ParamsSpec.$,
        null,
        this.setMouseCapture.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setAutoscrollSelectionActiveInMainFrame =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        blink.mojom.WidgetInputHandlerHost_SetAutoscrollSelectionActiveInMainFrame_ParamsSpec.$,
        null,
        this.setAutoscrollSelectionActiveInMainFrame.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestMouseLock =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        blink.mojom.WidgetInputHandlerHost_RequestMouseLock_ParamsSpec.$,
        blink.mojom.WidgetInputHandlerHost_RequestMouseLock_ResponseParamsSpec.$,
        this.requestMouseLock.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.FrameWidgetInputHandler');
goog.provide('blink.mojom.FrameWidgetInputHandlerReceiver');
goog.provide('blink.mojom.FrameWidgetInputHandlerCallbackRouter');
goog.provide('blink.mojom.FrameWidgetInputHandlerInterface');
goog.provide('blink.mojom.FrameWidgetInputHandlerRemote');
goog.provide('blink.mojom.FrameWidgetInputHandlerPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.FrameWidgetInputHandlerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.FrameWidgetInputHandler.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.FrameWidgetInputHandlerInterface = class {
  
  /**
   * @param { !number } start
   * @param { !number } end
   * @param { !Array<!ui.mojom.ImeTextSpan> } imeTextSpans
   */

  addImeTextSpansToExistingText(start, end, imeTextSpans) {}
  
  /**
   * @param { !number } start
   * @param { !number } end
   * @param { !ui.mojom.ImeTextSpanType } type
   */

  clearImeTextSpansByType(start, end, type) {}
  
  /**
   * @param { !number } start
   * @param { !number } end
   * @param { !Array<!ui.mojom.ImeTextSpan> } imeTextSpans
   */

  setCompositionFromExistingText(start, end, imeTextSpans) {}
  
  /**
   * @param { !number } before
   * @param { !number } after
   */

  extendSelectionAndDelete(before, after) {}
  
  /**
   * @param { !number } before
   * @param { !number } after
   * @param { !mojoBase.mojom.String16 } replacementText
   */

  extendSelectionAndReplace(before, after, replacementText) {}
  
  /**
   * @param { !number } before
   * @param { !number } after
   */

  deleteSurroundingText(before, after) {}
  
  /**
   * @param { !number } before
   * @param { !number } after
   */

  deleteSurroundingTextInCodePoints(before, after) {}
  
  /**
   * @param { !number } start
   * @param { !number } end
   */

  setEditableSelectionOffsets(start, end) {}
  
  /**
   * @param { !blink.mojom.StylusWritingGestureData } gestureData
   * @return {!Promise<{
        result: !blink.mojom.HandwritingGestureResult,
   *  }>}
   */

  handleStylusWritingGestureAction(gestureData) {}
  
  /**
   * @param { !string } command
   * @param { ?mojoBase.mojom.String16 } value
   */

  executeEditCommand(command, value) {}
  
  /**
   */

  undo() {}
  
  /**
   */

  redo() {}
  
  /**
   */

  cut() {}
  
  /**
   */

  copy() {}
  
  /**
   */

  copyToFindPboard() {}
  
  /**
   */

  centerSelection() {}
  
  /**
   */

  paste() {}
  
  /**
   */

  pasteAndMatchStyle() {}
  
  /**
   */

  delete() {}
  
  /**
   */

  selectAll() {}
  
  /**
   */

  collapseSelection() {}
  
  /**
   * @param { !number } token
   * @return {!Promise<{
        token: !number,
   *  }>}
   */

  copyWithConfirmation(token) {}
  
  /**
   * @param { !number } token
   * @return {!Promise<{
        token: !number,
   *  }>}
   */

  pasteWithConfirmation(token) {}
  
  /**
   * @param { !mojoBase.mojom.String16 } word
   */

  replace(word) {}
  
  /**
   * @param { !mojoBase.mojom.String16 } word
   */

  replaceMisspelling(word) {}
  
  /**
   * @param { !gfx.mojom.Point } base
   * @param { !gfx.mojom.Point } extent
   */

  selectRange(base, extent) {}
  
  /**
   * @param { !number } start
   * @param { !number } end
   * @param { !blink.mojom.SelectionMenuBehavior } behavior
   */

  adjustSelectionByCharacterOffset(start, end, behavior) {}
  
  /**
   * @param { !blink.mojom.SelectionGranularity } granularity
   * @param { !boolean } shouldShowHandle
   * @param { !boolean } shouldShowContextMenu
   * @return {!Promise<{
        result: ?blink.mojom.SelectAroundCaretResult,
   *  }>}
   */

  selectAroundCaret(granularity, shouldShowHandle, shouldShowContextMenu) {}
  
  /**
   * @param { !gfx.mojom.Point } extent
   */

  moveRangeSelectionExtent(extent) {}
  
  /**
   */

  scrollFocusedEditableNodeIntoView() {}
  
  /**
   * @return {!Promise}
   */

  waitForPageScaleAnimationForTesting() {}
  
  /**
   * @param { !gfx.mojom.Point } point
   */

  moveCaret(point) {}
};

/**
 * @export
 * @implements { blink.mojom.FrameWidgetInputHandlerInterface }
 */
blink.mojom.FrameWidgetInputHandlerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.FrameWidgetInputHandlerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.FrameWidgetInputHandlerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.FrameWidgetInputHandlerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } start
   * @param { !number } end
   * @param { !Array<!ui.mojom.ImeTextSpan> } imeTextSpans
   */

  addImeTextSpansToExistingText(
      start,
      end,
      imeTextSpans) {
    this.proxy.sendMessage(
        0,
        blink.mojom.FrameWidgetInputHandler_AddImeTextSpansToExistingText_ParamsSpec.$,
        null,
        [
          start,
          end,
          imeTextSpans
        ],
        false);
  }

  
  /**
   * @param { !number } start
   * @param { !number } end
   * @param { !ui.mojom.ImeTextSpanType } type
   */

  clearImeTextSpansByType(
      start,
      end,
      type) {
    this.proxy.sendMessage(
        1,
        blink.mojom.FrameWidgetInputHandler_ClearImeTextSpansByType_ParamsSpec.$,
        null,
        [
          start,
          end,
          type
        ],
        false);
  }

  
  /**
   * @param { !number } start
   * @param { !number } end
   * @param { !Array<!ui.mojom.ImeTextSpan> } imeTextSpans
   */

  setCompositionFromExistingText(
      start,
      end,
      imeTextSpans) {
    this.proxy.sendMessage(
        2,
        blink.mojom.FrameWidgetInputHandler_SetCompositionFromExistingText_ParamsSpec.$,
        null,
        [
          start,
          end,
          imeTextSpans
        ],
        false);
  }

  
  /**
   * @param { !number } before
   * @param { !number } after
   */

  extendSelectionAndDelete(
      before,
      after) {
    this.proxy.sendMessage(
        3,
        blink.mojom.FrameWidgetInputHandler_ExtendSelectionAndDelete_ParamsSpec.$,
        null,
        [
          before,
          after
        ],
        false);
  }

  
  /**
   * @param { !number } before
   * @param { !number } after
   * @param { !mojoBase.mojom.String16 } replacementText
   */

  extendSelectionAndReplace(
      before,
      after,
      replacementText) {
    this.proxy.sendMessage(
        4,
        blink.mojom.FrameWidgetInputHandler_ExtendSelectionAndReplace_ParamsSpec.$,
        null,
        [
          before,
          after,
          replacementText
        ],
        false);
  }

  
  /**
   * @param { !number } before
   * @param { !number } after
   */

  deleteSurroundingText(
      before,
      after) {
    this.proxy.sendMessage(
        5,
        blink.mojom.FrameWidgetInputHandler_DeleteSurroundingText_ParamsSpec.$,
        null,
        [
          before,
          after
        ],
        false);
  }

  
  /**
   * @param { !number } before
   * @param { !number } after
   */

  deleteSurroundingTextInCodePoints(
      before,
      after) {
    this.proxy.sendMessage(
        6,
        blink.mojom.FrameWidgetInputHandler_DeleteSurroundingTextInCodePoints_ParamsSpec.$,
        null,
        [
          before,
          after
        ],
        false);
  }

  
  /**
   * @param { !number } start
   * @param { !number } end
   */

  setEditableSelectionOffsets(
      start,
      end) {
    this.proxy.sendMessage(
        7,
        blink.mojom.FrameWidgetInputHandler_SetEditableSelectionOffsets_ParamsSpec.$,
        null,
        [
          start,
          end
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.StylusWritingGestureData } gestureData
   * @return {!Promise<{
        result: !blink.mojom.HandwritingGestureResult,
   *  }>}
   */

  handleStylusWritingGestureAction(
      gestureData) {
    return this.proxy.sendMessage(
        8,
        blink.mojom.FrameWidgetInputHandler_HandleStylusWritingGestureAction_ParamsSpec.$,
        blink.mojom.FrameWidgetInputHandler_HandleStylusWritingGestureAction_ResponseParamsSpec.$,
        [
          gestureData
        ],
        false);
  }

  
  /**
   * @param { !string } command
   * @param { ?mojoBase.mojom.String16 } value
   */

  executeEditCommand(
      command,
      value) {
    this.proxy.sendMessage(
        9,
        blink.mojom.FrameWidgetInputHandler_ExecuteEditCommand_ParamsSpec.$,
        null,
        [
          command,
          value
        ],
        false);
  }

  
  /**
   */

  undo() {
    this.proxy.sendMessage(
        10,
        blink.mojom.FrameWidgetInputHandler_Undo_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  redo() {
    this.proxy.sendMessage(
        11,
        blink.mojom.FrameWidgetInputHandler_Redo_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  cut() {
    this.proxy.sendMessage(
        12,
        blink.mojom.FrameWidgetInputHandler_Cut_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  copy() {
    this.proxy.sendMessage(
        13,
        blink.mojom.FrameWidgetInputHandler_Copy_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  copyToFindPboard() {
    this.proxy.sendMessage(
        14,
        blink.mojom.FrameWidgetInputHandler_CopyToFindPboard_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  centerSelection() {
    this.proxy.sendMessage(
        15,
        blink.mojom.FrameWidgetInputHandler_CenterSelection_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  paste() {
    this.proxy.sendMessage(
        16,
        blink.mojom.FrameWidgetInputHandler_Paste_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  pasteAndMatchStyle() {
    this.proxy.sendMessage(
        17,
        blink.mojom.FrameWidgetInputHandler_PasteAndMatchStyle_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  delete() {
    this.proxy.sendMessage(
        18,
        blink.mojom.FrameWidgetInputHandler_Delete_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  selectAll() {
    this.proxy.sendMessage(
        19,
        blink.mojom.FrameWidgetInputHandler_SelectAll_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  collapseSelection() {
    this.proxy.sendMessage(
        20,
        blink.mojom.FrameWidgetInputHandler_CollapseSelection_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !number } token
   * @return {!Promise<{
        token: !number,
   *  }>}
   */

  copyWithConfirmation(
      token) {
    return this.proxy.sendMessage(
        21,
        blink.mojom.FrameWidgetInputHandler_CopyWithConfirmation_ParamsSpec.$,
        blink.mojom.FrameWidgetInputHandler_CopyWithConfirmation_ResponseParamsSpec.$,
        [
          token
        ],
        false);
  }

  
  /**
   * @param { !number } token
   * @return {!Promise<{
        token: !number,
   *  }>}
   */

  pasteWithConfirmation(
      token) {
    return this.proxy.sendMessage(
        22,
        blink.mojom.FrameWidgetInputHandler_PasteWithConfirmation_ParamsSpec.$,
        blink.mojom.FrameWidgetInputHandler_PasteWithConfirmation_ResponseParamsSpec.$,
        [
          token
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.String16 } word
   */

  replace(
      word) {
    this.proxy.sendMessage(
        23,
        blink.mojom.FrameWidgetInputHandler_Replace_ParamsSpec.$,
        null,
        [
          word
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.String16 } word
   */

  replaceMisspelling(
      word) {
    this.proxy.sendMessage(
        24,
        blink.mojom.FrameWidgetInputHandler_ReplaceMisspelling_ParamsSpec.$,
        null,
        [
          word
        ],
        false);
  }

  
  /**
   * @param { !gfx.mojom.Point } base
   * @param { !gfx.mojom.Point } extent
   */

  selectRange(
      base,
      extent) {
    this.proxy.sendMessage(
        25,
        blink.mojom.FrameWidgetInputHandler_SelectRange_ParamsSpec.$,
        null,
        [
          base,
          extent
        ],
        false);
  }

  
  /**
   * @param { !number } start
   * @param { !number } end
   * @param { !blink.mojom.SelectionMenuBehavior } behavior
   */

  adjustSelectionByCharacterOffset(
      start,
      end,
      behavior) {
    this.proxy.sendMessage(
        26,
        blink.mojom.FrameWidgetInputHandler_AdjustSelectionByCharacterOffset_ParamsSpec.$,
        null,
        [
          start,
          end,
          behavior
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.SelectionGranularity } granularity
   * @param { !boolean } shouldShowHandle
   * @param { !boolean } shouldShowContextMenu
   * @return {!Promise<{
        result: ?blink.mojom.SelectAroundCaretResult,
   *  }>}
   */

  selectAroundCaret(
      granularity,
      shouldShowHandle,
      shouldShowContextMenu) {
    return this.proxy.sendMessage(
        27,
        blink.mojom.FrameWidgetInputHandler_SelectAroundCaret_ParamsSpec.$,
        blink.mojom.FrameWidgetInputHandler_SelectAroundCaret_ResponseParamsSpec.$,
        [
          granularity,
          shouldShowHandle,
          shouldShowContextMenu
        ],
        false);
  }

  
  /**
   * @param { !gfx.mojom.Point } extent
   */

  moveRangeSelectionExtent(
      extent) {
    this.proxy.sendMessage(
        28,
        blink.mojom.FrameWidgetInputHandler_MoveRangeSelectionExtent_ParamsSpec.$,
        null,
        [
          extent
        ],
        false);
  }

  
  /**
   */

  scrollFocusedEditableNodeIntoView() {
    this.proxy.sendMessage(
        29,
        blink.mojom.FrameWidgetInputHandler_ScrollFocusedEditableNodeIntoView_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  waitForPageScaleAnimationForTesting() {
    return this.proxy.sendMessage(
        30,
        blink.mojom.FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ParamsSpec.$,
        blink.mojom.FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !gfx.mojom.Point } point
   */

  moveCaret(
      point) {
    this.proxy.sendMessage(
        31,
        blink.mojom.FrameWidgetInputHandler_MoveCaret_ParamsSpec.$,
        null,
        [
          point
        ],
        false);
  }
};

/**
 * An object which receives request messages for the FrameWidgetInputHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.FrameWidgetInputHandlerReceiver = class {
  /**
   * @param {!blink.mojom.FrameWidgetInputHandlerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.FrameWidgetInputHandlerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.FrameWidgetInputHandlerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.FrameWidgetInputHandlerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.FrameWidgetInputHandler_AddImeTextSpansToExistingText_ParamsSpec.$,
        null,
        impl.addImeTextSpansToExistingText.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.FrameWidgetInputHandler_ClearImeTextSpansByType_ParamsSpec.$,
        null,
        impl.clearImeTextSpansByType.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.FrameWidgetInputHandler_SetCompositionFromExistingText_ParamsSpec.$,
        null,
        impl.setCompositionFromExistingText.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.FrameWidgetInputHandler_ExtendSelectionAndDelete_ParamsSpec.$,
        null,
        impl.extendSelectionAndDelete.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.FrameWidgetInputHandler_ExtendSelectionAndReplace_ParamsSpec.$,
        null,
        impl.extendSelectionAndReplace.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        blink.mojom.FrameWidgetInputHandler_DeleteSurroundingText_ParamsSpec.$,
        null,
        impl.deleteSurroundingText.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        blink.mojom.FrameWidgetInputHandler_DeleteSurroundingTextInCodePoints_ParamsSpec.$,
        null,
        impl.deleteSurroundingTextInCodePoints.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        blink.mojom.FrameWidgetInputHandler_SetEditableSelectionOffsets_ParamsSpec.$,
        null,
        impl.setEditableSelectionOffsets.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        blink.mojom.FrameWidgetInputHandler_HandleStylusWritingGestureAction_ParamsSpec.$,
        blink.mojom.FrameWidgetInputHandler_HandleStylusWritingGestureAction_ResponseParamsSpec.$,
        impl.handleStylusWritingGestureAction.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        blink.mojom.FrameWidgetInputHandler_ExecuteEditCommand_ParamsSpec.$,
        null,
        impl.executeEditCommand.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        blink.mojom.FrameWidgetInputHandler_Undo_ParamsSpec.$,
        null,
        impl.undo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        blink.mojom.FrameWidgetInputHandler_Redo_ParamsSpec.$,
        null,
        impl.redo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        blink.mojom.FrameWidgetInputHandler_Cut_ParamsSpec.$,
        null,
        impl.cut.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        blink.mojom.FrameWidgetInputHandler_Copy_ParamsSpec.$,
        null,
        impl.copy.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        blink.mojom.FrameWidgetInputHandler_CopyToFindPboard_ParamsSpec.$,
        null,
        impl.copyToFindPboard.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        blink.mojom.FrameWidgetInputHandler_CenterSelection_ParamsSpec.$,
        null,
        impl.centerSelection.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        16,
        blink.mojom.FrameWidgetInputHandler_Paste_ParamsSpec.$,
        null,
        impl.paste.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        17,
        blink.mojom.FrameWidgetInputHandler_PasteAndMatchStyle_ParamsSpec.$,
        null,
        impl.pasteAndMatchStyle.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        18,
        blink.mojom.FrameWidgetInputHandler_Delete_ParamsSpec.$,
        null,
        impl.delete.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        19,
        blink.mojom.FrameWidgetInputHandler_SelectAll_ParamsSpec.$,
        null,
        impl.selectAll.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        20,
        blink.mojom.FrameWidgetInputHandler_CollapseSelection_ParamsSpec.$,
        null,
        impl.collapseSelection.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        21,
        blink.mojom.FrameWidgetInputHandler_CopyWithConfirmation_ParamsSpec.$,
        blink.mojom.FrameWidgetInputHandler_CopyWithConfirmation_ResponseParamsSpec.$,
        impl.copyWithConfirmation.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        22,
        blink.mojom.FrameWidgetInputHandler_PasteWithConfirmation_ParamsSpec.$,
        blink.mojom.FrameWidgetInputHandler_PasteWithConfirmation_ResponseParamsSpec.$,
        impl.pasteWithConfirmation.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        23,
        blink.mojom.FrameWidgetInputHandler_Replace_ParamsSpec.$,
        null,
        impl.replace.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        24,
        blink.mojom.FrameWidgetInputHandler_ReplaceMisspelling_ParamsSpec.$,
        null,
        impl.replaceMisspelling.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        25,
        blink.mojom.FrameWidgetInputHandler_SelectRange_ParamsSpec.$,
        null,
        impl.selectRange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        26,
        blink.mojom.FrameWidgetInputHandler_AdjustSelectionByCharacterOffset_ParamsSpec.$,
        null,
        impl.adjustSelectionByCharacterOffset.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        27,
        blink.mojom.FrameWidgetInputHandler_SelectAroundCaret_ParamsSpec.$,
        blink.mojom.FrameWidgetInputHandler_SelectAroundCaret_ResponseParamsSpec.$,
        impl.selectAroundCaret.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        28,
        blink.mojom.FrameWidgetInputHandler_MoveRangeSelectionExtent_ParamsSpec.$,
        null,
        impl.moveRangeSelectionExtent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        29,
        blink.mojom.FrameWidgetInputHandler_ScrollFocusedEditableNodeIntoView_ParamsSpec.$,
        null,
        impl.scrollFocusedEditableNodeIntoView.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        30,
        blink.mojom.FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ParamsSpec.$,
        blink.mojom.FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ResponseParamsSpec.$,
        impl.waitForPageScaleAnimationForTesting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        31,
        blink.mojom.FrameWidgetInputHandler_MoveCaret_ParamsSpec.$,
        null,
        impl.moveCaret.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.FrameWidgetInputHandler = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.FrameWidgetInputHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.FrameWidgetInputHandlerRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.FrameWidgetInputHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the FrameWidgetInputHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.FrameWidgetInputHandlerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.FrameWidgetInputHandlerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.FrameWidgetInputHandlerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addImeTextSpansToExistingText =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.FrameWidgetInputHandler_AddImeTextSpansToExistingText_ParamsSpec.$,
        null,
        this.addImeTextSpansToExistingText.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearImeTextSpansByType =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.FrameWidgetInputHandler_ClearImeTextSpansByType_ParamsSpec.$,
        null,
        this.clearImeTextSpansByType.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setCompositionFromExistingText =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.FrameWidgetInputHandler_SetCompositionFromExistingText_ParamsSpec.$,
        null,
        this.setCompositionFromExistingText.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.extendSelectionAndDelete =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.FrameWidgetInputHandler_ExtendSelectionAndDelete_ParamsSpec.$,
        null,
        this.extendSelectionAndDelete.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.extendSelectionAndReplace =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.FrameWidgetInputHandler_ExtendSelectionAndReplace_ParamsSpec.$,
        null,
        this.extendSelectionAndReplace.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteSurroundingText =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        blink.mojom.FrameWidgetInputHandler_DeleteSurroundingText_ParamsSpec.$,
        null,
        this.deleteSurroundingText.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteSurroundingTextInCodePoints =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        blink.mojom.FrameWidgetInputHandler_DeleteSurroundingTextInCodePoints_ParamsSpec.$,
        null,
        this.deleteSurroundingTextInCodePoints.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setEditableSelectionOffsets =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        blink.mojom.FrameWidgetInputHandler_SetEditableSelectionOffsets_ParamsSpec.$,
        null,
        this.setEditableSelectionOffsets.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.handleStylusWritingGestureAction =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        blink.mojom.FrameWidgetInputHandler_HandleStylusWritingGestureAction_ParamsSpec.$,
        blink.mojom.FrameWidgetInputHandler_HandleStylusWritingGestureAction_ResponseParamsSpec.$,
        this.handleStylusWritingGestureAction.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.executeEditCommand =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        blink.mojom.FrameWidgetInputHandler_ExecuteEditCommand_ParamsSpec.$,
        null,
        this.executeEditCommand.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.undo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        blink.mojom.FrameWidgetInputHandler_Undo_ParamsSpec.$,
        null,
        this.undo.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.redo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        blink.mojom.FrameWidgetInputHandler_Redo_ParamsSpec.$,
        null,
        this.redo.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cut =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        blink.mojom.FrameWidgetInputHandler_Cut_ParamsSpec.$,
        null,
        this.cut.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.copy =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        blink.mojom.FrameWidgetInputHandler_Copy_ParamsSpec.$,
        null,
        this.copy.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.copyToFindPboard =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        blink.mojom.FrameWidgetInputHandler_CopyToFindPboard_ParamsSpec.$,
        null,
        this.copyToFindPboard.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.centerSelection =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        blink.mojom.FrameWidgetInputHandler_CenterSelection_ParamsSpec.$,
        null,
        this.centerSelection.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.paste =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        16,
        blink.mojom.FrameWidgetInputHandler_Paste_ParamsSpec.$,
        null,
        this.paste.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.pasteAndMatchStyle =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        17,
        blink.mojom.FrameWidgetInputHandler_PasteAndMatchStyle_ParamsSpec.$,
        null,
        this.pasteAndMatchStyle.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.delete =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        18,
        blink.mojom.FrameWidgetInputHandler_Delete_ParamsSpec.$,
        null,
        this.delete.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.selectAll =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        19,
        blink.mojom.FrameWidgetInputHandler_SelectAll_ParamsSpec.$,
        null,
        this.selectAll.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.collapseSelection =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        20,
        blink.mojom.FrameWidgetInputHandler_CollapseSelection_ParamsSpec.$,
        null,
        this.collapseSelection.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.copyWithConfirmation =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        21,
        blink.mojom.FrameWidgetInputHandler_CopyWithConfirmation_ParamsSpec.$,
        blink.mojom.FrameWidgetInputHandler_CopyWithConfirmation_ResponseParamsSpec.$,
        this.copyWithConfirmation.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.pasteWithConfirmation =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        22,
        blink.mojom.FrameWidgetInputHandler_PasteWithConfirmation_ParamsSpec.$,
        blink.mojom.FrameWidgetInputHandler_PasteWithConfirmation_ResponseParamsSpec.$,
        this.pasteWithConfirmation.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.replace =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        23,
        blink.mojom.FrameWidgetInputHandler_Replace_ParamsSpec.$,
        null,
        this.replace.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.replaceMisspelling =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        24,
        blink.mojom.FrameWidgetInputHandler_ReplaceMisspelling_ParamsSpec.$,
        null,
        this.replaceMisspelling.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.selectRange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        25,
        blink.mojom.FrameWidgetInputHandler_SelectRange_ParamsSpec.$,
        null,
        this.selectRange.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.adjustSelectionByCharacterOffset =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        26,
        blink.mojom.FrameWidgetInputHandler_AdjustSelectionByCharacterOffset_ParamsSpec.$,
        null,
        this.adjustSelectionByCharacterOffset.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.selectAroundCaret =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        27,
        blink.mojom.FrameWidgetInputHandler_SelectAroundCaret_ParamsSpec.$,
        blink.mojom.FrameWidgetInputHandler_SelectAroundCaret_ResponseParamsSpec.$,
        this.selectAroundCaret.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.moveRangeSelectionExtent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        28,
        blink.mojom.FrameWidgetInputHandler_MoveRangeSelectionExtent_ParamsSpec.$,
        null,
        this.moveRangeSelectionExtent.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.scrollFocusedEditableNodeIntoView =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        29,
        blink.mojom.FrameWidgetInputHandler_ScrollFocusedEditableNodeIntoView_ParamsSpec.$,
        null,
        this.scrollFocusedEditableNodeIntoView.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.waitForPageScaleAnimationForTesting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        30,
        blink.mojom.FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ParamsSpec.$,
        blink.mojom.FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ResponseParamsSpec.$,
        this.waitForPageScaleAnimationForTesting.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.moveCaret =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        31,
        blink.mojom.FrameWidgetInputHandler_MoveCaret_ParamsSpec.$,
        null,
        this.moveCaret.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.WidgetInputHandler');
goog.provide('blink.mojom.WidgetInputHandlerReceiver');
goog.provide('blink.mojom.WidgetInputHandlerCallbackRouter');
goog.provide('blink.mojom.WidgetInputHandlerInterface');
goog.provide('blink.mojom.WidgetInputHandlerRemote');
goog.provide('blink.mojom.WidgetInputHandlerPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.WidgetInputHandlerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.WidgetInputHandler.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.WidgetInputHandlerInterface = class {
  
  /**
   * @param { !blink.mojom.FocusState } state
   */

  setFocus(state) {}
  
  /**
   */

  mouseCaptureLost() {}
  
  /**
   * @param { !Array<!blink.mojom.EditCommand> } commands
   */

  setEditCommandsForNextKeyEvent(commands) {}
  
  /**
   * @param { !boolean } visible
   */

  cursorVisibilityChanged(visible) {}
  
  /**
   * @param { !mojoBase.mojom.String16 } text
   * @param { !Array<!ui.mojom.ImeTextSpan> } imeTextSpans
   * @param { !gfx.mojom.Range } range
   * @param { !number } start
   * @param { !number } end
   * @return {!Promise}
   */

  imeSetComposition(text, imeTextSpans, range, start, end) {}
  
  /**
   * @param { !mojoBase.mojom.String16 } text
   * @param { !Array<!ui.mojom.ImeTextSpan> } imeTextSpans
   * @param { !gfx.mojom.Range } range
   * @param { !number } relativeCursorPosition
   * @return {!Promise}
   */

  imeCommitText(text, imeTextSpans, range, relativeCursorPosition) {}
  
  /**
   * @param { !boolean } keepSelection
   */

  imeFinishComposingText(keepSelection) {}
  
  /**
   */

  requestTextInputStateUpdate() {}
  
  /**
   * @param { !boolean } immediateRequest
   * @param { !boolean } monitorRequest
   */

  requestCompositionUpdates(immediateRequest, monitorRequest) {}
  
  /**
   * @param { !blink.mojom.Event } event
   * @param { ?blink.mojom.Event } originalEventForGesture
   * @return {!Promise<{
        source: !blink.mojom.InputEventResultSource,
        updatedLatency: !ui.mojom.LatencyInfo,
        state: !blink.mojom.InputEventResultState,
        overscroll: ?blink.mojom.DidOverscrollParams,
        touchAction: ?blink.mojom.TouchActionOptional,
   *  }>}
   */

  dispatchEvent(event, originalEventForGesture) {}
  
  /**
   * @param { !blink.mojom.Event } event
   */

  dispatchNonBlockingEvent(event) {}
  
  /**
   * @return {!Promise}
   */

  waitForInputProcessed() {}
  
  /**
   * @param { !Object } interfaceRequest
   */

  getFrameWidgetInputHandler(interfaceRequest) {}
  
  /**
   * @param { !cc.mojom.BrowserControlsState } constraints
   * @param { !cc.mojom.BrowserControlsState } current
   * @param { !boolean } animate
   * @param { ?cc.mojom.BrowserControlsOffsetTagModifications } offsetTagModifications
   */

  updateBrowserControlsState(constraints, current, animate, offsetTagModifications) {}
};

/**
 * @export
 * @implements { blink.mojom.WidgetInputHandlerInterface }
 */
blink.mojom.WidgetInputHandlerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.WidgetInputHandlerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.WidgetInputHandlerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.WidgetInputHandlerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.FocusState } state
   */

  setFocus(
      state) {
    this.proxy.sendMessage(
        0,
        blink.mojom.WidgetInputHandler_SetFocus_ParamsSpec.$,
        null,
        [
          state
        ],
        false);
  }

  
  /**
   */

  mouseCaptureLost() {
    this.proxy.sendMessage(
        1,
        blink.mojom.WidgetInputHandler_MouseCaptureLost_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !Array<!blink.mojom.EditCommand> } commands
   */

  setEditCommandsForNextKeyEvent(
      commands) {
    this.proxy.sendMessage(
        2,
        blink.mojom.WidgetInputHandler_SetEditCommandsForNextKeyEvent_ParamsSpec.$,
        null,
        [
          commands
        ],
        false);
  }

  
  /**
   * @param { !boolean } visible
   */

  cursorVisibilityChanged(
      visible) {
    this.proxy.sendMessage(
        3,
        blink.mojom.WidgetInputHandler_CursorVisibilityChanged_ParamsSpec.$,
        null,
        [
          visible
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.String16 } text
   * @param { !Array<!ui.mojom.ImeTextSpan> } imeTextSpans
   * @param { !gfx.mojom.Range } range
   * @param { !number } start
   * @param { !number } end
   * @return {!Promise}
   */

  imeSetComposition(
      text,
      imeTextSpans,
      range,
      start,
      end) {
    return this.proxy.sendMessage(
        4,
        blink.mojom.WidgetInputHandler_ImeSetComposition_ParamsSpec.$,
        blink.mojom.WidgetInputHandler_ImeSetComposition_ResponseParamsSpec.$,
        [
          text,
          imeTextSpans,
          range,
          start,
          end
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.String16 } text
   * @param { !Array<!ui.mojom.ImeTextSpan> } imeTextSpans
   * @param { !gfx.mojom.Range } range
   * @param { !number } relativeCursorPosition
   * @return {!Promise}
   */

  imeCommitText(
      text,
      imeTextSpans,
      range,
      relativeCursorPosition) {
    return this.proxy.sendMessage(
        5,
        blink.mojom.WidgetInputHandler_ImeCommitText_ParamsSpec.$,
        blink.mojom.WidgetInputHandler_ImeCommitText_ResponseParamsSpec.$,
        [
          text,
          imeTextSpans,
          range,
          relativeCursorPosition
        ],
        false);
  }

  
  /**
   * @param { !boolean } keepSelection
   */

  imeFinishComposingText(
      keepSelection) {
    this.proxy.sendMessage(
        6,
        blink.mojom.WidgetInputHandler_ImeFinishComposingText_ParamsSpec.$,
        null,
        [
          keepSelection
        ],
        false);
  }

  
  /**
   */

  requestTextInputStateUpdate() {
    this.proxy.sendMessage(
        7,
        blink.mojom.WidgetInputHandler_RequestTextInputStateUpdate_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } immediateRequest
   * @param { !boolean } monitorRequest
   */

  requestCompositionUpdates(
      immediateRequest,
      monitorRequest) {
    this.proxy.sendMessage(
        8,
        blink.mojom.WidgetInputHandler_RequestCompositionUpdates_ParamsSpec.$,
        null,
        [
          immediateRequest,
          monitorRequest
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.Event } event
   * @param { ?blink.mojom.Event } originalEventForGesture
   * @return {!Promise<{
        source: !blink.mojom.InputEventResultSource,
        updatedLatency: !ui.mojom.LatencyInfo,
        state: !blink.mojom.InputEventResultState,
        overscroll: ?blink.mojom.DidOverscrollParams,
        touchAction: ?blink.mojom.TouchActionOptional,
   *  }>}
   */

  dispatchEvent(
      event,
      originalEventForGesture) {
    return this.proxy.sendMessage(
        9,
        blink.mojom.WidgetInputHandler_DispatchEvent_ParamsSpec.$,
        blink.mojom.WidgetInputHandler_DispatchEvent_ResponseParamsSpec.$,
        [
          event,
          originalEventForGesture
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.Event } event
   */

  dispatchNonBlockingEvent(
      event) {
    this.proxy.sendMessage(
        10,
        blink.mojom.WidgetInputHandler_DispatchNonBlockingEvent_ParamsSpec.$,
        null,
        [
          event
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  waitForInputProcessed() {
    return this.proxy.sendMessage(
        11,
        blink.mojom.WidgetInputHandler_WaitForInputProcessed_ParamsSpec.$,
        blink.mojom.WidgetInputHandler_WaitForInputProcessed_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !Object } interfaceRequest
   */

  getFrameWidgetInputHandler(
      interfaceRequest) {
    this.proxy.sendMessage(
        12,
        blink.mojom.WidgetInputHandler_GetFrameWidgetInputHandler_ParamsSpec.$,
        null,
        [
          interfaceRequest
        ],
        false);
  }

  
  /**
   * @param { !cc.mojom.BrowserControlsState } constraints
   * @param { !cc.mojom.BrowserControlsState } current
   * @param { !boolean } animate
   * @param { ?cc.mojom.BrowserControlsOffsetTagModifications } offsetTagModifications
   */

  updateBrowserControlsState(
      constraints,
      current,
      animate,
      offsetTagModifications) {
    this.proxy.sendMessage(
        13,
        blink.mojom.WidgetInputHandler_UpdateBrowserControlsState_ParamsSpec.$,
        null,
        [
          constraints,
          current,
          animate,
          offsetTagModifications
        ],
        false);
  }
};

/**
 * An object which receives request messages for the WidgetInputHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.WidgetInputHandlerReceiver = class {
  /**
   * @param {!blink.mojom.WidgetInputHandlerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.WidgetInputHandlerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.WidgetInputHandlerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.WidgetInputHandlerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.WidgetInputHandler_SetFocus_ParamsSpec.$,
        null,
        impl.setFocus.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.WidgetInputHandler_MouseCaptureLost_ParamsSpec.$,
        null,
        impl.mouseCaptureLost.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.WidgetInputHandler_SetEditCommandsForNextKeyEvent_ParamsSpec.$,
        null,
        impl.setEditCommandsForNextKeyEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.WidgetInputHandler_CursorVisibilityChanged_ParamsSpec.$,
        null,
        impl.cursorVisibilityChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.WidgetInputHandler_ImeSetComposition_ParamsSpec.$,
        blink.mojom.WidgetInputHandler_ImeSetComposition_ResponseParamsSpec.$,
        impl.imeSetComposition.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        blink.mojom.WidgetInputHandler_ImeCommitText_ParamsSpec.$,
        blink.mojom.WidgetInputHandler_ImeCommitText_ResponseParamsSpec.$,
        impl.imeCommitText.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        blink.mojom.WidgetInputHandler_ImeFinishComposingText_ParamsSpec.$,
        null,
        impl.imeFinishComposingText.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        blink.mojom.WidgetInputHandler_RequestTextInputStateUpdate_ParamsSpec.$,
        null,
        impl.requestTextInputStateUpdate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        blink.mojom.WidgetInputHandler_RequestCompositionUpdates_ParamsSpec.$,
        null,
        impl.requestCompositionUpdates.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        blink.mojom.WidgetInputHandler_DispatchEvent_ParamsSpec.$,
        blink.mojom.WidgetInputHandler_DispatchEvent_ResponseParamsSpec.$,
        impl.dispatchEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        blink.mojom.WidgetInputHandler_DispatchNonBlockingEvent_ParamsSpec.$,
        null,
        impl.dispatchNonBlockingEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        blink.mojom.WidgetInputHandler_WaitForInputProcessed_ParamsSpec.$,
        blink.mojom.WidgetInputHandler_WaitForInputProcessed_ResponseParamsSpec.$,
        impl.waitForInputProcessed.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        blink.mojom.WidgetInputHandler_GetFrameWidgetInputHandler_ParamsSpec.$,
        null,
        impl.getFrameWidgetInputHandler.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        blink.mojom.WidgetInputHandler_UpdateBrowserControlsState_ParamsSpec.$,
        null,
        impl.updateBrowserControlsState.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.WidgetInputHandler = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.WidgetInputHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.WidgetInputHandlerRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.WidgetInputHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the WidgetInputHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.WidgetInputHandlerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.WidgetInputHandlerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.WidgetInputHandlerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setFocus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.WidgetInputHandler_SetFocus_ParamsSpec.$,
        null,
        this.setFocus.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.mouseCaptureLost =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.WidgetInputHandler_MouseCaptureLost_ParamsSpec.$,
        null,
        this.mouseCaptureLost.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setEditCommandsForNextKeyEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.WidgetInputHandler_SetEditCommandsForNextKeyEvent_ParamsSpec.$,
        null,
        this.setEditCommandsForNextKeyEvent.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cursorVisibilityChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.WidgetInputHandler_CursorVisibilityChanged_ParamsSpec.$,
        null,
        this.cursorVisibilityChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.imeSetComposition =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.WidgetInputHandler_ImeSetComposition_ParamsSpec.$,
        blink.mojom.WidgetInputHandler_ImeSetComposition_ResponseParamsSpec.$,
        this.imeSetComposition.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.imeCommitText =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        blink.mojom.WidgetInputHandler_ImeCommitText_ParamsSpec.$,
        blink.mojom.WidgetInputHandler_ImeCommitText_ResponseParamsSpec.$,
        this.imeCommitText.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.imeFinishComposingText =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        blink.mojom.WidgetInputHandler_ImeFinishComposingText_ParamsSpec.$,
        null,
        this.imeFinishComposingText.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestTextInputStateUpdate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        blink.mojom.WidgetInputHandler_RequestTextInputStateUpdate_ParamsSpec.$,
        null,
        this.requestTextInputStateUpdate.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestCompositionUpdates =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        blink.mojom.WidgetInputHandler_RequestCompositionUpdates_ParamsSpec.$,
        null,
        this.requestCompositionUpdates.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        blink.mojom.WidgetInputHandler_DispatchEvent_ParamsSpec.$,
        blink.mojom.WidgetInputHandler_DispatchEvent_ResponseParamsSpec.$,
        this.dispatchEvent.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchNonBlockingEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        blink.mojom.WidgetInputHandler_DispatchNonBlockingEvent_ParamsSpec.$,
        null,
        this.dispatchNonBlockingEvent.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.waitForInputProcessed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        blink.mojom.WidgetInputHandler_WaitForInputProcessed_ParamsSpec.$,
        blink.mojom.WidgetInputHandler_WaitForInputProcessed_ResponseParamsSpec.$,
        this.waitForInputProcessed.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getFrameWidgetInputHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        blink.mojom.WidgetInputHandler_GetFrameWidgetInputHandler_ParamsSpec.$,
        null,
        this.getFrameWidgetInputHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateBrowserControlsState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        blink.mojom.WidgetInputHandler_UpdateBrowserControlsState_ParamsSpec.$,
        null,
        this.updateBrowserControlsState.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.KeyDataSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.KeyDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.PointerDataSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PointerDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.WheelDataSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WheelDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.MouseDataSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MouseDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ScrollDataSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ScrollDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.PinchBeginDataSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PinchBeginDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.PinchUpdateDataSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PinchUpdateDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.PinchEndDataSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PinchEndDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FlingDataSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FlingDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.TapDataSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.TapDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.TapDownDataSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.TapDownDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.GestureDataSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.GestureDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.TouchPointSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.TouchPointSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.TouchDataSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.TouchDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.EventSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.EventSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.DidOverscrollParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DidOverscrollParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.TouchActionOptionalSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.TouchActionOptionalSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.EditCommandSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.EditCommandSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.SelectAroundCaretResultSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SelectAroundCaretResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.WidgetInputHandlerHost_SetTouchActionFromMain_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WidgetInputHandlerHost_SetTouchActionFromMain_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.WidgetInputHandlerHost_SetPanAction_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WidgetInputHandlerHost_SetPanAction_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.WidgetInputHandlerHost_DidOverscroll_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WidgetInputHandlerHost_DidOverscroll_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.WidgetInputHandlerHost_DidStartScrollingViewport_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WidgetInputHandlerHost_DidStartScrollingViewport_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.WidgetInputHandlerHost_ImeCancelComposition_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WidgetInputHandlerHost_ImeCancelComposition_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.WidgetInputHandlerHost_ImeCompositionRangeChanged_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WidgetInputHandlerHost_ImeCompositionRangeChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.WidgetInputHandlerHost_SetMouseCapture_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WidgetInputHandlerHost_SetMouseCapture_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.WidgetInputHandlerHost_SetAutoscrollSelectionActiveInMainFrame_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WidgetInputHandlerHost_SetAutoscrollSelectionActiveInMainFrame_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.WidgetInputHandlerHost_RequestMouseLock_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WidgetInputHandlerHost_RequestMouseLock_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.WidgetInputHandlerHost_RequestMouseLock_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WidgetInputHandlerHost_RequestMouseLock_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidgetInputHandler_AddImeTextSpansToExistingText_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidgetInputHandler_AddImeTextSpansToExistingText_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidgetInputHandler_ClearImeTextSpansByType_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidgetInputHandler_ClearImeTextSpansByType_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidgetInputHandler_SetCompositionFromExistingText_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidgetInputHandler_SetCompositionFromExistingText_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidgetInputHandler_ExtendSelectionAndDelete_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidgetInputHandler_ExtendSelectionAndDelete_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidgetInputHandler_ExtendSelectionAndReplace_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidgetInputHandler_ExtendSelectionAndReplace_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidgetInputHandler_DeleteSurroundingText_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidgetInputHandler_DeleteSurroundingText_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidgetInputHandler_DeleteSurroundingTextInCodePoints_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidgetInputHandler_DeleteSurroundingTextInCodePoints_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidgetInputHandler_SetEditableSelectionOffsets_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidgetInputHandler_SetEditableSelectionOffsets_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidgetInputHandler_HandleStylusWritingGestureAction_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidgetInputHandler_HandleStylusWritingGestureAction_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidgetInputHandler_HandleStylusWritingGestureAction_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidgetInputHandler_HandleStylusWritingGestureAction_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidgetInputHandler_ExecuteEditCommand_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidgetInputHandler_ExecuteEditCommand_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidgetInputHandler_Undo_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidgetInputHandler_Undo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidgetInputHandler_Redo_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidgetInputHandler_Redo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidgetInputHandler_Cut_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidgetInputHandler_Cut_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidgetInputHandler_Copy_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidgetInputHandler_Copy_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidgetInputHandler_CopyToFindPboard_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidgetInputHandler_CopyToFindPboard_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidgetInputHandler_CenterSelection_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidgetInputHandler_CenterSelection_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidgetInputHandler_Paste_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidgetInputHandler_Paste_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidgetInputHandler_PasteAndMatchStyle_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidgetInputHandler_PasteAndMatchStyle_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidgetInputHandler_Delete_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidgetInputHandler_Delete_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidgetInputHandler_SelectAll_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidgetInputHandler_SelectAll_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidgetInputHandler_CollapseSelection_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidgetInputHandler_CollapseSelection_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidgetInputHandler_CopyWithConfirmation_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidgetInputHandler_CopyWithConfirmation_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidgetInputHandler_CopyWithConfirmation_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidgetInputHandler_CopyWithConfirmation_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidgetInputHandler_PasteWithConfirmation_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidgetInputHandler_PasteWithConfirmation_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidgetInputHandler_PasteWithConfirmation_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidgetInputHandler_PasteWithConfirmation_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidgetInputHandler_Replace_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidgetInputHandler_Replace_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidgetInputHandler_ReplaceMisspelling_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidgetInputHandler_ReplaceMisspelling_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidgetInputHandler_SelectRange_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidgetInputHandler_SelectRange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidgetInputHandler_AdjustSelectionByCharacterOffset_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidgetInputHandler_AdjustSelectionByCharacterOffset_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidgetInputHandler_SelectAroundCaret_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidgetInputHandler_SelectAroundCaret_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidgetInputHandler_SelectAroundCaret_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidgetInputHandler_SelectAroundCaret_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidgetInputHandler_MoveRangeSelectionExtent_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidgetInputHandler_MoveRangeSelectionExtent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidgetInputHandler_ScrollFocusedEditableNodeIntoView_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidgetInputHandler_ScrollFocusedEditableNodeIntoView_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FrameWidgetInputHandler_MoveCaret_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FrameWidgetInputHandler_MoveCaret_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.WidgetInputHandler_SetFocus_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WidgetInputHandler_SetFocus_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.WidgetInputHandler_MouseCaptureLost_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WidgetInputHandler_MouseCaptureLost_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.WidgetInputHandler_SetEditCommandsForNextKeyEvent_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WidgetInputHandler_SetEditCommandsForNextKeyEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.WidgetInputHandler_CursorVisibilityChanged_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WidgetInputHandler_CursorVisibilityChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.WidgetInputHandler_ImeSetComposition_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WidgetInputHandler_ImeSetComposition_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.WidgetInputHandler_ImeSetComposition_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WidgetInputHandler_ImeSetComposition_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.WidgetInputHandler_ImeCommitText_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WidgetInputHandler_ImeCommitText_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.WidgetInputHandler_ImeCommitText_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WidgetInputHandler_ImeCommitText_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.WidgetInputHandler_ImeFinishComposingText_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WidgetInputHandler_ImeFinishComposingText_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.WidgetInputHandler_RequestTextInputStateUpdate_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WidgetInputHandler_RequestTextInputStateUpdate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.WidgetInputHandler_RequestCompositionUpdates_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WidgetInputHandler_RequestCompositionUpdates_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.WidgetInputHandler_DispatchEvent_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WidgetInputHandler_DispatchEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.WidgetInputHandler_DispatchEvent_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WidgetInputHandler_DispatchEvent_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.WidgetInputHandler_DispatchNonBlockingEvent_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WidgetInputHandler_DispatchNonBlockingEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.WidgetInputHandler_WaitForInputProcessed_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WidgetInputHandler_WaitForInputProcessed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.WidgetInputHandler_WaitForInputProcessed_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WidgetInputHandler_WaitForInputProcessed_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.WidgetInputHandler_GetFrameWidgetInputHandler_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WidgetInputHandler_GetFrameWidgetInputHandler_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.WidgetInputHandler_UpdateBrowserControlsState_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.WidgetInputHandler_UpdateBrowserControlsState_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.KeyDataSpec.$,
    'KeyData',
    [
      mojo.internal.StructField(
        'domKey', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'domCode', 4,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'windowsKeyCode', 8,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'nativeKeyCode', 12,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isSystemKey', 16,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isBrowserShortcut', 16,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'text', 24,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'unmodifiedText', 32,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);



goog.provide('blink.mojom.KeyData');

/** @record */
blink.mojom.KeyData = class {
  constructor() {
    /** @export { !number } */
    this.domKey;
    /** @export { !number } */
    this.domCode;
    /** @export { !number } */
    this.windowsKeyCode;
    /** @export { !number } */
    this.nativeKeyCode;
    /** @export { !boolean } */
    this.isSystemKey;
    /** @export { !boolean } */
    this.isBrowserShortcut;
    /** @export { !mojoBase.mojom.String16 } */
    this.text;
    /** @export { !mojoBase.mojom.String16 } */
    this.unmodifiedText;
  }
};



mojo.internal.Struct(
    blink.mojom.PointerDataSpec.$,
    'PointerData',
    [
      mojo.internal.StructField(
        'pointerId', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'force', 4,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'tiltX', 8,
        0,
        mojo.internal.Double,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'tiltY', 16,
        0,
        mojo.internal.Double,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'tangentialPressure', 24,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'twist', 28,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'button', 32,
        0,
        blink.mojom.ButtonSpec.$,
        -1,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pointerType', 36,
        0,
        ui.mojom.EventPointerTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'movementX', 40,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'movementY', 44,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isRawMovementEvent', 48,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'widgetPosition', 56,
        0,
        gfx.mojom.PointFSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'screenPosition', 64,
        0,
        gfx.mojom.PointFSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mouseData', 72,
        0,
        blink.mojom.MouseDataSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'deviceId', 52,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 88],]);



goog.provide('blink.mojom.PointerData');

/** @record */
blink.mojom.PointerData = class {
  constructor() {
    /** @export { !number } */
    this.pointerId;
    /** @export { !number } */
    this.force;
    /** @export { !number } */
    this.tiltX;
    /** @export { !number } */
    this.tiltY;
    /** @export { !number } */
    this.tangentialPressure;
    /** @export { !number } */
    this.twist;
    /** @export { !blink.mojom.Button } */
    this.button;
    /** @export { !ui.mojom.EventPointerType } */
    this.pointerType;
    /** @export { !number } */
    this.movementX;
    /** @export { !number } */
    this.movementY;
    /** @export { !boolean } */
    this.isRawMovementEvent;
    /** @export { !gfx.mojom.PointF } */
    this.widgetPosition;
    /** @export { !gfx.mojom.PointF } */
    this.screenPosition;
    /** @export { (blink.mojom.MouseData|undefined) } */
    this.mouseData;
    /** @export { !number } */
    this.deviceId;
  }
};



mojo.internal.Struct(
    blink.mojom.WheelDataSpec.$,
    'WheelData',
    [
      mojo.internal.StructField(
        'deltaX', 0,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'deltaY', 4,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'wheelTicksX', 8,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'wheelTicksY', 12,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'accelerationRatioX', 16,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'accelerationRatioY', 20,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'phase', 24,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'momentumPhase', 25,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cancelable', 28,
        0,
        blink.mojom.DispatchTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'eventAction', 26,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'deltaUnits', 27,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'railsMode', 32,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);



goog.provide('blink.mojom.WheelData');

/** @record */
blink.mojom.WheelData = class {
  constructor() {
    /** @export { !number } */
    this.deltaX;
    /** @export { !number } */
    this.deltaY;
    /** @export { !number } */
    this.wheelTicksX;
    /** @export { !number } */
    this.wheelTicksY;
    /** @export { !number } */
    this.accelerationRatioX;
    /** @export { !number } */
    this.accelerationRatioY;
    /** @export { !number } */
    this.phase;
    /** @export { !number } */
    this.momentumPhase;
    /** @export { !blink.mojom.DispatchType } */
    this.cancelable;
    /** @export { !number } */
    this.eventAction;
    /** @export { !number } */
    this.deltaUnits;
    /** @export { !number } */
    this.railsMode;
  }
};



mojo.internal.Struct(
    blink.mojom.MouseDataSpec.$,
    'MouseData',
    [
      mojo.internal.StructField(
        'clickCount', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'wheelData', 8,
        0,
        blink.mojom.WheelDataSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.MouseData');

/** @record */
blink.mojom.MouseData = class {
  constructor() {
    /** @export { !number } */
    this.clickCount;
    /** @export { (blink.mojom.WheelData|undefined) } */
    this.wheelData;
  }
};



mojo.internal.Struct(
    blink.mojom.ScrollDataSpec.$,
    'ScrollData',
    [
      mojo.internal.StructField(
        'deltaX', 0,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'deltaY', 4,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'deltaUnits', 8,
        0,
        ui.mojom.ScrollGranularitySpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'targetViewport', 12,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'inertialPhase', 16,
        0,
        blink.mojom.InertialPhaseStateSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'synthetic', 12,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pointerCount', 20,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cursorControl', 12,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.ScrollData');

/** @record */
blink.mojom.ScrollData = class {
  constructor() {
    /** @export { !number } */
    this.deltaX;
    /** @export { !number } */
    this.deltaY;
    /** @export { !ui.mojom.ScrollGranularity } */
    this.deltaUnits;
    /** @export { !boolean } */
    this.targetViewport;
    /** @export { !blink.mojom.InertialPhaseState } */
    this.inertialPhase;
    /** @export { !boolean } */
    this.synthetic;
    /** @export { !number } */
    this.pointerCount;
    /** @export { !boolean } */
    this.cursorControl;
  }
};



mojo.internal.Struct(
    blink.mojom.PinchBeginDataSpec.$,
    'PinchBeginData',
    [
      mojo.internal.StructField(
        'needsWheelEvent', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.PinchBeginData');

/** @record */
blink.mojom.PinchBeginData = class {
  constructor() {
    /** @export { !boolean } */
    this.needsWheelEvent;
  }
};



mojo.internal.Struct(
    blink.mojom.PinchUpdateDataSpec.$,
    'PinchUpdateData',
    [
      mojo.internal.StructField(
        'scale', 0,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'zoomDisabled', 4,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'needsWheelEvent', 4,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.PinchUpdateData');

/** @record */
blink.mojom.PinchUpdateData = class {
  constructor() {
    /** @export { !number } */
    this.scale;
    /** @export { !boolean } */
    this.zoomDisabled;
    /** @export { !boolean } */
    this.needsWheelEvent;
  }
};



mojo.internal.Struct(
    blink.mojom.PinchEndDataSpec.$,
    'PinchEndData',
    [
      mojo.internal.StructField(
        'needsWheelEvent', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.PinchEndData');

/** @record */
blink.mojom.PinchEndData = class {
  constructor() {
    /** @export { !boolean } */
    this.needsWheelEvent;
  }
};



mojo.internal.Struct(
    blink.mojom.FlingDataSpec.$,
    'FlingData',
    [
      mojo.internal.StructField(
        'velocityX', 0,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'velocityY', 4,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'targetViewport', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'preventBoosting', 8,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.FlingData');

/** @record */
blink.mojom.FlingData = class {
  constructor() {
    /** @export { !number } */
    this.velocityX;
    /** @export { !number } */
    this.velocityY;
    /** @export { !boolean } */
    this.targetViewport;
    /** @export { !boolean } */
    this.preventBoosting;
  }
};



mojo.internal.Struct(
    blink.mojom.TapDataSpec.$,
    'TapData',
    [
      mojo.internal.StructField(
        'tapCount', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'needsWheelEvent', 4,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.TapData');

/** @record */
blink.mojom.TapData = class {
  constructor() {
    /** @export { !number } */
    this.tapCount;
    /** @export { !boolean } */
    this.needsWheelEvent;
  }
};



mojo.internal.Struct(
    blink.mojom.TapDownDataSpec.$,
    'TapDownData',
    [
      mojo.internal.StructField(
        'tapDownCount', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.TapDownData');

/** @record */
blink.mojom.TapDownData = class {
  constructor() {
    /** @export { !number } */
    this.tapDownCount;
  }
};



mojo.internal.Struct(
    blink.mojom.GestureDataSpec.$,
    'GestureData',
    [
      mojo.internal.StructField(
        'screenPosition', 0,
        0,
        gfx.mojom.PointFSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'widgetPosition', 8,
        0,
        gfx.mojom.PointFSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sourceDevice', 16,
        0,
        blink.mojom.GestureDeviceSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isSourceTouchEventSetBlocking', 20,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'primaryPointerType', 24,
        0,
        ui.mojom.EventPointerTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'primaryUniqueTouchEventId', 28,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'uniqueTouchEventId', 32,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'contactSize', 40,
        0,
        gfx.mojom.SizeSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'scrollData', 48,
        0,
        blink.mojom.ScrollDataSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pinchBeginData', 56,
        0,
        blink.mojom.PinchBeginDataSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pinchUpdateData', 64,
        0,
        blink.mojom.PinchUpdateDataSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pinchEndData', 72,
        0,
        blink.mojom.PinchEndDataSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'tapData', 80,
        0,
        blink.mojom.TapDataSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'tapDownData', 88,
        0,
        blink.mojom.TapDownDataSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'flingData', 96,
        0,
        blink.mojom.FlingDataSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 112],]);



goog.provide('blink.mojom.GestureData');

/** @record */
blink.mojom.GestureData = class {
  constructor() {
    /** @export { !gfx.mojom.PointF } */
    this.screenPosition;
    /** @export { !gfx.mojom.PointF } */
    this.widgetPosition;
    /** @export { !blink.mojom.GestureDevice } */
    this.sourceDevice;
    /** @export { !boolean } */
    this.isSourceTouchEventSetBlocking;
    /** @export { !ui.mojom.EventPointerType } */
    this.primaryPointerType;
    /** @export { !number } */
    this.primaryUniqueTouchEventId;
    /** @export { !number } */
    this.uniqueTouchEventId;
    /** @export { (gfx.mojom.Size|undefined) } */
    this.contactSize;
    /** @export { (blink.mojom.ScrollData|undefined) } */
    this.scrollData;
    /** @export { (blink.mojom.PinchBeginData|undefined) } */
    this.pinchBeginData;
    /** @export { (blink.mojom.PinchUpdateData|undefined) } */
    this.pinchUpdateData;
    /** @export { (blink.mojom.PinchEndData|undefined) } */
    this.pinchEndData;
    /** @export { (blink.mojom.TapData|undefined) } */
    this.tapData;
    /** @export { (blink.mojom.TapDownData|undefined) } */
    this.tapDownData;
    /** @export { (blink.mojom.FlingData|undefined) } */
    this.flingData;
  }
};



mojo.internal.Struct(
    blink.mojom.TouchPointSpec.$,
    'TouchPoint',
    [
      mojo.internal.StructField(
        'state', 0,
        0,
        blink.mojom.TouchStateSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'radiusX', 4,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'radiusY', 8,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'rotationAngle', 12,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pointerData', 16,
        0,
        blink.mojom.PointerDataSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.TouchPoint');

/** @record */
blink.mojom.TouchPoint = class {
  constructor() {
    /** @export { !blink.mojom.TouchState } */
    this.state;
    /** @export { !number } */
    this.radiusX;
    /** @export { !number } */
    this.radiusY;
    /** @export { !number } */
    this.rotationAngle;
    /** @export { !blink.mojom.PointerData } */
    this.pointerData;
  }
};



mojo.internal.Struct(
    blink.mojom.TouchDataSpec.$,
    'TouchData',
    [
      mojo.internal.StructField(
        'cancelable', 0,
        0,
        blink.mojom.DispatchTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'movedBeyondSlopRegion', 4,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'touchStartOrFirstMove', 4,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hovering', 4,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'uniqueTouchEventId', 8,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'touches', 16,
        0,
        mojo.internal.Array(blink.mojom.TouchPointSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.TouchData');

/** @record */
blink.mojom.TouchData = class {
  constructor() {
    /** @export { !blink.mojom.DispatchType } */
    this.cancelable;
    /** @export { !boolean } */
    this.movedBeyondSlopRegion;
    /** @export { !boolean } */
    this.touchStartOrFirstMove;
    /** @export { !boolean } */
    this.hovering;
    /** @export { !number } */
    this.uniqueTouchEventId;
    /** @export { !Array<!blink.mojom.TouchPoint> } */
    this.touches;
  }
};



mojo.internal.Struct(
    blink.mojom.EventSpec.$,
    'Event',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        blink.mojom.EventTypeSpec.$,
        -1,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'modifiers', 4,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'timestamp', 8,
        0,
        mojoBase.mojom.TimeTicksSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'latency', 16,
        0,
        ui.mojom.LatencyInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'eventLatencyMetadata', 24,
        0,
        ui.mojom.EventLatencyMetadataSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'keyData', 32,
        0,
        blink.mojom.KeyDataSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pointerData', 40,
        0,
        blink.mojom.PointerDataSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'gestureData', 48,
        0,
        blink.mojom.GestureDataSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'touchData', 56,
        0,
        blink.mojom.TouchDataSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'inputSource', 64,
        0,
        blink.mojom.InputSourceSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 80],]);



goog.provide('blink.mojom.Event');

/** @record */
blink.mojom.Event = class {
  constructor() {
    /** @export { !blink.mojom.EventType } */
    this.type;
    /** @export { !number } */
    this.modifiers;
    /** @export { !mojoBase.mojom.TimeTicks } */
    this.timestamp;
    /** @export { !ui.mojom.LatencyInfo } */
    this.latency;
    /** @export { !ui.mojom.EventLatencyMetadata } */
    this.eventLatencyMetadata;
    /** @export { (blink.mojom.KeyData|undefined) } */
    this.keyData;
    /** @export { (blink.mojom.PointerData|undefined) } */
    this.pointerData;
    /** @export { (blink.mojom.GestureData|undefined) } */
    this.gestureData;
    /** @export { (blink.mojom.TouchData|undefined) } */
    this.touchData;
    /** @export { !blink.mojom.InputSource } */
    this.inputSource;
  }
};



mojo.internal.Struct(
    blink.mojom.DidOverscrollParamsSpec.$,
    'DidOverscrollParams',
    [
      mojo.internal.StructField(
        'accumulatedOverscroll', 0,
        0,
        gfx.mojom.Vector2dFSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'latestOverscrollDelta', 8,
        0,
        gfx.mojom.Vector2dFSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'currentFlingVelocity', 16,
        0,
        gfx.mojom.Vector2dFSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'causalEventViewportPoint', 24,
        0,
        gfx.mojom.PointFSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'overscrollBehavior', 32,
        0,
        cc.mojom.OverscrollBehaviorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);



goog.provide('blink.mojom.DidOverscrollParams');

/** @record */
blink.mojom.DidOverscrollParams = class {
  constructor() {
    /** @export { !gfx.mojom.Vector2dF } */
    this.accumulatedOverscroll;
    /** @export { !gfx.mojom.Vector2dF } */
    this.latestOverscrollDelta;
    /** @export { !gfx.mojom.Vector2dF } */
    this.currentFlingVelocity;
    /** @export { !gfx.mojom.PointF } */
    this.causalEventViewportPoint;
    /** @export { !cc.mojom.OverscrollBehavior } */
    this.overscrollBehavior;
  }
};



mojo.internal.Struct(
    blink.mojom.TouchActionOptionalSpec.$,
    'TouchActionOptional',
    [
      mojo.internal.StructField(
        'touchAction', 0,
        0,
        cc.mojom.TouchActionSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.TouchActionOptional');

/** @record */
blink.mojom.TouchActionOptional = class {
  constructor() {
    /** @export { !cc.mojom.TouchAction } */
    this.touchAction;
  }
};



mojo.internal.Struct(
    blink.mojom.EditCommandSpec.$,
    'EditCommand',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'value', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.EditCommand');

/** @record */
blink.mojom.EditCommand = class {
  constructor() {
    /** @export { !string } */
    this.name;
    /** @export { !string } */
    this.value;
  }
};



mojo.internal.Struct(
    blink.mojom.SelectAroundCaretResultSpec.$,
    'SelectAroundCaretResult',
    [
      mojo.internal.StructField(
        'extendedStartAdjust', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'extendedEndAdjust', 4,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'wordStartAdjust', 8,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'wordEndAdjust', 12,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.SelectAroundCaretResult');

/** @record */
blink.mojom.SelectAroundCaretResult = class {
  constructor() {
    /** @export { !number } */
    this.extendedStartAdjust;
    /** @export { !number } */
    this.extendedEndAdjust;
    /** @export { !number } */
    this.wordStartAdjust;
    /** @export { !number } */
    this.wordEndAdjust;
  }
};



mojo.internal.Struct(
    blink.mojom.WidgetInputHandlerHost_SetTouchActionFromMain_ParamsSpec.$,
    'WidgetInputHandlerHost_SetTouchActionFromMain_Params',
    [
      mojo.internal.StructField(
        'touchAction', 0,
        0,
        cc.mojom.TouchActionSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.WidgetInputHandlerHost_SetTouchActionFromMain_Params');

/** @record */
blink.mojom.WidgetInputHandlerHost_SetTouchActionFromMain_Params = class {
  constructor() {
    /** @export { !cc.mojom.TouchAction } */
    this.touchAction;
  }
};



mojo.internal.Struct(
    blink.mojom.WidgetInputHandlerHost_SetPanAction_ParamsSpec.$,
    'WidgetInputHandlerHost_SetPanAction_Params',
    [
      mojo.internal.StructField(
        'panAction', 0,
        0,
        blink.mojom.PanActionSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.WidgetInputHandlerHost_SetPanAction_Params');

/** @record */
blink.mojom.WidgetInputHandlerHost_SetPanAction_Params = class {
  constructor() {
    /** @export { !blink.mojom.PanAction } */
    this.panAction;
  }
};



mojo.internal.Struct(
    blink.mojom.WidgetInputHandlerHost_DidOverscroll_ParamsSpec.$,
    'WidgetInputHandlerHost_DidOverscroll_Params',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        blink.mojom.DidOverscrollParamsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.WidgetInputHandlerHost_DidOverscroll_Params');

/** @record */
blink.mojom.WidgetInputHandlerHost_DidOverscroll_Params = class {
  constructor() {
    /** @export { !blink.mojom.DidOverscrollParams } */
    this.params;
  }
};



mojo.internal.Struct(
    blink.mojom.WidgetInputHandlerHost_DidStartScrollingViewport_ParamsSpec.$,
    'WidgetInputHandlerHost_DidStartScrollingViewport_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.WidgetInputHandlerHost_DidStartScrollingViewport_Params');

/** @record */
blink.mojom.WidgetInputHandlerHost_DidStartScrollingViewport_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.WidgetInputHandlerHost_ImeCancelComposition_ParamsSpec.$,
    'WidgetInputHandlerHost_ImeCancelComposition_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.WidgetInputHandlerHost_ImeCancelComposition_Params');

/** @record */
blink.mojom.WidgetInputHandlerHost_ImeCancelComposition_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.WidgetInputHandlerHost_ImeCompositionRangeChanged_ParamsSpec.$,
    'WidgetInputHandlerHost_ImeCompositionRangeChanged_Params',
    [
      mojo.internal.StructField(
        'range', 0,
        0,
        gfx.mojom.RangeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'characterBounds', 8,
        0,
        mojo.internal.Array(gfx.mojom.RectSpec.$, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.WidgetInputHandlerHost_ImeCompositionRangeChanged_Params');

/** @record */
blink.mojom.WidgetInputHandlerHost_ImeCompositionRangeChanged_Params = class {
  constructor() {
    /** @export { !gfx.mojom.Range } */
    this.range;
    /** @export { (Array<!gfx.mojom.Rect>|undefined) } */
    this.characterBounds;
  }
};



mojo.internal.Struct(
    blink.mojom.WidgetInputHandlerHost_SetMouseCapture_ParamsSpec.$,
    'WidgetInputHandlerHost_SetMouseCapture_Params',
    [
      mojo.internal.StructField(
        'capture', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.WidgetInputHandlerHost_SetMouseCapture_Params');

/** @record */
blink.mojom.WidgetInputHandlerHost_SetMouseCapture_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.capture;
  }
};



mojo.internal.Struct(
    blink.mojom.WidgetInputHandlerHost_SetAutoscrollSelectionActiveInMainFrame_ParamsSpec.$,
    'WidgetInputHandlerHost_SetAutoscrollSelectionActiveInMainFrame_Params',
    [
      mojo.internal.StructField(
        'autoscrollSelection', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.WidgetInputHandlerHost_SetAutoscrollSelectionActiveInMainFrame_Params');

/** @record */
blink.mojom.WidgetInputHandlerHost_SetAutoscrollSelectionActiveInMainFrame_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.autoscrollSelection;
  }
};



mojo.internal.Struct(
    blink.mojom.WidgetInputHandlerHost_RequestMouseLock_ParamsSpec.$,
    'WidgetInputHandlerHost_RequestMouseLock_Params',
    [
      mojo.internal.StructField(
        'fromUserGesture', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'unadjustedMovement', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.WidgetInputHandlerHost_RequestMouseLock_Params');

/** @record */
blink.mojom.WidgetInputHandlerHost_RequestMouseLock_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.fromUserGesture;
    /** @export { !boolean } */
    this.unadjustedMovement;
  }
};



mojo.internal.Struct(
    blink.mojom.WidgetInputHandlerHost_RequestMouseLock_ResponseParamsSpec.$,
    'WidgetInputHandlerHost_RequestMouseLock_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.PointerLockResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'context', 4,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.PointerLockContextRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.WidgetInputHandlerHost_RequestMouseLock_ResponseParams');

/** @record */
blink.mojom.WidgetInputHandlerHost_RequestMouseLock_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.PointerLockResult } */
    this.result;
    /** @export { (blink.mojom.PointerLockContextRemote|undefined) } */
    this.context;
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidgetInputHandler_AddImeTextSpansToExistingText_ParamsSpec.$,
    'FrameWidgetInputHandler_AddImeTextSpansToExistingText_Params',
    [
      mojo.internal.StructField(
        'start', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'end', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'imeTextSpans', 8,
        0,
        mojo.internal.Array(ui.mojom.ImeTextSpanSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.FrameWidgetInputHandler_AddImeTextSpansToExistingText_Params');

/** @record */
blink.mojom.FrameWidgetInputHandler_AddImeTextSpansToExistingText_Params = class {
  constructor() {
    /** @export { !number } */
    this.start;
    /** @export { !number } */
    this.end;
    /** @export { !Array<!ui.mojom.ImeTextSpan> } */
    this.imeTextSpans;
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidgetInputHandler_ClearImeTextSpansByType_ParamsSpec.$,
    'FrameWidgetInputHandler_ClearImeTextSpansByType_Params',
    [
      mojo.internal.StructField(
        'start', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'end', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'type', 8,
        0,
        ui.mojom.ImeTextSpanTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.FrameWidgetInputHandler_ClearImeTextSpansByType_Params');

/** @record */
blink.mojom.FrameWidgetInputHandler_ClearImeTextSpansByType_Params = class {
  constructor() {
    /** @export { !number } */
    this.start;
    /** @export { !number } */
    this.end;
    /** @export { !ui.mojom.ImeTextSpanType } */
    this.type;
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidgetInputHandler_SetCompositionFromExistingText_ParamsSpec.$,
    'FrameWidgetInputHandler_SetCompositionFromExistingText_Params',
    [
      mojo.internal.StructField(
        'start', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'end', 4,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'imeTextSpans', 8,
        0,
        mojo.internal.Array(ui.mojom.ImeTextSpanSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.FrameWidgetInputHandler_SetCompositionFromExistingText_Params');

/** @record */
blink.mojom.FrameWidgetInputHandler_SetCompositionFromExistingText_Params = class {
  constructor() {
    /** @export { !number } */
    this.start;
    /** @export { !number } */
    this.end;
    /** @export { !Array<!ui.mojom.ImeTextSpan> } */
    this.imeTextSpans;
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidgetInputHandler_ExtendSelectionAndDelete_ParamsSpec.$,
    'FrameWidgetInputHandler_ExtendSelectionAndDelete_Params',
    [
      mojo.internal.StructField(
        'before', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'after', 4,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FrameWidgetInputHandler_ExtendSelectionAndDelete_Params');

/** @record */
blink.mojom.FrameWidgetInputHandler_ExtendSelectionAndDelete_Params = class {
  constructor() {
    /** @export { !number } */
    this.before;
    /** @export { !number } */
    this.after;
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidgetInputHandler_ExtendSelectionAndReplace_ParamsSpec.$,
    'FrameWidgetInputHandler_ExtendSelectionAndReplace_Params',
    [
      mojo.internal.StructField(
        'before', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'after', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'replacementText', 8,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.FrameWidgetInputHandler_ExtendSelectionAndReplace_Params');

/** @record */
blink.mojom.FrameWidgetInputHandler_ExtendSelectionAndReplace_Params = class {
  constructor() {
    /** @export { !number } */
    this.before;
    /** @export { !number } */
    this.after;
    /** @export { !mojoBase.mojom.String16 } */
    this.replacementText;
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidgetInputHandler_DeleteSurroundingText_ParamsSpec.$,
    'FrameWidgetInputHandler_DeleteSurroundingText_Params',
    [
      mojo.internal.StructField(
        'before', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'after', 4,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FrameWidgetInputHandler_DeleteSurroundingText_Params');

/** @record */
blink.mojom.FrameWidgetInputHandler_DeleteSurroundingText_Params = class {
  constructor() {
    /** @export { !number } */
    this.before;
    /** @export { !number } */
    this.after;
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidgetInputHandler_DeleteSurroundingTextInCodePoints_ParamsSpec.$,
    'FrameWidgetInputHandler_DeleteSurroundingTextInCodePoints_Params',
    [
      mojo.internal.StructField(
        'before', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'after', 4,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FrameWidgetInputHandler_DeleteSurroundingTextInCodePoints_Params');

/** @record */
blink.mojom.FrameWidgetInputHandler_DeleteSurroundingTextInCodePoints_Params = class {
  constructor() {
    /** @export { !number } */
    this.before;
    /** @export { !number } */
    this.after;
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidgetInputHandler_SetEditableSelectionOffsets_ParamsSpec.$,
    'FrameWidgetInputHandler_SetEditableSelectionOffsets_Params',
    [
      mojo.internal.StructField(
        'start', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'end', 4,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FrameWidgetInputHandler_SetEditableSelectionOffsets_Params');

/** @record */
blink.mojom.FrameWidgetInputHandler_SetEditableSelectionOffsets_Params = class {
  constructor() {
    /** @export { !number } */
    this.start;
    /** @export { !number } */
    this.end;
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidgetInputHandler_HandleStylusWritingGestureAction_ParamsSpec.$,
    'FrameWidgetInputHandler_HandleStylusWritingGestureAction_Params',
    [
      mojo.internal.StructField(
        'gestureData', 0,
        0,
        blink.mojom.StylusWritingGestureDataSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FrameWidgetInputHandler_HandleStylusWritingGestureAction_Params');

/** @record */
blink.mojom.FrameWidgetInputHandler_HandleStylusWritingGestureAction_Params = class {
  constructor() {
    /** @export { !blink.mojom.StylusWritingGestureData } */
    this.gestureData;
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidgetInputHandler_HandleStylusWritingGestureAction_ResponseParamsSpec.$,
    'FrameWidgetInputHandler_HandleStylusWritingGestureAction_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.HandwritingGestureResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FrameWidgetInputHandler_HandleStylusWritingGestureAction_ResponseParams');

/** @record */
blink.mojom.FrameWidgetInputHandler_HandleStylusWritingGestureAction_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.HandwritingGestureResult } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidgetInputHandler_ExecuteEditCommand_ParamsSpec.$,
    'FrameWidgetInputHandler_ExecuteEditCommand_Params',
    [
      mojo.internal.StructField(
        'command', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'value', 8,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.FrameWidgetInputHandler_ExecuteEditCommand_Params');

/** @record */
blink.mojom.FrameWidgetInputHandler_ExecuteEditCommand_Params = class {
  constructor() {
    /** @export { !string } */
    this.command;
    /** @export { (mojoBase.mojom.String16|undefined) } */
    this.value;
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidgetInputHandler_Undo_ParamsSpec.$,
    'FrameWidgetInputHandler_Undo_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.FrameWidgetInputHandler_Undo_Params');

/** @record */
blink.mojom.FrameWidgetInputHandler_Undo_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidgetInputHandler_Redo_ParamsSpec.$,
    'FrameWidgetInputHandler_Redo_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.FrameWidgetInputHandler_Redo_Params');

/** @record */
blink.mojom.FrameWidgetInputHandler_Redo_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidgetInputHandler_Cut_ParamsSpec.$,
    'FrameWidgetInputHandler_Cut_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.FrameWidgetInputHandler_Cut_Params');

/** @record */
blink.mojom.FrameWidgetInputHandler_Cut_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidgetInputHandler_Copy_ParamsSpec.$,
    'FrameWidgetInputHandler_Copy_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.FrameWidgetInputHandler_Copy_Params');

/** @record */
blink.mojom.FrameWidgetInputHandler_Copy_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidgetInputHandler_CopyToFindPboard_ParamsSpec.$,
    'FrameWidgetInputHandler_CopyToFindPboard_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.FrameWidgetInputHandler_CopyToFindPboard_Params');

/** @record */
blink.mojom.FrameWidgetInputHandler_CopyToFindPboard_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidgetInputHandler_CenterSelection_ParamsSpec.$,
    'FrameWidgetInputHandler_CenterSelection_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.FrameWidgetInputHandler_CenterSelection_Params');

/** @record */
blink.mojom.FrameWidgetInputHandler_CenterSelection_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidgetInputHandler_Paste_ParamsSpec.$,
    'FrameWidgetInputHandler_Paste_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.FrameWidgetInputHandler_Paste_Params');

/** @record */
blink.mojom.FrameWidgetInputHandler_Paste_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidgetInputHandler_PasteAndMatchStyle_ParamsSpec.$,
    'FrameWidgetInputHandler_PasteAndMatchStyle_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.FrameWidgetInputHandler_PasteAndMatchStyle_Params');

/** @record */
blink.mojom.FrameWidgetInputHandler_PasteAndMatchStyle_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidgetInputHandler_Delete_ParamsSpec.$,
    'FrameWidgetInputHandler_Delete_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.FrameWidgetInputHandler_Delete_Params');

/** @record */
blink.mojom.FrameWidgetInputHandler_Delete_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidgetInputHandler_SelectAll_ParamsSpec.$,
    'FrameWidgetInputHandler_SelectAll_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.FrameWidgetInputHandler_SelectAll_Params');

/** @record */
blink.mojom.FrameWidgetInputHandler_SelectAll_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidgetInputHandler_CollapseSelection_ParamsSpec.$,
    'FrameWidgetInputHandler_CollapseSelection_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.FrameWidgetInputHandler_CollapseSelection_Params');

/** @record */
blink.mojom.FrameWidgetInputHandler_CollapseSelection_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidgetInputHandler_CopyWithConfirmation_ParamsSpec.$,
    'FrameWidgetInputHandler_CopyWithConfirmation_Params',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FrameWidgetInputHandler_CopyWithConfirmation_Params');

/** @record */
blink.mojom.FrameWidgetInputHandler_CopyWithConfirmation_Params = class {
  constructor() {
    /** @export { !number } */
    this.token;
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidgetInputHandler_CopyWithConfirmation_ResponseParamsSpec.$,
    'FrameWidgetInputHandler_CopyWithConfirmation_ResponseParams',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FrameWidgetInputHandler_CopyWithConfirmation_ResponseParams');

/** @record */
blink.mojom.FrameWidgetInputHandler_CopyWithConfirmation_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.token;
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidgetInputHandler_PasteWithConfirmation_ParamsSpec.$,
    'FrameWidgetInputHandler_PasteWithConfirmation_Params',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FrameWidgetInputHandler_PasteWithConfirmation_Params');

/** @record */
blink.mojom.FrameWidgetInputHandler_PasteWithConfirmation_Params = class {
  constructor() {
    /** @export { !number } */
    this.token;
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidgetInputHandler_PasteWithConfirmation_ResponseParamsSpec.$,
    'FrameWidgetInputHandler_PasteWithConfirmation_ResponseParams',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FrameWidgetInputHandler_PasteWithConfirmation_ResponseParams');

/** @record */
blink.mojom.FrameWidgetInputHandler_PasteWithConfirmation_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.token;
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidgetInputHandler_Replace_ParamsSpec.$,
    'FrameWidgetInputHandler_Replace_Params',
    [
      mojo.internal.StructField(
        'word', 0,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FrameWidgetInputHandler_Replace_Params');

/** @record */
blink.mojom.FrameWidgetInputHandler_Replace_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.String16 } */
    this.word;
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidgetInputHandler_ReplaceMisspelling_ParamsSpec.$,
    'FrameWidgetInputHandler_ReplaceMisspelling_Params',
    [
      mojo.internal.StructField(
        'word', 0,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FrameWidgetInputHandler_ReplaceMisspelling_Params');

/** @record */
blink.mojom.FrameWidgetInputHandler_ReplaceMisspelling_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.String16 } */
    this.word;
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidgetInputHandler_SelectRange_ParamsSpec.$,
    'FrameWidgetInputHandler_SelectRange_Params',
    [
      mojo.internal.StructField(
        'base', 0,
        0,
        gfx.mojom.PointSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'extent', 8,
        0,
        gfx.mojom.PointSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.FrameWidgetInputHandler_SelectRange_Params');

/** @record */
blink.mojom.FrameWidgetInputHandler_SelectRange_Params = class {
  constructor() {
    /** @export { !gfx.mojom.Point } */
    this.base;
    /** @export { !gfx.mojom.Point } */
    this.extent;
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidgetInputHandler_AdjustSelectionByCharacterOffset_ParamsSpec.$,
    'FrameWidgetInputHandler_AdjustSelectionByCharacterOffset_Params',
    [
      mojo.internal.StructField(
        'start', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'end', 4,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'behavior', 8,
        0,
        blink.mojom.SelectionMenuBehaviorSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.FrameWidgetInputHandler_AdjustSelectionByCharacterOffset_Params');

/** @record */
blink.mojom.FrameWidgetInputHandler_AdjustSelectionByCharacterOffset_Params = class {
  constructor() {
    /** @export { !number } */
    this.start;
    /** @export { !number } */
    this.end;
    /** @export { !blink.mojom.SelectionMenuBehavior } */
    this.behavior;
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidgetInputHandler_SelectAroundCaret_ParamsSpec.$,
    'FrameWidgetInputHandler_SelectAroundCaret_Params',
    [
      mojo.internal.StructField(
        'granularity', 0,
        0,
        blink.mojom.SelectionGranularitySpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'shouldShowHandle', 4,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'shouldShowContextMenu', 4,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FrameWidgetInputHandler_SelectAroundCaret_Params');

/** @record */
blink.mojom.FrameWidgetInputHandler_SelectAroundCaret_Params = class {
  constructor() {
    /** @export { !blink.mojom.SelectionGranularity } */
    this.granularity;
    /** @export { !boolean } */
    this.shouldShowHandle;
    /** @export { !boolean } */
    this.shouldShowContextMenu;
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidgetInputHandler_SelectAroundCaret_ResponseParamsSpec.$,
    'FrameWidgetInputHandler_SelectAroundCaret_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.SelectAroundCaretResultSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FrameWidgetInputHandler_SelectAroundCaret_ResponseParams');

/** @record */
blink.mojom.FrameWidgetInputHandler_SelectAroundCaret_ResponseParams = class {
  constructor() {
    /** @export { (blink.mojom.SelectAroundCaretResult|undefined) } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidgetInputHandler_MoveRangeSelectionExtent_ParamsSpec.$,
    'FrameWidgetInputHandler_MoveRangeSelectionExtent_Params',
    [
      mojo.internal.StructField(
        'extent', 0,
        0,
        gfx.mojom.PointSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FrameWidgetInputHandler_MoveRangeSelectionExtent_Params');

/** @record */
blink.mojom.FrameWidgetInputHandler_MoveRangeSelectionExtent_Params = class {
  constructor() {
    /** @export { !gfx.mojom.Point } */
    this.extent;
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidgetInputHandler_ScrollFocusedEditableNodeIntoView_ParamsSpec.$,
    'FrameWidgetInputHandler_ScrollFocusedEditableNodeIntoView_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.FrameWidgetInputHandler_ScrollFocusedEditableNodeIntoView_Params');

/** @record */
blink.mojom.FrameWidgetInputHandler_ScrollFocusedEditableNodeIntoView_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ParamsSpec.$,
    'FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_Params');

/** @record */
blink.mojom.FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ResponseParamsSpec.$,
    'FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ResponseParams');

/** @record */
blink.mojom.FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.FrameWidgetInputHandler_MoveCaret_ParamsSpec.$,
    'FrameWidgetInputHandler_MoveCaret_Params',
    [
      mojo.internal.StructField(
        'point', 0,
        0,
        gfx.mojom.PointSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FrameWidgetInputHandler_MoveCaret_Params');

/** @record */
blink.mojom.FrameWidgetInputHandler_MoveCaret_Params = class {
  constructor() {
    /** @export { !gfx.mojom.Point } */
    this.point;
  }
};



mojo.internal.Struct(
    blink.mojom.WidgetInputHandler_SetFocus_ParamsSpec.$,
    'WidgetInputHandler_SetFocus_Params',
    [
      mojo.internal.StructField(
        'state', 0,
        0,
        blink.mojom.FocusStateSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.WidgetInputHandler_SetFocus_Params');

/** @record */
blink.mojom.WidgetInputHandler_SetFocus_Params = class {
  constructor() {
    /** @export { !blink.mojom.FocusState } */
    this.state;
  }
};



mojo.internal.Struct(
    blink.mojom.WidgetInputHandler_MouseCaptureLost_ParamsSpec.$,
    'WidgetInputHandler_MouseCaptureLost_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.WidgetInputHandler_MouseCaptureLost_Params');

/** @record */
blink.mojom.WidgetInputHandler_MouseCaptureLost_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.WidgetInputHandler_SetEditCommandsForNextKeyEvent_ParamsSpec.$,
    'WidgetInputHandler_SetEditCommandsForNextKeyEvent_Params',
    [
      mojo.internal.StructField(
        'commands', 0,
        0,
        mojo.internal.Array(blink.mojom.EditCommandSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.WidgetInputHandler_SetEditCommandsForNextKeyEvent_Params');

/** @record */
blink.mojom.WidgetInputHandler_SetEditCommandsForNextKeyEvent_Params = class {
  constructor() {
    /** @export { !Array<!blink.mojom.EditCommand> } */
    this.commands;
  }
};



mojo.internal.Struct(
    blink.mojom.WidgetInputHandler_CursorVisibilityChanged_ParamsSpec.$,
    'WidgetInputHandler_CursorVisibilityChanged_Params',
    [
      mojo.internal.StructField(
        'visible', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.WidgetInputHandler_CursorVisibilityChanged_Params');

/** @record */
blink.mojom.WidgetInputHandler_CursorVisibilityChanged_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.visible;
  }
};



mojo.internal.Struct(
    blink.mojom.WidgetInputHandler_ImeSetComposition_ParamsSpec.$,
    'WidgetInputHandler_ImeSetComposition_Params',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'imeTextSpans', 8,
        0,
        mojo.internal.Array(ui.mojom.ImeTextSpanSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'range', 16,
        0,
        gfx.mojom.RangeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'start', 24,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'end', 28,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('blink.mojom.WidgetInputHandler_ImeSetComposition_Params');

/** @record */
blink.mojom.WidgetInputHandler_ImeSetComposition_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.String16 } */
    this.text;
    /** @export { !Array<!ui.mojom.ImeTextSpan> } */
    this.imeTextSpans;
    /** @export { !gfx.mojom.Range } */
    this.range;
    /** @export { !number } */
    this.start;
    /** @export { !number } */
    this.end;
  }
};



mojo.internal.Struct(
    blink.mojom.WidgetInputHandler_ImeSetComposition_ResponseParamsSpec.$,
    'WidgetInputHandler_ImeSetComposition_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.WidgetInputHandler_ImeSetComposition_ResponseParams');

/** @record */
blink.mojom.WidgetInputHandler_ImeSetComposition_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.WidgetInputHandler_ImeCommitText_ParamsSpec.$,
    'WidgetInputHandler_ImeCommitText_Params',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'imeTextSpans', 8,
        0,
        mojo.internal.Array(ui.mojom.ImeTextSpanSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'range', 16,
        0,
        gfx.mojom.RangeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'relativeCursorPosition', 24,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('blink.mojom.WidgetInputHandler_ImeCommitText_Params');

/** @record */
blink.mojom.WidgetInputHandler_ImeCommitText_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.String16 } */
    this.text;
    /** @export { !Array<!ui.mojom.ImeTextSpan> } */
    this.imeTextSpans;
    /** @export { !gfx.mojom.Range } */
    this.range;
    /** @export { !number } */
    this.relativeCursorPosition;
  }
};



mojo.internal.Struct(
    blink.mojom.WidgetInputHandler_ImeCommitText_ResponseParamsSpec.$,
    'WidgetInputHandler_ImeCommitText_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.WidgetInputHandler_ImeCommitText_ResponseParams');

/** @record */
blink.mojom.WidgetInputHandler_ImeCommitText_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.WidgetInputHandler_ImeFinishComposingText_ParamsSpec.$,
    'WidgetInputHandler_ImeFinishComposingText_Params',
    [
      mojo.internal.StructField(
        'keepSelection', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.WidgetInputHandler_ImeFinishComposingText_Params');

/** @record */
blink.mojom.WidgetInputHandler_ImeFinishComposingText_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.keepSelection;
  }
};



mojo.internal.Struct(
    blink.mojom.WidgetInputHandler_RequestTextInputStateUpdate_ParamsSpec.$,
    'WidgetInputHandler_RequestTextInputStateUpdate_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.WidgetInputHandler_RequestTextInputStateUpdate_Params');

/** @record */
blink.mojom.WidgetInputHandler_RequestTextInputStateUpdate_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.WidgetInputHandler_RequestCompositionUpdates_ParamsSpec.$,
    'WidgetInputHandler_RequestCompositionUpdates_Params',
    [
      mojo.internal.StructField(
        'immediateRequest', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'monitorRequest', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.WidgetInputHandler_RequestCompositionUpdates_Params');

/** @record */
blink.mojom.WidgetInputHandler_RequestCompositionUpdates_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.immediateRequest;
    /** @export { !boolean } */
    this.monitorRequest;
  }
};



mojo.internal.Struct(
    blink.mojom.WidgetInputHandler_DispatchEvent_ParamsSpec.$,
    'WidgetInputHandler_DispatchEvent_Params',
    [
      mojo.internal.StructField(
        'event', 0,
        0,
        blink.mojom.EventSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'originalEventForGesture', 8,
        0,
        blink.mojom.EventSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.WidgetInputHandler_DispatchEvent_Params');

/** @record */
blink.mojom.WidgetInputHandler_DispatchEvent_Params = class {
  constructor() {
    /** @export { !blink.mojom.Event } */
    this.event;
    /** @export { (blink.mojom.Event|undefined) } */
    this.originalEventForGesture;
  }
};



mojo.internal.Struct(
    blink.mojom.WidgetInputHandler_DispatchEvent_ResponseParamsSpec.$,
    'WidgetInputHandler_DispatchEvent_ResponseParams',
    [
      mojo.internal.StructField(
        'source', 0,
        0,
        blink.mojom.InputEventResultSourceSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'updatedLatency', 8,
        0,
        ui.mojom.LatencyInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'state', 4,
        0,
        blink.mojom.InputEventResultStateSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'overscroll', 16,
        0,
        blink.mojom.DidOverscrollParamsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'touchAction', 24,
        0,
        blink.mojom.TouchActionOptionalSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('blink.mojom.WidgetInputHandler_DispatchEvent_ResponseParams');

/** @record */
blink.mojom.WidgetInputHandler_DispatchEvent_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.InputEventResultSource } */
    this.source;
    /** @export { !ui.mojom.LatencyInfo } */
    this.updatedLatency;
    /** @export { !blink.mojom.InputEventResultState } */
    this.state;
    /** @export { (blink.mojom.DidOverscrollParams|undefined) } */
    this.overscroll;
    /** @export { (blink.mojom.TouchActionOptional|undefined) } */
    this.touchAction;
  }
};



mojo.internal.Struct(
    blink.mojom.WidgetInputHandler_DispatchNonBlockingEvent_ParamsSpec.$,
    'WidgetInputHandler_DispatchNonBlockingEvent_Params',
    [
      mojo.internal.StructField(
        'event', 0,
        0,
        blink.mojom.EventSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.WidgetInputHandler_DispatchNonBlockingEvent_Params');

/** @record */
blink.mojom.WidgetInputHandler_DispatchNonBlockingEvent_Params = class {
  constructor() {
    /** @export { !blink.mojom.Event } */
    this.event;
  }
};



mojo.internal.Struct(
    blink.mojom.WidgetInputHandler_WaitForInputProcessed_ParamsSpec.$,
    'WidgetInputHandler_WaitForInputProcessed_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.WidgetInputHandler_WaitForInputProcessed_Params');

/** @record */
blink.mojom.WidgetInputHandler_WaitForInputProcessed_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.WidgetInputHandler_WaitForInputProcessed_ResponseParamsSpec.$,
    'WidgetInputHandler_WaitForInputProcessed_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.WidgetInputHandler_WaitForInputProcessed_ResponseParams');

/** @record */
blink.mojom.WidgetInputHandler_WaitForInputProcessed_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.WidgetInputHandler_GetFrameWidgetInputHandler_ParamsSpec.$,
    'WidgetInputHandler_GetFrameWidgetInputHandler_Params',
    [
      mojo.internal.StructField(
        'interfaceRequest', 0,
        0,
        mojo.internal.AssociatedInterfaceRequest(blink.mojom.FrameWidgetInputHandlerPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.WidgetInputHandler_GetFrameWidgetInputHandler_Params');

/** @record */
blink.mojom.WidgetInputHandler_GetFrameWidgetInputHandler_Params = class {
  constructor() {
    /** @export { !Object } */
    this.interfaceRequest;
  }
};



mojo.internal.Struct(
    blink.mojom.WidgetInputHandler_UpdateBrowserControlsState_ParamsSpec.$,
    'WidgetInputHandler_UpdateBrowserControlsState_Params',
    [
      mojo.internal.StructField(
        'constraints', 0,
        0,
        cc.mojom.BrowserControlsStateSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'current', 4,
        0,
        cc.mojom.BrowserControlsStateSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'animate', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'offsetTagModifications', 16,
        0,
        cc.mojom.BrowserControlsOffsetTagModificationsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.WidgetInputHandler_UpdateBrowserControlsState_Params');

/** @record */
blink.mojom.WidgetInputHandler_UpdateBrowserControlsState_Params = class {
  constructor() {
    /** @export { !cc.mojom.BrowserControlsState } */
    this.constraints;
    /** @export { !cc.mojom.BrowserControlsState } */
    this.current;
    /** @export { !boolean } */
    this.animate;
    /** @export { (cc.mojom.BrowserControlsOffsetTagModifications|undefined) } */
    this.offsetTagModifications;
  }
};

