// third_party/blink/public/mojom/frame_sinks/embedded_frame_sink.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/frame_sinks/embedded_frame_sink.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/frame_sinks/embedded_frame_sink.mojom-params-data.h"
#include "third_party/blink/public/mojom/frame_sinks/embedded_frame_sink.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/frame_sinks/embedded_frame_sink.mojom-import-headers.h"
#include "third_party/blink/public/mojom/frame_sinks/embedded_frame_sink.mojom-test-utils.h"


namespace blink::mojom {
// The declaration includes the definition on other builds.

SurfaceEmbedder::IPCStableHashFunction SurfaceEmbedder::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SurfaceEmbedder>(message.name())) {
    case messages::SurfaceEmbedder::kSetLocalSurfaceId: {
      return &SurfaceEmbedder::SetLocalSurfaceId_Sym::IPCStableHash;
    }
    case messages::SurfaceEmbedder::kOnOpacityChanged: {
      return &SurfaceEmbedder::OnOpacityChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SurfaceEmbedder::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SurfaceEmbedder>(message.name())) {
      case messages::SurfaceEmbedder::kSetLocalSurfaceId:
            return "Receive blink::mojom::SurfaceEmbedder::SetLocalSurfaceId";
      case messages::SurfaceEmbedder::kOnOpacityChanged:
            return "Receive blink::mojom::SurfaceEmbedder::OnOpacityChanged";
    }
  } else {
    switch (static_cast<messages::SurfaceEmbedder>(message.name())) {
      case messages::SurfaceEmbedder::kSetLocalSurfaceId:
            return "Receive reply blink::mojom::SurfaceEmbedder::SetLocalSurfaceId";
      case messages::SurfaceEmbedder::kOnOpacityChanged:
            return "Receive reply blink::mojom::SurfaceEmbedder::OnOpacityChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SurfaceEmbedder::SetLocalSurfaceId_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8df53fbe;  // IPCStableHash for blink::mojom::SurfaceEmbedder::SetLocalSurfaceId
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SurfaceEmbedder::OnOpacityChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4c68934a;  // IPCStableHash for blink::mojom::SurfaceEmbedder::OnOpacityChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

SurfaceEmbedderProxy::SurfaceEmbedderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SurfaceEmbedderProxy::SetLocalSurfaceId(
    const ::viz::LocalSurfaceId& in_local_surface_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::SurfaceEmbedder::SetLocalSurfaceId", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("local_surface_id"), in_local_surface_id,
                        "<value of type const ::viz::LocalSurfaceId&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SurfaceEmbedder::kSetLocalSurfaceId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SurfaceEmbedder_SetLocalSurfaceId_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->local_surface_id)::BaseType> local_surface_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::LocalSurfaceIdDataView>(
    in_local_surface_id,
    local_surface_id_fragment);

  params->local_surface_id.Set(
      local_surface_id_fragment.is_null() ? nullptr : local_surface_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->local_surface_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null local_surface_id in SurfaceEmbedder.SetLocalSurfaceId request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SurfaceEmbedder::Name_);
  message.set_method_name("SetLocalSurfaceId");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SurfaceEmbedderProxy::OnOpacityChanged(
    bool in_is_opaque) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::SurfaceEmbedder::OnOpacityChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_opaque"), in_is_opaque,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SurfaceEmbedder::kOnOpacityChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SurfaceEmbedder_OnOpacityChanged_Params_Data> params(
          message);
  params.Allocate();

  params->is_opaque = in_is_opaque;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SurfaceEmbedder::Name_);
  message.set_method_name("OnOpacityChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool SurfaceEmbedderStubDispatch::Accept(
    SurfaceEmbedder* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SurfaceEmbedder>(message->header()->name)) {
    case messages::SurfaceEmbedder::kSetLocalSurfaceId: {
      DCHECK(message->is_serialized());
      internal::SurfaceEmbedder_SetLocalSurfaceId_Params_Data* params =
          reinterpret_cast<internal::SurfaceEmbedder_SetLocalSurfaceId_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SurfaceEmbedder.0
      bool success = true;
      ::viz::LocalSurfaceId p_local_surface_id{};
      SurfaceEmbedder_SetLocalSurfaceId_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLocalSurfaceId(&p_local_surface_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SurfaceEmbedder::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetLocalSurfaceId(        
        std::move(p_local_surface_id));
      return true;
    }
    case messages::SurfaceEmbedder::kOnOpacityChanged: {
      DCHECK(message->is_serialized());
      internal::SurfaceEmbedder_OnOpacityChanged_Params_Data* params =
          reinterpret_cast<internal::SurfaceEmbedder_OnOpacityChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SurfaceEmbedder.1
      bool success = true;
      bool p_is_opaque{};
      SurfaceEmbedder_OnOpacityChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_opaque = input_data_view.is_opaque();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SurfaceEmbedder::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnOpacityChanged(        
        std::move(p_is_opaque));
      return true;
    }
  }
  return false;
}

// static
bool SurfaceEmbedderStubDispatch::AcceptWithResponder(
    SurfaceEmbedder* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SurfaceEmbedder>(message->header()->name)) {
    case messages::SurfaceEmbedder::kSetLocalSurfaceId: {
      break;
    }
    case messages::SurfaceEmbedder::kOnOpacityChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSurfaceEmbedderValidationInfo[] = {
    { &internal::SurfaceEmbedder_SetLocalSurfaceId_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SurfaceEmbedder_OnOpacityChanged_Params_Data::Validate,
     nullptr /* no response */},
};

bool SurfaceEmbedderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::SurfaceEmbedder::Name_,
    kSurfaceEmbedderValidationInfo);
}

// The declaration includes the definition on other builds.

EmbeddedFrameSinkClient::IPCStableHashFunction EmbeddedFrameSinkClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::EmbeddedFrameSinkClient>(message.name())) {
    case messages::EmbeddedFrameSinkClient::kBindSurfaceEmbedder: {
      return &EmbeddedFrameSinkClient::BindSurfaceEmbedder_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* EmbeddedFrameSinkClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::EmbeddedFrameSinkClient>(message.name())) {
      case messages::EmbeddedFrameSinkClient::kBindSurfaceEmbedder:
            return "Receive blink::mojom::EmbeddedFrameSinkClient::BindSurfaceEmbedder";
    }
  } else {
    switch (static_cast<messages::EmbeddedFrameSinkClient>(message.name())) {
      case messages::EmbeddedFrameSinkClient::kBindSurfaceEmbedder:
            return "Receive reply blink::mojom::EmbeddedFrameSinkClient::BindSurfaceEmbedder";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t EmbeddedFrameSinkClient::BindSurfaceEmbedder_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xba2f4362;  // IPCStableHash for blink::mojom::EmbeddedFrameSinkClient::BindSurfaceEmbedder
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

EmbeddedFrameSinkClientProxy::EmbeddedFrameSinkClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void EmbeddedFrameSinkClientProxy::BindSurfaceEmbedder(
    ::mojo::PendingReceiver<SurfaceEmbedder> in_embedder) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::EmbeddedFrameSinkClient::BindSurfaceEmbedder", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("embedder"), in_embedder,
                        "<value of type ::mojo::PendingReceiver<SurfaceEmbedder>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::EmbeddedFrameSinkClient::kBindSurfaceEmbedder), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::EmbeddedFrameSinkClient_BindSurfaceEmbedder_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::SurfaceEmbedderInterfaceBase>>(
    in_embedder,
    &params->embedder,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->embedder)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid embedder in EmbeddedFrameSinkClient.BindSurfaceEmbedder request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EmbeddedFrameSinkClient::Name_);
  message.set_method_name("BindSurfaceEmbedder");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool EmbeddedFrameSinkClientStubDispatch::Accept(
    EmbeddedFrameSinkClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::EmbeddedFrameSinkClient>(message->header()->name)) {
    case messages::EmbeddedFrameSinkClient::kBindSurfaceEmbedder: {
      DCHECK(message->is_serialized());
      internal::EmbeddedFrameSinkClient_BindSurfaceEmbedder_Params_Data* params =
          reinterpret_cast<internal::EmbeddedFrameSinkClient_BindSurfaceEmbedder_Params_Data*>(
              message->mutable_payload());
      

      // Validation for EmbeddedFrameSinkClient.0
      bool success = true;
      ::mojo::PendingReceiver<SurfaceEmbedder> p_embedder{};
      EmbeddedFrameSinkClient_BindSurfaceEmbedder_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_embedder =
            input_data_view.TakeEmbedder<decltype(p_embedder)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EmbeddedFrameSinkClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindSurfaceEmbedder(        
        std::move(p_embedder));
      return true;
    }
  }
  return false;
}

// static
bool EmbeddedFrameSinkClientStubDispatch::AcceptWithResponder(
    EmbeddedFrameSinkClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::EmbeddedFrameSinkClient>(message->header()->name)) {
    case messages::EmbeddedFrameSinkClient::kBindSurfaceEmbedder: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kEmbeddedFrameSinkClientValidationInfo[] = {
    { &internal::EmbeddedFrameSinkClient_BindSurfaceEmbedder_Params_Data::Validate,
     nullptr /* no response */},
};

bool EmbeddedFrameSinkClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::EmbeddedFrameSinkClient::Name_,
    kEmbeddedFrameSinkClientValidationInfo);
}

// The declaration includes the definition on other builds.

EmbeddedFrameSinkProvider::IPCStableHashFunction EmbeddedFrameSinkProvider::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::EmbeddedFrameSinkProvider>(message.name())) {
    case messages::EmbeddedFrameSinkProvider::kRegisterEmbeddedFrameSink: {
      return &EmbeddedFrameSinkProvider::RegisterEmbeddedFrameSink_Sym::IPCStableHash;
    }
    case messages::EmbeddedFrameSinkProvider::kRegisterEmbeddedFrameSinkBundle: {
      return &EmbeddedFrameSinkProvider::RegisterEmbeddedFrameSinkBundle_Sym::IPCStableHash;
    }
    case messages::EmbeddedFrameSinkProvider::kCreateCompositorFrameSink: {
      return &EmbeddedFrameSinkProvider::CreateCompositorFrameSink_Sym::IPCStableHash;
    }
    case messages::EmbeddedFrameSinkProvider::kCreateBundledCompositorFrameSink: {
      return &EmbeddedFrameSinkProvider::CreateBundledCompositorFrameSink_Sym::IPCStableHash;
    }
    case messages::EmbeddedFrameSinkProvider::kCreateSimpleCompositorFrameSink: {
      return &EmbeddedFrameSinkProvider::CreateSimpleCompositorFrameSink_Sym::IPCStableHash;
    }
    case messages::EmbeddedFrameSinkProvider::kConnectToEmbedder: {
      return &EmbeddedFrameSinkProvider::ConnectToEmbedder_Sym::IPCStableHash;
    }
    case messages::EmbeddedFrameSinkProvider::kRegisterFrameSinkHierarchy: {
      return &EmbeddedFrameSinkProvider::RegisterFrameSinkHierarchy_Sym::IPCStableHash;
    }
    case messages::EmbeddedFrameSinkProvider::kUnregisterFrameSinkHierarchy: {
      return &EmbeddedFrameSinkProvider::UnregisterFrameSinkHierarchy_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* EmbeddedFrameSinkProvider::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::EmbeddedFrameSinkProvider>(message.name())) {
      case messages::EmbeddedFrameSinkProvider::kRegisterEmbeddedFrameSink:
            return "Receive blink::mojom::EmbeddedFrameSinkProvider::RegisterEmbeddedFrameSink";
      case messages::EmbeddedFrameSinkProvider::kRegisterEmbeddedFrameSinkBundle:
            return "Receive blink::mojom::EmbeddedFrameSinkProvider::RegisterEmbeddedFrameSinkBundle";
      case messages::EmbeddedFrameSinkProvider::kCreateCompositorFrameSink:
            return "Receive blink::mojom::EmbeddedFrameSinkProvider::CreateCompositorFrameSink";
      case messages::EmbeddedFrameSinkProvider::kCreateBundledCompositorFrameSink:
            return "Receive blink::mojom::EmbeddedFrameSinkProvider::CreateBundledCompositorFrameSink";
      case messages::EmbeddedFrameSinkProvider::kCreateSimpleCompositorFrameSink:
            return "Receive blink::mojom::EmbeddedFrameSinkProvider::CreateSimpleCompositorFrameSink";
      case messages::EmbeddedFrameSinkProvider::kConnectToEmbedder:
            return "Receive blink::mojom::EmbeddedFrameSinkProvider::ConnectToEmbedder";
      case messages::EmbeddedFrameSinkProvider::kRegisterFrameSinkHierarchy:
            return "Receive blink::mojom::EmbeddedFrameSinkProvider::RegisterFrameSinkHierarchy";
      case messages::EmbeddedFrameSinkProvider::kUnregisterFrameSinkHierarchy:
            return "Receive blink::mojom::EmbeddedFrameSinkProvider::UnregisterFrameSinkHierarchy";
    }
  } else {
    switch (static_cast<messages::EmbeddedFrameSinkProvider>(message.name())) {
      case messages::EmbeddedFrameSinkProvider::kRegisterEmbeddedFrameSink:
            return "Receive reply blink::mojom::EmbeddedFrameSinkProvider::RegisterEmbeddedFrameSink";
      case messages::EmbeddedFrameSinkProvider::kRegisterEmbeddedFrameSinkBundle:
            return "Receive reply blink::mojom::EmbeddedFrameSinkProvider::RegisterEmbeddedFrameSinkBundle";
      case messages::EmbeddedFrameSinkProvider::kCreateCompositorFrameSink:
            return "Receive reply blink::mojom::EmbeddedFrameSinkProvider::CreateCompositorFrameSink";
      case messages::EmbeddedFrameSinkProvider::kCreateBundledCompositorFrameSink:
            return "Receive reply blink::mojom::EmbeddedFrameSinkProvider::CreateBundledCompositorFrameSink";
      case messages::EmbeddedFrameSinkProvider::kCreateSimpleCompositorFrameSink:
            return "Receive reply blink::mojom::EmbeddedFrameSinkProvider::CreateSimpleCompositorFrameSink";
      case messages::EmbeddedFrameSinkProvider::kConnectToEmbedder:
            return "Receive reply blink::mojom::EmbeddedFrameSinkProvider::ConnectToEmbedder";
      case messages::EmbeddedFrameSinkProvider::kRegisterFrameSinkHierarchy:
            return "Receive reply blink::mojom::EmbeddedFrameSinkProvider::RegisterFrameSinkHierarchy";
      case messages::EmbeddedFrameSinkProvider::kUnregisterFrameSinkHierarchy:
            return "Receive reply blink::mojom::EmbeddedFrameSinkProvider::UnregisterFrameSinkHierarchy";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t EmbeddedFrameSinkProvider::RegisterEmbeddedFrameSink_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe08d1e6a;  // IPCStableHash for blink::mojom::EmbeddedFrameSinkProvider::RegisterEmbeddedFrameSink
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t EmbeddedFrameSinkProvider::RegisterEmbeddedFrameSinkBundle_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x233c87b8;  // IPCStableHash for blink::mojom::EmbeddedFrameSinkProvider::RegisterEmbeddedFrameSinkBundle
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t EmbeddedFrameSinkProvider::CreateCompositorFrameSink_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xff7ac4a7;  // IPCStableHash for blink::mojom::EmbeddedFrameSinkProvider::CreateCompositorFrameSink
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t EmbeddedFrameSinkProvider::CreateBundledCompositorFrameSink_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7b42fe68;  // IPCStableHash for blink::mojom::EmbeddedFrameSinkProvider::CreateBundledCompositorFrameSink
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t EmbeddedFrameSinkProvider::CreateSimpleCompositorFrameSink_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd907e339;  // IPCStableHash for blink::mojom::EmbeddedFrameSinkProvider::CreateSimpleCompositorFrameSink
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t EmbeddedFrameSinkProvider::ConnectToEmbedder_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x63f5991a;  // IPCStableHash for blink::mojom::EmbeddedFrameSinkProvider::ConnectToEmbedder
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t EmbeddedFrameSinkProvider::RegisterFrameSinkHierarchy_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x22f987be;  // IPCStableHash for blink::mojom::EmbeddedFrameSinkProvider::RegisterFrameSinkHierarchy
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t EmbeddedFrameSinkProvider::UnregisterFrameSinkHierarchy_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9fcbfbc9;  // IPCStableHash for blink::mojom::EmbeddedFrameSinkProvider::UnregisterFrameSinkHierarchy
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

EmbeddedFrameSinkProviderProxy::EmbeddedFrameSinkProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void EmbeddedFrameSinkProviderProxy::RegisterEmbeddedFrameSink(
    const ::viz::FrameSinkId& in_parent_frame_sink_id, const ::viz::FrameSinkId& in_frame_sink_id, ::mojo::PendingRemote<EmbeddedFrameSinkClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::EmbeddedFrameSinkProvider::RegisterEmbeddedFrameSink", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("parent_frame_sink_id"), in_parent_frame_sink_id,
                        "<value of type const ::viz::FrameSinkId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_sink_id"), in_frame_sink_id,
                        "<value of type const ::viz::FrameSinkId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<EmbeddedFrameSinkClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::EmbeddedFrameSinkProvider::kRegisterEmbeddedFrameSink), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::EmbeddedFrameSinkProvider_RegisterEmbeddedFrameSink_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->parent_frame_sink_id)::BaseType> parent_frame_sink_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
    in_parent_frame_sink_id,
    parent_frame_sink_id_fragment);

  params->parent_frame_sink_id.Set(
      parent_frame_sink_id_fragment.is_null() ? nullptr : parent_frame_sink_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->parent_frame_sink_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null parent_frame_sink_id in EmbeddedFrameSinkProvider.RegisterEmbeddedFrameSink request");
  mojo::internal::MessageFragment<
      typename decltype(params->frame_sink_id)::BaseType> frame_sink_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
    in_frame_sink_id,
    frame_sink_id_fragment);

  params->frame_sink_id.Set(
      frame_sink_id_fragment.is_null() ? nullptr : frame_sink_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame_sink_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame_sink_id in EmbeddedFrameSinkProvider.RegisterEmbeddedFrameSink request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::EmbeddedFrameSinkClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in EmbeddedFrameSinkProvider.RegisterEmbeddedFrameSink request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EmbeddedFrameSinkProvider::Name_);
  message.set_method_name("RegisterEmbeddedFrameSink");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void EmbeddedFrameSinkProviderProxy::RegisterEmbeddedFrameSinkBundle(
    const ::viz::FrameSinkBundleId& in_bundle_id, ::mojo::PendingReceiver<::viz::mojom::FrameSinkBundle> in_receiver, ::mojo::PendingRemote<::viz::mojom::FrameSinkBundleClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::EmbeddedFrameSinkProvider::RegisterEmbeddedFrameSinkBundle", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bundle_id"), in_bundle_id,
                        "<value of type const ::viz::FrameSinkBundleId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::viz::mojom::FrameSinkBundle>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<::viz::mojom::FrameSinkBundleClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::EmbeddedFrameSinkProvider::kRegisterEmbeddedFrameSinkBundle), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::EmbeddedFrameSinkProvider_RegisterEmbeddedFrameSinkBundle_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bundle_id)::BaseType> bundle_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::FrameSinkBundleIdDataView>(
    in_bundle_id,
    bundle_id_fragment);

  params->bundle_id.Set(
      bundle_id_fragment.is_null() ? nullptr : bundle_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->bundle_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null bundle_id in EmbeddedFrameSinkProvider.RegisterEmbeddedFrameSinkBundle request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::viz::mojom::FrameSinkBundleInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in EmbeddedFrameSinkProvider.RegisterEmbeddedFrameSinkBundle request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::viz::mojom::FrameSinkBundleClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in EmbeddedFrameSinkProvider.RegisterEmbeddedFrameSinkBundle request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EmbeddedFrameSinkProvider::Name_);
  message.set_method_name("RegisterEmbeddedFrameSinkBundle");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void EmbeddedFrameSinkProviderProxy::CreateCompositorFrameSink(
    const ::viz::FrameSinkId& in_frame_sink_id, ::mojo::PendingRemote<::viz::mojom::CompositorFrameSinkClient> in_client, ::mojo::PendingReceiver<::viz::mojom::CompositorFrameSink> in_sink) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::EmbeddedFrameSinkProvider::CreateCompositorFrameSink", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_sink_id"), in_frame_sink_id,
                        "<value of type const ::viz::FrameSinkId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<::viz::mojom::CompositorFrameSinkClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sink"), in_sink,
                        "<value of type ::mojo::PendingReceiver<::viz::mojom::CompositorFrameSink>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::EmbeddedFrameSinkProvider::kCreateCompositorFrameSink), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::EmbeddedFrameSinkProvider_CreateCompositorFrameSink_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame_sink_id)::BaseType> frame_sink_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
    in_frame_sink_id,
    frame_sink_id_fragment);

  params->frame_sink_id.Set(
      frame_sink_id_fragment.is_null() ? nullptr : frame_sink_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame_sink_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame_sink_id in EmbeddedFrameSinkProvider.CreateCompositorFrameSink request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::viz::mojom::CompositorFrameSinkClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in EmbeddedFrameSinkProvider.CreateCompositorFrameSink request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::viz::mojom::CompositorFrameSinkInterfaceBase>>(
    in_sink,
    &params->sink,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->sink)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid sink in EmbeddedFrameSinkProvider.CreateCompositorFrameSink request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EmbeddedFrameSinkProvider::Name_);
  message.set_method_name("CreateCompositorFrameSink");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void EmbeddedFrameSinkProviderProxy::CreateBundledCompositorFrameSink(
    const ::viz::FrameSinkId& in_frame_sink_id, const ::viz::FrameSinkBundleId& in_bundle_id, ::mojo::PendingRemote<::viz::mojom::CompositorFrameSinkClient> in_client, ::mojo::PendingReceiver<::viz::mojom::CompositorFrameSink> in_sink) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::EmbeddedFrameSinkProvider::CreateBundledCompositorFrameSink", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_sink_id"), in_frame_sink_id,
                        "<value of type const ::viz::FrameSinkId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bundle_id"), in_bundle_id,
                        "<value of type const ::viz::FrameSinkBundleId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<::viz::mojom::CompositorFrameSinkClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sink"), in_sink,
                        "<value of type ::mojo::PendingReceiver<::viz::mojom::CompositorFrameSink>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::EmbeddedFrameSinkProvider::kCreateBundledCompositorFrameSink), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::EmbeddedFrameSinkProvider_CreateBundledCompositorFrameSink_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame_sink_id)::BaseType> frame_sink_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
    in_frame_sink_id,
    frame_sink_id_fragment);

  params->frame_sink_id.Set(
      frame_sink_id_fragment.is_null() ? nullptr : frame_sink_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame_sink_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame_sink_id in EmbeddedFrameSinkProvider.CreateBundledCompositorFrameSink request");
  mojo::internal::MessageFragment<
      typename decltype(params->bundle_id)::BaseType> bundle_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::FrameSinkBundleIdDataView>(
    in_bundle_id,
    bundle_id_fragment);

  params->bundle_id.Set(
      bundle_id_fragment.is_null() ? nullptr : bundle_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->bundle_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null bundle_id in EmbeddedFrameSinkProvider.CreateBundledCompositorFrameSink request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::viz::mojom::CompositorFrameSinkClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in EmbeddedFrameSinkProvider.CreateBundledCompositorFrameSink request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::viz::mojom::CompositorFrameSinkInterfaceBase>>(
    in_sink,
    &params->sink,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->sink)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid sink in EmbeddedFrameSinkProvider.CreateBundledCompositorFrameSink request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EmbeddedFrameSinkProvider::Name_);
  message.set_method_name("CreateBundledCompositorFrameSink");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void EmbeddedFrameSinkProviderProxy::CreateSimpleCompositorFrameSink(
    const ::viz::FrameSinkId& in_parent_frame_sink_id, const ::viz::FrameSinkId& in_frame_sink_id, ::mojo::PendingRemote<EmbeddedFrameSinkClient> in_surface_client, ::mojo::PendingRemote<::viz::mojom::CompositorFrameSinkClient> in_client, ::mojo::PendingReceiver<::viz::mojom::CompositorFrameSink> in_sink) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::EmbeddedFrameSinkProvider::CreateSimpleCompositorFrameSink", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("parent_frame_sink_id"), in_parent_frame_sink_id,
                        "<value of type const ::viz::FrameSinkId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_sink_id"), in_frame_sink_id,
                        "<value of type const ::viz::FrameSinkId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("surface_client"), in_surface_client,
                        "<value of type ::mojo::PendingRemote<EmbeddedFrameSinkClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<::viz::mojom::CompositorFrameSinkClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sink"), in_sink,
                        "<value of type ::mojo::PendingReceiver<::viz::mojom::CompositorFrameSink>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::EmbeddedFrameSinkProvider::kCreateSimpleCompositorFrameSink), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::EmbeddedFrameSinkProvider_CreateSimpleCompositorFrameSink_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->parent_frame_sink_id)::BaseType> parent_frame_sink_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
    in_parent_frame_sink_id,
    parent_frame_sink_id_fragment);

  params->parent_frame_sink_id.Set(
      parent_frame_sink_id_fragment.is_null() ? nullptr : parent_frame_sink_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->parent_frame_sink_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null parent_frame_sink_id in EmbeddedFrameSinkProvider.CreateSimpleCompositorFrameSink request");
  mojo::internal::MessageFragment<
      typename decltype(params->frame_sink_id)::BaseType> frame_sink_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
    in_frame_sink_id,
    frame_sink_id_fragment);

  params->frame_sink_id.Set(
      frame_sink_id_fragment.is_null() ? nullptr : frame_sink_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame_sink_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame_sink_id in EmbeddedFrameSinkProvider.CreateSimpleCompositorFrameSink request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::EmbeddedFrameSinkClientInterfaceBase>>(
    in_surface_client,
    &params->surface_client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->surface_client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid surface_client in EmbeddedFrameSinkProvider.CreateSimpleCompositorFrameSink request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::viz::mojom::CompositorFrameSinkClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in EmbeddedFrameSinkProvider.CreateSimpleCompositorFrameSink request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::viz::mojom::CompositorFrameSinkInterfaceBase>>(
    in_sink,
    &params->sink,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->sink)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid sink in EmbeddedFrameSinkProvider.CreateSimpleCompositorFrameSink request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EmbeddedFrameSinkProvider::Name_);
  message.set_method_name("CreateSimpleCompositorFrameSink");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void EmbeddedFrameSinkProviderProxy::ConnectToEmbedder(
    const ::viz::FrameSinkId& in_frame_sink_id, ::mojo::PendingReceiver<SurfaceEmbedder> in_embedder) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::EmbeddedFrameSinkProvider::ConnectToEmbedder", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_sink_id"), in_frame_sink_id,
                        "<value of type const ::viz::FrameSinkId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("embedder"), in_embedder,
                        "<value of type ::mojo::PendingReceiver<SurfaceEmbedder>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::EmbeddedFrameSinkProvider::kConnectToEmbedder), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::EmbeddedFrameSinkProvider_ConnectToEmbedder_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame_sink_id)::BaseType> frame_sink_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
    in_frame_sink_id,
    frame_sink_id_fragment);

  params->frame_sink_id.Set(
      frame_sink_id_fragment.is_null() ? nullptr : frame_sink_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame_sink_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame_sink_id in EmbeddedFrameSinkProvider.ConnectToEmbedder request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::SurfaceEmbedderInterfaceBase>>(
    in_embedder,
    &params->embedder,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->embedder)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid embedder in EmbeddedFrameSinkProvider.ConnectToEmbedder request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EmbeddedFrameSinkProvider::Name_);
  message.set_method_name("ConnectToEmbedder");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void EmbeddedFrameSinkProviderProxy::RegisterFrameSinkHierarchy(
    const ::viz::FrameSinkId& in_frame_sink_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::EmbeddedFrameSinkProvider::RegisterFrameSinkHierarchy", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_sink_id"), in_frame_sink_id,
                        "<value of type const ::viz::FrameSinkId&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::EmbeddedFrameSinkProvider::kRegisterFrameSinkHierarchy), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::EmbeddedFrameSinkProvider_RegisterFrameSinkHierarchy_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame_sink_id)::BaseType> frame_sink_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
    in_frame_sink_id,
    frame_sink_id_fragment);

  params->frame_sink_id.Set(
      frame_sink_id_fragment.is_null() ? nullptr : frame_sink_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame_sink_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame_sink_id in EmbeddedFrameSinkProvider.RegisterFrameSinkHierarchy request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EmbeddedFrameSinkProvider::Name_);
  message.set_method_name("RegisterFrameSinkHierarchy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void EmbeddedFrameSinkProviderProxy::UnregisterFrameSinkHierarchy(
    const ::viz::FrameSinkId& in_frame_sink_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::EmbeddedFrameSinkProvider::UnregisterFrameSinkHierarchy", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_sink_id"), in_frame_sink_id,
                        "<value of type const ::viz::FrameSinkId&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::EmbeddedFrameSinkProvider::kUnregisterFrameSinkHierarchy), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::EmbeddedFrameSinkProvider_UnregisterFrameSinkHierarchy_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame_sink_id)::BaseType> frame_sink_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
    in_frame_sink_id,
    frame_sink_id_fragment);

  params->frame_sink_id.Set(
      frame_sink_id_fragment.is_null() ? nullptr : frame_sink_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame_sink_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame_sink_id in EmbeddedFrameSinkProvider.UnregisterFrameSinkHierarchy request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(EmbeddedFrameSinkProvider::Name_);
  message.set_method_name("UnregisterFrameSinkHierarchy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool EmbeddedFrameSinkProviderStubDispatch::Accept(
    EmbeddedFrameSinkProvider* impl,
    mojo::Message* message) {
  switch (static_cast<messages::EmbeddedFrameSinkProvider>(message->header()->name)) {
    case messages::EmbeddedFrameSinkProvider::kRegisterEmbeddedFrameSink: {
      DCHECK(message->is_serialized());
      internal::EmbeddedFrameSinkProvider_RegisterEmbeddedFrameSink_Params_Data* params =
          reinterpret_cast<internal::EmbeddedFrameSinkProvider_RegisterEmbeddedFrameSink_Params_Data*>(
              message->mutable_payload());
      

      // Validation for EmbeddedFrameSinkProvider.0
      bool success = true;
      ::viz::FrameSinkId p_parent_frame_sink_id{};
      ::viz::FrameSinkId p_frame_sink_id{};
      ::mojo::PendingRemote<EmbeddedFrameSinkClient> p_client{};
      EmbeddedFrameSinkProvider_RegisterEmbeddedFrameSink_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParentFrameSinkId(&p_parent_frame_sink_id))
        success = false;
      if (success && !input_data_view.ReadFrameSinkId(&p_frame_sink_id))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EmbeddedFrameSinkProvider::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterEmbeddedFrameSink(        
        std::move(p_parent_frame_sink_id), 
        std::move(p_frame_sink_id), 
        std::move(p_client));
      return true;
    }
    case messages::EmbeddedFrameSinkProvider::kRegisterEmbeddedFrameSinkBundle: {
      DCHECK(message->is_serialized());
      internal::EmbeddedFrameSinkProvider_RegisterEmbeddedFrameSinkBundle_Params_Data* params =
          reinterpret_cast<internal::EmbeddedFrameSinkProvider_RegisterEmbeddedFrameSinkBundle_Params_Data*>(
              message->mutable_payload());
      

      // Validation for EmbeddedFrameSinkProvider.1
      bool success = true;
      ::viz::FrameSinkBundleId p_bundle_id{};
      ::mojo::PendingReceiver<::viz::mojom::FrameSinkBundle> p_receiver{};
      ::mojo::PendingRemote<::viz::mojom::FrameSinkBundleClient> p_client{};
      EmbeddedFrameSinkProvider_RegisterEmbeddedFrameSinkBundle_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBundleId(&p_bundle_id))
        success = false;
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EmbeddedFrameSinkProvider::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterEmbeddedFrameSinkBundle(        
        std::move(p_bundle_id), 
        std::move(p_receiver), 
        std::move(p_client));
      return true;
    }
    case messages::EmbeddedFrameSinkProvider::kCreateCompositorFrameSink: {
      DCHECK(message->is_serialized());
      internal::EmbeddedFrameSinkProvider_CreateCompositorFrameSink_Params_Data* params =
          reinterpret_cast<internal::EmbeddedFrameSinkProvider_CreateCompositorFrameSink_Params_Data*>(
              message->mutable_payload());
      

      // Validation for EmbeddedFrameSinkProvider.2
      bool success = true;
      ::viz::FrameSinkId p_frame_sink_id{};
      ::mojo::PendingRemote<::viz::mojom::CompositorFrameSinkClient> p_client{};
      ::mojo::PendingReceiver<::viz::mojom::CompositorFrameSink> p_sink{};
      EmbeddedFrameSinkProvider_CreateCompositorFrameSink_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFrameSinkId(&p_frame_sink_id))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success) {
        p_sink =
            input_data_view.TakeSink<decltype(p_sink)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EmbeddedFrameSinkProvider::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateCompositorFrameSink(        
        std::move(p_frame_sink_id), 
        std::move(p_client), 
        std::move(p_sink));
      return true;
    }
    case messages::EmbeddedFrameSinkProvider::kCreateBundledCompositorFrameSink: {
      DCHECK(message->is_serialized());
      internal::EmbeddedFrameSinkProvider_CreateBundledCompositorFrameSink_Params_Data* params =
          reinterpret_cast<internal::EmbeddedFrameSinkProvider_CreateBundledCompositorFrameSink_Params_Data*>(
              message->mutable_payload());
      

      // Validation for EmbeddedFrameSinkProvider.3
      bool success = true;
      ::viz::FrameSinkId p_frame_sink_id{};
      ::viz::FrameSinkBundleId p_bundle_id{};
      ::mojo::PendingRemote<::viz::mojom::CompositorFrameSinkClient> p_client{};
      ::mojo::PendingReceiver<::viz::mojom::CompositorFrameSink> p_sink{};
      EmbeddedFrameSinkProvider_CreateBundledCompositorFrameSink_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFrameSinkId(&p_frame_sink_id))
        success = false;
      if (success && !input_data_view.ReadBundleId(&p_bundle_id))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success) {
        p_sink =
            input_data_view.TakeSink<decltype(p_sink)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EmbeddedFrameSinkProvider::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateBundledCompositorFrameSink(        
        std::move(p_frame_sink_id), 
        std::move(p_bundle_id), 
        std::move(p_client), 
        std::move(p_sink));
      return true;
    }
    case messages::EmbeddedFrameSinkProvider::kCreateSimpleCompositorFrameSink: {
      DCHECK(message->is_serialized());
      internal::EmbeddedFrameSinkProvider_CreateSimpleCompositorFrameSink_Params_Data* params =
          reinterpret_cast<internal::EmbeddedFrameSinkProvider_CreateSimpleCompositorFrameSink_Params_Data*>(
              message->mutable_payload());
      

      // Validation for EmbeddedFrameSinkProvider.4
      bool success = true;
      ::viz::FrameSinkId p_parent_frame_sink_id{};
      ::viz::FrameSinkId p_frame_sink_id{};
      ::mojo::PendingRemote<EmbeddedFrameSinkClient> p_surface_client{};
      ::mojo::PendingRemote<::viz::mojom::CompositorFrameSinkClient> p_client{};
      ::mojo::PendingReceiver<::viz::mojom::CompositorFrameSink> p_sink{};
      EmbeddedFrameSinkProvider_CreateSimpleCompositorFrameSink_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParentFrameSinkId(&p_parent_frame_sink_id))
        success = false;
      if (success && !input_data_view.ReadFrameSinkId(&p_frame_sink_id))
        success = false;
      if (success) {
        p_surface_client =
            input_data_view.TakeSurfaceClient<decltype(p_surface_client)>();
      }
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success) {
        p_sink =
            input_data_view.TakeSink<decltype(p_sink)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EmbeddedFrameSinkProvider::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateSimpleCompositorFrameSink(        
        std::move(p_parent_frame_sink_id), 
        std::move(p_frame_sink_id), 
        std::move(p_surface_client), 
        std::move(p_client), 
        std::move(p_sink));
      return true;
    }
    case messages::EmbeddedFrameSinkProvider::kConnectToEmbedder: {
      DCHECK(message->is_serialized());
      internal::EmbeddedFrameSinkProvider_ConnectToEmbedder_Params_Data* params =
          reinterpret_cast<internal::EmbeddedFrameSinkProvider_ConnectToEmbedder_Params_Data*>(
              message->mutable_payload());
      

      // Validation for EmbeddedFrameSinkProvider.5
      bool success = true;
      ::viz::FrameSinkId p_frame_sink_id{};
      ::mojo::PendingReceiver<SurfaceEmbedder> p_embedder{};
      EmbeddedFrameSinkProvider_ConnectToEmbedder_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFrameSinkId(&p_frame_sink_id))
        success = false;
      if (success) {
        p_embedder =
            input_data_view.TakeEmbedder<decltype(p_embedder)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EmbeddedFrameSinkProvider::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ConnectToEmbedder(        
        std::move(p_frame_sink_id), 
        std::move(p_embedder));
      return true;
    }
    case messages::EmbeddedFrameSinkProvider::kRegisterFrameSinkHierarchy: {
      DCHECK(message->is_serialized());
      internal::EmbeddedFrameSinkProvider_RegisterFrameSinkHierarchy_Params_Data* params =
          reinterpret_cast<internal::EmbeddedFrameSinkProvider_RegisterFrameSinkHierarchy_Params_Data*>(
              message->mutable_payload());
      

      // Validation for EmbeddedFrameSinkProvider.6
      bool success = true;
      ::viz::FrameSinkId p_frame_sink_id{};
      EmbeddedFrameSinkProvider_RegisterFrameSinkHierarchy_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFrameSinkId(&p_frame_sink_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EmbeddedFrameSinkProvider::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterFrameSinkHierarchy(        
        std::move(p_frame_sink_id));
      return true;
    }
    case messages::EmbeddedFrameSinkProvider::kUnregisterFrameSinkHierarchy: {
      DCHECK(message->is_serialized());
      internal::EmbeddedFrameSinkProvider_UnregisterFrameSinkHierarchy_Params_Data* params =
          reinterpret_cast<internal::EmbeddedFrameSinkProvider_UnregisterFrameSinkHierarchy_Params_Data*>(
              message->mutable_payload());
      

      // Validation for EmbeddedFrameSinkProvider.7
      bool success = true;
      ::viz::FrameSinkId p_frame_sink_id{};
      EmbeddedFrameSinkProvider_UnregisterFrameSinkHierarchy_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFrameSinkId(&p_frame_sink_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            EmbeddedFrameSinkProvider::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UnregisterFrameSinkHierarchy(        
        std::move(p_frame_sink_id));
      return true;
    }
  }
  return false;
}

// static
bool EmbeddedFrameSinkProviderStubDispatch::AcceptWithResponder(
    EmbeddedFrameSinkProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::EmbeddedFrameSinkProvider>(message->header()->name)) {
    case messages::EmbeddedFrameSinkProvider::kRegisterEmbeddedFrameSink: {
      break;
    }
    case messages::EmbeddedFrameSinkProvider::kRegisterEmbeddedFrameSinkBundle: {
      break;
    }
    case messages::EmbeddedFrameSinkProvider::kCreateCompositorFrameSink: {
      break;
    }
    case messages::EmbeddedFrameSinkProvider::kCreateBundledCompositorFrameSink: {
      break;
    }
    case messages::EmbeddedFrameSinkProvider::kCreateSimpleCompositorFrameSink: {
      break;
    }
    case messages::EmbeddedFrameSinkProvider::kConnectToEmbedder: {
      break;
    }
    case messages::EmbeddedFrameSinkProvider::kRegisterFrameSinkHierarchy: {
      break;
    }
    case messages::EmbeddedFrameSinkProvider::kUnregisterFrameSinkHierarchy: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kEmbeddedFrameSinkProviderValidationInfo[] = {
    { &internal::EmbeddedFrameSinkProvider_RegisterEmbeddedFrameSink_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::EmbeddedFrameSinkProvider_RegisterEmbeddedFrameSinkBundle_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::EmbeddedFrameSinkProvider_CreateCompositorFrameSink_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::EmbeddedFrameSinkProvider_CreateBundledCompositorFrameSink_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::EmbeddedFrameSinkProvider_CreateSimpleCompositorFrameSink_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::EmbeddedFrameSinkProvider_ConnectToEmbedder_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::EmbeddedFrameSinkProvider_RegisterFrameSinkHierarchy_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::EmbeddedFrameSinkProvider_UnregisterFrameSinkHierarchy_Params_Data::Validate,
     nullptr /* no response */},
};

bool EmbeddedFrameSinkProviderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::EmbeddedFrameSinkProvider::Name_,
    kEmbeddedFrameSinkProviderValidationInfo);
}



}  // blink::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void SurfaceEmbedderInterceptorForTesting::SetLocalSurfaceId(const ::viz::LocalSurfaceId& local_surface_id) {
  GetForwardingInterface()->SetLocalSurfaceId(
    std::move(local_surface_id)
    );
}
void SurfaceEmbedderInterceptorForTesting::OnOpacityChanged(bool is_opaque) {
  GetForwardingInterface()->OnOpacityChanged(
    std::move(is_opaque)
    );
}
SurfaceEmbedderAsyncWaiter::SurfaceEmbedderAsyncWaiter(
    SurfaceEmbedder* proxy) : proxy_(proxy) {}

SurfaceEmbedderAsyncWaiter::~SurfaceEmbedderAsyncWaiter() = default;





void EmbeddedFrameSinkClientInterceptorForTesting::BindSurfaceEmbedder(::mojo::PendingReceiver<SurfaceEmbedder> embedder) {
  GetForwardingInterface()->BindSurfaceEmbedder(
    std::move(embedder)
    );
}
EmbeddedFrameSinkClientAsyncWaiter::EmbeddedFrameSinkClientAsyncWaiter(
    EmbeddedFrameSinkClient* proxy) : proxy_(proxy) {}

EmbeddedFrameSinkClientAsyncWaiter::~EmbeddedFrameSinkClientAsyncWaiter() = default;





void EmbeddedFrameSinkProviderInterceptorForTesting::RegisterEmbeddedFrameSink(const ::viz::FrameSinkId& parent_frame_sink_id, const ::viz::FrameSinkId& frame_sink_id, ::mojo::PendingRemote<EmbeddedFrameSinkClient> client) {
  GetForwardingInterface()->RegisterEmbeddedFrameSink(
    std::move(parent_frame_sink_id)
    , 
    std::move(frame_sink_id)
    , 
    std::move(client)
    );
}
void EmbeddedFrameSinkProviderInterceptorForTesting::RegisterEmbeddedFrameSinkBundle(const ::viz::FrameSinkBundleId& bundle_id, ::mojo::PendingReceiver<::viz::mojom::FrameSinkBundle> receiver, ::mojo::PendingRemote<::viz::mojom::FrameSinkBundleClient> client) {
  GetForwardingInterface()->RegisterEmbeddedFrameSinkBundle(
    std::move(bundle_id)
    , 
    std::move(receiver)
    , 
    std::move(client)
    );
}
void EmbeddedFrameSinkProviderInterceptorForTesting::CreateCompositorFrameSink(const ::viz::FrameSinkId& frame_sink_id, ::mojo::PendingRemote<::viz::mojom::CompositorFrameSinkClient> client, ::mojo::PendingReceiver<::viz::mojom::CompositorFrameSink> sink) {
  GetForwardingInterface()->CreateCompositorFrameSink(
    std::move(frame_sink_id)
    , 
    std::move(client)
    , 
    std::move(sink)
    );
}
void EmbeddedFrameSinkProviderInterceptorForTesting::CreateBundledCompositorFrameSink(const ::viz::FrameSinkId& frame_sink_id, const ::viz::FrameSinkBundleId& bundle_id, ::mojo::PendingRemote<::viz::mojom::CompositorFrameSinkClient> client, ::mojo::PendingReceiver<::viz::mojom::CompositorFrameSink> sink) {
  GetForwardingInterface()->CreateBundledCompositorFrameSink(
    std::move(frame_sink_id)
    , 
    std::move(bundle_id)
    , 
    std::move(client)
    , 
    std::move(sink)
    );
}
void EmbeddedFrameSinkProviderInterceptorForTesting::CreateSimpleCompositorFrameSink(const ::viz::FrameSinkId& parent_frame_sink_id, const ::viz::FrameSinkId& frame_sink_id, ::mojo::PendingRemote<EmbeddedFrameSinkClient> surface_client, ::mojo::PendingRemote<::viz::mojom::CompositorFrameSinkClient> client, ::mojo::PendingReceiver<::viz::mojom::CompositorFrameSink> sink) {
  GetForwardingInterface()->CreateSimpleCompositorFrameSink(
    std::move(parent_frame_sink_id)
    , 
    std::move(frame_sink_id)
    , 
    std::move(surface_client)
    , 
    std::move(client)
    , 
    std::move(sink)
    );
}
void EmbeddedFrameSinkProviderInterceptorForTesting::ConnectToEmbedder(const ::viz::FrameSinkId& frame_sink_id, ::mojo::PendingReceiver<SurfaceEmbedder> embedder) {
  GetForwardingInterface()->ConnectToEmbedder(
    std::move(frame_sink_id)
    , 
    std::move(embedder)
    );
}
void EmbeddedFrameSinkProviderInterceptorForTesting::RegisterFrameSinkHierarchy(const ::viz::FrameSinkId& frame_sink_id) {
  GetForwardingInterface()->RegisterFrameSinkHierarchy(
    std::move(frame_sink_id)
    );
}
void EmbeddedFrameSinkProviderInterceptorForTesting::UnregisterFrameSinkHierarchy(const ::viz::FrameSinkId& frame_sink_id) {
  GetForwardingInterface()->UnregisterFrameSinkHierarchy(
    std::move(frame_sink_id)
    );
}
EmbeddedFrameSinkProviderAsyncWaiter::EmbeddedFrameSinkProviderAsyncWaiter(
    EmbeddedFrameSinkProvider* proxy) : proxy_(proxy) {}

EmbeddedFrameSinkProviderAsyncWaiter::~EmbeddedFrameSinkProviderAsyncWaiter() = default;







}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif