// third_party/blink/public/mojom/frame/reporting_observer.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/frame/reporting_observer.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/frame/reporting_observer.mojom-params-data.h"
#include "third_party/blink/public/mojom/frame/reporting_observer.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/frame/reporting_observer.mojom-import-headers.h"
#include "third_party/blink/public/mojom/frame/reporting_observer.mojom-test-utils.h"


namespace blink::mojom {
ReportBodyElement::ReportBodyElement()
    : name(),
      value() {}

ReportBodyElement::ReportBodyElement(
    const std::string& name_in,
    const std::string& value_in)
    : name(std::move(name_in)),
      value(std::move(value_in)) {}

ReportBodyElement::~ReportBodyElement() = default;
size_t ReportBodyElement::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->name);
  seed = mojo::internal::Hash(seed, this->value);
  return seed;
}

void ReportBodyElement::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ReportBodyElement::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ReportBody::ReportBody()
    : body() {}

ReportBody::ReportBody(
    std::vector<ReportBodyElementPtr> body_in)
    : body(std::move(body_in)) {}

ReportBody::~ReportBody() = default;

void ReportBody::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "body"), this->body,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<ReportBodyElementPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ReportBody::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Report::Report()
    : type(),
      url(),
      body() {}

Report::Report(
    const std::string& type_in,
    const ::GURL& url_in,
    ReportBodyPtr body_in)
    : type(std::move(type_in)),
      url(std::move(url_in)),
      body(std::move(body_in)) {}

Report::~Report() = default;

void Report::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "body"), this->body,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ReportBodyPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Report::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

ReportingObserver::IPCStableHashFunction ReportingObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ReportingObserver>(message.name())) {
    case messages::ReportingObserver::kNotify: {
      return &ReportingObserver::Notify_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ReportingObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ReportingObserver>(message.name())) {
      case messages::ReportingObserver::kNotify:
            return "Receive blink::mojom::ReportingObserver::Notify";
    }
  } else {
    switch (static_cast<messages::ReportingObserver>(message.name())) {
      case messages::ReportingObserver::kNotify:
            return "Receive reply blink::mojom::ReportingObserver::Notify";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ReportingObserver::Notify_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x88d2806e;  // IPCStableHash for blink::mojom::ReportingObserver::Notify
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ReportingObserverProxy::ReportingObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ReportingObserverProxy::Notify(
    ReportPtr in_report) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ReportingObserver::Notify", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("report"), in_report,
                        "<value of type ReportPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ReportingObserver::kNotify), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ReportingObserver_Notify_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->report)::BaseType> report_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ReportDataView>(
    in_report,
    report_fragment);

  params->report.Set(
      report_fragment.is_null() ? nullptr : report_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->report.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null report in ReportingObserver.Notify request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ReportingObserver::Name_);
  message.set_method_name("Notify");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ReportingObserverStubDispatch::Accept(
    ReportingObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ReportingObserver>(message->header()->name)) {
    case messages::ReportingObserver::kNotify: {
      DCHECK(message->is_serialized());
      internal::ReportingObserver_Notify_Params_Data* params =
          reinterpret_cast<internal::ReportingObserver_Notify_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ReportingObserver.0
      bool success = true;
      ReportPtr p_report{};
      ReportingObserver_Notify_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReport(&p_report))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ReportingObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Notify(        
        std::move(p_report));
      return true;
    }
  }
  return false;
}

// static
bool ReportingObserverStubDispatch::AcceptWithResponder(
    ReportingObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ReportingObserver>(message->header()->name)) {
    case messages::ReportingObserver::kNotify: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kReportingObserverValidationInfo[] = {
    { &internal::ReportingObserver_Notify_Params_Data::Validate,
     nullptr /* no response */},
};

bool ReportingObserverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::ReportingObserver::Name_,
    kReportingObserverValidationInfo);
}



}  // blink::mojom


namespace mojo {


// static
bool StructTraits<::blink::mojom::ReportBodyElement::DataView, ::blink::mojom::ReportBodyElementPtr>::Read(
    ::blink::mojom::ReportBodyElement::DataView input,
    ::blink::mojom::ReportBodyElementPtr* output) {
  bool success = true;
  ::blink::mojom::ReportBodyElementPtr result(::blink::mojom::ReportBodyElement::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadValue(&result->value))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::ReportBody::DataView, ::blink::mojom::ReportBodyPtr>::Read(
    ::blink::mojom::ReportBody::DataView input,
    ::blink::mojom::ReportBodyPtr* output) {
  bool success = true;
  ::blink::mojom::ReportBodyPtr result(::blink::mojom::ReportBody::New());
  
      if (success && !input.ReadBody(&result->body))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::Report::DataView, ::blink::mojom::ReportPtr>::Read(
    ::blink::mojom::Report::DataView input,
    ::blink::mojom::ReportPtr* output) {
  bool success = true;
  ::blink::mojom::ReportPtr result(::blink::mojom::Report::New());
  
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadBody(&result->body))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void ReportingObserverInterceptorForTesting::Notify(ReportPtr report) {
  GetForwardingInterface()->Notify(
    std::move(report)
    );
}
ReportingObserverAsyncWaiter::ReportingObserverAsyncWaiter(
    ReportingObserver* proxy) : proxy_(proxy) {}

ReportingObserverAsyncWaiter::~ReportingObserverAsyncWaiter() = default;







}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif