// third_party/blink/public/mojom/frame/media_player_action.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/frame/media_player_action.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/frame/media_player_action.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* MediaPlayerActionTypeToStringHelper(MediaPlayerActionType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case MediaPlayerActionType::kLoop:
      return "kLoop";
    case MediaPlayerActionType::kControls:
      return "kControls";
    case MediaPlayerActionType::kSaveVideoFrameAs:
      return "kSaveVideoFrameAs";
    case MediaPlayerActionType::kCopyVideoFrame:
      return "kCopyVideoFrame";
    case MediaPlayerActionType::kPictureInPicture:
      return "{kPictureInPicture, kDefaultActionType}";
    default:
      return nullptr;
  }
}

std::string MediaPlayerActionTypeToString(MediaPlayerActionType value) {
  const char *str = MediaPlayerActionTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown MediaPlayerActionType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, MediaPlayerActionType value) {
  return os << MediaPlayerActionTypeToString(value);
}

namespace internal {


// static
bool MediaPlayerAction_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaPlayerAction_Data* object =
      static_cast<const MediaPlayerAction_Data*>(data);


  if (!::blink::mojom::internal::MediaPlayerActionType_Data
        ::Validate(object->type, validation_context))
    return false;

  return true;
}

MediaPlayerAction_Data::MediaPlayerAction_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::MediaPlayerActionType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::MediaPlayerActionType value) {
  return std::move(context).WriteString(::blink::mojom::MediaPlayerActionTypeToString(value));
}

} // namespace perfetto