// third_party/blink/public/mojom/frame/frame.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_MOJOM_TEST_UTILS_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_MOJOM_TEST_UTILS_H_

#include "third_party/blink/public/mojom/frame/frame.mojom.h"
#include "third_party/blink/public/common/common_export.h"


namespace blink::mojom {


class BLINK_COMMON_EXPORT LocalFrameHostInterceptorForTesting : public LocalFrameHost {
  virtual LocalFrameHost* GetForwardingInterface() = 0;
  void EnterFullscreen(::blink::mojom::FullscreenOptionsPtr options, EnterFullscreenCallback callback) override;
  void ExitFullscreen() override;
  void FullscreenStateChanged(bool is_fullscreen, ::blink::mojom::FullscreenOptionsPtr options) override;
  void RegisterProtocolHandler(const std::string& scheme, const ::GURL& url, bool user_gesture) override;
  void UnregisterProtocolHandler(const std::string& scheme, const ::GURL& url, bool user_gesture) override;
  void DidDisplayInsecureContent() override;
  void DidContainInsecureFormAction() override;
  void MainDocumentElementAvailable(bool uses_temporary_zoom_level) override;
  void SetNeedsOcclusionTracking(bool needs_tracking) override;
  void SetVirtualKeyboardMode(::ui::mojom::VirtualKeyboardMode type) override;
  void VisibilityChanged(::blink::mojom::FrameVisibility visibility) override;
  void DidChangeThemeColor(std::optional<::SkColor> theme_color) override;
  void DidChangeBackgroundColor(const ::SkColor4f& background_color, bool color_adjust) override;
  void DidFailLoadWithError(const ::GURL& url, int32_t error_code) override;
  void DidFocusFrame() override;
  void DidCallFocus() override;
  void EnforceInsecureRequestPolicy(::blink::mojom::InsecureRequestPolicy policy_bitmap) override;
  void EnforceInsecureNavigationsSet(const std::vector<uint32_t>& set) override;
  void SuddenTerminationDisablerChanged(bool present, ::blink::mojom::SuddenTerminationDisablerType disabler_type) override;
  void HadStickyUserActivationBeforeNavigationChanged(bool has_gesture) override;
  void ScrollRectToVisibleInParentFrame(const ::gfx::RectF& rect_to_scroll, ::blink::mojom::ScrollIntoViewParamsPtr params) override;
  void BubbleLogicalScrollInParentFrame(::blink::mojom::ScrollDirection direction, ::ui::ScrollGranularity granularity) override;
  void StartLoadingForAsyncNavigationApiCommit() override;
  void DidBlockNavigation(const ::GURL& blocked_url, ::blink::mojom::NavigationBlockedReason reason) override;
  void DidChangeLoadProgress(double load_progress) override;
  void DidFinishLoad(const ::GURL& validated_url) override;
  void DispatchLoad() override;
  void GoToEntryAtOffset(int32_t offset, bool has_user_gesture, ::base::TimeTicks actual_navigation_start, std::optional<::blink::scheduler::TaskAttributionId> soft_navigation_heuristics_task_id) override;
  void NavigateToNavigationApiKey(const std::string& key, bool has_user_gesture, ::base::TimeTicks actual_navigation_start, std::optional<::blink::scheduler::TaskAttributionId> soft_navigation_heuristics_task_id) override;
  void NavigateEventHandlerPresenceChanged(bool present) override;
  void UpdateTitle(const std::optional<::std::u16string>& title, ::base::i18n::TextDirection title_direction) override;
  void UpdateApplicationTitle(const ::std::u16string& application_title) override;
  void UpdateUserActivationState(::blink::mojom::UserActivationUpdateType update_type, ::blink::mojom::UserActivationNotificationType notification_type) override;
  void DidConsumeHistoryUserActivation() override;
  void HandleAccessibilityFindInPageResult(FindInPageResultAXParamsPtr params) override;
  void HandleAccessibilityFindInPageTermination() override;
  void DocumentOnLoadCompleted() override;
  void ForwardResourceTimingToParent(::blink::mojom::ResourceTimingInfoPtr timing) override;
  void DidDispatchDOMContentLoadedEvent() override;
  void RunModalAlertDialog(const ::std::u16string& alert_message, bool disable_third_party_subframe_suppresion, RunModalAlertDialogCallback callback) override;
  void RunModalConfirmDialog(const ::std::u16string& alert_message, bool disable_third_party_subframe_suppresion, RunModalConfirmDialogCallback callback) override;
  void RunModalPromptDialog(const ::std::u16string& alert_message, const ::std::u16string& default_value, bool disable_third_party_subframe_suppresion, RunModalPromptDialogCallback callback) override;
  void RunBeforeUnloadConfirm(bool is_reload, RunBeforeUnloadConfirmCallback callback) override;
  void UpdateFaviconURL(std::vector<::blink::mojom::FaviconURLPtr> favicon_urls) override;
  void DownloadURL(DownloadURLParamsPtr params) override;
  void FocusedElementChanged(bool is_editable_element, bool is_richly_editable_element, const ::gfx::Rect& bounds_in_frame_widget, ::blink::mojom::FocusType focus_type) override;
  void TextSelectionChanged(const ::std::u16string& text, uint32_t offset, const ::gfx::Range& range) override;
  void ShowPopupMenu(::mojo::PendingRemote<::blink::mojom::PopupMenuClient> popup_client, const ::gfx::Rect& bounds, double font_size, int32_t selected_item, std::vector<::blink::mojom::MenuItemPtr> menu_items, bool right_aligned, bool allow_multiple_selection) override;
  void CreateNewPopupWidget(::mojo::PendingAssociatedReceiver<::blink::mojom::PopupWidgetHost> popup_host, ::mojo::PendingAssociatedReceiver<::blink::mojom::WidgetHost> blink_widget_host, ::mojo::PendingAssociatedRemote<::blink::mojom::Widget> blink_widget) override;
  void ShowContextMenu(::mojo::PendingAssociatedRemote<::blink::mojom::ContextMenuClient> client, const ::blink::UntrustworthyContextMenuParams& params) override;
  void DidLoadResourceFromMemoryCache(const ::GURL& url, const std::string& http_method, const std::string& mime_type, ::network::mojom::RequestDestination request_destination, bool include_credentials) override;
  void DidChangeFrameOwnerProperties(const ::blink::FrameToken& child_frame_token, ::blink::mojom::FrameOwnerPropertiesPtr frame_owner_properties) override;
  void DidChangeOpener(const std::optional<::blink::LocalFrameToken>& opener_frame) override;
  void DidChangeFramePolicy(const ::blink::FrameToken& child_frame_token, const ::blink::FramePolicy& frame_policy) override;
  void DidChangeIframeAttributes(const ::blink::FrameToken& child_frame_token, IframeAttributesPtr attributes) override;
  void CapturePaintPreviewOfSubframe(const ::gfx::Rect& clip_rect, const ::base::UnguessableToken& guid) override;
  void SetCloseListener(::mojo::PendingRemote<::blink::mojom::CloseListener> listener) override;
  void Detach() override;
  void GetKeepAliveHandleFactory(::mojo::PendingReceiver<::blink::mojom::KeepAliveHandleFactory> factory) override;
  void DidAddMessageToConsole(::blink::mojom::ConsoleMessageLevel log_level, const ::std::u16string& msg, uint32_t line_number, const std::optional<::std::u16string>& source_id, const std::optional<::std::u16string>& untrusted_stack_trace) override;
  void FrameSizeChanged(const ::gfx::Size& size) override;
  void DidInferColorScheme(::blink::mojom::PreferredColorScheme color_scheme) override;
  void DidChangeSrcDoc(const ::blink::FrameToken& child_frame_token, const std::string& srcdoc_value) override;
  void ReceivedDelegatedCapability(::blink::mojom::DelegatedCapability delegated_capability) override;
  void SendFencedFrameReportingBeacon(const std::string& event_data, const std::string& event_type, const std::vector<::blink::FencedFrame::ReportingDestination>& destinations, bool cross_origin_exposed) override;
  void SendFencedFrameReportingBeaconToCustomURL(const ::GURL& destination_url, bool cross_origin_exposed) override;
  void DisableUntrustedNetworkInFencedFrame(DisableUntrustedNetworkInFencedFrameCallback callback) override;
  void ExemptUrlFromNetworkRevocationForTesting(const ::GURL& exempted_url, ExemptUrlFromNetworkRevocationForTestingCallback callback) override;
  void SendLegacyTechEvent(const std::string& type, LegacyTechEventCodeLocationPtr code_location) override;
  void SetFencedFrameAutomaticBeaconReportEventData(::blink::mojom::AutomaticBeaconType event_type, const std::string& event_data, const std::vector<::blink::FencedFrame::ReportingDestination>& destinations, bool once, bool cross_origin_exposed) override;
  void SendPrivateAggregationRequestsForFencedFrameEvent(const std::string& event_type) override;
  void CreateFencedFrame(::mojo::PendingAssociatedReceiver<::blink::mojom::FencedFrameOwnerHost> fenced_frame, ::blink::mojom::RemoteFrameInterfacesFromRendererPtr remote_frame_interfaces, const ::blink::RemoteFrameToken& frame_token, const ::base::UnguessableToken& devtools_frame_token) override;
  void ForwardFencedFrameEventAndUserActivationToEmbedder(const std::string& event_type) override;
  void OnViewTransitionOptInChanged(ViewTransitionSameOriginOptIn view_transition_opt_in) override;
  void StartDragging(::blink::mojom::DragDataPtr drag_data, ::blink::DragOperationsMask operations_allowed, const ::SkBitmap& image, const ::gfx::Vector2d& cursor_offset_in_dip, const ::gfx::Rect& drag_obj_rect_in_dip, ::blink::mojom::DragEventSourceInfoPtr event_info) override;
  void IssueKeepAliveHandle(::mojo::PendingReceiver<::blink::mojom::NavigationStateKeepAliveHandle> receiver) override;
  void NotifyStorageAccessed(StorageTypeAccessed storageType, bool blocked) override;
  void RecordWindowProxyUsageMetrics(const ::blink::FrameToken& target_frame_token, WindowProxyAccessType access_type) override;
  void NotifyDocumentInteractive() override;
  void SetStorageAccessApiStatus(::net::StorageAccessApiStatus status) override;
  void InitializeCrashReportStorage(uint64_t length, InitializeCrashReportStorageCallback callback) override;
  void SetCrashReportStorageKey(const std::string& key, const std::string& value, SetCrashReportStorageKeyCallback callback) override;
  void RemoveCrashReportStorageKey(const std::string& key, RemoveCrashReportStorageKeyCallback callback) override;
};
class BLINK_COMMON_EXPORT LocalFrameHostAsyncWaiter {
 public:
  explicit LocalFrameHostAsyncWaiter(LocalFrameHost* proxy);

  LocalFrameHostAsyncWaiter(const LocalFrameHostAsyncWaiter&) = delete;
  LocalFrameHostAsyncWaiter& operator=(const LocalFrameHostAsyncWaiter&) = delete;

  ~LocalFrameHostAsyncWaiter();
  void EnterFullscreen(
      ::blink::mojom::FullscreenOptionsPtr options, bool* out_granted);
  bool EnterFullscreen(::blink::mojom::FullscreenOptionsPtr options);
  void RunModalAlertDialog(
      const ::std::u16string& alert_message, bool disable_third_party_subframe_suppresion);
  
  void RunModalConfirmDialog(
      const ::std::u16string& alert_message, bool disable_third_party_subframe_suppresion, bool* out_success);
  bool RunModalConfirmDialog(const ::std::u16string& alert_message, bool disable_third_party_subframe_suppresion);
  void RunModalPromptDialog(
      const ::std::u16string& alert_message, const ::std::u16string& default_value, bool disable_third_party_subframe_suppresion, bool* out_success, ::std::u16string* out_result);
  
  void RunBeforeUnloadConfirm(
      bool is_reload, bool* out_success);
  bool RunBeforeUnloadConfirm(bool is_reload);
  void DisableUntrustedNetworkInFencedFrame(
      );
  
  void ExemptUrlFromNetworkRevocationForTesting(
      const ::GURL& exempted_url);
  
  void InitializeCrashReportStorage(
      uint64_t length);
  
  void SetCrashReportStorageKey(
      const std::string& key, const std::string& value);
  
  void RemoveCrashReportStorageKey(
      const std::string& key);
  

 private:
  LocalFrameHost* const proxy_;
};


class BLINK_COMMON_EXPORT NonAssociatedLocalFrameHostInterceptorForTesting : public NonAssociatedLocalFrameHost {
  virtual NonAssociatedLocalFrameHost* GetForwardingInterface() = 0;
  void MaybeStartOutermostMainFrameNavigation(const std::vector<::GURL>& urls) override;
};
class BLINK_COMMON_EXPORT NonAssociatedLocalFrameHostAsyncWaiter {
 public:
  explicit NonAssociatedLocalFrameHostAsyncWaiter(NonAssociatedLocalFrameHost* proxy);

  NonAssociatedLocalFrameHostAsyncWaiter(const NonAssociatedLocalFrameHostAsyncWaiter&) = delete;
  NonAssociatedLocalFrameHostAsyncWaiter& operator=(const NonAssociatedLocalFrameHostAsyncWaiter&) = delete;

  ~NonAssociatedLocalFrameHostAsyncWaiter();

 private:
  NonAssociatedLocalFrameHost* const proxy_;
};


class BLINK_COMMON_EXPORT LocalFrameInterceptorForTesting : public LocalFrame {
  virtual LocalFrame* GetForwardingInterface() = 0;
  void GetTextSurroundingSelection(uint32_t max_length, GetTextSurroundingSelectionCallback callback) override;
  void SendInterventionReport(const std::string& id, const std::string& message, const std::optional<::blink::FrameToken>& child_frame_token) override;
  void SetFrameOwnerProperties(::blink::mojom::FrameOwnerPropertiesPtr properties) override;
  void NotifyUserActivation(::blink::mojom::UserActivationNotificationType notification_type) override;
  void NotifyVirtualKeyboardOverlayRect(const ::gfx::Rect& keyboard_rect) override;
  void ShowInterestInElement(int32_t nodeID) override;
  void AddMessageToConsole(::blink::mojom::ConsoleMessageLevel level, const std::string& message, bool discard_duplicates) override;
  void SwapInImmediately() override;
  void CheckCompleted() override;
  void StopLoading() override;
  void Collapse(bool collapsed) override;
  void EnableViewSourceMode() override;
  void Focus() override;
  void ClearFocusedElement() override;
  void CopyImageAt(const ::gfx::Point& window_point) override;
  void SaveImageAt(const ::gfx::Point& window_point) override;
  void ReportBlinkFeatureUsage(const std::vector<::blink::mojom::WebFeature>& features) override;
  void RenderFallbackContent() override;
  void BeforeUnload(bool is_reload, BeforeUnloadCallback callback) override;
  void MediaPlayerActionAt(const ::gfx::Point& location, ::blink::mojom::MediaPlayerActionPtr action) override;
  void RequestVideoFrameAtWithBoundsHint(const ::gfx::Point& location, const ::gfx::Size& max_size, int32_t max_area, RequestVideoFrameAtWithBoundsHintCallback callback) override;
  void PluginActionAt(const ::gfx::Point& location, PluginActionType action) override;
  void AdvanceFocusInFrame(::blink::mojom::FocusType focus_type, const std::optional<::blink::RemoteFrameToken>& source_frame_token) override;
  void AdvanceFocusForIME(::blink::mojom::FocusType focus_type) override;
  void ReportContentSecurityPolicyViolation(::network::mojom::CSPViolationPtr violation) override;
  void DidUpdateFramePolicy(const ::blink::FramePolicy& frame_policy) override;
  void OnFrameVisibilityChanged(::blink::mojom::FrameVisibility visibility) override;
  void PostMessageEvent(const std::optional<::blink::RemoteFrameToken>& source_frame_token, const ::std::u16string& source_origin, const ::std::u16string& target_origin, ::blink::TransferableMessage message) override;
  void JavaScriptMethodExecuteRequest(const ::std::u16string& object_name, const ::std::u16string& method_name, ::base::Value::List arguments, bool wants_result, JavaScriptMethodExecuteRequestCallback callback) override;
  void JavaScriptExecuteRequest(const ::std::u16string& javascript, bool wants_result, JavaScriptExecuteRequestCallback callback) override;
  void JavaScriptExecuteRequestForTests(const ::std::u16string& javascript, bool has_user_gesture, bool resolve_promises, bool honor_js_content_settings, int32_t world_id, JavaScriptExecuteRequestForTestsCallback callback) override;
  void JavaScriptExecuteRequestInIsolatedWorld(const ::std::u16string& javascript, bool wants_result, int32_t world_id, JavaScriptExecuteRequestInIsolatedWorldCallback callback) override;
  void JavaScriptAwaitPromiseInIsolatedWorld(const ::std::u16string& javascript, int32_t world_id, JavaScriptAwaitPromiseInIsolatedWorldCallback callback) override;
  void GetCharacterIndexAtPoint(const ::gfx::Point& location) override;
  void GetFirstRectForRange(const ::gfx::Range& range) override;
  void GetStringForRange(const ::gfx::Range& range, GetStringForRangeCallback callback) override;
  void BindReportingObserver(::mojo::PendingReceiver<::blink::mojom::ReportingObserver> receiver) override;
  void UpdateOpener(const std::optional<::blink::FrameToken>& opener_frame_token) override;
  void GetSavableResourceLinks(GetSavableResourceLinksCallback callback) override;
  void MixedContentFound(const ::GURL& main_resource_url, const ::GURL& mixed_content_url, ::blink::mojom::RequestContextType request_context, bool was_allowed, const ::GURL& url_before_redirects, bool had_redirect, ::network::mojom::SourceLocationPtr source_location) override;
  void BindDevToolsAgent(::mojo::PendingAssociatedRemote<::blink::mojom::DevToolsAgentHost> agent_host, ::mojo::PendingAssociatedReceiver<::blink::mojom::DevToolsAgent> agent) override;
  void ExtractAnnotatedText(uint64_t char_count_goal, ExtractAnnotatedTextCallback callback) override;
  void ExtractSerializedDom(ExtractSerializedDomCallback callback) override;
  void ExtractSerializedDomElementInfo(const std::string& id, ExtractSerializedDomElementInfoCallback callback) override;
  void HandleRendererDebugURL(const ::GURL& url) override;
  void GetCanonicalUrlForSharing(GetCanonicalUrlForSharingCallback callback) override;
  void GetOpenGraphMetadata(GetOpenGraphMetadataCallback callback) override;
  void SetNavigationApiHistoryEntriesForRestore(::blink::mojom::NavigationApiHistoryEntryArraysPtr entry_arrays, NavigationApiEntryRestoreReason restore_reason) override;
  void UpdatePrerenderURL(const ::GURL& matched_url, UpdatePrerenderURLCallback callback) override;
  void NotifyNavigationApiOfDisposedEntries(const std::vector<std::string>& keys) override;
  void TraverseCancelled(const std::string& navigation_api_key, TraverseCancelledReason reason) override;
  void DispatchNavigateEventForCrossDocumentTraversal(const ::GURL& url, const std::string& page_state, bool is_browser_initiated) override;
  void SnapshotDocumentForViewTransition(const ::blink::ViewTransitionToken& transition_token, ::blink::mojom::PageSwapEventParamsPtr page_swap_event_params, SnapshotDocumentForViewTransitionCallback callback) override;
  void NotifyViewTransitionAbortedToOldDocument() override;
  void DispatchPageSwap(::blink::mojom::PageSwapEventParamsPtr page_swap_event_params) override;
  void AddResourceTimingEntryForFailedSubframeNavigation(const ::blink::FrameToken& subframe_token, const ::GURL& initial_url, ::base::TimeTicks start_time, ::base::TimeTicks redirect_time, ::base::TimeTicks request_start, ::base::TimeTicks response_start, uint32_t response_code, const std::string& mime_type, const ::net::LoadTimingInfo& load_timing_info, ::net::HttpConnectionInfo connection_info, const std::string& alpn_negotiated_protocol, bool is_secure_transport, bool is_validated, const std::string& normalized_server_timing, const ::network::URLLoaderCompletionStatus& completion_status) override;
  void GetScrollPosition(GetScrollPositionCallback callback) override;
};
class BLINK_COMMON_EXPORT LocalFrameAsyncWaiter {
 public:
  explicit LocalFrameAsyncWaiter(LocalFrame* proxy);

  LocalFrameAsyncWaiter(const LocalFrameAsyncWaiter&) = delete;
  LocalFrameAsyncWaiter& operator=(const LocalFrameAsyncWaiter&) = delete;

  ~LocalFrameAsyncWaiter();
  void GetTextSurroundingSelection(
      uint32_t max_length, ::std::u16string* out_content, uint32_t* out_start_offset, uint32_t* out_end_offset);
  
  void BeforeUnload(
      bool is_reload, bool* out_proceed, ::base::TimeTicks* out_before_unload_start_time, ::base::TimeTicks* out_before_unload_end_time);
  
  void RequestVideoFrameAtWithBoundsHint(
      const ::gfx::Point& location, const ::gfx::Size& max_size, int32_t max_area, ::SkBitmap* out_bitmap, ::gfx::Rect* out_bounds);
  
  void JavaScriptMethodExecuteRequest(
      const ::std::u16string& object_name, const ::std::u16string& method_name, ::base::Value::List arguments, bool wants_result, ::base::Value* out_result);
  ::base::Value JavaScriptMethodExecuteRequest(const ::std::u16string& object_name, const ::std::u16string& method_name, ::base::Value::List arguments, bool wants_result);
  void JavaScriptExecuteRequest(
      const ::std::u16string& javascript, bool wants_result, ::base::Value* out_result);
  ::base::Value JavaScriptExecuteRequest(const ::std::u16string& javascript, bool wants_result);
  void JavaScriptExecuteRequestForTests(
      const ::std::u16string& javascript, bool has_user_gesture, bool resolve_promises, bool honor_js_content_settings, int32_t world_id, JavaScriptExecutionResultType* out_result_type, ::base::Value* out_result);
  
  void JavaScriptExecuteRequestInIsolatedWorld(
      const ::std::u16string& javascript, bool wants_result, int32_t world_id, ::base::Value* out_result);
  ::base::Value JavaScriptExecuteRequestInIsolatedWorld(const ::std::u16string& javascript, bool wants_result, int32_t world_id);
  void JavaScriptAwaitPromiseInIsolatedWorld(
      const ::std::u16string& javascript, int32_t world_id, ::base::Value* out_result);
  ::base::Value JavaScriptAwaitPromiseInIsolatedWorld(const ::std::u16string& javascript, int32_t world_id);
  void GetStringForRange(
      const ::gfx::Range& range, ::ui::mojom::AttributedStringPtr* out_string, ::gfx::Point* out_baseline_point);
  
  void GetSavableResourceLinks(
      GetSavableResourceLinksReplyPtr* out_reply);
  GetSavableResourceLinksReplyPtr GetSavableResourceLinks();
  void ExtractAnnotatedText(
      uint64_t char_count_goal, ::std::u16string* out_annotated_text);
  ::std::u16string ExtractAnnotatedText(uint64_t char_count_goal);
  void ExtractSerializedDom(
      ::std::u16string* out_serialized_dom);
  ::std::u16string ExtractSerializedDom();
  void ExtractSerializedDomElementInfo(
      const std::string& id, SerializedDomElementInfoPtr* out_info);
  SerializedDomElementInfoPtr ExtractSerializedDomElementInfo(const std::string& id);
  void GetCanonicalUrlForSharing(
      std::optional<::GURL>* out_canonical_url);
  std::optional<::GURL> GetCanonicalUrlForSharing();
  void GetOpenGraphMetadata(
      ::blink::mojom::OpenGraphMetadataPtr* out_metadata);
  ::blink::mojom::OpenGraphMetadataPtr GetOpenGraphMetadata();
  void UpdatePrerenderURL(
      const ::GURL& matched_url);
  
  void SnapshotDocumentForViewTransition(
      const ::blink::ViewTransitionToken& transition_token, ::blink::mojom::PageSwapEventParamsPtr page_swap_event_params, ::blink::ViewTransitionState* out_view_transition_state);
  ::blink::ViewTransitionState SnapshotDocumentForViewTransition(const ::blink::ViewTransitionToken& transition_token, ::blink::mojom::PageSwapEventParamsPtr page_swap_event_params);
  void GetScrollPosition(
      ::gfx::Point* out_scroll_position);
  ::gfx::Point GetScrollPosition();

 private:
  LocalFrame* const proxy_;
};


class BLINK_COMMON_EXPORT LocalMainFrameInterceptorForTesting : public LocalMainFrame {
  virtual LocalMainFrame* GetForwardingInterface() = 0;
  void AnimateDoubleTapZoom(const ::gfx::Point& point, const ::gfx::Rect& rect) override;
  void SetScaleFactor(float scale) override;
  void ClosePage(ClosePageCallback callback) override;
  void GetFullPageSize(GetFullPageSizeCallback callback) override;
  void SetInitialFocus(bool reverse) override;
  void EnablePreferredSizeChangedMode() override;
  void ZoomToFindInPageRect(const ::gfx::Rect& rect_in_root_frame) override;
  void InstallCoopAccessMonitor(const ::blink::FrameToken& accessed_window, ::network::mojom::CrossOriginOpenerPolicyReporterParamsPtr coop_reporter_info) override;
  void UpdateBrowserControlsState(::cc::BrowserControlsState constraints, ::cc::BrowserControlsState current, bool animate, const std::optional<::cc::BrowserControlsOffsetTagModifications>& offset_tag_modifications) override;
  void SetV8CompileHints(::base::ReadOnlySharedMemoryRegion data) override;
  void Discard(DiscardCallback callback) override;
  void FinalizeNavigationConfidence(double randomized_trigger_rate, ::blink::mojom::ConfidenceLevel confidence) override;
};
class BLINK_COMMON_EXPORT LocalMainFrameAsyncWaiter {
 public:
  explicit LocalMainFrameAsyncWaiter(LocalMainFrame* proxy);

  LocalMainFrameAsyncWaiter(const LocalMainFrameAsyncWaiter&) = delete;
  LocalMainFrameAsyncWaiter& operator=(const LocalMainFrameAsyncWaiter&) = delete;

  ~LocalMainFrameAsyncWaiter();
  void ClosePage(
      );
  
  void GetFullPageSize(
      ::gfx::Size* out_full_page_size);
  ::gfx::Size GetFullPageSize();
  void Discard(
      );
  

 private:
  LocalMainFrame* const proxy_;
};


class BLINK_COMMON_EXPORT LocalMainFrameHostInterceptorForTesting : public LocalMainFrameHost {
  virtual LocalMainFrameHost* GetForwardingInterface() = 0;
  void ScaleFactorChanged(float scale) override;
  void ContentsPreferredSizeChanged(const ::gfx::Size& pref_size) override;
  void TextAutosizerPageInfoChanged(::blink::mojom::TextAutosizerPageInfoPtr page_info) override;
  void FocusPage() override;
  void TakeFocus(bool reverse) override;
  void UpdateTargetURL(const ::GURL& url, UpdateTargetURLCallback callback) override;
  void RequestClose() override;
  void ShowCreatedWindow(const ::blink::LocalFrameToken& opener_frame_token, ::WindowOpenDisposition disposition, ::blink::mojom::WindowFeaturesPtr window_features, bool opened_by_user_gesture, ShowCreatedWindowCallback callback) override;
  void SetWindowRect(const ::gfx::Rect& bounds, SetWindowRectCallback callback) override;
  void DidFirstVisuallyNonEmptyPaint() override;
  void DidAccessInitialMainDocument() override;
  void Maximize() override;
  void Minimize() override;
  void Restore() override;
  void SetResizable(bool resizable) override;
  void DraggableRegionsChanged(std::vector<::blink::mojom::DraggableRegionPtr> regions) override;
  void OnFirstContentfulPaint() override;
};
class BLINK_COMMON_EXPORT LocalMainFrameHostAsyncWaiter {
 public:
  explicit LocalMainFrameHostAsyncWaiter(LocalMainFrameHost* proxy);

  LocalMainFrameHostAsyncWaiter(const LocalMainFrameHostAsyncWaiter&) = delete;
  LocalMainFrameHostAsyncWaiter& operator=(const LocalMainFrameHostAsyncWaiter&) = delete;

  ~LocalMainFrameHostAsyncWaiter();
  void UpdateTargetURL(
      const ::GURL& url);
  
  void ShowCreatedWindow(
      const ::blink::LocalFrameToken& opener_frame_token, ::WindowOpenDisposition disposition, ::blink::mojom::WindowFeaturesPtr window_features, bool opened_by_user_gesture);
  
  void SetWindowRect(
      const ::gfx::Rect& bounds);
  

 private:
  LocalMainFrameHost* const proxy_;
};




}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_MOJOM_TEST_UTILS_H_