// third_party/blink/public/mojom/frame/back_forward_cache_controller.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/frame/back_forward_cache_controller.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/frame/back_forward_cache_controller.mojom-params-data.h"
#include "third_party/blink/public/mojom/frame/back_forward_cache_controller.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/frame/back_forward_cache_controller.mojom-import-headers.h"
#include "third_party/blink/public/mojom/frame/back_forward_cache_controller.mojom-test-utils.h"


namespace blink::mojom {
BlockingDetails::BlockingDetails()
    : feature(),
      source() {}

BlockingDetails::BlockingDetails(
    ::blink::mojom::WebSchedulerTrackedFeature feature_in,
    ::blink::mojom::ScriptSourceLocationPtr source_in)
    : feature(std::move(feature_in)),
      source(std::move(source_in)) {}

BlockingDetails::~BlockingDetails() = default;

void BlockingDetails::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "feature"), this->feature,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::WebSchedulerTrackedFeature>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source"), this->source,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::ScriptSourceLocationPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BlockingDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

BackForwardCacheControllerHost::IPCStableHashFunction BackForwardCacheControllerHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::BackForwardCacheControllerHost>(message.name())) {
    case messages::BackForwardCacheControllerHost::kEvictFromBackForwardCache: {
      return &BackForwardCacheControllerHost::EvictFromBackForwardCache_Sym::IPCStableHash;
    }
    case messages::BackForwardCacheControllerHost::kDidChangeBackForwardCacheDisablingFeatures: {
      return &BackForwardCacheControllerHost::DidChangeBackForwardCacheDisablingFeatures_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* BackForwardCacheControllerHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::BackForwardCacheControllerHost>(message.name())) {
      case messages::BackForwardCacheControllerHost::kEvictFromBackForwardCache:
            return "Receive blink::mojom::BackForwardCacheControllerHost::EvictFromBackForwardCache";
      case messages::BackForwardCacheControllerHost::kDidChangeBackForwardCacheDisablingFeatures:
            return "Receive blink::mojom::BackForwardCacheControllerHost::DidChangeBackForwardCacheDisablingFeatures";
    }
  } else {
    switch (static_cast<messages::BackForwardCacheControllerHost>(message.name())) {
      case messages::BackForwardCacheControllerHost::kEvictFromBackForwardCache:
            return "Receive reply blink::mojom::BackForwardCacheControllerHost::EvictFromBackForwardCache";
      case messages::BackForwardCacheControllerHost::kDidChangeBackForwardCacheDisablingFeatures:
            return "Receive reply blink::mojom::BackForwardCacheControllerHost::DidChangeBackForwardCacheDisablingFeatures";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t BackForwardCacheControllerHost::EvictFromBackForwardCache_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5a9bf30b;  // IPCStableHash for blink::mojom::BackForwardCacheControllerHost::EvictFromBackForwardCache
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BackForwardCacheControllerHost::DidChangeBackForwardCacheDisablingFeatures_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb8023ecd;  // IPCStableHash for blink::mojom::BackForwardCacheControllerHost::DidChangeBackForwardCacheDisablingFeatures
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

BackForwardCacheControllerHostProxy::BackForwardCacheControllerHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BackForwardCacheControllerHostProxy::EvictFromBackForwardCache(
    ::blink::mojom::RendererEvictionReason in_reason, ::blink::mojom::ScriptSourceLocationPtr in_source) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::BackForwardCacheControllerHost::EvictFromBackForwardCache", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason,
                        "<value of type ::blink::mojom::RendererEvictionReason>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type ::blink::mojom::ScriptSourceLocationPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BackForwardCacheControllerHost::kEvictFromBackForwardCache), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BackForwardCacheControllerHost_EvictFromBackForwardCache_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::RendererEvictionReason>(
    in_reason,
    &params->reason);
  mojo::internal::MessageFragment<
      typename decltype(params->source)::BaseType> source_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ScriptSourceLocationDataView>(
    in_source,
    source_fragment);

  params->source.Set(
      source_fragment.is_null() ? nullptr : source_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BackForwardCacheControllerHost::Name_);
  message.set_method_name("EvictFromBackForwardCache");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void BackForwardCacheControllerHostProxy::DidChangeBackForwardCacheDisablingFeatures(
    std::vector<BlockingDetailsPtr> in_details) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::BackForwardCacheControllerHost::DidChangeBackForwardCacheDisablingFeatures", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("details"), in_details,
                        "<value of type std::vector<BlockingDetailsPtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BackForwardCacheControllerHost::kDidChangeBackForwardCacheDisablingFeatures), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BackForwardCacheControllerHost_DidChangeBackForwardCacheDisablingFeatures_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->details)::BaseType>
      details_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& details_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::BlockingDetailsDataView>>(
    in_details,
    details_fragment,
    &details_validate_params);

  params->details.Set(
      details_fragment.is_null() ? nullptr : details_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->details.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null details in BackForwardCacheControllerHost.DidChangeBackForwardCacheDisablingFeatures request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BackForwardCacheControllerHost::Name_);
  message.set_method_name("DidChangeBackForwardCacheDisablingFeatures");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool BackForwardCacheControllerHostStubDispatch::Accept(
    BackForwardCacheControllerHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::BackForwardCacheControllerHost>(message->header()->name)) {
    case messages::BackForwardCacheControllerHost::kEvictFromBackForwardCache: {
      DCHECK(message->is_serialized());
      internal::BackForwardCacheControllerHost_EvictFromBackForwardCache_Params_Data* params =
          reinterpret_cast<internal::BackForwardCacheControllerHost_EvictFromBackForwardCache_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BackForwardCacheControllerHost.0
      bool success = true;
      ::blink::mojom::RendererEvictionReason p_reason{};
      ::blink::mojom::ScriptSourceLocationPtr p_source{};
      BackForwardCacheControllerHost_EvictFromBackForwardCache_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BackForwardCacheControllerHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EvictFromBackForwardCache(        
        std::move(p_reason), 
        std::move(p_source));
      return true;
    }
    case messages::BackForwardCacheControllerHost::kDidChangeBackForwardCacheDisablingFeatures: {
      DCHECK(message->is_serialized());
      internal::BackForwardCacheControllerHost_DidChangeBackForwardCacheDisablingFeatures_Params_Data* params =
          reinterpret_cast<internal::BackForwardCacheControllerHost_DidChangeBackForwardCacheDisablingFeatures_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BackForwardCacheControllerHost.1
      bool success = true;
      std::vector<BlockingDetailsPtr> p_details{};
      BackForwardCacheControllerHost_DidChangeBackForwardCacheDisablingFeatures_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDetails(&p_details))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BackForwardCacheControllerHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidChangeBackForwardCacheDisablingFeatures(        
        std::move(p_details));
      return true;
    }
  }
  return false;
}

// static
bool BackForwardCacheControllerHostStubDispatch::AcceptWithResponder(
    BackForwardCacheControllerHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::BackForwardCacheControllerHost>(message->header()->name)) {
    case messages::BackForwardCacheControllerHost::kEvictFromBackForwardCache: {
      break;
    }
    case messages::BackForwardCacheControllerHost::kDidChangeBackForwardCacheDisablingFeatures: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kBackForwardCacheControllerHostValidationInfo[] = {
    { &internal::BackForwardCacheControllerHost_EvictFromBackForwardCache_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::BackForwardCacheControllerHost_DidChangeBackForwardCacheDisablingFeatures_Params_Data::Validate,
     nullptr /* no response */},
};

bool BackForwardCacheControllerHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::BackForwardCacheControllerHost::Name_,
    kBackForwardCacheControllerHostValidationInfo);
}



}  // blink::mojom


namespace mojo {


// static
bool StructTraits<::blink::mojom::BlockingDetails::DataView, ::blink::mojom::BlockingDetailsPtr>::Read(
    ::blink::mojom::BlockingDetails::DataView input,
    ::blink::mojom::BlockingDetailsPtr* output) {
  bool success = true;
  ::blink::mojom::BlockingDetailsPtr result(::blink::mojom::BlockingDetails::New());
  
      if (success && !input.ReadFeature(&result->feature))
        success = false;
      if (success && !input.ReadSource(&result->source))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void BackForwardCacheControllerHostInterceptorForTesting::EvictFromBackForwardCache(::blink::mojom::RendererEvictionReason reason, ::blink::mojom::ScriptSourceLocationPtr source) {
  GetForwardingInterface()->EvictFromBackForwardCache(
    std::move(reason)
    , 
    std::move(source)
    );
}
void BackForwardCacheControllerHostInterceptorForTesting::DidChangeBackForwardCacheDisablingFeatures(std::vector<BlockingDetailsPtr> details) {
  GetForwardingInterface()->DidChangeBackForwardCacheDisablingFeatures(
    std::move(details)
    );
}
BackForwardCacheControllerHostAsyncWaiter::BackForwardCacheControllerHostAsyncWaiter(
    BackForwardCacheControllerHost* proxy) : proxy_(proxy) {}

BackForwardCacheControllerHostAsyncWaiter::~BackForwardCacheControllerHostAsyncWaiter() = default;







}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif