// third_party/blink/public/mojom/font_access/font_access.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/font_access/font_access.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/font_access/font_access.mojom-params-data.h"
#include "third_party/blink/public/mojom/font_access/font_access.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/font_access/font_access.mojom-import-headers.h"
#include "third_party/blink/public/mojom/font_access/font_access.mojom-test-utils.h"


namespace blink::mojom {
FontData::FontData()
    : postscript_name(),
      full_name(),
      family(),
      style() {}

FontData::FontData(
    const std::string& postscript_name_in,
    const std::string& full_name_in,
    const std::string& family_in,
    const std::string& style_in)
    : postscript_name(std::move(postscript_name_in)),
      full_name(std::move(full_name_in)),
      family(std::move(family_in)),
      style(std::move(style_in)) {}

FontData::~FontData() = default;
size_t FontData::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->postscript_name);
  seed = mojo::internal::Hash(seed, this->full_name);
  seed = mojo::internal::Hash(seed, this->family);
  seed = mojo::internal::Hash(seed, this->style);
  return seed;
}

void FontData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "postscript_name"), this->postscript_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "full_name"), this->full_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "family"), this->family,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "style"), this->style,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FontData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

FontAccessManager::IPCStableHashFunction FontAccessManager::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FontAccessManager>(message.name())) {
    case messages::FontAccessManager::kEnumerateLocalFonts: {
      return &FontAccessManager::EnumerateLocalFonts_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FontAccessManager::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FontAccessManager>(message.name())) {
      case messages::FontAccessManager::kEnumerateLocalFonts:
            return "Receive blink::mojom::FontAccessManager::EnumerateLocalFonts";
    }
  } else {
    switch (static_cast<messages::FontAccessManager>(message.name())) {
      case messages::FontAccessManager::kEnumerateLocalFonts:
            return "Receive reply blink::mojom::FontAccessManager::EnumerateLocalFonts";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FontAccessManager::EnumerateLocalFonts_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfc4beb7c;  // IPCStableHash for blink::mojom::FontAccessManager::EnumerateLocalFonts
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class FontAccessManager_EnumerateLocalFonts_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FontAccessManager_EnumerateLocalFonts_ForwardToCallback(
      FontAccessManager::EnumerateLocalFontsCallback callback
      ) : callback_(std::move(callback)) {
  }

  FontAccessManager_EnumerateLocalFonts_ForwardToCallback(const FontAccessManager_EnumerateLocalFonts_ForwardToCallback&) = delete;
  FontAccessManager_EnumerateLocalFonts_ForwardToCallback& operator=(const FontAccessManager_EnumerateLocalFonts_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FontAccessManager::EnumerateLocalFontsCallback callback_;
};

FontAccessManagerProxy::FontAccessManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FontAccessManagerProxy::EnumerateLocalFonts(
    EnumerateLocalFontsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::FontAccessManager::EnumerateLocalFonts");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FontAccessManager::kEnumerateLocalFonts), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FontAccessManager_EnumerateLocalFonts_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FontAccessManager::Name_);
  message.set_method_name("EnumerateLocalFonts");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FontAccessManager_EnumerateLocalFonts_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class FontAccessManager_EnumerateLocalFonts_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FontAccessManager::EnumerateLocalFontsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FontAccessManager_EnumerateLocalFonts_ProxyToResponder> proxy(
        new FontAccessManager_EnumerateLocalFonts_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FontAccessManager_EnumerateLocalFonts_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FontAccessManager_EnumerateLocalFonts_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FontAccessManager_EnumerateLocalFonts_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FontAccessManager::EnumerateLocalFontsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      FontEnumerationStatus in_enumeration_status, ::base::ReadOnlySharedMemoryRegion in_enumeration_table);
};

bool FontAccessManager_EnumerateLocalFonts_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FontAccessManager_EnumerateLocalFonts_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FontAccessManager_EnumerateLocalFonts_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FontAccessManager.0
  bool success = true;
  FontEnumerationStatus p_enumeration_status{};
  ::base::ReadOnlySharedMemoryRegion p_enumeration_table{};
  FontAccessManager_EnumerateLocalFonts_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadEnumerationStatus(&p_enumeration_status))
    success = false;
  if (success && !input_data_view.ReadEnumerationTable(&p_enumeration_table))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FontAccessManager::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_enumeration_status), 
std::move(p_enumeration_table));
  }
  return true;
}

void FontAccessManager_EnumerateLocalFonts_ProxyToResponder::Run(
    FontEnumerationStatus in_enumeration_status, ::base::ReadOnlySharedMemoryRegion in_enumeration_table) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FontAccessManager::EnumerateLocalFonts", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enumeration_status"), in_enumeration_status,
                        "<value of type FontEnumerationStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enumeration_table"), in_enumeration_table,
                        "<value of type ::base::ReadOnlySharedMemoryRegion>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FontAccessManager::kEnumerateLocalFonts), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FontAccessManager_EnumerateLocalFonts_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::FontEnumerationStatus>(
    in_enumeration_status,
    &params->enumeration_status);
  mojo::internal::MessageFragment<
      typename decltype(params->enumeration_table)::BaseType> enumeration_table_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
    in_enumeration_table,
    enumeration_table_fragment);

  params->enumeration_table.Set(
      enumeration_table_fragment.is_null() ? nullptr : enumeration_table_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FontAccessManager::Name_);
  message.set_method_name("EnumerateLocalFonts");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool FontAccessManagerStubDispatch::Accept(
    FontAccessManager* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FontAccessManager>(message->header()->name)) {
    case messages::FontAccessManager::kEnumerateLocalFonts: {
      break;
    }
  }
  return false;
}

// static
bool FontAccessManagerStubDispatch::AcceptWithResponder(
    FontAccessManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FontAccessManager>(message->header()->name)) {
    case messages::FontAccessManager::kEnumerateLocalFonts: {
      internal::FontAccessManager_EnumerateLocalFonts_Params_Data* params =
          reinterpret_cast<
              internal::FontAccessManager_EnumerateLocalFonts_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FontAccessManager.0
      bool success = true;
      FontAccessManager_EnumerateLocalFonts_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FontAccessManager::Name_, 0, false);
        return false;
      }
      auto callback =
          FontAccessManager_EnumerateLocalFonts_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnumerateLocalFonts(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kFontAccessManagerValidationInfo[] = {
    { &internal::FontAccessManager_EnumerateLocalFonts_Params_Data::Validate,
     &internal::FontAccessManager_EnumerateLocalFonts_ResponseParams_Data::Validate},
};

bool FontAccessManagerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::FontAccessManager::Name_,
    kFontAccessManagerValidationInfo);
}

bool FontAccessManagerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::FontAccessManager::Name_,
    kFontAccessManagerValidationInfo);
}


}  // blink::mojom


namespace mojo {


// static
bool StructTraits<::blink::mojom::FontData::DataView, ::blink::mojom::FontDataPtr>::Read(
    ::blink::mojom::FontData::DataView input,
    ::blink::mojom::FontDataPtr* output) {
  bool success = true;
  ::blink::mojom::FontDataPtr result(::blink::mojom::FontData::New());
  
      if (success && !input.ReadPostscriptName(&result->postscript_name))
        success = false;
      if (success && !input.ReadFullName(&result->full_name))
        success = false;
      if (success && !input.ReadFamily(&result->family))
        success = false;
      if (success && !input.ReadStyle(&result->style))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void FontAccessManagerInterceptorForTesting::EnumerateLocalFonts(EnumerateLocalFontsCallback callback) {
  GetForwardingInterface()->EnumerateLocalFonts(std::move(callback));
}
FontAccessManagerAsyncWaiter::FontAccessManagerAsyncWaiter(
    FontAccessManager* proxy) : proxy_(proxy) {}

FontAccessManagerAsyncWaiter::~FontAccessManagerAsyncWaiter() = default;


void FontAccessManagerAsyncWaiter::EnumerateLocalFonts(
    FontEnumerationStatus* out_enumeration_status, ::base::ReadOnlySharedMemoryRegion* out_enumeration_table) {
  base::RunLoop loop;
  proxy_->EnumerateLocalFonts(
      base::BindOnce(
          [](base::RunLoop* loop,
             FontEnumerationStatus* out_enumeration_status
,
             ::base::ReadOnlySharedMemoryRegion* out_enumeration_table
,
             FontEnumerationStatus enumeration_status,
             ::base::ReadOnlySharedMemoryRegion enumeration_table) {*out_enumeration_status = std::move(enumeration_status);*out_enumeration_table = std::move(enumeration_table);
            loop->Quit();
          },
          &loop,
          out_enumeration_status,
          out_enumeration_table));
  loop.Run();
}








}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif