// third_party/blink/public/mojom/file_system_access/file_system_access_transfer_token.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('mojoBase.mojom.UnguessableToken');






goog.provide('blink.mojom.FileSystemAccessTransferToken');
goog.provide('blink.mojom.FileSystemAccessTransferTokenReceiver');
goog.provide('blink.mojom.FileSystemAccessTransferTokenCallbackRouter');
goog.provide('blink.mojom.FileSystemAccessTransferTokenInterface');
goog.provide('blink.mojom.FileSystemAccessTransferTokenRemote');
goog.provide('blink.mojom.FileSystemAccessTransferTokenPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.FileSystemAccessTransferTokenPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.FileSystemAccessTransferToken.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.FileSystemAccessTransferTokenInterface = class {
  
  /**
   * @return {!Promise<{
        id: !mojoBase.mojom.UnguessableToken,
   *  }>}
   */

  getInternalID() {}
  
  /**
   * @param { !blink.mojom.FileSystemAccessTransferTokenPendingReceiver } tokenClone
   */

  clone(tokenClone) {}
};

/**
 * @export
 * @implements { blink.mojom.FileSystemAccessTransferTokenInterface }
 */
blink.mojom.FileSystemAccessTransferTokenRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.FileSystemAccessTransferTokenPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.FileSystemAccessTransferTokenPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.FileSystemAccessTransferTokenPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        id: !mojoBase.mojom.UnguessableToken,
   *  }>}
   */

  getInternalID() {
    return this.proxy.sendMessage(
        0,
        blink.mojom.FileSystemAccessTransferToken_GetInternalID_ParamsSpec.$,
        blink.mojom.FileSystemAccessTransferToken_GetInternalID_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.FileSystemAccessTransferTokenPendingReceiver } tokenClone
   */

  clone(
      tokenClone) {
    this.proxy.sendMessage(
        1,
        blink.mojom.FileSystemAccessTransferToken_Clone_ParamsSpec.$,
        null,
        [
          tokenClone
        ],
        false);
  }
};

/**
 * An object which receives request messages for the FileSystemAccessTransferToken
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.FileSystemAccessTransferTokenReceiver = class {
  /**
   * @param {!blink.mojom.FileSystemAccessTransferTokenInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.FileSystemAccessTransferTokenRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.FileSystemAccessTransferTokenRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.FileSystemAccessTransferTokenRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.FileSystemAccessTransferToken_GetInternalID_ParamsSpec.$,
        blink.mojom.FileSystemAccessTransferToken_GetInternalID_ResponseParamsSpec.$,
        impl.getInternalID.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.FileSystemAccessTransferToken_Clone_ParamsSpec.$,
        null,
        impl.clone.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.FileSystemAccessTransferToken = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.FileSystemAccessTransferToken";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.FileSystemAccessTransferTokenRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.FileSystemAccessTransferTokenRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the FileSystemAccessTransferToken
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.FileSystemAccessTransferTokenCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.FileSystemAccessTransferTokenRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.FileSystemAccessTransferTokenRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getInternalID =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.FileSystemAccessTransferToken_GetInternalID_ParamsSpec.$,
        blink.mojom.FileSystemAccessTransferToken_GetInternalID_ResponseParamsSpec.$,
        this.getInternalID.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.FileSystemAccessTransferToken_Clone_ParamsSpec.$,
        null,
        this.clone.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.FileSystemAccessTransferToken_GetInternalID_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessTransferToken_GetInternalID_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessTransferToken_GetInternalID_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessTransferToken_GetInternalID_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessTransferToken_Clone_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessTransferToken_Clone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.FileSystemAccessTransferToken_GetInternalID_ParamsSpec.$,
    'FileSystemAccessTransferToken_GetInternalID_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.FileSystemAccessTransferToken_GetInternalID_Params');

/** @record */
blink.mojom.FileSystemAccessTransferToken_GetInternalID_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessTransferToken_GetInternalID_ResponseParamsSpec.$,
    'FileSystemAccessTransferToken_GetInternalID_ResponseParams',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FileSystemAccessTransferToken_GetInternalID_ResponseParams');

/** @record */
blink.mojom.FileSystemAccessTransferToken_GetInternalID_ResponseParams = class {
  constructor() {
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.id;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessTransferToken_Clone_ParamsSpec.$,
    'FileSystemAccessTransferToken_Clone_Params',
    [
      mojo.internal.StructField(
        'tokenClone', 0,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.FileSystemAccessTransferTokenPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FileSystemAccessTransferToken_Clone_Params');

/** @record */
blink.mojom.FileSystemAccessTransferToken_Clone_Params = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessTransferTokenPendingReceiver } */
    this.tokenClone;
  }
};

