// third_party/blink/public/mojom/file_system_access/file_system_access_observer.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  FileSystemAccessEntry as blink_mojom_FileSystemAccessEntry,
  FileSystemAccessEntrySpec as blink_mojom_FileSystemAccessEntrySpec
} from './file_system_access_directory_handle.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class FileSystemAccessObserverPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.FileSystemAccessObserver', scope);
  }
}

/** @interface */
export class FileSystemAccessObserverInterface {
  
  /**
   * @param { !Array<!FileSystemAccessChange> } changes
   */

  onFileChanges(changes) {}
}

/**
 * @implements { FileSystemAccessObserverInterface }
 */
export class FileSystemAccessObserverRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!FileSystemAccessObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          FileSystemAccessObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!FileSystemAccessObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!FileSystemAccessChange> } changes
   */

  onFileChanges(
      changes) {
    this.proxy.sendMessage(
        0,
        FileSystemAccessObserver_OnFileChanges_ParamsSpec.$,
        null,
        [
          changes
        ],
        false);
  }
}

/**
 * An object which receives request messages for the FileSystemAccessObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class FileSystemAccessObserverReceiver {
  /**
   * @param {!FileSystemAccessObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!FileSystemAccessObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        FileSystemAccessObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FileSystemAccessObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        FileSystemAccessObserver_OnFileChanges_ParamsSpec.$,
        null,
        impl.onFileChanges.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class FileSystemAccessObserver {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.FileSystemAccessObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!FileSystemAccessObserverRemote}
   */
  static getRemote() {
    let remote = new FileSystemAccessObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the FileSystemAccessObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class FileSystemAccessObserverCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      FileSystemAccessObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FileSystemAccessObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onFileChanges =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        FileSystemAccessObserver_OnFileChanges_ParamsSpec.$,
        null,
        this.onFileChanges.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessChangeTypeAppearedSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessChangeTypeDisappearedSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessChangeTypeErroredSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessChangeTypeModifiedSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessChangeTypeMovedSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessChangeTypeUnknownSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessChangeMetadataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessChangeSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessObserver_OnFileChanges_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const FileSystemAccessChangeTypeSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    FileSystemAccessChangeTypeAppearedSpec.$,
    'FileSystemAccessChangeTypeAppeared',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class FileSystemAccessChangeTypeAppeared {
  constructor() {
  }
}



mojo.internal.Struct(
    FileSystemAccessChangeTypeDisappearedSpec.$,
    'FileSystemAccessChangeTypeDisappeared',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class FileSystemAccessChangeTypeDisappeared {
  constructor() {
  }
}



mojo.internal.Struct(
    FileSystemAccessChangeTypeErroredSpec.$,
    'FileSystemAccessChangeTypeErrored',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class FileSystemAccessChangeTypeErrored {
  constructor() {
  }
}



mojo.internal.Struct(
    FileSystemAccessChangeTypeModifiedSpec.$,
    'FileSystemAccessChangeTypeModified',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class FileSystemAccessChangeTypeModified {
  constructor() {
  }
}



mojo.internal.Struct(
    FileSystemAccessChangeTypeMovedSpec.$,
    'FileSystemAccessChangeTypeMoved',
    [
      mojo.internal.StructField(
        'formerRelativePath', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemAccessChangeTypeMoved {
  constructor() {
    /** @type { (Array<!string>|undefined) } */
    this.formerRelativePath;
  }
}



mojo.internal.Struct(
    FileSystemAccessChangeTypeUnknownSpec.$,
    'FileSystemAccessChangeTypeUnknown',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class FileSystemAccessChangeTypeUnknown {
  constructor() {
  }
}



mojo.internal.Struct(
    FileSystemAccessChangeMetadataSpec.$,
    'FileSystemAccessChangeMetadata',
    [
      mojo.internal.StructField(
        'root', 0,
        0,
        blink_mojom_FileSystemAccessEntrySpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'changedEntry', 8,
        0,
        blink_mojom_FileSystemAccessEntrySpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'relativePath', 16,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class FileSystemAccessChangeMetadata {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessEntry } */
    this.root;
    /** @type { !blink_mojom_FileSystemAccessEntry } */
    this.changedEntry;
    /** @type { !Array<!string> } */
    this.relativePath;
  }
}



mojo.internal.Struct(
    FileSystemAccessChangeSpec.$,
    'FileSystemAccessChange',
    [
      mojo.internal.StructField(
        'metadata', 0,
        0,
        FileSystemAccessChangeMetadataSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'type', 8,
        0,
        FileSystemAccessChangeTypeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class FileSystemAccessChange {
  constructor() {
    /** @type { !FileSystemAccessChangeMetadata } */
    this.metadata;
    /** @type { !FileSystemAccessChangeType } */
    this.type;
  }
}



mojo.internal.Struct(
    FileSystemAccessObserver_OnFileChanges_ParamsSpec.$,
    'FileSystemAccessObserver_OnFileChanges_Params',
    [
      mojo.internal.StructField(
        'changes', 0,
        0,
        mojo.internal.Array(FileSystemAccessChangeSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemAccessObserver_OnFileChanges_Params {
  constructor() {
    /** @type { !Array<!FileSystemAccessChange> } */
    this.changes;
  }
}

mojo.internal.Union(
    FileSystemAccessChangeTypeSpec.$, 'FileSystemAccessChangeType',
    {
      'appeared': {
        'ordinal': 0,
        'type': FileSystemAccessChangeTypeAppearedSpec.$,
      },
      'disappeared': {
        'ordinal': 1,
        'type': FileSystemAccessChangeTypeDisappearedSpec.$,
      },
      'errored': {
        'ordinal': 2,
        'type': FileSystemAccessChangeTypeErroredSpec.$,
      },
      'modified': {
        'ordinal': 3,
        'type': FileSystemAccessChangeTypeModifiedSpec.$,
      },
      'moved': {
        'ordinal': 4,
        'type': FileSystemAccessChangeTypeMovedSpec.$,
      },
      'unknown': {
        'ordinal': 5,
        'type': FileSystemAccessChangeTypeUnknownSpec.$,
      },
    });

/**
 * @typedef { {
 *   appeared: (!FileSystemAccessChangeTypeAppeared|undefined),
 *   disappeared: (!FileSystemAccessChangeTypeDisappeared|undefined),
 *   errored: (!FileSystemAccessChangeTypeErrored|undefined),
 *   modified: (!FileSystemAccessChangeTypeModified|undefined),
 *   moved: (!FileSystemAccessChangeTypeMoved|undefined),
 *   unknown: (!FileSystemAccessChangeTypeUnknown|undefined),
 * } }
 */
export const FileSystemAccessChangeType = {};
