// third_party/blink/public/mojom/file_system_access/file_system_access_manager.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  String16 as mojoBase_mojom_String16,
  String16Spec as mojoBase_mojom_String16Spec
} from '../../../../../mojo/public/mojom/base/string16.mojom.m.js';

import {
  FileSystemAccessDataTransferTokenRemote as blink_mojom_FileSystemAccessDataTransferTokenRemote,
  FileSystemAccessDataTransferTokenPendingReceiver as blink_mojom_FileSystemAccessDataTransferTokenPendingReceiver
} from './file_system_access_data_transfer_token.mojom.m.js';

import {
  FileSystemAccessDirectoryHandleRemote as blink_mojom_FileSystemAccessDirectoryHandleRemote,
  FileSystemAccessDirectoryHandlePendingReceiver as blink_mojom_FileSystemAccessDirectoryHandlePendingReceiver,
  FileSystemAccessEntry as blink_mojom_FileSystemAccessEntry,
  FileSystemAccessEntrySpec as blink_mojom_FileSystemAccessEntrySpec
} from './file_system_access_directory_handle.mojom.m.js';

import {
  FileSystemAccessError as blink_mojom_FileSystemAccessError,
  FileSystemAccessErrorSpec as blink_mojom_FileSystemAccessErrorSpec
} from './file_system_access_error.mojom.m.js';

import {
  FileSystemAccessFileHandleRemote as blink_mojom_FileSystemAccessFileHandleRemote,
  FileSystemAccessFileHandlePendingReceiver as blink_mojom_FileSystemAccessFileHandlePendingReceiver
} from './file_system_access_file_handle.mojom.m.js';

import {
  FileSystemAccessObserverHostRemote as blink_mojom_FileSystemAccessObserverHostRemote,
  FileSystemAccessObserverHostPendingReceiver as blink_mojom_FileSystemAccessObserverHostPendingReceiver
} from './file_system_access_observer_host.mojom.m.js';

import {
  FileSystemAccessPermissionMode as blink_mojom_FileSystemAccessPermissionMode,
  FileSystemAccessPermissionModeSpec as blink_mojom_FileSystemAccessPermissionModeSpec
} from './file_system_access_permission_mode.mojom.m.js';

import {
  FileSystemAccessTransferTokenRemote as blink_mojom_FileSystemAccessTransferTokenRemote,
  FileSystemAccessTransferTokenPendingReceiver as blink_mojom_FileSystemAccessTransferTokenPendingReceiver
} from './file_system_access_transfer_token.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const WellKnownDirectorySpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const WellKnownDirectory = {
  
  kDirDesktop: 0,
  kDirDocuments: 1,
  kDirDownloads: 2,
  kDirMusic: 3,
  kDirPictures: 4,
  kDirVideos: 5,
  MIN_VALUE: 0,
  MAX_VALUE: 5,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class FileSystemAccessManagerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.FileSystemAccessManager', scope);
  }
}

/** @interface */
export class FileSystemAccessManagerInterface {
  
  /**
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
        directory: ?blink_mojom_FileSystemAccessDirectoryHandleRemote,
   *  }>}
   */

  getSandboxedFileSystem() {}
  
  /**
   * @param { !Array<!string> } directoryPathComponents
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
        directory: ?blink_mojom_FileSystemAccessDirectoryHandleRemote,
   *  }>}
   */

  getSandboxedFileSystemForDevtools(directoryPathComponents) {}
  
  /**
   * @param { !FilePickerOptions } options
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
        entries: !Array<!blink_mojom_FileSystemAccessEntry>,
   *  }>}
   */

  chooseEntries(options) {}
  
  /**
   * @param { !blink_mojom_FileSystemAccessTransferTokenRemote } token
   * @param { !blink_mojom_FileSystemAccessFileHandlePendingReceiver } fileHandle
   */

  getFileHandleFromToken(token, fileHandle) {}
  
  /**
   * @param { !blink_mojom_FileSystemAccessTransferTokenRemote } token
   * @param { !blink_mojom_FileSystemAccessDirectoryHandlePendingReceiver } directoryHandle
   */

  getDirectoryHandleFromToken(token, directoryHandle) {}
  
  /**
   * @param { !blink_mojom_FileSystemAccessDataTransferTokenRemote } token
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
        entry: ?blink_mojom_FileSystemAccessEntry,
   *  }>}
   */

  getEntryFromDataTransferToken(token) {}
  
  /**
   * @param { !blink_mojom_FileSystemAccessObserverHostPendingReceiver } observerHost
   */

  bindObserverHost(observerHost) {}
}

/**
 * @implements { FileSystemAccessManagerInterface }
 */
export class FileSystemAccessManagerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!FileSystemAccessManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          FileSystemAccessManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!FileSystemAccessManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
        directory: ?blink_mojom_FileSystemAccessDirectoryHandleRemote,
   *  }>}
   */

  getSandboxedFileSystem() {
    return this.proxy.sendMessage(
        0,
        FileSystemAccessManager_GetSandboxedFileSystem_ParamsSpec.$,
        FileSystemAccessManager_GetSandboxedFileSystem_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !Array<!string> } directoryPathComponents
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
        directory: ?blink_mojom_FileSystemAccessDirectoryHandleRemote,
   *  }>}
   */

  getSandboxedFileSystemForDevtools(
      directoryPathComponents) {
    return this.proxy.sendMessage(
        1,
        FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ParamsSpec.$,
        FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ResponseParamsSpec.$,
        [
          directoryPathComponents
        ],
        false);
  }

  
  /**
   * @param { !FilePickerOptions } options
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
        entries: !Array<!blink_mojom_FileSystemAccessEntry>,
   *  }>}
   */

  chooseEntries(
      options) {
    return this.proxy.sendMessage(
        2,
        FileSystemAccessManager_ChooseEntries_ParamsSpec.$,
        FileSystemAccessManager_ChooseEntries_ResponseParamsSpec.$,
        [
          options
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_FileSystemAccessTransferTokenRemote } token
   * @param { !blink_mojom_FileSystemAccessFileHandlePendingReceiver } fileHandle
   */

  getFileHandleFromToken(
      token,
      fileHandle) {
    this.proxy.sendMessage(
        3,
        FileSystemAccessManager_GetFileHandleFromToken_ParamsSpec.$,
        null,
        [
          token,
          fileHandle
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_FileSystemAccessTransferTokenRemote } token
   * @param { !blink_mojom_FileSystemAccessDirectoryHandlePendingReceiver } directoryHandle
   */

  getDirectoryHandleFromToken(
      token,
      directoryHandle) {
    this.proxy.sendMessage(
        4,
        FileSystemAccessManager_GetDirectoryHandleFromToken_ParamsSpec.$,
        null,
        [
          token,
          directoryHandle
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_FileSystemAccessDataTransferTokenRemote } token
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
        entry: ?blink_mojom_FileSystemAccessEntry,
   *  }>}
   */

  getEntryFromDataTransferToken(
      token) {
    return this.proxy.sendMessage(
        5,
        FileSystemAccessManager_GetEntryFromDataTransferToken_ParamsSpec.$,
        FileSystemAccessManager_GetEntryFromDataTransferToken_ResponseParamsSpec.$,
        [
          token
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_FileSystemAccessObserverHostPendingReceiver } observerHost
   */

  bindObserverHost(
      observerHost) {
    this.proxy.sendMessage(
        6,
        FileSystemAccessManager_BindObserverHost_ParamsSpec.$,
        null,
        [
          observerHost
        ],
        false);
  }
}

/**
 * An object which receives request messages for the FileSystemAccessManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class FileSystemAccessManagerReceiver {
  /**
   * @param {!FileSystemAccessManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!FileSystemAccessManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        FileSystemAccessManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FileSystemAccessManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        FileSystemAccessManager_GetSandboxedFileSystem_ParamsSpec.$,
        FileSystemAccessManager_GetSandboxedFileSystem_ResponseParamsSpec.$,
        impl.getSandboxedFileSystem.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ParamsSpec.$,
        FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ResponseParamsSpec.$,
        impl.getSandboxedFileSystemForDevtools.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        FileSystemAccessManager_ChooseEntries_ParamsSpec.$,
        FileSystemAccessManager_ChooseEntries_ResponseParamsSpec.$,
        impl.chooseEntries.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        FileSystemAccessManager_GetFileHandleFromToken_ParamsSpec.$,
        null,
        impl.getFileHandleFromToken.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        FileSystemAccessManager_GetDirectoryHandleFromToken_ParamsSpec.$,
        null,
        impl.getDirectoryHandleFromToken.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        FileSystemAccessManager_GetEntryFromDataTransferToken_ParamsSpec.$,
        FileSystemAccessManager_GetEntryFromDataTransferToken_ResponseParamsSpec.$,
        impl.getEntryFromDataTransferToken.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        FileSystemAccessManager_BindObserverHost_ParamsSpec.$,
        null,
        impl.bindObserverHost.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class FileSystemAccessManager {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.FileSystemAccessManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!FileSystemAccessManagerRemote}
   */
  static getRemote() {
    let remote = new FileSystemAccessManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the FileSystemAccessManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class FileSystemAccessManagerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      FileSystemAccessManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FileSystemAccessManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getSandboxedFileSystem =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        FileSystemAccessManager_GetSandboxedFileSystem_ParamsSpec.$,
        FileSystemAccessManager_GetSandboxedFileSystem_ResponseParamsSpec.$,
        this.getSandboxedFileSystem.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getSandboxedFileSystemForDevtools =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ParamsSpec.$,
        FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ResponseParamsSpec.$,
        this.getSandboxedFileSystemForDevtools.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.chooseEntries =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        FileSystemAccessManager_ChooseEntries_ParamsSpec.$,
        FileSystemAccessManager_ChooseEntries_ResponseParamsSpec.$,
        this.chooseEntries.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getFileHandleFromToken =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        FileSystemAccessManager_GetFileHandleFromToken_ParamsSpec.$,
        null,
        this.getFileHandleFromToken.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDirectoryHandleFromToken =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        FileSystemAccessManager_GetDirectoryHandleFromToken_ParamsSpec.$,
        null,
        this.getDirectoryHandleFromToken.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getEntryFromDataTransferToken =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        FileSystemAccessManager_GetEntryFromDataTransferToken_ParamsSpec.$,
        FileSystemAccessManager_GetEntryFromDataTransferToken_ResponseParamsSpec.$,
        this.getEntryFromDataTransferToken.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindObserverHost =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        FileSystemAccessManager_BindObserverHost_ParamsSpec.$,
        null,
        this.bindObserverHost.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ChooseFileSystemEntryAcceptsOptionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AcceptsTypesInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const OpenFilePickerOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SaveFilePickerOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DirectoryPickerOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FilePickerOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessManager_GetSandboxedFileSystem_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessManager_GetSandboxedFileSystem_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessManager_ChooseEntries_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessManager_ChooseEntries_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessManager_GetFileHandleFromToken_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessManager_GetDirectoryHandleFromToken_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessManager_GetEntryFromDataTransferToken_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessManager_GetEntryFromDataTransferToken_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessManager_BindObserverHost_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const TypeSpecificFilePickerOptionsUnionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const FilePickerStartInOptionsUnionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ChooseFileSystemEntryAcceptsOptionSpec.$,
    'ChooseFileSystemEntryAcceptsOption',
    [
      mojo.internal.StructField(
        'description', 0,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mimeTypes', 8,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'extensions', 16,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class ChooseFileSystemEntryAcceptsOption {
  constructor() {
    /** @type { !mojoBase_mojom_String16 } */
    this.description;
    /** @type { !Array<!string> } */
    this.mimeTypes;
    /** @type { !Array<!string> } */
    this.extensions;
  }
}



mojo.internal.Struct(
    AcceptsTypesInfoSpec.$,
    'AcceptsTypesInfo',
    [
      mojo.internal.StructField(
        'accepts', 0,
        0,
        mojo.internal.Array(ChooseFileSystemEntryAcceptsOptionSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'includeAcceptsAll', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AcceptsTypesInfo {
  constructor() {
    /** @type { !Array<!ChooseFileSystemEntryAcceptsOption> } */
    this.accepts;
    /** @type { !boolean } */
    this.includeAcceptsAll;
  }
}



mojo.internal.Struct(
    OpenFilePickerOptionsSpec.$,
    'OpenFilePickerOptions',
    [
      mojo.internal.StructField(
        'acceptsTypesInfo', 0,
        0,
        AcceptsTypesInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'canSelectMultipleFiles', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class OpenFilePickerOptions {
  constructor() {
    /** @type { !AcceptsTypesInfo } */
    this.acceptsTypesInfo;
    /** @type { !boolean } */
    this.canSelectMultipleFiles;
  }
}



mojo.internal.Struct(
    SaveFilePickerOptionsSpec.$,
    'SaveFilePickerOptions',
    [
      mojo.internal.StructField(
        'acceptsTypesInfo', 0,
        0,
        AcceptsTypesInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'suggestedName', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SaveFilePickerOptions {
  constructor() {
    /** @type { !AcceptsTypesInfo } */
    this.acceptsTypesInfo;
    /** @type { !string } */
    this.suggestedName;
  }
}



mojo.internal.Struct(
    DirectoryPickerOptionsSpec.$,
    'DirectoryPickerOptions',
    [
      mojo.internal.StructField(
        'permissionMode', 0,
        0,
        blink_mojom_FileSystemAccessPermissionModeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class DirectoryPickerOptions {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessPermissionMode } */
    this.permissionMode;
  }
}



mojo.internal.Struct(
    FilePickerOptionsSpec.$,
    'FilePickerOptions',
    [
      mojo.internal.StructField(
        'typeSpecificOptions', 0,
        0,
        TypeSpecificFilePickerOptionsUnionSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'startingDirectoryId', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'startInOptions', 24,
        0,
        FilePickerStartInOptionsUnionSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class FilePickerOptions {
  constructor() {
    /** @type { !TypeSpecificFilePickerOptionsUnion } */
    this.typeSpecificOptions;
    /** @type { !string } */
    this.startingDirectoryId;
    /** @type { (FilePickerStartInOptionsUnion|undefined) } */
    this.startInOptions;
  }
}



mojo.internal.Struct(
    FileSystemAccessManager_GetSandboxedFileSystem_ParamsSpec.$,
    'FileSystemAccessManager_GetSandboxedFileSystem_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class FileSystemAccessManager_GetSandboxedFileSystem_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    FileSystemAccessManager_GetSandboxedFileSystem_ResponseParamsSpec.$,
    'FileSystemAccessManager_GetSandboxedFileSystem_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink_mojom_FileSystemAccessErrorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'directory', 8,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_FileSystemAccessDirectoryHandleRemote),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FileSystemAccessManager_GetSandboxedFileSystem_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessError } */
    this.result;
    /** @type { (blink_mojom_FileSystemAccessDirectoryHandleRemote|undefined) } */
    this.directory;
  }
}



mojo.internal.Struct(
    FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ParamsSpec.$,
    'FileSystemAccessManager_GetSandboxedFileSystemForDevtools_Params',
    [
      mojo.internal.StructField(
        'directoryPathComponents', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemAccessManager_GetSandboxedFileSystemForDevtools_Params {
  constructor() {
    /** @type { !Array<!string> } */
    this.directoryPathComponents;
  }
}



mojo.internal.Struct(
    FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ResponseParamsSpec.$,
    'FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink_mojom_FileSystemAccessErrorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'directory', 8,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_FileSystemAccessDirectoryHandleRemote),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessError } */
    this.result;
    /** @type { (blink_mojom_FileSystemAccessDirectoryHandleRemote|undefined) } */
    this.directory;
  }
}



mojo.internal.Struct(
    FileSystemAccessManager_ChooseEntries_ParamsSpec.$,
    'FileSystemAccessManager_ChooseEntries_Params',
    [
      mojo.internal.StructField(
        'options', 0,
        0,
        FilePickerOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemAccessManager_ChooseEntries_Params {
  constructor() {
    /** @type { !FilePickerOptions } */
    this.options;
  }
}



mojo.internal.Struct(
    FileSystemAccessManager_ChooseEntries_ResponseParamsSpec.$,
    'FileSystemAccessManager_ChooseEntries_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink_mojom_FileSystemAccessErrorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'entries', 8,
        0,
        mojo.internal.Array(blink_mojom_FileSystemAccessEntrySpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FileSystemAccessManager_ChooseEntries_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessError } */
    this.result;
    /** @type { !Array<!blink_mojom_FileSystemAccessEntry> } */
    this.entries;
  }
}



mojo.internal.Struct(
    FileSystemAccessManager_GetFileHandleFromToken_ParamsSpec.$,
    'FileSystemAccessManager_GetFileHandleFromToken_Params',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_FileSystemAccessTransferTokenRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fileHandle', 8,
        0,
        mojo.internal.InterfaceRequest(blink_mojom_FileSystemAccessFileHandlePendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FileSystemAccessManager_GetFileHandleFromToken_Params {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessTransferTokenRemote } */
    this.token;
    /** @type { !blink_mojom_FileSystemAccessFileHandlePendingReceiver } */
    this.fileHandle;
  }
}



mojo.internal.Struct(
    FileSystemAccessManager_GetDirectoryHandleFromToken_ParamsSpec.$,
    'FileSystemAccessManager_GetDirectoryHandleFromToken_Params',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_FileSystemAccessTransferTokenRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'directoryHandle', 8,
        0,
        mojo.internal.InterfaceRequest(blink_mojom_FileSystemAccessDirectoryHandlePendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FileSystemAccessManager_GetDirectoryHandleFromToken_Params {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessTransferTokenRemote } */
    this.token;
    /** @type { !blink_mojom_FileSystemAccessDirectoryHandlePendingReceiver } */
    this.directoryHandle;
  }
}



mojo.internal.Struct(
    FileSystemAccessManager_GetEntryFromDataTransferToken_ParamsSpec.$,
    'FileSystemAccessManager_GetEntryFromDataTransferToken_Params',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_FileSystemAccessDataTransferTokenRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemAccessManager_GetEntryFromDataTransferToken_Params {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessDataTransferTokenRemote } */
    this.token;
  }
}



mojo.internal.Struct(
    FileSystemAccessManager_GetEntryFromDataTransferToken_ResponseParamsSpec.$,
    'FileSystemAccessManager_GetEntryFromDataTransferToken_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink_mojom_FileSystemAccessErrorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'entry', 8,
        0,
        blink_mojom_FileSystemAccessEntrySpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FileSystemAccessManager_GetEntryFromDataTransferToken_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessError } */
    this.result;
    /** @type { (blink_mojom_FileSystemAccessEntry|undefined) } */
    this.entry;
  }
}



mojo.internal.Struct(
    FileSystemAccessManager_BindObserverHost_ParamsSpec.$,
    'FileSystemAccessManager_BindObserverHost_Params',
    [
      mojo.internal.StructField(
        'observerHost', 0,
        0,
        mojo.internal.InterfaceRequest(blink_mojom_FileSystemAccessObserverHostPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemAccessManager_BindObserverHost_Params {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessObserverHostPendingReceiver } */
    this.observerHost;
  }
}

mojo.internal.Union(
    TypeSpecificFilePickerOptionsUnionSpec.$, 'TypeSpecificFilePickerOptionsUnion',
    {
      'openFilePickerOptions': {
        'ordinal': 0,
        'type': OpenFilePickerOptionsSpec.$,
      },
      'saveFilePickerOptions': {
        'ordinal': 1,
        'type': SaveFilePickerOptionsSpec.$,
      },
      'directoryPickerOptions': {
        'ordinal': 2,
        'type': DirectoryPickerOptionsSpec.$,
      },
    });

/**
 * @typedef { {
 *   openFilePickerOptions: (!OpenFilePickerOptions|undefined),
 *   saveFilePickerOptions: (!SaveFilePickerOptions|undefined),
 *   directoryPickerOptions: (!DirectoryPickerOptions|undefined),
 * } }
 */
export const TypeSpecificFilePickerOptionsUnion = {};
mojo.internal.Union(
    FilePickerStartInOptionsUnionSpec.$, 'FilePickerStartInOptionsUnion',
    {
      'wellKnownDirectory': {
        'ordinal': 0,
        'type': WellKnownDirectorySpec.$,
      },
      'directoryToken': {
        'ordinal': 1,
        'type': mojo.internal.InterfaceProxy(blink_mojom_FileSystemAccessTransferTokenRemote),
      },
    });

/**
 * @typedef { {
 *   wellKnownDirectory: (!WellKnownDirectory|undefined),
 *   directoryToken: (!blink_mojom_FileSystemAccessTransferTokenRemote|undefined),
 * } }
 */
export const FilePickerStartInOptionsUnion = {};
