// third_party/blink/public/mojom/file_system_access/file_system_access_manager.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/file_system_access/file_system_access_manager.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var string16$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/string16.mojom', '../../../../../mojo/public/mojom/base/string16.mojom.js');
  }
  var file_system_access_data_transfer_token$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/file_system_access/file_system_access_data_transfer_token.mojom', 'file_system_access_data_transfer_token.mojom.js');
  }
  var file_system_access_directory_handle$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/file_system_access/file_system_access_directory_handle.mojom', 'file_system_access_directory_handle.mojom.js');
  }
  var file_system_access_error$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/file_system_access/file_system_access_error.mojom', 'file_system_access_error.mojom.js');
  }
  var file_system_access_file_handle$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/file_system_access/file_system_access_file_handle.mojom', 'file_system_access_file_handle.mojom.js');
  }
  var file_system_access_observer_host$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/file_system_access/file_system_access_observer_host.mojom', 'file_system_access_observer_host.mojom.js');
  }
  var file_system_access_permission_mode$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/file_system_access/file_system_access_permission_mode.mojom', 'file_system_access_permission_mode.mojom.js');
  }
  var file_system_access_transfer_token$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/file_system_access/file_system_access_transfer_token.mojom', 'file_system_access_transfer_token.mojom.js');
  }


  var WellKnownDirectory = {};
  WellKnownDirectory.kDirDesktop = 0;
  WellKnownDirectory.kDirDocuments = 1;
  WellKnownDirectory.kDirDownloads = 2;
  WellKnownDirectory.kDirMusic = 3;
  WellKnownDirectory.kDirPictures = 4;
  WellKnownDirectory.kDirVideos = 5;
  WellKnownDirectory.MIN_VALUE = 0;
  WellKnownDirectory.MAX_VALUE = 5;

  WellKnownDirectory.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
      return true;
    }
    return false;
  };

  WellKnownDirectory.toKnownEnumValue = function(value) {
    return value;
  };

  WellKnownDirectory.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function ChooseFileSystemEntryAcceptsOption(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ChooseFileSystemEntryAcceptsOption.prototype.initDefaults_ = function() {
    this.description = null;
    this.mimeTypes = null;
    this.extensions = null;
  };
  ChooseFileSystemEntryAcceptsOption.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ChooseFileSystemEntryAcceptsOption.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ChooseFileSystemEntryAcceptsOption.description
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ChooseFileSystemEntryAcceptsOption.mimeTypes
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ChooseFileSystemEntryAcceptsOption.extensions
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ChooseFileSystemEntryAcceptsOption.encodedSize = codec.kStructHeaderSize + 24;

  ChooseFileSystemEntryAcceptsOption.decode = function(decoder) {
    var packed;
    var val = new ChooseFileSystemEntryAcceptsOption();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.description =
        decoder.decodeStructPointer(string16$.String16);
    val.mimeTypes =
        decoder.decodeArrayPointer(codec.String);
    val.extensions =
        decoder.decodeArrayPointer(codec.String);
    return val;
  };

  ChooseFileSystemEntryAcceptsOption.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ChooseFileSystemEntryAcceptsOption.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(string16$.String16, val.description);
    encoder.encodeArrayPointer(codec.String, val.mimeTypes);
    encoder.encodeArrayPointer(codec.String, val.extensions);
  };
  function AcceptsTypesInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AcceptsTypesInfo.prototype.initDefaults_ = function() {
    this.accepts = null;
    this.includeAcceptsAll = false;
  };
  AcceptsTypesInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AcceptsTypesInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AcceptsTypesInfo.accepts
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(ChooseFileSystemEntryAcceptsOption), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  AcceptsTypesInfo.encodedSize = codec.kStructHeaderSize + 16;

  AcceptsTypesInfo.decode = function(decoder) {
    var packed;
    var val = new AcceptsTypesInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.accepts =
        decoder.decodeArrayPointer(new codec.PointerTo(ChooseFileSystemEntryAcceptsOption));
    packed = decoder.readUint8();
    val.includeAcceptsAll = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  AcceptsTypesInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AcceptsTypesInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(ChooseFileSystemEntryAcceptsOption), val.accepts);
    packed = 0;
    packed |= (val.includeAcceptsAll & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function OpenFilePickerOptions(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  OpenFilePickerOptions.prototype.initDefaults_ = function() {
    this.acceptsTypesInfo = null;
    this.canSelectMultipleFiles = false;
  };
  OpenFilePickerOptions.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  OpenFilePickerOptions.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OpenFilePickerOptions.acceptsTypesInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, AcceptsTypesInfo, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  OpenFilePickerOptions.encodedSize = codec.kStructHeaderSize + 16;

  OpenFilePickerOptions.decode = function(decoder) {
    var packed;
    var val = new OpenFilePickerOptions();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.acceptsTypesInfo =
        decoder.decodeStructPointer(AcceptsTypesInfo);
    packed = decoder.readUint8();
    val.canSelectMultipleFiles = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  OpenFilePickerOptions.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(OpenFilePickerOptions.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(AcceptsTypesInfo, val.acceptsTypesInfo);
    packed = 0;
    packed |= (val.canSelectMultipleFiles & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SaveFilePickerOptions(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SaveFilePickerOptions.prototype.initDefaults_ = function() {
    this.acceptsTypesInfo = null;
    this.suggestedName = null;
  };
  SaveFilePickerOptions.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SaveFilePickerOptions.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SaveFilePickerOptions.acceptsTypesInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, AcceptsTypesInfo, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SaveFilePickerOptions.suggestedName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SaveFilePickerOptions.encodedSize = codec.kStructHeaderSize + 16;

  SaveFilePickerOptions.decode = function(decoder) {
    var packed;
    var val = new SaveFilePickerOptions();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.acceptsTypesInfo =
        decoder.decodeStructPointer(AcceptsTypesInfo);
    val.suggestedName =
        decoder.decodeStruct(codec.String);
    return val;
  };

  SaveFilePickerOptions.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SaveFilePickerOptions.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(AcceptsTypesInfo, val.acceptsTypesInfo);
    encoder.encodeStruct(codec.String, val.suggestedName);
  };
  function DirectoryPickerOptions(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DirectoryPickerOptions.prototype.initDefaults_ = function() {
    this.permissionMode = 0;
  };
  DirectoryPickerOptions.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DirectoryPickerOptions.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DirectoryPickerOptions.permissionMode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, file_system_access_permission_mode$.FileSystemAccessPermissionMode);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DirectoryPickerOptions.encodedSize = codec.kStructHeaderSize + 8;

  DirectoryPickerOptions.decode = function(decoder) {
    var packed;
    var val = new DirectoryPickerOptions();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.permissionMode =
        decoder.decodeStruct(new codec.Enum(file_system_access_permission_mode$.FileSystemAccessPermissionMode));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  DirectoryPickerOptions.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DirectoryPickerOptions.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.permissionMode);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FilePickerOptions(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FilePickerOptions.prototype.initDefaults_ = function() {
    this.typeSpecificOptions = null;
    this.startingDirectoryId = null;
    this.startInOptions = null;
  };
  FilePickerOptions.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FilePickerOptions.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FilePickerOptions.typeSpecificOptions
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, TypeSpecificFilePickerOptionsUnion, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FilePickerOptions.startingDirectoryId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate FilePickerOptions.startInOptions
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 24, FilePickerStartInOptionsUnion, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FilePickerOptions.encodedSize = codec.kStructHeaderSize + 40;

  FilePickerOptions.decode = function(decoder) {
    var packed;
    var val = new FilePickerOptions();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.typeSpecificOptions =
        decoder.decodeStruct(TypeSpecificFilePickerOptionsUnion);
    val.startingDirectoryId =
        decoder.decodeStruct(codec.String);
    val.startInOptions =
        decoder.decodeStruct(FilePickerStartInOptionsUnion);
    return val;
  };

  FilePickerOptions.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FilePickerOptions.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(TypeSpecificFilePickerOptionsUnion, val.typeSpecificOptions);
    encoder.encodeStruct(codec.String, val.startingDirectoryId);
    encoder.encodeStruct(FilePickerStartInOptionsUnion, val.startInOptions);
  };
  function FileSystemAccessManager_GetSandboxedFileSystem_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessManager_GetSandboxedFileSystem_Params.prototype.initDefaults_ = function() {
  };
  FileSystemAccessManager_GetSandboxedFileSystem_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessManager_GetSandboxedFileSystem_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessManager_GetSandboxedFileSystem_Params.encodedSize = codec.kStructHeaderSize + 0;

  FileSystemAccessManager_GetSandboxedFileSystem_Params.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessManager_GetSandboxedFileSystem_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FileSystemAccessManager_GetSandboxedFileSystem_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessManager_GetSandboxedFileSystem_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function FileSystemAccessManager_GetSandboxedFileSystem_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessManager_GetSandboxedFileSystem_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
    this.directory = new file_system_access_directory_handle$.FileSystemAccessDirectoryHandlePtr();
  };
  FileSystemAccessManager_GetSandboxedFileSystem_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessManager_GetSandboxedFileSystem_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessManager_GetSandboxedFileSystem_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_system_access_error$.FileSystemAccessError, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessManager_GetSandboxedFileSystem_ResponseParams.directory
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 8, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessManager_GetSandboxedFileSystem_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  FileSystemAccessManager_GetSandboxedFileSystem_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessManager_GetSandboxedFileSystem_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(file_system_access_error$.FileSystemAccessError);
    val.directory =
        decoder.decodeStruct(new codec.NullableInterface(file_system_access_directory_handle$.FileSystemAccessDirectoryHandlePtr));
    return val;
  };

  FileSystemAccessManager_GetSandboxedFileSystem_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessManager_GetSandboxedFileSystem_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_system_access_error$.FileSystemAccessError, val.result);
    encoder.encodeStruct(new codec.NullableInterface(file_system_access_directory_handle$.FileSystemAccessDirectoryHandlePtr), val.directory);
  };
  function FileSystemAccessManager_GetSandboxedFileSystemForDevtools_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessManager_GetSandboxedFileSystemForDevtools_Params.prototype.initDefaults_ = function() {
    this.directoryPathComponents = null;
  };
  FileSystemAccessManager_GetSandboxedFileSystemForDevtools_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessManager_GetSandboxedFileSystemForDevtools_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessManager_GetSandboxedFileSystemForDevtools_Params.directoryPathComponents
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessManager_GetSandboxedFileSystemForDevtools_Params.encodedSize = codec.kStructHeaderSize + 8;

  FileSystemAccessManager_GetSandboxedFileSystemForDevtools_Params.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessManager_GetSandboxedFileSystemForDevtools_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.directoryPathComponents =
        decoder.decodeArrayPointer(codec.String);
    return val;
  };

  FileSystemAccessManager_GetSandboxedFileSystemForDevtools_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessManager_GetSandboxedFileSystemForDevtools_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.String, val.directoryPathComponents);
  };
  function FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
    this.directory = new file_system_access_directory_handle$.FileSystemAccessDirectoryHandlePtr();
  };
  FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_system_access_error$.FileSystemAccessError, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ResponseParams.directory
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 8, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(file_system_access_error$.FileSystemAccessError);
    val.directory =
        decoder.decodeStruct(new codec.NullableInterface(file_system_access_directory_handle$.FileSystemAccessDirectoryHandlePtr));
    return val;
  };

  FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_system_access_error$.FileSystemAccessError, val.result);
    encoder.encodeStruct(new codec.NullableInterface(file_system_access_directory_handle$.FileSystemAccessDirectoryHandlePtr), val.directory);
  };
  function FileSystemAccessManager_ChooseEntries_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessManager_ChooseEntries_Params.prototype.initDefaults_ = function() {
    this.options = null;
  };
  FileSystemAccessManager_ChooseEntries_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessManager_ChooseEntries_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessManager_ChooseEntries_Params.options
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, FilePickerOptions, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessManager_ChooseEntries_Params.encodedSize = codec.kStructHeaderSize + 8;

  FileSystemAccessManager_ChooseEntries_Params.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessManager_ChooseEntries_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.options =
        decoder.decodeStructPointer(FilePickerOptions);
    return val;
  };

  FileSystemAccessManager_ChooseEntries_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessManager_ChooseEntries_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(FilePickerOptions, val.options);
  };
  function FileSystemAccessManager_ChooseEntries_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessManager_ChooseEntries_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
    this.entries = null;
  };
  FileSystemAccessManager_ChooseEntries_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessManager_ChooseEntries_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessManager_ChooseEntries_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_system_access_error$.FileSystemAccessError, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessManager_ChooseEntries_ResponseParams.entries
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(file_system_access_directory_handle$.FileSystemAccessEntry), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessManager_ChooseEntries_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  FileSystemAccessManager_ChooseEntries_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessManager_ChooseEntries_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(file_system_access_error$.FileSystemAccessError);
    val.entries =
        decoder.decodeArrayPointer(new codec.PointerTo(file_system_access_directory_handle$.FileSystemAccessEntry));
    return val;
  };

  FileSystemAccessManager_ChooseEntries_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessManager_ChooseEntries_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_system_access_error$.FileSystemAccessError, val.result);
    encoder.encodeArrayPointer(new codec.PointerTo(file_system_access_directory_handle$.FileSystemAccessEntry), val.entries);
  };
  function FileSystemAccessManager_GetFileHandleFromToken_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessManager_GetFileHandleFromToken_Params.prototype.initDefaults_ = function() {
    this.token = new file_system_access_transfer_token$.FileSystemAccessTransferTokenPtr();
    this.fileHandle = new bindings.InterfaceRequest();
  };
  FileSystemAccessManager_GetFileHandleFromToken_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessManager_GetFileHandleFromToken_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessManager_GetFileHandleFromToken_Params.token
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessManager_GetFileHandleFromToken_Params.fileHandle
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessManager_GetFileHandleFromToken_Params.encodedSize = codec.kStructHeaderSize + 16;

  FileSystemAccessManager_GetFileHandleFromToken_Params.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessManager_GetFileHandleFromToken_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.token =
        decoder.decodeStruct(new codec.Interface(file_system_access_transfer_token$.FileSystemAccessTransferTokenPtr));
    val.fileHandle =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FileSystemAccessManager_GetFileHandleFromToken_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessManager_GetFileHandleFromToken_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(file_system_access_transfer_token$.FileSystemAccessTransferTokenPtr), val.token);
    encoder.encodeStruct(codec.InterfaceRequest, val.fileHandle);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FileSystemAccessManager_GetDirectoryHandleFromToken_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessManager_GetDirectoryHandleFromToken_Params.prototype.initDefaults_ = function() {
    this.token = new file_system_access_transfer_token$.FileSystemAccessTransferTokenPtr();
    this.directoryHandle = new bindings.InterfaceRequest();
  };
  FileSystemAccessManager_GetDirectoryHandleFromToken_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessManager_GetDirectoryHandleFromToken_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessManager_GetDirectoryHandleFromToken_Params.token
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessManager_GetDirectoryHandleFromToken_Params.directoryHandle
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessManager_GetDirectoryHandleFromToken_Params.encodedSize = codec.kStructHeaderSize + 16;

  FileSystemAccessManager_GetDirectoryHandleFromToken_Params.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessManager_GetDirectoryHandleFromToken_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.token =
        decoder.decodeStruct(new codec.Interface(file_system_access_transfer_token$.FileSystemAccessTransferTokenPtr));
    val.directoryHandle =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FileSystemAccessManager_GetDirectoryHandleFromToken_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessManager_GetDirectoryHandleFromToken_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(file_system_access_transfer_token$.FileSystemAccessTransferTokenPtr), val.token);
    encoder.encodeStruct(codec.InterfaceRequest, val.directoryHandle);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FileSystemAccessManager_GetEntryFromDataTransferToken_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessManager_GetEntryFromDataTransferToken_Params.prototype.initDefaults_ = function() {
    this.token = new file_system_access_data_transfer_token$.FileSystemAccessDataTransferTokenPtr();
  };
  FileSystemAccessManager_GetEntryFromDataTransferToken_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessManager_GetEntryFromDataTransferToken_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessManager_GetEntryFromDataTransferToken_Params.token
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessManager_GetEntryFromDataTransferToken_Params.encodedSize = codec.kStructHeaderSize + 8;

  FileSystemAccessManager_GetEntryFromDataTransferToken_Params.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessManager_GetEntryFromDataTransferToken_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.token =
        decoder.decodeStruct(new codec.Interface(file_system_access_data_transfer_token$.FileSystemAccessDataTransferTokenPtr));
    return val;
  };

  FileSystemAccessManager_GetEntryFromDataTransferToken_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessManager_GetEntryFromDataTransferToken_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(file_system_access_data_transfer_token$.FileSystemAccessDataTransferTokenPtr), val.token);
  };
  function FileSystemAccessManager_GetEntryFromDataTransferToken_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessManager_GetEntryFromDataTransferToken_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
    this.entry = null;
  };
  FileSystemAccessManager_GetEntryFromDataTransferToken_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessManager_GetEntryFromDataTransferToken_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessManager_GetEntryFromDataTransferToken_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_system_access_error$.FileSystemAccessError, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessManager_GetEntryFromDataTransferToken_ResponseParams.entry
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, file_system_access_directory_handle$.FileSystemAccessEntry, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessManager_GetEntryFromDataTransferToken_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  FileSystemAccessManager_GetEntryFromDataTransferToken_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessManager_GetEntryFromDataTransferToken_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(file_system_access_error$.FileSystemAccessError);
    val.entry =
        decoder.decodeStructPointer(file_system_access_directory_handle$.FileSystemAccessEntry);
    return val;
  };

  FileSystemAccessManager_GetEntryFromDataTransferToken_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessManager_GetEntryFromDataTransferToken_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_system_access_error$.FileSystemAccessError, val.result);
    encoder.encodeStructPointer(file_system_access_directory_handle$.FileSystemAccessEntry, val.entry);
  };
  function FileSystemAccessManager_BindObserverHost_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessManager_BindObserverHost_Params.prototype.initDefaults_ = function() {
    this.observerHost = new bindings.InterfaceRequest();
  };
  FileSystemAccessManager_BindObserverHost_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessManager_BindObserverHost_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessManager_BindObserverHost_Params.observerHost
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessManager_BindObserverHost_Params.encodedSize = codec.kStructHeaderSize + 8;

  FileSystemAccessManager_BindObserverHost_Params.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessManager_BindObserverHost_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.observerHost =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FileSystemAccessManager_BindObserverHost_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessManager_BindObserverHost_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.observerHost);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };

  function TypeSpecificFilePickerOptionsUnion(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  TypeSpecificFilePickerOptionsUnion.Tags = {
    openFilePickerOptions: 0,
    saveFilePickerOptions: 1,
    directoryPickerOptions: 2,
  };

  TypeSpecificFilePickerOptionsUnion.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  TypeSpecificFilePickerOptionsUnion.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "openFilePickerOptions",
        "saveFilePickerOptions",
        "directoryPickerOptions",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a TypeSpecificFilePickerOptionsUnion member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(TypeSpecificFilePickerOptionsUnion.prototype, "openFilePickerOptions", {
    get: function() {
      if (this.$tag != TypeSpecificFilePickerOptionsUnion.Tags.openFilePickerOptions) {
        throw new ReferenceError(
            "TypeSpecificFilePickerOptionsUnion.openFilePickerOptions is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = TypeSpecificFilePickerOptionsUnion.Tags.openFilePickerOptions;
      this.$data = value;
    }
  });
  Object.defineProperty(TypeSpecificFilePickerOptionsUnion.prototype, "saveFilePickerOptions", {
    get: function() {
      if (this.$tag != TypeSpecificFilePickerOptionsUnion.Tags.saveFilePickerOptions) {
        throw new ReferenceError(
            "TypeSpecificFilePickerOptionsUnion.saveFilePickerOptions is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = TypeSpecificFilePickerOptionsUnion.Tags.saveFilePickerOptions;
      this.$data = value;
    }
  });
  Object.defineProperty(TypeSpecificFilePickerOptionsUnion.prototype, "directoryPickerOptions", {
    get: function() {
      if (this.$tag != TypeSpecificFilePickerOptionsUnion.Tags.directoryPickerOptions) {
        throw new ReferenceError(
            "TypeSpecificFilePickerOptionsUnion.directoryPickerOptions is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = TypeSpecificFilePickerOptionsUnion.Tags.directoryPickerOptions;
      this.$data = value;
    }
  });


    TypeSpecificFilePickerOptionsUnion.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case TypeSpecificFilePickerOptionsUnion.Tags.openFilePickerOptions:
          encoder.encodeStructPointer(OpenFilePickerOptions, val.openFilePickerOptions);
          break;
        case TypeSpecificFilePickerOptionsUnion.Tags.saveFilePickerOptions:
          encoder.encodeStructPointer(SaveFilePickerOptions, val.saveFilePickerOptions);
          break;
        case TypeSpecificFilePickerOptionsUnion.Tags.directoryPickerOptions:
          encoder.encodeStructPointer(DirectoryPickerOptions, val.directoryPickerOptions);
          break;
      }
      encoder.align();
    };


    TypeSpecificFilePickerOptionsUnion.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new TypeSpecificFilePickerOptionsUnion();
      var tag = decoder.readUint32();
      switch (tag) {
        case TypeSpecificFilePickerOptionsUnion.Tags.openFilePickerOptions:
          result.openFilePickerOptions = decoder.decodeStructPointer(OpenFilePickerOptions);
          break;
        case TypeSpecificFilePickerOptionsUnion.Tags.saveFilePickerOptions:
          result.saveFilePickerOptions = decoder.decodeStructPointer(SaveFilePickerOptions);
          break;
        case TypeSpecificFilePickerOptionsUnion.Tags.directoryPickerOptions:
          result.directoryPickerOptions = decoder.decodeStructPointer(DirectoryPickerOptions);
          break;
      }
      decoder.align();

      return result;
    };


    TypeSpecificFilePickerOptionsUnion.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case TypeSpecificFilePickerOptionsUnion.Tags.openFilePickerOptions:
          

    // validate TypeSpecificFilePickerOptionsUnion.openFilePickerOptions
    err = messageValidator.validateStructPointer(data_offset, OpenFilePickerOptions, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case TypeSpecificFilePickerOptionsUnion.Tags.saveFilePickerOptions:
          

    // validate TypeSpecificFilePickerOptionsUnion.saveFilePickerOptions
    err = messageValidator.validateStructPointer(data_offset, SaveFilePickerOptions, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case TypeSpecificFilePickerOptionsUnion.Tags.directoryPickerOptions:
          

    // validate TypeSpecificFilePickerOptionsUnion.directoryPickerOptions
    err = messageValidator.validateStructPointer(data_offset, DirectoryPickerOptions, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  TypeSpecificFilePickerOptionsUnion.encodedSize = 16;

  function FilePickerStartInOptionsUnion(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  FilePickerStartInOptionsUnion.Tags = {
    wellKnownDirectory: 0,
    directoryToken: 1,
  };

  FilePickerStartInOptionsUnion.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  FilePickerStartInOptionsUnion.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "wellKnownDirectory",
        "directoryToken",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a FilePickerStartInOptionsUnion member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(FilePickerStartInOptionsUnion.prototype, "wellKnownDirectory", {
    get: function() {
      if (this.$tag != FilePickerStartInOptionsUnion.Tags.wellKnownDirectory) {
        throw new ReferenceError(
            "FilePickerStartInOptionsUnion.wellKnownDirectory is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = FilePickerStartInOptionsUnion.Tags.wellKnownDirectory;
      this.$data = value;
    }
  });
  Object.defineProperty(FilePickerStartInOptionsUnion.prototype, "directoryToken", {
    get: function() {
      if (this.$tag != FilePickerStartInOptionsUnion.Tags.directoryToken) {
        throw new ReferenceError(
            "FilePickerStartInOptionsUnion.directoryToken is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = FilePickerStartInOptionsUnion.Tags.directoryToken;
      this.$data = value;
    }
  });


    FilePickerStartInOptionsUnion.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case FilePickerStartInOptionsUnion.Tags.wellKnownDirectory:
          encoder.encodeStruct(codec.Int32, val.wellKnownDirectory);
          break;
        case FilePickerStartInOptionsUnion.Tags.directoryToken:
          encoder.encodeStruct(new codec.Interface(file_system_access_transfer_token$.FileSystemAccessTransferTokenPtr), val.directoryToken);
          break;
      }
      encoder.align();
    };


    FilePickerStartInOptionsUnion.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new FilePickerStartInOptionsUnion();
      var tag = decoder.readUint32();
      switch (tag) {
        case FilePickerStartInOptionsUnion.Tags.wellKnownDirectory:
          result.wellKnownDirectory = decoder.decodeStruct(new codec.Enum(WellKnownDirectory));
          break;
        case FilePickerStartInOptionsUnion.Tags.directoryToken:
          result.directoryToken = decoder.decodeStruct(new codec.Interface(file_system_access_transfer_token$.FileSystemAccessTransferTokenPtr));
          break;
      }
      decoder.align();

      return result;
    };


    FilePickerStartInOptionsUnion.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case FilePickerStartInOptionsUnion.Tags.wellKnownDirectory:
          

    // validate FilePickerStartInOptionsUnion.wellKnownDirectory
    err = messageValidator.validateEnum(data_offset, WellKnownDirectory);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case FilePickerStartInOptionsUnion.Tags.directoryToken:
          

    // validate FilePickerStartInOptionsUnion.directoryToken
    err = messageValidator.validateInterface(data_offset, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  FilePickerStartInOptionsUnion.encodedSize = 16;
  var kFileSystemAccessManager_GetSandboxedFileSystem_Name = 0;
  var kFileSystemAccessManager_GetSandboxedFileSystemForDevtools_Name = 1;
  var kFileSystemAccessManager_ChooseEntries_Name = 2;
  var kFileSystemAccessManager_GetFileHandleFromToken_Name = 3;
  var kFileSystemAccessManager_GetDirectoryHandleFromToken_Name = 4;
  var kFileSystemAccessManager_GetEntryFromDataTransferToken_Name = 5;
  var kFileSystemAccessManager_BindObserverHost_Name = 6;

  function FileSystemAccessManagerPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(FileSystemAccessManager,
                                                   handleOrPtrInfo);
  }

  function FileSystemAccessManagerAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        FileSystemAccessManager, associatedInterfacePtrInfo);
  }

  FileSystemAccessManagerAssociatedPtr.prototype =
      Object.create(FileSystemAccessManagerPtr.prototype);
  FileSystemAccessManagerAssociatedPtr.prototype.constructor =
      FileSystemAccessManagerAssociatedPtr;

  function FileSystemAccessManagerProxy(receiver) {
    this.receiver_ = receiver;
  }
  FileSystemAccessManagerPtr.prototype.getSandboxedFileSystem = function() {
    return FileSystemAccessManagerProxy.prototype.getSandboxedFileSystem
        .apply(this.ptr.getProxy(), arguments);
  };

  FileSystemAccessManagerProxy.prototype.getSandboxedFileSystem = function() {
    var params_ = new FileSystemAccessManager_GetSandboxedFileSystem_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFileSystemAccessManager_GetSandboxedFileSystem_Name,
          codec.align(FileSystemAccessManager_GetSandboxedFileSystem_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FileSystemAccessManager_GetSandboxedFileSystem_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FileSystemAccessManager_GetSandboxedFileSystem_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  FileSystemAccessManagerPtr.prototype.getSandboxedFileSystemForDevtools = function() {
    return FileSystemAccessManagerProxy.prototype.getSandboxedFileSystemForDevtools
        .apply(this.ptr.getProxy(), arguments);
  };

  FileSystemAccessManagerProxy.prototype.getSandboxedFileSystemForDevtools = function(directoryPathComponents) {
    var params_ = new FileSystemAccessManager_GetSandboxedFileSystemForDevtools_Params();
    params_.directoryPathComponents = directoryPathComponents;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFileSystemAccessManager_GetSandboxedFileSystemForDevtools_Name,
          codec.align(FileSystemAccessManager_GetSandboxedFileSystemForDevtools_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FileSystemAccessManager_GetSandboxedFileSystemForDevtools_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  FileSystemAccessManagerPtr.prototype.chooseEntries = function() {
    return FileSystemAccessManagerProxy.prototype.chooseEntries
        .apply(this.ptr.getProxy(), arguments);
  };

  FileSystemAccessManagerProxy.prototype.chooseEntries = function(options) {
    var params_ = new FileSystemAccessManager_ChooseEntries_Params();
    params_.options = options;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFileSystemAccessManager_ChooseEntries_Name,
          codec.align(FileSystemAccessManager_ChooseEntries_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FileSystemAccessManager_ChooseEntries_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FileSystemAccessManager_ChooseEntries_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  FileSystemAccessManagerPtr.prototype.getFileHandleFromToken = function() {
    return FileSystemAccessManagerProxy.prototype.getFileHandleFromToken
        .apply(this.ptr.getProxy(), arguments);
  };

  FileSystemAccessManagerProxy.prototype.getFileHandleFromToken = function(token, fileHandle) {
    var params_ = new FileSystemAccessManager_GetFileHandleFromToken_Params();
    params_.token = token;
    params_.fileHandle = fileHandle;
    var builder = new codec.MessageV0Builder(
        kFileSystemAccessManager_GetFileHandleFromToken_Name,
        codec.align(FileSystemAccessManager_GetFileHandleFromToken_Params.encodedSize));
    builder.encodeStruct(FileSystemAccessManager_GetFileHandleFromToken_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FileSystemAccessManagerPtr.prototype.getDirectoryHandleFromToken = function() {
    return FileSystemAccessManagerProxy.prototype.getDirectoryHandleFromToken
        .apply(this.ptr.getProxy(), arguments);
  };

  FileSystemAccessManagerProxy.prototype.getDirectoryHandleFromToken = function(token, directoryHandle) {
    var params_ = new FileSystemAccessManager_GetDirectoryHandleFromToken_Params();
    params_.token = token;
    params_.directoryHandle = directoryHandle;
    var builder = new codec.MessageV0Builder(
        kFileSystemAccessManager_GetDirectoryHandleFromToken_Name,
        codec.align(FileSystemAccessManager_GetDirectoryHandleFromToken_Params.encodedSize));
    builder.encodeStruct(FileSystemAccessManager_GetDirectoryHandleFromToken_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FileSystemAccessManagerPtr.prototype.getEntryFromDataTransferToken = function() {
    return FileSystemAccessManagerProxy.prototype.getEntryFromDataTransferToken
        .apply(this.ptr.getProxy(), arguments);
  };

  FileSystemAccessManagerProxy.prototype.getEntryFromDataTransferToken = function(token) {
    var params_ = new FileSystemAccessManager_GetEntryFromDataTransferToken_Params();
    params_.token = token;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFileSystemAccessManager_GetEntryFromDataTransferToken_Name,
          codec.align(FileSystemAccessManager_GetEntryFromDataTransferToken_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FileSystemAccessManager_GetEntryFromDataTransferToken_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FileSystemAccessManager_GetEntryFromDataTransferToken_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  FileSystemAccessManagerPtr.prototype.bindObserverHost = function() {
    return FileSystemAccessManagerProxy.prototype.bindObserverHost
        .apply(this.ptr.getProxy(), arguments);
  };

  FileSystemAccessManagerProxy.prototype.bindObserverHost = function(observerHost) {
    var params_ = new FileSystemAccessManager_BindObserverHost_Params();
    params_.observerHost = observerHost;
    var builder = new codec.MessageV0Builder(
        kFileSystemAccessManager_BindObserverHost_Name,
        codec.align(FileSystemAccessManager_BindObserverHost_Params.encodedSize));
    builder.encodeStruct(FileSystemAccessManager_BindObserverHost_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function FileSystemAccessManagerStub(delegate) {
    this.delegate_ = delegate;
  }
  FileSystemAccessManagerStub.prototype.getSandboxedFileSystem = function() {
    return this.delegate_ && this.delegate_.getSandboxedFileSystem && this.delegate_.getSandboxedFileSystem();
  }
  FileSystemAccessManagerStub.prototype.getSandboxedFileSystemForDevtools = function(directoryPathComponents) {
    return this.delegate_ && this.delegate_.getSandboxedFileSystemForDevtools && this.delegate_.getSandboxedFileSystemForDevtools(directoryPathComponents);
  }
  FileSystemAccessManagerStub.prototype.chooseEntries = function(options) {
    return this.delegate_ && this.delegate_.chooseEntries && this.delegate_.chooseEntries(options);
  }
  FileSystemAccessManagerStub.prototype.getFileHandleFromToken = function(token, fileHandle) {
    return this.delegate_ && this.delegate_.getFileHandleFromToken && this.delegate_.getFileHandleFromToken(token, fileHandle);
  }
  FileSystemAccessManagerStub.prototype.getDirectoryHandleFromToken = function(token, directoryHandle) {
    return this.delegate_ && this.delegate_.getDirectoryHandleFromToken && this.delegate_.getDirectoryHandleFromToken(token, directoryHandle);
  }
  FileSystemAccessManagerStub.prototype.getEntryFromDataTransferToken = function(token) {
    return this.delegate_ && this.delegate_.getEntryFromDataTransferToken && this.delegate_.getEntryFromDataTransferToken(token);
  }
  FileSystemAccessManagerStub.prototype.bindObserverHost = function(observerHost) {
    return this.delegate_ && this.delegate_.bindObserverHost && this.delegate_.bindObserverHost(observerHost);
  }

  FileSystemAccessManagerStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kFileSystemAccessManager_GetFileHandleFromToken_Name:
      var params = reader.decodeStruct(FileSystemAccessManager_GetFileHandleFromToken_Params);
      this.getFileHandleFromToken(params.token, params.fileHandle);
      return true;
    case kFileSystemAccessManager_GetDirectoryHandleFromToken_Name:
      var params = reader.decodeStruct(FileSystemAccessManager_GetDirectoryHandleFromToken_Params);
      this.getDirectoryHandleFromToken(params.token, params.directoryHandle);
      return true;
    case kFileSystemAccessManager_BindObserverHost_Name:
      var params = reader.decodeStruct(FileSystemAccessManager_BindObserverHost_Params);
      this.bindObserverHost(params.observerHost);
      return true;
    default:
      return false;
    }
  };

  FileSystemAccessManagerStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kFileSystemAccessManager_GetSandboxedFileSystem_Name:
      var params = reader.decodeStruct(FileSystemAccessManager_GetSandboxedFileSystem_Params);
      this.getSandboxedFileSystem().then(function(response) {
        var responseParams =
            new FileSystemAccessManager_GetSandboxedFileSystem_ResponseParams();
        responseParams.result = response.result;
        responseParams.directory = response.directory;
        var builder = new codec.MessageV1Builder(
            kFileSystemAccessManager_GetSandboxedFileSystem_Name,
            codec.align(FileSystemAccessManager_GetSandboxedFileSystem_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FileSystemAccessManager_GetSandboxedFileSystem_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kFileSystemAccessManager_GetSandboxedFileSystemForDevtools_Name:
      var params = reader.decodeStruct(FileSystemAccessManager_GetSandboxedFileSystemForDevtools_Params);
      this.getSandboxedFileSystemForDevtools(params.directoryPathComponents).then(function(response) {
        var responseParams =
            new FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ResponseParams();
        responseParams.result = response.result;
        responseParams.directory = response.directory;
        var builder = new codec.MessageV1Builder(
            kFileSystemAccessManager_GetSandboxedFileSystemForDevtools_Name,
            codec.align(FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kFileSystemAccessManager_ChooseEntries_Name:
      var params = reader.decodeStruct(FileSystemAccessManager_ChooseEntries_Params);
      this.chooseEntries(params.options).then(function(response) {
        var responseParams =
            new FileSystemAccessManager_ChooseEntries_ResponseParams();
        responseParams.result = response.result;
        responseParams.entries = response.entries;
        var builder = new codec.MessageV1Builder(
            kFileSystemAccessManager_ChooseEntries_Name,
            codec.align(FileSystemAccessManager_ChooseEntries_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FileSystemAccessManager_ChooseEntries_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kFileSystemAccessManager_GetEntryFromDataTransferToken_Name:
      var params = reader.decodeStruct(FileSystemAccessManager_GetEntryFromDataTransferToken_Params);
      this.getEntryFromDataTransferToken(params.token).then(function(response) {
        var responseParams =
            new FileSystemAccessManager_GetEntryFromDataTransferToken_ResponseParams();
        responseParams.result = response.result;
        responseParams.entry = response.entry;
        var builder = new codec.MessageV1Builder(
            kFileSystemAccessManager_GetEntryFromDataTransferToken_Name,
            codec.align(FileSystemAccessManager_GetEntryFromDataTransferToken_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FileSystemAccessManager_GetEntryFromDataTransferToken_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateFileSystemAccessManagerRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kFileSystemAccessManager_GetSandboxedFileSystem_Name:
        if (message.expectsResponse())
          paramsClass = FileSystemAccessManager_GetSandboxedFileSystem_Params;
      break;
      case kFileSystemAccessManager_GetSandboxedFileSystemForDevtools_Name:
        if (message.expectsResponse())
          paramsClass = FileSystemAccessManager_GetSandboxedFileSystemForDevtools_Params;
      break;
      case kFileSystemAccessManager_ChooseEntries_Name:
        if (message.expectsResponse())
          paramsClass = FileSystemAccessManager_ChooseEntries_Params;
      break;
      case kFileSystemAccessManager_GetFileHandleFromToken_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FileSystemAccessManager_GetFileHandleFromToken_Params;
      break;
      case kFileSystemAccessManager_GetDirectoryHandleFromToken_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FileSystemAccessManager_GetDirectoryHandleFromToken_Params;
      break;
      case kFileSystemAccessManager_GetEntryFromDataTransferToken_Name:
        if (message.expectsResponse())
          paramsClass = FileSystemAccessManager_GetEntryFromDataTransferToken_Params;
      break;
      case kFileSystemAccessManager_BindObserverHost_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FileSystemAccessManager_BindObserverHost_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateFileSystemAccessManagerResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kFileSystemAccessManager_GetSandboxedFileSystem_Name:
        if (message.isResponse())
          paramsClass = FileSystemAccessManager_GetSandboxedFileSystem_ResponseParams;
        break;
      case kFileSystemAccessManager_GetSandboxedFileSystemForDevtools_Name:
        if (message.isResponse())
          paramsClass = FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ResponseParams;
        break;
      case kFileSystemAccessManager_ChooseEntries_Name:
        if (message.isResponse())
          paramsClass = FileSystemAccessManager_ChooseEntries_ResponseParams;
        break;
      case kFileSystemAccessManager_GetEntryFromDataTransferToken_Name:
        if (message.isResponse())
          paramsClass = FileSystemAccessManager_GetEntryFromDataTransferToken_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var FileSystemAccessManager = {
    name: 'blink.mojom.FileSystemAccessManager',
    kVersion: 0,
    ptrClass: FileSystemAccessManagerPtr,
    proxyClass: FileSystemAccessManagerProxy,
    stubClass: FileSystemAccessManagerStub,
    validateRequest: validateFileSystemAccessManagerRequest,
    validateResponse: validateFileSystemAccessManagerResponse,
  };
  FileSystemAccessManagerStub.prototype.validator = validateFileSystemAccessManagerRequest;
  FileSystemAccessManagerProxy.prototype.validator = validateFileSystemAccessManagerResponse;
  exports.WellKnownDirectory = WellKnownDirectory;
  exports.ChooseFileSystemEntryAcceptsOption = ChooseFileSystemEntryAcceptsOption;
  exports.AcceptsTypesInfo = AcceptsTypesInfo;
  exports.OpenFilePickerOptions = OpenFilePickerOptions;
  exports.SaveFilePickerOptions = SaveFilePickerOptions;
  exports.DirectoryPickerOptions = DirectoryPickerOptions;
  exports.FilePickerOptions = FilePickerOptions;
  exports.TypeSpecificFilePickerOptionsUnion = TypeSpecificFilePickerOptionsUnion;
  exports.FilePickerStartInOptionsUnion = FilePickerStartInOptionsUnion;
  exports.FileSystemAccessManager = FileSystemAccessManager;
  exports.FileSystemAccessManagerPtr = FileSystemAccessManagerPtr;
  exports.FileSystemAccessManagerAssociatedPtr = FileSystemAccessManagerAssociatedPtr;
})();