// third_party/blink/public/mojom/file_system_access/file_system_access_file_modification_host.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_modification_host.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_modification_host.mojom-params-data.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_modification_host.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_modification_host.mojom-import-headers.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_modification_host.mojom-test-utils.h"


namespace blink::mojom {
// The declaration includes the definition on other builds.

FileSystemAccessFileModificationHost::IPCStableHashFunction FileSystemAccessFileModificationHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FileSystemAccessFileModificationHost>(message.name())) {
    case messages::FileSystemAccessFileModificationHost::kRequestCapacityChange: {
      return &FileSystemAccessFileModificationHost::RequestCapacityChange_Sym::IPCStableHash;
    }
    case messages::FileSystemAccessFileModificationHost::kOnContentsModified: {
      return &FileSystemAccessFileModificationHost::OnContentsModified_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FileSystemAccessFileModificationHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FileSystemAccessFileModificationHost>(message.name())) {
      case messages::FileSystemAccessFileModificationHost::kRequestCapacityChange:
            return "Receive blink::mojom::FileSystemAccessFileModificationHost::RequestCapacityChange";
      case messages::FileSystemAccessFileModificationHost::kOnContentsModified:
            return "Receive blink::mojom::FileSystemAccessFileModificationHost::OnContentsModified";
    }
  } else {
    switch (static_cast<messages::FileSystemAccessFileModificationHost>(message.name())) {
      case messages::FileSystemAccessFileModificationHost::kRequestCapacityChange:
            return "Receive reply blink::mojom::FileSystemAccessFileModificationHost::RequestCapacityChange";
      case messages::FileSystemAccessFileModificationHost::kOnContentsModified:
            return "Receive reply blink::mojom::FileSystemAccessFileModificationHost::OnContentsModified";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FileSystemAccessFileModificationHost::RequestCapacityChange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x916acd73;  // IPCStableHash for blink::mojom::FileSystemAccessFileModificationHost::RequestCapacityChange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemAccessFileModificationHost::OnContentsModified_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2eb4ad85;  // IPCStableHash for blink::mojom::FileSystemAccessFileModificationHost::OnContentsModified
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool FileSystemAccessFileModificationHost::RequestCapacityChange(int64_t capacity_delta, int64_t* out_granted_capacity_delta) {
  NOTREACHED();
}
class FileSystemAccessFileModificationHost_RequestCapacityChange_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessFileModificationHost_RequestCapacityChange_HandleSyncResponse(
      bool* result, int64_t* out_granted_capacity_delta)
      : result_(result), out_granted_capacity_delta_(out_granted_capacity_delta) {
    DCHECK(!*result_);
  }

  FileSystemAccessFileModificationHost_RequestCapacityChange_HandleSyncResponse(const FileSystemAccessFileModificationHost_RequestCapacityChange_HandleSyncResponse&) = delete;
  FileSystemAccessFileModificationHost_RequestCapacityChange_HandleSyncResponse& operator=(const FileSystemAccessFileModificationHost_RequestCapacityChange_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  int64_t* out_granted_capacity_delta_;};

class FileSystemAccessFileModificationHost_RequestCapacityChange_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessFileModificationHost_RequestCapacityChange_ForwardToCallback(
      FileSystemAccessFileModificationHost::RequestCapacityChangeCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemAccessFileModificationHost_RequestCapacityChange_ForwardToCallback(const FileSystemAccessFileModificationHost_RequestCapacityChange_ForwardToCallback&) = delete;
  FileSystemAccessFileModificationHost_RequestCapacityChange_ForwardToCallback& operator=(const FileSystemAccessFileModificationHost_RequestCapacityChange_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessFileModificationHost::RequestCapacityChangeCallback callback_;
};

FileSystemAccessFileModificationHostProxy::FileSystemAccessFileModificationHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool FileSystemAccessFileModificationHostProxy::RequestCapacityChange(
    int64_t param_capacity_delta, int64_t* out_param_granted_capacity_delta) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call blink::mojom::FileSystemAccessFileModificationHost::RequestCapacityChange (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("capacity_delta"), param_capacity_delta,
                        "<value of type int64_t>");
   });
#else
  TRACE_EVENT0("mojom", "FileSystemAccessFileModificationHost::RequestCapacityChange");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessFileModificationHost::kRequestCapacityChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileModificationHost_RequestCapacityChange_Params_Data> params(
          message);
  params.Allocate();

  params->capacity_delta = param_capacity_delta;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileModificationHost::Name_);
  message.set_method_name("RequestCapacityChange");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessFileModificationHost_RequestCapacityChange_HandleSyncResponse(
          &result, out_param_granted_capacity_delta));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "FileSystemAccessFileModificationHost::RequestCapacityChange", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("granted_capacity_delta"), out_param_granted_capacity_delta,
                        "<value of type int64_t>");
   });
#endif
  return result;
}

void FileSystemAccessFileModificationHostProxy::RequestCapacityChange(
    int64_t in_capacity_delta, RequestCapacityChangeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemAccessFileModificationHost::RequestCapacityChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("capacity_delta"), in_capacity_delta,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessFileModificationHost::kRequestCapacityChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileModificationHost_RequestCapacityChange_Params_Data> params(
          message);
  params.Allocate();

  params->capacity_delta = in_capacity_delta;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileModificationHost::Name_);
  message.set_method_name("RequestCapacityChange");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessFileModificationHost_RequestCapacityChange_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FileSystemAccessFileModificationHostProxy::OnContentsModified(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::FileSystemAccessFileModificationHost::OnContentsModified");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessFileModificationHost::kOnContentsModified), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileModificationHost_OnContentsModified_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileModificationHost::Name_);
  message.set_method_name("OnContentsModified");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class FileSystemAccessFileModificationHost_RequestCapacityChange_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemAccessFileModificationHost::RequestCapacityChangeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemAccessFileModificationHost_RequestCapacityChange_ProxyToResponder> proxy(
        new FileSystemAccessFileModificationHost_RequestCapacityChange_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemAccessFileModificationHost_RequestCapacityChange_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessFileModificationHost_RequestCapacityChange_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemAccessFileModificationHost_RequestCapacityChange_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemAccessFileModificationHost::RequestCapacityChangeCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      int64_t in_granted_capacity_delta);
};

bool FileSystemAccessFileModificationHost_RequestCapacityChange_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemAccessFileModificationHost_RequestCapacityChange_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessFileModificationHost_RequestCapacityChange_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemAccessFileModificationHost.0
  bool success = true;
  int64_t p_granted_capacity_delta{};
  FileSystemAccessFileModificationHost_RequestCapacityChange_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_granted_capacity_delta = input_data_view.granted_capacity_delta();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessFileModificationHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_granted_capacity_delta));
  }
  return true;
}

void FileSystemAccessFileModificationHost_RequestCapacityChange_ProxyToResponder::Run(
    int64_t in_granted_capacity_delta) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemAccessFileModificationHost::RequestCapacityChange", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("granted_capacity_delta"), in_granted_capacity_delta,
                        "<value of type int64_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessFileModificationHost::kRequestCapacityChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileModificationHost_RequestCapacityChange_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->granted_capacity_delta = in_granted_capacity_delta;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileModificationHost::Name_);
  message.set_method_name("RequestCapacityChange");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool FileSystemAccessFileModificationHost_RequestCapacityChange_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemAccessFileModificationHost_RequestCapacityChange_ResponseParams_Data* params =
      reinterpret_cast<internal::FileSystemAccessFileModificationHost_RequestCapacityChange_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for FileSystemAccessFileModificationHost.0
  bool success = true;
  int64_t p_granted_capacity_delta{};
  FileSystemAccessFileModificationHost_RequestCapacityChange_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_granted_capacity_delta = input_data_view.granted_capacity_delta();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessFileModificationHost::Name_, 0, true);
    return false;
  }
  *out_granted_capacity_delta_ = std::move(p_granted_capacity_delta);
  *result_ = true;
  return true;
}

// static
bool FileSystemAccessFileModificationHostStubDispatch::Accept(
    FileSystemAccessFileModificationHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FileSystemAccessFileModificationHost>(message->header()->name)) {
    case messages::FileSystemAccessFileModificationHost::kRequestCapacityChange: {
      break;
    }
    case messages::FileSystemAccessFileModificationHost::kOnContentsModified: {
      DCHECK(message->is_serialized());
      internal::FileSystemAccessFileModificationHost_OnContentsModified_Params_Data* params =
          reinterpret_cast<internal::FileSystemAccessFileModificationHost_OnContentsModified_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FileSystemAccessFileModificationHost.1
      bool success = true;
      FileSystemAccessFileModificationHost_OnContentsModified_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessFileModificationHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnContentsModified(        );
      return true;
    }
  }
  return false;
}

// static
bool FileSystemAccessFileModificationHostStubDispatch::AcceptWithResponder(
    FileSystemAccessFileModificationHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FileSystemAccessFileModificationHost>(message->header()->name)) {
    case messages::FileSystemAccessFileModificationHost::kRequestCapacityChange: {
      internal::FileSystemAccessFileModificationHost_RequestCapacityChange_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessFileModificationHost_RequestCapacityChange_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemAccessFileModificationHost.0
      bool success = true;
      int64_t p_capacity_delta{};
      FileSystemAccessFileModificationHost_RequestCapacityChange_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_capacity_delta = input_data_view.capacity_delta();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessFileModificationHost::Name_, 0, false);
        return false;
      }
      auto callback =
          FileSystemAccessFileModificationHost_RequestCapacityChange_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestCapacityChange(        
        std::move(p_capacity_delta), std::move(callback));
      return true;
    }
    case messages::FileSystemAccessFileModificationHost::kOnContentsModified: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kFileSystemAccessFileModificationHostValidationInfo[] = {
    { &internal::FileSystemAccessFileModificationHost_RequestCapacityChange_Params_Data::Validate,
     &internal::FileSystemAccessFileModificationHost_RequestCapacityChange_ResponseParams_Data::Validate},
    { &internal::FileSystemAccessFileModificationHost_OnContentsModified_Params_Data::Validate,
     nullptr /* no response */},
};

bool FileSystemAccessFileModificationHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::FileSystemAccessFileModificationHost::Name_,
    kFileSystemAccessFileModificationHostValidationInfo);
}

bool FileSystemAccessFileModificationHostResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::FileSystemAccessFileModificationHost::Name_,
    kFileSystemAccessFileModificationHostValidationInfo);
}


}  // blink::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void FileSystemAccessFileModificationHostInterceptorForTesting::RequestCapacityChange(int64_t capacity_delta, RequestCapacityChangeCallback callback) {
  GetForwardingInterface()->RequestCapacityChange(
    std::move(capacity_delta)
    , std::move(callback));
}
void FileSystemAccessFileModificationHostInterceptorForTesting::OnContentsModified() {
  GetForwardingInterface()->OnContentsModified();
}
FileSystemAccessFileModificationHostAsyncWaiter::FileSystemAccessFileModificationHostAsyncWaiter(
    FileSystemAccessFileModificationHost* proxy) : proxy_(proxy) {}

FileSystemAccessFileModificationHostAsyncWaiter::~FileSystemAccessFileModificationHostAsyncWaiter() = default;


void FileSystemAccessFileModificationHostAsyncWaiter::RequestCapacityChange(
    int64_t capacity_delta, int64_t* out_granted_capacity_delta) {
  base::RunLoop loop;
  proxy_->RequestCapacityChange(
      std::move(capacity_delta),
      base::BindOnce(
          [](base::RunLoop* loop,
             int64_t* out_granted_capacity_delta
,
             int64_t granted_capacity_delta) {*out_granted_capacity_delta = std::move(granted_capacity_delta);
            loop->Quit();
          },
          &loop,
          out_granted_capacity_delta));
  loop.Run();
}

int64_t FileSystemAccessFileModificationHostAsyncWaiter::RequestCapacityChange(
    int64_t capacity_delta) {
  int64_t async_wait_result;
  RequestCapacityChange(std::move(capacity_delta),&async_wait_result);
  return async_wait_result;
}






}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif