// third_party/blink/public/mojom/file_system_access/file_system_access_data_transfer_token.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/file_system_access/file_system_access_data_transfer_token.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/file_system_access/file_system_access_data_transfer_token.mojom-params-data.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_data_transfer_token.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/file_system_access/file_system_access_data_transfer_token.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_data_transfer_token.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
// The declaration includes the definition on other builds.

FileSystemAccessDataTransferToken::IPCStableHashFunction FileSystemAccessDataTransferToken::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FileSystemAccessDataTransferToken>(message.name())) {
    case messages::FileSystemAccessDataTransferToken::kGetInternalId: {
      return &FileSystemAccessDataTransferToken::GetInternalId_Sym::IPCStableHash;
    }
    case messages::FileSystemAccessDataTransferToken::kClone: {
      return &FileSystemAccessDataTransferToken::Clone_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FileSystemAccessDataTransferToken::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FileSystemAccessDataTransferToken>(message.name())) {
      case messages::FileSystemAccessDataTransferToken::kGetInternalId:
            return "Receive blink::mojom::FileSystemAccessDataTransferToken::GetInternalId";
      case messages::FileSystemAccessDataTransferToken::kClone:
            return "Receive blink::mojom::FileSystemAccessDataTransferToken::Clone";
    }
  } else {
    switch (static_cast<messages::FileSystemAccessDataTransferToken>(message.name())) {
      case messages::FileSystemAccessDataTransferToken::kGetInternalId:
            return "Receive reply blink::mojom::FileSystemAccessDataTransferToken::GetInternalId";
      case messages::FileSystemAccessDataTransferToken::kClone:
            return "Receive reply blink::mojom::FileSystemAccessDataTransferToken::Clone";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FileSystemAccessDataTransferToken::GetInternalId_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd97e184f;  // IPCStableHash for blink::mojom::FileSystemAccessDataTransferToken::GetInternalId
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemAccessDataTransferToken::Clone_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x50e124b9;  // IPCStableHash for blink::mojom::FileSystemAccessDataTransferToken::Clone
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class FileSystemAccessDataTransferToken_GetInternalId_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessDataTransferToken_GetInternalId_ForwardToCallback(
      FileSystemAccessDataTransferToken::GetInternalIdCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemAccessDataTransferToken_GetInternalId_ForwardToCallback(const FileSystemAccessDataTransferToken_GetInternalId_ForwardToCallback&) = delete;
  FileSystemAccessDataTransferToken_GetInternalId_ForwardToCallback& operator=(const FileSystemAccessDataTransferToken_GetInternalId_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessDataTransferToken::GetInternalIdCallback callback_;
};

FileSystemAccessDataTransferTokenProxy::FileSystemAccessDataTransferTokenProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FileSystemAccessDataTransferTokenProxy::GetInternalId(
    GetInternalIdCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::FileSystemAccessDataTransferToken::GetInternalId");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessDataTransferToken::kGetInternalId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessDataTransferToken_GetInternalId_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessDataTransferToken::Name_);
  message.set_method_name("GetInternalId");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessDataTransferToken_GetInternalId_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FileSystemAccessDataTransferTokenProxy::Clone(
    ::mojo::PendingReceiver<FileSystemAccessDataTransferToken> in_token_clone) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemAccessDataTransferToken::Clone", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token_clone"), in_token_clone,
                        "<value of type ::mojo::PendingReceiver<FileSystemAccessDataTransferToken>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessDataTransferToken::kClone), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessDataTransferToken_Clone_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::FileSystemAccessDataTransferTokenInterfaceBase>>(
    in_token_clone,
    &params->token_clone,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->token_clone)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid token_clone in FileSystemAccessDataTransferToken.Clone request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessDataTransferToken::Name_);
  message.set_method_name("Clone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class FileSystemAccessDataTransferToken_GetInternalId_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemAccessDataTransferToken::GetInternalIdCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemAccessDataTransferToken_GetInternalId_ProxyToResponder> proxy(
        new FileSystemAccessDataTransferToken_GetInternalId_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemAccessDataTransferToken_GetInternalId_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessDataTransferToken_GetInternalId_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemAccessDataTransferToken_GetInternalId_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemAccessDataTransferToken::GetInternalIdCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::base::UnguessableToken& in_id);
};

bool FileSystemAccessDataTransferToken_GetInternalId_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemAccessDataTransferToken_GetInternalId_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessDataTransferToken_GetInternalId_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemAccessDataTransferToken.0
  bool success = true;
  ::base::UnguessableToken p_id{};
  FileSystemAccessDataTransferToken_GetInternalId_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadId(&p_id))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessDataTransferToken::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_id));
  }
  return true;
}

void FileSystemAccessDataTransferToken_GetInternalId_ProxyToResponder::Run(
    const ::base::UnguessableToken& in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemAccessDataTransferToken::GetInternalId", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessDataTransferToken::kGetInternalId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessDataTransferToken_GetInternalId_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_id,
    id_fragment);

  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null id in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessDataTransferToken::Name_);
  message.set_method_name("GetInternalId");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool FileSystemAccessDataTransferTokenStubDispatch::Accept(
    FileSystemAccessDataTransferToken* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FileSystemAccessDataTransferToken>(message->header()->name)) {
    case messages::FileSystemAccessDataTransferToken::kGetInternalId: {
      break;
    }
    case messages::FileSystemAccessDataTransferToken::kClone: {
      DCHECK(message->is_serialized());
      internal::FileSystemAccessDataTransferToken_Clone_Params_Data* params =
          reinterpret_cast<internal::FileSystemAccessDataTransferToken_Clone_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FileSystemAccessDataTransferToken.1
      bool success = true;
      ::mojo::PendingReceiver<FileSystemAccessDataTransferToken> p_token_clone{};
      FileSystemAccessDataTransferToken_Clone_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_token_clone =
            input_data_view.TakeTokenClone<decltype(p_token_clone)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessDataTransferToken::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Clone(        
        std::move(p_token_clone));
      return true;
    }
  }
  return false;
}

// static
bool FileSystemAccessDataTransferTokenStubDispatch::AcceptWithResponder(
    FileSystemAccessDataTransferToken* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FileSystemAccessDataTransferToken>(message->header()->name)) {
    case messages::FileSystemAccessDataTransferToken::kGetInternalId: {
      internal::FileSystemAccessDataTransferToken_GetInternalId_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessDataTransferToken_GetInternalId_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemAccessDataTransferToken.0
      bool success = true;
      FileSystemAccessDataTransferToken_GetInternalId_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessDataTransferToken::Name_, 0, false);
        return false;
      }
      auto callback =
          FileSystemAccessDataTransferToken_GetInternalId_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetInternalId(std::move(callback));
      return true;
    }
    case messages::FileSystemAccessDataTransferToken::kClone: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kFileSystemAccessDataTransferTokenValidationInfo[] = {
    { &internal::FileSystemAccessDataTransferToken_GetInternalId_Params_Data::Validate,
     &internal::FileSystemAccessDataTransferToken_GetInternalId_ResponseParams_Data::Validate},
    { &internal::FileSystemAccessDataTransferToken_Clone_Params_Data::Validate,
     nullptr /* no response */},
};

bool FileSystemAccessDataTransferTokenRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::FileSystemAccessDataTransferToken::Name_,
    kFileSystemAccessDataTransferTokenValidationInfo);
}

bool FileSystemAccessDataTransferTokenResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::FileSystemAccessDataTransferToken::Name_,
    kFileSystemAccessDataTransferTokenValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void FileSystemAccessDataTransferTokenInterceptorForTesting::GetInternalId(GetInternalIdCallback callback) {
  GetForwardingInterface()->GetInternalId(std::move(callback));
}
void FileSystemAccessDataTransferTokenInterceptorForTesting::Clone(::mojo::PendingReceiver<FileSystemAccessDataTransferToken> token_clone) {
  GetForwardingInterface()->Clone(
    std::move(token_clone)
    );
}
FileSystemAccessDataTransferTokenAsyncWaiter::FileSystemAccessDataTransferTokenAsyncWaiter(
    FileSystemAccessDataTransferToken* proxy) : proxy_(proxy) {}

FileSystemAccessDataTransferTokenAsyncWaiter::~FileSystemAccessDataTransferTokenAsyncWaiter() = default;


void FileSystemAccessDataTransferTokenAsyncWaiter::GetInternalId(
    ::base::UnguessableToken* out_id) {
  base::RunLoop loop;
  proxy_->GetInternalId(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::UnguessableToken* out_id
,
             const ::base::UnguessableToken& id) {*out_id = std::move(id);
            loop->Quit();
          },
          &loop,
          out_id));
  loop.Run();
}

::base::UnguessableToken FileSystemAccessDataTransferTokenAsyncWaiter::GetInternalId(
    ) {
  ::base::UnguessableToken async_wait_result;
  GetInternalId(&async_wait_result);
  return async_wait_result;
}






}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif