// third_party/blink/public/mojom/file/file_utilities.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/file/file_utilities.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/file/file_utilities.mojom-params-data.h"
#include "third_party/blink/public/mojom/file/file_utilities.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/file/file_utilities.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/file/file_utilities.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
// The declaration includes the definition on other builds.

FileUtilitiesHost::IPCStableHashFunction FileUtilitiesHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FileUtilitiesHost>(message.name())) {
    case messages::FileUtilitiesHost::kGetFileInfo: {
      return &FileUtilitiesHost::GetFileInfo_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FileUtilitiesHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FileUtilitiesHost>(message.name())) {
      case messages::FileUtilitiesHost::kGetFileInfo:
            return "Receive blink::mojom::FileUtilitiesHost::GetFileInfo";
    }
  } else {
    switch (static_cast<messages::FileUtilitiesHost>(message.name())) {
      case messages::FileUtilitiesHost::kGetFileInfo:
            return "Receive reply blink::mojom::FileUtilitiesHost::GetFileInfo";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FileUtilitiesHost::GetFileInfo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd9c0d845;  // IPCStableHash for blink::mojom::FileUtilitiesHost::GetFileInfo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool FileUtilitiesHost::GetFileInfo(const ::base::FilePath& path, std::optional<::base::File::Info>* out_result) {
  NOTREACHED();
}
class FileUtilitiesHost_GetFileInfo_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  FileUtilitiesHost_GetFileInfo_HandleSyncResponse(
      bool* result, std::optional<::base::File::Info>* out_result)
      : result_(result), out_result_(out_result) {
    DCHECK(!*result_);
  }

  FileUtilitiesHost_GetFileInfo_HandleSyncResponse(const FileUtilitiesHost_GetFileInfo_HandleSyncResponse&) = delete;
  FileUtilitiesHost_GetFileInfo_HandleSyncResponse& operator=(const FileUtilitiesHost_GetFileInfo_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  std::optional<::base::File::Info>* out_result_;};

class FileUtilitiesHost_GetFileInfo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileUtilitiesHost_GetFileInfo_ForwardToCallback(
      FileUtilitiesHost::GetFileInfoCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileUtilitiesHost_GetFileInfo_ForwardToCallback(const FileUtilitiesHost_GetFileInfo_ForwardToCallback&) = delete;
  FileUtilitiesHost_GetFileInfo_ForwardToCallback& operator=(const FileUtilitiesHost_GetFileInfo_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileUtilitiesHost::GetFileInfoCallback callback_;
};

FileUtilitiesHostProxy::FileUtilitiesHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool FileUtilitiesHostProxy::GetFileInfo(
    const ::base::FilePath& param_path, std::optional<::base::File::Info>* out_param_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call blink::mojom::FileUtilitiesHost::GetFileInfo (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), param_path,
                        "<value of type const ::base::FilePath&>");
   });
#else
  TRACE_EVENT0("mojom", "FileUtilitiesHost::GetFileInfo");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileUtilitiesHost::kGetFileInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileUtilitiesHost_GetFileInfo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
    param_path,
    path_fragment);

  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null path in FileUtilitiesHost.GetFileInfo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileUtilitiesHost::Name_);
  message.set_method_name("GetFileInfo");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileUtilitiesHost_GetFileInfo_HandleSyncResponse(
          &result, out_param_result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "FileUtilitiesHost::GetFileInfo", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), out_param_result,
                        "<value of type const std::optional<::base::File::Info>&>");
   });
#endif
  return result;
}

void FileUtilitiesHostProxy::GetFileInfo(
    const ::base::FilePath& in_path, GetFileInfoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileUtilitiesHost::GetFileInfo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const ::base::FilePath&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileUtilitiesHost::kGetFileInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileUtilitiesHost_GetFileInfo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
    in_path,
    path_fragment);

  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null path in FileUtilitiesHost.GetFileInfo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileUtilitiesHost::Name_);
  message.set_method_name("GetFileInfo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileUtilitiesHost_GetFileInfo_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class FileUtilitiesHost_GetFileInfo_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileUtilitiesHost::GetFileInfoCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileUtilitiesHost_GetFileInfo_ProxyToResponder> proxy(
        new FileUtilitiesHost_GetFileInfo_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileUtilitiesHost_GetFileInfo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileUtilitiesHost_GetFileInfo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileUtilitiesHost_GetFileInfo_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileUtilitiesHost::GetFileInfoCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<::base::File::Info>& in_result);
};

bool FileUtilitiesHost_GetFileInfo_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileUtilitiesHost_GetFileInfo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileUtilitiesHost_GetFileInfo_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileUtilitiesHost.0
  bool success = true;
  std::optional<::base::File::Info> p_result{};
  FileUtilitiesHost_GetFileInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileUtilitiesHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void FileUtilitiesHost_GetFileInfo_ProxyToResponder::Run(
    const std::optional<::base::File::Info>& in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileUtilitiesHost::GetFileInfo", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type const std::optional<::base::File::Info>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileUtilitiesHost::kGetFileInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileUtilitiesHost_GetFileInfo_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FileInfoDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileUtilitiesHost::Name_);
  message.set_method_name("GetFileInfo");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool FileUtilitiesHost_GetFileInfo_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileUtilitiesHost_GetFileInfo_ResponseParams_Data* params =
      reinterpret_cast<internal::FileUtilitiesHost_GetFileInfo_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for FileUtilitiesHost.0
  bool success = true;
  std::optional<::base::File::Info> p_result{};
  FileUtilitiesHost_GetFileInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileUtilitiesHost::Name_, 0, true);
    return false;
  }
  *out_result_ = std::move(p_result);
  *result_ = true;
  return true;
}

// static
bool FileUtilitiesHostStubDispatch::Accept(
    FileUtilitiesHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FileUtilitiesHost>(message->header()->name)) {
    case messages::FileUtilitiesHost::kGetFileInfo: {
      break;
    }
  }
  return false;
}

// static
bool FileUtilitiesHostStubDispatch::AcceptWithResponder(
    FileUtilitiesHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FileUtilitiesHost>(message->header()->name)) {
    case messages::FileUtilitiesHost::kGetFileInfo: {
      internal::FileUtilitiesHost_GetFileInfo_Params_Data* params =
          reinterpret_cast<
              internal::FileUtilitiesHost_GetFileInfo_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileUtilitiesHost.0
      bool success = true;
      ::base::FilePath p_path{};
      FileUtilitiesHost_GetFileInfo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileUtilitiesHost::Name_, 0, false);
        return false;
      }
      auto callback =
          FileUtilitiesHost_GetFileInfo_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetFileInfo(        
        std::move(p_path), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kFileUtilitiesHostValidationInfo[] = {
    { &internal::FileUtilitiesHost_GetFileInfo_Params_Data::Validate,
     &internal::FileUtilitiesHost_GetFileInfo_ResponseParams_Data::Validate},
};

bool FileUtilitiesHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::FileUtilitiesHost::Name_,
    kFileUtilitiesHostValidationInfo);
}

bool FileUtilitiesHostResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::FileUtilitiesHost::Name_,
    kFileUtilitiesHostValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void FileUtilitiesHostInterceptorForTesting::GetFileInfo(const ::base::FilePath& path, GetFileInfoCallback callback) {
  GetForwardingInterface()->GetFileInfo(
    std::move(path)
    , std::move(callback));
}
FileUtilitiesHostAsyncWaiter::FileUtilitiesHostAsyncWaiter(
    FileUtilitiesHost* proxy) : proxy_(proxy) {}

FileUtilitiesHostAsyncWaiter::~FileUtilitiesHostAsyncWaiter() = default;


void FileUtilitiesHostAsyncWaiter::GetFileInfo(
    const ::base::FilePath& path, std::optional<::base::File::Info>* out_result) {
  base::RunLoop loop;
  proxy_->GetFileInfo(
      std::move(path),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<::base::File::Info>* out_result
,
             const std::optional<::base::File::Info>& result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

std::optional<::base::File::Info> FileUtilitiesHostAsyncWaiter::GetFileInfo(
    const ::base::FilePath& path) {
  std::optional<::base::File::Info> async_wait_result;
  GetFileInfo(std::move(path),&async_wait_result);
  return async_wait_result;
}






}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif