// third_party/blink/public/mojom/fetch/fetch_api_request.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  UnguessableToken as mojoBase_mojom_UnguessableToken,
  UnguessableTokenSpec as mojoBase_mojom_UnguessableTokenSpec
} from '../../../../../mojo/public/mojom/base/unguessable_token.mojom.m.js';

import {
  AttributionReportingEligibility as network_mojom_AttributionReportingEligibility,
  AttributionReportingEligibilitySpec as network_mojom_AttributionReportingEligibilitySpec,
  AttributionSupport as network_mojom_AttributionSupport,
  AttributionSupportSpec as network_mojom_AttributionSupportSpec
} from '../../../../../services/network/public/mojom/attribution.mojom.m.js';

import {
  CredentialsMode as network_mojom_CredentialsMode,
  CredentialsModeSpec as network_mojom_CredentialsModeSpec,
  RedirectMode as network_mojom_RedirectMode,
  RedirectModeSpec as network_mojom_RedirectModeSpec,
  RequestDestination as network_mojom_RequestDestination,
  RequestDestinationSpec as network_mojom_RequestDestinationSpec,
  RequestMode as network_mojom_RequestMode,
  RequestModeSpec as network_mojom_RequestModeSpec
} from '../../../../../services/network/public/mojom/fetch_api.mojom.m.js';

import {
  IPAddressSpace as network_mojom_IPAddressSpace,
  IPAddressSpaceSpec as network_mojom_IPAddressSpaceSpec
} from '../../../../../services/network/public/mojom/ip_address_space.mojom.m.js';

import {
  RequestPriority as network_mojom_RequestPriority,
  RequestPrioritySpec as network_mojom_RequestPrioritySpec
} from '../../../../../services/network/public/mojom/request_priority.mojom.m.js';

import {
  TrustTokenParams as network_mojom_TrustTokenParams,
  TrustTokenParamsSpec as network_mojom_TrustTokenParamsSpec
} from '../../../../../services/network/public/mojom/trust_tokens.mojom.m.js';

import {
  DataElement as network_mojom_DataElement,
  DataElementSpec as network_mojom_DataElementSpec
} from '../../../../../services/network/public/mojom/url_request.mojom.m.js';

import {
  Origin as url_mojom_Origin,
  OriginSpec as url_mojom_OriginSpec
} from '../../../../../url/mojom/origin.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';

import {
  SerializedBlob as blink_mojom_SerializedBlob,
  SerializedBlobSpec as blink_mojom_SerializedBlobSpec
} from '../blob/serialized_blob.mojom.m.js';

import {
  Referrer as blink_mojom_Referrer,
  ReferrerSpec as blink_mojom_ReferrerSpec
} from '../loader/referrer.mojom.m.js';

import {
  RequestContextFrameType as blink_mojom_RequestContextFrameType,
  RequestContextFrameTypeSpec as blink_mojom_RequestContextFrameTypeSpec
} from '../loader/request_context_frame_type.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const RequestContextTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const RequestContextType = {
  
  UNSPECIFIED: 0,
  ATTRIBUTION_SRC: 1,
  AUDIO: 2,
  BEACON: 3,
  CSP_REPORT: 4,
  DOWNLOAD: 5,
  EMBED: 6,
  EVENT_SOURCE: 7,
  FAVICON: 8,
  FETCH: 9,
  FONT: 10,
  FORM: 11,
  FRAME: 12,
  HYPERLINK: 13,
  IFRAME: 14,
  IMAGE: 15,
  IMAGE_SET: 16,
  INTERNAL: 17,
  JSON: 18,
  LOCATION: 19,
  MANIFEST: 20,
  OBJECT: 21,
  PING: 22,
  PLUGIN: 23,
  PREFETCH: 24,
  SCRIPT: 25,
  SERVICE_WORKER: 26,
  SHARED_WORKER: 27,
  SPECULATION_RULES: 28,
  SUBRESOURCE: 29,
  SUBRESOURCE_WEBBUNDLE: 30,
  STYLE: 31,
  TRACK: 32,
  VIDEO: 33,
  WORKER: 34,
  XML_HTTP_REQUEST: 35,
  XSLT: 36,
  MIN_VALUE: 0,
  MAX_VALUE: 36,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const FetchCacheModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const FetchCacheMode = {
  
  kDefault: 0,
  kNoStore: 1,
  kBypassCache: 2,
  kValidateCache: 3,
  kForceCache: 4,
  kOnlyIfCached: 5,
  kUnspecifiedOnlyIfCachedStrict: 6,
  kUnspecifiedForceCacheMiss: 7,
  MIN_VALUE: 0,
  MAX_VALUE: 7,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const FetchPriorityHintSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const FetchPriorityHint = {
  
  kLow: 0,
  kAuto: 1,
  kHigh: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FetchAPIRequestHeadersSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FetchAPIRequestBodySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FetchAPIRequestSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    FetchAPIRequestHeadersSpec.$,
    'FetchAPIRequestHeaders',
    [
      mojo.internal.StructField(
        'headers', 0,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FetchAPIRequestHeaders {
  constructor() {
    /** @type { !Object<!string, !string> } */
    this.headers;
  }
}



mojo.internal.Struct(
    FetchAPIRequestBodySpec.$,
    'FetchAPIRequestBody',
    [
      mojo.internal.StructField(
        'elements', 0,
        0,
        mojo.internal.Array(network_mojom_DataElementSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'identifier', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'containsSensitiveInfo', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class FetchAPIRequestBody {
  constructor() {
    /** @type { !Array<!network_mojom_DataElement> } */
    this.elements;
    /** @type { !bigint } */
    this.identifier;
    /** @type { !boolean } */
    this.containsSensitiveInfo;
  }
}



mojo.internal.Struct(
    FetchAPIRequestSpec.$,
    'FetchAPIRequest',
    [
      mojo.internal.StructField(
        'mode', 0,
        0,
        network_mojom_RequestModeSpec.$,
        network_mojom_RequestMode.kNoCors,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isMainResourceLoad', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'destination', 8,
        0,
        network_mojom_RequestDestinationSpec.$,
        network_mojom_RequestDestination.kEmpty,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'frameType', 12,
        0,
        blink_mojom_RequestContextFrameTypeSpec.$,
        blink_mojom_RequestContextFrameType.kNone,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'url', 16,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'method', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'headers', 32,
        0,
        FetchAPIRequestHeadersSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'blob', 40,
        0,
        blink_mojom_SerializedBlobSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'body', 48,
        0,
        FetchAPIRequestBodySpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'requestInitiator', 56,
        0,
        url_mojom_OriginSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'navigationRedirectChain', 64,
        0,
        mojo.internal.Array(url_mojom_UrlSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'referrer', 72,
        0,
        blink_mojom_ReferrerSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'credentialsMode', 80,
        0,
        network_mojom_CredentialsModeSpec.$,
        network_mojom_CredentialsMode.kOmit,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cacheMode', 84,
        0,
        FetchCacheModeSpec.$,
        FetchCacheMode.kDefault,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'redirectMode', 88,
        0,
        network_mojom_RedirectModeSpec.$,
        network_mojom_RedirectMode.kFollow,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'integrity', 96,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'priority', 92,
        0,
        network_mojom_RequestPrioritySpec.$,
        network_mojom_RequestPriority.kIdle,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fetchWindowId', 104,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'keepalive', 4,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isReload', 4,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isHistoryNavigation', 4,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'devtoolsStackId', 112,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'trustTokenParams', 120,
        0,
        network_mojom_TrustTokenParamsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'targetAddressSpace', 128,
        0,
        network_mojom_IPAddressSpaceSpec.$,
        network_mojom_IPAddressSpace.kUnknown,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'attributionReportingEligibility', 132,
        0,
        network_mojom_AttributionReportingEligibilitySpec.$,
        network_mojom_AttributionReportingEligibility.kUnset,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'attributionReportingSupport', 136,
        0,
        network_mojom_AttributionSupportSpec.$,
        network_mojom_AttributionSupport.kUnset,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'serviceWorkerRaceNetworkRequestToken', 144,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 160],]);



/**
 * @record
 */
export class FetchAPIRequest {
  constructor() {
    /** @type { !network_mojom_RequestMode } */
    this.mode;
    /** @type { !boolean } */
    this.isMainResourceLoad;
    /** @type { !network_mojom_RequestDestination } */
    this.destination;
    /** @type { !blink_mojom_RequestContextFrameType } */
    this.frameType;
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !string } */
    this.method;
    /** @type { !FetchAPIRequestHeaders } */
    this.headers;
    /** @type { (blink_mojom_SerializedBlob|undefined) } */
    this.blob;
    /** @type { (FetchAPIRequestBody|undefined) } */
    this.body;
    /** @type { (url_mojom_Origin|undefined) } */
    this.requestInitiator;
    /** @type { !Array<!url_mojom_Url> } */
    this.navigationRedirectChain;
    /** @type { (blink_mojom_Referrer|undefined) } */
    this.referrer;
    /** @type { !network_mojom_CredentialsMode } */
    this.credentialsMode;
    /** @type { !FetchCacheMode } */
    this.cacheMode;
    /** @type { !network_mojom_RedirectMode } */
    this.redirectMode;
    /** @type { (string|undefined) } */
    this.integrity;
    /** @type { !network_mojom_RequestPriority } */
    this.priority;
    /** @type { (mojoBase_mojom_UnguessableToken|undefined) } */
    this.fetchWindowId;
    /** @type { !boolean } */
    this.keepalive;
    /** @type { !boolean } */
    this.isReload;
    /** @type { !boolean } */
    this.isHistoryNavigation;
    /** @type { (string|undefined) } */
    this.devtoolsStackId;
    /** @type { (network_mojom_TrustTokenParams|undefined) } */
    this.trustTokenParams;
    /** @type { !network_mojom_IPAddressSpace } */
    this.targetAddressSpace;
    /** @type { !network_mojom_AttributionReportingEligibility } */
    this.attributionReportingEligibility;
    /** @type { !network_mojom_AttributionSupport } */
    this.attributionReportingSupport;
    /** @type { (mojoBase_mojom_UnguessableToken|undefined) } */
    this.serviceWorkerRaceNetworkRequestToken;
  }
}

