// third_party/blink/public/mojom/fetch/fetch_api_request.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FETCH_FETCH_API_REQUEST_MOJOM_SEND_VALIDATION_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FETCH_FETCH_API_REQUEST_MOJOM_SEND_VALIDATION_H_

#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/network/public/mojom/attribution.mojom-shared.h"
#include "services/network/public/mojom/ip_address_space.mojom-shared.h"
#include "services/network/public/mojom/chunked_data_pipe_getter.mojom-shared.h"
#include "services/network/public/mojom/fetch_api.mojom-shared.h"
#include "services/network/public/mojom/request_priority.mojom-shared.h"
#include "services/network/public/mojom/trust_tokens.mojom-shared.h"
#include "services/network/public/mojom/url_request.mojom-shared.h"
#include "third_party/blink/public/mojom/blob/serialized_blob.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/request_context_frame_type.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/referrer.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"

#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::RequestContextType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::FetchCacheMode, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::FetchPriorityHint, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::FetchAPIRequestHeadersDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::FetchAPIRequestHeadersDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::FetchAPIRequestHeaders_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::headers(input)) in_headers = Traits::headers(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->headers)::BaseType>
          headers_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& headers_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>, send_validation>(
        in_headers,
        headers_fragment,
        &headers_validate_params);

      fragment->headers.Set(
          headers_fragment.is_null() ? nullptr : headers_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->headers.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null headers in FetchAPIRequestHeaders struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::FetchAPIRequestBodyDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::FetchAPIRequestBodyDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::FetchAPIRequestBody_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::elements(input)) in_elements = Traits::elements(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->elements)::BaseType>
          elements_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& elements_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::DataElementDataView>, send_validation>(
        in_elements,
        elements_fragment,
        &elements_validate_params);

      fragment->elements.Set(
          elements_fragment.is_null() ? nullptr : elements_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->elements.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null elements in FetchAPIRequestBody struct");

      fragment->identifier = Traits::identifier(input);

      fragment->contains_sensitive_info = Traits::contains_sensitive_info(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::FetchAPIRequestDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::FetchAPIRequestDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::FetchAPIRequest_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::network::mojom::RequestMode>(
        Traits::mode(input),
        &fragment->mode);

      fragment->is_main_resource_load = Traits::is_main_resource_load(input);

      
      mojo::internal::Serialize<::network::mojom::RequestDestination>(
        Traits::destination(input),
        &fragment->destination);

      
      mojo::internal::Serialize<::blink::mojom::RequestContextFrameType>(
        Traits::frame_type(input),
        &fragment->frame_type);

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in FetchAPIRequest struct");

      decltype(Traits::method(input)) in_method = Traits::method(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->method)::BaseType> method_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_method,
        method_fragment);

      fragment->method.Set(
          method_fragment.is_null() ? nullptr : method_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->method.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null method in FetchAPIRequest struct");

      decltype(Traits::headers(input)) in_headers = Traits::headers(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->headers)::BaseType> headers_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::FetchAPIRequestHeadersDataView, send_validation>(
        in_headers,
        headers_fragment);

      fragment->headers.Set(
          headers_fragment.is_null() ? nullptr : headers_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->headers.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null headers in FetchAPIRequest struct");

      decltype(Traits::blob(input)) in_blob = Traits::blob(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->blob)::BaseType> blob_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::SerializedBlobDataView, send_validation>(
        in_blob,
        blob_fragment);

      fragment->blob.Set(
          blob_fragment.is_null() ? nullptr : blob_fragment.data());

      decltype(Traits::body(input)) in_body = Traits::body(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->body)::BaseType> body_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::FetchAPIRequestBodyDataView, send_validation>(
        in_body,
        body_fragment);

      fragment->body.Set(
          body_fragment.is_null() ? nullptr : body_fragment.data());

      decltype(Traits::request_initiator(input)) in_request_initiator = Traits::request_initiator(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->request_initiator)::BaseType> request_initiator_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::OriginDataView, send_validation>(
        in_request_initiator,
        request_initiator_fragment);

      fragment->request_initiator.Set(
          request_initiator_fragment.is_null() ? nullptr : request_initiator_fragment.data());

      decltype(Traits::navigation_redirect_chain(input)) in_navigation_redirect_chain = Traits::navigation_redirect_chain(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->navigation_redirect_chain)::BaseType>
          navigation_redirect_chain_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& navigation_redirect_chain_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>, send_validation>(
        in_navigation_redirect_chain,
        navigation_redirect_chain_fragment,
        &navigation_redirect_chain_validate_params);

      fragment->navigation_redirect_chain.Set(
          navigation_redirect_chain_fragment.is_null() ? nullptr : navigation_redirect_chain_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->navigation_redirect_chain.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null navigation_redirect_chain in FetchAPIRequest struct");

      decltype(Traits::referrer(input)) in_referrer = Traits::referrer(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->referrer)::BaseType> referrer_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::ReferrerDataView, send_validation>(
        in_referrer,
        referrer_fragment);

      fragment->referrer.Set(
          referrer_fragment.is_null() ? nullptr : referrer_fragment.data());

      
      mojo::internal::Serialize<::network::mojom::CredentialsMode>(
        Traits::credentials_mode(input),
        &fragment->credentials_mode);

      
      mojo::internal::Serialize<::blink::mojom::FetchCacheMode>(
        Traits::cache_mode(input),
        &fragment->cache_mode);

      
      mojo::internal::Serialize<::network::mojom::RedirectMode>(
        Traits::redirect_mode(input),
        &fragment->redirect_mode);

      decltype(Traits::integrity(input)) in_integrity = Traits::integrity(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->integrity)::BaseType> integrity_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_integrity,
        integrity_fragment);

      fragment->integrity.Set(
          integrity_fragment.is_null() ? nullptr : integrity_fragment.data());

      
      mojo::internal::Serialize<::network::mojom::RequestPriority>(
        Traits::priority(input),
        &fragment->priority);

      decltype(Traits::fetch_window_id(input)) in_fetch_window_id = Traits::fetch_window_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->fetch_window_id)::BaseType> fetch_window_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView, send_validation>(
        in_fetch_window_id,
        fetch_window_id_fragment);

      fragment->fetch_window_id.Set(
          fetch_window_id_fragment.is_null() ? nullptr : fetch_window_id_fragment.data());

      fragment->keepalive = Traits::keepalive(input);

      fragment->is_reload = Traits::is_reload(input);

      fragment->is_history_navigation = Traits::is_history_navigation(input);

      decltype(Traits::devtools_stack_id(input)) in_devtools_stack_id = Traits::devtools_stack_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->devtools_stack_id)::BaseType> devtools_stack_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_devtools_stack_id,
        devtools_stack_id_fragment);

      fragment->devtools_stack_id.Set(
          devtools_stack_id_fragment.is_null() ? nullptr : devtools_stack_id_fragment.data());

      decltype(Traits::trust_token_params(input)) in_trust_token_params = Traits::trust_token_params(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->trust_token_params)::BaseType> trust_token_params_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::TrustTokenParamsDataView, send_validation>(
        in_trust_token_params,
        trust_token_params_fragment);

      fragment->trust_token_params.Set(
          trust_token_params_fragment.is_null() ? nullptr : trust_token_params_fragment.data());

      
      mojo::internal::Serialize<::network::mojom::IPAddressSpace>(
        Traits::target_address_space(input),
        &fragment->target_address_space);

      
      mojo::internal::Serialize<::network::mojom::AttributionReportingEligibility>(
        Traits::attribution_reporting_eligibility(input),
        &fragment->attribution_reporting_eligibility);

      
      mojo::internal::Serialize<::network::mojom::AttributionSupport>(
        Traits::attribution_reporting_support(input),
        &fragment->attribution_reporting_support);

      decltype(Traits::service_worker_race_network_request_token(input)) in_service_worker_race_network_request_token = Traits::service_worker_race_network_request_token(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->service_worker_race_network_request_token)::BaseType> service_worker_race_network_request_token_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView, send_validation>(
        in_service_worker_race_network_request_token,
        service_worker_race_network_request_token_fragment);

      fragment->service_worker_race_network_request_token.Set(
          service_worker_race_network_request_token_fragment.is_null() ? nullptr : service_worker_race_network_request_token_fragment.data());
  }
};

}  // namespace mojo::internal

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FETCH_FETCH_API_REQUEST_MOJOM_SEND_VALIDATION_H_