// third_party/blink/public/mojom/fenced_frame/fenced_frame_config.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FENCED_FRAME_FENCED_FRAME_CONFIG_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FENCED_FRAME_FENCED_FRAME_CONFIG_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/fenced_frame/fenced_frame_config.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/fenced_frame/fenced_frame_config.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/fenced_frame/fenced_frame_config.mojom-forward.h"  // IWYU pragma: export
#include "services/network/public/mojom/schemeful_site.mojom.h"
#include "services/network/public/mojom/permissions_policy/permissions_policy.mojom.h"
#include "services/network/public/mojom/permissions_policy/permissions_policy_feature.mojom-forward.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "url/mojom/url.mojom.h"
#include "url/mojom/origin.mojom.h"
#include <string>
#include <vector>




#include "third_party/blink/public/common/fenced_frame/redacted_fenced_frame_config_mojom_traits.h"
#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {











class BLINK_COMMON_EXPORT PotentiallyOpaqueURL {
 public:
  using DataView = PotentiallyOpaqueURLDataView;
  using Data_ = internal::PotentiallyOpaqueURL_Data;
  using Tag = Data_::PotentiallyOpaqueURL_Tag;

  template <typename... Args>
  static PotentiallyOpaqueURLPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |transparent|.
  static PotentiallyOpaqueURLPtr NewTransparent(
      const ::GURL& value);
  // Construct an instance holding |opaque|.
  static PotentiallyOpaqueURLPtr NewOpaque(
      ::blink::FencedFrame::Opaque value);

  template <typename U>
  static PotentiallyOpaqueURLPtr From(const U& u) {
    return mojo::TypeConverter<PotentiallyOpaqueURLPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PotentiallyOpaqueURL>::Convert(*this);
  }
  ~PotentiallyOpaqueURL();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  PotentiallyOpaqueURL(const PotentiallyOpaqueURL& other) = delete;
  PotentiallyOpaqueURL& operator=(const PotentiallyOpaqueURL& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = PotentiallyOpaqueURLPtr>
  PotentiallyOpaqueURLPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, PotentiallyOpaqueURL>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, PotentiallyOpaqueURL>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_transparent() const { return tag_ == Tag::kTransparent; }
  const ::GURL& get_transparent() const {
    CHECK(tag_ == Tag::kTransparent);
    return data_.transparent;
  }
  ::GURL& get_transparent() {
    CHECK(tag_ == Tag::kTransparent);
    return data_.transparent;
  }
  void set_transparent(const ::GURL& transparent);

  bool is_opaque() const { return tag_ == Tag::kOpaque; }
  ::blink::FencedFrame::Opaque get_opaque() const {
    CHECK(tag_ == Tag::kOpaque);
    return data_.opaque;
  }
  void set_opaque(::blink::FencedFrame::Opaque opaque);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PotentiallyOpaqueURL::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<PotentiallyOpaqueURL::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kTransparent)>,
        const ::GURL& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kOpaque)>,
        ::blink::FencedFrame::Opaque value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::GURL transparent;
    ::blink::FencedFrame::Opaque opaque;
  };

  PotentiallyOpaqueURL(
      std::in_place_index_t<static_cast<size_t>(Tag::kTransparent)>,
      const ::GURL& value);
  PotentiallyOpaqueURL(
      std::in_place_index_t<static_cast<size_t>(Tag::kOpaque)>,
      ::blink::FencedFrame::Opaque value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class BLINK_COMMON_EXPORT PotentiallyOpaqueSize {
 public:
  using DataView = PotentiallyOpaqueSizeDataView;
  using Data_ = internal::PotentiallyOpaqueSize_Data;
  using Tag = Data_::PotentiallyOpaqueSize_Tag;

  template <typename... Args>
  static PotentiallyOpaqueSizePtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |transparent|.
  static PotentiallyOpaqueSizePtr NewTransparent(
      const ::gfx::Size& value);
  // Construct an instance holding |opaque|.
  static PotentiallyOpaqueSizePtr NewOpaque(
      ::blink::FencedFrame::Opaque value);

  template <typename U>
  static PotentiallyOpaqueSizePtr From(const U& u) {
    return mojo::TypeConverter<PotentiallyOpaqueSizePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PotentiallyOpaqueSize>::Convert(*this);
  }
  ~PotentiallyOpaqueSize();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  PotentiallyOpaqueSize(const PotentiallyOpaqueSize& other) = delete;
  PotentiallyOpaqueSize& operator=(const PotentiallyOpaqueSize& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = PotentiallyOpaqueSizePtr>
  PotentiallyOpaqueSizePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, PotentiallyOpaqueSize>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, PotentiallyOpaqueSize>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_transparent() const { return tag_ == Tag::kTransparent; }
  const ::gfx::Size& get_transparent() const {
    CHECK(tag_ == Tag::kTransparent);
    return data_.transparent;
  }
  ::gfx::Size& get_transparent() {
    CHECK(tag_ == Tag::kTransparent);
    return data_.transparent;
  }
  void set_transparent(const ::gfx::Size& transparent);

  bool is_opaque() const { return tag_ == Tag::kOpaque; }
  ::blink::FencedFrame::Opaque get_opaque() const {
    CHECK(tag_ == Tag::kOpaque);
    return data_.opaque;
  }
  void set_opaque(::blink::FencedFrame::Opaque opaque);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PotentiallyOpaqueSize::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<PotentiallyOpaqueSize::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kTransparent)>,
        const ::gfx::Size& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kOpaque)>,
        ::blink::FencedFrame::Opaque value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::gfx::Size transparent;
    ::blink::FencedFrame::Opaque opaque;
  };

  PotentiallyOpaqueSize(
      std::in_place_index_t<static_cast<size_t>(Tag::kTransparent)>,
      const ::gfx::Size& value);
  PotentiallyOpaqueSize(
      std::in_place_index_t<static_cast<size_t>(Tag::kOpaque)>,
      ::blink::FencedFrame::Opaque value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class BLINK_COMMON_EXPORT PotentiallyOpaqueBool {
 public:
  using DataView = PotentiallyOpaqueBoolDataView;
  using Data_ = internal::PotentiallyOpaqueBool_Data;
  using Tag = Data_::PotentiallyOpaqueBool_Tag;

  template <typename... Args>
  static PotentiallyOpaqueBoolPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |transparent|.
  static PotentiallyOpaqueBoolPtr NewTransparent(
      bool value);
  // Construct an instance holding |opaque|.
  static PotentiallyOpaqueBoolPtr NewOpaque(
      ::blink::FencedFrame::Opaque value);

  template <typename U>
  static PotentiallyOpaqueBoolPtr From(const U& u) {
    return mojo::TypeConverter<PotentiallyOpaqueBoolPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PotentiallyOpaqueBool>::Convert(*this);
  }
  ~PotentiallyOpaqueBool();


  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = PotentiallyOpaqueBoolPtr>
  PotentiallyOpaqueBoolPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, PotentiallyOpaqueBool>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, PotentiallyOpaqueBool>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_transparent() const { return tag_ == Tag::kTransparent; }
  bool get_transparent() const {
    CHECK(tag_ == Tag::kTransparent);
    return data_.transparent;
  }
  void set_transparent(bool transparent);

  bool is_opaque() const { return tag_ == Tag::kOpaque; }
  ::blink::FencedFrame::Opaque get_opaque() const {
    CHECK(tag_ == Tag::kOpaque);
    return data_.opaque;
  }
  void set_opaque(::blink::FencedFrame::Opaque opaque);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PotentiallyOpaqueBool::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<PotentiallyOpaqueBool::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kTransparent)>,
        bool value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kOpaque)>,
        ::blink::FencedFrame::Opaque value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    bool transparent;
    ::blink::FencedFrame::Opaque opaque;
  };

  PotentiallyOpaqueBool(
      std::in_place_index_t<static_cast<size_t>(Tag::kTransparent)>,
      bool value);
  PotentiallyOpaqueBool(
      std::in_place_index_t<static_cast<size_t>(Tag::kOpaque)>,
      ::blink::FencedFrame::Opaque value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class BLINK_COMMON_EXPORT PotentiallyOpaqueAdAuctionData {
 public:
  using DataView = PotentiallyOpaqueAdAuctionDataDataView;
  using Data_ = internal::PotentiallyOpaqueAdAuctionData_Data;
  using Tag = Data_::PotentiallyOpaqueAdAuctionData_Tag;

  template <typename... Args>
  static PotentiallyOpaqueAdAuctionDataPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |transparent|.
  static PotentiallyOpaqueAdAuctionDataPtr NewTransparent(
      const ::blink::FencedFrame::AdAuctionData& value);
  // Construct an instance holding |opaque|.
  static PotentiallyOpaqueAdAuctionDataPtr NewOpaque(
      ::blink::FencedFrame::Opaque value);

  template <typename U>
  static PotentiallyOpaqueAdAuctionDataPtr From(const U& u) {
    return mojo::TypeConverter<PotentiallyOpaqueAdAuctionDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PotentiallyOpaqueAdAuctionData>::Convert(*this);
  }
  ~PotentiallyOpaqueAdAuctionData();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  PotentiallyOpaqueAdAuctionData(const PotentiallyOpaqueAdAuctionData& other) = delete;
  PotentiallyOpaqueAdAuctionData& operator=(const PotentiallyOpaqueAdAuctionData& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = PotentiallyOpaqueAdAuctionDataPtr>
  PotentiallyOpaqueAdAuctionDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, PotentiallyOpaqueAdAuctionData>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, PotentiallyOpaqueAdAuctionData>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_transparent() const { return tag_ == Tag::kTransparent; }
  const ::blink::FencedFrame::AdAuctionData& get_transparent() const {
    CHECK(tag_ == Tag::kTransparent);
    return data_.transparent;
  }
  ::blink::FencedFrame::AdAuctionData& get_transparent() {
    CHECK(tag_ == Tag::kTransparent);
    return data_.transparent;
  }
  void set_transparent(const ::blink::FencedFrame::AdAuctionData& transparent);

  bool is_opaque() const { return tag_ == Tag::kOpaque; }
  ::blink::FencedFrame::Opaque get_opaque() const {
    CHECK(tag_ == Tag::kOpaque);
    return data_.opaque;
  }
  void set_opaque(::blink::FencedFrame::Opaque opaque);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PotentiallyOpaqueAdAuctionData::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<PotentiallyOpaqueAdAuctionData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kTransparent)>,
        const ::blink::FencedFrame::AdAuctionData& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kOpaque)>,
        ::blink::FencedFrame::Opaque value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::blink::FencedFrame::AdAuctionData transparent;
    ::blink::FencedFrame::Opaque opaque;
  };

  PotentiallyOpaqueAdAuctionData(
      std::in_place_index_t<static_cast<size_t>(Tag::kTransparent)>,
      const ::blink::FencedFrame::AdAuctionData& value);
  PotentiallyOpaqueAdAuctionData(
      std::in_place_index_t<static_cast<size_t>(Tag::kOpaque)>,
      ::blink::FencedFrame::Opaque value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class BLINK_COMMON_EXPORT PotentiallyOpaqueConfigVector {
 public:
  using DataView = PotentiallyOpaqueConfigVectorDataView;
  using Data_ = internal::PotentiallyOpaqueConfigVector_Data;
  using Tag = Data_::PotentiallyOpaqueConfigVector_Tag;

  template <typename... Args>
  static PotentiallyOpaqueConfigVectorPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |transparent|.
  static PotentiallyOpaqueConfigVectorPtr NewTransparent(
      std::vector<::blink::FencedFrame::RedactedFencedFrameConfig> value);
  // Construct an instance holding |opaque|.
  static PotentiallyOpaqueConfigVectorPtr NewOpaque(
      ::blink::FencedFrame::Opaque value);

  template <typename U>
  static PotentiallyOpaqueConfigVectorPtr From(const U& u) {
    return mojo::TypeConverter<PotentiallyOpaqueConfigVectorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PotentiallyOpaqueConfigVector>::Convert(*this);
  }
  ~PotentiallyOpaqueConfigVector();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  PotentiallyOpaqueConfigVector(const PotentiallyOpaqueConfigVector& other) = delete;
  PotentiallyOpaqueConfigVector& operator=(const PotentiallyOpaqueConfigVector& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = PotentiallyOpaqueConfigVectorPtr>
  PotentiallyOpaqueConfigVectorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, PotentiallyOpaqueConfigVector>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, PotentiallyOpaqueConfigVector>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_transparent() const { return tag_ == Tag::kTransparent; }
  const std::vector<::blink::FencedFrame::RedactedFencedFrameConfig>& get_transparent() const {
    CHECK(tag_ == Tag::kTransparent);
    return data_.transparent;
  }
  std::vector<::blink::FencedFrame::RedactedFencedFrameConfig>& get_transparent() {
    CHECK(tag_ == Tag::kTransparent);
    return data_.transparent;
  }
  void set_transparent(std::vector<::blink::FencedFrame::RedactedFencedFrameConfig> transparent);

  bool is_opaque() const { return tag_ == Tag::kOpaque; }
  ::blink::FencedFrame::Opaque get_opaque() const {
    CHECK(tag_ == Tag::kOpaque);
    return data_.opaque;
  }
  void set_opaque(::blink::FencedFrame::Opaque opaque);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PotentiallyOpaqueConfigVector::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<PotentiallyOpaqueConfigVector::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kTransparent)>,
        std::vector<::blink::FencedFrame::RedactedFencedFrameConfig> value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kOpaque)>,
        ::blink::FencedFrame::Opaque value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    std::vector<::blink::FencedFrame::RedactedFencedFrameConfig> transparent;
    ::blink::FencedFrame::Opaque opaque;
  };

  PotentiallyOpaqueConfigVector(
      std::in_place_index_t<static_cast<size_t>(Tag::kTransparent)>,
      std::vector<::blink::FencedFrame::RedactedFencedFrameConfig> value);
  PotentiallyOpaqueConfigVector(
      std::in_place_index_t<static_cast<size_t>(Tag::kOpaque)>,
      ::blink::FencedFrame::Opaque value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class BLINK_COMMON_EXPORT PotentiallyOpaqueURNConfigVector {
 public:
  using DataView = PotentiallyOpaqueURNConfigVectorDataView;
  using Data_ = internal::PotentiallyOpaqueURNConfigVector_Data;
  using Tag = Data_::PotentiallyOpaqueURNConfigVector_Tag;

  template <typename... Args>
  static PotentiallyOpaqueURNConfigVectorPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |transparent|.
  static PotentiallyOpaqueURNConfigVectorPtr NewTransparent(
      std::vector<URNConfigPairPtr> value);
  // Construct an instance holding |opaque|.
  static PotentiallyOpaqueURNConfigVectorPtr NewOpaque(
      ::blink::FencedFrame::Opaque value);

  template <typename U>
  static PotentiallyOpaqueURNConfigVectorPtr From(const U& u) {
    return mojo::TypeConverter<PotentiallyOpaqueURNConfigVectorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PotentiallyOpaqueURNConfigVector>::Convert(*this);
  }
  ~PotentiallyOpaqueURNConfigVector();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  PotentiallyOpaqueURNConfigVector(const PotentiallyOpaqueURNConfigVector& other) = delete;
  PotentiallyOpaqueURNConfigVector& operator=(const PotentiallyOpaqueURNConfigVector& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = PotentiallyOpaqueURNConfigVectorPtr>
  PotentiallyOpaqueURNConfigVectorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, PotentiallyOpaqueURNConfigVector>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, PotentiallyOpaqueURNConfigVector>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_transparent() const { return tag_ == Tag::kTransparent; }
  const std::vector<URNConfigPairPtr>& get_transparent() const {
    CHECK(tag_ == Tag::kTransparent);
    return data_.transparent;
  }
  std::vector<URNConfigPairPtr>& get_transparent() {
    CHECK(tag_ == Tag::kTransparent);
    return data_.transparent;
  }
  void set_transparent(std::vector<URNConfigPairPtr> transparent);

  bool is_opaque() const { return tag_ == Tag::kOpaque; }
  ::blink::FencedFrame::Opaque get_opaque() const {
    CHECK(tag_ == Tag::kOpaque);
    return data_.opaque;
  }
  void set_opaque(::blink::FencedFrame::Opaque opaque);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PotentiallyOpaqueURNConfigVector::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<PotentiallyOpaqueURNConfigVector::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kTransparent)>,
        std::vector<URNConfigPairPtr> value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kOpaque)>,
        ::blink::FencedFrame::Opaque value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    std::vector<URNConfigPairPtr> transparent;
    ::blink::FencedFrame::Opaque opaque;
  };

  PotentiallyOpaqueURNConfigVector(
      std::in_place_index_t<static_cast<size_t>(Tag::kTransparent)>,
      std::vector<URNConfigPairPtr> value);
  PotentiallyOpaqueURNConfigVector(
      std::in_place_index_t<static_cast<size_t>(Tag::kOpaque)>,
      ::blink::FencedFrame::Opaque value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class BLINK_COMMON_EXPORT PotentiallyOpaqueSharedStorageBudgetMetadata {
 public:
  using DataView = PotentiallyOpaqueSharedStorageBudgetMetadataDataView;
  using Data_ = internal::PotentiallyOpaqueSharedStorageBudgetMetadata_Data;
  using Tag = Data_::PotentiallyOpaqueSharedStorageBudgetMetadata_Tag;

  template <typename... Args>
  static PotentiallyOpaqueSharedStorageBudgetMetadataPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |transparent|.
  static PotentiallyOpaqueSharedStorageBudgetMetadataPtr NewTransparent(
      const ::blink::FencedFrame::SharedStorageBudgetMetadata& value);
  // Construct an instance holding |opaque|.
  static PotentiallyOpaqueSharedStorageBudgetMetadataPtr NewOpaque(
      ::blink::FencedFrame::Opaque value);

  template <typename U>
  static PotentiallyOpaqueSharedStorageBudgetMetadataPtr From(const U& u) {
    return mojo::TypeConverter<PotentiallyOpaqueSharedStorageBudgetMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PotentiallyOpaqueSharedStorageBudgetMetadata>::Convert(*this);
  }
  ~PotentiallyOpaqueSharedStorageBudgetMetadata();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  PotentiallyOpaqueSharedStorageBudgetMetadata(const PotentiallyOpaqueSharedStorageBudgetMetadata& other) = delete;
  PotentiallyOpaqueSharedStorageBudgetMetadata& operator=(const PotentiallyOpaqueSharedStorageBudgetMetadata& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = PotentiallyOpaqueSharedStorageBudgetMetadataPtr>
  PotentiallyOpaqueSharedStorageBudgetMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, PotentiallyOpaqueSharedStorageBudgetMetadata>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, PotentiallyOpaqueSharedStorageBudgetMetadata>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_transparent() const { return tag_ == Tag::kTransparent; }
  const ::blink::FencedFrame::SharedStorageBudgetMetadata& get_transparent() const {
    CHECK(tag_ == Tag::kTransparent);
    return data_.transparent;
  }
  ::blink::FencedFrame::SharedStorageBudgetMetadata& get_transparent() {
    CHECK(tag_ == Tag::kTransparent);
    return data_.transparent;
  }
  void set_transparent(const ::blink::FencedFrame::SharedStorageBudgetMetadata& transparent);

  bool is_opaque() const { return tag_ == Tag::kOpaque; }
  ::blink::FencedFrame::Opaque get_opaque() const {
    CHECK(tag_ == Tag::kOpaque);
    return data_.opaque;
  }
  void set_opaque(::blink::FencedFrame::Opaque opaque);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PotentiallyOpaqueSharedStorageBudgetMetadata::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<PotentiallyOpaqueSharedStorageBudgetMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kTransparent)>,
        const ::blink::FencedFrame::SharedStorageBudgetMetadata& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kOpaque)>,
        ::blink::FencedFrame::Opaque value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::blink::FencedFrame::SharedStorageBudgetMetadata transparent;
    ::blink::FencedFrame::Opaque opaque;
  };

  PotentiallyOpaqueSharedStorageBudgetMetadata(
      std::in_place_index_t<static_cast<size_t>(Tag::kTransparent)>,
      const ::blink::FencedFrame::SharedStorageBudgetMetadata& value);
  PotentiallyOpaqueSharedStorageBudgetMetadata(
      std::in_place_index_t<static_cast<size_t>(Tag::kOpaque)>,
      ::blink::FencedFrame::Opaque value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class BLINK_COMMON_EXPORT AdAuctionData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AdAuctionData, T>::value>;
  using DataView = AdAuctionDataDataView;
  using Data_ = internal::AdAuctionData_Data;

  template <typename... Args>
  static AdAuctionDataPtr New(Args&&... args) {
    return AdAuctionDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AdAuctionDataPtr From(const U& u) {
    return mojo::TypeConverter<AdAuctionDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AdAuctionData>::Convert(*this);
  }


  AdAuctionData();

  AdAuctionData(
      const ::url::Origin& interest_group_owner,
      const std::string& interest_group_name);


  ~AdAuctionData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AdAuctionDataPtr>
  AdAuctionDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AdAuctionData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AdAuctionData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AdAuctionData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AdAuctionData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AdAuctionData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AdAuctionData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AdAuctionData_UnserializedMessageContext<
            UserType, AdAuctionData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AdAuctionData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AdAuctionData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AdAuctionData_UnserializedMessageContext<
            UserType, AdAuctionData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AdAuctionData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::url::Origin interest_group_owner;
  
  std::string interest_group_name;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AdAuctionData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AdAuctionData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AdAuctionData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AdAuctionData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT URNConfigPair {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<URNConfigPair, T>::value>;
  using DataView = URNConfigPairDataView;
  using Data_ = internal::URNConfigPair_Data;

  template <typename... Args>
  static URNConfigPairPtr New(Args&&... args) {
    return URNConfigPairPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static URNConfigPairPtr From(const U& u) {
    return mojo::TypeConverter<URNConfigPairPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, URNConfigPair>::Convert(*this);
  }


  URNConfigPair();

  URNConfigPair(
      const ::GURL& urn,
      const ::blink::FencedFrame::RedactedFencedFrameConfig& config);


  ~URNConfigPair();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = URNConfigPairPtr>
  URNConfigPairPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, URNConfigPair::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, URNConfigPair::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, URNConfigPair::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        URNConfigPair::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        URNConfigPair::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        URNConfigPair::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::URNConfigPair_UnserializedMessageContext<
            UserType, URNConfigPair::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<URNConfigPair::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return URNConfigPair::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::URNConfigPair_UnserializedMessageContext<
            UserType, URNConfigPair::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<URNConfigPair::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL urn;
  
  ::blink::FencedFrame::RedactedFencedFrameConfig config;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, URNConfigPair::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, URNConfigPair::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, URNConfigPair::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, URNConfigPair::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT SharedStorageBudgetMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SharedStorageBudgetMetadata, T>::value>;
  using DataView = SharedStorageBudgetMetadataDataView;
  using Data_ = internal::SharedStorageBudgetMetadata_Data;

  template <typename... Args>
  static SharedStorageBudgetMetadataPtr New(Args&&... args) {
    return SharedStorageBudgetMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SharedStorageBudgetMetadataPtr From(const U& u) {
    return mojo::TypeConverter<SharedStorageBudgetMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SharedStorageBudgetMetadata>::Convert(*this);
  }


  SharedStorageBudgetMetadata();

  SharedStorageBudgetMetadata(
      const ::net::SchemefulSite& site,
      double budget_to_charge,
      bool top_navigated);


  ~SharedStorageBudgetMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SharedStorageBudgetMetadataPtr>
  SharedStorageBudgetMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SharedStorageBudgetMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SharedStorageBudgetMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SharedStorageBudgetMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedStorageBudgetMetadata::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedStorageBudgetMetadata::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SharedStorageBudgetMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SharedStorageBudgetMetadata_UnserializedMessageContext<
            UserType, SharedStorageBudgetMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SharedStorageBudgetMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SharedStorageBudgetMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SharedStorageBudgetMetadata_UnserializedMessageContext<
            UserType, SharedStorageBudgetMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SharedStorageBudgetMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::net::SchemefulSite site;
  
  double budget_to_charge;
  
  bool top_navigated;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SharedStorageBudgetMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SharedStorageBudgetMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SharedStorageBudgetMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SharedStorageBudgetMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT ParentPermissionsInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ParentPermissionsInfo, T>::value>;
  using DataView = ParentPermissionsInfoDataView;
  using Data_ = internal::ParentPermissionsInfo_Data;

  template <typename... Args>
  static ParentPermissionsInfoPtr New(Args&&... args) {
    return ParentPermissionsInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ParentPermissionsInfoPtr From(const U& u) {
    return mojo::TypeConverter<ParentPermissionsInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ParentPermissionsInfo>::Convert(*this);
  }


  ParentPermissionsInfo();

  ParentPermissionsInfo(
      std::vector<::network::ParsedPermissionsPolicyDeclaration> parsed_permissions_policy,
      const ::url::Origin& origin);


  ~ParentPermissionsInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ParentPermissionsInfoPtr>
  ParentPermissionsInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ParentPermissionsInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ParentPermissionsInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ParentPermissionsInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ParentPermissionsInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ParentPermissionsInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ParentPermissionsInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ParentPermissionsInfo_UnserializedMessageContext<
            UserType, ParentPermissionsInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ParentPermissionsInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ParentPermissionsInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ParentPermissionsInfo_UnserializedMessageContext<
            UserType, ParentPermissionsInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ParentPermissionsInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<::network::ParsedPermissionsPolicyDeclaration> parsed_permissions_policy;
  
  ::url::Origin origin;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ParentPermissionsInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ParentPermissionsInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ParentPermissionsInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ParentPermissionsInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT FencedFrameConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FencedFrameConfig, T>::value>;
  using DataView = FencedFrameConfigDataView;
  using Data_ = internal::FencedFrameConfig_Data;

  template <typename... Args>
  static FencedFrameConfigPtr New(Args&&... args) {
    return FencedFrameConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FencedFrameConfigPtr From(const U& u) {
    return mojo::TypeConverter<FencedFrameConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FencedFrameConfig>::Convert(*this);
  }


  FencedFrameConfig();

  FencedFrameConfig(
      const std::optional<::blink::FencedFrame::RedactedFencedFrameProperty<GURL>>& mapped_url,
      const std::optional<::blink::FencedFrame::RedactedFencedFrameProperty<::gfx::Size>>& container_size,
      const std::optional<::blink::FencedFrame::RedactedFencedFrameProperty<::gfx::Size>>& content_size,
      const std::optional<::blink::FencedFrame::RedactedFencedFrameProperty<bool>>& deprecated_should_freeze_initial_size,
      const std::optional<::blink::FencedFrame::RedactedFencedFrameProperty<::blink::FencedFrame::AdAuctionData>>& ad_auction_data,
      const std::optional<::blink::FencedFrame::RedactedFencedFrameProperty<std::vector<::blink::FencedFrame::RedactedFencedFrameConfig>>>& nested_configs,
      const std::optional<::blink::FencedFrame::RedactedFencedFrameProperty<::blink::FencedFrame::SharedStorageBudgetMetadata>>& shared_storage_budget_metadata,
      const ::GURL& urn_uuid,
      ::blink::FencedFrame::DeprecatedFencedFrameMode mode,
      std::vector<::network::mojom::PermissionsPolicyFeature> effective_enabled_permissions,
      ParentPermissionsInfoPtr parent_permissions_info);

FencedFrameConfig(const FencedFrameConfig&) = delete;
FencedFrameConfig& operator=(const FencedFrameConfig&) = delete;

  ~FencedFrameConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FencedFrameConfigPtr>
  FencedFrameConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FencedFrameConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FencedFrameConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FencedFrameConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FencedFrameConfig::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FencedFrameConfig::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FencedFrameConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FencedFrameConfig_UnserializedMessageContext<
            UserType, FencedFrameConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FencedFrameConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FencedFrameConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FencedFrameConfig_UnserializedMessageContext<
            UserType, FencedFrameConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FencedFrameConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::blink::FencedFrame::RedactedFencedFrameProperty<GURL>> mapped_url;
  
  std::optional<::blink::FencedFrame::RedactedFencedFrameProperty<::gfx::Size>> container_size;
  
  std::optional<::blink::FencedFrame::RedactedFencedFrameProperty<::gfx::Size>> content_size;
  
  std::optional<::blink::FencedFrame::RedactedFencedFrameProperty<bool>> deprecated_should_freeze_initial_size;
  
  std::optional<::blink::FencedFrame::RedactedFencedFrameProperty<::blink::FencedFrame::AdAuctionData>> ad_auction_data;
  
  std::optional<::blink::FencedFrame::RedactedFencedFrameProperty<std::vector<::blink::FencedFrame::RedactedFencedFrameConfig>>> nested_configs;
  
  std::optional<::blink::FencedFrame::RedactedFencedFrameProperty<::blink::FencedFrame::SharedStorageBudgetMetadata>> shared_storage_budget_metadata;
  
  ::GURL urn_uuid;
  
  ::blink::FencedFrame::DeprecatedFencedFrameMode mode;
  
  std::vector<::network::mojom::PermissionsPolicyFeature> effective_enabled_permissions;
  
  ParentPermissionsInfoPtr parent_permissions_info;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FencedFrameConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FencedFrameConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FencedFrameConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FencedFrameConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT FencedFrameProperties {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FencedFrameProperties, T>::value>;
  using DataView = FencedFramePropertiesDataView;
  using Data_ = internal::FencedFrameProperties_Data;

  template <typename... Args>
  static FencedFramePropertiesPtr New(Args&&... args) {
    return FencedFramePropertiesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FencedFramePropertiesPtr From(const U& u) {
    return mojo::TypeConverter<FencedFramePropertiesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FencedFrameProperties>::Convert(*this);
  }


  FencedFrameProperties();

  FencedFrameProperties(
      const std::optional<::blink::FencedFrame::RedactedFencedFrameProperty<GURL>>& mapped_url,
      const std::optional<::blink::FencedFrame::RedactedFencedFrameProperty<::gfx::Size>>& container_size,
      const std::optional<::blink::FencedFrame::RedactedFencedFrameProperty<::gfx::Size>>& content_size,
      const std::optional<::blink::FencedFrame::RedactedFencedFrameProperty<bool>>& deprecated_should_freeze_initial_size,
      const std::optional<::blink::FencedFrame::RedactedFencedFrameProperty<::blink::FencedFrame::AdAuctionData>>& ad_auction_data,
      PotentiallyOpaqueURNConfigVectorPtr nested_urn_config_pairs,
      const std::optional<::blink::FencedFrame::RedactedFencedFrameProperty<::blink::FencedFrame::SharedStorageBudgetMetadata>>& shared_storage_budget_metadata,
      ::blink::FencedFrame::DeprecatedFencedFrameMode mode,
      std::vector<::network::mojom::PermissionsPolicyFeature> effective_enabled_permissions,
      ParentPermissionsInfoPtr parent_permissions_info,
      bool can_disable_untrusted_network,
      bool is_cross_origin_content,
      bool allow_cross_origin_event_reporting);

FencedFrameProperties(const FencedFrameProperties&) = delete;
FencedFrameProperties& operator=(const FencedFrameProperties&) = delete;

  ~FencedFrameProperties();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FencedFramePropertiesPtr>
  FencedFramePropertiesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FencedFrameProperties::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FencedFrameProperties::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FencedFrameProperties::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FencedFrameProperties::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FencedFrameProperties::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FencedFrameProperties::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FencedFrameProperties_UnserializedMessageContext<
            UserType, FencedFrameProperties::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FencedFrameProperties::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FencedFrameProperties::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FencedFrameProperties_UnserializedMessageContext<
            UserType, FencedFrameProperties::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FencedFrameProperties::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::blink::FencedFrame::RedactedFencedFrameProperty<GURL>> mapped_url;
  
  std::optional<::blink::FencedFrame::RedactedFencedFrameProperty<::gfx::Size>> container_size;
  
  std::optional<::blink::FencedFrame::RedactedFencedFrameProperty<::gfx::Size>> content_size;
  
  std::optional<::blink::FencedFrame::RedactedFencedFrameProperty<bool>> deprecated_should_freeze_initial_size;
  
  std::optional<::blink::FencedFrame::RedactedFencedFrameProperty<::blink::FencedFrame::AdAuctionData>> ad_auction_data;
  
  PotentiallyOpaqueURNConfigVectorPtr nested_urn_config_pairs;
  
  std::optional<::blink::FencedFrame::RedactedFencedFrameProperty<::blink::FencedFrame::SharedStorageBudgetMetadata>> shared_storage_budget_metadata;
  
  ::blink::FencedFrame::DeprecatedFencedFrameMode mode;
  
  std::vector<::network::mojom::PermissionsPolicyFeature> effective_enabled_permissions;
  
  ParentPermissionsInfoPtr parent_permissions_info;
  
  bool can_disable_untrusted_network;
  
  bool is_cross_origin_content;
  
  bool allow_cross_origin_event_reporting;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FencedFrameProperties::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FencedFrameProperties::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FencedFrameProperties::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FencedFrameProperties::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
PotentiallyOpaqueURLPtr PotentiallyOpaqueURL::Clone() const {
  switch (tag_) {
    case Tag::kTransparent:
      return NewTransparent(
          mojo::Clone(data_.transparent));
    case Tag::kOpaque:
      return NewOpaque(
          mojo::Clone(data_.opaque));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, PotentiallyOpaqueURL>::value>::type*>
bool PotentiallyOpaqueURL::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kTransparent:
      return mojo::Equals(data_.transparent, other.data_.transparent);
    case Tag::kOpaque:
      return mojo::Equals(data_.opaque, other.data_.opaque);
  }

  return false;
}
template <typename UnionPtrType>
PotentiallyOpaqueSizePtr PotentiallyOpaqueSize::Clone() const {
  switch (tag_) {
    case Tag::kTransparent:
      return NewTransparent(
          mojo::Clone(data_.transparent));
    case Tag::kOpaque:
      return NewOpaque(
          mojo::Clone(data_.opaque));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, PotentiallyOpaqueSize>::value>::type*>
bool PotentiallyOpaqueSize::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kTransparent:
      return mojo::Equals(data_.transparent, other.data_.transparent);
    case Tag::kOpaque:
      return mojo::Equals(data_.opaque, other.data_.opaque);
  }

  return false;
}
template <typename UnionPtrType>
PotentiallyOpaqueBoolPtr PotentiallyOpaqueBool::Clone() const {
  switch (tag_) {
    case Tag::kTransparent:
      return NewTransparent(
          mojo::Clone(data_.transparent));
    case Tag::kOpaque:
      return NewOpaque(
          mojo::Clone(data_.opaque));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, PotentiallyOpaqueBool>::value>::type*>
bool PotentiallyOpaqueBool::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kTransparent:
      return mojo::Equals(data_.transparent, other.data_.transparent);
    case Tag::kOpaque:
      return mojo::Equals(data_.opaque, other.data_.opaque);
  }

  return false;
}
template <typename UnionPtrType>
PotentiallyOpaqueAdAuctionDataPtr PotentiallyOpaqueAdAuctionData::Clone() const {
  switch (tag_) {
    case Tag::kTransparent:
      return NewTransparent(
          mojo::Clone(data_.transparent));
    case Tag::kOpaque:
      return NewOpaque(
          mojo::Clone(data_.opaque));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, PotentiallyOpaqueAdAuctionData>::value>::type*>
bool PotentiallyOpaqueAdAuctionData::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kTransparent:
      return mojo::Equals(data_.transparent, other.data_.transparent);
    case Tag::kOpaque:
      return mojo::Equals(data_.opaque, other.data_.opaque);
  }

  return false;
}
template <typename UnionPtrType>
PotentiallyOpaqueConfigVectorPtr PotentiallyOpaqueConfigVector::Clone() const {
  switch (tag_) {
    case Tag::kTransparent:
      return NewTransparent(
          mojo::Clone(data_.transparent));
    case Tag::kOpaque:
      return NewOpaque(
          mojo::Clone(data_.opaque));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, PotentiallyOpaqueConfigVector>::value>::type*>
bool PotentiallyOpaqueConfigVector::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kTransparent:
      return mojo::Equals(data_.transparent, other.data_.transparent);
    case Tag::kOpaque:
      return mojo::Equals(data_.opaque, other.data_.opaque);
  }

  return false;
}
template <typename UnionPtrType>
PotentiallyOpaqueURNConfigVectorPtr PotentiallyOpaqueURNConfigVector::Clone() const {
  switch (tag_) {
    case Tag::kTransparent:
      return NewTransparent(
          mojo::Clone(data_.transparent));
    case Tag::kOpaque:
      return NewOpaque(
          mojo::Clone(data_.opaque));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, PotentiallyOpaqueURNConfigVector>::value>::type*>
bool PotentiallyOpaqueURNConfigVector::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kTransparent:
      return mojo::Equals(data_.transparent, other.data_.transparent);
    case Tag::kOpaque:
      return mojo::Equals(data_.opaque, other.data_.opaque);
  }

  return false;
}
template <typename UnionPtrType>
PotentiallyOpaqueSharedStorageBudgetMetadataPtr PotentiallyOpaqueSharedStorageBudgetMetadata::Clone() const {
  switch (tag_) {
    case Tag::kTransparent:
      return NewTransparent(
          mojo::Clone(data_.transparent));
    case Tag::kOpaque:
      return NewOpaque(
          mojo::Clone(data_.opaque));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, PotentiallyOpaqueSharedStorageBudgetMetadata>::value>::type*>
bool PotentiallyOpaqueSharedStorageBudgetMetadata::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kTransparent:
      return mojo::Equals(data_.transparent, other.data_.transparent);
    case Tag::kOpaque:
      return mojo::Equals(data_.opaque, other.data_.opaque);
  }

  return false;
}
template <typename StructPtrType>
AdAuctionDataPtr AdAuctionData::Clone() const {
  return New(
      mojo::Clone(interest_group_owner),
      mojo::Clone(interest_group_name)
  );
}

template <typename T, AdAuctionData::EnableIfSame<T>*>
bool AdAuctionData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->interest_group_owner, other_struct.interest_group_owner))
    return false;
  if (!mojo::Equals(this->interest_group_name, other_struct.interest_group_name))
    return false;
  return true;
}

template <typename T, AdAuctionData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.interest_group_owner < rhs.interest_group_owner)
    return true;
  if (rhs.interest_group_owner < lhs.interest_group_owner)
    return false;
  if (lhs.interest_group_name < rhs.interest_group_name)
    return true;
  if (rhs.interest_group_name < lhs.interest_group_name)
    return false;
  return false;
}
template <typename StructPtrType>
URNConfigPairPtr URNConfigPair::Clone() const {
  return New(
      mojo::Clone(urn),
      mojo::Clone(config)
  );
}

template <typename T, URNConfigPair::EnableIfSame<T>*>
bool URNConfigPair::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->urn, other_struct.urn))
    return false;
  if (!mojo::Equals(this->config, other_struct.config))
    return false;
  return true;
}

template <typename T, URNConfigPair::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.urn < rhs.urn)
    return true;
  if (rhs.urn < lhs.urn)
    return false;
  if (lhs.config < rhs.config)
    return true;
  if (rhs.config < lhs.config)
    return false;
  return false;
}
template <typename StructPtrType>
SharedStorageBudgetMetadataPtr SharedStorageBudgetMetadata::Clone() const {
  return New(
      mojo::Clone(site),
      mojo::Clone(budget_to_charge),
      mojo::Clone(top_navigated)
  );
}

template <typename T, SharedStorageBudgetMetadata::EnableIfSame<T>*>
bool SharedStorageBudgetMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->site, other_struct.site))
    return false;
  if (!mojo::Equals(this->budget_to_charge, other_struct.budget_to_charge))
    return false;
  if (!mojo::Equals(this->top_navigated, other_struct.top_navigated))
    return false;
  return true;
}

template <typename T, SharedStorageBudgetMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.site < rhs.site)
    return true;
  if (rhs.site < lhs.site)
    return false;
  if (lhs.budget_to_charge < rhs.budget_to_charge)
    return true;
  if (rhs.budget_to_charge < lhs.budget_to_charge)
    return false;
  if (lhs.top_navigated < rhs.top_navigated)
    return true;
  if (rhs.top_navigated < lhs.top_navigated)
    return false;
  return false;
}
template <typename StructPtrType>
ParentPermissionsInfoPtr ParentPermissionsInfo::Clone() const {
  return New(
      mojo::Clone(parsed_permissions_policy),
      mojo::Clone(origin)
  );
}

template <typename T, ParentPermissionsInfo::EnableIfSame<T>*>
bool ParentPermissionsInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->parsed_permissions_policy, other_struct.parsed_permissions_policy))
    return false;
  if (!mojo::Equals(this->origin, other_struct.origin))
    return false;
  return true;
}

template <typename T, ParentPermissionsInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.parsed_permissions_policy < rhs.parsed_permissions_policy)
    return true;
  if (rhs.parsed_permissions_policy < lhs.parsed_permissions_policy)
    return false;
  if (lhs.origin < rhs.origin)
    return true;
  if (rhs.origin < lhs.origin)
    return false;
  return false;
}
template <typename StructPtrType>
FencedFrameConfigPtr FencedFrameConfig::Clone() const {
  return New(
      mojo::Clone(mapped_url),
      mojo::Clone(container_size),
      mojo::Clone(content_size),
      mojo::Clone(deprecated_should_freeze_initial_size),
      mojo::Clone(ad_auction_data),
      mojo::Clone(nested_configs),
      mojo::Clone(shared_storage_budget_metadata),
      mojo::Clone(urn_uuid),
      mojo::Clone(mode),
      mojo::Clone(effective_enabled_permissions),
      mojo::Clone(parent_permissions_info)
  );
}

template <typename T, FencedFrameConfig::EnableIfSame<T>*>
bool FencedFrameConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->mapped_url, other_struct.mapped_url))
    return false;
  if (!mojo::Equals(this->container_size, other_struct.container_size))
    return false;
  if (!mojo::Equals(this->content_size, other_struct.content_size))
    return false;
  if (!mojo::Equals(this->deprecated_should_freeze_initial_size, other_struct.deprecated_should_freeze_initial_size))
    return false;
  if (!mojo::Equals(this->ad_auction_data, other_struct.ad_auction_data))
    return false;
  if (!mojo::Equals(this->nested_configs, other_struct.nested_configs))
    return false;
  if (!mojo::Equals(this->shared_storage_budget_metadata, other_struct.shared_storage_budget_metadata))
    return false;
  if (!mojo::Equals(this->urn_uuid, other_struct.urn_uuid))
    return false;
  if (!mojo::Equals(this->mode, other_struct.mode))
    return false;
  if (!mojo::Equals(this->effective_enabled_permissions, other_struct.effective_enabled_permissions))
    return false;
  if (!mojo::Equals(this->parent_permissions_info, other_struct.parent_permissions_info))
    return false;
  return true;
}

template <typename T, FencedFrameConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.mapped_url < rhs.mapped_url)
    return true;
  if (rhs.mapped_url < lhs.mapped_url)
    return false;
  if (lhs.container_size < rhs.container_size)
    return true;
  if (rhs.container_size < lhs.container_size)
    return false;
  if (lhs.content_size < rhs.content_size)
    return true;
  if (rhs.content_size < lhs.content_size)
    return false;
  if (lhs.deprecated_should_freeze_initial_size < rhs.deprecated_should_freeze_initial_size)
    return true;
  if (rhs.deprecated_should_freeze_initial_size < lhs.deprecated_should_freeze_initial_size)
    return false;
  if (lhs.ad_auction_data < rhs.ad_auction_data)
    return true;
  if (rhs.ad_auction_data < lhs.ad_auction_data)
    return false;
  if (lhs.nested_configs < rhs.nested_configs)
    return true;
  if (rhs.nested_configs < lhs.nested_configs)
    return false;
  if (lhs.shared_storage_budget_metadata < rhs.shared_storage_budget_metadata)
    return true;
  if (rhs.shared_storage_budget_metadata < lhs.shared_storage_budget_metadata)
    return false;
  if (lhs.urn_uuid < rhs.urn_uuid)
    return true;
  if (rhs.urn_uuid < lhs.urn_uuid)
    return false;
  if (lhs.mode < rhs.mode)
    return true;
  if (rhs.mode < lhs.mode)
    return false;
  if (lhs.effective_enabled_permissions < rhs.effective_enabled_permissions)
    return true;
  if (rhs.effective_enabled_permissions < lhs.effective_enabled_permissions)
    return false;
  if (lhs.parent_permissions_info < rhs.parent_permissions_info)
    return true;
  if (rhs.parent_permissions_info < lhs.parent_permissions_info)
    return false;
  return false;
}
template <typename StructPtrType>
FencedFramePropertiesPtr FencedFrameProperties::Clone() const {
  return New(
      mojo::Clone(mapped_url),
      mojo::Clone(container_size),
      mojo::Clone(content_size),
      mojo::Clone(deprecated_should_freeze_initial_size),
      mojo::Clone(ad_auction_data),
      mojo::Clone(nested_urn_config_pairs),
      mojo::Clone(shared_storage_budget_metadata),
      mojo::Clone(mode),
      mojo::Clone(effective_enabled_permissions),
      mojo::Clone(parent_permissions_info),
      mojo::Clone(can_disable_untrusted_network),
      mojo::Clone(is_cross_origin_content),
      mojo::Clone(allow_cross_origin_event_reporting)
  );
}

template <typename T, FencedFrameProperties::EnableIfSame<T>*>
bool FencedFrameProperties::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->mapped_url, other_struct.mapped_url))
    return false;
  if (!mojo::Equals(this->container_size, other_struct.container_size))
    return false;
  if (!mojo::Equals(this->content_size, other_struct.content_size))
    return false;
  if (!mojo::Equals(this->deprecated_should_freeze_initial_size, other_struct.deprecated_should_freeze_initial_size))
    return false;
  if (!mojo::Equals(this->ad_auction_data, other_struct.ad_auction_data))
    return false;
  if (!mojo::Equals(this->nested_urn_config_pairs, other_struct.nested_urn_config_pairs))
    return false;
  if (!mojo::Equals(this->shared_storage_budget_metadata, other_struct.shared_storage_budget_metadata))
    return false;
  if (!mojo::Equals(this->mode, other_struct.mode))
    return false;
  if (!mojo::Equals(this->effective_enabled_permissions, other_struct.effective_enabled_permissions))
    return false;
  if (!mojo::Equals(this->parent_permissions_info, other_struct.parent_permissions_info))
    return false;
  if (!mojo::Equals(this->can_disable_untrusted_network, other_struct.can_disable_untrusted_network))
    return false;
  if (!mojo::Equals(this->is_cross_origin_content, other_struct.is_cross_origin_content))
    return false;
  if (!mojo::Equals(this->allow_cross_origin_event_reporting, other_struct.allow_cross_origin_event_reporting))
    return false;
  return true;
}

template <typename T, FencedFrameProperties::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.mapped_url < rhs.mapped_url)
    return true;
  if (rhs.mapped_url < lhs.mapped_url)
    return false;
  if (lhs.container_size < rhs.container_size)
    return true;
  if (rhs.container_size < lhs.container_size)
    return false;
  if (lhs.content_size < rhs.content_size)
    return true;
  if (rhs.content_size < lhs.content_size)
    return false;
  if (lhs.deprecated_should_freeze_initial_size < rhs.deprecated_should_freeze_initial_size)
    return true;
  if (rhs.deprecated_should_freeze_initial_size < lhs.deprecated_should_freeze_initial_size)
    return false;
  if (lhs.ad_auction_data < rhs.ad_auction_data)
    return true;
  if (rhs.ad_auction_data < lhs.ad_auction_data)
    return false;
  if (lhs.nested_urn_config_pairs < rhs.nested_urn_config_pairs)
    return true;
  if (rhs.nested_urn_config_pairs < lhs.nested_urn_config_pairs)
    return false;
  if (lhs.shared_storage_budget_metadata < rhs.shared_storage_budget_metadata)
    return true;
  if (rhs.shared_storage_budget_metadata < lhs.shared_storage_budget_metadata)
    return false;
  if (lhs.mode < rhs.mode)
    return true;
  if (rhs.mode < lhs.mode)
    return false;
  if (lhs.effective_enabled_permissions < rhs.effective_enabled_permissions)
    return true;
  if (rhs.effective_enabled_permissions < lhs.effective_enabled_permissions)
    return false;
  if (lhs.parent_permissions_info < rhs.parent_permissions_info)
    return true;
  if (rhs.parent_permissions_info < lhs.parent_permissions_info)
    return false;
  if (lhs.can_disable_untrusted_network < rhs.can_disable_untrusted_network)
    return true;
  if (rhs.can_disable_untrusted_network < lhs.can_disable_untrusted_network)
    return false;
  if (lhs.is_cross_origin_content < rhs.is_cross_origin_content)
    return true;
  if (rhs.is_cross_origin_content < lhs.is_cross_origin_content)
    return false;
  if (lhs.allow_cross_origin_event_reporting < rhs.allow_cross_origin_event_reporting)
    return true;
  if (rhs.allow_cross_origin_event_reporting < lhs.allow_cross_origin_event_reporting)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::AdAuctionData::DataView,
                                         ::blink::mojom::AdAuctionDataPtr> {
  static bool IsNull(const ::blink::mojom::AdAuctionDataPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::AdAuctionDataPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::AdAuctionData::interest_group_owner)& interest_group_owner(
      const ::blink::mojom::AdAuctionDataPtr& input) {
    return input->interest_group_owner;
  }

  static const decltype(::blink::mojom::AdAuctionData::interest_group_name)& interest_group_name(
      const ::blink::mojom::AdAuctionDataPtr& input) {
    return input->interest_group_name;
  }

  static bool Read(::blink::mojom::AdAuctionData::DataView input, ::blink::mojom::AdAuctionDataPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::URNConfigPair::DataView,
                                         ::blink::mojom::URNConfigPairPtr> {
  static bool IsNull(const ::blink::mojom::URNConfigPairPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::URNConfigPairPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::URNConfigPair::urn)& urn(
      const ::blink::mojom::URNConfigPairPtr& input) {
    return input->urn;
  }

  static const decltype(::blink::mojom::URNConfigPair::config)& config(
      const ::blink::mojom::URNConfigPairPtr& input) {
    return input->config;
  }

  static bool Read(::blink::mojom::URNConfigPair::DataView input, ::blink::mojom::URNConfigPairPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::SharedStorageBudgetMetadata::DataView,
                                         ::blink::mojom::SharedStorageBudgetMetadataPtr> {
  static bool IsNull(const ::blink::mojom::SharedStorageBudgetMetadataPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::SharedStorageBudgetMetadataPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::SharedStorageBudgetMetadata::site)& site(
      const ::blink::mojom::SharedStorageBudgetMetadataPtr& input) {
    return input->site;
  }

  static decltype(::blink::mojom::SharedStorageBudgetMetadata::budget_to_charge) budget_to_charge(
      const ::blink::mojom::SharedStorageBudgetMetadataPtr& input) {
    return input->budget_to_charge;
  }

  static decltype(::blink::mojom::SharedStorageBudgetMetadata::top_navigated) top_navigated(
      const ::blink::mojom::SharedStorageBudgetMetadataPtr& input) {
    return input->top_navigated;
  }

  static bool Read(::blink::mojom::SharedStorageBudgetMetadata::DataView input, ::blink::mojom::SharedStorageBudgetMetadataPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ParentPermissionsInfo::DataView,
                                         ::blink::mojom::ParentPermissionsInfoPtr> {
  static bool IsNull(const ::blink::mojom::ParentPermissionsInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ParentPermissionsInfoPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::ParentPermissionsInfo::parsed_permissions_policy)& parsed_permissions_policy(
      const ::blink::mojom::ParentPermissionsInfoPtr& input) {
    return input->parsed_permissions_policy;
  }

  static const decltype(::blink::mojom::ParentPermissionsInfo::origin)& origin(
      const ::blink::mojom::ParentPermissionsInfoPtr& input) {
    return input->origin;
  }

  static bool Read(::blink::mojom::ParentPermissionsInfo::DataView input, ::blink::mojom::ParentPermissionsInfoPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::FencedFrameConfig::DataView,
                                         ::blink::mojom::FencedFrameConfigPtr> {
  static bool IsNull(const ::blink::mojom::FencedFrameConfigPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::FencedFrameConfigPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::FencedFrameConfig::mapped_url)& mapped_url(
      const ::blink::mojom::FencedFrameConfigPtr& input) {
    return input->mapped_url;
  }

  static const decltype(::blink::mojom::FencedFrameConfig::container_size)& container_size(
      const ::blink::mojom::FencedFrameConfigPtr& input) {
    return input->container_size;
  }

  static const decltype(::blink::mojom::FencedFrameConfig::content_size)& content_size(
      const ::blink::mojom::FencedFrameConfigPtr& input) {
    return input->content_size;
  }

  static const decltype(::blink::mojom::FencedFrameConfig::deprecated_should_freeze_initial_size)& deprecated_should_freeze_initial_size(
      const ::blink::mojom::FencedFrameConfigPtr& input) {
    return input->deprecated_should_freeze_initial_size;
  }

  static const decltype(::blink::mojom::FencedFrameConfig::ad_auction_data)& ad_auction_data(
      const ::blink::mojom::FencedFrameConfigPtr& input) {
    return input->ad_auction_data;
  }

  static const decltype(::blink::mojom::FencedFrameConfig::nested_configs)& nested_configs(
      const ::blink::mojom::FencedFrameConfigPtr& input) {
    return input->nested_configs;
  }

  static const decltype(::blink::mojom::FencedFrameConfig::shared_storage_budget_metadata)& shared_storage_budget_metadata(
      const ::blink::mojom::FencedFrameConfigPtr& input) {
    return input->shared_storage_budget_metadata;
  }

  static const decltype(::blink::mojom::FencedFrameConfig::urn_uuid)& urn_uuid(
      const ::blink::mojom::FencedFrameConfigPtr& input) {
    return input->urn_uuid;
  }

  static decltype(::blink::mojom::FencedFrameConfig::mode) mode(
      const ::blink::mojom::FencedFrameConfigPtr& input) {
    return input->mode;
  }

  static const decltype(::blink::mojom::FencedFrameConfig::effective_enabled_permissions)& effective_enabled_permissions(
      const ::blink::mojom::FencedFrameConfigPtr& input) {
    return input->effective_enabled_permissions;
  }

  static const decltype(::blink::mojom::FencedFrameConfig::parent_permissions_info)& parent_permissions_info(
      const ::blink::mojom::FencedFrameConfigPtr& input) {
    return input->parent_permissions_info;
  }

  static bool Read(::blink::mojom::FencedFrameConfig::DataView input, ::blink::mojom::FencedFrameConfigPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::FencedFrameProperties::DataView,
                                         ::blink::mojom::FencedFramePropertiesPtr> {
  static bool IsNull(const ::blink::mojom::FencedFramePropertiesPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::FencedFramePropertiesPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::FencedFrameProperties::mapped_url)& mapped_url(
      const ::blink::mojom::FencedFramePropertiesPtr& input) {
    return input->mapped_url;
  }

  static const decltype(::blink::mojom::FencedFrameProperties::container_size)& container_size(
      const ::blink::mojom::FencedFramePropertiesPtr& input) {
    return input->container_size;
  }

  static const decltype(::blink::mojom::FencedFrameProperties::content_size)& content_size(
      const ::blink::mojom::FencedFramePropertiesPtr& input) {
    return input->content_size;
  }

  static const decltype(::blink::mojom::FencedFrameProperties::deprecated_should_freeze_initial_size)& deprecated_should_freeze_initial_size(
      const ::blink::mojom::FencedFramePropertiesPtr& input) {
    return input->deprecated_should_freeze_initial_size;
  }

  static const decltype(::blink::mojom::FencedFrameProperties::ad_auction_data)& ad_auction_data(
      const ::blink::mojom::FencedFramePropertiesPtr& input) {
    return input->ad_auction_data;
  }

  static const decltype(::blink::mojom::FencedFrameProperties::nested_urn_config_pairs)& nested_urn_config_pairs(
      const ::blink::mojom::FencedFramePropertiesPtr& input) {
    return input->nested_urn_config_pairs;
  }

  static const decltype(::blink::mojom::FencedFrameProperties::shared_storage_budget_metadata)& shared_storage_budget_metadata(
      const ::blink::mojom::FencedFramePropertiesPtr& input) {
    return input->shared_storage_budget_metadata;
  }

  static decltype(::blink::mojom::FencedFrameProperties::mode) mode(
      const ::blink::mojom::FencedFramePropertiesPtr& input) {
    return input->mode;
  }

  static const decltype(::blink::mojom::FencedFrameProperties::effective_enabled_permissions)& effective_enabled_permissions(
      const ::blink::mojom::FencedFramePropertiesPtr& input) {
    return input->effective_enabled_permissions;
  }

  static const decltype(::blink::mojom::FencedFrameProperties::parent_permissions_info)& parent_permissions_info(
      const ::blink::mojom::FencedFramePropertiesPtr& input) {
    return input->parent_permissions_info;
  }

  static decltype(::blink::mojom::FencedFrameProperties::can_disable_untrusted_network) can_disable_untrusted_network(
      const ::blink::mojom::FencedFramePropertiesPtr& input) {
    return input->can_disable_untrusted_network;
  }

  static decltype(::blink::mojom::FencedFrameProperties::is_cross_origin_content) is_cross_origin_content(
      const ::blink::mojom::FencedFramePropertiesPtr& input) {
    return input->is_cross_origin_content;
  }

  static decltype(::blink::mojom::FencedFrameProperties::allow_cross_origin_event_reporting) allow_cross_origin_event_reporting(
      const ::blink::mojom::FencedFramePropertiesPtr& input) {
    return input->allow_cross_origin_event_reporting;
  }

  static bool Read(::blink::mojom::FencedFrameProperties::DataView input, ::blink::mojom::FencedFramePropertiesPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT UnionTraits<::blink::mojom::PotentiallyOpaqueURL::DataView,
                                        ::blink::mojom::PotentiallyOpaqueURLPtr> {
  static bool IsNull(const ::blink::mojom::PotentiallyOpaqueURLPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::PotentiallyOpaqueURLPtr* output) { output->reset(); }

  static ::blink::mojom::PotentiallyOpaqueURL::Tag GetTag(const ::blink::mojom::PotentiallyOpaqueURLPtr& input) {
    return input->which();
  }

  static const ::GURL& transparent(const ::blink::mojom::PotentiallyOpaqueURLPtr& input) {
    return input->get_transparent();
  }

  static  ::blink::FencedFrame::Opaque opaque(const ::blink::mojom::PotentiallyOpaqueURLPtr& input) {
    return input->get_opaque();
  }

  static bool Read(::blink::mojom::PotentiallyOpaqueURL::DataView input, ::blink::mojom::PotentiallyOpaqueURLPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT UnionTraits<::blink::mojom::PotentiallyOpaqueSize::DataView,
                                        ::blink::mojom::PotentiallyOpaqueSizePtr> {
  static bool IsNull(const ::blink::mojom::PotentiallyOpaqueSizePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::PotentiallyOpaqueSizePtr* output) { output->reset(); }

  static ::blink::mojom::PotentiallyOpaqueSize::Tag GetTag(const ::blink::mojom::PotentiallyOpaqueSizePtr& input) {
    return input->which();
  }

  static const ::gfx::Size& transparent(const ::blink::mojom::PotentiallyOpaqueSizePtr& input) {
    return input->get_transparent();
  }

  static  ::blink::FencedFrame::Opaque opaque(const ::blink::mojom::PotentiallyOpaqueSizePtr& input) {
    return input->get_opaque();
  }

  static bool Read(::blink::mojom::PotentiallyOpaqueSize::DataView input, ::blink::mojom::PotentiallyOpaqueSizePtr* output);
};


template <>
struct BLINK_COMMON_EXPORT UnionTraits<::blink::mojom::PotentiallyOpaqueBool::DataView,
                                        ::blink::mojom::PotentiallyOpaqueBoolPtr> {
  static bool IsNull(const ::blink::mojom::PotentiallyOpaqueBoolPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::PotentiallyOpaqueBoolPtr* output) { output->reset(); }

  static ::blink::mojom::PotentiallyOpaqueBool::Tag GetTag(const ::blink::mojom::PotentiallyOpaqueBoolPtr& input) {
    return input->which();
  }

  static  bool transparent(const ::blink::mojom::PotentiallyOpaqueBoolPtr& input) {
    return input->get_transparent();
  }

  static  ::blink::FencedFrame::Opaque opaque(const ::blink::mojom::PotentiallyOpaqueBoolPtr& input) {
    return input->get_opaque();
  }

  static bool Read(::blink::mojom::PotentiallyOpaqueBool::DataView input, ::blink::mojom::PotentiallyOpaqueBoolPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT UnionTraits<::blink::mojom::PotentiallyOpaqueAdAuctionData::DataView,
                                        ::blink::mojom::PotentiallyOpaqueAdAuctionDataPtr> {
  static bool IsNull(const ::blink::mojom::PotentiallyOpaqueAdAuctionDataPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::PotentiallyOpaqueAdAuctionDataPtr* output) { output->reset(); }

  static ::blink::mojom::PotentiallyOpaqueAdAuctionData::Tag GetTag(const ::blink::mojom::PotentiallyOpaqueAdAuctionDataPtr& input) {
    return input->which();
  }

  static const ::blink::FencedFrame::AdAuctionData& transparent(const ::blink::mojom::PotentiallyOpaqueAdAuctionDataPtr& input) {
    return input->get_transparent();
  }

  static  ::blink::FencedFrame::Opaque opaque(const ::blink::mojom::PotentiallyOpaqueAdAuctionDataPtr& input) {
    return input->get_opaque();
  }

  static bool Read(::blink::mojom::PotentiallyOpaqueAdAuctionData::DataView input, ::blink::mojom::PotentiallyOpaqueAdAuctionDataPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT UnionTraits<::blink::mojom::PotentiallyOpaqueConfigVector::DataView,
                                        ::blink::mojom::PotentiallyOpaqueConfigVectorPtr> {
  static bool IsNull(const ::blink::mojom::PotentiallyOpaqueConfigVectorPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::PotentiallyOpaqueConfigVectorPtr* output) { output->reset(); }

  static ::blink::mojom::PotentiallyOpaqueConfigVector::Tag GetTag(const ::blink::mojom::PotentiallyOpaqueConfigVectorPtr& input) {
    return input->which();
  }

  static const std::vector<::blink::FencedFrame::RedactedFencedFrameConfig>& transparent(const ::blink::mojom::PotentiallyOpaqueConfigVectorPtr& input) {
    return input->get_transparent();
  }

  static  ::blink::FencedFrame::Opaque opaque(const ::blink::mojom::PotentiallyOpaqueConfigVectorPtr& input) {
    return input->get_opaque();
  }

  static bool Read(::blink::mojom::PotentiallyOpaqueConfigVector::DataView input, ::blink::mojom::PotentiallyOpaqueConfigVectorPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT UnionTraits<::blink::mojom::PotentiallyOpaqueURNConfigVector::DataView,
                                        ::blink::mojom::PotentiallyOpaqueURNConfigVectorPtr> {
  static bool IsNull(const ::blink::mojom::PotentiallyOpaqueURNConfigVectorPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::PotentiallyOpaqueURNConfigVectorPtr* output) { output->reset(); }

  static ::blink::mojom::PotentiallyOpaqueURNConfigVector::Tag GetTag(const ::blink::mojom::PotentiallyOpaqueURNConfigVectorPtr& input) {
    return input->which();
  }

  static const std::vector<::blink::mojom::URNConfigPairPtr>& transparent(const ::blink::mojom::PotentiallyOpaqueURNConfigVectorPtr& input) {
    return input->get_transparent();
  }

  static  ::blink::FencedFrame::Opaque opaque(const ::blink::mojom::PotentiallyOpaqueURNConfigVectorPtr& input) {
    return input->get_opaque();
  }

  static bool Read(::blink::mojom::PotentiallyOpaqueURNConfigVector::DataView input, ::blink::mojom::PotentiallyOpaqueURNConfigVectorPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT UnionTraits<::blink::mojom::PotentiallyOpaqueSharedStorageBudgetMetadata::DataView,
                                        ::blink::mojom::PotentiallyOpaqueSharedStorageBudgetMetadataPtr> {
  static bool IsNull(const ::blink::mojom::PotentiallyOpaqueSharedStorageBudgetMetadataPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::PotentiallyOpaqueSharedStorageBudgetMetadataPtr* output) { output->reset(); }

  static ::blink::mojom::PotentiallyOpaqueSharedStorageBudgetMetadata::Tag GetTag(const ::blink::mojom::PotentiallyOpaqueSharedStorageBudgetMetadataPtr& input) {
    return input->which();
  }

  static const ::blink::FencedFrame::SharedStorageBudgetMetadata& transparent(const ::blink::mojom::PotentiallyOpaqueSharedStorageBudgetMetadataPtr& input) {
    return input->get_transparent();
  }

  static  ::blink::FencedFrame::Opaque opaque(const ::blink::mojom::PotentiallyOpaqueSharedStorageBudgetMetadataPtr& input) {
    return input->get_opaque();
  }

  static bool Read(::blink::mojom::PotentiallyOpaqueSharedStorageBudgetMetadata::DataView input, ::blink::mojom::PotentiallyOpaqueSharedStorageBudgetMetadataPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FENCED_FRAME_FENCED_FRAME_CONFIG_MOJOM_H_