// third_party/blink/public/mojom/fenced_frame/fenced_frame.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FENCED_FRAME_FENCED_FRAME_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FENCED_FRAME_FENCED_FRAME_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/fenced_frame/fenced_frame.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/fenced_frame/fenced_frame.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/fenced_frame/fenced_frame.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "third_party/blink/public/mojom/frame/frame_policy.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class FencedFrameOwnerHostProxy;

template <typename ImplRefTraits>
class FencedFrameOwnerHostStub;

class FencedFrameOwnerHostRequestValidator;


class BLINK_COMMON_EXPORT FencedFrameOwnerHost
    : public FencedFrameOwnerHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.FencedFrameOwnerHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = FencedFrameOwnerHostInterfaceBase;
  using Proxy_ = FencedFrameOwnerHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = FencedFrameOwnerHostStub<ImplRefTraits>;

  using RequestValidator_ = FencedFrameOwnerHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kNavigateMinVersion = 0,
    kDidChangeFramePolicyMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Navigate_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidChangeFramePolicy_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~FencedFrameOwnerHost() = default;

  virtual void Navigate(const ::GURL& url, ::base::TimeTicks navigation_start_time, const std::optional<::std::u16string>& embedder_shared_storage_context) = 0;

  virtual void DidChangeFramePolicy(const ::blink::FramePolicy& frame_policy) = 0;
};



class BLINK_COMMON_EXPORT FencedFrameOwnerHostProxy
    : public FencedFrameOwnerHost {
 public:
  using InterfaceType = FencedFrameOwnerHost;

  explicit FencedFrameOwnerHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Navigate(const ::GURL& url, ::base::TimeTicks navigation_start_time, const std::optional<::std::u16string>& embedder_shared_storage_context) final;
  
  void DidChangeFramePolicy(const ::blink::FramePolicy& frame_policy) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT FencedFrameOwnerHostStubDispatch {
 public:
  static bool Accept(FencedFrameOwnerHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FencedFrameOwnerHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FencedFrameOwnerHost>>
class FencedFrameOwnerHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FencedFrameOwnerHostStub() = default;
  ~FencedFrameOwnerHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FencedFrameOwnerHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FencedFrameOwnerHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT FencedFrameOwnerHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // blink::mojom

namespace mojo {

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FENCED_FRAME_FENCED_FRAME_MOJOM_H_