// third_party/blink/public/mojom/fenced_frame/fenced_frame.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/fenced_frame/fenced_frame.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/fenced_frame/fenced_frame.mojom-params-data.h"
#include "third_party/blink/public/mojom/fenced_frame/fenced_frame.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/fenced_frame/fenced_frame.mojom-import-headers.h"
#include "third_party/blink/public/mojom/fenced_frame/fenced_frame.mojom-test-utils.h"


namespace blink::mojom {
// The declaration includes the definition on other builds.

FencedFrameOwnerHost::IPCStableHashFunction FencedFrameOwnerHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FencedFrameOwnerHost>(message.name())) {
    case messages::FencedFrameOwnerHost::kNavigate: {
      return &FencedFrameOwnerHost::Navigate_Sym::IPCStableHash;
    }
    case messages::FencedFrameOwnerHost::kDidChangeFramePolicy: {
      return &FencedFrameOwnerHost::DidChangeFramePolicy_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FencedFrameOwnerHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FencedFrameOwnerHost>(message.name())) {
      case messages::FencedFrameOwnerHost::kNavigate:
            return "Receive blink::mojom::FencedFrameOwnerHost::Navigate";
      case messages::FencedFrameOwnerHost::kDidChangeFramePolicy:
            return "Receive blink::mojom::FencedFrameOwnerHost::DidChangeFramePolicy";
    }
  } else {
    switch (static_cast<messages::FencedFrameOwnerHost>(message.name())) {
      case messages::FencedFrameOwnerHost::kNavigate:
            return "Receive reply blink::mojom::FencedFrameOwnerHost::Navigate";
      case messages::FencedFrameOwnerHost::kDidChangeFramePolicy:
            return "Receive reply blink::mojom::FencedFrameOwnerHost::DidChangeFramePolicy";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FencedFrameOwnerHost::Navigate_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x442df8ca;  // IPCStableHash for blink::mojom::FencedFrameOwnerHost::Navigate
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FencedFrameOwnerHost::DidChangeFramePolicy_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbd35b248;  // IPCStableHash for blink::mojom::FencedFrameOwnerHost::DidChangeFramePolicy
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

FencedFrameOwnerHostProxy::FencedFrameOwnerHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FencedFrameOwnerHostProxy::Navigate(
    const ::GURL& in_url, ::base::TimeTicks in_navigation_start_time, const std::optional<::std::u16string>& in_embedder_shared_storage_context) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FencedFrameOwnerHost::Navigate", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("navigation_start_time"), in_navigation_start_time,
                        "<value of type ::base::TimeTicks>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("embedder_shared_storage_context"), in_embedder_shared_storage_context,
                        "<value of type const std::optional<::std::u16string>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FencedFrameOwnerHost::kNavigate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FencedFrameOwnerHost_Navigate_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in FencedFrameOwnerHost.Navigate request");
  mojo::internal::MessageFragment<
      typename decltype(params->navigation_start_time)::BaseType> navigation_start_time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
    in_navigation_start_time,
    navigation_start_time_fragment);

  params->navigation_start_time.Set(
      navigation_start_time_fragment.is_null() ? nullptr : navigation_start_time_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->navigation_start_time.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null navigation_start_time in FencedFrameOwnerHost.Navigate request");
  mojo::internal::MessageFragment<
      typename decltype(params->embedder_shared_storage_context)::BaseType> embedder_shared_storage_context_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_embedder_shared_storage_context,
    embedder_shared_storage_context_fragment);

  params->embedder_shared_storage_context.Set(
      embedder_shared_storage_context_fragment.is_null() ? nullptr : embedder_shared_storage_context_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FencedFrameOwnerHost::Name_);
  message.set_method_name("Navigate");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FencedFrameOwnerHostProxy::DidChangeFramePolicy(
    const ::blink::FramePolicy& in_frame_policy) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FencedFrameOwnerHost::DidChangeFramePolicy", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_policy"), in_frame_policy,
                        "<value of type const ::blink::FramePolicy&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FencedFrameOwnerHost::kDidChangeFramePolicy), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FencedFrameOwnerHost_DidChangeFramePolicy_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame_policy)::BaseType> frame_policy_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FramePolicyDataView>(
    in_frame_policy,
    frame_policy_fragment);

  params->frame_policy.Set(
      frame_policy_fragment.is_null() ? nullptr : frame_policy_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame_policy.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame_policy in FencedFrameOwnerHost.DidChangeFramePolicy request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FencedFrameOwnerHost::Name_);
  message.set_method_name("DidChangeFramePolicy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool FencedFrameOwnerHostStubDispatch::Accept(
    FencedFrameOwnerHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FencedFrameOwnerHost>(message->header()->name)) {
    case messages::FencedFrameOwnerHost::kNavigate: {
      DCHECK(message->is_serialized());
      internal::FencedFrameOwnerHost_Navigate_Params_Data* params =
          reinterpret_cast<internal::FencedFrameOwnerHost_Navigate_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FencedFrameOwnerHost.0
      bool success = true;
      ::GURL p_url{};
      ::base::TimeTicks p_navigation_start_time{};
      std::optional<::std::u16string> p_embedder_shared_storage_context{};
      FencedFrameOwnerHost_Navigate_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadNavigationStartTime(&p_navigation_start_time))
        success = false;
      if (success && !input_data_view.ReadEmbedderSharedStorageContext(&p_embedder_shared_storage_context))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FencedFrameOwnerHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Navigate(        
        std::move(p_url), 
        std::move(p_navigation_start_time), 
        std::move(p_embedder_shared_storage_context));
      return true;
    }
    case messages::FencedFrameOwnerHost::kDidChangeFramePolicy: {
      DCHECK(message->is_serialized());
      internal::FencedFrameOwnerHost_DidChangeFramePolicy_Params_Data* params =
          reinterpret_cast<internal::FencedFrameOwnerHost_DidChangeFramePolicy_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FencedFrameOwnerHost.1
      bool success = true;
      ::blink::FramePolicy p_frame_policy{};
      FencedFrameOwnerHost_DidChangeFramePolicy_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFramePolicy(&p_frame_policy))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FencedFrameOwnerHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidChangeFramePolicy(        
        std::move(p_frame_policy));
      return true;
    }
  }
  return false;
}

// static
bool FencedFrameOwnerHostStubDispatch::AcceptWithResponder(
    FencedFrameOwnerHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FencedFrameOwnerHost>(message->header()->name)) {
    case messages::FencedFrameOwnerHost::kNavigate: {
      break;
    }
    case messages::FencedFrameOwnerHost::kDidChangeFramePolicy: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kFencedFrameOwnerHostValidationInfo[] = {
    { &internal::FencedFrameOwnerHost_Navigate_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FencedFrameOwnerHost_DidChangeFramePolicy_Params_Data::Validate,
     nullptr /* no response */},
};

bool FencedFrameOwnerHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::FencedFrameOwnerHost::Name_,
    kFencedFrameOwnerHostValidationInfo);
}



}  // blink::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void FencedFrameOwnerHostInterceptorForTesting::Navigate(const ::GURL& url, ::base::TimeTicks navigation_start_time, const std::optional<::std::u16string>& embedder_shared_storage_context) {
  GetForwardingInterface()->Navigate(
    std::move(url)
    , 
    std::move(navigation_start_time)
    , 
    std::move(embedder_shared_storage_context)
    );
}
void FencedFrameOwnerHostInterceptorForTesting::DidChangeFramePolicy(const ::blink::FramePolicy& frame_policy) {
  GetForwardingInterface()->DidChangeFramePolicy(
    std::move(frame_policy)
    );
}
FencedFrameOwnerHostAsyncWaiter::FencedFrameOwnerHostAsyncWaiter(
    FencedFrameOwnerHost* proxy) : proxy_(proxy) {}

FencedFrameOwnerHostAsyncWaiter::~FencedFrameOwnerHostAsyncWaiter() = default;







}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif