// third_party/blink/public/mojom/favicon/favicon_url.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FAVICON_FAVICON_URL_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FAVICON_FAVICON_URL_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/blink/public/mojom/favicon/favicon_url.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"


namespace blink::mojom {
class FaviconURLDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::FaviconURLDataView> {
  using Data = ::blink::mojom::internal::FaviconURL_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class FaviconIconType : int32_t {
  
  kInvalid = 0,
  
  kFavicon = 1,
  
  kTouchIcon = 2,
  
  kTouchPrecomposedIcon = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, FaviconIconType value);
inline bool IsKnownEnumValue(FaviconIconType value) {
  return internal::FaviconIconType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class FaviconURLDataView {
 public:
  FaviconURLDataView() = default;

  FaviconURLDataView(
      internal::FaviconURL_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIconUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIconUrl(UserType* output) {
    
    auto* pointer = data_->icon_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadIconType(UserType* output) const {
    auto data_value = data_->icon_type;
    return mojo::internal::Deserialize<::blink::mojom::FaviconIconType>(
        data_value, output);
  }
  FaviconIconType icon_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::FaviconIconType>(data_->icon_type));
  }
  inline void GetIconSizesDataView(
      mojo::ArrayDataView<::gfx::mojom::SizeDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIconSizes(UserType* output) {
    
    auto* pointer = data_->icon_sizes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gfx::mojom::SizeDataView>>(
        pointer, output, message_);
  }
  bool is_default_icon() const {
    return data_->is_default_icon;
  }
 private:
  internal::FaviconURL_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FAVICON_FAVICON_URL_MOJOM_DATA_VIEW_H_