// third_party/blink/public/mojom/devtools/inspector_issue.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_DEVTOOLS_INSPECTOR_ISSUE_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_DEVTOOLS_INSPECTOR_ISSUE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/blink/public/mojom/devtools/inspector_issue.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/network/public/mojom/blocked_by_response_reason.mojom-shared.h"
#include "services/network/public/mojom/cookie_manager.mojom-shared.h"
#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace blink::mojom {
class AffectedCookieDataView;

class AffectedRequestDataView;

class AffectedFrameDataView;

class AffectedLocationDataView;

class BlockedByResponseIssueDetailsDataView;

class HeavyAdIssueDetailsDataView;

class AttributionReportingIssueDetailsDataView;

class MixedContentIssueDetailsDataView;

class ContentSecurityPolicyIssueDetailsDataView;

class CookieIssueDetailsDataView;

class SharedArrayBufferIssueDetailsDataView;

class LowTextContrastIssueDataView;

class FederatedAuthRequestIssueDetailsDataView;

class FederatedAuthUserInfoRequestIssueDetailsDataView;

class BounceTrackingIssueDetailsDataView;

class PartitioningBlobURLIssueDetailsDataView;

class CookieDeprecationMetadataIssueDetailsDataView;

class GenericIssueDetailsDataView;

class DeprecationIssueDetailsDataView;

class UserReidentificationIssueDetailsDataView;

class InspectorIssueDetailsDataView;

class InspectorIssueInfoDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::AffectedCookieDataView> {
  using Data = ::blink::mojom::internal::AffectedCookie_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AffectedRequestDataView> {
  using Data = ::blink::mojom::internal::AffectedRequest_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AffectedFrameDataView> {
  using Data = ::blink::mojom::internal::AffectedFrame_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AffectedLocationDataView> {
  using Data = ::blink::mojom::internal::AffectedLocation_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::BlockedByResponseIssueDetailsDataView> {
  using Data = ::blink::mojom::internal::BlockedByResponseIssueDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::HeavyAdIssueDetailsDataView> {
  using Data = ::blink::mojom::internal::HeavyAdIssueDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AttributionReportingIssueDetailsDataView> {
  using Data = ::blink::mojom::internal::AttributionReportingIssueDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::MixedContentIssueDetailsDataView> {
  using Data = ::blink::mojom::internal::MixedContentIssueDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ContentSecurityPolicyIssueDetailsDataView> {
  using Data = ::blink::mojom::internal::ContentSecurityPolicyIssueDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::CookieIssueDetailsDataView> {
  using Data = ::blink::mojom::internal::CookieIssueDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::SharedArrayBufferIssueDetailsDataView> {
  using Data = ::blink::mojom::internal::SharedArrayBufferIssueDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::LowTextContrastIssueDataView> {
  using Data = ::blink::mojom::internal::LowTextContrastIssue_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::FederatedAuthRequestIssueDetailsDataView> {
  using Data = ::blink::mojom::internal::FederatedAuthRequestIssueDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::FederatedAuthUserInfoRequestIssueDetailsDataView> {
  using Data = ::blink::mojom::internal::FederatedAuthUserInfoRequestIssueDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::BounceTrackingIssueDetailsDataView> {
  using Data = ::blink::mojom::internal::BounceTrackingIssueDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PartitioningBlobURLIssueDetailsDataView> {
  using Data = ::blink::mojom::internal::PartitioningBlobURLIssueDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::CookieDeprecationMetadataIssueDetailsDataView> {
  using Data = ::blink::mojom::internal::CookieDeprecationMetadataIssueDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::GenericIssueDetailsDataView> {
  using Data = ::blink::mojom::internal::GenericIssueDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::DeprecationIssueDetailsDataView> {
  using Data = ::blink::mojom::internal::DeprecationIssueDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::UserReidentificationIssueDetailsDataView> {
  using Data = ::blink::mojom::internal::UserReidentificationIssueDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::InspectorIssueDetailsDataView> {
  using Data = ::blink::mojom::internal::InspectorIssueDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::InspectorIssueInfoDataView> {
  using Data = ::blink::mojom::internal::InspectorIssueInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class InspectorIssueCode : int32_t {
  
  kCookieIssue = 0,
  
  kMixedContentIssue = 1,
  
  kBlockedByResponseIssue = 2,
  
  kContentSecurityPolicyIssue = 3,
  
  kSharedArrayBufferIssue = 4,
  
  kHeavyAdIssue = 5,
  
  kAttributionReportingIssue = 6,
  
  kLowTextContrastIssue = 7,
  
  kFederatedAuthRequestIssue = 8,
  
  kBounceTrackingIssue = 9,
  
  kCookieDeprecationMetadataIssue = 10,
  
  kGenericIssue = 11,
  
  kDeprecationIssue = 12,
  
  kFederatedAuthUserInfoRequestIssue = 13,
  
  kPartitioningBlobURLIssue = 14,
  
  kUserReidentificationIssue = 15,
  kMinValue = 0,
  kMaxValue = 15,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, InspectorIssueCode value);
inline bool IsKnownEnumValue(InspectorIssueCode value) {
  return internal::InspectorIssueCode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class HeavyAdResolutionStatus : int32_t {
  
  kHeavyAdBlocked = 0,
  
  kHeavyAdWarning = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, HeavyAdResolutionStatus value);
inline bool IsKnownEnumValue(HeavyAdResolutionStatus value) {
  return internal::HeavyAdResolutionStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class HeavyAdReason : int32_t {
  
  kNetworkTotalLimit = 0,
  
  kCpuTotalLimit = 1,
  
  kCpuPeakLimit = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, HeavyAdReason value);
inline bool IsKnownEnumValue(HeavyAdReason value) {
  return internal::HeavyAdReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AttributionReportingIssueType : int32_t {
  
  kPermissionPolicyDisabled = 0,
  
  kUntrustworthyReportingOrigin = 1,
  
  kInsecureContext = 2,
  
  kInvalidRegisterSourceHeader = 3,
  
  kInvalidRegisterTriggerHeader = 4,
  
  kSourceAndTriggerHeaders = 5,
  
  kSourceIgnored = 6,
  
  kTriggerIgnored = 7,
  
  kOsSourceIgnored = 8,
  
  kOsTriggerIgnored = 9,
  
  kInvalidRegisterOsSourceHeader = 10,
  
  kInvalidRegisterOsTriggerHeader = 11,
  
  kWebAndOsHeaders = 12,
  
  kNoWebOrOsSupport = 13,
  
  kNavigationRegistrationWithoutTransientUserActivation = 14,
  
  kInvalidInfoHeader = 15,
  
  kNoRegisterSourceHeader = 16,
  
  kNoRegisterTriggerHeader = 17,
  
  kNoRegisterOsSourceHeader = 18,
  
  kNoRegisterOsTriggerHeader = 19,
  
  kNavigationRegistrationUniqueScopeAlreadySet = 20,
  kMinValue = 0,
  kMaxValue = 20,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, AttributionReportingIssueType value);
inline bool IsKnownEnumValue(AttributionReportingIssueType value) {
  return internal::AttributionReportingIssueType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class MixedContentResolutionStatus : int32_t {
  
  kMixedContentBlocked = 0,
  
  kMixedContentAutomaticallyUpgraded = 1,
  
  kMixedContentWarning = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, MixedContentResolutionStatus value);
inline bool IsKnownEnumValue(MixedContentResolutionStatus value) {
  return internal::MixedContentResolutionStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ContentSecurityPolicyViolationType : int32_t {
  
  kInlineViolation = 0,
  
  kEvalViolation = 1,
  
  kURLViolation = 2,
  
  kSRIViolation = 3,
  
  kTrustedTypesSinkViolation = 4,
  
  kTrustedTypesPolicyViolation = 5,
  
  kWasmEvalViolation = 6,
  kMinValue = 0,
  kMaxValue = 6,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, ContentSecurityPolicyViolationType value);
inline bool IsKnownEnumValue(ContentSecurityPolicyViolationType value) {
  return internal::ContentSecurityPolicyViolationType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CookieOperation : int32_t {
  
  kSetCookie = 0,
  
  kReadCookie = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, CookieOperation value);
inline bool IsKnownEnumValue(CookieOperation value) {
  return internal::CookieOperation_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CookieExclusionReason : int32_t {
  
  kExcludeSameSiteUnspecifiedTreatedAsLax = 0,
  
  kExcludeSameSiteNoneInsecure = 1,
  
  kExcludeSameSiteLax = 2,
  
  kExcludeSameSiteStrict = 3,
  
  kExcludeDomainNonASCII = 4,
  
  kExcludeThirdPartyPhaseout = 5,
  
  kExcludePortMismatch = 6,
  
  kExcludeSchemeMismatch = 7,
  kMinValue = 0,
  kMaxValue = 7,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, CookieExclusionReason value);
inline bool IsKnownEnumValue(CookieExclusionReason value) {
  return internal::CookieExclusionReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CookieWarningReason : int32_t {
  
  kWarnSameSiteUnspecifiedCrossSiteContext = 0,
  
  kWarnSameSiteNoneInsecure = 1,
  
  kWarnSameSiteUnspecifiedLaxAllowUnsafe = 2,
  
  kWarnSameSiteStrictLaxDowngradeStrict = 3,
  
  kWarnSameSiteStrictCrossDowngradeStrict = 4,
  
  kWarnSameSiteStrictCrossDowngradeLax = 5,
  
  kWarnSameSiteLaxCrossDowngradeStrict = 6,
  
  kWarnSameSiteLaxCrossDowngradeLax = 7,
  
  kWarnAttributeValueExceedsMaxSize = 8,
  
  kWarnDomainNonASCII = 9,
  
  kWarnThirdPartyPhaseout = 10,
  
  kWarnCrossSiteRedirectDowngradeChangesInclusion = 11,
  kMinValue = 0,
  kMaxValue = 11,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, CookieWarningReason value);
inline bool IsKnownEnumValue(CookieWarningReason value) {
  return internal::CookieWarningReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SharedArrayBufferIssueType : int32_t {
  
  kTransferIssue = 0,
  
  kCreationIssue = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, SharedArrayBufferIssueType value);
inline bool IsKnownEnumValue(SharedArrayBufferIssueType value) {
  return internal::SharedArrayBufferIssueType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class FederatedAuthRequestResult : int32_t {
  
  kSuccess = 0,
  
  kShouldEmbargo = 1,
  
  kIdpNotPotentiallyTrustworthy = 2,
  
  kDisabledInSettings = 3,
  
  kDisabledInFlags = 4,
  
  kTooManyRequests = 5,
  
  kWellKnownHttpNotFound = 6,
  
  kWellKnownNoResponse = 7,
  
  kWellKnownInvalidResponse = 8,
  
  kWellKnownListEmpty = 9,
  
  kWellKnownInvalidContentType = 10,
  
  kConfigNotInWellKnown = 11,
  
  kWellKnownTooBig = 12,
  
  kConfigHttpNotFound = 13,
  
  kConfigNoResponse = 14,
  
  kConfigInvalidResponse = 15,
  
  kConfigInvalidContentType = 16,
  
  kClientMetadataHttpNotFound = 17,
  
  kClientMetadataNoResponse = 18,
  
  kClientMetadataInvalidResponse = 19,
  
  kClientMetadataInvalidContentType = 20,
  
  kAccountsHttpNotFound = 21,
  
  kAccountsNoResponse = 22,
  
  kAccountsInvalidResponse = 23,
  
  kAccountsListEmpty = 24,
  
  kAccountsInvalidContentType = 25,
  
  kIdTokenHttpNotFound = 26,
  
  kIdTokenNoResponse = 27,
  
  kIdTokenInvalidResponse = 28,
  
  kIdTokenIdpErrorResponse = 29,
  
  kIdTokenCrossSiteIdpErrorResponse = 30,
  
  kIdTokenInvalidContentType = 31,
  
  kCanceled = 32,
  
  kRpPageNotVisible = 33,
  
  kSilentMediationFailure = 34,
  
  kThirdPartyCookiesBlocked = 35,
  
  kNotSignedInWithIdp = 36,
  
  kMissingTransientUserActivation = 37,
  
  kReplacedByActiveMode = 38,
  
  kInvalidFieldsSpecified = 39,
  
  kRelyingPartyOriginIsOpaque = 40,
  
  kTypeNotMatching = 41,
  
  kError = 42,
  
  kUiDismissedNoEmbargo = 43,
  
  kCorsError = 44,
  
  kSuppressedBySegmentationPlatform = 45,
  kMinValue = 0,
  kMaxValue = 45,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, FederatedAuthRequestResult value);
inline bool IsKnownEnumValue(FederatedAuthRequestResult value) {
  return internal::FederatedAuthRequestResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class FederatedAuthUserInfoRequestResult : int32_t {
  
  kSuccess = 0,
  
  kNotSameOrigin = 1,
  
  kNotIframe = 2,
  
  kNotPotentiallyTrustworthy = 3,
  
  kNoApiPermission = 4,
  
  kNotSignedInWithIdp = 5,
  
  kNoAccountSharingPermission = 6,
  
  kInvalidConfigOrWellKnown = 7,
  
  kInvalidAccountsResponse = 8,
  
  kNoReturningUserFromFetchedAccounts = 9,
  
  kUnhandledRequest = 10,
  kMinValue = 0,
  kMaxValue = 10,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, FederatedAuthUserInfoRequestResult value);
inline bool IsKnownEnumValue(FederatedAuthUserInfoRequestResult value) {
  return internal::FederatedAuthUserInfoRequestResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class PartitioningBlobURLInfo : int32_t {
  
  kBlockedCrossPartitionFetching = 0,
  
  kEnforceNoopenerForNavigation = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, PartitioningBlobURLInfo value);
inline bool IsKnownEnumValue(PartitioningBlobURLInfo value) {
  return internal::PartitioningBlobURLInfo_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class GenericIssueErrorType : int32_t {
  
  kFormLabelForNameError = 0,
  
  kFormDuplicateIdForInputError = 1,
  
  kFormInputWithNoLabelError = 2,
  
  kFormAutocompleteAttributeEmptyError = 3,
  
  kFormEmptyIdAndNameAttributesForInputError = 4,
  
  kFormAriaLabelledByToNonExistingId = 5,
  
  kFormInputAssignedAutocompleteValueToIdOrNameAttributeError = 6,
  
  kFormLabelHasNeitherForNorNestedInput = 7,
  
  kFormLabelForMatchesNonExistingIdError = 8,
  
  kFormInputHasWrongButWellIntendedAutocompleteValueError = 9,
  
  kResponseWasBlockedByORB = 10,
  kMinValue = 0,
  kMaxValue = 10,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, GenericIssueErrorType value);
inline bool IsKnownEnumValue(GenericIssueErrorType value) {
  return internal::GenericIssueErrorType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class DeprecationIssueType : int32_t {
  
  kPrivacySandboxExtensionsAPI = 0,
  kMinValue = 0,
  kMaxValue = 0,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, DeprecationIssueType value);
inline bool IsKnownEnumValue(DeprecationIssueType value) {
  return internal::DeprecationIssueType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class UserReidentificationIssueType : int32_t {
  
  kBlockedFrameNavigation = 0,
  
  kBlockedSubresource = 1,
  
  kNoisedCanvasReadback = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, UserReidentificationIssueType value);
inline bool IsKnownEnumValue(UserReidentificationIssueType value) {
  return internal::UserReidentificationIssueType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class AffectedCookieDataView {
 public:
  AffectedCookieDataView() = default;

  AffectedCookieDataView(
      internal::AffectedCookie_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPathDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDomainDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDomain(UserType* output) {
    
    auto* pointer = data_->domain.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::AffectedCookie_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AffectedRequestDataView {
 public:
  AffectedRequestDataView() = default;

  AffectedRequestDataView(
      internal::AffectedRequest_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRequestIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequestId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `request_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRequestId` instead "
    "of `ReadRequestId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->request_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::AffectedRequest_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AffectedFrameDataView {
 public:
  AffectedFrameDataView() = default;

  AffectedFrameDataView(
      internal::AffectedFrame_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFrameIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameId(UserType* output) {
    
    auto* pointer = data_->frame_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::AffectedFrame_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AffectedLocationDataView {
 public:
  AffectedLocationDataView() = default;

  AffectedLocationDataView(
      internal::AffectedLocation_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetScriptIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScriptId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `script_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadScriptId` instead "
    "of `ReadScriptId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->script_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUrl` instead "
    "of `ReadUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint32_t line() const {
    return data_->line;
  }
  uint32_t column() const {
    return data_->column;
  }
 private:
  internal::AffectedLocation_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BlockedByResponseIssueDetailsDataView {
 public:
  BlockedByResponseIssueDetailsDataView() = default;

  BlockedByResponseIssueDetailsDataView(
      internal::BlockedByResponseIssueDetails_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRequestDataView(
      AffectedRequestDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequest(UserType* output) {
    
    auto* pointer = data_->request.Get();
    return mojo::internal::Deserialize<::blink::mojom::AffectedRequestDataView>(
        pointer, output, message_);
  }
  inline void GetParentFrameDataView(
      AffectedFrameDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParentFrame(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AffectedFrameDataView, UserType>(),
    "Attempting to read the optional `parentFrame` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadParentFrame` instead "
    "of `ReadParentFrame if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->parentFrame.Get();
    return mojo::internal::Deserialize<::blink::mojom::AffectedFrameDataView>(
        pointer, output, message_);
  }
  inline void GetBlockedFrameDataView(
      AffectedFrameDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBlockedFrame(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AffectedFrameDataView, UserType>(),
    "Attempting to read the optional `blockedFrame` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBlockedFrame` instead "
    "of `ReadBlockedFrame if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->blockedFrame.Get();
    return mojo::internal::Deserialize<::blink::mojom::AffectedFrameDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadReason(UserType* output) const {
    auto data_value = data_->reason;
    return mojo::internal::Deserialize<::network::mojom::BlockedByResponseReason>(
        data_value, output);
  }
  ::network::mojom::BlockedByResponseReason reason() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::BlockedByResponseReason>(data_->reason));
  }
 private:
  internal::BlockedByResponseIssueDetails_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class HeavyAdIssueDetailsDataView {
 public:
  HeavyAdIssueDetailsDataView() = default;

  HeavyAdIssueDetailsDataView(
      internal::HeavyAdIssueDetails_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadResolution(UserType* output) const {
    auto data_value = data_->resolution;
    return mojo::internal::Deserialize<::blink::mojom::HeavyAdResolutionStatus>(
        data_value, output);
  }
  HeavyAdResolutionStatus resolution() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::HeavyAdResolutionStatus>(data_->resolution));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadReason(UserType* output) const {
    auto data_value = data_->reason;
    return mojo::internal::Deserialize<::blink::mojom::HeavyAdReason>(
        data_value, output);
  }
  HeavyAdReason reason() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::HeavyAdReason>(data_->reason));
  }
  inline void GetFrameDataView(
      AffectedFrameDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrame(UserType* output) {
    
    auto* pointer = data_->frame.Get();
    return mojo::internal::Deserialize<::blink::mojom::AffectedFrameDataView>(
        pointer, output, message_);
  }
 private:
  internal::HeavyAdIssueDetails_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AttributionReportingIssueDetailsDataView {
 public:
  AttributionReportingIssueDetailsDataView() = default;

  AttributionReportingIssueDetailsDataView(
      internal::AttributionReportingIssueDetails_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadViolationType(UserType* output) const {
    auto data_value = data_->violation_type;
    return mojo::internal::Deserialize<::blink::mojom::AttributionReportingIssueType>(
        data_value, output);
  }
  AttributionReportingIssueType violation_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::AttributionReportingIssueType>(data_->violation_type));
  }
  inline void GetRequestDataView(
      AffectedRequestDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequest(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AffectedRequestDataView, UserType>(),
    "Attempting to read the optional `request` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRequest` instead "
    "of `ReadRequest if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->request.Get();
    return mojo::internal::Deserialize<::blink::mojom::AffectedRequestDataView>(
        pointer, output, message_);
  }
  inline void GetInvalidParameterDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInvalidParameter(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `invalid_parameter` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInvalidParameter` instead "
    "of `ReadInvalidParameter if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->invalid_parameter.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::AttributionReportingIssueDetails_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MixedContentIssueDetailsDataView {
 public:
  MixedContentIssueDetailsDataView() = default;

  MixedContentIssueDetailsDataView(
      internal::MixedContentIssueDetails_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadRequestContext(UserType* output) const {
    auto data_value = data_->request_context;
    return mojo::internal::Deserialize<::blink::mojom::RequestContextType>(
        data_value, output);
  }
  ::blink::mojom::RequestContextType request_context() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::RequestContextType>(data_->request_context));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadResolutionStatus(UserType* output) const {
    auto data_value = data_->resolution_status;
    return mojo::internal::Deserialize<::blink::mojom::MixedContentResolutionStatus>(
        data_value, output);
  }
  MixedContentResolutionStatus resolution_status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::MixedContentResolutionStatus>(data_->resolution_status));
  }
  inline void GetInsecureUrlDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInsecureUrl(UserType* output) {
    
    auto* pointer = data_->insecure_url.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetMainResourceUrlDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMainResourceUrl(UserType* output) {
    
    auto* pointer = data_->main_resource_url.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetRequestDataView(
      AffectedRequestDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequest(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AffectedRequestDataView, UserType>(),
    "Attempting to read the optional `request` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRequest` instead "
    "of `ReadRequest if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->request.Get();
    return mojo::internal::Deserialize<::blink::mojom::AffectedRequestDataView>(
        pointer, output, message_);
  }
  inline void GetFrameDataView(
      AffectedFrameDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrame(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AffectedFrameDataView, UserType>(),
    "Attempting to read the optional `frame` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFrame` instead "
    "of `ReadFrame if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->frame.Get();
    return mojo::internal::Deserialize<::blink::mojom::AffectedFrameDataView>(
        pointer, output, message_);
  }
 private:
  internal::MixedContentIssueDetails_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ContentSecurityPolicyIssueDetailsDataView {
 public:
  ContentSecurityPolicyIssueDetailsDataView() = default;

  ContentSecurityPolicyIssueDetailsDataView(
      internal::ContentSecurityPolicyIssueDetails_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBlockedUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBlockedUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `blocked_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBlockedUrl` instead "
    "of `ReadBlockedUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->blocked_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetViolatedDirectiveDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadViolatedDirective(UserType* output) {
    
    auto* pointer = data_->violated_directive.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool is_report_only() const {
    return data_->is_report_only;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadContentSecurityPolicyViolationType(UserType* output) const {
    auto data_value = data_->content_security_policy_violation_type;
    return mojo::internal::Deserialize<::blink::mojom::ContentSecurityPolicyViolationType>(
        data_value, output);
  }
  ContentSecurityPolicyViolationType content_security_policy_violation_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::ContentSecurityPolicyViolationType>(data_->content_security_policy_violation_type));
  }
  inline void GetFrameAncestorDataView(
      AffectedFrameDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameAncestor(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AffectedFrameDataView, UserType>(),
    "Attempting to read the optional `frame_ancestor` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFrameAncestor` instead "
    "of `ReadFrameAncestor if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->frame_ancestor.Get();
    return mojo::internal::Deserialize<::blink::mojom::AffectedFrameDataView>(
        pointer, output, message_);
  }
  inline void GetAffectedLocationDataView(
      AffectedLocationDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAffectedLocation(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AffectedLocationDataView, UserType>(),
    "Attempting to read the optional `affected_location` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAffectedLocation` instead "
    "of `ReadAffectedLocation if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->affected_location.Get();
    return mojo::internal::Deserialize<::blink::mojom::AffectedLocationDataView>(
        pointer, output, message_);
  }
  int32_t violating_node_id() const {
    return data_->violating_node_id;
  }
 private:
  internal::ContentSecurityPolicyIssueDetails_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CookieIssueDetailsDataView {
 public:
  CookieIssueDetailsDataView() = default;

  CookieIssueDetailsDataView(
      internal::CookieIssueDetails_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCookieDataView(
      AffectedCookieDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCookie(UserType* output) {
    
    auto* pointer = data_->cookie.Get();
    return mojo::internal::Deserialize<::blink::mojom::AffectedCookieDataView>(
        pointer, output, message_);
  }
  inline void GetExclusionReasonDataView(
      mojo::ArrayDataView<CookieExclusionReason>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExclusionReason(UserType* output) {
    
    auto* pointer = data_->exclusion_reason.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::CookieExclusionReason>>(
        pointer, output, message_);
  }
  inline void GetWarningReasonDataView(
      mojo::ArrayDataView<CookieWarningReason>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWarningReason(UserType* output) {
    
    auto* pointer = data_->warning_reason.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::CookieWarningReason>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadOperation(UserType* output) const {
    auto data_value = data_->operation;
    return mojo::internal::Deserialize<::blink::mojom::CookieOperation>(
        data_value, output);
  }
  CookieOperation operation() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::CookieOperation>(data_->operation));
  }
  inline void GetSiteForCookiesDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSiteForCookies(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `site_for_cookies` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSiteForCookies` instead "
    "of `ReadSiteForCookies if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->site_for_cookies.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetCookieUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCookieUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `cookie_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCookieUrl` instead "
    "of `ReadCookieUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->cookie_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetRequestDataView(
      AffectedRequestDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequest(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AffectedRequestDataView, UserType>(),
    "Attempting to read the optional `request` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRequest` instead "
    "of `ReadRequest if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->request.Get();
    return mojo::internal::Deserialize<::blink::mojom::AffectedRequestDataView>(
        pointer, output, message_);
  }
 private:
  internal::CookieIssueDetails_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SharedArrayBufferIssueDetailsDataView {
 public:
  SharedArrayBufferIssueDetailsDataView() = default;

  SharedArrayBufferIssueDetailsDataView(
      internal::SharedArrayBufferIssueDetails_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAffectedLocationDataView(
      AffectedLocationDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAffectedLocation(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AffectedLocationDataView, UserType>(),
    "Attempting to read the optional `affected_location` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAffectedLocation` instead "
    "of `ReadAffectedLocation if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->affected_location.Get();
    return mojo::internal::Deserialize<::blink::mojom::AffectedLocationDataView>(
        pointer, output, message_);
  }
  bool is_warning() const {
    return data_->is_warning;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::blink::mojom::SharedArrayBufferIssueType>(
        data_value, output);
  }
  SharedArrayBufferIssueType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::SharedArrayBufferIssueType>(data_->type));
  }
 private:
  internal::SharedArrayBufferIssueDetails_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class LowTextContrastIssueDataView {
 public:
  LowTextContrastIssueDataView() = default;

  LowTextContrastIssueDataView(
      internal::LowTextContrastIssue_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t violating_node_id() const {
    return data_->violating_node_id;
  }
  inline void GetViolatingNodeSelectorDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadViolatingNodeSelector(UserType* output) {
    
    auto* pointer = data_->violating_node_selector.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  float contrast_ratio() const {
    return data_->contrast_ratio;
  }
  float threshold_aa() const {
    return data_->threshold_aa;
  }
  float threshold_aaa() const {
    return data_->threshold_aaa;
  }
  inline void GetFontSizeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFontSize(UserType* output) {
    
    auto* pointer = data_->font_size.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetFontWeightDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFontWeight(UserType* output) {
    
    auto* pointer = data_->font_weight.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::LowTextContrastIssue_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FederatedAuthRequestIssueDetailsDataView {
 public:
  FederatedAuthRequestIssueDetailsDataView() = default;

  FederatedAuthRequestIssueDetailsDataView(
      internal::FederatedAuthRequestIssueDetails_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) const {
    auto data_value = data_->status;
    return mojo::internal::Deserialize<::blink::mojom::FederatedAuthRequestResult>(
        data_value, output);
  }
  FederatedAuthRequestResult status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::FederatedAuthRequestResult>(data_->status));
  }
 private:
  internal::FederatedAuthRequestIssueDetails_Data* data_ = nullptr;
};


class FederatedAuthUserInfoRequestIssueDetailsDataView {
 public:
  FederatedAuthUserInfoRequestIssueDetailsDataView() = default;

  FederatedAuthUserInfoRequestIssueDetailsDataView(
      internal::FederatedAuthUserInfoRequestIssueDetails_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) const {
    auto data_value = data_->status;
    return mojo::internal::Deserialize<::blink::mojom::FederatedAuthUserInfoRequestResult>(
        data_value, output);
  }
  FederatedAuthUserInfoRequestResult status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::FederatedAuthUserInfoRequestResult>(data_->status));
  }
 private:
  internal::FederatedAuthUserInfoRequestIssueDetails_Data* data_ = nullptr;
};


class BounceTrackingIssueDetailsDataView {
 public:
  BounceTrackingIssueDetailsDataView() = default;

  BounceTrackingIssueDetailsDataView(
      internal::BounceTrackingIssueDetails_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTrackingSitesDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrackingSites(UserType* output) {
    
    auto* pointer = data_->tracking_sites.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::BounceTrackingIssueDetails_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PartitioningBlobURLIssueDetailsDataView {
 public:
  PartitioningBlobURLIssueDetailsDataView() = default;

  PartitioningBlobURLIssueDetailsDataView(
      internal::PartitioningBlobURLIssueDetails_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPartitioningBlobUrlInfo(UserType* output) const {
    auto data_value = data_->partitioning_blob_url_info;
    return mojo::internal::Deserialize<::blink::mojom::PartitioningBlobURLInfo>(
        data_value, output);
  }
  PartitioningBlobURLInfo partitioning_blob_url_info() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::PartitioningBlobURLInfo>(data_->partitioning_blob_url_info));
  }
 private:
  internal::PartitioningBlobURLIssueDetails_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CookieDeprecationMetadataIssueDetailsDataView {
 public:
  CookieDeprecationMetadataIssueDetailsDataView() = default;

  CookieDeprecationMetadataIssueDetailsDataView(
      internal::CookieDeprecationMetadataIssueDetails_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAllowedSitesDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAllowedSites(UserType* output) {
    
    auto* pointer = data_->allowed_sites.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  uint32_t opt_out_percentage() const {
    return data_->opt_out_percentage;
  }
  bool is_opt_out_top_level() const {
    return data_->is_opt_out_top_level;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadOperation(UserType* output) const {
    auto data_value = data_->operation;
    return mojo::internal::Deserialize<::blink::mojom::CookieOperation>(
        data_value, output);
  }
  CookieOperation operation() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::CookieOperation>(data_->operation));
  }
 private:
  internal::CookieDeprecationMetadataIssueDetails_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GenericIssueDetailsDataView {
 public:
  GenericIssueDetailsDataView() = default;

  GenericIssueDetailsDataView(
      internal::GenericIssueDetails_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadErrorType(UserType* output) const {
    auto data_value = data_->error_type;
    return mojo::internal::Deserialize<::blink::mojom::GenericIssueErrorType>(
        data_value, output);
  }
  GenericIssueErrorType error_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::GenericIssueErrorType>(data_->error_type));
  }
  inline void GetFrameIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `frame_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFrameId` instead "
    "of `ReadFrameId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->frame_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  int32_t violating_node_id() const {
    return data_->violating_node_id;
  }
  inline void GetViolatingNodeAttributeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadViolatingNodeAttribute(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `violating_node_attribute` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadViolatingNodeAttribute` instead "
    "of `ReadViolatingNodeAttribute if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->violating_node_attribute.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::GenericIssueDetails_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DeprecationIssueDetailsDataView {
 public:
  DeprecationIssueDetailsDataView() = default;

  DeprecationIssueDetailsDataView(
      internal::DeprecationIssueDetails_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::blink::mojom::DeprecationIssueType>(
        data_value, output);
  }
  DeprecationIssueType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::DeprecationIssueType>(data_->type));
  }
  inline void GetAffectedLocationDataView(
      AffectedLocationDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAffectedLocation(UserType* output) {
    
    auto* pointer = data_->affected_location.Get();
    return mojo::internal::Deserialize<::blink::mojom::AffectedLocationDataView>(
        pointer, output, message_);
  }
 private:
  internal::DeprecationIssueDetails_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class UserReidentificationIssueDetailsDataView {
 public:
  UserReidentificationIssueDetailsDataView() = default;

  UserReidentificationIssueDetailsDataView(
      internal::UserReidentificationIssueDetails_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::blink::mojom::UserReidentificationIssueType>(
        data_value, output);
  }
  UserReidentificationIssueType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::UserReidentificationIssueType>(data_->type));
  }
  inline void GetRequestDataView(
      AffectedRequestDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequest(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AffectedRequestDataView, UserType>(),
    "Attempting to read the optional `request` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRequest` instead "
    "of `ReadRequest if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->request.Get();
    return mojo::internal::Deserialize<::blink::mojom::AffectedRequestDataView>(
        pointer, output, message_);
  }
  inline void GetSourceCodeLocationDataView(
      AffectedLocationDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSourceCodeLocation(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AffectedLocationDataView, UserType>(),
    "Attempting to read the optional `sourceCodeLocation` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSourceCodeLocation` instead "
    "of `ReadSourceCodeLocation if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->sourceCodeLocation.Get();
    return mojo::internal::Deserialize<::blink::mojom::AffectedLocationDataView>(
        pointer, output, message_);
  }
 private:
  internal::UserReidentificationIssueDetails_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class InspectorIssueDetailsDataView {
 public:
  InspectorIssueDetailsDataView() = default;

  InspectorIssueDetailsDataView(
      internal::InspectorIssueDetails_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCookieIssueDetailsDataView(
      CookieIssueDetailsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCookieIssueDetails(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::CookieIssueDetailsDataView, UserType>(),
    "Attempting to read the optional `cookie_issue_details` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCookieIssueDetails` instead "
    "of `ReadCookieIssueDetails if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->cookie_issue_details.Get();
    return mojo::internal::Deserialize<::blink::mojom::CookieIssueDetailsDataView>(
        pointer, output, message_);
  }
  inline void GetMixedContentIssueDetailsDataView(
      MixedContentIssueDetailsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMixedContentIssueDetails(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::MixedContentIssueDetailsDataView, UserType>(),
    "Attempting to read the optional `mixed_content_issue_details` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMixedContentIssueDetails` instead "
    "of `ReadMixedContentIssueDetails if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->mixed_content_issue_details.Get();
    return mojo::internal::Deserialize<::blink::mojom::MixedContentIssueDetailsDataView>(
        pointer, output, message_);
  }
  inline void GetBlockedByResponseIssueDetailsDataView(
      BlockedByResponseIssueDetailsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBlockedByResponseIssueDetails(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::BlockedByResponseIssueDetailsDataView, UserType>(),
    "Attempting to read the optional `blocked_by_response_issue_details` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBlockedByResponseIssueDetails` instead "
    "of `ReadBlockedByResponseIssueDetails if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->blocked_by_response_issue_details.Get();
    return mojo::internal::Deserialize<::blink::mojom::BlockedByResponseIssueDetailsDataView>(
        pointer, output, message_);
  }
  inline void GetCspIssueDetailsDataView(
      ContentSecurityPolicyIssueDetailsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCspIssueDetails(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ContentSecurityPolicyIssueDetailsDataView, UserType>(),
    "Attempting to read the optional `csp_issue_details` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCspIssueDetails` instead "
    "of `ReadCspIssueDetails if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->csp_issue_details.Get();
    return mojo::internal::Deserialize<::blink::mojom::ContentSecurityPolicyIssueDetailsDataView>(
        pointer, output, message_);
  }
  inline void GetSabIssueDetailsDataView(
      SharedArrayBufferIssueDetailsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSabIssueDetails(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::SharedArrayBufferIssueDetailsDataView, UserType>(),
    "Attempting to read the optional `sab_issue_details` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSabIssueDetails` instead "
    "of `ReadSabIssueDetails if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->sab_issue_details.Get();
    return mojo::internal::Deserialize<::blink::mojom::SharedArrayBufferIssueDetailsDataView>(
        pointer, output, message_);
  }
  inline void GetHeavyAdIssueDetailsDataView(
      HeavyAdIssueDetailsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHeavyAdIssueDetails(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::HeavyAdIssueDetailsDataView, UserType>(),
    "Attempting to read the optional `heavy_ad_issue_details` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadHeavyAdIssueDetails` instead "
    "of `ReadHeavyAdIssueDetails if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->heavy_ad_issue_details.Get();
    return mojo::internal::Deserialize<::blink::mojom::HeavyAdIssueDetailsDataView>(
        pointer, output, message_);
  }
  inline void GetAttributionReportingIssueDetailsDataView(
      AttributionReportingIssueDetailsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAttributionReportingIssueDetails(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AttributionReportingIssueDetailsDataView, UserType>(),
    "Attempting to read the optional `attribution_reporting_issue_details` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAttributionReportingIssueDetails` instead "
    "of `ReadAttributionReportingIssueDetails if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->attribution_reporting_issue_details.Get();
    return mojo::internal::Deserialize<::blink::mojom::AttributionReportingIssueDetailsDataView>(
        pointer, output, message_);
  }
  inline void GetLowTextContrastDetailsDataView(
      LowTextContrastIssueDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLowTextContrastDetails(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::LowTextContrastIssueDataView, UserType>(),
    "Attempting to read the optional `low_text_contrast_details` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLowTextContrastDetails` instead "
    "of `ReadLowTextContrastDetails if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->low_text_contrast_details.Get();
    return mojo::internal::Deserialize<::blink::mojom::LowTextContrastIssueDataView>(
        pointer, output, message_);
  }
  inline void GetFederatedAuthRequestDetailsDataView(
      FederatedAuthRequestIssueDetailsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFederatedAuthRequestDetails(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::FederatedAuthRequestIssueDetailsDataView, UserType>(),
    "Attempting to read the optional `federated_auth_request_details` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFederatedAuthRequestDetails` instead "
    "of `ReadFederatedAuthRequestDetails if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->federated_auth_request_details.Get();
    return mojo::internal::Deserialize<::blink::mojom::FederatedAuthRequestIssueDetailsDataView>(
        pointer, output, message_);
  }
  inline void GetBounceTrackingIssueDetailsDataView(
      BounceTrackingIssueDetailsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBounceTrackingIssueDetails(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::BounceTrackingIssueDetailsDataView, UserType>(),
    "Attempting to read the optional `bounce_tracking_issue_details` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBounceTrackingIssueDetails` instead "
    "of `ReadBounceTrackingIssueDetails if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->bounce_tracking_issue_details.Get();
    return mojo::internal::Deserialize<::blink::mojom::BounceTrackingIssueDetailsDataView>(
        pointer, output, message_);
  }
  inline void GetPartitioningBlobUrlIssueDetailsDataView(
      PartitioningBlobURLIssueDetailsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPartitioningBlobUrlIssueDetails(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PartitioningBlobURLIssueDetailsDataView, UserType>(),
    "Attempting to read the optional `partitioning_blob_url_issue_details` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPartitioningBlobUrlIssueDetails` instead "
    "of `ReadPartitioningBlobUrlIssueDetails if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->partitioning_blob_url_issue_details.Get();
    return mojo::internal::Deserialize<::blink::mojom::PartitioningBlobURLIssueDetailsDataView>(
        pointer, output, message_);
  }
  inline void GetCookieDeprecationMetadataIssueDetailsDataView(
      CookieDeprecationMetadataIssueDetailsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCookieDeprecationMetadataIssueDetails(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::CookieDeprecationMetadataIssueDetailsDataView, UserType>(),
    "Attempting to read the optional `cookie_deprecation_metadata_issue_details` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCookieDeprecationMetadataIssueDetails` instead "
    "of `ReadCookieDeprecationMetadataIssueDetails if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->cookie_deprecation_metadata_issue_details.Get();
    return mojo::internal::Deserialize<::blink::mojom::CookieDeprecationMetadataIssueDetailsDataView>(
        pointer, output, message_);
  }
  inline void GetGenericIssueDetailsDataView(
      GenericIssueDetailsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGenericIssueDetails(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::GenericIssueDetailsDataView, UserType>(),
    "Attempting to read the optional `generic_issue_details` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadGenericIssueDetails` instead "
    "of `ReadGenericIssueDetails if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->generic_issue_details.Get();
    return mojo::internal::Deserialize<::blink::mojom::GenericIssueDetailsDataView>(
        pointer, output, message_);
  }
  inline void GetDeprecationIssueDetailsDataView(
      DeprecationIssueDetailsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDeprecationIssueDetails(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::DeprecationIssueDetailsDataView, UserType>(),
    "Attempting to read the optional `deprecation_issue_details` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDeprecationIssueDetails` instead "
    "of `ReadDeprecationIssueDetails if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->deprecation_issue_details.Get();
    return mojo::internal::Deserialize<::blink::mojom::DeprecationIssueDetailsDataView>(
        pointer, output, message_);
  }
  inline void GetFederatedAuthUserInfoRequestDetailsDataView(
      FederatedAuthUserInfoRequestIssueDetailsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFederatedAuthUserInfoRequestDetails(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::FederatedAuthUserInfoRequestIssueDetailsDataView, UserType>(),
    "Attempting to read the optional `federated_auth_user_info_request_details` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFederatedAuthUserInfoRequestDetails` instead "
    "of `ReadFederatedAuthUserInfoRequestDetails if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->federated_auth_user_info_request_details.Get();
    return mojo::internal::Deserialize<::blink::mojom::FederatedAuthUserInfoRequestIssueDetailsDataView>(
        pointer, output, message_);
  }
  inline void GetUserReidentificationIssueDetailsDataView(
      UserReidentificationIssueDetailsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUserReidentificationIssueDetails(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::UserReidentificationIssueDetailsDataView, UserType>(),
    "Attempting to read the optional `user_reidentification_issue_details` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUserReidentificationIssueDetails` instead "
    "of `ReadUserReidentificationIssueDetails if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->user_reidentification_issue_details.Get();
    return mojo::internal::Deserialize<::blink::mojom::UserReidentificationIssueDetailsDataView>(
        pointer, output, message_);
  }
  inline void GetIssueIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIssueId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `issue_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadIssueId` instead "
    "of `ReadIssueId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->issue_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::InspectorIssueDetails_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class InspectorIssueInfoDataView {
 public:
  InspectorIssueInfoDataView() = default;

  InspectorIssueInfoDataView(
      internal::InspectorIssueInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadCode(UserType* output) const {
    auto data_value = data_->code;
    return mojo::internal::Deserialize<::blink::mojom::InspectorIssueCode>(
        data_value, output);
  }
  InspectorIssueCode code() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::InspectorIssueCode>(data_->code));
  }
  inline void GetDetailsDataView(
      InspectorIssueDetailsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDetails(UserType* output) {
    
    auto* pointer = data_->details.Get();
    return mojo::internal::Deserialize<::blink::mojom::InspectorIssueDetailsDataView>(
        pointer, output, message_);
  }
 private:
  internal::InspectorIssueInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_DEVTOOLS_INSPECTOR_ISSUE_MOJOM_DATA_VIEW_H_