// third_party/blink/public/mojom/devtools/devtools_frontend.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('mojoBase.mojom.DictionaryValue');






goog.provide('blink.mojom.DevToolsFrontend');
goog.provide('blink.mojom.DevToolsFrontendReceiver');
goog.provide('blink.mojom.DevToolsFrontendCallbackRouter');
goog.provide('blink.mojom.DevToolsFrontendInterface');
goog.provide('blink.mojom.DevToolsFrontendRemote');
goog.provide('blink.mojom.DevToolsFrontendPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.DevToolsFrontendPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.DevToolsFrontend.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.DevToolsFrontendInterface = class {
  
  /**
   * @param { !string } apiScript
   * @param { !Object } host
   */

  setupDevToolsFrontend(apiScript, host) {}
  
  /**
   * @param { !string } extensionApi
   */

  setupDevToolsExtensionAPI(extensionApi) {}
};

/**
 * @export
 * @implements { blink.mojom.DevToolsFrontendInterface }
 */
blink.mojom.DevToolsFrontendRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.DevToolsFrontendPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.DevToolsFrontendPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.DevToolsFrontendPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } apiScript
   * @param { !Object } host
   */

  setupDevToolsFrontend(
      apiScript,
      host) {
    this.proxy.sendMessage(
        0,
        blink.mojom.DevToolsFrontend_SetupDevToolsFrontend_ParamsSpec.$,
        null,
        [
          apiScript,
          host
        ],
        false);
  }

  
  /**
   * @param { !string } extensionApi
   */

  setupDevToolsExtensionAPI(
      extensionApi) {
    this.proxy.sendMessage(
        1,
        blink.mojom.DevToolsFrontend_SetupDevToolsExtensionAPI_ParamsSpec.$,
        null,
        [
          extensionApi
        ],
        false);
  }
};

/**
 * An object which receives request messages for the DevToolsFrontend
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.DevToolsFrontendReceiver = class {
  /**
   * @param {!blink.mojom.DevToolsFrontendInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.DevToolsFrontendRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.DevToolsFrontendRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.DevToolsFrontendRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.DevToolsFrontend_SetupDevToolsFrontend_ParamsSpec.$,
        null,
        impl.setupDevToolsFrontend.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.DevToolsFrontend_SetupDevToolsExtensionAPI_ParamsSpec.$,
        null,
        impl.setupDevToolsExtensionAPI.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.DevToolsFrontend = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.DevToolsFrontend";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.DevToolsFrontendRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.DevToolsFrontendRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the DevToolsFrontend
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.DevToolsFrontendCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.DevToolsFrontendRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.DevToolsFrontendRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setupDevToolsFrontend =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.DevToolsFrontend_SetupDevToolsFrontend_ParamsSpec.$,
        null,
        this.setupDevToolsFrontend.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setupDevToolsExtensionAPI =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.DevToolsFrontend_SetupDevToolsExtensionAPI_ParamsSpec.$,
        null,
        this.setupDevToolsExtensionAPI.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.DevToolsFrontendHost');
goog.provide('blink.mojom.DevToolsFrontendHostReceiver');
goog.provide('blink.mojom.DevToolsFrontendHostCallbackRouter');
goog.provide('blink.mojom.DevToolsFrontendHostInterface');
goog.provide('blink.mojom.DevToolsFrontendHostRemote');
goog.provide('blink.mojom.DevToolsFrontendHostPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.DevToolsFrontendHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.DevToolsFrontendHost.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.DevToolsFrontendHostInterface = class {
  
  /**
   * @param { !mojoBase.mojom.DictionaryValue } message
   */

  dispatchEmbedderMessage(message) {}
};

/**
 * @export
 * @implements { blink.mojom.DevToolsFrontendHostInterface }
 */
blink.mojom.DevToolsFrontendHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.DevToolsFrontendHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.DevToolsFrontendHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.DevToolsFrontendHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !mojoBase.mojom.DictionaryValue } message
   */

  dispatchEmbedderMessage(
      message) {
    this.proxy.sendMessage(
        0,
        blink.mojom.DevToolsFrontendHost_DispatchEmbedderMessage_ParamsSpec.$,
        null,
        [
          message
        ],
        false);
  }
};

/**
 * An object which receives request messages for the DevToolsFrontendHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.DevToolsFrontendHostReceiver = class {
  /**
   * @param {!blink.mojom.DevToolsFrontendHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.DevToolsFrontendHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.DevToolsFrontendHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.DevToolsFrontendHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.DevToolsFrontendHost_DispatchEmbedderMessage_ParamsSpec.$,
        null,
        impl.dispatchEmbedderMessage.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.DevToolsFrontendHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.DevToolsFrontendHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.DevToolsFrontendHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.DevToolsFrontendHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the DevToolsFrontendHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.DevToolsFrontendHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.DevToolsFrontendHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.DevToolsFrontendHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchEmbedderMessage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.DevToolsFrontendHost_DispatchEmbedderMessage_ParamsSpec.$,
        null,
        this.dispatchEmbedderMessage.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.DevToolsFrontend_SetupDevToolsFrontend_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DevToolsFrontend_SetupDevToolsFrontend_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.DevToolsFrontend_SetupDevToolsExtensionAPI_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DevToolsFrontend_SetupDevToolsExtensionAPI_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.DevToolsFrontendHost_DispatchEmbedderMessage_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DevToolsFrontendHost_DispatchEmbedderMessage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.DevToolsFrontend_SetupDevToolsFrontend_ParamsSpec.$,
    'DevToolsFrontend_SetupDevToolsFrontend_Params',
    [
      mojo.internal.StructField(
        'apiScript', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'host', 8,
        0,
        mojo.internal.AssociatedInterfaceProxy(blink.mojom.DevToolsFrontendHostRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.DevToolsFrontend_SetupDevToolsFrontend_Params');

/** @record */
blink.mojom.DevToolsFrontend_SetupDevToolsFrontend_Params = class {
  constructor() {
    /** @export { !string } */
    this.apiScript;
    /** @export { !Object } */
    this.host;
  }
};



mojo.internal.Struct(
    blink.mojom.DevToolsFrontend_SetupDevToolsExtensionAPI_ParamsSpec.$,
    'DevToolsFrontend_SetupDevToolsExtensionAPI_Params',
    [
      mojo.internal.StructField(
        'extensionApi', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.DevToolsFrontend_SetupDevToolsExtensionAPI_Params');

/** @record */
blink.mojom.DevToolsFrontend_SetupDevToolsExtensionAPI_Params = class {
  constructor() {
    /** @export { !string } */
    this.extensionApi;
  }
};



mojo.internal.Struct(
    blink.mojom.DevToolsFrontendHost_DispatchEmbedderMessage_ParamsSpec.$,
    'DevToolsFrontendHost_DispatchEmbedderMessage_Params',
    [
      mojo.internal.StructField(
        'message', 0,
        0,
        mojoBase.mojom.DictionaryValueSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.DevToolsFrontendHost_DispatchEmbedderMessage_Params');

/** @record */
blink.mojom.DevToolsFrontendHost_DispatchEmbedderMessage_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.DictionaryValue } */
    this.message;
  }
};

