// third_party/blink/public/mojom/devtools/devtools_frontend.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/devtools/devtools_frontend.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/devtools/devtools_frontend.mojom-params-data.h"
#include "third_party/blink/public/mojom/devtools/devtools_frontend.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/devtools/devtools_frontend.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/devtools/devtools_frontend.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
// The declaration includes the definition on other builds.

DevToolsFrontend::IPCStableHashFunction DevToolsFrontend::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DevToolsFrontend>(message.name())) {
    case messages::DevToolsFrontend::kSetupDevToolsFrontend: {
      return &DevToolsFrontend::SetupDevToolsFrontend_Sym::IPCStableHash;
    }
    case messages::DevToolsFrontend::kSetupDevToolsExtensionAPI: {
      return &DevToolsFrontend::SetupDevToolsExtensionAPI_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DevToolsFrontend::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DevToolsFrontend>(message.name())) {
      case messages::DevToolsFrontend::kSetupDevToolsFrontend:
            return "Receive blink::mojom::DevToolsFrontend::SetupDevToolsFrontend";
      case messages::DevToolsFrontend::kSetupDevToolsExtensionAPI:
            return "Receive blink::mojom::DevToolsFrontend::SetupDevToolsExtensionAPI";
    }
  } else {
    switch (static_cast<messages::DevToolsFrontend>(message.name())) {
      case messages::DevToolsFrontend::kSetupDevToolsFrontend:
            return "Receive reply blink::mojom::DevToolsFrontend::SetupDevToolsFrontend";
      case messages::DevToolsFrontend::kSetupDevToolsExtensionAPI:
            return "Receive reply blink::mojom::DevToolsFrontend::SetupDevToolsExtensionAPI";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DevToolsFrontend::SetupDevToolsFrontend_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x028e13da;  // IPCStableHash for blink::mojom::DevToolsFrontend::SetupDevToolsFrontend
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DevToolsFrontend::SetupDevToolsExtensionAPI_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xde03295e;  // IPCStableHash for blink::mojom::DevToolsFrontend::SetupDevToolsExtensionAPI
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

DevToolsFrontendProxy::DevToolsFrontendProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DevToolsFrontendProxy::SetupDevToolsFrontend(
    const ::blink::String& in_api_script, ::mojo::PendingAssociatedRemote<DevToolsFrontendHost> in_host) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::DevToolsFrontend::SetupDevToolsFrontend", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("api_script"), in_api_script,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host"), in_host,
                        "<value of type ::mojo::PendingAssociatedRemote<DevToolsFrontendHost>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevToolsFrontend::kSetupDevToolsFrontend), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DevToolsFrontend_SetupDevToolsFrontend_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->api_script)::BaseType> api_script_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_api_script,
    api_script_fragment);

  params->api_script.Set(
      api_script_fragment.is_null() ? nullptr : api_script_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->api_script.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null api_script in DevToolsFrontend.SetupDevToolsFrontend request");

  
  mojo::internal::Serialize<::blink::mojom::DevToolsFrontendHostAssociatedPtrInfoDataView>(
    in_host,
    &params->host,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->host)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid host in DevToolsFrontend.SetupDevToolsFrontend request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevToolsFrontend::Name_);
  message.set_method_name("SetupDevToolsFrontend");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DevToolsFrontendProxy::SetupDevToolsExtensionAPI(
    const ::blink::String& in_extension_api) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::DevToolsFrontend::SetupDevToolsExtensionAPI", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_api"), in_extension_api,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevToolsFrontend::kSetupDevToolsExtensionAPI), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DevToolsFrontend_SetupDevToolsExtensionAPI_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_api)::BaseType> extension_api_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_extension_api,
    extension_api_fragment);

  params->extension_api.Set(
      extension_api_fragment.is_null() ? nullptr : extension_api_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->extension_api.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null extension_api in DevToolsFrontend.SetupDevToolsExtensionAPI request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevToolsFrontend::Name_);
  message.set_method_name("SetupDevToolsExtensionAPI");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool DevToolsFrontendStubDispatch::Accept(
    DevToolsFrontend* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DevToolsFrontend>(message->header()->name)) {
    case messages::DevToolsFrontend::kSetupDevToolsFrontend: {
      DCHECK(message->is_serialized());
      internal::DevToolsFrontend_SetupDevToolsFrontend_Params_Data* params =
          reinterpret_cast<internal::DevToolsFrontend_SetupDevToolsFrontend_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DevToolsFrontend.0
      bool success = true;
      ::blink::String p_api_script{};
      ::mojo::PendingAssociatedRemote<DevToolsFrontendHost> p_host{};
      DevToolsFrontend_SetupDevToolsFrontend_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadApiScript(&p_api_script))
        success = false;
      if (success) {
        p_host =
            input_data_view.TakeHost<decltype(p_host)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevToolsFrontend::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetupDevToolsFrontend(        
        std::move(p_api_script), 
        std::move(p_host));
      return true;
    }
    case messages::DevToolsFrontend::kSetupDevToolsExtensionAPI: {
      DCHECK(message->is_serialized());
      internal::DevToolsFrontend_SetupDevToolsExtensionAPI_Params_Data* params =
          reinterpret_cast<internal::DevToolsFrontend_SetupDevToolsExtensionAPI_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DevToolsFrontend.1
      bool success = true;
      ::blink::String p_extension_api{};
      DevToolsFrontend_SetupDevToolsExtensionAPI_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionApi(&p_extension_api))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevToolsFrontend::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetupDevToolsExtensionAPI(        
        std::move(p_extension_api));
      return true;
    }
  }
  return false;
}

// static
bool DevToolsFrontendStubDispatch::AcceptWithResponder(
    DevToolsFrontend* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DevToolsFrontend>(message->header()->name)) {
    case messages::DevToolsFrontend::kSetupDevToolsFrontend: {
      break;
    }
    case messages::DevToolsFrontend::kSetupDevToolsExtensionAPI: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kDevToolsFrontendValidationInfo[] = {
    { &internal::DevToolsFrontend_SetupDevToolsFrontend_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DevToolsFrontend_SetupDevToolsExtensionAPI_Params_Data::Validate,
     nullptr /* no response */},
};

bool DevToolsFrontendRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::DevToolsFrontend::Name_,
    kDevToolsFrontendValidationInfo);
}

// The declaration includes the definition on other builds.

DevToolsFrontendHost::IPCStableHashFunction DevToolsFrontendHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DevToolsFrontendHost>(message.name())) {
    case messages::DevToolsFrontendHost::kDispatchEmbedderMessage: {
      return &DevToolsFrontendHost::DispatchEmbedderMessage_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DevToolsFrontendHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DevToolsFrontendHost>(message.name())) {
      case messages::DevToolsFrontendHost::kDispatchEmbedderMessage:
            return "Receive blink::mojom::DevToolsFrontendHost::DispatchEmbedderMessage";
    }
  } else {
    switch (static_cast<messages::DevToolsFrontendHost>(message.name())) {
      case messages::DevToolsFrontendHost::kDispatchEmbedderMessage:
            return "Receive reply blink::mojom::DevToolsFrontendHost::DispatchEmbedderMessage";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DevToolsFrontendHost::DispatchEmbedderMessage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x27338c01;  // IPCStableHash for blink::mojom::DevToolsFrontendHost::DispatchEmbedderMessage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

DevToolsFrontendHostProxy::DevToolsFrontendHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DevToolsFrontendHostProxy::DispatchEmbedderMessage(
    ::base::Value::Dict in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::DevToolsFrontendHost::DispatchEmbedderMessage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type ::base::Value::Dict>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevToolsFrontendHost::kDispatchEmbedderMessage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DevToolsFrontendHost_DispatchEmbedderMessage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::DictionaryValueDataView>(
    in_message,
    message_fragment);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in DevToolsFrontendHost.DispatchEmbedderMessage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevToolsFrontendHost::Name_);
  message.set_method_name("DispatchEmbedderMessage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool DevToolsFrontendHostStubDispatch::Accept(
    DevToolsFrontendHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DevToolsFrontendHost>(message->header()->name)) {
    case messages::DevToolsFrontendHost::kDispatchEmbedderMessage: {
      DCHECK(message->is_serialized());
      internal::DevToolsFrontendHost_DispatchEmbedderMessage_Params_Data* params =
          reinterpret_cast<internal::DevToolsFrontendHost_DispatchEmbedderMessage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DevToolsFrontendHost.0
      bool success = true;
      ::base::Value::Dict p_message{};
      DevToolsFrontendHost_DispatchEmbedderMessage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevToolsFrontendHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchEmbedderMessage(        
        std::move(p_message));
      return true;
    }
  }
  return false;
}

// static
bool DevToolsFrontendHostStubDispatch::AcceptWithResponder(
    DevToolsFrontendHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DevToolsFrontendHost>(message->header()->name)) {
    case messages::DevToolsFrontendHost::kDispatchEmbedderMessage: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kDevToolsFrontendHostValidationInfo[] = {
    { &internal::DevToolsFrontendHost_DispatchEmbedderMessage_Params_Data::Validate,
     nullptr /* no response */},
};

bool DevToolsFrontendHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::DevToolsFrontendHost::Name_,
    kDevToolsFrontendHostValidationInfo);
}



}  // blink::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void DevToolsFrontendInterceptorForTesting::SetupDevToolsFrontend(const ::blink::String& api_script, ::mojo::PendingAssociatedRemote<DevToolsFrontendHost> host) {
  GetForwardingInterface()->SetupDevToolsFrontend(
    std::move(api_script)
    , 
    std::move(host)
    );
}
void DevToolsFrontendInterceptorForTesting::SetupDevToolsExtensionAPI(const ::blink::String& extension_api) {
  GetForwardingInterface()->SetupDevToolsExtensionAPI(
    std::move(extension_api)
    );
}
DevToolsFrontendAsyncWaiter::DevToolsFrontendAsyncWaiter(
    DevToolsFrontend* proxy) : proxy_(proxy) {}

DevToolsFrontendAsyncWaiter::~DevToolsFrontendAsyncWaiter() = default;





void DevToolsFrontendHostInterceptorForTesting::DispatchEmbedderMessage(::base::Value::Dict message) {
  GetForwardingInterface()->DispatchEmbedderMessage(
    std::move(message)
    );
}
DevToolsFrontendHostAsyncWaiter::DevToolsFrontendHostAsyncWaiter(
    DevToolsFrontendHost* proxy) : proxy_(proxy) {}

DevToolsFrontendHostAsyncWaiter::~DevToolsFrontendHostAsyncWaiter() = default;







}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif