// third_party/blink/public/mojom/devtools/devtools_agent.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_DEVTOOLS_DEVTOOLS_AGENT_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_DEVTOOLS_DEVTOOLS_AGENT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/devtools/devtools_agent.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/devtools/devtools_agent.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/devtools/devtools_agent.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/big_buffer.mojom.h"
#include "mojo/public/mojom/base/read_only_buffer.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class DevToolsAgentProxy;

template <typename ImplRefTraits>
class DevToolsAgentStub;

class DevToolsAgentRequestValidator;
class DevToolsAgentResponseValidator;


class BLINK_COMMON_EXPORT DevToolsAgent
    : public DevToolsAgentInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.DevToolsAgent";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DevToolsAgentInterfaceBase;
  using Proxy_ = DevToolsAgentProxy;

  template <typename ImplRefTraits>
  using Stub_ = DevToolsAgentStub<ImplRefTraits>;

  using RequestValidator_ = DevToolsAgentRequestValidator;
  using ResponseValidator_ = DevToolsAgentResponseValidator;
  enum MethodMinVersions : uint32_t {
    kAttachDevToolsSessionMinVersion = 0,
    kInspectElementMinVersion = 0,
    kReportChildTargetsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct AttachDevToolsSession_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct InspectElement_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReportChildTargets_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~DevToolsAgent() = default;

  virtual void AttachDevToolsSession(::mojo::PendingAssociatedRemote<DevToolsSessionHost> host, ::mojo::PendingAssociatedReceiver<DevToolsSession> session, ::mojo::PendingReceiver<DevToolsSession> io_session, DevToolsSessionStatePtr reattach_session_state, const std::string& script_to_evaluate_on_load, bool client_expects_binary_responses, bool client_is_trusted, const std::string& session_id, bool session_waits_for_debugger) = 0;

  virtual void InspectElement(const ::gfx::Point& point) = 0;

  using ReportChildTargetsCallback = base::OnceCallback<void()>;
  using ReportChildTargetsMojoCallback = base::OnceCallback<void()>;

  virtual void ReportChildTargets(bool report, bool wait_for_debugger, ReportChildTargetsCallback callback) = 0;
};

class DevToolsAgentHostProxy;

template <typename ImplRefTraits>
class DevToolsAgentHostStub;

class DevToolsAgentHostRequestValidator;


class BLINK_COMMON_EXPORT DevToolsAgentHost
    : public DevToolsAgentHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.DevToolsAgentHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DevToolsAgentHostInterfaceBase;
  using Proxy_ = DevToolsAgentHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = DevToolsAgentHostStub<ImplRefTraits>;

  using RequestValidator_ = DevToolsAgentHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kChildTargetCreatedMinVersion = 0,
    kMainThreadDebuggerPausedMinVersion = 0,
    kMainThreadDebuggerResumedMinVersion = 0,
    kBringToForegroundMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ChildTargetCreated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MainThreadDebuggerPaused_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MainThreadDebuggerResumed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BringToForeground_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~DevToolsAgentHost() = default;

  virtual void ChildTargetCreated(::mojo::PendingRemote<DevToolsAgent> worker_devtools_agent, ::mojo::PendingReceiver<DevToolsAgentHost> worker_devtools_agent_host, const ::GURL& url, const std::string& name, const ::base::UnguessableToken& devtools_worker_token, bool waiting_for_debugger, DevToolsExecutionContextType context_type) = 0;

  virtual void MainThreadDebuggerPaused() = 0;

  virtual void MainThreadDebuggerResumed() = 0;

  virtual void BringToForeground() = 0;
};

class DevToolsSessionProxy;

template <typename ImplRefTraits>
class DevToolsSessionStub;

class DevToolsSessionRequestValidator;


class BLINK_COMMON_EXPORT DevToolsSession
    : public DevToolsSessionInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.DevToolsSession";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DevToolsSessionInterfaceBase;
  using Proxy_ = DevToolsSessionProxy;

  template <typename ImplRefTraits>
  using Stub_ = DevToolsSessionStub<ImplRefTraits>;

  using RequestValidator_ = DevToolsSessionRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kDispatchProtocolCommandMinVersion = 0,
    kUnpauseAndTerminateMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct DispatchProtocolCommand_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UnpauseAndTerminate_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~DevToolsSession() = default;

  virtual void DispatchProtocolCommand(int32_t call_id, const std::string& method, ::base::span<const ::uint8_t> message) = 0;

  virtual void UnpauseAndTerminate() = 0;
};

class DevToolsSessionHostProxy;

template <typename ImplRefTraits>
class DevToolsSessionHostStub;

class DevToolsSessionHostRequestValidator;


class BLINK_COMMON_EXPORT DevToolsSessionHost
    : public DevToolsSessionHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.DevToolsSessionHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DevToolsSessionHostInterfaceBase;
  using Proxy_ = DevToolsSessionHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = DevToolsSessionHostStub<ImplRefTraits>;

  using RequestValidator_ = DevToolsSessionHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kDispatchProtocolResponseMinVersion = 0,
    kDispatchProtocolNotificationMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct DispatchProtocolResponse_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DispatchProtocolNotification_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~DevToolsSessionHost() = default;

  virtual void DispatchProtocolResponse(DevToolsMessagePtr message, int32_t call_id, DevToolsSessionStatePtr updates) = 0;

  virtual void DispatchProtocolNotification(DevToolsMessagePtr message, DevToolsSessionStatePtr updates) = 0;
};



class BLINK_COMMON_EXPORT DevToolsAgentProxy
    : public DevToolsAgent {
 public:
  using InterfaceType = DevToolsAgent;

  explicit DevToolsAgentProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void AttachDevToolsSession(::mojo::PendingAssociatedRemote<DevToolsSessionHost> host, ::mojo::PendingAssociatedReceiver<DevToolsSession> session, ::mojo::PendingReceiver<DevToolsSession> io_session, DevToolsSessionStatePtr reattach_session_state, const std::string& script_to_evaluate_on_load, bool client_expects_binary_responses, bool client_is_trusted, const std::string& session_id, bool session_waits_for_debugger) final;
  
  void InspectElement(const ::gfx::Point& point) final;
  
  void ReportChildTargets(bool report, bool wait_for_debugger, ReportChildTargetsCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT DevToolsAgentHostProxy
    : public DevToolsAgentHost {
 public:
  using InterfaceType = DevToolsAgentHost;

  explicit DevToolsAgentHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ChildTargetCreated(::mojo::PendingRemote<DevToolsAgent> worker_devtools_agent, ::mojo::PendingReceiver<DevToolsAgentHost> worker_devtools_agent_host, const ::GURL& url, const std::string& name, const ::base::UnguessableToken& devtools_worker_token, bool waiting_for_debugger, DevToolsExecutionContextType context_type) final;
  
  void MainThreadDebuggerPaused() final;
  
  void MainThreadDebuggerResumed() final;
  
  void BringToForeground() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT DevToolsSessionProxy
    : public DevToolsSession {
 public:
  using InterfaceType = DevToolsSession;

  explicit DevToolsSessionProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void DispatchProtocolCommand(int32_t call_id, const std::string& method, ::base::span<const ::uint8_t> message) final;
  
  void UnpauseAndTerminate() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT DevToolsSessionHostProxy
    : public DevToolsSessionHost {
 public:
  using InterfaceType = DevToolsSessionHost;

  explicit DevToolsSessionHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void DispatchProtocolResponse(DevToolsMessagePtr message, int32_t call_id, DevToolsSessionStatePtr updates) final;
  
  void DispatchProtocolNotification(DevToolsMessagePtr message, DevToolsSessionStatePtr updates) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT DevToolsAgentStubDispatch {
 public:
  static bool Accept(DevToolsAgent* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DevToolsAgent* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DevToolsAgent>>
class DevToolsAgentStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DevToolsAgentStub() = default;
  ~DevToolsAgentStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DevToolsAgentStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DevToolsAgentStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT DevToolsAgentHostStubDispatch {
 public:
  static bool Accept(DevToolsAgentHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DevToolsAgentHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DevToolsAgentHost>>
class DevToolsAgentHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DevToolsAgentHostStub() = default;
  ~DevToolsAgentHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DevToolsAgentHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DevToolsAgentHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT DevToolsSessionStubDispatch {
 public:
  static bool Accept(DevToolsSession* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DevToolsSession* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DevToolsSession>>
class DevToolsSessionStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DevToolsSessionStub() = default;
  ~DevToolsSessionStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DevToolsSessionStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DevToolsSessionStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT DevToolsSessionHostStubDispatch {
 public:
  static bool Accept(DevToolsSessionHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DevToolsSessionHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DevToolsSessionHost>>
class DevToolsSessionHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DevToolsSessionHostStub() = default;
  ~DevToolsSessionHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DevToolsSessionHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DevToolsSessionHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT DevToolsAgentRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT DevToolsAgentHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT DevToolsSessionRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT DevToolsSessionHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT DevToolsAgentResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class BLINK_COMMON_EXPORT DevToolsMessage {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DevToolsMessage, T>::value>;
  using DataView = DevToolsMessageDataView;
  using Data_ = internal::DevToolsMessage_Data;

  template <typename... Args>
  static DevToolsMessagePtr New(Args&&... args) {
    return DevToolsMessagePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DevToolsMessagePtr From(const U& u) {
    return mojo::TypeConverter<DevToolsMessagePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DevToolsMessage>::Convert(*this);
  }


  DevToolsMessage();

  explicit DevToolsMessage(
      ::mojo_base::BigBuffer data);

DevToolsMessage(const DevToolsMessage&) = delete;
DevToolsMessage& operator=(const DevToolsMessage&) = delete;

  ~DevToolsMessage();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DevToolsMessagePtr>
  DevToolsMessagePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DevToolsMessage::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DevToolsMessage::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DevToolsMessage::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DevToolsMessage::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DevToolsMessage_UnserializedMessageContext<
            UserType, DevToolsMessage::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DevToolsMessage::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DevToolsMessage::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DevToolsMessage_UnserializedMessageContext<
            UserType, DevToolsMessage::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DevToolsMessage::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo_base::BigBuffer data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DevToolsMessage::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DevToolsMessage::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DevToolsMessage::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DevToolsMessage::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT DevToolsSessionState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DevToolsSessionState, T>::value>;
  using DataView = DevToolsSessionStateDataView;
  using Data_ = internal::DevToolsSessionState_Data;

  template <typename... Args>
  static DevToolsSessionStatePtr New(Args&&... args) {
    return DevToolsSessionStatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DevToolsSessionStatePtr From(const U& u) {
    return mojo::TypeConverter<DevToolsSessionStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DevToolsSessionState>::Convert(*this);
  }


  DevToolsSessionState();

  explicit DevToolsSessionState(
      const base::flat_map<std::string, std::optional<std::vector<uint8_t>>>& entries);


  ~DevToolsSessionState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DevToolsSessionStatePtr>
  DevToolsSessionStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DevToolsSessionState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DevToolsSessionState::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DevToolsSessionState::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DevToolsSessionState::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DevToolsSessionState::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DevToolsSessionState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DevToolsSessionState_UnserializedMessageContext<
            UserType, DevToolsSessionState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DevToolsSessionState::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DevToolsSessionState::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DevToolsSessionState_UnserializedMessageContext<
            UserType, DevToolsSessionState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DevToolsSessionState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  base::flat_map<std::string, std::optional<std::vector<uint8_t>>> entries;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DevToolsSessionState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DevToolsSessionState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DevToolsSessionState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DevToolsSessionState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
DevToolsMessagePtr DevToolsMessage::Clone() const {
  return New(
      mojo::Clone(data)
  );
}

template <typename T, DevToolsMessage::EnableIfSame<T>*>
bool DevToolsMessage::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  return true;
}

template <typename T, DevToolsMessage::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  return false;
}
template <typename StructPtrType>
DevToolsSessionStatePtr DevToolsSessionState::Clone() const {
  return New(
      mojo::Clone(entries)
  );
}

template <typename T, DevToolsSessionState::EnableIfSame<T>*>
bool DevToolsSessionState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->entries, other_struct.entries))
    return false;
  return true;
}

template <typename T, DevToolsSessionState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.entries < rhs.entries)
    return true;
  if (rhs.entries < lhs.entries)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::DevToolsMessage::DataView,
                                         ::blink::mojom::DevToolsMessagePtr> {
  static bool IsNull(const ::blink::mojom::DevToolsMessagePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::DevToolsMessagePtr* output) { output->reset(); }

  static  decltype(::blink::mojom::DevToolsMessage::data)& data(
       ::blink::mojom::DevToolsMessagePtr& input) {
    return input->data;
  }

  static bool Read(::blink::mojom::DevToolsMessage::DataView input, ::blink::mojom::DevToolsMessagePtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::DevToolsSessionState::DataView,
                                         ::blink::mojom::DevToolsSessionStatePtr> {
  static bool IsNull(const ::blink::mojom::DevToolsSessionStatePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::DevToolsSessionStatePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::DevToolsSessionState::entries)& entries(
      const ::blink::mojom::DevToolsSessionStatePtr& input) {
    return input->entries;
  }

  static bool Read(::blink::mojom::DevToolsSessionState::DataView input, ::blink::mojom::DevToolsSessionStatePtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_DEVTOOLS_DEVTOOLS_AGENT_MOJOM_H_