// third_party/blink/public/mojom/devtools/devtools_agent.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/devtools/devtools_agent.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/devtools/devtools_agent.mojom-params-data.h"
#include "third_party/blink/public/mojom/devtools/devtools_agent.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/devtools/devtools_agent.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/devtools/devtools_agent.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
DevToolsMessage::DevToolsMessage()
    : data() {}

DevToolsMessage::DevToolsMessage(
    ::mojo_base::BigBuffer data_in)
    : data(std::move(data_in)) {}

DevToolsMessage::~DevToolsMessage() = default;

void DevToolsMessage::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo_base::BigBuffer>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DevToolsMessage::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DevToolsSessionState::DevToolsSessionState()
    : entries() {}

DevToolsSessionState::DevToolsSessionState(
    const ::blink::HashMap<::blink::String, std::optional<::blink::Vector<uint8_t>>>& entries_in)
    : entries(std::move(entries_in)) {}

DevToolsSessionState::~DevToolsSessionState() = default;

void DevToolsSessionState::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "entries"), this->entries,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::HashMap<::blink::String, std::optional<::blink::Vector<uint8_t>>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DevToolsSessionState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

DevToolsAgent::IPCStableHashFunction DevToolsAgent::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DevToolsAgent>(message.name())) {
    case messages::DevToolsAgent::kAttachDevToolsSession: {
      return &DevToolsAgent::AttachDevToolsSession_Sym::IPCStableHash;
    }
    case messages::DevToolsAgent::kInspectElement: {
      return &DevToolsAgent::InspectElement_Sym::IPCStableHash;
    }
    case messages::DevToolsAgent::kReportChildTargets: {
      return &DevToolsAgent::ReportChildTargets_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DevToolsAgent::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DevToolsAgent>(message.name())) {
      case messages::DevToolsAgent::kAttachDevToolsSession:
            return "Receive blink::mojom::DevToolsAgent::AttachDevToolsSession";
      case messages::DevToolsAgent::kInspectElement:
            return "Receive blink::mojom::DevToolsAgent::InspectElement";
      case messages::DevToolsAgent::kReportChildTargets:
            return "Receive blink::mojom::DevToolsAgent::ReportChildTargets";
    }
  } else {
    switch (static_cast<messages::DevToolsAgent>(message.name())) {
      case messages::DevToolsAgent::kAttachDevToolsSession:
            return "Receive reply blink::mojom::DevToolsAgent::AttachDevToolsSession";
      case messages::DevToolsAgent::kInspectElement:
            return "Receive reply blink::mojom::DevToolsAgent::InspectElement";
      case messages::DevToolsAgent::kReportChildTargets:
            return "Receive reply blink::mojom::DevToolsAgent::ReportChildTargets";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DevToolsAgent::AttachDevToolsSession_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd1559bbe;  // IPCStableHash for blink::mojom::DevToolsAgent::AttachDevToolsSession
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DevToolsAgent::InspectElement_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x027c2076;  // IPCStableHash for blink::mojom::DevToolsAgent::InspectElement
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DevToolsAgent::ReportChildTargets_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9e6dfb15;  // IPCStableHash for blink::mojom::DevToolsAgent::ReportChildTargets
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class DevToolsAgent_ReportChildTargets_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DevToolsAgent_ReportChildTargets_ForwardToCallback(
      DevToolsAgent::ReportChildTargetsCallback callback
      ) : callback_(std::move(callback)) {
  }

  DevToolsAgent_ReportChildTargets_ForwardToCallback(const DevToolsAgent_ReportChildTargets_ForwardToCallback&) = delete;
  DevToolsAgent_ReportChildTargets_ForwardToCallback& operator=(const DevToolsAgent_ReportChildTargets_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  DevToolsAgent::ReportChildTargetsCallback callback_;
};

DevToolsAgentProxy::DevToolsAgentProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DevToolsAgentProxy::AttachDevToolsSession(
    ::mojo::PendingAssociatedRemote<DevToolsSessionHost> in_host, ::mojo::PendingAssociatedReceiver<DevToolsSession> in_session, ::mojo::PendingReceiver<DevToolsSession> in_io_session, DevToolsSessionStatePtr in_reattach_session_state, const ::blink::String& in_script_to_evaluate_on_load, bool in_client_expects_binary_responses, bool in_client_is_trusted, const ::blink::String& in_session_id, bool in_session_waits_for_debugger) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::DevToolsAgent::AttachDevToolsSession", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host"), in_host,
                        "<value of type ::mojo::PendingAssociatedRemote<DevToolsSessionHost>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session"), in_session,
                        "<value of type ::mojo::PendingAssociatedReceiver<DevToolsSession>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("io_session"), in_io_session,
                        "<value of type ::mojo::PendingReceiver<DevToolsSession>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reattach_session_state"), in_reattach_session_state,
                        "<value of type DevToolsSessionStatePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("script_to_evaluate_on_load"), in_script_to_evaluate_on_load,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_expects_binary_responses"), in_client_expects_binary_responses,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_is_trusted"), in_client_is_trusted,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_id"), in_session_id,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_waits_for_debugger"), in_session_waits_for_debugger,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevToolsAgent::kAttachDevToolsSession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DevToolsAgent_AttachDevToolsSession_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::DevToolsSessionHostAssociatedPtrInfoDataView>(
    in_host,
    &params->host,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->host)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid host in DevToolsAgent.AttachDevToolsSession request");

  
  mojo::internal::Serialize<::blink::mojom::DevToolsSessionAssociatedRequestDataView>(
    in_session,
    &params->session,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->session)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid session in DevToolsAgent.AttachDevToolsSession request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::DevToolsSessionInterfaceBase>>(
    in_io_session,
    &params->io_session,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->io_session)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid io_session in DevToolsAgent.AttachDevToolsSession request");
  mojo::internal::MessageFragment<
      typename decltype(params->reattach_session_state)::BaseType> reattach_session_state_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::DevToolsSessionStateDataView>(
    in_reattach_session_state,
    reattach_session_state_fragment);

  params->reattach_session_state.Set(
      reattach_session_state_fragment.is_null() ? nullptr : reattach_session_state_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->script_to_evaluate_on_load)::BaseType> script_to_evaluate_on_load_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_script_to_evaluate_on_load,
    script_to_evaluate_on_load_fragment);

  params->script_to_evaluate_on_load.Set(
      script_to_evaluate_on_load_fragment.is_null() ? nullptr : script_to_evaluate_on_load_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->script_to_evaluate_on_load.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null script_to_evaluate_on_load in DevToolsAgent.AttachDevToolsSession request");

  params->client_expects_binary_responses = in_client_expects_binary_responses;

  params->client_is_trusted = in_client_is_trusted;
  mojo::internal::MessageFragment<
      typename decltype(params->session_id)::BaseType> session_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_session_id,
    session_id_fragment);

  params->session_id.Set(
      session_id_fragment.is_null() ? nullptr : session_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->session_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null session_id in DevToolsAgent.AttachDevToolsSession request");

  params->session_waits_for_debugger = in_session_waits_for_debugger;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevToolsAgent::Name_);
  message.set_method_name("AttachDevToolsSession");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DevToolsAgentProxy::InspectElement(
    const ::gfx::Point& in_point) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::DevToolsAgent::InspectElement", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("point"), in_point,
                        "<value of type const ::gfx::Point&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevToolsAgent::kInspectElement), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DevToolsAgent_InspectElement_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->point)::BaseType> point_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointDataView>(
    in_point,
    point_fragment);

  params->point.Set(
      point_fragment.is_null() ? nullptr : point_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->point.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null point in DevToolsAgent.InspectElement request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevToolsAgent::Name_);
  message.set_method_name("InspectElement");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DevToolsAgentProxy::ReportChildTargets(
    bool in_report, bool in_wait_for_debugger, ReportChildTargetsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::DevToolsAgent::ReportChildTargets", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("report"), in_report,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("wait_for_debugger"), in_wait_for_debugger,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevToolsAgent::kReportChildTargets), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DevToolsAgent_ReportChildTargets_Params_Data> params(
          message);
  params.Allocate();

  params->report = in_report;

  params->wait_for_debugger = in_wait_for_debugger;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevToolsAgent::Name_);
  message.set_method_name("ReportChildTargets");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DevToolsAgent_ReportChildTargets_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class DevToolsAgent_ReportChildTargets_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static DevToolsAgent::ReportChildTargetsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<DevToolsAgent_ReportChildTargets_ProxyToResponder> proxy(
        new DevToolsAgent_ReportChildTargets_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&DevToolsAgent_ReportChildTargets_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DevToolsAgent_ReportChildTargets_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  DevToolsAgent_ReportChildTargets_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "DevToolsAgent::ReportChildTargetsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool DevToolsAgent_ReportChildTargets_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::DevToolsAgent_ReportChildTargets_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DevToolsAgent_ReportChildTargets_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for DevToolsAgent.2
  bool success = true;
  DevToolsAgent_ReportChildTargets_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DevToolsAgent::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void DevToolsAgent_ReportChildTargets_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply blink::mojom::DevToolsAgent::ReportChildTargets");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevToolsAgent::kReportChildTargets), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DevToolsAgent_ReportChildTargets_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevToolsAgent::Name_);
  message.set_method_name("ReportChildTargets");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool DevToolsAgentStubDispatch::Accept(
    DevToolsAgent* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DevToolsAgent>(message->header()->name)) {
    case messages::DevToolsAgent::kAttachDevToolsSession: {
      DCHECK(message->is_serialized());
      internal::DevToolsAgent_AttachDevToolsSession_Params_Data* params =
          reinterpret_cast<internal::DevToolsAgent_AttachDevToolsSession_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DevToolsAgent.0
      bool success = true;
      ::mojo::PendingAssociatedRemote<DevToolsSessionHost> p_host{};
      ::mojo::PendingAssociatedReceiver<DevToolsSession> p_session{};
      ::mojo::PendingReceiver<DevToolsSession> p_io_session{};
      DevToolsSessionStatePtr p_reattach_session_state{};
      ::blink::String p_script_to_evaluate_on_load{};
      bool p_client_expects_binary_responses{};
      bool p_client_is_trusted{};
      ::blink::String p_session_id{};
      bool p_session_waits_for_debugger{};
      DevToolsAgent_AttachDevToolsSession_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_host =
            input_data_view.TakeHost<decltype(p_host)>();
      }
      if (success) {
        p_session =
            input_data_view.TakeSession<decltype(p_session)>();
      }
      if (success) {
        p_io_session =
            input_data_view.TakeIoSession<decltype(p_io_session)>();
      }
      if (success && !input_data_view.ReadReattachSessionState(&p_reattach_session_state))
        success = false;
      if (success && !input_data_view.ReadScriptToEvaluateOnLoad(&p_script_to_evaluate_on_load))
        success = false;
      if (success)
        p_client_expects_binary_responses = input_data_view.client_expects_binary_responses();
      if (success)
        p_client_is_trusted = input_data_view.client_is_trusted();
      if (success && !input_data_view.ReadSessionId(&p_session_id))
        success = false;
      if (success)
        p_session_waits_for_debugger = input_data_view.session_waits_for_debugger();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevToolsAgent::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AttachDevToolsSession(        
        std::move(p_host), 
        std::move(p_session), 
        std::move(p_io_session), 
        std::move(p_reattach_session_state), 
        std::move(p_script_to_evaluate_on_load), 
        std::move(p_client_expects_binary_responses), 
        std::move(p_client_is_trusted), 
        std::move(p_session_id), 
        std::move(p_session_waits_for_debugger));
      return true;
    }
    case messages::DevToolsAgent::kInspectElement: {
      DCHECK(message->is_serialized());
      internal::DevToolsAgent_InspectElement_Params_Data* params =
          reinterpret_cast<internal::DevToolsAgent_InspectElement_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DevToolsAgent.1
      bool success = true;
      ::gfx::Point p_point{};
      DevToolsAgent_InspectElement_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPoint(&p_point))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevToolsAgent::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InspectElement(        
        std::move(p_point));
      return true;
    }
    case messages::DevToolsAgent::kReportChildTargets: {
      break;
    }
  }
  return false;
}

// static
bool DevToolsAgentStubDispatch::AcceptWithResponder(
    DevToolsAgent* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DevToolsAgent>(message->header()->name)) {
    case messages::DevToolsAgent::kAttachDevToolsSession: {
      break;
    }
    case messages::DevToolsAgent::kInspectElement: {
      break;
    }
    case messages::DevToolsAgent::kReportChildTargets: {
      internal::DevToolsAgent_ReportChildTargets_Params_Data* params =
          reinterpret_cast<
              internal::DevToolsAgent_ReportChildTargets_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for DevToolsAgent.2
      bool success = true;
      bool p_report{};
      bool p_wait_for_debugger{};
      DevToolsAgent_ReportChildTargets_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_report = input_data_view.report();
      if (success)
        p_wait_for_debugger = input_data_view.wait_for_debugger();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevToolsAgent::Name_, 2, false);
        return false;
      }
      auto callback =
          DevToolsAgent_ReportChildTargets_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReportChildTargets(        
        std::move(p_report), 
        std::move(p_wait_for_debugger), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kDevToolsAgentValidationInfo[] = {
    { &internal::DevToolsAgent_AttachDevToolsSession_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DevToolsAgent_InspectElement_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DevToolsAgent_ReportChildTargets_Params_Data::Validate,
     &internal::DevToolsAgent_ReportChildTargets_ResponseParams_Data::Validate},
};

bool DevToolsAgentRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::DevToolsAgent::Name_,
    kDevToolsAgentValidationInfo);
}

bool DevToolsAgentResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::DevToolsAgent::Name_,
    kDevToolsAgentValidationInfo);
}
// The declaration includes the definition on other builds.

DevToolsAgentHost::IPCStableHashFunction DevToolsAgentHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DevToolsAgentHost>(message.name())) {
    case messages::DevToolsAgentHost::kChildTargetCreated: {
      return &DevToolsAgentHost::ChildTargetCreated_Sym::IPCStableHash;
    }
    case messages::DevToolsAgentHost::kMainThreadDebuggerPaused: {
      return &DevToolsAgentHost::MainThreadDebuggerPaused_Sym::IPCStableHash;
    }
    case messages::DevToolsAgentHost::kMainThreadDebuggerResumed: {
      return &DevToolsAgentHost::MainThreadDebuggerResumed_Sym::IPCStableHash;
    }
    case messages::DevToolsAgentHost::kBringToForeground: {
      return &DevToolsAgentHost::BringToForeground_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DevToolsAgentHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DevToolsAgentHost>(message.name())) {
      case messages::DevToolsAgentHost::kChildTargetCreated:
            return "Receive blink::mojom::DevToolsAgentHost::ChildTargetCreated";
      case messages::DevToolsAgentHost::kMainThreadDebuggerPaused:
            return "Receive blink::mojom::DevToolsAgentHost::MainThreadDebuggerPaused";
      case messages::DevToolsAgentHost::kMainThreadDebuggerResumed:
            return "Receive blink::mojom::DevToolsAgentHost::MainThreadDebuggerResumed";
      case messages::DevToolsAgentHost::kBringToForeground:
            return "Receive blink::mojom::DevToolsAgentHost::BringToForeground";
    }
  } else {
    switch (static_cast<messages::DevToolsAgentHost>(message.name())) {
      case messages::DevToolsAgentHost::kChildTargetCreated:
            return "Receive reply blink::mojom::DevToolsAgentHost::ChildTargetCreated";
      case messages::DevToolsAgentHost::kMainThreadDebuggerPaused:
            return "Receive reply blink::mojom::DevToolsAgentHost::MainThreadDebuggerPaused";
      case messages::DevToolsAgentHost::kMainThreadDebuggerResumed:
            return "Receive reply blink::mojom::DevToolsAgentHost::MainThreadDebuggerResumed";
      case messages::DevToolsAgentHost::kBringToForeground:
            return "Receive reply blink::mojom::DevToolsAgentHost::BringToForeground";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DevToolsAgentHost::ChildTargetCreated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb8e64e57;  // IPCStableHash for blink::mojom::DevToolsAgentHost::ChildTargetCreated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DevToolsAgentHost::MainThreadDebuggerPaused_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfaa76405;  // IPCStableHash for blink::mojom::DevToolsAgentHost::MainThreadDebuggerPaused
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DevToolsAgentHost::MainThreadDebuggerResumed_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7d0dc9f5;  // IPCStableHash for blink::mojom::DevToolsAgentHost::MainThreadDebuggerResumed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DevToolsAgentHost::BringToForeground_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7505b13f;  // IPCStableHash for blink::mojom::DevToolsAgentHost::BringToForeground
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

DevToolsAgentHostProxy::DevToolsAgentHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DevToolsAgentHostProxy::ChildTargetCreated(
    ::mojo::PendingRemote<DevToolsAgent> in_worker_devtools_agent, ::mojo::PendingReceiver<DevToolsAgentHost> in_worker_devtools_agent_host, const ::blink::KURL& in_url, const ::blink::String& in_name, const ::base::UnguessableToken& in_devtools_worker_token, bool in_waiting_for_debugger, DevToolsExecutionContextType in_context_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::DevToolsAgentHost::ChildTargetCreated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("worker_devtools_agent"), in_worker_devtools_agent,
                        "<value of type ::mojo::PendingRemote<DevToolsAgent>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("worker_devtools_agent_host"), in_worker_devtools_agent_host,
                        "<value of type ::mojo::PendingReceiver<DevToolsAgentHost>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devtools_worker_token"), in_devtools_worker_token,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("waiting_for_debugger"), in_waiting_for_debugger,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("context_type"), in_context_type,
                        "<value of type DevToolsExecutionContextType>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevToolsAgentHost::kChildTargetCreated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DevToolsAgentHost_ChildTargetCreated_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::DevToolsAgentInterfaceBase>>(
    in_worker_devtools_agent,
    &params->worker_devtools_agent,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->worker_devtools_agent)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid worker_devtools_agent in DevToolsAgentHost.ChildTargetCreated request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::DevToolsAgentHostInterfaceBase>>(
    in_worker_devtools_agent_host,
    &params->worker_devtools_agent_host,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->worker_devtools_agent_host)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid worker_devtools_agent_host in DevToolsAgentHost.ChildTargetCreated request");
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in DevToolsAgentHost.ChildTargetCreated request");
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_name,
    name_fragment);

  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null name in DevToolsAgentHost.ChildTargetCreated request");
  mojo::internal::MessageFragment<
      typename decltype(params->devtools_worker_token)::BaseType> devtools_worker_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_devtools_worker_token,
    devtools_worker_token_fragment);

  params->devtools_worker_token.Set(
      devtools_worker_token_fragment.is_null() ? nullptr : devtools_worker_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->devtools_worker_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null devtools_worker_token in DevToolsAgentHost.ChildTargetCreated request");

  params->waiting_for_debugger = in_waiting_for_debugger;

  
  mojo::internal::Serialize<::blink::mojom::DevToolsExecutionContextType>(
    in_context_type,
    &params->context_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevToolsAgentHost::Name_);
  message.set_method_name("ChildTargetCreated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DevToolsAgentHostProxy::MainThreadDebuggerPaused(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::DevToolsAgentHost::MainThreadDebuggerPaused");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevToolsAgentHost::kMainThreadDebuggerPaused), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DevToolsAgentHost_MainThreadDebuggerPaused_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevToolsAgentHost::Name_);
  message.set_method_name("MainThreadDebuggerPaused");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DevToolsAgentHostProxy::MainThreadDebuggerResumed(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::DevToolsAgentHost::MainThreadDebuggerResumed");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevToolsAgentHost::kMainThreadDebuggerResumed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DevToolsAgentHost_MainThreadDebuggerResumed_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevToolsAgentHost::Name_);
  message.set_method_name("MainThreadDebuggerResumed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DevToolsAgentHostProxy::BringToForeground(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::DevToolsAgentHost::BringToForeground");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevToolsAgentHost::kBringToForeground), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DevToolsAgentHost_BringToForeground_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevToolsAgentHost::Name_);
  message.set_method_name("BringToForeground");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool DevToolsAgentHostStubDispatch::Accept(
    DevToolsAgentHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DevToolsAgentHost>(message->header()->name)) {
    case messages::DevToolsAgentHost::kChildTargetCreated: {
      DCHECK(message->is_serialized());
      internal::DevToolsAgentHost_ChildTargetCreated_Params_Data* params =
          reinterpret_cast<internal::DevToolsAgentHost_ChildTargetCreated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DevToolsAgentHost.0
      bool success = true;
      ::mojo::PendingRemote<DevToolsAgent> p_worker_devtools_agent{};
      ::mojo::PendingReceiver<DevToolsAgentHost> p_worker_devtools_agent_host{};
      ::blink::KURL p_url{};
      ::blink::String p_name{};
      ::base::UnguessableToken p_devtools_worker_token{};
      bool p_waiting_for_debugger{};
      DevToolsExecutionContextType p_context_type{};
      DevToolsAgentHost_ChildTargetCreated_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_worker_devtools_agent =
            input_data_view.TakeWorkerDevtoolsAgent<decltype(p_worker_devtools_agent)>();
      }
      if (success) {
        p_worker_devtools_agent_host =
            input_data_view.TakeWorkerDevtoolsAgentHost<decltype(p_worker_devtools_agent_host)>();
      }
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (success && !input_data_view.ReadDevtoolsWorkerToken(&p_devtools_worker_token))
        success = false;
      if (success)
        p_waiting_for_debugger = input_data_view.waiting_for_debugger();
      if (success && !input_data_view.ReadContextType(&p_context_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevToolsAgentHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ChildTargetCreated(        
        std::move(p_worker_devtools_agent), 
        std::move(p_worker_devtools_agent_host), 
        std::move(p_url), 
        std::move(p_name), 
        std::move(p_devtools_worker_token), 
        std::move(p_waiting_for_debugger), 
        std::move(p_context_type));
      return true;
    }
    case messages::DevToolsAgentHost::kMainThreadDebuggerPaused: {
      DCHECK(message->is_serialized());
      internal::DevToolsAgentHost_MainThreadDebuggerPaused_Params_Data* params =
          reinterpret_cast<internal::DevToolsAgentHost_MainThreadDebuggerPaused_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DevToolsAgentHost.1
      bool success = true;
      DevToolsAgentHost_MainThreadDebuggerPaused_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevToolsAgentHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MainThreadDebuggerPaused(        );
      return true;
    }
    case messages::DevToolsAgentHost::kMainThreadDebuggerResumed: {
      DCHECK(message->is_serialized());
      internal::DevToolsAgentHost_MainThreadDebuggerResumed_Params_Data* params =
          reinterpret_cast<internal::DevToolsAgentHost_MainThreadDebuggerResumed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DevToolsAgentHost.2
      bool success = true;
      DevToolsAgentHost_MainThreadDebuggerResumed_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevToolsAgentHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MainThreadDebuggerResumed(        );
      return true;
    }
    case messages::DevToolsAgentHost::kBringToForeground: {
      DCHECK(message->is_serialized());
      internal::DevToolsAgentHost_BringToForeground_Params_Data* params =
          reinterpret_cast<internal::DevToolsAgentHost_BringToForeground_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DevToolsAgentHost.3
      bool success = true;
      DevToolsAgentHost_BringToForeground_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevToolsAgentHost::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BringToForeground(        );
      return true;
    }
  }
  return false;
}

// static
bool DevToolsAgentHostStubDispatch::AcceptWithResponder(
    DevToolsAgentHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DevToolsAgentHost>(message->header()->name)) {
    case messages::DevToolsAgentHost::kChildTargetCreated: {
      break;
    }
    case messages::DevToolsAgentHost::kMainThreadDebuggerPaused: {
      break;
    }
    case messages::DevToolsAgentHost::kMainThreadDebuggerResumed: {
      break;
    }
    case messages::DevToolsAgentHost::kBringToForeground: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kDevToolsAgentHostValidationInfo[] = {
    { &internal::DevToolsAgentHost_ChildTargetCreated_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DevToolsAgentHost_MainThreadDebuggerPaused_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DevToolsAgentHost_MainThreadDebuggerResumed_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DevToolsAgentHost_BringToForeground_Params_Data::Validate,
     nullptr /* no response */},
};

bool DevToolsAgentHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::DevToolsAgentHost::Name_,
    kDevToolsAgentHostValidationInfo);
}

// The declaration includes the definition on other builds.

DevToolsSession::IPCStableHashFunction DevToolsSession::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DevToolsSession>(message.name())) {
    case messages::DevToolsSession::kDispatchProtocolCommand: {
      return &DevToolsSession::DispatchProtocolCommand_Sym::IPCStableHash;
    }
    case messages::DevToolsSession::kUnpauseAndTerminate: {
      return &DevToolsSession::UnpauseAndTerminate_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DevToolsSession::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DevToolsSession>(message.name())) {
      case messages::DevToolsSession::kDispatchProtocolCommand:
            return "Receive blink::mojom::DevToolsSession::DispatchProtocolCommand";
      case messages::DevToolsSession::kUnpauseAndTerminate:
            return "Receive blink::mojom::DevToolsSession::UnpauseAndTerminate";
    }
  } else {
    switch (static_cast<messages::DevToolsSession>(message.name())) {
      case messages::DevToolsSession::kDispatchProtocolCommand:
            return "Receive reply blink::mojom::DevToolsSession::DispatchProtocolCommand";
      case messages::DevToolsSession::kUnpauseAndTerminate:
            return "Receive reply blink::mojom::DevToolsSession::UnpauseAndTerminate";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DevToolsSession::DispatchProtocolCommand_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd33f5552;  // IPCStableHash for blink::mojom::DevToolsSession::DispatchProtocolCommand
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DevToolsSession::UnpauseAndTerminate_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc0b7221c;  // IPCStableHash for blink::mojom::DevToolsSession::UnpauseAndTerminate
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

DevToolsSessionProxy::DevToolsSessionProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DevToolsSessionProxy::DispatchProtocolCommand(
    int32_t in_call_id, const ::blink::String& in_method, ::base::span<const ::uint8_t> in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::DevToolsSession::DispatchProtocolCommand", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("call_id"), in_call_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("method"), in_method,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type ::base::span<const ::uint8_t>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevToolsSession::kDispatchProtocolCommand), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DevToolsSession_DispatchProtocolCommand_Params_Data> params(
          message);
  params.Allocate();

  params->call_id = in_call_id;
  mojo::internal::MessageFragment<
      typename decltype(params->method)::BaseType> method_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_method,
    method_fragment);

  params->method.Set(
      method_fragment.is_null() ? nullptr : method_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->method.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null method in DevToolsSession.DispatchProtocolCommand request");
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyBufferDataView>(
    in_message,
    message_fragment);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in DevToolsSession.DispatchProtocolCommand request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevToolsSession::Name_);
  message.set_method_name("DispatchProtocolCommand");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DevToolsSessionProxy::UnpauseAndTerminate(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::DevToolsSession::UnpauseAndTerminate");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevToolsSession::kUnpauseAndTerminate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DevToolsSession_UnpauseAndTerminate_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevToolsSession::Name_);
  message.set_method_name("UnpauseAndTerminate");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool DevToolsSessionStubDispatch::Accept(
    DevToolsSession* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DevToolsSession>(message->header()->name)) {
    case messages::DevToolsSession::kDispatchProtocolCommand: {
      DCHECK(message->is_serialized());
      internal::DevToolsSession_DispatchProtocolCommand_Params_Data* params =
          reinterpret_cast<internal::DevToolsSession_DispatchProtocolCommand_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DevToolsSession.0
      bool success = true;
      int32_t p_call_id{};
      ::blink::String p_method{};
      ::base::span<const ::uint8_t> p_message{};
      DevToolsSession_DispatchProtocolCommand_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_call_id = input_data_view.call_id();
      if (success && !input_data_view.ReadMethod(&p_method))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevToolsSession::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchProtocolCommand(        
        std::move(p_call_id), 
        std::move(p_method), 
        std::move(p_message));
      return true;
    }
    case messages::DevToolsSession::kUnpauseAndTerminate: {
      DCHECK(message->is_serialized());
      internal::DevToolsSession_UnpauseAndTerminate_Params_Data* params =
          reinterpret_cast<internal::DevToolsSession_UnpauseAndTerminate_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DevToolsSession.1
      bool success = true;
      DevToolsSession_UnpauseAndTerminate_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevToolsSession::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UnpauseAndTerminate(        );
      return true;
    }
  }
  return false;
}

// static
bool DevToolsSessionStubDispatch::AcceptWithResponder(
    DevToolsSession* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DevToolsSession>(message->header()->name)) {
    case messages::DevToolsSession::kDispatchProtocolCommand: {
      break;
    }
    case messages::DevToolsSession::kUnpauseAndTerminate: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kDevToolsSessionValidationInfo[] = {
    { &internal::DevToolsSession_DispatchProtocolCommand_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DevToolsSession_UnpauseAndTerminate_Params_Data::Validate,
     nullptr /* no response */},
};

bool DevToolsSessionRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::DevToolsSession::Name_,
    kDevToolsSessionValidationInfo);
}

// The declaration includes the definition on other builds.

DevToolsSessionHost::IPCStableHashFunction DevToolsSessionHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DevToolsSessionHost>(message.name())) {
    case messages::DevToolsSessionHost::kDispatchProtocolResponse: {
      return &DevToolsSessionHost::DispatchProtocolResponse_Sym::IPCStableHash;
    }
    case messages::DevToolsSessionHost::kDispatchProtocolNotification: {
      return &DevToolsSessionHost::DispatchProtocolNotification_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DevToolsSessionHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DevToolsSessionHost>(message.name())) {
      case messages::DevToolsSessionHost::kDispatchProtocolResponse:
            return "Receive blink::mojom::DevToolsSessionHost::DispatchProtocolResponse";
      case messages::DevToolsSessionHost::kDispatchProtocolNotification:
            return "Receive blink::mojom::DevToolsSessionHost::DispatchProtocolNotification";
    }
  } else {
    switch (static_cast<messages::DevToolsSessionHost>(message.name())) {
      case messages::DevToolsSessionHost::kDispatchProtocolResponse:
            return "Receive reply blink::mojom::DevToolsSessionHost::DispatchProtocolResponse";
      case messages::DevToolsSessionHost::kDispatchProtocolNotification:
            return "Receive reply blink::mojom::DevToolsSessionHost::DispatchProtocolNotification";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DevToolsSessionHost::DispatchProtocolResponse_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfeccea9e;  // IPCStableHash for blink::mojom::DevToolsSessionHost::DispatchProtocolResponse
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DevToolsSessionHost::DispatchProtocolNotification_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xeec33ddb;  // IPCStableHash for blink::mojom::DevToolsSessionHost::DispatchProtocolNotification
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

DevToolsSessionHostProxy::DevToolsSessionHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DevToolsSessionHostProxy::DispatchProtocolResponse(
    DevToolsMessagePtr in_message, int32_t in_call_id, DevToolsSessionStatePtr in_updates) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::DevToolsSessionHost::DispatchProtocolResponse", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type DevToolsMessagePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("call_id"), in_call_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("updates"), in_updates,
                        "<value of type DevToolsSessionStatePtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevToolsSessionHost::kDispatchProtocolResponse), kFlags,
      MOJO_CREATE_MESSAGE_FLAG_UNLIMITED_SIZE,
      estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DevToolsSessionHost_DispatchProtocolResponse_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::DevToolsMessageDataView>(
    in_message,
    message_fragment);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in DevToolsSessionHost.DispatchProtocolResponse request");

  params->call_id = in_call_id;
  mojo::internal::MessageFragment<
      typename decltype(params->updates)::BaseType> updates_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::DevToolsSessionStateDataView>(
    in_updates,
    updates_fragment);

  params->updates.Set(
      updates_fragment.is_null() ? nullptr : updates_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevToolsSessionHost::Name_);
  message.set_method_name("DispatchProtocolResponse");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DevToolsSessionHostProxy::DispatchProtocolNotification(
    DevToolsMessagePtr in_message, DevToolsSessionStatePtr in_updates) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::DevToolsSessionHost::DispatchProtocolNotification", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type DevToolsMessagePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("updates"), in_updates,
                        "<value of type DevToolsSessionStatePtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevToolsSessionHost::kDispatchProtocolNotification), kFlags,
      MOJO_CREATE_MESSAGE_FLAG_UNLIMITED_SIZE,
      estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DevToolsSessionHost_DispatchProtocolNotification_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::DevToolsMessageDataView>(
    in_message,
    message_fragment);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in DevToolsSessionHost.DispatchProtocolNotification request");
  mojo::internal::MessageFragment<
      typename decltype(params->updates)::BaseType> updates_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::DevToolsSessionStateDataView>(
    in_updates,
    updates_fragment);

  params->updates.Set(
      updates_fragment.is_null() ? nullptr : updates_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevToolsSessionHost::Name_);
  message.set_method_name("DispatchProtocolNotification");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool DevToolsSessionHostStubDispatch::Accept(
    DevToolsSessionHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DevToolsSessionHost>(message->header()->name)) {
    case messages::DevToolsSessionHost::kDispatchProtocolResponse: {
      DCHECK(message->is_serialized());
      internal::DevToolsSessionHost_DispatchProtocolResponse_Params_Data* params =
          reinterpret_cast<internal::DevToolsSessionHost_DispatchProtocolResponse_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DevToolsSessionHost.0
      bool success = true;
      DevToolsMessagePtr p_message{};
      int32_t p_call_id{};
      DevToolsSessionStatePtr p_updates{};
      DevToolsSessionHost_DispatchProtocolResponse_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (success)
        p_call_id = input_data_view.call_id();
      if (success && !input_data_view.ReadUpdates(&p_updates))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevToolsSessionHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchProtocolResponse(        
        std::move(p_message), 
        std::move(p_call_id), 
        std::move(p_updates));
      return true;
    }
    case messages::DevToolsSessionHost::kDispatchProtocolNotification: {
      DCHECK(message->is_serialized());
      internal::DevToolsSessionHost_DispatchProtocolNotification_Params_Data* params =
          reinterpret_cast<internal::DevToolsSessionHost_DispatchProtocolNotification_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DevToolsSessionHost.1
      bool success = true;
      DevToolsMessagePtr p_message{};
      DevToolsSessionStatePtr p_updates{};
      DevToolsSessionHost_DispatchProtocolNotification_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (success && !input_data_view.ReadUpdates(&p_updates))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevToolsSessionHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchProtocolNotification(        
        std::move(p_message), 
        std::move(p_updates));
      return true;
    }
  }
  return false;
}

// static
bool DevToolsSessionHostStubDispatch::AcceptWithResponder(
    DevToolsSessionHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DevToolsSessionHost>(message->header()->name)) {
    case messages::DevToolsSessionHost::kDispatchProtocolResponse: {
      break;
    }
    case messages::DevToolsSessionHost::kDispatchProtocolNotification: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kDevToolsSessionHostValidationInfo[] = {
    { &internal::DevToolsSessionHost_DispatchProtocolResponse_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DevToolsSessionHost_DispatchProtocolNotification_Params_Data::Validate,
     nullptr /* no response */},
};

bool DevToolsSessionHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::DevToolsSessionHost::Name_,
    kDevToolsSessionHostValidationInfo);
}



}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::DevToolsMessage::DataView, ::blink::mojom::blink::DevToolsMessagePtr>::Read(
    ::blink::mojom::blink::DevToolsMessage::DataView input,
    ::blink::mojom::blink::DevToolsMessagePtr* output) {
  bool success = true;
  ::blink::mojom::blink::DevToolsMessagePtr result(::blink::mojom::blink::DevToolsMessage::New());
  
      if (success && !input.ReadData(&result->data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::DevToolsSessionState::DataView, ::blink::mojom::blink::DevToolsSessionStatePtr>::Read(
    ::blink::mojom::blink::DevToolsSessionState::DataView input,
    ::blink::mojom::blink::DevToolsSessionStatePtr* output) {
  bool success = true;
  ::blink::mojom::blink::DevToolsSessionStatePtr result(::blink::mojom::blink::DevToolsSessionState::New());
  
      if (success && !input.ReadEntries(&result->entries))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void DevToolsAgentInterceptorForTesting::AttachDevToolsSession(::mojo::PendingAssociatedRemote<DevToolsSessionHost> host, ::mojo::PendingAssociatedReceiver<DevToolsSession> session, ::mojo::PendingReceiver<DevToolsSession> io_session, DevToolsSessionStatePtr reattach_session_state, const ::blink::String& script_to_evaluate_on_load, bool client_expects_binary_responses, bool client_is_trusted, const ::blink::String& session_id, bool session_waits_for_debugger) {
  GetForwardingInterface()->AttachDevToolsSession(
    std::move(host)
    , 
    std::move(session)
    , 
    std::move(io_session)
    , 
    std::move(reattach_session_state)
    , 
    std::move(script_to_evaluate_on_load)
    , 
    std::move(client_expects_binary_responses)
    , 
    std::move(client_is_trusted)
    , 
    std::move(session_id)
    , 
    std::move(session_waits_for_debugger)
    );
}
void DevToolsAgentInterceptorForTesting::InspectElement(const ::gfx::Point& point) {
  GetForwardingInterface()->InspectElement(
    std::move(point)
    );
}
void DevToolsAgentInterceptorForTesting::ReportChildTargets(bool report, bool wait_for_debugger, ReportChildTargetsCallback callback) {
  GetForwardingInterface()->ReportChildTargets(
    std::move(report)
    , 
    std::move(wait_for_debugger)
    , std::move(callback));
}
DevToolsAgentAsyncWaiter::DevToolsAgentAsyncWaiter(
    DevToolsAgent* proxy) : proxy_(proxy) {}

DevToolsAgentAsyncWaiter::~DevToolsAgentAsyncWaiter() = default;


void DevToolsAgentAsyncWaiter::ReportChildTargets(
    bool report, bool wait_for_debugger) {
  base::RunLoop loop;
  proxy_->ReportChildTargets(
      std::move(report),
      std::move(wait_for_debugger),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}






void DevToolsAgentHostInterceptorForTesting::ChildTargetCreated(::mojo::PendingRemote<DevToolsAgent> worker_devtools_agent, ::mojo::PendingReceiver<DevToolsAgentHost> worker_devtools_agent_host, const ::blink::KURL& url, const ::blink::String& name, const ::base::UnguessableToken& devtools_worker_token, bool waiting_for_debugger, DevToolsExecutionContextType context_type) {
  GetForwardingInterface()->ChildTargetCreated(
    std::move(worker_devtools_agent)
    , 
    std::move(worker_devtools_agent_host)
    , 
    std::move(url)
    , 
    std::move(name)
    , 
    std::move(devtools_worker_token)
    , 
    std::move(waiting_for_debugger)
    , 
    std::move(context_type)
    );
}
void DevToolsAgentHostInterceptorForTesting::MainThreadDebuggerPaused() {
  GetForwardingInterface()->MainThreadDebuggerPaused();
}
void DevToolsAgentHostInterceptorForTesting::MainThreadDebuggerResumed() {
  GetForwardingInterface()->MainThreadDebuggerResumed();
}
void DevToolsAgentHostInterceptorForTesting::BringToForeground() {
  GetForwardingInterface()->BringToForeground();
}
DevToolsAgentHostAsyncWaiter::DevToolsAgentHostAsyncWaiter(
    DevToolsAgentHost* proxy) : proxy_(proxy) {}

DevToolsAgentHostAsyncWaiter::~DevToolsAgentHostAsyncWaiter() = default;





void DevToolsSessionInterceptorForTesting::DispatchProtocolCommand(int32_t call_id, const ::blink::String& method, ::base::span<const ::uint8_t> message) {
  GetForwardingInterface()->DispatchProtocolCommand(
    std::move(call_id)
    , 
    std::move(method)
    , 
    std::move(message)
    );
}
void DevToolsSessionInterceptorForTesting::UnpauseAndTerminate() {
  GetForwardingInterface()->UnpauseAndTerminate();
}
DevToolsSessionAsyncWaiter::DevToolsSessionAsyncWaiter(
    DevToolsSession* proxy) : proxy_(proxy) {}

DevToolsSessionAsyncWaiter::~DevToolsSessionAsyncWaiter() = default;





void DevToolsSessionHostInterceptorForTesting::DispatchProtocolResponse(DevToolsMessagePtr message, int32_t call_id, DevToolsSessionStatePtr updates) {
  GetForwardingInterface()->DispatchProtocolResponse(
    std::move(message)
    , 
    std::move(call_id)
    , 
    std::move(updates)
    );
}
void DevToolsSessionHostInterceptorForTesting::DispatchProtocolNotification(DevToolsMessagePtr message, DevToolsSessionStatePtr updates) {
  GetForwardingInterface()->DispatchProtocolNotification(
    std::move(message)
    , 
    std::move(updates)
    );
}
DevToolsSessionHostAsyncWaiter::DevToolsSessionHostAsyncWaiter(
    DevToolsSessionHost* proxy) : proxy_(proxy) {}

DevToolsSessionHostAsyncWaiter::~DevToolsSessionHostAsyncWaiter() = default;







}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif