// third_party/blink/public/mojom/device/device.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_DEVICE_DEVICE_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_DEVICE_DEVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/device/device.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/device/device.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/device/device.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class ManagedConfigurationObserverProxy;

template <typename ImplRefTraits>
class ManagedConfigurationObserverStub;

class ManagedConfigurationObserverRequestValidator;


class BLINK_COMMON_EXPORT ManagedConfigurationObserver
    : public ManagedConfigurationObserverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.ManagedConfigurationObserver";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ManagedConfigurationObserverInterfaceBase;
  using Proxy_ = ManagedConfigurationObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = ManagedConfigurationObserverStub<ImplRefTraits>;

  using RequestValidator_ = ManagedConfigurationObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnConfigurationChangedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnConfigurationChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ManagedConfigurationObserver() = default;

  virtual void OnConfigurationChanged() = 0;
};

class DeviceAPIServiceProxy;

template <typename ImplRefTraits>
class DeviceAPIServiceStub;

class DeviceAPIServiceRequestValidator;
class DeviceAPIServiceResponseValidator;


class BLINK_COMMON_EXPORT DeviceAPIService
    : public DeviceAPIServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.DeviceAPIService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DeviceAPIServiceInterfaceBase;
  using Proxy_ = DeviceAPIServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = DeviceAPIServiceStub<ImplRefTraits>;

  using RequestValidator_ = DeviceAPIServiceRequestValidator;
  using ResponseValidator_ = DeviceAPIServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetDirectoryIdMinVersion = 0,
    kGetHostnameMinVersion = 0,
    kGetSerialNumberMinVersion = 0,
    kGetAnnotatedAssetIdMinVersion = 0,
    kGetAnnotatedLocationMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetDirectoryId_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetHostname_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetSerialNumber_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetAnnotatedAssetId_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetAnnotatedLocation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~DeviceAPIService() = default;

  using GetDirectoryIdCallback = base::OnceCallback<void(DeviceAttributeResultPtr)>;
  using GetDirectoryIdMojoCallback = base::OnceCallback<void(DeviceAttributeResultPtr)>;

  virtual void GetDirectoryId(GetDirectoryIdCallback callback) = 0;

  using GetHostnameCallback = base::OnceCallback<void(DeviceAttributeResultPtr)>;
  using GetHostnameMojoCallback = base::OnceCallback<void(DeviceAttributeResultPtr)>;

  virtual void GetHostname(GetHostnameCallback callback) = 0;

  using GetSerialNumberCallback = base::OnceCallback<void(DeviceAttributeResultPtr)>;
  using GetSerialNumberMojoCallback = base::OnceCallback<void(DeviceAttributeResultPtr)>;

  virtual void GetSerialNumber(GetSerialNumberCallback callback) = 0;

  using GetAnnotatedAssetIdCallback = base::OnceCallback<void(DeviceAttributeResultPtr)>;
  using GetAnnotatedAssetIdMojoCallback = base::OnceCallback<void(DeviceAttributeResultPtr)>;

  virtual void GetAnnotatedAssetId(GetAnnotatedAssetIdCallback callback) = 0;

  using GetAnnotatedLocationCallback = base::OnceCallback<void(DeviceAttributeResultPtr)>;
  using GetAnnotatedLocationMojoCallback = base::OnceCallback<void(DeviceAttributeResultPtr)>;

  virtual void GetAnnotatedLocation(GetAnnotatedLocationCallback callback) = 0;
};

class ManagedConfigurationServiceProxy;

template <typename ImplRefTraits>
class ManagedConfigurationServiceStub;

class ManagedConfigurationServiceRequestValidator;
class ManagedConfigurationServiceResponseValidator;


class BLINK_COMMON_EXPORT ManagedConfigurationService
    : public ManagedConfigurationServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.ManagedConfigurationService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ManagedConfigurationServiceInterfaceBase;
  using Proxy_ = ManagedConfigurationServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = ManagedConfigurationServiceStub<ImplRefTraits>;

  using RequestValidator_ = ManagedConfigurationServiceRequestValidator;
  using ResponseValidator_ = ManagedConfigurationServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetManagedConfigurationMinVersion = 0,
    kSubscribeToManagedConfigurationMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetManagedConfiguration_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SubscribeToManagedConfiguration_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ManagedConfigurationService() = default;

  using GetManagedConfigurationCallback = base::OnceCallback<void(const std::optional<base::flat_map<std::string, std::string>>&)>;
  using GetManagedConfigurationMojoCallback = base::OnceCallback<void(const std::optional<base::flat_map<std::string, std::string>>&)>;

  virtual void GetManagedConfiguration(const std::vector<std::string>& keys, GetManagedConfigurationCallback callback) = 0;

  virtual void SubscribeToManagedConfiguration(::mojo::PendingRemote<ManagedConfigurationObserver> observer) = 0;
};



class BLINK_COMMON_EXPORT ManagedConfigurationObserverProxy
    : public ManagedConfigurationObserver {
 public:
  using InterfaceType = ManagedConfigurationObserver;

  explicit ManagedConfigurationObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnConfigurationChanged() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT DeviceAPIServiceProxy
    : public DeviceAPIService {
 public:
  using InterfaceType = DeviceAPIService;

  explicit DeviceAPIServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetDirectoryId(GetDirectoryIdCallback callback) final;
  
  void GetHostname(GetHostnameCallback callback) final;
  
  void GetSerialNumber(GetSerialNumberCallback callback) final;
  
  void GetAnnotatedAssetId(GetAnnotatedAssetIdCallback callback) final;
  
  void GetAnnotatedLocation(GetAnnotatedLocationCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT ManagedConfigurationServiceProxy
    : public ManagedConfigurationService {
 public:
  using InterfaceType = ManagedConfigurationService;

  explicit ManagedConfigurationServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetManagedConfiguration(const std::vector<std::string>& keys, GetManagedConfigurationCallback callback) final;
  
  void SubscribeToManagedConfiguration(::mojo::PendingRemote<ManagedConfigurationObserver> observer) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT ManagedConfigurationObserverStubDispatch {
 public:
  static bool Accept(ManagedConfigurationObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ManagedConfigurationObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ManagedConfigurationObserver>>
class ManagedConfigurationObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ManagedConfigurationObserverStub() = default;
  ~ManagedConfigurationObserverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ManagedConfigurationObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ManagedConfigurationObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT DeviceAPIServiceStubDispatch {
 public:
  static bool Accept(DeviceAPIService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DeviceAPIService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DeviceAPIService>>
class DeviceAPIServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DeviceAPIServiceStub() = default;
  ~DeviceAPIServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DeviceAPIServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DeviceAPIServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT ManagedConfigurationServiceStubDispatch {
 public:
  static bool Accept(ManagedConfigurationService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ManagedConfigurationService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ManagedConfigurationService>>
class ManagedConfigurationServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ManagedConfigurationServiceStub() = default;
  ~ManagedConfigurationServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ManagedConfigurationServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ManagedConfigurationServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT ManagedConfigurationObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT DeviceAPIServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT ManagedConfigurationServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT DeviceAPIServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT ManagedConfigurationServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class BLINK_COMMON_EXPORT DeviceAttributeResult {
 public:
  using DataView = DeviceAttributeResultDataView;
  using Data_ = internal::DeviceAttributeResult_Data;
  using Tag = Data_::DeviceAttributeResult_Tag;

  template <typename... Args>
  static DeviceAttributeResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |error_message|.
  static DeviceAttributeResultPtr NewErrorMessage(
      const std::string& value);
  // Construct an instance holding |attribute|.
  static DeviceAttributeResultPtr NewAttribute(
      const std::optional<std::string>& value);

  template <typename U>
  static DeviceAttributeResultPtr From(const U& u) {
    return mojo::TypeConverter<DeviceAttributeResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DeviceAttributeResult>::Convert(*this);
  }
  ~DeviceAttributeResult();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  DeviceAttributeResult(const DeviceAttributeResult& other) = delete;
  DeviceAttributeResult& operator=(const DeviceAttributeResult& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = DeviceAttributeResultPtr>
  DeviceAttributeResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, DeviceAttributeResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, DeviceAttributeResult>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_error_message() const { return tag_ == Tag::kErrorMessage; }
  const std::string& get_error_message() const {
    CHECK(tag_ == Tag::kErrorMessage);
    return data_.error_message;
  }
  std::string& get_error_message() {
    CHECK(tag_ == Tag::kErrorMessage);
    return data_.error_message;
  }
  void set_error_message(const std::string& error_message);

  bool is_attribute() const { return tag_ == Tag::kAttribute; }
  const std::optional<std::string>& get_attribute() const {
    CHECK(tag_ == Tag::kAttribute);
    return data_.attribute;
  }
  std::optional<std::string>& get_attribute() {
    CHECK(tag_ == Tag::kAttribute);
    return data_.attribute;
  }
  void set_attribute(const std::optional<std::string>& attribute);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DeviceAttributeResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<DeviceAttributeResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kErrorMessage)>,
        const std::string& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kAttribute)>,
        const std::optional<std::string>& value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    std::string error_message;
    std::optional<std::string> attribute;
  };

  DeviceAttributeResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kErrorMessage)>,
      const std::string& value);
  DeviceAttributeResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kAttribute)>,
      const std::optional<std::string>& value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};

template <typename UnionPtrType>
DeviceAttributeResultPtr DeviceAttributeResult::Clone() const {
  switch (tag_) {
    case Tag::kErrorMessage:
      return NewErrorMessage(
          mojo::Clone(data_.error_message));
    case Tag::kAttribute:
      return NewAttribute(
          mojo::Clone(data_.attribute));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, DeviceAttributeResult>::value>::type*>
bool DeviceAttributeResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kErrorMessage:
      return mojo::Equals(data_.error_message, other.data_.error_message);
    case Tag::kAttribute:
      return mojo::Equals(data_.attribute, other.data_.attribute);
  }

  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT UnionTraits<::blink::mojom::DeviceAttributeResult::DataView,
                                        ::blink::mojom::DeviceAttributeResultPtr> {
  static bool IsNull(const ::blink::mojom::DeviceAttributeResultPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::DeviceAttributeResultPtr* output) { output->reset(); }

  static ::blink::mojom::DeviceAttributeResult::Tag GetTag(const ::blink::mojom::DeviceAttributeResultPtr& input) {
    return input->which();
  }

  static const std::string& error_message(const ::blink::mojom::DeviceAttributeResultPtr& input) {
    return input->get_error_message();
  }

  static const std::optional<std::string>& attribute(const ::blink::mojom::DeviceAttributeResultPtr& input) {
    return input->get_attribute();
  }

  static bool Read(::blink::mojom::DeviceAttributeResult::DataView input, ::blink::mojom::DeviceAttributeResultPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_DEVICE_DEVICE_MOJOM_H_