// third_party/blink/public/mojom/cookie_store/cookie_store.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/cookie_store/cookie_store.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var restricted_cookie_manager$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/restricted_cookie_manager.mojom', '../../../../../services/network/public/mojom/restricted_cookie_manager.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../../url/mojom/url.mojom.js');
  }



  function CookieChangeSubscription(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieChangeSubscription.prototype.initDefaults_ = function() {
    this.url = null;
    this.matchType = 0;
    this.name = null;
  };
  CookieChangeSubscription.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieChangeSubscription.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieChangeSubscription.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieChangeSubscription.matchType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, restricted_cookie_manager$.CookieMatchType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieChangeSubscription.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CookieChangeSubscription.encodedSize = codec.kStructHeaderSize + 24;

  CookieChangeSubscription.decode = function(decoder) {
    var packed;
    var val = new CookieChangeSubscription();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.matchType =
        decoder.decodeStruct(new codec.Enum(restricted_cookie_manager$.CookieMatchType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.name =
        decoder.decodeStruct(codec.String);
    return val;
  };

  CookieChangeSubscription.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieChangeSubscription.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStruct(codec.Int32, val.matchType);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.name);
  };
  function CookieStore_AddSubscriptions_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieStore_AddSubscriptions_Params.prototype.initDefaults_ = function() {
    this.serviceWorkerRegistrationId = 0;
    this.subscription = null;
  };
  CookieStore_AddSubscriptions_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieStore_AddSubscriptions_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate CookieStore_AddSubscriptions_Params.subscription
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(CookieChangeSubscription), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CookieStore_AddSubscriptions_Params.encodedSize = codec.kStructHeaderSize + 16;

  CookieStore_AddSubscriptions_Params.decode = function(decoder) {
    var packed;
    var val = new CookieStore_AddSubscriptions_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.serviceWorkerRegistrationId =
        decoder.decodeStruct(codec.Int64);
    val.subscription =
        decoder.decodeArrayPointer(new codec.PointerTo(CookieChangeSubscription));
    return val;
  };

  CookieStore_AddSubscriptions_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieStore_AddSubscriptions_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.serviceWorkerRegistrationId);
    encoder.encodeArrayPointer(new codec.PointerTo(CookieChangeSubscription), val.subscription);
  };
  function CookieStore_AddSubscriptions_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieStore_AddSubscriptions_ResponseParams.prototype.initDefaults_ = function() {
    this.success = false;
  };
  CookieStore_AddSubscriptions_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieStore_AddSubscriptions_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  CookieStore_AddSubscriptions_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  CookieStore_AddSubscriptions_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new CookieStore_AddSubscriptions_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.success = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  CookieStore_AddSubscriptions_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieStore_AddSubscriptions_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.success & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function CookieStore_RemoveSubscriptions_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieStore_RemoveSubscriptions_Params.prototype.initDefaults_ = function() {
    this.serviceWorkerRegistrationId = 0;
    this.subscription = null;
  };
  CookieStore_RemoveSubscriptions_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieStore_RemoveSubscriptions_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate CookieStore_RemoveSubscriptions_Params.subscription
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(CookieChangeSubscription), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CookieStore_RemoveSubscriptions_Params.encodedSize = codec.kStructHeaderSize + 16;

  CookieStore_RemoveSubscriptions_Params.decode = function(decoder) {
    var packed;
    var val = new CookieStore_RemoveSubscriptions_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.serviceWorkerRegistrationId =
        decoder.decodeStruct(codec.Int64);
    val.subscription =
        decoder.decodeArrayPointer(new codec.PointerTo(CookieChangeSubscription));
    return val;
  };

  CookieStore_RemoveSubscriptions_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieStore_RemoveSubscriptions_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.serviceWorkerRegistrationId);
    encoder.encodeArrayPointer(new codec.PointerTo(CookieChangeSubscription), val.subscription);
  };
  function CookieStore_RemoveSubscriptions_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieStore_RemoveSubscriptions_ResponseParams.prototype.initDefaults_ = function() {
    this.success = false;
  };
  CookieStore_RemoveSubscriptions_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieStore_RemoveSubscriptions_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  CookieStore_RemoveSubscriptions_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  CookieStore_RemoveSubscriptions_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new CookieStore_RemoveSubscriptions_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.success = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  CookieStore_RemoveSubscriptions_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieStore_RemoveSubscriptions_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.success & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function CookieStore_GetSubscriptions_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieStore_GetSubscriptions_Params.prototype.initDefaults_ = function() {
    this.serviceWorkerRegistrationId = 0;
  };
  CookieStore_GetSubscriptions_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieStore_GetSubscriptions_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  CookieStore_GetSubscriptions_Params.encodedSize = codec.kStructHeaderSize + 8;

  CookieStore_GetSubscriptions_Params.decode = function(decoder) {
    var packed;
    var val = new CookieStore_GetSubscriptions_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.serviceWorkerRegistrationId =
        decoder.decodeStruct(codec.Int64);
    return val;
  };

  CookieStore_GetSubscriptions_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieStore_GetSubscriptions_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.serviceWorkerRegistrationId);
  };
  function CookieStore_GetSubscriptions_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieStore_GetSubscriptions_ResponseParams.prototype.initDefaults_ = function() {
    this.subscriptions = null;
    this.success = false;
  };
  CookieStore_GetSubscriptions_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieStore_GetSubscriptions_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieStore_GetSubscriptions_ResponseParams.subscriptions
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(CookieChangeSubscription), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  CookieStore_GetSubscriptions_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  CookieStore_GetSubscriptions_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new CookieStore_GetSubscriptions_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.subscriptions =
        decoder.decodeArrayPointer(new codec.PointerTo(CookieChangeSubscription));
    packed = decoder.readUint8();
    val.success = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  CookieStore_GetSubscriptions_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieStore_GetSubscriptions_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(CookieChangeSubscription), val.subscriptions);
    packed = 0;
    packed |= (val.success & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kCookieStore_AddSubscriptions_Name = 0;
  var kCookieStore_RemoveSubscriptions_Name = 1;
  var kCookieStore_GetSubscriptions_Name = 2;

  function CookieStorePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(CookieStore,
                                                   handleOrPtrInfo);
  }

  function CookieStoreAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        CookieStore, associatedInterfacePtrInfo);
  }

  CookieStoreAssociatedPtr.prototype =
      Object.create(CookieStorePtr.prototype);
  CookieStoreAssociatedPtr.prototype.constructor =
      CookieStoreAssociatedPtr;

  function CookieStoreProxy(receiver) {
    this.receiver_ = receiver;
  }
  CookieStorePtr.prototype.addSubscriptions = function() {
    return CookieStoreProxy.prototype.addSubscriptions
        .apply(this.ptr.getProxy(), arguments);
  };

  CookieStoreProxy.prototype.addSubscriptions = function(serviceWorkerRegistrationId, subscription) {
    var params_ = new CookieStore_AddSubscriptions_Params();
    params_.serviceWorkerRegistrationId = serviceWorkerRegistrationId;
    params_.subscription = subscription;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kCookieStore_AddSubscriptions_Name,
          codec.align(CookieStore_AddSubscriptions_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(CookieStore_AddSubscriptions_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(CookieStore_AddSubscriptions_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  CookieStorePtr.prototype.removeSubscriptions = function() {
    return CookieStoreProxy.prototype.removeSubscriptions
        .apply(this.ptr.getProxy(), arguments);
  };

  CookieStoreProxy.prototype.removeSubscriptions = function(serviceWorkerRegistrationId, subscription) {
    var params_ = new CookieStore_RemoveSubscriptions_Params();
    params_.serviceWorkerRegistrationId = serviceWorkerRegistrationId;
    params_.subscription = subscription;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kCookieStore_RemoveSubscriptions_Name,
          codec.align(CookieStore_RemoveSubscriptions_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(CookieStore_RemoveSubscriptions_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(CookieStore_RemoveSubscriptions_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  CookieStorePtr.prototype.getSubscriptions = function() {
    return CookieStoreProxy.prototype.getSubscriptions
        .apply(this.ptr.getProxy(), arguments);
  };

  CookieStoreProxy.prototype.getSubscriptions = function(serviceWorkerRegistrationId) {
    var params_ = new CookieStore_GetSubscriptions_Params();
    params_.serviceWorkerRegistrationId = serviceWorkerRegistrationId;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kCookieStore_GetSubscriptions_Name,
          codec.align(CookieStore_GetSubscriptions_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(CookieStore_GetSubscriptions_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(CookieStore_GetSubscriptions_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function CookieStoreStub(delegate) {
    this.delegate_ = delegate;
  }
  CookieStoreStub.prototype.addSubscriptions = function(serviceWorkerRegistrationId, subscription) {
    return this.delegate_ && this.delegate_.addSubscriptions && this.delegate_.addSubscriptions(serviceWorkerRegistrationId, subscription);
  }
  CookieStoreStub.prototype.removeSubscriptions = function(serviceWorkerRegistrationId, subscription) {
    return this.delegate_ && this.delegate_.removeSubscriptions && this.delegate_.removeSubscriptions(serviceWorkerRegistrationId, subscription);
  }
  CookieStoreStub.prototype.getSubscriptions = function(serviceWorkerRegistrationId) {
    return this.delegate_ && this.delegate_.getSubscriptions && this.delegate_.getSubscriptions(serviceWorkerRegistrationId);
  }

  CookieStoreStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  CookieStoreStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kCookieStore_AddSubscriptions_Name:
      var params = reader.decodeStruct(CookieStore_AddSubscriptions_Params);
      this.addSubscriptions(params.serviceWorkerRegistrationId, params.subscription).then(function(response) {
        var responseParams =
            new CookieStore_AddSubscriptions_ResponseParams();
        responseParams.success = response.success;
        var builder = new codec.MessageV1Builder(
            kCookieStore_AddSubscriptions_Name,
            codec.align(CookieStore_AddSubscriptions_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(CookieStore_AddSubscriptions_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kCookieStore_RemoveSubscriptions_Name:
      var params = reader.decodeStruct(CookieStore_RemoveSubscriptions_Params);
      this.removeSubscriptions(params.serviceWorkerRegistrationId, params.subscription).then(function(response) {
        var responseParams =
            new CookieStore_RemoveSubscriptions_ResponseParams();
        responseParams.success = response.success;
        var builder = new codec.MessageV1Builder(
            kCookieStore_RemoveSubscriptions_Name,
            codec.align(CookieStore_RemoveSubscriptions_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(CookieStore_RemoveSubscriptions_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kCookieStore_GetSubscriptions_Name:
      var params = reader.decodeStruct(CookieStore_GetSubscriptions_Params);
      this.getSubscriptions(params.serviceWorkerRegistrationId).then(function(response) {
        var responseParams =
            new CookieStore_GetSubscriptions_ResponseParams();
        responseParams.subscriptions = response.subscriptions;
        responseParams.success = response.success;
        var builder = new codec.MessageV1Builder(
            kCookieStore_GetSubscriptions_Name,
            codec.align(CookieStore_GetSubscriptions_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(CookieStore_GetSubscriptions_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateCookieStoreRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kCookieStore_AddSubscriptions_Name:
        if (message.expectsResponse())
          paramsClass = CookieStore_AddSubscriptions_Params;
      break;
      case kCookieStore_RemoveSubscriptions_Name:
        if (message.expectsResponse())
          paramsClass = CookieStore_RemoveSubscriptions_Params;
      break;
      case kCookieStore_GetSubscriptions_Name:
        if (message.expectsResponse())
          paramsClass = CookieStore_GetSubscriptions_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateCookieStoreResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kCookieStore_AddSubscriptions_Name:
        if (message.isResponse())
          paramsClass = CookieStore_AddSubscriptions_ResponseParams;
        break;
      case kCookieStore_RemoveSubscriptions_Name:
        if (message.isResponse())
          paramsClass = CookieStore_RemoveSubscriptions_ResponseParams;
        break;
      case kCookieStore_GetSubscriptions_Name:
        if (message.isResponse())
          paramsClass = CookieStore_GetSubscriptions_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var CookieStore = {
    name: 'blink.mojom.CookieStore',
    kVersion: 0,
    ptrClass: CookieStorePtr,
    proxyClass: CookieStoreProxy,
    stubClass: CookieStoreStub,
    validateRequest: validateCookieStoreRequest,
    validateResponse: validateCookieStoreResponse,
  };
  CookieStoreStub.prototype.validator = validateCookieStoreRequest;
  CookieStoreProxy.prototype.validator = validateCookieStoreResponse;
  exports.CookieChangeSubscription = CookieChangeSubscription;
  exports.CookieStore = CookieStore;
  exports.CookieStorePtr = CookieStorePtr;
  exports.CookieStoreAssociatedPtr = CookieStoreAssociatedPtr;
})();