// third_party/blink/public/mojom/context_menu/context_menu.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/context_menu/context_menu.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var string16$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/string16.mojom', '../../../../../mojo/public/mojom/base/string16.mojom.js');
  }
  var referrer_policy$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/referrer_policy.mojom', '../../../../../services/network/public/mojom/referrer_policy.mojom.js');
  }
  var annotation$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/annotation/annotation.mojom', '../annotation/annotation.mojom.js');
  }
  var conversions$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/conversions/conversions.mojom', '../conversions/conversions.mojom.js');
  }
  var form_control_type$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/forms/form_control_type.mojom', '../forms/form_control_type.mojom.js');
  }
  var menu_source_type$ =
      mojo.internal.exposeNamespace('ui.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/base/mojom/menu_source_type.mojom', '../../../../../ui/base/mojom/menu_source_type.mojom.js');
  }
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../../url/mojom/url.mojom.js');
  }


  var ContextMenuDataMediaType = {};
  ContextMenuDataMediaType.kNone = 0;
  ContextMenuDataMediaType.kImage = 1;
  ContextMenuDataMediaType.kVideo = 2;
  ContextMenuDataMediaType.kAudio = 3;
  ContextMenuDataMediaType.kCanvas = 4;
  ContextMenuDataMediaType.kFile = 5;
  ContextMenuDataMediaType.kPlugin = 6;
  ContextMenuDataMediaType.MIN_VALUE = 0;
  ContextMenuDataMediaType.MAX_VALUE = 6;

  ContextMenuDataMediaType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
      return true;
    }
    return false;
  };

  ContextMenuDataMediaType.toKnownEnumValue = function(value) {
    return value;
  };

  ContextMenuDataMediaType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var CustomContextMenuItemType = {};
  CustomContextMenuItemType.kOption = 0;
  CustomContextMenuItemType.kCheckableOption = 1;
  CustomContextMenuItemType.kGroup = 2;
  CustomContextMenuItemType.kSeparator = 3;
  CustomContextMenuItemType.kSubMenu = 4;
  CustomContextMenuItemType.MIN_VALUE = 0;
  CustomContextMenuItemType.MAX_VALUE = 4;

  CustomContextMenuItemType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
      return true;
    }
    return false;
  };

  CustomContextMenuItemType.toKnownEnumValue = function(value) {
    return value;
  };

  CustomContextMenuItemType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function Accelerator(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Accelerator.prototype.initDefaults_ = function() {
    this.keyCode = 0;
    this.modifiers = 0;
  };
  Accelerator.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Accelerator.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  Accelerator.encodedSize = codec.kStructHeaderSize + 8;

  Accelerator.decode = function(decoder) {
    var packed;
    var val = new Accelerator();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.keyCode =
        decoder.decodeStruct(codec.Uint16);
    decoder.skip(1);
    decoder.skip(1);
    val.modifiers =
        decoder.decodeStruct(codec.Int32);
    return val;
  };

  Accelerator.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Accelerator.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint16, val.keyCode);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.modifiers);
  };
  function FormRendererId(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FormRendererId.prototype.initDefaults_ = function() {
    this.id = 0;
  };
  FormRendererId.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FormRendererId.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  FormRendererId.encodedSize = codec.kStructHeaderSize + 8;

  FormRendererId.decode = function(decoder) {
    var packed;
    var val = new FormRendererId();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.id =
        decoder.decodeStruct(codec.Uint64);
    return val;
  };

  FormRendererId.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FormRendererId.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint64, val.id);
  };
  function FieldRendererId(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FieldRendererId.prototype.initDefaults_ = function() {
    this.id = 0;
  };
  FieldRendererId.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FieldRendererId.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  FieldRendererId.encodedSize = codec.kStructHeaderSize + 8;

  FieldRendererId.decode = function(decoder) {
    var packed;
    var val = new FieldRendererId();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.id =
        decoder.decodeStruct(codec.Uint64);
    return val;
  };

  FieldRendererId.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FieldRendererId.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint64, val.id);
  };
  function CustomContextMenuItem(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CustomContextMenuItem.prototype.initDefaults_ = function() {
    this.label = null;
    this.accelerator = null;
    this.icon = null;
    this.toolTip = null;
    this.type = 0;
    this.action = 0;
    this.featureName = null;
    this.isExperimentalFeature = false;
    this.rtl = false;
    this.hasDirectionalOverride = false;
    this.enabled = false;
    this.checked = false;
    this.forceShowAcceleratorForItem = false;
    this.submenu = null;
  };
  CustomContextMenuItem.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CustomContextMenuItem.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 72}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CustomContextMenuItem.label
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CustomContextMenuItem.accelerator
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, Accelerator, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CustomContextMenuItem.icon
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CustomContextMenuItem.toolTip
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CustomContextMenuItem.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 32, CustomContextMenuItemType);
    if (err !== validator.validationError.NONE)
        return err;



    // validate CustomContextMenuItem.featureName
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;








    // validate CustomContextMenuItem.submenu
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 56, 8, new codec.PointerTo(CustomContextMenuItem), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CustomContextMenuItem.encodedSize = codec.kStructHeaderSize + 64;

  CustomContextMenuItem.decode = function(decoder) {
    var packed;
    var val = new CustomContextMenuItem();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.label =
        decoder.decodeStructPointer(string16$.String16);
    val.accelerator =
        decoder.decodeStructPointer(Accelerator);
    val.icon =
        decoder.decodeStructPointer(string16$.String16);
    val.toolTip =
        decoder.decodeStructPointer(string16$.String16);
    val.type =
        decoder.decodeStruct(new codec.Enum(CustomContextMenuItemType));
    val.action =
        decoder.decodeStruct(codec.Int32);
    val.featureName =
        decoder.decodeStructPointer(string16$.String16);
    packed = decoder.readUint8();
    val.isExperimentalFeature = (packed >> 0) & 1 ? true : false;
    val.rtl = (packed >> 1) & 1 ? true : false;
    val.hasDirectionalOverride = (packed >> 2) & 1 ? true : false;
    val.enabled = (packed >> 3) & 1 ? true : false;
    val.checked = (packed >> 4) & 1 ? true : false;
    val.forceShowAcceleratorForItem = (packed >> 5) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.submenu =
        decoder.decodeArrayPointer(new codec.PointerTo(CustomContextMenuItem));
    return val;
  };

  CustomContextMenuItem.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CustomContextMenuItem.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(string16$.String16, val.label);
    encoder.encodeStructPointer(Accelerator, val.accelerator);
    encoder.encodeStructPointer(string16$.String16, val.icon);
    encoder.encodeStructPointer(string16$.String16, val.toolTip);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.encodeStruct(codec.Int32, val.action);
    encoder.encodeStructPointer(string16$.String16, val.featureName);
    packed = 0;
    packed |= (val.isExperimentalFeature & 1) << 0
    packed |= (val.rtl & 1) << 1
    packed |= (val.hasDirectionalOverride & 1) << 2
    packed |= (val.enabled & 1) << 3
    packed |= (val.checked & 1) << 4
    packed |= (val.forceShowAcceleratorForItem & 1) << 5
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.PointerTo(CustomContextMenuItem), val.submenu);
  };
  function UntrustworthyContextMenuParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  UntrustworthyContextMenuParams.prototype.initDefaults_ = function() {
    this.mediaType = 0;
    this.x = 0;
    this.y = 0;
    this.hasImageContents = false;
    this.isImageMediaPluginDocument = false;
    this.spellcheckEnabled = false;
    this.isEditable = false;
    this.annotation_type_$flag = false;
    this.openedFromInterestFor = false;
    this.form_control_type_$flag = false;
    this.isContentEditableForAutofill = false;
    this.linkUrl = null;
    this.linkText = null;
    this.impression = null;
    this.unfilteredLinkUrl = null;
    this.srcUrl = null;
    this.mediaFlags = 0;
    this.writingDirectionDefault = 0;
    this.selectionText = null;
    this.titleText = null;
    this.altText = null;
    this.suggestedFilename = null;
    this.misspelledWord = null;
    this.dictionarySuggestions = null;
    this.writingDirectionLeftToRight = 0;
    this.writingDirectionRightToLeft = 0;
    this.editFlags = 0;
    this.referrerPolicy = 0;
    this.frameCharset = null;
    this.linkFollowed = null;
    this.customItems = null;
    this.sourceType = 0;
    this.selectionStartOffset = 0;
    this.selectionRect = null;
    this.annotation_type_$value = 0;
    this.interestForNodeId = 0;
    this.form_control_type_$value = 0;
    this.fieldRendererId = null;
    this.formRendererId = null;
  };
  UntrustworthyContextMenuParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  UntrustworthyContextMenuParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 208}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate UntrustworthyContextMenuParams.mediaType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, ContextMenuDataMediaType);
    if (err !== validator.validationError.NONE)
        return err;




    // validate UntrustworthyContextMenuParams.linkUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate UntrustworthyContextMenuParams.linkText
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate UntrustworthyContextMenuParams.impression
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, conversions$.Impression, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate UntrustworthyContextMenuParams.unfilteredLinkUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate UntrustworthyContextMenuParams.srcUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;





    // validate UntrustworthyContextMenuParams.selectionText
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 64, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate UntrustworthyContextMenuParams.titleText
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 72, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate UntrustworthyContextMenuParams.altText
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 80, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate UntrustworthyContextMenuParams.suggestedFilename
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 88, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate UntrustworthyContextMenuParams.misspelledWord
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 96, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate UntrustworthyContextMenuParams.dictionarySuggestions
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 104, 8, new codec.PointerTo(string16$.String16), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;








    // validate UntrustworthyContextMenuParams.frameCharset
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 128, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate UntrustworthyContextMenuParams.referrerPolicy
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 124, referrer_policy$.ReferrerPolicy);
    if (err !== validator.validationError.NONE)
        return err;


    // validate UntrustworthyContextMenuParams.linkFollowed
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 136, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate UntrustworthyContextMenuParams.customItems
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 144, 8, new codec.PointerTo(CustomContextMenuItem), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate UntrustworthyContextMenuParams.sourceType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 152, menu_source_type$.MenuSourceType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate UntrustworthyContextMenuParams.selectionRect
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 160, geometry$.Rect, false);
    if (err !== validator.validationError.NONE)
        return err;




    // validate UntrustworthyContextMenuParams.annotation_type_$value
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 168, annotation$.AnnotationType);
    if (err !== validator.validationError.NONE)
        return err;





    // validate UntrustworthyContextMenuParams.form_control_type_$value
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 176, form_control_type$.FormControlType);
    if (err !== validator.validationError.NONE)
        return err;



    // validate UntrustworthyContextMenuParams.fieldRendererId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 184, FieldRendererId, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate UntrustworthyContextMenuParams.formRendererId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 192, FormRendererId, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  UntrustworthyContextMenuParams.encodedSize = codec.kStructHeaderSize + 200;

  UntrustworthyContextMenuParams.decode = function(decoder) {
    var packed;
    var val = new UntrustworthyContextMenuParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.mediaType =
        decoder.decodeStruct(new codec.Enum(ContextMenuDataMediaType));
    val.x =
        decoder.decodeStruct(codec.Int32);
    val.y =
        decoder.decodeStruct(codec.Int32);
    packed = decoder.readUint8();
    val.hasImageContents = (packed >> 0) & 1 ? true : false;
    val.isImageMediaPluginDocument = (packed >> 1) & 1 ? true : false;
    val.spellcheckEnabled = (packed >> 2) & 1 ? true : false;
    val.isEditable = (packed >> 3) & 1 ? true : false;
    val.annotation_type_$flag = (packed >> 4) & 1 ? true : false;
    val.openedFromInterestFor = (packed >> 5) & 1 ? true : false;
    val.form_control_type_$flag = (packed >> 6) & 1 ? true : false;
    val.isContentEditableForAutofill = (packed >> 7) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.linkUrl =
        decoder.decodeStructPointer(url$.Url);
    val.linkText =
        decoder.decodeStructPointer(string16$.String16);
    val.impression =
        decoder.decodeStructPointer(conversions$.Impression);
    val.unfilteredLinkUrl =
        decoder.decodeStructPointer(url$.Url);
    val.srcUrl =
        decoder.decodeStructPointer(url$.Url);
    val.mediaFlags =
        decoder.decodeStruct(codec.Int32);
    val.writingDirectionDefault =
        decoder.decodeStruct(codec.Int32);
    val.selectionText =
        decoder.decodeStructPointer(string16$.String16);
    val.titleText =
        decoder.decodeStructPointer(string16$.String16);
    val.altText =
        decoder.decodeStructPointer(string16$.String16);
    val.suggestedFilename =
        decoder.decodeStructPointer(string16$.String16);
    val.misspelledWord =
        decoder.decodeStructPointer(string16$.String16);
    val.dictionarySuggestions =
        decoder.decodeArrayPointer(new codec.PointerTo(string16$.String16));
    val.writingDirectionLeftToRight =
        decoder.decodeStruct(codec.Int32);
    val.writingDirectionRightToLeft =
        decoder.decodeStruct(codec.Int32);
    val.editFlags =
        decoder.decodeStruct(codec.Int32);
    val.referrerPolicy =
        decoder.decodeStruct(new codec.Enum(referrer_policy$.ReferrerPolicy));
    val.frameCharset =
        decoder.decodeStruct(codec.String);
    val.linkFollowed =
        decoder.decodeStructPointer(url$.Url);
    val.customItems =
        decoder.decodeArrayPointer(new codec.PointerTo(CustomContextMenuItem));
    val.sourceType =
        decoder.decodeStruct(new codec.Enum(menu_source_type$.MenuSourceType));
    val.selectionStartOffset =
        decoder.decodeStruct(codec.Int32);
    val.selectionRect =
        decoder.decodeStructPointer(geometry$.Rect);
    val.annotation_type_$value =
        decoder.decodeStruct(new codec.Enum(annotation$.AnnotationType));
    val.interestForNodeId =
        decoder.decodeStruct(codec.Int32);
    val.form_control_type_$value =
        decoder.decodeStruct(new codec.Enum(form_control_type$.FormControlType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.fieldRendererId =
        decoder.decodeStructPointer(FieldRendererId);
    val.formRendererId =
        decoder.decodeStructPointer(FormRendererId);
    return val;
  };

  UntrustworthyContextMenuParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(UntrustworthyContextMenuParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.mediaType);
    encoder.encodeStruct(codec.Int32, val.x);
    encoder.encodeStruct(codec.Int32, val.y);
    packed = 0;
    packed |= (val.hasImageContents & 1) << 0
    packed |= (val.isImageMediaPluginDocument & 1) << 1
    packed |= (val.spellcheckEnabled & 1) << 2
    packed |= (val.isEditable & 1) << 3
    packed |= (val.annotation_type_$flag & 1) << 4
    packed |= (val.openedFromInterestFor & 1) << 5
    packed |= (val.form_control_type_$flag & 1) << 6
    packed |= (val.isContentEditableForAutofill & 1) << 7
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(url$.Url, val.linkUrl);
    encoder.encodeStructPointer(string16$.String16, val.linkText);
    encoder.encodeStructPointer(conversions$.Impression, val.impression);
    encoder.encodeStructPointer(url$.Url, val.unfilteredLinkUrl);
    encoder.encodeStructPointer(url$.Url, val.srcUrl);
    encoder.encodeStruct(codec.Int32, val.mediaFlags);
    encoder.encodeStruct(codec.Int32, val.writingDirectionDefault);
    encoder.encodeStructPointer(string16$.String16, val.selectionText);
    encoder.encodeStructPointer(string16$.String16, val.titleText);
    encoder.encodeStructPointer(string16$.String16, val.altText);
    encoder.encodeStructPointer(string16$.String16, val.suggestedFilename);
    encoder.encodeStructPointer(string16$.String16, val.misspelledWord);
    encoder.encodeArrayPointer(new codec.PointerTo(string16$.String16), val.dictionarySuggestions);
    encoder.encodeStruct(codec.Int32, val.writingDirectionLeftToRight);
    encoder.encodeStruct(codec.Int32, val.writingDirectionRightToLeft);
    encoder.encodeStruct(codec.Int32, val.editFlags);
    encoder.encodeStruct(codec.Int32, val.referrerPolicy);
    encoder.encodeStruct(codec.String, val.frameCharset);
    encoder.encodeStructPointer(url$.Url, val.linkFollowed);
    encoder.encodeArrayPointer(new codec.PointerTo(CustomContextMenuItem), val.customItems);
    encoder.encodeStruct(codec.Int32, val.sourceType);
    encoder.encodeStruct(codec.Int32, val.selectionStartOffset);
    encoder.encodeStructPointer(geometry$.Rect, val.selectionRect);
    encoder.encodeStruct(codec.Int32, val.annotation_type_$value);
    encoder.encodeStruct(codec.Int32, val.interestForNodeId);
    encoder.encodeStruct(codec.Int32, val.form_control_type_$value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(FieldRendererId, val.fieldRendererId);
    encoder.encodeStructPointer(FormRendererId, val.formRendererId);
  };
  function ContextMenuClient_CustomContextMenuAction_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ContextMenuClient_CustomContextMenuAction_Params.prototype.initDefaults_ = function() {
    this.action = 0;
  };
  ContextMenuClient_CustomContextMenuAction_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ContextMenuClient_CustomContextMenuAction_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  ContextMenuClient_CustomContextMenuAction_Params.encodedSize = codec.kStructHeaderSize + 8;

  ContextMenuClient_CustomContextMenuAction_Params.decode = function(decoder) {
    var packed;
    var val = new ContextMenuClient_CustomContextMenuAction_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.action =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ContextMenuClient_CustomContextMenuAction_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ContextMenuClient_CustomContextMenuAction_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.action);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ContextMenuClient_ContextMenuClosed_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ContextMenuClient_ContextMenuClosed_Params.prototype.initDefaults_ = function() {
    this.linkFollowed = null;
    this.impression = null;
  };
  ContextMenuClient_ContextMenuClosed_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ContextMenuClient_ContextMenuClosed_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ContextMenuClient_ContextMenuClosed_Params.linkFollowed
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ContextMenuClient_ContextMenuClosed_Params.impression
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, conversions$.Impression, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ContextMenuClient_ContextMenuClosed_Params.encodedSize = codec.kStructHeaderSize + 16;

  ContextMenuClient_ContextMenuClosed_Params.decode = function(decoder) {
    var packed;
    var val = new ContextMenuClient_ContextMenuClosed_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.linkFollowed =
        decoder.decodeStructPointer(url$.Url);
    val.impression =
        decoder.decodeStructPointer(conversions$.Impression);
    return val;
  };

  ContextMenuClient_ContextMenuClosed_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ContextMenuClient_ContextMenuClosed_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.linkFollowed);
    encoder.encodeStructPointer(conversions$.Impression, val.impression);
  };
  var kContextMenuClient_CustomContextMenuAction_Name = 0;
  var kContextMenuClient_ContextMenuClosed_Name = 1;

  function ContextMenuClientPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(ContextMenuClient,
                                                   handleOrPtrInfo);
  }

  function ContextMenuClientAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        ContextMenuClient, associatedInterfacePtrInfo);
  }

  ContextMenuClientAssociatedPtr.prototype =
      Object.create(ContextMenuClientPtr.prototype);
  ContextMenuClientAssociatedPtr.prototype.constructor =
      ContextMenuClientAssociatedPtr;

  function ContextMenuClientProxy(receiver) {
    this.receiver_ = receiver;
  }
  ContextMenuClientPtr.prototype.customContextMenuAction = function() {
    return ContextMenuClientProxy.prototype.customContextMenuAction
        .apply(this.ptr.getProxy(), arguments);
  };

  ContextMenuClientProxy.prototype.customContextMenuAction = function(action) {
    var params_ = new ContextMenuClient_CustomContextMenuAction_Params();
    params_.action = action;
    var builder = new codec.MessageV0Builder(
        kContextMenuClient_CustomContextMenuAction_Name,
        codec.align(ContextMenuClient_CustomContextMenuAction_Params.encodedSize));
    builder.encodeStruct(ContextMenuClient_CustomContextMenuAction_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ContextMenuClientPtr.prototype.contextMenuClosed = function() {
    return ContextMenuClientProxy.prototype.contextMenuClosed
        .apply(this.ptr.getProxy(), arguments);
  };

  ContextMenuClientProxy.prototype.contextMenuClosed = function(linkFollowed, impression) {
    var params_ = new ContextMenuClient_ContextMenuClosed_Params();
    params_.linkFollowed = linkFollowed;
    params_.impression = impression;
    var builder = new codec.MessageV0Builder(
        kContextMenuClient_ContextMenuClosed_Name,
        codec.align(ContextMenuClient_ContextMenuClosed_Params.encodedSize));
    builder.encodeStruct(ContextMenuClient_ContextMenuClosed_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function ContextMenuClientStub(delegate) {
    this.delegate_ = delegate;
  }
  ContextMenuClientStub.prototype.customContextMenuAction = function(action) {
    return this.delegate_ && this.delegate_.customContextMenuAction && this.delegate_.customContextMenuAction(action);
  }
  ContextMenuClientStub.prototype.contextMenuClosed = function(linkFollowed, impression) {
    return this.delegate_ && this.delegate_.contextMenuClosed && this.delegate_.contextMenuClosed(linkFollowed, impression);
  }

  ContextMenuClientStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kContextMenuClient_CustomContextMenuAction_Name:
      var params = reader.decodeStruct(ContextMenuClient_CustomContextMenuAction_Params);
      this.customContextMenuAction(params.action);
      return true;
    case kContextMenuClient_ContextMenuClosed_Name:
      var params = reader.decodeStruct(ContextMenuClient_ContextMenuClosed_Params);
      this.contextMenuClosed(params.linkFollowed, params.impression);
      return true;
    default:
      return false;
    }
  };

  ContextMenuClientStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateContextMenuClientRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kContextMenuClient_CustomContextMenuAction_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ContextMenuClient_CustomContextMenuAction_Params;
      break;
      case kContextMenuClient_ContextMenuClosed_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ContextMenuClient_ContextMenuClosed_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateContextMenuClientResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var ContextMenuClient = {
    name: 'blink.mojom.ContextMenuClient',
    kVersion: 0,
    ptrClass: ContextMenuClientPtr,
    proxyClass: ContextMenuClientProxy,
    stubClass: ContextMenuClientStub,
    validateRequest: validateContextMenuClientRequest,
    validateResponse: null,
  };
  ContextMenuClientStub.prototype.validator = validateContextMenuClientRequest;
  ContextMenuClientProxy.prototype.validator = null;
  exports.ContextMenuDataMediaType = ContextMenuDataMediaType;
  exports.CustomContextMenuItemType = CustomContextMenuItemType;
  exports.Accelerator = Accelerator;
  exports.FormRendererId = FormRendererId;
  exports.FieldRendererId = FieldRendererId;
  exports.CustomContextMenuItem = CustomContextMenuItem;
  exports.UntrustworthyContextMenuParams = UntrustworthyContextMenuParams;
  exports.ContextMenuClient = ContextMenuClient;
  exports.ContextMenuClientPtr = ContextMenuClientPtr;
  exports.ContextMenuClientAssociatedPtr = ContextMenuClientAssociatedPtr;
})();