// third_party/blink/public/mojom/content_extraction/script_tools.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTENT_EXTRACTION_SCRIPT_TOOLS_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTENT_EXTRACTION_SCRIPT_TOOLS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/content_extraction/script_tools.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/content_extraction/script_tools.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/content_extraction/script_tools.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {





class BLINK_COMMON_EXPORT ScriptToolAnnotations {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ScriptToolAnnotations, T>::value>;
  using DataView = ScriptToolAnnotationsDataView;
  using Data_ = internal::ScriptToolAnnotations_Data;

  template <typename... Args>
  static ScriptToolAnnotationsPtr New(Args&&... args) {
    return ScriptToolAnnotationsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ScriptToolAnnotationsPtr From(const U& u) {
    return mojo::TypeConverter<ScriptToolAnnotationsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ScriptToolAnnotations>::Convert(*this);
  }


  ScriptToolAnnotations();

  explicit ScriptToolAnnotations(
      bool read_only);


  ~ScriptToolAnnotations();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ScriptToolAnnotationsPtr>
  ScriptToolAnnotationsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ScriptToolAnnotations::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ScriptToolAnnotations::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ScriptToolAnnotations::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScriptToolAnnotations::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScriptToolAnnotations::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ScriptToolAnnotations::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ScriptToolAnnotations_UnserializedMessageContext<
            UserType, ScriptToolAnnotations::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ScriptToolAnnotations::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ScriptToolAnnotations::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ScriptToolAnnotations_UnserializedMessageContext<
            UserType, ScriptToolAnnotations::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ScriptToolAnnotations::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool read_only;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ScriptToolAnnotations::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ScriptToolAnnotations::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ScriptToolAnnotations::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ScriptToolAnnotations::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}









class BLINK_COMMON_EXPORT ScriptTool {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ScriptTool, T>::value>;
  using DataView = ScriptToolDataView;
  using Data_ = internal::ScriptTool_Data;

  template <typename... Args>
  static ScriptToolPtr New(Args&&... args) {
    return ScriptToolPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ScriptToolPtr From(const U& u) {
    return mojo::TypeConverter<ScriptToolPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ScriptTool>::Convert(*this);
  }


  ScriptTool();

  ScriptTool(
      const std::string& name,
      const std::string& description,
      const std::optional<std::string>& input_schema,
      ScriptToolAnnotationsPtr annotations);

ScriptTool(const ScriptTool&) = delete;
ScriptTool& operator=(const ScriptTool&) = delete;

  ~ScriptTool();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ScriptToolPtr>
  ScriptToolPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ScriptTool::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ScriptTool::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ScriptTool::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScriptTool::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ScriptTool::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ScriptTool::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ScriptTool_UnserializedMessageContext<
            UserType, ScriptTool::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ScriptTool::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ScriptTool::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ScriptTool_UnserializedMessageContext<
            UserType, ScriptTool::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ScriptTool::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string name;
  
  std::string description;
  
  std::optional<std::string> input_schema;
  
  ScriptToolAnnotationsPtr annotations;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ScriptTool::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ScriptTool::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ScriptTool::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ScriptTool::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ScriptToolAnnotationsPtr ScriptToolAnnotations::Clone() const {
  return New(
      mojo::Clone(read_only)
  );
}

template <typename T, ScriptToolAnnotations::EnableIfSame<T>*>
bool ScriptToolAnnotations::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->read_only, other_struct.read_only))
    return false;
  return true;
}

template <typename T, ScriptToolAnnotations::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.read_only < rhs.read_only)
    return true;
  if (rhs.read_only < lhs.read_only)
    return false;
  return false;
}
template <typename StructPtrType>
ScriptToolPtr ScriptTool::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(description),
      mojo::Clone(input_schema),
      mojo::Clone(annotations)
  );
}

template <typename T, ScriptTool::EnableIfSame<T>*>
bool ScriptTool::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->description, other_struct.description))
    return false;
  if (!mojo::Equals(this->input_schema, other_struct.input_schema))
    return false;
  if (!mojo::Equals(this->annotations, other_struct.annotations))
    return false;
  return true;
}

template <typename T, ScriptTool::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.description < rhs.description)
    return true;
  if (rhs.description < lhs.description)
    return false;
  if (lhs.input_schema < rhs.input_schema)
    return true;
  if (rhs.input_schema < lhs.input_schema)
    return false;
  if (lhs.annotations < rhs.annotations)
    return true;
  if (rhs.annotations < lhs.annotations)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ScriptToolAnnotations::DataView,
                                         ::blink::mojom::ScriptToolAnnotationsPtr> {
  static bool IsNull(const ::blink::mojom::ScriptToolAnnotationsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ScriptToolAnnotationsPtr* output) { output->reset(); }

  static decltype(::blink::mojom::ScriptToolAnnotations::read_only) read_only(
      const ::blink::mojom::ScriptToolAnnotationsPtr& input) {
    return input->read_only;
  }

  static bool Read(::blink::mojom::ScriptToolAnnotations::DataView input, ::blink::mojom::ScriptToolAnnotationsPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ScriptTool::DataView,
                                         ::blink::mojom::ScriptToolPtr> {
  static bool IsNull(const ::blink::mojom::ScriptToolPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ScriptToolPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::ScriptTool::name)& name(
      const ::blink::mojom::ScriptToolPtr& input) {
    return input->name;
  }

  static const decltype(::blink::mojom::ScriptTool::description)& description(
      const ::blink::mojom::ScriptToolPtr& input) {
    return input->description;
  }

  static const decltype(::blink::mojom::ScriptTool::input_schema)& input_schema(
      const ::blink::mojom::ScriptToolPtr& input) {
    return input->input_schema;
  }

  static const decltype(::blink::mojom::ScriptTool::annotations)& annotations(
      const ::blink::mojom::ScriptToolPtr& input) {
    return input->annotations;
  }

  static bool Read(::blink::mojom::ScriptTool::DataView input, ::blink::mojom::ScriptToolPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTENT_EXTRACTION_SCRIPT_TOOLS_MOJOM_H_