// third_party/blink/public/mojom/content_extraction/inner_text.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  LocalFrameToken as blink_mojom_LocalFrameToken,
  LocalFrameTokenSpec as blink_mojom_LocalFrameTokenSpec
} from '../tokens/tokens.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const NodeLocationTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const NodeLocationType = {
  
  kStart: 0,
  MIN_VALUE: 0,
  MAX_VALUE: 0,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class InnerTextAgentPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.InnerTextAgent', scope);
  }
}

/** @interface */
export class InnerTextAgentInterface {
  
  /**
   * @param { !InnerTextParams } params
   * @return {!Promise<{
        frame: !InnerTextFrame,
   *  }>}
   */

  getInnerText(params) {}
}

/**
 * @implements { InnerTextAgentInterface }
 */
export class InnerTextAgentRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!InnerTextAgentPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          InnerTextAgentPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!InnerTextAgentPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !InnerTextParams } params
   * @return {!Promise<{
        frame: !InnerTextFrame,
   *  }>}
   */

  getInnerText(
      params) {
    return this.proxy.sendMessage(
        0,
        InnerTextAgent_GetInnerText_ParamsSpec.$,
        InnerTextAgent_GetInnerText_ResponseParamsSpec.$,
        [
          params
        ],
        false);
  }
}

/**
 * An object which receives request messages for the InnerTextAgent
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class InnerTextAgentReceiver {
  /**
   * @param {!InnerTextAgentInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!InnerTextAgentRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        InnerTextAgentRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!InnerTextAgentRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        InnerTextAgent_GetInnerText_ParamsSpec.$,
        InnerTextAgent_GetInnerText_ResponseParamsSpec.$,
        impl.getInnerText.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class InnerTextAgent {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.InnerTextAgent";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!InnerTextAgentRemote}
   */
  static getRemote() {
    let remote = new InnerTextAgentRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the InnerTextAgent
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class InnerTextAgentCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      InnerTextAgentRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!InnerTextAgentRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getInnerText =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        InnerTextAgent_GetInnerText_ParamsSpec.$,
        InnerTextAgent_GetInnerText_ResponseParamsSpec.$,
        this.getInnerText.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InnerTextFrameSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InnerTextParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InnerTextAgent_GetInnerText_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InnerTextAgent_GetInnerText_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const InnerTextSegmentSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    InnerTextFrameSpec.$,
    'InnerTextFrame',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        blink_mojom_LocalFrameTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'segments', 8,
        0,
        mojo.internal.Array(InnerTextSegmentSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class InnerTextFrame {
  constructor() {
    /** @type { !blink_mojom_LocalFrameToken } */
    this.token;
    /** @type { !Array<!InnerTextSegment> } */
    this.segments;
  }
}



mojo.internal.Struct(
    InnerTextParamsSpec.$,
    'InnerTextParams',
    [
      mojo.internal.StructField(
        'node_id_$flag', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "node_id_$value",
          originalFieldName: "nodeId",
        }
      ),
      mojo.internal.StructField(
        'node_id_$value', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "nodeId",
        }
      ),
      mojo.internal.StructField(
        'max_words_per_aggregate_passage_$flag', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "max_words_per_aggregate_passage_$value",
          originalFieldName: "maxWordsPerAggregatePassage",
        }
      ),
      mojo.internal.StructField(
        'max_words_per_aggregate_passage_$value', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "maxWordsPerAggregatePassage",
        }
      ),
      mojo.internal.StructField(
        'greedily_aggregate_sibling_nodes_$flag', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "greedily_aggregate_sibling_nodes_$value",
          originalFieldName: "greedilyAggregateSiblingNodes",
        }
      ),
      mojo.internal.StructField(
        'greedily_aggregate_sibling_nodes_$value', 0,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "greedilyAggregateSiblingNodes",
        }
      ),
      mojo.internal.StructField(
        'maxPassages', 12,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'min_words_per_passage_$flag', 0,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "min_words_per_passage_$value",
          originalFieldName: "minWordsPerPassage",
        }
      ),
      mojo.internal.StructField(
        'min_words_per_passage_$value', 16,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "minWordsPerPassage",
        }
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class InnerTextParams {
  constructor() {
    /** @type { (number|undefined) } */
    this.nodeId;
    /** @type { (number|undefined) } */
    this.maxWordsPerAggregatePassage;
    /** @type { (boolean|undefined) } */
    this.greedilyAggregateSiblingNodes;
    /** @type { !number } */
    this.maxPassages;
    /** @type { (number|undefined) } */
    this.minWordsPerPassage;
  }
}



mojo.internal.Struct(
    InnerTextAgent_GetInnerText_ParamsSpec.$,
    'InnerTextAgent_GetInnerText_Params',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        InnerTextParamsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class InnerTextAgent_GetInnerText_Params {
  constructor() {
    /** @type { !InnerTextParams } */
    this.params;
  }
}



mojo.internal.Struct(
    InnerTextAgent_GetInnerText_ResponseParamsSpec.$,
    'InnerTextAgent_GetInnerText_ResponseParams',
    [
      mojo.internal.StructField(
        'frame', 0,
        0,
        InnerTextFrameSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class InnerTextAgent_GetInnerText_ResponseParams {
  constructor() {
    /** @type { !InnerTextFrame } */
    this.frame;
  }
}

mojo.internal.Union(
    InnerTextSegmentSpec.$, 'InnerTextSegment',
    {
      'nodeLocation': {
        'ordinal': 0,
        'type': NodeLocationTypeSpec.$,
      },
      'text': {
        'ordinal': 1,
        'type': mojo.internal.String,
      },
      'frame': {
        'ordinal': 2,
        'type': InnerTextFrameSpec.$,
      },
    });

/**
 * @typedef { {
 *   nodeLocation: (!NodeLocationType|undefined),
 *   text: (!string|undefined),
 *   frame: (!InnerTextFrame|undefined),
 * } }
 */
export const InnerTextSegment = {};
