// third_party/blink/public/mojom/content_extraction/inner_text.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/content_extraction/inner_text.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/content_extraction/inner_text.mojom-params-data.h"
#include "third_party/blink/public/mojom/content_extraction/inner_text.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/content_extraction/inner_text.mojom-import-headers.h"
#include "third_party/blink/public/mojom/content_extraction/inner_text.mojom-test-utils.h"


namespace blink::mojom {
InnerTextFrame::InnerTextFrame()
    : token(),
      segments() {}

InnerTextFrame::InnerTextFrame(
    const ::blink::LocalFrameToken& token_in,
    std::vector<InnerTextSegmentPtr> segments_in)
    : token(std::move(token_in)),
      segments(std::move(segments_in)) {}

InnerTextFrame::~InnerTextFrame() = default;

void InnerTextFrame::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "token"), this->token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::LocalFrameToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "segments"), this->segments,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<InnerTextSegmentPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool InnerTextFrame::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
InnerTextParams::InnerTextParams()
    : node_id(),
      max_words_per_aggregate_passage(),
      greedily_aggregate_sibling_nodes(),
      max_passages(),
      min_words_per_passage() {}

InnerTextParams::InnerTextParams(
    std::optional<int32_t> node_id_in,
    std::optional<uint32_t> max_words_per_aggregate_passage_in,
    std::optional<bool> greedily_aggregate_sibling_nodes_in,
    uint32_t max_passages_in,
    std::optional<uint32_t> min_words_per_passage_in)
    : node_id(std::move(node_id_in)),
      max_words_per_aggregate_passage(std::move(max_words_per_aggregate_passage_in)),
      greedily_aggregate_sibling_nodes(std::move(greedily_aggregate_sibling_nodes_in)),
      max_passages(std::move(max_passages_in)),
      min_words_per_passage(std::move(min_words_per_passage_in)) {}

InnerTextParams::~InnerTextParams() = default;

void InnerTextParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "node_id"), this->node_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<int32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_words_per_aggregate_passage"), this->max_words_per_aggregate_passage,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<uint32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "greedily_aggregate_sibling_nodes"), this->greedily_aggregate_sibling_nodes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<bool>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_passages"), this->max_passages,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "min_words_per_passage"), this->min_words_per_passage,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<uint32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool InnerTextParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
InnerTextSegmentPtr
InnerTextSegment::NewNodeLocation(
    NodeLocationType value) {
  return InnerTextSegmentPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kNodeLocation)>,
      std::move(value));
}

InnerTextSegmentPtr
InnerTextSegment::NewText(
    const std::string& value) {
  return InnerTextSegmentPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kText)>,
      std::move(value));
}

InnerTextSegmentPtr
InnerTextSegment::NewFrame(
    InnerTextFramePtr value) {
  return InnerTextSegmentPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFrame)>,
      std::move(value));
}

InnerTextSegment::InnerTextSegment(
    std::in_place_index_t<static_cast<size_t>(Tag::kNodeLocation)>,
    NodeLocationType value)
    : tag_(Tag::kNodeLocation),
      data_(std::in_place_index<static_cast<size_t>(Tag::kNodeLocation)>,
            std::move(value)) {}

InnerTextSegment::InnerTextSegment(
    std::in_place_index_t<static_cast<size_t>(Tag::kText)>,
    const std::string& value)
    : tag_(Tag::kText),
      data_(std::in_place_index<static_cast<size_t>(Tag::kText)>,
            std::move(value)) {}

InnerTextSegment::InnerTextSegment(
    std::in_place_index_t<static_cast<size_t>(Tag::kFrame)>,
    InnerTextFramePtr value)
    : tag_(Tag::kFrame),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFrame)>,
            std::move(value)) {}
InnerTextSegment::~InnerTextSegment() {
  DestroyActive();
}

void InnerTextSegment::set_node_location(NodeLocationType node_location) {
  if (tag_ != Tag::kNodeLocation) {
    DestroyActive();
    tag_ = Tag::kNodeLocation;
  }
  data_.node_location = node_location;
}

void InnerTextSegment::set_text(const std::string& text) {
  if (tag_ == Tag::kText) {
    data_.text = std::move(text);
  } else {
    DestroyActive();
    tag_ = Tag::kText;
    new (&data_.text) std::string(
        std::move(text));
  }
}

void InnerTextSegment::set_frame(InnerTextFramePtr frame) {
  if (tag_ == Tag::kFrame) {
    data_.frame = std::move(frame);
  } else {
    DestroyActive();
    tag_ = Tag::kFrame;
    new (&data_.frame) InnerTextFramePtr(
        std::move(frame));
  }
}


InnerTextSegment::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kNodeLocation)>,
    NodeLocationType value)
    : node_location(std::move(value)) {}

InnerTextSegment::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kText)>,
    const std::string& value)
    : text(std::move(value)) {}

InnerTextSegment::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFrame)>,
    InnerTextFramePtr value)
    : frame(std::move(value)) {}

void InnerTextSegment::DestroyActive() {
  switch (tag_) {

    case Tag::kNodeLocation:
      std::destroy_at(&data_.node_location);
      break;
    case Tag::kText:
      std::destroy_at(&data_.text);
      break;
    case Tag::kFrame:
      std::destroy_at(&data_.frame);
      break;
  }
}

bool InnerTextSegment::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

InnerTextAgent::IPCStableHashFunction InnerTextAgent::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::InnerTextAgent>(message.name())) {
    case messages::InnerTextAgent::kGetInnerText: {
      return &InnerTextAgent::GetInnerText_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* InnerTextAgent::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::InnerTextAgent>(message.name())) {
      case messages::InnerTextAgent::kGetInnerText:
            return "Receive blink::mojom::InnerTextAgent::GetInnerText";
    }
  } else {
    switch (static_cast<messages::InnerTextAgent>(message.name())) {
      case messages::InnerTextAgent::kGetInnerText:
            return "Receive reply blink::mojom::InnerTextAgent::GetInnerText";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t InnerTextAgent::GetInnerText_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc7e0b9fb;  // IPCStableHash for blink::mojom::InnerTextAgent::GetInnerText
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class InnerTextAgent_GetInnerText_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  InnerTextAgent_GetInnerText_ForwardToCallback(
      InnerTextAgent::GetInnerTextCallback callback
      ) : callback_(std::move(callback)) {
  }

  InnerTextAgent_GetInnerText_ForwardToCallback(const InnerTextAgent_GetInnerText_ForwardToCallback&) = delete;
  InnerTextAgent_GetInnerText_ForwardToCallback& operator=(const InnerTextAgent_GetInnerText_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  InnerTextAgent::GetInnerTextCallback callback_;
};

InnerTextAgentProxy::InnerTextAgentProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void InnerTextAgentProxy::GetInnerText(
    InnerTextParamsPtr in_params, GetInnerTextCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::InnerTextAgent::GetInnerText", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type InnerTextParamsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::InnerTextAgent::kGetInnerText), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::InnerTextAgent_GetInnerText_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::InnerTextParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in InnerTextAgent.GetInnerText request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(InnerTextAgent::Name_);
  message.set_method_name("GetInnerText");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new InnerTextAgent_GetInnerText_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class InnerTextAgent_GetInnerText_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static InnerTextAgent::GetInnerTextCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<InnerTextAgent_GetInnerText_ProxyToResponder> proxy(
        new InnerTextAgent_GetInnerText_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&InnerTextAgent_GetInnerText_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~InnerTextAgent_GetInnerText_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  InnerTextAgent_GetInnerText_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "InnerTextAgent::GetInnerTextCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      InnerTextFramePtr in_frame);
};

bool InnerTextAgent_GetInnerText_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::InnerTextAgent_GetInnerText_ResponseParams_Data* params =
      reinterpret_cast<
          internal::InnerTextAgent_GetInnerText_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for InnerTextAgent.0
  bool success = true;
  InnerTextFramePtr p_frame{};
  InnerTextAgent_GetInnerText_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadFrame(&p_frame))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        InnerTextAgent::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_frame));
  }
  return true;
}

void InnerTextAgent_GetInnerText_ProxyToResponder::Run(
    InnerTextFramePtr in_frame) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::InnerTextAgent::GetInnerText", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame"), in_frame,
                        "<value of type InnerTextFramePtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::InnerTextAgent::kGetInnerText), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::InnerTextAgent_GetInnerText_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame)::BaseType> frame_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::InnerTextFrameDataView>(
    in_frame,
    frame_fragment);

  params->frame.Set(
      frame_fragment.is_null() ? nullptr : frame_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(InnerTextAgent::Name_);
  message.set_method_name("GetInnerText");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool InnerTextAgentStubDispatch::Accept(
    InnerTextAgent* impl,
    mojo::Message* message) {
  switch (static_cast<messages::InnerTextAgent>(message->header()->name)) {
    case messages::InnerTextAgent::kGetInnerText: {
      break;
    }
  }
  return false;
}

// static
bool InnerTextAgentStubDispatch::AcceptWithResponder(
    InnerTextAgent* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::InnerTextAgent>(message->header()->name)) {
    case messages::InnerTextAgent::kGetInnerText: {
      internal::InnerTextAgent_GetInnerText_Params_Data* params =
          reinterpret_cast<
              internal::InnerTextAgent_GetInnerText_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for InnerTextAgent.0
      bool success = true;
      InnerTextParamsPtr p_params{};
      InnerTextAgent_GetInnerText_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            InnerTextAgent::Name_, 0, false);
        return false;
      }
      auto callback =
          InnerTextAgent_GetInnerText_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetInnerText(        
        std::move(p_params), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kInnerTextAgentValidationInfo[] = {
    { &internal::InnerTextAgent_GetInnerText_Params_Data::Validate,
     &internal::InnerTextAgent_GetInnerText_ResponseParams_Data::Validate},
};

bool InnerTextAgentRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::InnerTextAgent::Name_,
    kInnerTextAgentValidationInfo);
}

bool InnerTextAgentResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::InnerTextAgent::Name_,
    kInnerTextAgentValidationInfo);
}


}  // blink::mojom


namespace mojo {


// static
bool StructTraits<::blink::mojom::InnerTextFrame::DataView, ::blink::mojom::InnerTextFramePtr>::Read(
    ::blink::mojom::InnerTextFrame::DataView input,
    ::blink::mojom::InnerTextFramePtr* output) {
  bool success = true;
  ::blink::mojom::InnerTextFramePtr result(::blink::mojom::InnerTextFrame::New());
  
      if (success && !input.ReadToken(&result->token))
        success = false;
      if (success && !input.ReadSegments(&result->segments))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::InnerTextParams::DataView, ::blink::mojom::InnerTextParamsPtr>::Read(
    ::blink::mojom::InnerTextParams::DataView input,
    ::blink::mojom::InnerTextParamsPtr* output) {
  bool success = true;
  ::blink::mojom::InnerTextParamsPtr result(::blink::mojom::InnerTextParams::New());
  
      if (success) {
        result->node_id = input.node_id();
      }
      if (success) {
        result->max_words_per_aggregate_passage = input.max_words_per_aggregate_passage();
      }
      if (success) {
        result->greedily_aggregate_sibling_nodes = input.greedily_aggregate_sibling_nodes();
      }
      if (success)
        result->max_passages = input.max_passages();
      if (success) {
        result->min_words_per_passage = input.min_words_per_passage();
      }
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::blink::mojom::InnerTextSegment::DataView, ::blink::mojom::InnerTextSegmentPtr>::Read(
    ::blink::mojom::InnerTextSegment::DataView input,
    ::blink::mojom::InnerTextSegmentPtr* output) {
  using UnionType = ::blink::mojom::InnerTextSegment;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kNodeLocation: {
      ::blink::mojom::NodeLocationType result_node_location;
      if (!input.ReadNodeLocation(&result_node_location))
        return false;

      *output = UnionType::NewNodeLocation(result_node_location);
      break;
    }
    case Tag::kText: {
      std::string result_text{};
      if (!input.ReadText(&result_text))
        return false;

      *output = UnionType::NewText(
          std::move(result_text));
      break;
    }
    case Tag::kFrame: {
      ::blink::mojom::InnerTextFramePtr result_frame{};
      if (!input.ReadFrame(&result_frame))
        return false;

      *output = UnionType::NewFrame(
          std::move(result_frame));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void InnerTextAgentInterceptorForTesting::GetInnerText(InnerTextParamsPtr params, GetInnerTextCallback callback) {
  GetForwardingInterface()->GetInnerText(
    std::move(params)
    , std::move(callback));
}
InnerTextAgentAsyncWaiter::InnerTextAgentAsyncWaiter(
    InnerTextAgent* proxy) : proxy_(proxy) {}

InnerTextAgentAsyncWaiter::~InnerTextAgentAsyncWaiter() = default;


void InnerTextAgentAsyncWaiter::GetInnerText(
    InnerTextParamsPtr params, InnerTextFramePtr* out_frame) {
  base::RunLoop loop;
  proxy_->GetInnerText(
      std::move(params),
      base::BindOnce(
          [](base::RunLoop* loop,
             InnerTextFramePtr* out_frame
,
             InnerTextFramePtr frame) {*out_frame = std::move(frame);
            loop->Quit();
          },
          &loop,
          out_frame));
  loop.Run();
}

InnerTextFramePtr InnerTextAgentAsyncWaiter::GetInnerText(
    InnerTextParamsPtr params) {
  InnerTextFramePtr async_wait_result;
  GetInnerText(std::move(params),&async_wait_result);
  return async_wait_result;
}






}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif