// third_party/blink/public/mojom/content_extraction/ai_page_content_metadata.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/content_extraction/ai_page_content_metadata.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../../url/mojom/url.mojom.js');
  }



  function MetaTag(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MetaTag.prototype.initDefaults_ = function() {
    this.name = null;
    this.content = null;
  };
  MetaTag.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MetaTag.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MetaTag.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate MetaTag.content
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MetaTag.encodedSize = codec.kStructHeaderSize + 16;

  MetaTag.decode = function(decoder) {
    var packed;
    var val = new MetaTag();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.name =
        decoder.decodeStruct(codec.String);
    val.content =
        decoder.decodeStruct(codec.String);
    return val;
  };

  MetaTag.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MetaTag.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.name);
    encoder.encodeStruct(codec.String, val.content);
  };
  function FrameMetadata(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameMetadata.prototype.initDefaults_ = function() {
    this.url = null;
    this.metaTags = null;
  };
  FrameMetadata.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameMetadata.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameMetadata.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameMetadata.metaTags
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(MetaTag), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameMetadata.encodedSize = codec.kStructHeaderSize + 16;

  FrameMetadata.decode = function(decoder) {
    var packed;
    var val = new FrameMetadata();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.metaTags =
        decoder.decodeArrayPointer(new codec.PointerTo(MetaTag));
    return val;
  };

  FrameMetadata.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameMetadata.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeArrayPointer(new codec.PointerTo(MetaTag), val.metaTags);
  };
  function PageMetadata(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PageMetadata.prototype.initDefaults_ = function() {
    this.frameMetadata = null;
  };
  PageMetadata.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PageMetadata.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PageMetadata.frameMetadata
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(FrameMetadata), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PageMetadata.encodedSize = codec.kStructHeaderSize + 8;

  PageMetadata.decode = function(decoder) {
    var packed;
    var val = new PageMetadata();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.frameMetadata =
        decoder.decodeArrayPointer(new codec.PointerTo(FrameMetadata));
    return val;
  };

  PageMetadata.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PageMetadata.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(FrameMetadata), val.frameMetadata);
  };
  exports.MetaTag = MetaTag;
  exports.FrameMetadata = FrameMetadata;
  exports.PageMetadata = PageMetadata;
})();