// third_party/blink/public/mojom/content_extraction/ai_page_content.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/content_extraction/ai_page_content.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var form_control_type$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/forms/form_control_type.mojom', '../forms/form_control_type.mojom.js');
  }
  var tokens$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/tokens/tokens.mojom', '../tokens/tokens.mojom.js');
  }
  var ax_enums$ =
      mojo.internal.exposeNamespace('ax.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/accessibility/ax_enums.mojom', '../../../../../ui/accessibility/ax_enums.mojom.js');
  }
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }
  var origin$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/origin.mojom', '../../../../../url/mojom/origin.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../../url/mojom/url.mojom.js');
  }
  var script_tools$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/content_extraction/script_tools.mojom', 'script_tools.mojom.js');
  }


  var AIPageContentAttributeType = {};
  AIPageContentAttributeType.kRoot = 0;
  AIPageContentAttributeType.kIframe = 1;
  AIPageContentAttributeType.kContainer = 2;
  AIPageContentAttributeType.kText = 3;
  AIPageContentAttributeType.kAnchor = 4;
  AIPageContentAttributeType.kParagraph = 5;
  AIPageContentAttributeType.kHeading = 6;
  AIPageContentAttributeType.kImage = 7;
  AIPageContentAttributeType.kSVG = 8;
  AIPageContentAttributeType.kCanvas = 9;
  AIPageContentAttributeType.kVideo = 10;
  AIPageContentAttributeType.kForm = 11;
  AIPageContentAttributeType.kFormControl = 12;
  AIPageContentAttributeType.kTable = 13;
  AIPageContentAttributeType.kTableRow = 14;
  AIPageContentAttributeType.kTableCell = 15;
  AIPageContentAttributeType.kOrderedList = 16;
  AIPageContentAttributeType.kUnorderedList = 17;
  AIPageContentAttributeType.kListItem = 18;
  AIPageContentAttributeType.MIN_VALUE = 0;
  AIPageContentAttributeType.MAX_VALUE = 18;

  AIPageContentAttributeType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
      return true;
    }
    return false;
  };

  AIPageContentAttributeType.toKnownEnumValue = function(value) {
    return value;
  };

  AIPageContentAttributeType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var AIPageContentAnnotatedRole = {};
  AIPageContentAnnotatedRole.kHeader = 0;
  AIPageContentAnnotatedRole.kNav = 1;
  AIPageContentAnnotatedRole.kSearch = 2;
  AIPageContentAnnotatedRole.kMain = 3;
  AIPageContentAnnotatedRole.kArticle = 4;
  AIPageContentAnnotatedRole.kSection = 5;
  AIPageContentAnnotatedRole.kAside = 6;
  AIPageContentAnnotatedRole.kFooter = 7;
  AIPageContentAnnotatedRole.kContentHidden = 8;
  AIPageContentAnnotatedRole.kPaidContent = 9;
  AIPageContentAnnotatedRole.MIN_VALUE = 0;
  AIPageContentAnnotatedRole.MAX_VALUE = 9;

  AIPageContentAnnotatedRole.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
      return true;
    }
    return false;
  };

  AIPageContentAnnotatedRole.toKnownEnumValue = function(value) {
    return value;
  };

  AIPageContentAnnotatedRole.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var AIPageContentClickabilityReason = {};
  AIPageContentClickabilityReason.kClickableControl = 0;
  AIPageContentClickabilityReason.kClickEvents = 1;
  AIPageContentClickabilityReason.kMouseEvents = 2;
  AIPageContentClickabilityReason.kMouseClick = 3;
  AIPageContentClickabilityReason.kMouseHover = 4;
  AIPageContentClickabilityReason.kKeyEvents = 5;
  AIPageContentClickabilityReason.kEditable = 6;
  AIPageContentClickabilityReason.kCursorPointer = 7;
  AIPageContentClickabilityReason.kAriaRole = 8;
  AIPageContentClickabilityReason.kAriaHasPopup = 9;
  AIPageContentClickabilityReason.kAriaExpandedTrue = 10;
  AIPageContentClickabilityReason.kAriaExpandedFalse = 11;
  AIPageContentClickabilityReason.kTabIndex = 12;
  AIPageContentClickabilityReason.kAutocomplete = 13;
  AIPageContentClickabilityReason.MIN_VALUE = 0;
  AIPageContentClickabilityReason.MAX_VALUE = 13;

  AIPageContentClickabilityReason.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
      return true;
    }
    return false;
  };

  AIPageContentClickabilityReason.toKnownEnumValue = function(value) {
    return value;
  };

  AIPageContentClickabilityReason.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var AIPageContentTextSize = {};
  AIPageContentTextSize.kXS = 0;
  AIPageContentTextSize.kS = 1;
  AIPageContentTextSize.kM = 2;
  AIPageContentTextSize.kL = 3;
  AIPageContentTextSize.kXL = 4;
  AIPageContentTextSize.MIN_VALUE = 0;
  AIPageContentTextSize.MAX_VALUE = 4;

  AIPageContentTextSize.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
      return true;
    }
    return false;
  };

  AIPageContentTextSize.toKnownEnumValue = function(value) {
    return value;
  };

  AIPageContentTextSize.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var AIPageContentAnchorRel = {};
  AIPageContentAnchorRel.kRelationUnknown = 0;
  AIPageContentAnchorRel.kRelationNoReferrer = 1;
  AIPageContentAnchorRel.kRelationNoOpener = 2;
  AIPageContentAnchorRel.kRelationOpener = 3;
  AIPageContentAnchorRel.kRelationPrivacyPolicy = 4;
  AIPageContentAnchorRel.kRelationTermsOfService = 5;
  AIPageContentAnchorRel.MIN_VALUE = 0;
  AIPageContentAnchorRel.MAX_VALUE = 5;

  AIPageContentAnchorRel.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
      return true;
    }
    return false;
  };

  AIPageContentAnchorRel.toKnownEnumValue = function(value) {
    return value;
  };

  AIPageContentAnchorRel.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var AIPageContentTableRowType = {};
  AIPageContentTableRowType.kHeader = 0;
  AIPageContentTableRowType.kBody = 1;
  AIPageContentTableRowType.kFooter = 2;
  AIPageContentTableRowType.MIN_VALUE = 0;
  AIPageContentTableRowType.MAX_VALUE = 2;

  AIPageContentTableRowType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  AIPageContentTableRowType.toKnownEnumValue = function(value) {
    return value;
  };

  AIPageContentTableRowType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var AIPageContentRedactionDecision = {};
  AIPageContentRedactionDecision.kNoRedactionNecessary = 0;
  AIPageContentRedactionDecision.kUnredacted_EmptyPassword = 1;
  AIPageContentRedactionDecision.kRedacted_HasBeenPassword = 2;
  AIPageContentRedactionDecision.MIN_VALUE = 0;
  AIPageContentRedactionDecision.MAX_VALUE = 2;

  AIPageContentRedactionDecision.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  AIPageContentRedactionDecision.toKnownEnumValue = function(value) {
    return value;
  };

  AIPageContentRedactionDecision.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var AIPageContentMode = {};
  AIPageContentMode.kDefault = 0;
  AIPageContentMode.kActionableElements = 1;
  AIPageContentMode.MIN_VALUE = 0;
  AIPageContentMode.MAX_VALUE = 1;

  AIPageContentMode.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  AIPageContentMode.toKnownEnumValue = function(value) {
    return value;
  };

  AIPageContentMode.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function AIPageContentGeometry(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIPageContentGeometry.prototype.initDefaults_ = function() {
    this.outerBoundingBox = null;
    this.visibleBoundingBox = null;
    this.fragmentVisibleBoundingBoxes = null;
    this.isFixedOrStickyPosition = false;
  };
  AIPageContentGeometry.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIPageContentGeometry.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentGeometry.outerBoundingBox
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, geometry$.Rect, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentGeometry.visibleBoundingBox
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, geometry$.Rect, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentGeometry.fragmentVisibleBoundingBoxes
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, new codec.PointerTo(geometry$.Rect), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  AIPageContentGeometry.encodedSize = codec.kStructHeaderSize + 32;

  AIPageContentGeometry.decode = function(decoder) {
    var packed;
    var val = new AIPageContentGeometry();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.outerBoundingBox =
        decoder.decodeStructPointer(geometry$.Rect);
    val.visibleBoundingBox =
        decoder.decodeStructPointer(geometry$.Rect);
    val.fragmentVisibleBoundingBoxes =
        decoder.decodeArrayPointer(new codec.PointerTo(geometry$.Rect));
    packed = decoder.readUint8();
    val.isFixedOrStickyPosition = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  AIPageContentGeometry.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIPageContentGeometry.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(geometry$.Rect, val.outerBoundingBox);
    encoder.encodeStructPointer(geometry$.Rect, val.visibleBoundingBox);
    encoder.encodeArrayPointer(new codec.PointerTo(geometry$.Rect), val.fragmentVisibleBoundingBoxes);
    packed = 0;
    packed |= (val.isFixedOrStickyPosition & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function AIPageContentSelection(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIPageContentSelection.prototype.initDefaults_ = function() {
    this.startDomNodeId = 0;
    this.startOffset = 0;
    this.endDomNodeId = 0;
    this.endOffset = 0;
    this.selectedText = null;
  };
  AIPageContentSelection.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIPageContentSelection.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;






    // validate AIPageContentSelection.selectedText
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIPageContentSelection.encodedSize = codec.kStructHeaderSize + 24;

  AIPageContentSelection.decode = function(decoder) {
    var packed;
    var val = new AIPageContentSelection();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.startDomNodeId =
        decoder.decodeStruct(codec.Int32);
    val.startOffset =
        decoder.decodeStruct(codec.Int32);
    val.endDomNodeId =
        decoder.decodeStruct(codec.Int32);
    val.endOffset =
        decoder.decodeStruct(codec.Int32);
    val.selectedText =
        decoder.decodeStruct(codec.String);
    return val;
  };

  AIPageContentSelection.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIPageContentSelection.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.startDomNodeId);
    encoder.encodeStruct(codec.Int32, val.startOffset);
    encoder.encodeStruct(codec.Int32, val.endDomNodeId);
    encoder.encodeStruct(codec.Int32, val.endOffset);
    encoder.encodeStruct(codec.String, val.selectedText);
  };
  function AIPageContentPageInteractionInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIPageContentPageInteractionInfo.prototype.initDefaults_ = function() {
    this.focused_dom_node_id_$flag = false;
    this.accessibility_focused_dom_node_id_$flag = false;
    this.focused_dom_node_id_$value = 0;
    this.accessibility_focused_dom_node_id_$value = 0;
    this.mousePosition = null;
  };
  AIPageContentPageInteractionInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIPageContentPageInteractionInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;






    // validate AIPageContentPageInteractionInfo.mousePosition
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, geometry$.Point, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIPageContentPageInteractionInfo.encodedSize = codec.kStructHeaderSize + 24;

  AIPageContentPageInteractionInfo.decode = function(decoder) {
    var packed;
    var val = new AIPageContentPageInteractionInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.focused_dom_node_id_$flag = (packed >> 0) & 1 ? true : false;
    val.accessibility_focused_dom_node_id_$flag = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.focused_dom_node_id_$value =
        decoder.decodeStruct(codec.Int32);
    val.accessibility_focused_dom_node_id_$value =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.mousePosition =
        decoder.decodeStructPointer(geometry$.Point);
    return val;
  };

  AIPageContentPageInteractionInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIPageContentPageInteractionInfo.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.focused_dom_node_id_$flag & 1) << 0
    packed |= (val.accessibility_focused_dom_node_id_$flag & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.focused_dom_node_id_$value);
    encoder.encodeStruct(codec.Int32, val.accessibility_focused_dom_node_id_$value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(geometry$.Point, val.mousePosition);
  };
  function AIPageContentFrameInteractionInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIPageContentFrameInteractionInfo.prototype.initDefaults_ = function() {
    this.selection = null;
  };
  AIPageContentFrameInteractionInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIPageContentFrameInteractionInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentFrameInteractionInfo.selection
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, AIPageContentSelection, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIPageContentFrameInteractionInfo.encodedSize = codec.kStructHeaderSize + 8;

  AIPageContentFrameInteractionInfo.decode = function(decoder) {
    var packed;
    var val = new AIPageContentFrameInteractionInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.selection =
        decoder.decodeStructPointer(AIPageContentSelection);
    return val;
  };

  AIPageContentFrameInteractionInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIPageContentFrameInteractionInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(AIPageContentSelection, val.selection);
  };
  function AIPageContentNodeInteractionInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIPageContentNodeInteractionInfo.prototype.initDefaults_ = function() {
    this.scrollerInfo = null;
    this.isFocusable = false;
    this.isClickable = false;
    this.document_scoped_z_order_$flag = false;
    this.document_scoped_z_order_$value = 0;
    this.clickabilityReasons = null;
  };
  AIPageContentNodeInteractionInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIPageContentNodeInteractionInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentNodeInteractionInfo.scrollerInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, AIPageContentScrollerInfo, true);
    if (err !== validator.validationError.NONE)
        return err;






    // validate AIPageContentNodeInteractionInfo.clickabilityReasons
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 4, new codec.Enum(AIPageContentClickabilityReason), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIPageContentNodeInteractionInfo.encodedSize = codec.kStructHeaderSize + 24;

  AIPageContentNodeInteractionInfo.decode = function(decoder) {
    var packed;
    var val = new AIPageContentNodeInteractionInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.scrollerInfo =
        decoder.decodeStructPointer(AIPageContentScrollerInfo);
    packed = decoder.readUint8();
    val.isFocusable = (packed >> 0) & 1 ? true : false;
    val.isClickable = (packed >> 1) & 1 ? true : false;
    val.document_scoped_z_order_$flag = (packed >> 2) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.document_scoped_z_order_$value =
        decoder.decodeStruct(codec.Int32);
    val.clickabilityReasons =
        decoder.decodeArrayPointer(new codec.Enum(AIPageContentClickabilityReason));
    return val;
  };

  AIPageContentNodeInteractionInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIPageContentNodeInteractionInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(AIPageContentScrollerInfo, val.scrollerInfo);
    packed = 0;
    packed |= (val.isFocusable & 1) << 0
    packed |= (val.isClickable & 1) << 1
    packed |= (val.document_scoped_z_order_$flag & 1) << 2
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.document_scoped_z_order_$value);
    encoder.encodeArrayPointer(new codec.Enum(AIPageContentClickabilityReason), val.clickabilityReasons);
  };
  function AIPageContentScrollerInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIPageContentScrollerInfo.prototype.initDefaults_ = function() {
    this.scrollingBounds = null;
    this.visibleArea = null;
    this.userScrollableHorizontal = false;
    this.userScrollableVertical = false;
  };
  AIPageContentScrollerInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIPageContentScrollerInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentScrollerInfo.scrollingBounds
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentScrollerInfo.visibleArea
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, geometry$.Rect, false);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  AIPageContentScrollerInfo.encodedSize = codec.kStructHeaderSize + 24;

  AIPageContentScrollerInfo.decode = function(decoder) {
    var packed;
    var val = new AIPageContentScrollerInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.scrollingBounds =
        decoder.decodeStructPointer(geometry$.Size);
    val.visibleArea =
        decoder.decodeStructPointer(geometry$.Rect);
    packed = decoder.readUint8();
    val.userScrollableHorizontal = (packed >> 0) & 1 ? true : false;
    val.userScrollableVertical = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  AIPageContentScrollerInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIPageContentScrollerInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(geometry$.Size, val.scrollingBounds);
    encoder.encodeStructPointer(geometry$.Rect, val.visibleArea);
    packed = 0;
    packed |= (val.userScrollableHorizontal & 1) << 0
    packed |= (val.userScrollableVertical & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function AIPageContentTextStyle(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIPageContentTextStyle.prototype.initDefaults_ = function() {
    this.textSize = 0;
    this.hasEmphasis = false;
    this.color = 0;
  };
  AIPageContentTextStyle.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIPageContentTextStyle.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentTextStyle.textSize
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, AIPageContentTextSize);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  AIPageContentTextStyle.encodedSize = codec.kStructHeaderSize + 16;

  AIPageContentTextStyle.decode = function(decoder) {
    var packed;
    var val = new AIPageContentTextStyle();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.textSize =
        decoder.decodeStruct(new codec.Enum(AIPageContentTextSize));
    packed = decoder.readUint8();
    val.hasEmphasis = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.color =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  AIPageContentTextStyle.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIPageContentTextStyle.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.textSize);
    packed = 0;
    packed |= (val.hasEmphasis & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint32, val.color);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function AIPageContentTextInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIPageContentTextInfo.prototype.initDefaults_ = function() {
    this.textContent = null;
    this.textStyle = null;
  };
  AIPageContentTextInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIPageContentTextInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentTextInfo.textContent
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentTextInfo.textStyle
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, AIPageContentTextStyle, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIPageContentTextInfo.encodedSize = codec.kStructHeaderSize + 16;

  AIPageContentTextInfo.decode = function(decoder) {
    var packed;
    var val = new AIPageContentTextInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.textContent =
        decoder.decodeStruct(codec.String);
    val.textStyle =
        decoder.decodeStructPointer(AIPageContentTextStyle);
    return val;
  };

  AIPageContentTextInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIPageContentTextInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.textContent);
    encoder.encodeStructPointer(AIPageContentTextStyle, val.textStyle);
  };
  function AIPageContentAnchorData(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIPageContentAnchorData.prototype.initDefaults_ = function() {
    this.url = null;
    this.rel = null;
  };
  AIPageContentAnchorData.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIPageContentAnchorData.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentAnchorData.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentAnchorData.rel
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 4, new codec.Enum(AIPageContentAnchorRel), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIPageContentAnchorData.encodedSize = codec.kStructHeaderSize + 16;

  AIPageContentAnchorData.decode = function(decoder) {
    var packed;
    var val = new AIPageContentAnchorData();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.rel =
        decoder.decodeArrayPointer(new codec.Enum(AIPageContentAnchorRel));
    return val;
  };

  AIPageContentAnchorData.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIPageContentAnchorData.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeArrayPointer(new codec.Enum(AIPageContentAnchorRel), val.rel);
  };
  function AIPageContentImageInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIPageContentImageInfo.prototype.initDefaults_ = function() {
    this.imageCaption = null;
    this.sourceOrigin = null;
  };
  AIPageContentImageInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIPageContentImageInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentImageInfo.imageCaption
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentImageInfo.sourceOrigin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, origin$.Origin, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIPageContentImageInfo.encodedSize = codec.kStructHeaderSize + 16;

  AIPageContentImageInfo.decode = function(decoder) {
    var packed;
    var val = new AIPageContentImageInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.imageCaption =
        decoder.decodeStruct(codec.String);
    val.sourceOrigin =
        decoder.decodeStructPointer(origin$.Origin);
    return val;
  };

  AIPageContentImageInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIPageContentImageInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.imageCaption);
    encoder.encodeStructPointer(origin$.Origin, val.sourceOrigin);
  };
  function AIPageContentSVGData(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIPageContentSVGData.prototype.initDefaults_ = function() {
    this.innerText = null;
  };
  AIPageContentSVGData.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIPageContentSVGData.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentSVGData.innerText
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, true)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIPageContentSVGData.encodedSize = codec.kStructHeaderSize + 8;

  AIPageContentSVGData.decode = function(decoder) {
    var packed;
    var val = new AIPageContentSVGData();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.innerText =
        decoder.decodeStruct(codec.String);
    return val;
  };

  AIPageContentSVGData.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIPageContentSVGData.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.innerText);
  };
  function AIPageContentCanvasData(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIPageContentCanvasData.prototype.initDefaults_ = function() {
    this.layoutSize = null;
  };
  AIPageContentCanvasData.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIPageContentCanvasData.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentCanvasData.layoutSize
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIPageContentCanvasData.encodedSize = codec.kStructHeaderSize + 8;

  AIPageContentCanvasData.decode = function(decoder) {
    var packed;
    var val = new AIPageContentCanvasData();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.layoutSize =
        decoder.decodeStructPointer(geometry$.Size);
    return val;
  };

  AIPageContentCanvasData.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIPageContentCanvasData.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(geometry$.Size, val.layoutSize);
  };
  function AIPageContentVideoData(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIPageContentVideoData.prototype.initDefaults_ = function() {
    this.url = null;
    this.sourceOrigin = null;
  };
  AIPageContentVideoData.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIPageContentVideoData.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentVideoData.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentVideoData.sourceOrigin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, origin$.Origin, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIPageContentVideoData.encodedSize = codec.kStructHeaderSize + 16;

  AIPageContentVideoData.decode = function(decoder) {
    var packed;
    var val = new AIPageContentVideoData();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.sourceOrigin =
        decoder.decodeStructPointer(origin$.Origin);
    return val;
  };

  AIPageContentVideoData.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIPageContentVideoData.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStructPointer(origin$.Origin, val.sourceOrigin);
  };
  function AIPageContentMeta(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIPageContentMeta.prototype.initDefaults_ = function() {
    this.name = null;
    this.content = null;
  };
  AIPageContentMeta.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIPageContentMeta.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentMeta.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentMeta.content
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIPageContentMeta.encodedSize = codec.kStructHeaderSize + 16;

  AIPageContentMeta.decode = function(decoder) {
    var packed;
    var val = new AIPageContentMeta();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.name =
        decoder.decodeStruct(codec.String);
    val.content =
        decoder.decodeStruct(codec.String);
    return val;
  };

  AIPageContentMeta.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIPageContentMeta.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.name);
    encoder.encodeStruct(codec.String, val.content);
  };
  function AIPageContentFrameData(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIPageContentFrameData.prototype.initDefaults_ = function() {
    this.frameInteractionInfo = null;
    this.metaData = null;
    this.title = null;
    this.contains_paid_content_$flag = false;
    this.contains_paid_content_$value = false;
    this.scriptTools = null;
  };
  AIPageContentFrameData.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIPageContentFrameData.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentFrameData.frameInteractionInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, AIPageContentFrameInteractionInfo, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentFrameData.metaData
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(AIPageContentMeta), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentFrameData.title
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, true)
    if (err !== validator.validationError.NONE)
        return err;




    // validate AIPageContentFrameData.scriptTools
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 32, 8, new codec.PointerTo(script_tools$.ScriptTool), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIPageContentFrameData.encodedSize = codec.kStructHeaderSize + 40;

  AIPageContentFrameData.decode = function(decoder) {
    var packed;
    var val = new AIPageContentFrameData();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.frameInteractionInfo =
        decoder.decodeStructPointer(AIPageContentFrameInteractionInfo);
    val.metaData =
        decoder.decodeArrayPointer(new codec.PointerTo(AIPageContentMeta));
    val.title =
        decoder.decodeStruct(codec.String);
    packed = decoder.readUint8();
    val.contains_paid_content_$flag = (packed >> 0) & 1 ? true : false;
    val.contains_paid_content_$value = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.scriptTools =
        decoder.decodeArrayPointer(new codec.PointerTo(script_tools$.ScriptTool));
    return val;
  };

  AIPageContentFrameData.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIPageContentFrameData.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(AIPageContentFrameInteractionInfo, val.frameInteractionInfo);
    encoder.encodeArrayPointer(new codec.PointerTo(AIPageContentMeta), val.metaData);
    encoder.encodeStruct(codec.String, val.title);
    packed = 0;
    packed |= (val.contains_paid_content_$flag & 1) << 0
    packed |= (val.contains_paid_content_$value & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.PointerTo(script_tools$.ScriptTool), val.scriptTools);
  };
  function RedactedFrameMetadata(values) {
    this.initDefaults_();
    this.initFields_(values);
  }

  RedactedFrameMetadata.Reason = {};
  RedactedFrameMetadata.Reason.kCrossSite = 0;
  RedactedFrameMetadata.Reason.kCrossOrigin = 1;
  RedactedFrameMetadata.Reason.MIN_VALUE = 0;
  RedactedFrameMetadata.Reason.MAX_VALUE = 1;

  RedactedFrameMetadata.Reason.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  RedactedFrameMetadata.Reason.toKnownEnumValue = function(value) {
    return value;
  };

  RedactedFrameMetadata.Reason.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  RedactedFrameMetadata.prototype.initDefaults_ = function() {
    this.reason = 0;
  };
  RedactedFrameMetadata.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RedactedFrameMetadata.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RedactedFrameMetadata.reason
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, RedactedFrameMetadata.Reason);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RedactedFrameMetadata.encodedSize = codec.kStructHeaderSize + 8;

  RedactedFrameMetadata.decode = function(decoder) {
    var packed;
    var val = new RedactedFrameMetadata();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.reason =
        decoder.decodeStruct(new codec.Enum(RedactedFrameMetadata.Reason));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  RedactedFrameMetadata.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RedactedFrameMetadata.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.reason);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function AIPageContentIframeData(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIPageContentIframeData.prototype.initDefaults_ = function() {
    this.frameToken = null;
    this.likelyAdFrame = false;
    this.content = null;
  };
  AIPageContentIframeData.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIPageContentIframeData.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentIframeData.frameToken
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, tokens$.FrameToken, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate AIPageContentIframeData.content
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 24, AIPageContentIframeContent, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIPageContentIframeData.encodedSize = codec.kStructHeaderSize + 40;

  AIPageContentIframeData.decode = function(decoder) {
    var packed;
    var val = new AIPageContentIframeData();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.frameToken =
        decoder.decodeStruct(tokens$.FrameToken);
    packed = decoder.readUint8();
    val.likelyAdFrame = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.content =
        decoder.decodeStruct(AIPageContentIframeContent);
    return val;
  };

  AIPageContentIframeData.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIPageContentIframeData.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(tokens$.FrameToken, val.frameToken);
    packed = 0;
    packed |= (val.likelyAdFrame & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(AIPageContentIframeContent, val.content);
  };
  function AIPageContentTableData(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIPageContentTableData.prototype.initDefaults_ = function() {
    this.tableName = null;
  };
  AIPageContentTableData.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIPageContentTableData.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentTableData.tableName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, true)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIPageContentTableData.encodedSize = codec.kStructHeaderSize + 8;

  AIPageContentTableData.decode = function(decoder) {
    var packed;
    var val = new AIPageContentTableData();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.tableName =
        decoder.decodeStruct(codec.String);
    return val;
  };

  AIPageContentTableData.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIPageContentTableData.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.tableName);
  };
  function AIPageContentTableRowData(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIPageContentTableRowData.prototype.initDefaults_ = function() {
    this.rowType = 0;
  };
  AIPageContentTableRowData.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIPageContentTableRowData.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentTableRowData.rowType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, AIPageContentTableRowType);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIPageContentTableRowData.encodedSize = codec.kStructHeaderSize + 8;

  AIPageContentTableRowData.decode = function(decoder) {
    var packed;
    var val = new AIPageContentTableRowData();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.rowType =
        decoder.decodeStruct(new codec.Enum(AIPageContentTableRowType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  AIPageContentTableRowData.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIPageContentTableRowData.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.rowType);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function AIPageContentFormData(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIPageContentFormData.prototype.initDefaults_ = function() {
    this.formName = null;
  };
  AIPageContentFormData.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIPageContentFormData.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentFormData.formName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, true)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIPageContentFormData.encodedSize = codec.kStructHeaderSize + 8;

  AIPageContentFormData.decode = function(decoder) {
    var packed;
    var val = new AIPageContentFormData();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.formName =
        decoder.decodeStruct(codec.String);
    return val;
  };

  AIPageContentFormData.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIPageContentFormData.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.formName);
  };
  function AIPageContentSelectOption(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIPageContentSelectOption.prototype.initDefaults_ = function() {
    this.value = null;
    this.text = null;
    this.isSelected = false;
    this.disabled = false;
  };
  AIPageContentSelectOption.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIPageContentSelectOption.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentSelectOption.value
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentSelectOption.text
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, true)
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  AIPageContentSelectOption.encodedSize = codec.kStructHeaderSize + 24;

  AIPageContentSelectOption.decode = function(decoder) {
    var packed;
    var val = new AIPageContentSelectOption();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStruct(codec.String);
    val.text =
        decoder.decodeStruct(codec.String);
    packed = decoder.readUint8();
    val.isSelected = (packed >> 0) & 1 ? true : false;
    val.disabled = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  AIPageContentSelectOption.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIPageContentSelectOption.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.value);
    encoder.encodeStruct(codec.String, val.text);
    packed = 0;
    packed |= (val.isSelected & 1) << 0
    packed |= (val.disabled & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function AIPageContentFormControlData(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIPageContentFormControlData.prototype.initDefaults_ = function() {
    this.formControlType = 0;
    this.isChecked = false;
    this.isRequired = false;
    this.fieldName = null;
    this.fieldValue = null;
    this.selectOptions = null;
    this.placeholder = null;
    this.redactionDecision = 0;
  };
  AIPageContentFormControlData.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIPageContentFormControlData.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentFormControlData.formControlType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, form_control_type$.FormControlType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentFormControlData.fieldName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentFormControlData.fieldValue
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentFormControlData.selectOptions
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 24, 8, new codec.PointerTo(AIPageContentSelectOption), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentFormControlData.placeholder
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 32, true)
    if (err !== validator.validationError.NONE)
        return err;




    // validate AIPageContentFormControlData.redactionDecision
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 40, AIPageContentRedactionDecision);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIPageContentFormControlData.encodedSize = codec.kStructHeaderSize + 48;

  AIPageContentFormControlData.decode = function(decoder) {
    var packed;
    var val = new AIPageContentFormControlData();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.formControlType =
        decoder.decodeStruct(new codec.Enum(form_control_type$.FormControlType));
    packed = decoder.readUint8();
    val.isChecked = (packed >> 0) & 1 ? true : false;
    val.isRequired = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.fieldName =
        decoder.decodeStruct(codec.String);
    val.fieldValue =
        decoder.decodeStruct(codec.String);
    val.selectOptions =
        decoder.decodeArrayPointer(new codec.PointerTo(AIPageContentSelectOption));
    val.placeholder =
        decoder.decodeStruct(codec.String);
    val.redactionDecision =
        decoder.decodeStruct(new codec.Enum(AIPageContentRedactionDecision));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  AIPageContentFormControlData.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIPageContentFormControlData.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.formControlType);
    packed = 0;
    packed |= (val.isChecked & 1) << 0
    packed |= (val.isRequired & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.fieldName);
    encoder.encodeStruct(codec.String, val.fieldValue);
    encoder.encodeArrayPointer(new codec.PointerTo(AIPageContentSelectOption), val.selectOptions);
    encoder.encodeStruct(codec.String, val.placeholder);
    encoder.encodeStruct(codec.Int32, val.redactionDecision);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function AIPageContentAttributes(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIPageContentAttributes.prototype.initDefaults_ = function() {
    this.dom_node_id_$flag = false;
    this.aria_role_$flag = false;
    this.label_for_dom_node_id_$flag = false;
    this.dom_node_id_$value = 0;
    this.attributeType = 0;
    this.aria_role_$value = 0;
    this.geometry = null;
    this.nodeInteractionInfo = null;
    this.textInfo = null;
    this.imageInfo = null;
    this.svgData = null;
    this.canvasData = null;
    this.videoData = null;
    this.anchorData = null;
    this.formData = null;
    this.formControlData = null;
    this.tableData = null;
    this.iframeData = null;
    this.tableRowData = null;
    this.annotatedRoles = null;
    this.label = null;
    this.label_for_dom_node_id_$value = 0;
  };
  AIPageContentAttributes.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIPageContentAttributes.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 152}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate AIPageContentAttributes.attributeType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, AIPageContentAttributeType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentAttributes.geometry
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, AIPageContentGeometry, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentAttributes.nodeInteractionInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, AIPageContentNodeInteractionInfo, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentAttributes.textInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, AIPageContentTextInfo, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentAttributes.imageInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, AIPageContentImageInfo, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentAttributes.svgData
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, AIPageContentSVGData, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentAttributes.canvasData
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 56, AIPageContentCanvasData, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentAttributes.videoData
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 64, AIPageContentVideoData, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentAttributes.anchorData
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 72, AIPageContentAnchorData, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentAttributes.formData
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 80, AIPageContentFormData, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentAttributes.formControlData
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 88, AIPageContentFormControlData, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentAttributes.tableData
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 96, AIPageContentTableData, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentAttributes.iframeData
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 104, AIPageContentIframeData, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentAttributes.tableRowData
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 112, AIPageContentTableRowData, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentAttributes.annotatedRoles
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 120, 4, new codec.Enum(AIPageContentAnnotatedRole), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentAttributes.label
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 128, true)
    if (err !== validator.validationError.NONE)
        return err;



    // validate AIPageContentAttributes.aria_role_$value
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 12, ax_enums$.Role);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  AIPageContentAttributes.encodedSize = codec.kStructHeaderSize + 144;

  AIPageContentAttributes.decode = function(decoder) {
    var packed;
    var val = new AIPageContentAttributes();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.dom_node_id_$flag = (packed >> 0) & 1 ? true : false;
    val.aria_role_$flag = (packed >> 1) & 1 ? true : false;
    val.label_for_dom_node_id_$flag = (packed >> 2) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.dom_node_id_$value =
        decoder.decodeStruct(codec.Int32);
    val.attributeType =
        decoder.decodeStruct(new codec.Enum(AIPageContentAttributeType));
    val.aria_role_$value =
        decoder.decodeStruct(new codec.Enum(ax_enums$.Role));
    val.geometry =
        decoder.decodeStructPointer(AIPageContentGeometry);
    val.nodeInteractionInfo =
        decoder.decodeStructPointer(AIPageContentNodeInteractionInfo);
    val.textInfo =
        decoder.decodeStructPointer(AIPageContentTextInfo);
    val.imageInfo =
        decoder.decodeStructPointer(AIPageContentImageInfo);
    val.svgData =
        decoder.decodeStructPointer(AIPageContentSVGData);
    val.canvasData =
        decoder.decodeStructPointer(AIPageContentCanvasData);
    val.videoData =
        decoder.decodeStructPointer(AIPageContentVideoData);
    val.anchorData =
        decoder.decodeStructPointer(AIPageContentAnchorData);
    val.formData =
        decoder.decodeStructPointer(AIPageContentFormData);
    val.formControlData =
        decoder.decodeStructPointer(AIPageContentFormControlData);
    val.tableData =
        decoder.decodeStructPointer(AIPageContentTableData);
    val.iframeData =
        decoder.decodeStructPointer(AIPageContentIframeData);
    val.tableRowData =
        decoder.decodeStructPointer(AIPageContentTableRowData);
    val.annotatedRoles =
        decoder.decodeArrayPointer(new codec.Enum(AIPageContentAnnotatedRole));
    val.label =
        decoder.decodeStruct(codec.String);
    val.label_for_dom_node_id_$value =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  AIPageContentAttributes.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIPageContentAttributes.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.dom_node_id_$flag & 1) << 0
    packed |= (val.aria_role_$flag & 1) << 1
    packed |= (val.label_for_dom_node_id_$flag & 1) << 2
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.dom_node_id_$value);
    encoder.encodeStruct(codec.Int32, val.attributeType);
    encoder.encodeStruct(codec.Int32, val.aria_role_$value);
    encoder.encodeStructPointer(AIPageContentGeometry, val.geometry);
    encoder.encodeStructPointer(AIPageContentNodeInteractionInfo, val.nodeInteractionInfo);
    encoder.encodeStructPointer(AIPageContentTextInfo, val.textInfo);
    encoder.encodeStructPointer(AIPageContentImageInfo, val.imageInfo);
    encoder.encodeStructPointer(AIPageContentSVGData, val.svgData);
    encoder.encodeStructPointer(AIPageContentCanvasData, val.canvasData);
    encoder.encodeStructPointer(AIPageContentVideoData, val.videoData);
    encoder.encodeStructPointer(AIPageContentAnchorData, val.anchorData);
    encoder.encodeStructPointer(AIPageContentFormData, val.formData);
    encoder.encodeStructPointer(AIPageContentFormControlData, val.formControlData);
    encoder.encodeStructPointer(AIPageContentTableData, val.tableData);
    encoder.encodeStructPointer(AIPageContentIframeData, val.iframeData);
    encoder.encodeStructPointer(AIPageContentTableRowData, val.tableRowData);
    encoder.encodeArrayPointer(new codec.Enum(AIPageContentAnnotatedRole), val.annotatedRoles);
    encoder.encodeStruct(codec.String, val.label);
    encoder.encodeStruct(codec.Int32, val.label_for_dom_node_id_$value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function AIPageContentNode(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIPageContentNode.prototype.initDefaults_ = function() {
    this.childrenNodes = null;
    this.contentAttributes = null;
  };
  AIPageContentNode.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIPageContentNode.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentNode.childrenNodes
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(AIPageContentNode), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentNode.contentAttributes
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, AIPageContentAttributes, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIPageContentNode.encodedSize = codec.kStructHeaderSize + 16;

  AIPageContentNode.decode = function(decoder) {
    var packed;
    var val = new AIPageContentNode();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.childrenNodes =
        decoder.decodeArrayPointer(new codec.PointerTo(AIPageContentNode));
    val.contentAttributes =
        decoder.decodeStructPointer(AIPageContentAttributes);
    return val;
  };

  AIPageContentNode.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIPageContentNode.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(AIPageContentNode), val.childrenNodes);
    encoder.encodeStructPointer(AIPageContentAttributes, val.contentAttributes);
  };
  function AIPageContent(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIPageContent.prototype.initDefaults_ = function() {
    this.rootNode = null;
    this.pageInteractionInfo = null;
    this.frameData = null;
  };
  AIPageContent.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIPageContent.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContent.rootNode
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, AIPageContentNode, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContent.pageInteractionInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, AIPageContentPageInteractionInfo, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContent.frameData
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, AIPageContentFrameData, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIPageContent.encodedSize = codec.kStructHeaderSize + 24;

  AIPageContent.decode = function(decoder) {
    var packed;
    var val = new AIPageContent();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.rootNode =
        decoder.decodeStructPointer(AIPageContentNode);
    val.pageInteractionInfo =
        decoder.decodeStructPointer(AIPageContentPageInteractionInfo);
    val.frameData =
        decoder.decodeStructPointer(AIPageContentFrameData);
    return val;
  };

  AIPageContent.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIPageContent.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(AIPageContentNode, val.rootNode);
    encoder.encodeStructPointer(AIPageContentPageInteractionInfo, val.pageInteractionInfo);
    encoder.encodeStructPointer(AIPageContentFrameData, val.frameData);
  };
  function AIPageContentOptions(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIPageContentOptions.prototype.initDefaults_ = function() {
    this.mode = 0;
    this.onCriticalPath = false;
    this.includeSameSiteOnly = false;
    this.maxMetaElements = 0;
  };
  AIPageContentOptions.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIPageContentOptions.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentOptions.mode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, AIPageContentMode);
    if (err !== validator.validationError.NONE)
        return err;




    return validator.validationError.NONE;
  };

  AIPageContentOptions.encodedSize = codec.kStructHeaderSize + 16;

  AIPageContentOptions.decode = function(decoder) {
    var packed;
    var val = new AIPageContentOptions();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.mode =
        decoder.decodeStruct(new codec.Enum(AIPageContentMode));
    packed = decoder.readUint8();
    val.onCriticalPath = (packed >> 0) & 1 ? true : false;
    val.includeSameSiteOnly = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.maxMetaElements =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  AIPageContentOptions.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIPageContentOptions.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.mode);
    packed = 0;
    packed |= (val.onCriticalPath & 1) << 0
    packed |= (val.includeSameSiteOnly & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.maxMetaElements);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function AIPageContentAgent_GetAIPageContent_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIPageContentAgent_GetAIPageContent_Params.prototype.initDefaults_ = function() {
    this.request = null;
  };
  AIPageContentAgent_GetAIPageContent_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIPageContentAgent_GetAIPageContent_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentAgent_GetAIPageContent_Params.request
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, AIPageContentOptions, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIPageContentAgent_GetAIPageContent_Params.encodedSize = codec.kStructHeaderSize + 8;

  AIPageContentAgent_GetAIPageContent_Params.decode = function(decoder) {
    var packed;
    var val = new AIPageContentAgent_GetAIPageContent_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.request =
        decoder.decodeStructPointer(AIPageContentOptions);
    return val;
  };

  AIPageContentAgent_GetAIPageContent_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIPageContentAgent_GetAIPageContent_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(AIPageContentOptions, val.request);
  };
  function AIPageContentAgent_GetAIPageContent_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIPageContentAgent_GetAIPageContent_ResponseParams.prototype.initDefaults_ = function() {
    this.pageContent = null;
  };
  AIPageContentAgent_GetAIPageContent_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIPageContentAgent_GetAIPageContent_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIPageContentAgent_GetAIPageContent_ResponseParams.pageContent
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, AIPageContent, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIPageContentAgent_GetAIPageContent_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  AIPageContentAgent_GetAIPageContent_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new AIPageContentAgent_GetAIPageContent_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.pageContent =
        decoder.decodeStructPointer(AIPageContent);
    return val;
  };

  AIPageContentAgent_GetAIPageContent_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIPageContentAgent_GetAIPageContent_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(AIPageContent, val.pageContent);
  };

  function AIPageContentIframeContent(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  AIPageContentIframeContent.Tags = {
    localFrameData: 0,
    redactedFrameMetadata: 1,
  };

  AIPageContentIframeContent.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  AIPageContentIframeContent.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "localFrameData",
        "redactedFrameMetadata",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a AIPageContentIframeContent member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(AIPageContentIframeContent.prototype, "localFrameData", {
    get: function() {
      if (this.$tag != AIPageContentIframeContent.Tags.localFrameData) {
        throw new ReferenceError(
            "AIPageContentIframeContent.localFrameData is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = AIPageContentIframeContent.Tags.localFrameData;
      this.$data = value;
    }
  });
  Object.defineProperty(AIPageContentIframeContent.prototype, "redactedFrameMetadata", {
    get: function() {
      if (this.$tag != AIPageContentIframeContent.Tags.redactedFrameMetadata) {
        throw new ReferenceError(
            "AIPageContentIframeContent.redactedFrameMetadata is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = AIPageContentIframeContent.Tags.redactedFrameMetadata;
      this.$data = value;
    }
  });


    AIPageContentIframeContent.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case AIPageContentIframeContent.Tags.localFrameData:
          encoder.encodeStructPointer(AIPageContentFrameData, val.localFrameData);
          break;
        case AIPageContentIframeContent.Tags.redactedFrameMetadata:
          encoder.encodeStructPointer(RedactedFrameMetadata, val.redactedFrameMetadata);
          break;
      }
      encoder.align();
    };


    AIPageContentIframeContent.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new AIPageContentIframeContent();
      var tag = decoder.readUint32();
      switch (tag) {
        case AIPageContentIframeContent.Tags.localFrameData:
          result.localFrameData = decoder.decodeStructPointer(AIPageContentFrameData);
          break;
        case AIPageContentIframeContent.Tags.redactedFrameMetadata:
          result.redactedFrameMetadata = decoder.decodeStructPointer(RedactedFrameMetadata);
          break;
      }
      decoder.align();

      return result;
    };


    AIPageContentIframeContent.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case AIPageContentIframeContent.Tags.localFrameData:
          

    // validate AIPageContentIframeContent.localFrameData
    err = messageValidator.validateStructPointer(data_offset, AIPageContentFrameData, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case AIPageContentIframeContent.Tags.redactedFrameMetadata:
          

    // validate AIPageContentIframeContent.redactedFrameMetadata
    err = messageValidator.validateStructPointer(data_offset, RedactedFrameMetadata, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  AIPageContentIframeContent.encodedSize = 16;
  var kAIPageContentAgent_GetAIPageContent_Name = 0;

  function AIPageContentAgentPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(AIPageContentAgent,
                                                   handleOrPtrInfo);
  }

  function AIPageContentAgentAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        AIPageContentAgent, associatedInterfacePtrInfo);
  }

  AIPageContentAgentAssociatedPtr.prototype =
      Object.create(AIPageContentAgentPtr.prototype);
  AIPageContentAgentAssociatedPtr.prototype.constructor =
      AIPageContentAgentAssociatedPtr;

  function AIPageContentAgentProxy(receiver) {
    this.receiver_ = receiver;
  }
  AIPageContentAgentPtr.prototype.getAIPageContent = function() {
    return AIPageContentAgentProxy.prototype.getAIPageContent
        .apply(this.ptr.getProxy(), arguments);
  };

  AIPageContentAgentProxy.prototype.getAIPageContent = function(request) {
    var params_ = new AIPageContentAgent_GetAIPageContent_Params();
    params_.request = request;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kAIPageContentAgent_GetAIPageContent_Name,
          codec.align(AIPageContentAgent_GetAIPageContent_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(AIPageContentAgent_GetAIPageContent_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(AIPageContentAgent_GetAIPageContent_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function AIPageContentAgentStub(delegate) {
    this.delegate_ = delegate;
  }
  AIPageContentAgentStub.prototype.getAIPageContent = function(request) {
    return this.delegate_ && this.delegate_.getAIPageContent && this.delegate_.getAIPageContent(request);
  }

  AIPageContentAgentStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  AIPageContentAgentStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kAIPageContentAgent_GetAIPageContent_Name:
      var params = reader.decodeStruct(AIPageContentAgent_GetAIPageContent_Params);
      this.getAIPageContent(params.request).then(function(response) {
        var responseParams =
            new AIPageContentAgent_GetAIPageContent_ResponseParams();
        responseParams.pageContent = response.pageContent;
        var builder = new codec.MessageV1Builder(
            kAIPageContentAgent_GetAIPageContent_Name,
            codec.align(AIPageContentAgent_GetAIPageContent_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(AIPageContentAgent_GetAIPageContent_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateAIPageContentAgentRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kAIPageContentAgent_GetAIPageContent_Name:
        if (message.expectsResponse())
          paramsClass = AIPageContentAgent_GetAIPageContent_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateAIPageContentAgentResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kAIPageContentAgent_GetAIPageContent_Name:
        if (message.isResponse())
          paramsClass = AIPageContentAgent_GetAIPageContent_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var AIPageContentAgent = {
    name: 'blink.mojom.AIPageContentAgent',
    kVersion: 0,
    ptrClass: AIPageContentAgentPtr,
    proxyClass: AIPageContentAgentProxy,
    stubClass: AIPageContentAgentStub,
    validateRequest: validateAIPageContentAgentRequest,
    validateResponse: validateAIPageContentAgentResponse,
  };
  AIPageContentAgentStub.prototype.validator = validateAIPageContentAgentRequest;
  AIPageContentAgentProxy.prototype.validator = validateAIPageContentAgentResponse;
  exports.AIPageContentAttributeType = AIPageContentAttributeType;
  exports.AIPageContentAnnotatedRole = AIPageContentAnnotatedRole;
  exports.AIPageContentClickabilityReason = AIPageContentClickabilityReason;
  exports.AIPageContentTextSize = AIPageContentTextSize;
  exports.AIPageContentAnchorRel = AIPageContentAnchorRel;
  exports.AIPageContentTableRowType = AIPageContentTableRowType;
  exports.AIPageContentRedactionDecision = AIPageContentRedactionDecision;
  exports.AIPageContentMode = AIPageContentMode;
  exports.AIPageContentGeometry = AIPageContentGeometry;
  exports.AIPageContentSelection = AIPageContentSelection;
  exports.AIPageContentPageInteractionInfo = AIPageContentPageInteractionInfo;
  exports.AIPageContentFrameInteractionInfo = AIPageContentFrameInteractionInfo;
  exports.AIPageContentNodeInteractionInfo = AIPageContentNodeInteractionInfo;
  exports.AIPageContentScrollerInfo = AIPageContentScrollerInfo;
  exports.AIPageContentTextStyle = AIPageContentTextStyle;
  exports.AIPageContentTextInfo = AIPageContentTextInfo;
  exports.AIPageContentAnchorData = AIPageContentAnchorData;
  exports.AIPageContentImageInfo = AIPageContentImageInfo;
  exports.AIPageContentSVGData = AIPageContentSVGData;
  exports.AIPageContentCanvasData = AIPageContentCanvasData;
  exports.AIPageContentVideoData = AIPageContentVideoData;
  exports.AIPageContentMeta = AIPageContentMeta;
  exports.AIPageContentFrameData = AIPageContentFrameData;
  exports.RedactedFrameMetadata = RedactedFrameMetadata;
  exports.AIPageContentIframeData = AIPageContentIframeData;
  exports.AIPageContentTableData = AIPageContentTableData;
  exports.AIPageContentTableRowData = AIPageContentTableRowData;
  exports.AIPageContentFormData = AIPageContentFormData;
  exports.AIPageContentSelectOption = AIPageContentSelectOption;
  exports.AIPageContentFormControlData = AIPageContentFormControlData;
  exports.AIPageContentAttributes = AIPageContentAttributes;
  exports.AIPageContentNode = AIPageContentNode;
  exports.AIPageContent = AIPageContent;
  exports.AIPageContentOptions = AIPageContentOptions;
  exports.AIPageContentIframeContent = AIPageContentIframeContent;
  exports.AIPageContentAgent = AIPageContentAgent;
  exports.AIPageContentAgentPtr = AIPageContentAgentPtr;
  exports.AIPageContentAgentAssociatedPtr = AIPageContentAgentAssociatedPtr;
})();