// third_party/blink/public/mojom/clipboard/clipboard.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CLIPBOARD_CLIPBOARD_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CLIPBOARD_CLIPBOARD_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/clipboard/clipboard.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/clipboard/clipboard.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/clipboard/clipboard.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/big_buffer.mojom-blink.h"
#include "mojo/public/mojom/base/big_string.mojom-blink.h"
#include "mojo/public/mojom/base/string16.mojom-blink.h"
#include "skia/public/mojom/bitmap.mojom-blink.h"
#include "third_party/blink/public/mojom/data_transfer/data_transfer.mojom-blink.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-blink.h"
#include "url/mojom/url.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {

class ClipboardListenerProxy;

template <typename ImplRefTraits>
class ClipboardListenerStub;

class ClipboardListenerRequestValidator;


class PLATFORM_EXPORT ClipboardListener
    : public ClipboardListenerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.ClipboardListener";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ClipboardListenerInterfaceBase;
  using Proxy_ = ClipboardListenerProxy;

  template <typename ImplRefTraits>
  using Stub_ = ClipboardListenerStub<ImplRefTraits>;

  using RequestValidator_ = ClipboardListenerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnClipboardDataChangedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnClipboardDataChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ClipboardListener() = default;

  virtual void OnClipboardDataChanged() = 0;
};

class ClipboardHostProxy;

template <typename ImplRefTraits>
class ClipboardHostStub;

class ClipboardHostRequestValidator;
class ClipboardHostResponseValidator;


class PLATFORM_EXPORT ClipboardHost
    : public ClipboardHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.ClipboardHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    0, 
    1, 
    2, 
    3, 
    4, 
    6, 
    7, 
    8, 
    9, 
    10
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ClipboardHostInterfaceBase;
  using Proxy_ = ClipboardHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = ClipboardHostStub<ImplRefTraits>;

  using RequestValidator_ = ClipboardHostRequestValidator;
  using ResponseValidator_ = ClipboardHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetSequenceNumberMinVersion = 0,
    kIsFormatAvailableMinVersion = 0,
    kReadAvailableTypesMinVersion = 0,
    kReadTextMinVersion = 0,
    kReadHtmlMinVersion = 0,
    kReadSvgMinVersion = 0,
    kReadRtfMinVersion = 0,
    kReadPngMinVersion = 0,
    kReadFilesMinVersion = 0,
    kReadDataTransferCustomDataMinVersion = 0,
    kReadAvailableCustomAndStandardFormatsMinVersion = 0,
    kReadUnsanitizedCustomFormatMinVersion = 0,
    kWriteTextMinVersion = 0,
    kWriteHtmlMinVersion = 0,
    kWriteSvgMinVersion = 0,
    kWriteSmartPasteMarkerMinVersion = 0,
    kWriteDataTransferCustomDataMinVersion = 0,
    kWriteBookmarkMinVersion = 0,
    kWriteImageMinVersion = 0,
    kWriteUnsanitizedCustomFormatMinVersion = 0,
    kCommitWriteMinVersion = 0,
    kBeginCopyWithCompletionMinVersion = 0,
    kEndCopyWithCompletionMinVersion = 0,
    kBeginPasteWithCompletionMinVersion = 0,
    kEndPasteWithCompletionMinVersion = 0,
    kWriteStringToFindPboardMinVersion = 0,
    kGetPlatformPermissionStateMinVersion = 0,
    kRegisterClipboardListenerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetSequenceNumber_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct IsFormatAvailable_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReadAvailableTypes_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReadText_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReadHtml_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReadSvg_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReadRtf_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReadPng_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReadFiles_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReadDataTransferCustomData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReadAvailableCustomAndStandardFormats_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReadUnsanitizedCustomFormat_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct WriteText_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct WriteHtml_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct WriteSvg_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct WriteSmartPasteMarker_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct WriteDataTransferCustomData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct WriteBookmark_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct WriteImage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct WriteUnsanitizedCustomFormat_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CommitWrite_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BeginCopyWithCompletion_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EndCopyWithCompletion_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BeginPasteWithCompletion_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EndPasteWithCompletion_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct WriteStringToFindPboard_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetPlatformPermissionState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RegisterClipboardListener_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  
  static constexpr uint32_t kMaxFormatSize = 1024U;
  
  static constexpr uint32_t kMaxDataSize = 1073741824U;
  virtual ~ClipboardHost() = default;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetSequenceNumber(ClipboardBuffer buffer, ::blink::ClipboardSequenceNumberToken* out_result);
  using GetSequenceNumberCallback = base::OnceCallback<void(const ::blink::ClipboardSequenceNumberToken&)>;
  using GetSequenceNumberMojoCallback = base::OnceCallback<void(const ::blink::ClipboardSequenceNumberToken&)>;

  virtual void GetSequenceNumber(ClipboardBuffer buffer, GetSequenceNumberCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool IsFormatAvailable(ClipboardFormat format, ClipboardBuffer buffer, bool* out_result);
  using IsFormatAvailableCallback = base::OnceCallback<void(bool)>;
  using IsFormatAvailableMojoCallback = base::OnceCallback<void(bool)>;

  virtual void IsFormatAvailable(ClipboardFormat format, ClipboardBuffer buffer, IsFormatAvailableCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool ReadAvailableTypes(ClipboardBuffer buffer, ::blink::Vector<::blink::String>* out_types);
  using ReadAvailableTypesCallback = base::OnceCallback<void(const ::blink::Vector<::blink::String>&)>;
  using ReadAvailableTypesMojoCallback = base::OnceCallback<void(const ::blink::Vector<::blink::String>&)>;

  virtual void ReadAvailableTypes(ClipboardBuffer buffer, ReadAvailableTypesCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool ReadText(ClipboardBuffer buffer, ::blink::String* out_result);
  using ReadTextCallback = base::OnceCallback<void(const ::blink::String&)>;
  using ReadTextMojoCallback = base::OnceCallback<void(const ::blink::String&)>;

  virtual void ReadText(ClipboardBuffer buffer, ReadTextCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool ReadHtml(ClipboardBuffer buffer, ::blink::String* out_markup, ::blink::KURL* out_url, uint32_t* out_fragment_start, uint32_t* out_fragment_end);
  using ReadHtmlCallback = base::OnceCallback<void(const ::blink::String&, const ::blink::KURL&, uint32_t, uint32_t)>;
  using ReadHtmlMojoCallback = base::OnceCallback<void(const ::blink::String&, const ::blink::KURL&, uint32_t, uint32_t)>;

  virtual void ReadHtml(ClipboardBuffer buffer, ReadHtmlCallback callback) = 0;

  using ReadSvgCallback = base::OnceCallback<void(const ::blink::String&)>;
  using ReadSvgMojoCallback = base::OnceCallback<void(const ::blink::String&)>;

  virtual void ReadSvg(ClipboardBuffer buffer, ReadSvgCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool ReadRtf(ClipboardBuffer buffer, ::blink::String* out_result);
  using ReadRtfCallback = base::OnceCallback<void(const ::blink::String&)>;
  using ReadRtfMojoCallback = base::OnceCallback<void(const ::blink::String&)>;

  virtual void ReadRtf(ClipboardBuffer buffer, ReadRtfCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool ReadPng(ClipboardBuffer buffer, ::mojo_base::BigBuffer* out_png);
  using ReadPngCallback = base::OnceCallback<void(::mojo_base::BigBuffer)>;
  using ReadPngMojoCallback = base::OnceCallback<void(::mojo_base::BigBuffer)>;

  virtual void ReadPng(ClipboardBuffer buffer, ReadPngCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool ReadFiles(ClipboardBuffer buffer, ClipboardFilesPtr* out_result);
  using ReadFilesCallback = base::OnceCallback<void(ClipboardFilesPtr)>;
  using ReadFilesMojoCallback = base::OnceCallback<void(ClipboardFilesPtr)>;

  virtual void ReadFiles(ClipboardBuffer buffer, ReadFilesCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool ReadDataTransferCustomData(ClipboardBuffer buffer, const ::blink::String& type, ::blink::String* out_result);
  using ReadDataTransferCustomDataCallback = base::OnceCallback<void(const ::blink::String&)>;
  using ReadDataTransferCustomDataMojoCallback = base::OnceCallback<void(const ::blink::String&)>;

  virtual void ReadDataTransferCustomData(ClipboardBuffer buffer, const ::blink::String& type, ReadDataTransferCustomDataCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool ReadAvailableCustomAndStandardFormats(::blink::Vector<::blink::String>* out_format_types);
  using ReadAvailableCustomAndStandardFormatsCallback = base::OnceCallback<void(const ::blink::Vector<::blink::String>&)>;
  using ReadAvailableCustomAndStandardFormatsMojoCallback = base::OnceCallback<void(const ::blink::Vector<::blink::String>&)>;

  virtual void ReadAvailableCustomAndStandardFormats(ReadAvailableCustomAndStandardFormatsCallback callback) = 0;

  using ReadUnsanitizedCustomFormatCallback = base::OnceCallback<void(::mojo_base::BigBuffer)>;
  using ReadUnsanitizedCustomFormatMojoCallback = base::OnceCallback<void(::mojo_base::BigBuffer)>;

  virtual void ReadUnsanitizedCustomFormat(const ::blink::String& format, ReadUnsanitizedCustomFormatCallback callback) = 0;

  virtual void WriteText(const ::blink::String& text) = 0;

  virtual void WriteHtml(const ::blink::String& markup, const ::blink::KURL& url) = 0;

  virtual void WriteSvg(const ::blink::String& markup) = 0;

  virtual void WriteSmartPasteMarker() = 0;

  virtual void WriteDataTransferCustomData(const ::blink::HashMap<::blink::String, ::blink::String>& data) = 0;

  virtual void WriteBookmark(const ::blink::String& url, const ::blink::String& title) = 0;

  virtual void WriteImage(const ::SkBitmap& image) = 0;

  virtual void WriteUnsanitizedCustomFormat(const ::blink::String& format, ::mojo_base::BigBuffer data) = 0;

  virtual void CommitWrite() = 0;

  virtual void BeginCopyWithCompletion(int32_t token) = 0;

  using EndCopyWithCompletionCallback = base::OnceCallback<void(int32_t)>;
  using EndCopyWithCompletionMojoCallback = base::OnceCallback<void(int32_t)>;

  virtual void EndCopyWithCompletion(int32_t token, EndCopyWithCompletionCallback callback) = 0;

  virtual void BeginPasteWithCompletion(int32_t token) = 0;

  using EndPasteWithCompletionCallback = base::OnceCallback<void(int32_t)>;
  using EndPasteWithCompletionMojoCallback = base::OnceCallback<void(int32_t)>;

  virtual void EndPasteWithCompletion(int32_t token, EndPasteWithCompletionCallback callback) = 0;

  virtual void WriteStringToFindPboard(const ::blink::String& text) = 0;

  using GetPlatformPermissionStateCallback = base::OnceCallback<void(PlatformClipboardPermissionState)>;
  using GetPlatformPermissionStateMojoCallback = base::OnceCallback<void(PlatformClipboardPermissionState)>;

  virtual void GetPlatformPermissionState(GetPlatformPermissionStateCallback callback) = 0;

  virtual void RegisterClipboardListener(::mojo::PendingRemote<ClipboardListener> listener) = 0;
};



class PLATFORM_EXPORT ClipboardListenerProxy
    : public ClipboardListener {
 public:
  using InterfaceType = ClipboardListener;

  explicit ClipboardListenerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnClipboardDataChanged() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class PLATFORM_EXPORT ClipboardHostProxy
    : public ClipboardHost {
 public:
  using InterfaceType = ClipboardHost;

  explicit ClipboardHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  bool GetSequenceNumber(ClipboardBuffer buffer, ::blink::ClipboardSequenceNumberToken* out_result) final;
  
  void GetSequenceNumber(ClipboardBuffer buffer, GetSequenceNumberCallback callback) final;
  
  bool IsFormatAvailable(ClipboardFormat format, ClipboardBuffer buffer, bool* out_result) final;
  
  void IsFormatAvailable(ClipboardFormat format, ClipboardBuffer buffer, IsFormatAvailableCallback callback) final;
  
  bool ReadAvailableTypes(ClipboardBuffer buffer, ::blink::Vector<::blink::String>* out_types) final;
  
  void ReadAvailableTypes(ClipboardBuffer buffer, ReadAvailableTypesCallback callback) final;
  
  bool ReadText(ClipboardBuffer buffer, ::blink::String* out_result) final;
  
  void ReadText(ClipboardBuffer buffer, ReadTextCallback callback) final;
  
  bool ReadHtml(ClipboardBuffer buffer, ::blink::String* out_markup, ::blink::KURL* out_url, uint32_t* out_fragment_start, uint32_t* out_fragment_end) final;
  
  void ReadHtml(ClipboardBuffer buffer, ReadHtmlCallback callback) final;
  
  void ReadSvg(ClipboardBuffer buffer, ReadSvgCallback callback) final;
  
  bool ReadRtf(ClipboardBuffer buffer, ::blink::String* out_result) final;
  
  void ReadRtf(ClipboardBuffer buffer, ReadRtfCallback callback) final;
  
  bool ReadPng(ClipboardBuffer buffer, ::mojo_base::BigBuffer* out_png) final;
  
  void ReadPng(ClipboardBuffer buffer, ReadPngCallback callback) final;
  
  bool ReadFiles(ClipboardBuffer buffer, ClipboardFilesPtr* out_result) final;
  
  void ReadFiles(ClipboardBuffer buffer, ReadFilesCallback callback) final;
  
  bool ReadDataTransferCustomData(ClipboardBuffer buffer, const ::blink::String& type, ::blink::String* out_result) final;
  
  void ReadDataTransferCustomData(ClipboardBuffer buffer, const ::blink::String& type, ReadDataTransferCustomDataCallback callback) final;
  
  bool ReadAvailableCustomAndStandardFormats(::blink::Vector<::blink::String>* out_format_types) final;
  
  void ReadAvailableCustomAndStandardFormats(ReadAvailableCustomAndStandardFormatsCallback callback) final;
  
  void ReadUnsanitizedCustomFormat(const ::blink::String& format, ReadUnsanitizedCustomFormatCallback callback) final;
  
  void WriteText(const ::blink::String& text) final;
  
  void WriteHtml(const ::blink::String& markup, const ::blink::KURL& url) final;
  
  void WriteSvg(const ::blink::String& markup) final;
  
  void WriteSmartPasteMarker() final;
  
  void WriteDataTransferCustomData(const ::blink::HashMap<::blink::String, ::blink::String>& data) final;
  
  void WriteBookmark(const ::blink::String& url, const ::blink::String& title) final;
  
  void WriteImage(const ::SkBitmap& image) final;
  
  void WriteUnsanitizedCustomFormat(const ::blink::String& format, ::mojo_base::BigBuffer data) final;
  
  void CommitWrite() final;
  
  void BeginCopyWithCompletion(int32_t token) final;
  
  void EndCopyWithCompletion(int32_t token, EndCopyWithCompletionCallback callback) final;
  
  void BeginPasteWithCompletion(int32_t token) final;
  
  void EndPasteWithCompletion(int32_t token, EndPasteWithCompletionCallback callback) final;
  
  void WriteStringToFindPboard(const ::blink::String& text) final;
  
  void GetPlatformPermissionState(GetPlatformPermissionStateCallback callback) final;
  
  void RegisterClipboardListener(::mojo::PendingRemote<ClipboardListener> listener) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT ClipboardListenerStubDispatch {
 public:
  static bool Accept(ClipboardListener* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ClipboardListener* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ClipboardListener>>
class ClipboardListenerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ClipboardListenerStub() = default;
  ~ClipboardListenerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ClipboardListenerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ClipboardListenerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT ClipboardHostStubDispatch {
 public:
  static bool Accept(ClipboardHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ClipboardHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ClipboardHost>>
class ClipboardHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ClipboardHostStub() = default;
  ~ClipboardHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ClipboardHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ClipboardHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT ClipboardListenerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT ClipboardHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT ClipboardHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class PLATFORM_EXPORT ClipboardFiles {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ClipboardFiles, T>::value>;
  using DataView = ClipboardFilesDataView;
  using Data_ = internal::ClipboardFiles_Data;

  template <typename... Args>
  static ClipboardFilesPtr New(Args&&... args) {
    return ClipboardFilesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ClipboardFilesPtr From(const U& u) {
    return mojo::TypeConverter<ClipboardFilesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ClipboardFiles>::Convert(*this);
  }


  ClipboardFiles();

  ClipboardFiles(
      ::blink::Vector<::blink::mojom::blink::DataTransferFilePtr> files,
      const ::blink::String& file_system_id);

ClipboardFiles(const ClipboardFiles&) = delete;
ClipboardFiles& operator=(const ClipboardFiles&) = delete;

  ~ClipboardFiles();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ClipboardFilesPtr>
  ClipboardFilesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ClipboardFiles::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ClipboardFiles::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ClipboardFiles::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ClipboardFiles::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ClipboardFiles_UnserializedMessageContext<
            UserType, ClipboardFiles::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ClipboardFiles::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ClipboardFiles::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ClipboardFiles_UnserializedMessageContext<
            UserType, ClipboardFiles::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ClipboardFiles::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<::blink::mojom::blink::DataTransferFilePtr> files;
  
  ::blink::String file_system_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ClipboardFiles::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ClipboardFiles::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ClipboardFiles::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ClipboardFiles::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ClipboardFilesPtr ClipboardFiles::Clone() const {
  return New(
      mojo::Clone(files),
      mojo::Clone(file_system_id)
  );
}

template <typename T, ClipboardFiles::EnableIfSame<T>*>
bool ClipboardFiles::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->files, other_struct.files))
    return false;
  if (!mojo::Equals(this->file_system_id, other_struct.file_system_id))
    return false;
  return true;
}

template <typename T, ClipboardFiles::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.files < rhs.files)
    return true;
  if (rhs.files < lhs.files)
    return false;
  if (lhs.file_system_id < rhs.file_system_id)
    return true;
  if (rhs.file_system_id < lhs.file_system_id)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::ClipboardFiles::DataView,
                                         ::blink::mojom::blink::ClipboardFilesPtr> {
  static bool IsNull(const ::blink::mojom::blink::ClipboardFilesPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::ClipboardFilesPtr* output) { output->reset(); }

  static  decltype(::blink::mojom::blink::ClipboardFiles::files)& files(
       ::blink::mojom::blink::ClipboardFilesPtr& input) {
    return input->files;
  }

  static const decltype(::blink::mojom::blink::ClipboardFiles::file_system_id)& file_system_id(
      const ::blink::mojom::blink::ClipboardFilesPtr& input) {
    return input->file_system_id;
  }

  static bool Read(::blink::mojom::blink::ClipboardFiles::DataView input, ::blink::mojom::blink::ClipboardFilesPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_CLIPBOARD_CLIPBOARD_MOJOM_BLINK_H_