// third_party/blink/public/mojom/clipboard/clipboard.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/clipboard/clipboard.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/clipboard/clipboard.mojom-params-data.h"
#include "third_party/blink/public/mojom/clipboard/clipboard.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/clipboard/clipboard.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/clipboard/clipboard.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
ClipboardFiles::ClipboardFiles()
    : files(),
      file_system_id() {}

ClipboardFiles::ClipboardFiles(
    ::blink::Vector<::blink::mojom::blink::DataTransferFilePtr> files_in,
    const ::blink::String& file_system_id_in)
    : files(std::move(files_in)),
      file_system_id(std::move(file_system_id_in)) {}

ClipboardFiles::~ClipboardFiles() = default;

void ClipboardFiles::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "files"), this->files,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<::blink::mojom::blink::DataTransferFilePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "file_system_id"), this->file_system_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ClipboardFiles::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

ClipboardListener::IPCStableHashFunction ClipboardListener::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ClipboardListener>(message.name())) {
    case messages::ClipboardListener::kOnClipboardDataChanged: {
      return &ClipboardListener::OnClipboardDataChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ClipboardListener::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ClipboardListener>(message.name())) {
      case messages::ClipboardListener::kOnClipboardDataChanged:
            return "Receive blink::mojom::ClipboardListener::OnClipboardDataChanged";
    }
  } else {
    switch (static_cast<messages::ClipboardListener>(message.name())) {
      case messages::ClipboardListener::kOnClipboardDataChanged:
            return "Receive reply blink::mojom::ClipboardListener::OnClipboardDataChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ClipboardListener::OnClipboardDataChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xde5bfa13;  // IPCStableHash for blink::mojom::ClipboardListener::OnClipboardDataChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ClipboardListenerProxy::ClipboardListenerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ClipboardListenerProxy::OnClipboardDataChanged(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::ClipboardListener::OnClipboardDataChanged");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardListener::kOnClipboardDataChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardListener_OnClipboardDataChanged_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardListener::Name_);
  message.set_method_name("OnClipboardDataChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ClipboardListenerStubDispatch::Accept(
    ClipboardListener* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ClipboardListener>(message->header()->name)) {
    case messages::ClipboardListener::kOnClipboardDataChanged: {
      DCHECK(message->is_serialized());
      internal::ClipboardListener_OnClipboardDataChanged_Params_Data* params =
          reinterpret_cast<internal::ClipboardListener_OnClipboardDataChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ClipboardListener.0
      bool success = true;
      ClipboardListener_OnClipboardDataChanged_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClipboardListener::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnClipboardDataChanged(        );
      return true;
    }
  }
  return false;
}

// static
bool ClipboardListenerStubDispatch::AcceptWithResponder(
    ClipboardListener* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ClipboardListener>(message->header()->name)) {
    case messages::ClipboardListener::kOnClipboardDataChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kClipboardListenerValidationInfo[] = {
    { &internal::ClipboardListener_OnClipboardDataChanged_Params_Data::Validate,
     nullptr /* no response */},
};

bool ClipboardListenerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::ClipboardListener::Name_,
    kClipboardListenerValidationInfo);
}

// The declaration includes the definition on other builds.
constexpr uint32_t ClipboardHost::kMaxFormatSize;
constexpr uint32_t ClipboardHost::kMaxDataSize;

ClipboardHost::IPCStableHashFunction ClipboardHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ClipboardHost>(message.name())) {
    case messages::ClipboardHost::kGetSequenceNumber: {
      return &ClipboardHost::GetSequenceNumber_Sym::IPCStableHash;
    }
    case messages::ClipboardHost::kIsFormatAvailable: {
      return &ClipboardHost::IsFormatAvailable_Sym::IPCStableHash;
    }
    case messages::ClipboardHost::kReadAvailableTypes: {
      return &ClipboardHost::ReadAvailableTypes_Sym::IPCStableHash;
    }
    case messages::ClipboardHost::kReadText: {
      return &ClipboardHost::ReadText_Sym::IPCStableHash;
    }
    case messages::ClipboardHost::kReadHtml: {
      return &ClipboardHost::ReadHtml_Sym::IPCStableHash;
    }
    case messages::ClipboardHost::kReadSvg: {
      return &ClipboardHost::ReadSvg_Sym::IPCStableHash;
    }
    case messages::ClipboardHost::kReadRtf: {
      return &ClipboardHost::ReadRtf_Sym::IPCStableHash;
    }
    case messages::ClipboardHost::kReadPng: {
      return &ClipboardHost::ReadPng_Sym::IPCStableHash;
    }
    case messages::ClipboardHost::kReadFiles: {
      return &ClipboardHost::ReadFiles_Sym::IPCStableHash;
    }
    case messages::ClipboardHost::kReadDataTransferCustomData: {
      return &ClipboardHost::ReadDataTransferCustomData_Sym::IPCStableHash;
    }
    case messages::ClipboardHost::kReadAvailableCustomAndStandardFormats: {
      return &ClipboardHost::ReadAvailableCustomAndStandardFormats_Sym::IPCStableHash;
    }
    case messages::ClipboardHost::kReadUnsanitizedCustomFormat: {
      return &ClipboardHost::ReadUnsanitizedCustomFormat_Sym::IPCStableHash;
    }
    case messages::ClipboardHost::kWriteText: {
      return &ClipboardHost::WriteText_Sym::IPCStableHash;
    }
    case messages::ClipboardHost::kWriteHtml: {
      return &ClipboardHost::WriteHtml_Sym::IPCStableHash;
    }
    case messages::ClipboardHost::kWriteSvg: {
      return &ClipboardHost::WriteSvg_Sym::IPCStableHash;
    }
    case messages::ClipboardHost::kWriteSmartPasteMarker: {
      return &ClipboardHost::WriteSmartPasteMarker_Sym::IPCStableHash;
    }
    case messages::ClipboardHost::kWriteDataTransferCustomData: {
      return &ClipboardHost::WriteDataTransferCustomData_Sym::IPCStableHash;
    }
    case messages::ClipboardHost::kWriteBookmark: {
      return &ClipboardHost::WriteBookmark_Sym::IPCStableHash;
    }
    case messages::ClipboardHost::kWriteImage: {
      return &ClipboardHost::WriteImage_Sym::IPCStableHash;
    }
    case messages::ClipboardHost::kWriteUnsanitizedCustomFormat: {
      return &ClipboardHost::WriteUnsanitizedCustomFormat_Sym::IPCStableHash;
    }
    case messages::ClipboardHost::kCommitWrite: {
      return &ClipboardHost::CommitWrite_Sym::IPCStableHash;
    }
    case messages::ClipboardHost::kBeginCopyWithCompletion: {
      return &ClipboardHost::BeginCopyWithCompletion_Sym::IPCStableHash;
    }
    case messages::ClipboardHost::kEndCopyWithCompletion: {
      return &ClipboardHost::EndCopyWithCompletion_Sym::IPCStableHash;
    }
    case messages::ClipboardHost::kBeginPasteWithCompletion: {
      return &ClipboardHost::BeginPasteWithCompletion_Sym::IPCStableHash;
    }
    case messages::ClipboardHost::kEndPasteWithCompletion: {
      return &ClipboardHost::EndPasteWithCompletion_Sym::IPCStableHash;
    }
    case messages::ClipboardHost::kWriteStringToFindPboard: {
      return &ClipboardHost::WriteStringToFindPboard_Sym::IPCStableHash;
    }
    case messages::ClipboardHost::kGetPlatformPermissionState: {
      return &ClipboardHost::GetPlatformPermissionState_Sym::IPCStableHash;
    }
    case messages::ClipboardHost::kRegisterClipboardListener: {
      return &ClipboardHost::RegisterClipboardListener_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ClipboardHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ClipboardHost>(message.name())) {
      case messages::ClipboardHost::kGetSequenceNumber:
            return "Receive blink::mojom::ClipboardHost::GetSequenceNumber";
      case messages::ClipboardHost::kIsFormatAvailable:
            return "Receive blink::mojom::ClipboardHost::IsFormatAvailable";
      case messages::ClipboardHost::kReadAvailableTypes:
            return "Receive blink::mojom::ClipboardHost::ReadAvailableTypes";
      case messages::ClipboardHost::kReadText:
            return "Receive blink::mojom::ClipboardHost::ReadText";
      case messages::ClipboardHost::kReadHtml:
            return "Receive blink::mojom::ClipboardHost::ReadHtml";
      case messages::ClipboardHost::kReadSvg:
            return "Receive blink::mojom::ClipboardHost::ReadSvg";
      case messages::ClipboardHost::kReadRtf:
            return "Receive blink::mojom::ClipboardHost::ReadRtf";
      case messages::ClipboardHost::kReadPng:
            return "Receive blink::mojom::ClipboardHost::ReadPng";
      case messages::ClipboardHost::kReadFiles:
            return "Receive blink::mojom::ClipboardHost::ReadFiles";
      case messages::ClipboardHost::kReadDataTransferCustomData:
            return "Receive blink::mojom::ClipboardHost::ReadDataTransferCustomData";
      case messages::ClipboardHost::kReadAvailableCustomAndStandardFormats:
            return "Receive blink::mojom::ClipboardHost::ReadAvailableCustomAndStandardFormats";
      case messages::ClipboardHost::kReadUnsanitizedCustomFormat:
            return "Receive blink::mojom::ClipboardHost::ReadUnsanitizedCustomFormat";
      case messages::ClipboardHost::kWriteText:
            return "Receive blink::mojom::ClipboardHost::WriteText";
      case messages::ClipboardHost::kWriteHtml:
            return "Receive blink::mojom::ClipboardHost::WriteHtml";
      case messages::ClipboardHost::kWriteSvg:
            return "Receive blink::mojom::ClipboardHost::WriteSvg";
      case messages::ClipboardHost::kWriteSmartPasteMarker:
            return "Receive blink::mojom::ClipboardHost::WriteSmartPasteMarker";
      case messages::ClipboardHost::kWriteDataTransferCustomData:
            return "Receive blink::mojom::ClipboardHost::WriteDataTransferCustomData";
      case messages::ClipboardHost::kWriteBookmark:
            return "Receive blink::mojom::ClipboardHost::WriteBookmark";
      case messages::ClipboardHost::kWriteImage:
            return "Receive blink::mojom::ClipboardHost::WriteImage";
      case messages::ClipboardHost::kWriteUnsanitizedCustomFormat:
            return "Receive blink::mojom::ClipboardHost::WriteUnsanitizedCustomFormat";
      case messages::ClipboardHost::kCommitWrite:
            return "Receive blink::mojom::ClipboardHost::CommitWrite";
      case messages::ClipboardHost::kBeginCopyWithCompletion:
            return "Receive blink::mojom::ClipboardHost::BeginCopyWithCompletion";
      case messages::ClipboardHost::kEndCopyWithCompletion:
            return "Receive blink::mojom::ClipboardHost::EndCopyWithCompletion";
      case messages::ClipboardHost::kBeginPasteWithCompletion:
            return "Receive blink::mojom::ClipboardHost::BeginPasteWithCompletion";
      case messages::ClipboardHost::kEndPasteWithCompletion:
            return "Receive blink::mojom::ClipboardHost::EndPasteWithCompletion";
      case messages::ClipboardHost::kWriteStringToFindPboard:
            return "Receive blink::mojom::ClipboardHost::WriteStringToFindPboard";
      case messages::ClipboardHost::kGetPlatformPermissionState:
            return "Receive blink::mojom::ClipboardHost::GetPlatformPermissionState";
      case messages::ClipboardHost::kRegisterClipboardListener:
            return "Receive blink::mojom::ClipboardHost::RegisterClipboardListener";
    }
  } else {
    switch (static_cast<messages::ClipboardHost>(message.name())) {
      case messages::ClipboardHost::kGetSequenceNumber:
            return "Receive reply blink::mojom::ClipboardHost::GetSequenceNumber";
      case messages::ClipboardHost::kIsFormatAvailable:
            return "Receive reply blink::mojom::ClipboardHost::IsFormatAvailable";
      case messages::ClipboardHost::kReadAvailableTypes:
            return "Receive reply blink::mojom::ClipboardHost::ReadAvailableTypes";
      case messages::ClipboardHost::kReadText:
            return "Receive reply blink::mojom::ClipboardHost::ReadText";
      case messages::ClipboardHost::kReadHtml:
            return "Receive reply blink::mojom::ClipboardHost::ReadHtml";
      case messages::ClipboardHost::kReadSvg:
            return "Receive reply blink::mojom::ClipboardHost::ReadSvg";
      case messages::ClipboardHost::kReadRtf:
            return "Receive reply blink::mojom::ClipboardHost::ReadRtf";
      case messages::ClipboardHost::kReadPng:
            return "Receive reply blink::mojom::ClipboardHost::ReadPng";
      case messages::ClipboardHost::kReadFiles:
            return "Receive reply blink::mojom::ClipboardHost::ReadFiles";
      case messages::ClipboardHost::kReadDataTransferCustomData:
            return "Receive reply blink::mojom::ClipboardHost::ReadDataTransferCustomData";
      case messages::ClipboardHost::kReadAvailableCustomAndStandardFormats:
            return "Receive reply blink::mojom::ClipboardHost::ReadAvailableCustomAndStandardFormats";
      case messages::ClipboardHost::kReadUnsanitizedCustomFormat:
            return "Receive reply blink::mojom::ClipboardHost::ReadUnsanitizedCustomFormat";
      case messages::ClipboardHost::kWriteText:
            return "Receive reply blink::mojom::ClipboardHost::WriteText";
      case messages::ClipboardHost::kWriteHtml:
            return "Receive reply blink::mojom::ClipboardHost::WriteHtml";
      case messages::ClipboardHost::kWriteSvg:
            return "Receive reply blink::mojom::ClipboardHost::WriteSvg";
      case messages::ClipboardHost::kWriteSmartPasteMarker:
            return "Receive reply blink::mojom::ClipboardHost::WriteSmartPasteMarker";
      case messages::ClipboardHost::kWriteDataTransferCustomData:
            return "Receive reply blink::mojom::ClipboardHost::WriteDataTransferCustomData";
      case messages::ClipboardHost::kWriteBookmark:
            return "Receive reply blink::mojom::ClipboardHost::WriteBookmark";
      case messages::ClipboardHost::kWriteImage:
            return "Receive reply blink::mojom::ClipboardHost::WriteImage";
      case messages::ClipboardHost::kWriteUnsanitizedCustomFormat:
            return "Receive reply blink::mojom::ClipboardHost::WriteUnsanitizedCustomFormat";
      case messages::ClipboardHost::kCommitWrite:
            return "Receive reply blink::mojom::ClipboardHost::CommitWrite";
      case messages::ClipboardHost::kBeginCopyWithCompletion:
            return "Receive reply blink::mojom::ClipboardHost::BeginCopyWithCompletion";
      case messages::ClipboardHost::kEndCopyWithCompletion:
            return "Receive reply blink::mojom::ClipboardHost::EndCopyWithCompletion";
      case messages::ClipboardHost::kBeginPasteWithCompletion:
            return "Receive reply blink::mojom::ClipboardHost::BeginPasteWithCompletion";
      case messages::ClipboardHost::kEndPasteWithCompletion:
            return "Receive reply blink::mojom::ClipboardHost::EndPasteWithCompletion";
      case messages::ClipboardHost::kWriteStringToFindPboard:
            return "Receive reply blink::mojom::ClipboardHost::WriteStringToFindPboard";
      case messages::ClipboardHost::kGetPlatformPermissionState:
            return "Receive reply blink::mojom::ClipboardHost::GetPlatformPermissionState";
      case messages::ClipboardHost::kRegisterClipboardListener:
            return "Receive reply blink::mojom::ClipboardHost::RegisterClipboardListener";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ClipboardHost::GetSequenceNumber_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb2adb394;  // IPCStableHash for blink::mojom::ClipboardHost::GetSequenceNumber
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ClipboardHost::IsFormatAvailable_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcfd8468a;  // IPCStableHash for blink::mojom::ClipboardHost::IsFormatAvailable
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ClipboardHost::ReadAvailableTypes_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9213b646;  // IPCStableHash for blink::mojom::ClipboardHost::ReadAvailableTypes
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ClipboardHost::ReadText_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa1cd5c4d;  // IPCStableHash for blink::mojom::ClipboardHost::ReadText
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ClipboardHost::ReadHtml_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe8d757ae;  // IPCStableHash for blink::mojom::ClipboardHost::ReadHtml
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ClipboardHost::ReadSvg_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x813cc1d0;  // IPCStableHash for blink::mojom::ClipboardHost::ReadSvg
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ClipboardHost::ReadRtf_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7579414d;  // IPCStableHash for blink::mojom::ClipboardHost::ReadRtf
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ClipboardHost::ReadPng_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0cbb9eb0;  // IPCStableHash for blink::mojom::ClipboardHost::ReadPng
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ClipboardHost::ReadFiles_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2303a697;  // IPCStableHash for blink::mojom::ClipboardHost::ReadFiles
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ClipboardHost::ReadDataTransferCustomData_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6ce161c7;  // IPCStableHash for blink::mojom::ClipboardHost::ReadDataTransferCustomData
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ClipboardHost::ReadAvailableCustomAndStandardFormats_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc332f2e1;  // IPCStableHash for blink::mojom::ClipboardHost::ReadAvailableCustomAndStandardFormats
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ClipboardHost::ReadUnsanitizedCustomFormat_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8a487bfe;  // IPCStableHash for blink::mojom::ClipboardHost::ReadUnsanitizedCustomFormat
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ClipboardHost::WriteText_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xddc37174;  // IPCStableHash for blink::mojom::ClipboardHost::WriteText
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ClipboardHost::WriteHtml_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9623e44e;  // IPCStableHash for blink::mojom::ClipboardHost::WriteHtml
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ClipboardHost::WriteSvg_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa33b8848;  // IPCStableHash for blink::mojom::ClipboardHost::WriteSvg
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ClipboardHost::WriteSmartPasteMarker_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5da1f422;  // IPCStableHash for blink::mojom::ClipboardHost::WriteSmartPasteMarker
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ClipboardHost::WriteDataTransferCustomData_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x467014bc;  // IPCStableHash for blink::mojom::ClipboardHost::WriteDataTransferCustomData
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ClipboardHost::WriteBookmark_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x53e7ffda;  // IPCStableHash for blink::mojom::ClipboardHost::WriteBookmark
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ClipboardHost::WriteImage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0df05fe0;  // IPCStableHash for blink::mojom::ClipboardHost::WriteImage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ClipboardHost::WriteUnsanitizedCustomFormat_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x49bae62e;  // IPCStableHash for blink::mojom::ClipboardHost::WriteUnsanitizedCustomFormat
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ClipboardHost::CommitWrite_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc9a26bf7;  // IPCStableHash for blink::mojom::ClipboardHost::CommitWrite
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ClipboardHost::BeginCopyWithCompletion_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4c8ec5ec;  // IPCStableHash for blink::mojom::ClipboardHost::BeginCopyWithCompletion
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ClipboardHost::EndCopyWithCompletion_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x21a23f7f;  // IPCStableHash for blink::mojom::ClipboardHost::EndCopyWithCompletion
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ClipboardHost::BeginPasteWithCompletion_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb58d1ee5;  // IPCStableHash for blink::mojom::ClipboardHost::BeginPasteWithCompletion
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ClipboardHost::EndPasteWithCompletion_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x073b7c03;  // IPCStableHash for blink::mojom::ClipboardHost::EndPasteWithCompletion
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ClipboardHost::WriteStringToFindPboard_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6c4caf47;  // IPCStableHash for blink::mojom::ClipboardHost::WriteStringToFindPboard
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ClipboardHost::GetPlatformPermissionState_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8ec32447;  // IPCStableHash for blink::mojom::ClipboardHost::GetPlatformPermissionState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ClipboardHost::RegisterClipboardListener_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x367f4030;  // IPCStableHash for blink::mojom::ClipboardHost::RegisterClipboardListener
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool ClipboardHost::GetSequenceNumber(ClipboardBuffer buffer, ::blink::ClipboardSequenceNumberToken* out_result) {
  NOTREACHED();
}
bool ClipboardHost::IsFormatAvailable(ClipboardFormat format, ClipboardBuffer buffer, bool* out_result) {
  NOTREACHED();
}
bool ClipboardHost::ReadAvailableTypes(ClipboardBuffer buffer, ::blink::Vector<::blink::String>* out_types) {
  NOTREACHED();
}
bool ClipboardHost::ReadText(ClipboardBuffer buffer, ::blink::String* out_result) {
  NOTREACHED();
}
bool ClipboardHost::ReadHtml(ClipboardBuffer buffer, ::blink::String* out_markup, ::blink::KURL* out_url, uint32_t* out_fragment_start, uint32_t* out_fragment_end) {
  NOTREACHED();
}
bool ClipboardHost::ReadRtf(ClipboardBuffer buffer, ::blink::String* out_result) {
  NOTREACHED();
}
bool ClipboardHost::ReadPng(ClipboardBuffer buffer, ::mojo_base::BigBuffer* out_png) {
  NOTREACHED();
}
bool ClipboardHost::ReadFiles(ClipboardBuffer buffer, ClipboardFilesPtr* out_result) {
  NOTREACHED();
}
bool ClipboardHost::ReadDataTransferCustomData(ClipboardBuffer buffer, const ::blink::String& type, ::blink::String* out_result) {
  NOTREACHED();
}
bool ClipboardHost::ReadAvailableCustomAndStandardFormats(::blink::Vector<::blink::String>* out_format_types) {
  NOTREACHED();
}
class ClipboardHost_GetSequenceNumber_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  ClipboardHost_GetSequenceNumber_HandleSyncResponse(
      bool* result, ::blink::ClipboardSequenceNumberToken* out_result)
      : result_(result), out_result_(out_result) {
    DCHECK(!*result_);
  }

  ClipboardHost_GetSequenceNumber_HandleSyncResponse(const ClipboardHost_GetSequenceNumber_HandleSyncResponse&) = delete;
  ClipboardHost_GetSequenceNumber_HandleSyncResponse& operator=(const ClipboardHost_GetSequenceNumber_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::blink::ClipboardSequenceNumberToken* out_result_;};

class ClipboardHost_GetSequenceNumber_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ClipboardHost_GetSequenceNumber_ForwardToCallback(
      ClipboardHost::GetSequenceNumberCallback callback
      ) : callback_(std::move(callback)) {
  }

  ClipboardHost_GetSequenceNumber_ForwardToCallback(const ClipboardHost_GetSequenceNumber_ForwardToCallback&) = delete;
  ClipboardHost_GetSequenceNumber_ForwardToCallback& operator=(const ClipboardHost_GetSequenceNumber_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ClipboardHost::GetSequenceNumberCallback callback_;
};
class ClipboardHost_IsFormatAvailable_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  ClipboardHost_IsFormatAvailable_HandleSyncResponse(
      bool* result, bool* out_result)
      : result_(result), out_result_(out_result) {
    DCHECK(!*result_);
  }

  ClipboardHost_IsFormatAvailable_HandleSyncResponse(const ClipboardHost_IsFormatAvailable_HandleSyncResponse&) = delete;
  ClipboardHost_IsFormatAvailable_HandleSyncResponse& operator=(const ClipboardHost_IsFormatAvailable_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_result_;};

class ClipboardHost_IsFormatAvailable_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ClipboardHost_IsFormatAvailable_ForwardToCallback(
      ClipboardHost::IsFormatAvailableCallback callback
      ) : callback_(std::move(callback)) {
  }

  ClipboardHost_IsFormatAvailable_ForwardToCallback(const ClipboardHost_IsFormatAvailable_ForwardToCallback&) = delete;
  ClipboardHost_IsFormatAvailable_ForwardToCallback& operator=(const ClipboardHost_IsFormatAvailable_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ClipboardHost::IsFormatAvailableCallback callback_;
};
class ClipboardHost_ReadAvailableTypes_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  ClipboardHost_ReadAvailableTypes_HandleSyncResponse(
      bool* result, ::blink::Vector<::blink::String>* out_types)
      : result_(result), out_types_(out_types) {
    DCHECK(!*result_);
  }

  ClipboardHost_ReadAvailableTypes_HandleSyncResponse(const ClipboardHost_ReadAvailableTypes_HandleSyncResponse&) = delete;
  ClipboardHost_ReadAvailableTypes_HandleSyncResponse& operator=(const ClipboardHost_ReadAvailableTypes_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::blink::Vector<::blink::String>* out_types_;};

class ClipboardHost_ReadAvailableTypes_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ClipboardHost_ReadAvailableTypes_ForwardToCallback(
      ClipboardHost::ReadAvailableTypesCallback callback
      ) : callback_(std::move(callback)) {
  }

  ClipboardHost_ReadAvailableTypes_ForwardToCallback(const ClipboardHost_ReadAvailableTypes_ForwardToCallback&) = delete;
  ClipboardHost_ReadAvailableTypes_ForwardToCallback& operator=(const ClipboardHost_ReadAvailableTypes_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ClipboardHost::ReadAvailableTypesCallback callback_;
};
class ClipboardHost_ReadText_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  ClipboardHost_ReadText_HandleSyncResponse(
      bool* result, ::blink::String* out_result)
      : result_(result), out_result_(out_result) {
    DCHECK(!*result_);
  }

  ClipboardHost_ReadText_HandleSyncResponse(const ClipboardHost_ReadText_HandleSyncResponse&) = delete;
  ClipboardHost_ReadText_HandleSyncResponse& operator=(const ClipboardHost_ReadText_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::blink::String* out_result_;};

class ClipboardHost_ReadText_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ClipboardHost_ReadText_ForwardToCallback(
      ClipboardHost::ReadTextCallback callback
      ) : callback_(std::move(callback)) {
  }

  ClipboardHost_ReadText_ForwardToCallback(const ClipboardHost_ReadText_ForwardToCallback&) = delete;
  ClipboardHost_ReadText_ForwardToCallback& operator=(const ClipboardHost_ReadText_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ClipboardHost::ReadTextCallback callback_;
};
class ClipboardHost_ReadHtml_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  ClipboardHost_ReadHtml_HandleSyncResponse(
      bool* result, ::blink::String* out_markup, ::blink::KURL* out_url, uint32_t* out_fragment_start, uint32_t* out_fragment_end)
      : result_(result), out_markup_(out_markup), out_url_(out_url), out_fragment_start_(out_fragment_start), out_fragment_end_(out_fragment_end) {
    DCHECK(!*result_);
  }

  ClipboardHost_ReadHtml_HandleSyncResponse(const ClipboardHost_ReadHtml_HandleSyncResponse&) = delete;
  ClipboardHost_ReadHtml_HandleSyncResponse& operator=(const ClipboardHost_ReadHtml_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::blink::String* out_markup_;
  ::blink::KURL* out_url_;
  uint32_t* out_fragment_start_;
  uint32_t* out_fragment_end_;};

class ClipboardHost_ReadHtml_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ClipboardHost_ReadHtml_ForwardToCallback(
      ClipboardHost::ReadHtmlCallback callback
      ) : callback_(std::move(callback)) {
  }

  ClipboardHost_ReadHtml_ForwardToCallback(const ClipboardHost_ReadHtml_ForwardToCallback&) = delete;
  ClipboardHost_ReadHtml_ForwardToCallback& operator=(const ClipboardHost_ReadHtml_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ClipboardHost::ReadHtmlCallback callback_;
};

class ClipboardHost_ReadSvg_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ClipboardHost_ReadSvg_ForwardToCallback(
      ClipboardHost::ReadSvgCallback callback
      ) : callback_(std::move(callback)) {
  }

  ClipboardHost_ReadSvg_ForwardToCallback(const ClipboardHost_ReadSvg_ForwardToCallback&) = delete;
  ClipboardHost_ReadSvg_ForwardToCallback& operator=(const ClipboardHost_ReadSvg_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ClipboardHost::ReadSvgCallback callback_;
};
class ClipboardHost_ReadRtf_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  ClipboardHost_ReadRtf_HandleSyncResponse(
      bool* result, ::blink::String* out_result)
      : result_(result), out_result_(out_result) {
    DCHECK(!*result_);
  }

  ClipboardHost_ReadRtf_HandleSyncResponse(const ClipboardHost_ReadRtf_HandleSyncResponse&) = delete;
  ClipboardHost_ReadRtf_HandleSyncResponse& operator=(const ClipboardHost_ReadRtf_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::blink::String* out_result_;};

class ClipboardHost_ReadRtf_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ClipboardHost_ReadRtf_ForwardToCallback(
      ClipboardHost::ReadRtfCallback callback
      ) : callback_(std::move(callback)) {
  }

  ClipboardHost_ReadRtf_ForwardToCallback(const ClipboardHost_ReadRtf_ForwardToCallback&) = delete;
  ClipboardHost_ReadRtf_ForwardToCallback& operator=(const ClipboardHost_ReadRtf_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ClipboardHost::ReadRtfCallback callback_;
};
class ClipboardHost_ReadPng_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  ClipboardHost_ReadPng_HandleSyncResponse(
      bool* result, ::mojo_base::BigBuffer* out_png)
      : result_(result), out_png_(out_png) {
    DCHECK(!*result_);
  }

  ClipboardHost_ReadPng_HandleSyncResponse(const ClipboardHost_ReadPng_HandleSyncResponse&) = delete;
  ClipboardHost_ReadPng_HandleSyncResponse& operator=(const ClipboardHost_ReadPng_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::mojo_base::BigBuffer* out_png_;};

class ClipboardHost_ReadPng_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ClipboardHost_ReadPng_ForwardToCallback(
      ClipboardHost::ReadPngCallback callback
      ) : callback_(std::move(callback)) {
  }

  ClipboardHost_ReadPng_ForwardToCallback(const ClipboardHost_ReadPng_ForwardToCallback&) = delete;
  ClipboardHost_ReadPng_ForwardToCallback& operator=(const ClipboardHost_ReadPng_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ClipboardHost::ReadPngCallback callback_;
};
class ClipboardHost_ReadFiles_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  ClipboardHost_ReadFiles_HandleSyncResponse(
      bool* result, ClipboardFilesPtr* out_result)
      : result_(result), out_result_(out_result) {
    DCHECK(!*result_);
  }

  ClipboardHost_ReadFiles_HandleSyncResponse(const ClipboardHost_ReadFiles_HandleSyncResponse&) = delete;
  ClipboardHost_ReadFiles_HandleSyncResponse& operator=(const ClipboardHost_ReadFiles_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ClipboardFilesPtr* out_result_;};

class ClipboardHost_ReadFiles_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ClipboardHost_ReadFiles_ForwardToCallback(
      ClipboardHost::ReadFilesCallback callback
      ) : callback_(std::move(callback)) {
  }

  ClipboardHost_ReadFiles_ForwardToCallback(const ClipboardHost_ReadFiles_ForwardToCallback&) = delete;
  ClipboardHost_ReadFiles_ForwardToCallback& operator=(const ClipboardHost_ReadFiles_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ClipboardHost::ReadFilesCallback callback_;
};
class ClipboardHost_ReadDataTransferCustomData_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  ClipboardHost_ReadDataTransferCustomData_HandleSyncResponse(
      bool* result, ::blink::String* out_result)
      : result_(result), out_result_(out_result) {
    DCHECK(!*result_);
  }

  ClipboardHost_ReadDataTransferCustomData_HandleSyncResponse(const ClipboardHost_ReadDataTransferCustomData_HandleSyncResponse&) = delete;
  ClipboardHost_ReadDataTransferCustomData_HandleSyncResponse& operator=(const ClipboardHost_ReadDataTransferCustomData_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::blink::String* out_result_;};

class ClipboardHost_ReadDataTransferCustomData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ClipboardHost_ReadDataTransferCustomData_ForwardToCallback(
      ClipboardHost::ReadDataTransferCustomDataCallback callback
      ) : callback_(std::move(callback)) {
  }

  ClipboardHost_ReadDataTransferCustomData_ForwardToCallback(const ClipboardHost_ReadDataTransferCustomData_ForwardToCallback&) = delete;
  ClipboardHost_ReadDataTransferCustomData_ForwardToCallback& operator=(const ClipboardHost_ReadDataTransferCustomData_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ClipboardHost::ReadDataTransferCustomDataCallback callback_;
};
class ClipboardHost_ReadAvailableCustomAndStandardFormats_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  ClipboardHost_ReadAvailableCustomAndStandardFormats_HandleSyncResponse(
      bool* result, ::blink::Vector<::blink::String>* out_format_types)
      : result_(result), out_format_types_(out_format_types) {
    DCHECK(!*result_);
  }

  ClipboardHost_ReadAvailableCustomAndStandardFormats_HandleSyncResponse(const ClipboardHost_ReadAvailableCustomAndStandardFormats_HandleSyncResponse&) = delete;
  ClipboardHost_ReadAvailableCustomAndStandardFormats_HandleSyncResponse& operator=(const ClipboardHost_ReadAvailableCustomAndStandardFormats_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::blink::Vector<::blink::String>* out_format_types_;};

class ClipboardHost_ReadAvailableCustomAndStandardFormats_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ClipboardHost_ReadAvailableCustomAndStandardFormats_ForwardToCallback(
      ClipboardHost::ReadAvailableCustomAndStandardFormatsCallback callback
      ) : callback_(std::move(callback)) {
  }

  ClipboardHost_ReadAvailableCustomAndStandardFormats_ForwardToCallback(const ClipboardHost_ReadAvailableCustomAndStandardFormats_ForwardToCallback&) = delete;
  ClipboardHost_ReadAvailableCustomAndStandardFormats_ForwardToCallback& operator=(const ClipboardHost_ReadAvailableCustomAndStandardFormats_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ClipboardHost::ReadAvailableCustomAndStandardFormatsCallback callback_;
};

class ClipboardHost_ReadUnsanitizedCustomFormat_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ClipboardHost_ReadUnsanitizedCustomFormat_ForwardToCallback(
      ClipboardHost::ReadUnsanitizedCustomFormatCallback callback
      ) : callback_(std::move(callback)) {
  }

  ClipboardHost_ReadUnsanitizedCustomFormat_ForwardToCallback(const ClipboardHost_ReadUnsanitizedCustomFormat_ForwardToCallback&) = delete;
  ClipboardHost_ReadUnsanitizedCustomFormat_ForwardToCallback& operator=(const ClipboardHost_ReadUnsanitizedCustomFormat_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ClipboardHost::ReadUnsanitizedCustomFormatCallback callback_;
};

class ClipboardHost_EndCopyWithCompletion_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ClipboardHost_EndCopyWithCompletion_ForwardToCallback(
      ClipboardHost::EndCopyWithCompletionCallback callback
      ) : callback_(std::move(callback)) {
  }

  ClipboardHost_EndCopyWithCompletion_ForwardToCallback(const ClipboardHost_EndCopyWithCompletion_ForwardToCallback&) = delete;
  ClipboardHost_EndCopyWithCompletion_ForwardToCallback& operator=(const ClipboardHost_EndCopyWithCompletion_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ClipboardHost::EndCopyWithCompletionCallback callback_;
};

class ClipboardHost_EndPasteWithCompletion_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ClipboardHost_EndPasteWithCompletion_ForwardToCallback(
      ClipboardHost::EndPasteWithCompletionCallback callback
      ) : callback_(std::move(callback)) {
  }

  ClipboardHost_EndPasteWithCompletion_ForwardToCallback(const ClipboardHost_EndPasteWithCompletion_ForwardToCallback&) = delete;
  ClipboardHost_EndPasteWithCompletion_ForwardToCallback& operator=(const ClipboardHost_EndPasteWithCompletion_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ClipboardHost::EndPasteWithCompletionCallback callback_;
};

class ClipboardHost_GetPlatformPermissionState_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ClipboardHost_GetPlatformPermissionState_ForwardToCallback(
      ClipboardHost::GetPlatformPermissionStateCallback callback
      ) : callback_(std::move(callback)) {
  }

  ClipboardHost_GetPlatformPermissionState_ForwardToCallback(const ClipboardHost_GetPlatformPermissionState_ForwardToCallback&) = delete;
  ClipboardHost_GetPlatformPermissionState_ForwardToCallback& operator=(const ClipboardHost_GetPlatformPermissionState_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ClipboardHost::GetPlatformPermissionStateCallback callback_;
};

ClipboardHostProxy::ClipboardHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool ClipboardHostProxy::GetSequenceNumber(
    ClipboardBuffer param_buffer, ::blink::ClipboardSequenceNumberToken* out_param_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call blink::mojom::ClipboardHost::GetSequenceNumber (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), param_buffer,
                        "<value of type ClipboardBuffer>");
   });
#else
  TRACE_EVENT0("mojom", "ClipboardHost::GetSequenceNumber");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kGetSequenceNumber), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_GetSequenceNumber_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ClipboardBuffer>(
    param_buffer,
    &params->buffer);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("GetSequenceNumber");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ClipboardHost_GetSequenceNumber_HandleSyncResponse(
          &result, out_param_result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "ClipboardHost::GetSequenceNumber", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), out_param_result,
                        "<value of type const ::blink::ClipboardSequenceNumberToken&>");
   });
#endif
  return result;
}

void ClipboardHostProxy::GetSequenceNumber(
    ClipboardBuffer in_buffer, GetSequenceNumberCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ClipboardHost::GetSequenceNumber", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), in_buffer,
                        "<value of type ClipboardBuffer>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kGetSequenceNumber), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_GetSequenceNumber_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ClipboardBuffer>(
    in_buffer,
    &params->buffer);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("GetSequenceNumber");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ClipboardHost_GetSequenceNumber_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool ClipboardHostProxy::IsFormatAvailable(
    ClipboardFormat param_format, ClipboardBuffer param_buffer, bool* out_param_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call blink::mojom::ClipboardHost::IsFormatAvailable (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("format"), param_format,
                        "<value of type ClipboardFormat>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), param_buffer,
                        "<value of type ClipboardBuffer>");
   });
#else
  TRACE_EVENT0("mojom", "ClipboardHost::IsFormatAvailable");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kIsFormatAvailable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_IsFormatAvailable_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ClipboardFormat>(
    param_format,
    &params->format);

  
  mojo::internal::Serialize<::blink::mojom::ClipboardBuffer>(
    param_buffer,
    &params->buffer);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("IsFormatAvailable");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ClipboardHost_IsFormatAvailable_HandleSyncResponse(
          &result, out_param_result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "ClipboardHost::IsFormatAvailable", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), out_param_result,
                        "<value of type bool>");
   });
#endif
  return result;
}

void ClipboardHostProxy::IsFormatAvailable(
    ClipboardFormat in_format, ClipboardBuffer in_buffer, IsFormatAvailableCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ClipboardHost::IsFormatAvailable", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("format"), in_format,
                        "<value of type ClipboardFormat>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), in_buffer,
                        "<value of type ClipboardBuffer>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kIsFormatAvailable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_IsFormatAvailable_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ClipboardFormat>(
    in_format,
    &params->format);

  
  mojo::internal::Serialize<::blink::mojom::ClipboardBuffer>(
    in_buffer,
    &params->buffer);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("IsFormatAvailable");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ClipboardHost_IsFormatAvailable_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool ClipboardHostProxy::ReadAvailableTypes(
    ClipboardBuffer param_buffer, ::blink::Vector<::blink::String>* out_param_types) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call blink::mojom::ClipboardHost::ReadAvailableTypes (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), param_buffer,
                        "<value of type ClipboardBuffer>");
   });
#else
  TRACE_EVENT0("mojom", "ClipboardHost::ReadAvailableTypes");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kReadAvailableTypes), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_ReadAvailableTypes_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ClipboardBuffer>(
    param_buffer,
    &params->buffer);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("ReadAvailableTypes");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ClipboardHost_ReadAvailableTypes_HandleSyncResponse(
          &result, out_param_types));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "ClipboardHost::ReadAvailableTypes", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("types"), out_param_types,
                        "<value of type const ::blink::Vector<::blink::String>&>");
   });
#endif
  return result;
}

void ClipboardHostProxy::ReadAvailableTypes(
    ClipboardBuffer in_buffer, ReadAvailableTypesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ClipboardHost::ReadAvailableTypes", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), in_buffer,
                        "<value of type ClipboardBuffer>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kReadAvailableTypes), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_ReadAvailableTypes_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ClipboardBuffer>(
    in_buffer,
    &params->buffer);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("ReadAvailableTypes");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ClipboardHost_ReadAvailableTypes_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool ClipboardHostProxy::ReadText(
    ClipboardBuffer param_buffer, ::blink::String* out_param_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call blink::mojom::ClipboardHost::ReadText (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), param_buffer,
                        "<value of type ClipboardBuffer>");
   });
#else
  TRACE_EVENT0("mojom", "ClipboardHost::ReadText");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kReadText), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_ReadText_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ClipboardBuffer>(
    param_buffer,
    &params->buffer);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("ReadText");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ClipboardHost_ReadText_HandleSyncResponse(
          &result, out_param_result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "ClipboardHost::ReadText", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), out_param_result,
                        "<value of type const ::blink::String&>");
   });
#endif
  return result;
}

void ClipboardHostProxy::ReadText(
    ClipboardBuffer in_buffer, ReadTextCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ClipboardHost::ReadText", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), in_buffer,
                        "<value of type ClipboardBuffer>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kReadText), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_ReadText_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ClipboardBuffer>(
    in_buffer,
    &params->buffer);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("ReadText");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ClipboardHost_ReadText_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool ClipboardHostProxy::ReadHtml(
    ClipboardBuffer param_buffer, ::blink::String* out_param_markup, ::blink::KURL* out_param_url, uint32_t* out_param_fragment_start, uint32_t* out_param_fragment_end) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call blink::mojom::ClipboardHost::ReadHtml (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), param_buffer,
                        "<value of type ClipboardBuffer>");
   });
#else
  TRACE_EVENT0("mojom", "ClipboardHost::ReadHtml");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kReadHtml), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_ReadHtml_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ClipboardBuffer>(
    param_buffer,
    &params->buffer);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("ReadHtml");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ClipboardHost_ReadHtml_HandleSyncResponse(
          &result, out_param_markup, out_param_url, out_param_fragment_start, out_param_fragment_end));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "ClipboardHost::ReadHtml", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("markup"), out_param_markup,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), out_param_url,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("fragment_start"), out_param_fragment_start,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("fragment_end"), out_param_fragment_end,
                        "<value of type uint32_t>");
   });
#endif
  return result;
}

void ClipboardHostProxy::ReadHtml(
    ClipboardBuffer in_buffer, ReadHtmlCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ClipboardHost::ReadHtml", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), in_buffer,
                        "<value of type ClipboardBuffer>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kReadHtml), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_ReadHtml_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ClipboardBuffer>(
    in_buffer,
    &params->buffer);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("ReadHtml");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ClipboardHost_ReadHtml_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ClipboardHostProxy::ReadSvg(
    ClipboardBuffer in_buffer, ReadSvgCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ClipboardHost::ReadSvg", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), in_buffer,
                        "<value of type ClipboardBuffer>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kReadSvg), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_ReadSvg_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ClipboardBuffer>(
    in_buffer,
    &params->buffer);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("ReadSvg");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ClipboardHost_ReadSvg_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool ClipboardHostProxy::ReadRtf(
    ClipboardBuffer param_buffer, ::blink::String* out_param_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call blink::mojom::ClipboardHost::ReadRtf (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), param_buffer,
                        "<value of type ClipboardBuffer>");
   });
#else
  TRACE_EVENT0("mojom", "ClipboardHost::ReadRtf");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kReadRtf), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_ReadRtf_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ClipboardBuffer>(
    param_buffer,
    &params->buffer);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("ReadRtf");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ClipboardHost_ReadRtf_HandleSyncResponse(
          &result, out_param_result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "ClipboardHost::ReadRtf", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), out_param_result,
                        "<value of type const ::blink::String&>");
   });
#endif
  return result;
}

void ClipboardHostProxy::ReadRtf(
    ClipboardBuffer in_buffer, ReadRtfCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ClipboardHost::ReadRtf", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), in_buffer,
                        "<value of type ClipboardBuffer>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kReadRtf), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_ReadRtf_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ClipboardBuffer>(
    in_buffer,
    &params->buffer);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("ReadRtf");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ClipboardHost_ReadRtf_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool ClipboardHostProxy::ReadPng(
    ClipboardBuffer param_buffer, ::mojo_base::BigBuffer* out_param_png) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call blink::mojom::ClipboardHost::ReadPng (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), param_buffer,
                        "<value of type ClipboardBuffer>");
   });
#else
  TRACE_EVENT0("mojom", "ClipboardHost::ReadPng");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kReadPng), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_ReadPng_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ClipboardBuffer>(
    param_buffer,
    &params->buffer);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("ReadPng");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ClipboardHost_ReadPng_HandleSyncResponse(
          &result, out_param_png));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "ClipboardHost::ReadPng", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("png"), out_param_png,
                        "<value of type ::mojo_base::BigBuffer>");
   });
#endif
  return result;
}

void ClipboardHostProxy::ReadPng(
    ClipboardBuffer in_buffer, ReadPngCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ClipboardHost::ReadPng", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), in_buffer,
                        "<value of type ClipboardBuffer>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kReadPng), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_ReadPng_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ClipboardBuffer>(
    in_buffer,
    &params->buffer);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("ReadPng");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ClipboardHost_ReadPng_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool ClipboardHostProxy::ReadFiles(
    ClipboardBuffer param_buffer, ClipboardFilesPtr* out_param_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call blink::mojom::ClipboardHost::ReadFiles (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), param_buffer,
                        "<value of type ClipboardBuffer>");
   });
#else
  TRACE_EVENT0("mojom", "ClipboardHost::ReadFiles");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kReadFiles), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_ReadFiles_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ClipboardBuffer>(
    param_buffer,
    &params->buffer);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("ReadFiles");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ClipboardHost_ReadFiles_HandleSyncResponse(
          &result, out_param_result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "ClipboardHost::ReadFiles", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), out_param_result,
                        "<value of type ClipboardFilesPtr>");
   });
#endif
  return result;
}

void ClipboardHostProxy::ReadFiles(
    ClipboardBuffer in_buffer, ReadFilesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ClipboardHost::ReadFiles", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), in_buffer,
                        "<value of type ClipboardBuffer>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kReadFiles), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_ReadFiles_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ClipboardBuffer>(
    in_buffer,
    &params->buffer);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("ReadFiles");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ClipboardHost_ReadFiles_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool ClipboardHostProxy::ReadDataTransferCustomData(
    ClipboardBuffer param_buffer, const ::blink::String& param_type, ::blink::String* out_param_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call blink::mojom::ClipboardHost::ReadDataTransferCustomData (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), param_buffer,
                        "<value of type ClipboardBuffer>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), param_type,
                        "<value of type const ::blink::String&>");
   });
#else
  TRACE_EVENT0("mojom", "ClipboardHost::ReadDataTransferCustomData");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kReadDataTransferCustomData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_ReadDataTransferCustomData_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ClipboardBuffer>(
    param_buffer,
    &params->buffer);
  mojo::internal::MessageFragment<
      typename decltype(params->type)::BaseType> type_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    param_type,
    type_fragment);

  params->type.Set(
      type_fragment.is_null() ? nullptr : type_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->type.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null type in ClipboardHost.ReadDataTransferCustomData request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("ReadDataTransferCustomData");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ClipboardHost_ReadDataTransferCustomData_HandleSyncResponse(
          &result, out_param_result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "ClipboardHost::ReadDataTransferCustomData", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), out_param_result,
                        "<value of type const ::blink::String&>");
   });
#endif
  return result;
}

void ClipboardHostProxy::ReadDataTransferCustomData(
    ClipboardBuffer in_buffer, const ::blink::String& in_type, ReadDataTransferCustomDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ClipboardHost::ReadDataTransferCustomData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), in_buffer,
                        "<value of type ClipboardBuffer>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kReadDataTransferCustomData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_ReadDataTransferCustomData_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ClipboardBuffer>(
    in_buffer,
    &params->buffer);
  mojo::internal::MessageFragment<
      typename decltype(params->type)::BaseType> type_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_type,
    type_fragment);

  params->type.Set(
      type_fragment.is_null() ? nullptr : type_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->type.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null type in ClipboardHost.ReadDataTransferCustomData request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("ReadDataTransferCustomData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ClipboardHost_ReadDataTransferCustomData_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool ClipboardHostProxy::ReadAvailableCustomAndStandardFormats(
    ::blink::Vector<::blink::String>* out_param_format_types) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call blink::mojom::ClipboardHost::ReadAvailableCustomAndStandardFormats (sync)");
#else
  TRACE_EVENT0("mojom", "ClipboardHost::ReadAvailableCustomAndStandardFormats");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kReadAvailableCustomAndStandardFormats), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_ReadAvailableCustomAndStandardFormats_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("ReadAvailableCustomAndStandardFormats");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ClipboardHost_ReadAvailableCustomAndStandardFormats_HandleSyncResponse(
          &result, out_param_format_types));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "ClipboardHost::ReadAvailableCustomAndStandardFormats", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("format_types"), out_param_format_types,
                        "<value of type const ::blink::Vector<::blink::String>&>");
   });
#endif
  return result;
}

void ClipboardHostProxy::ReadAvailableCustomAndStandardFormats(
    ReadAvailableCustomAndStandardFormatsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::ClipboardHost::ReadAvailableCustomAndStandardFormats");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kReadAvailableCustomAndStandardFormats), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_ReadAvailableCustomAndStandardFormats_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("ReadAvailableCustomAndStandardFormats");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ClipboardHost_ReadAvailableCustomAndStandardFormats_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ClipboardHostProxy::ReadUnsanitizedCustomFormat(
    const ::blink::String& in_format, ReadUnsanitizedCustomFormatCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ClipboardHost::ReadUnsanitizedCustomFormat", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("format"), in_format,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kReadUnsanitizedCustomFormat), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_ReadUnsanitizedCustomFormat_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->format)::BaseType> format_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_format,
    format_fragment);

  params->format.Set(
      format_fragment.is_null() ? nullptr : format_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->format.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null format in ClipboardHost.ReadUnsanitizedCustomFormat request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("ReadUnsanitizedCustomFormat");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ClipboardHost_ReadUnsanitizedCustomFormat_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ClipboardHostProxy::WriteText(
    const ::blink::String& in_text) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ClipboardHost::WriteText", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text"), in_text,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kWriteText), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_WriteText_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->text)::BaseType> text_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::BigString16DataView>(
    in_text,
    text_fragment);

  params->text.Set(
      text_fragment.is_null() ? nullptr : text_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->text.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null text in ClipboardHost.WriteText request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("WriteText");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ClipboardHostProxy::WriteHtml(
    const ::blink::String& in_markup, const ::blink::KURL& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ClipboardHost::WriteHtml", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("markup"), in_markup,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::blink::KURL&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kWriteHtml), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_WriteHtml_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->markup)::BaseType> markup_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::BigString16DataView>(
    in_markup,
    markup_fragment);

  params->markup.Set(
      markup_fragment.is_null() ? nullptr : markup_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->markup.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null markup in ClipboardHost.WriteHtml request");
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in ClipboardHost.WriteHtml request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("WriteHtml");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ClipboardHostProxy::WriteSvg(
    const ::blink::String& in_markup) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ClipboardHost::WriteSvg", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("markup"), in_markup,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kWriteSvg), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_WriteSvg_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->markup)::BaseType> markup_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::BigString16DataView>(
    in_markup,
    markup_fragment);

  params->markup.Set(
      markup_fragment.is_null() ? nullptr : markup_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->markup.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null markup in ClipboardHost.WriteSvg request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("WriteSvg");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ClipboardHostProxy::WriteSmartPasteMarker(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::ClipboardHost::WriteSmartPasteMarker");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kWriteSmartPasteMarker), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_WriteSmartPasteMarker_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("WriteSmartPasteMarker");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ClipboardHostProxy::WriteDataTransferCustomData(
    const ::blink::HashMap<::blink::String, ::blink::String>& in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ClipboardHost::WriteDataTransferCustomData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type const ::blink::HashMap<::blink::String, ::blink::String>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kWriteDataTransferCustomData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_WriteDataTransferCustomData_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType>
      data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::MapDataView<::mojo_base::mojom::String16DataView, ::mojo_base::mojom::BigString16DataView>>(
    in_data,
    data_fragment,
    &data_validate_params);

  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in ClipboardHost.WriteDataTransferCustomData request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("WriteDataTransferCustomData");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ClipboardHostProxy::WriteBookmark(
    const ::blink::String& in_url, const ::blink::String& in_title) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ClipboardHost::WriteBookmark", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("title"), in_title,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kWriteBookmark), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_WriteBookmark_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in ClipboardHost.WriteBookmark request");
  mojo::internal::MessageFragment<
      typename decltype(params->title)::BaseType> title_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_title,
    title_fragment);

  params->title.Set(
      title_fragment.is_null() ? nullptr : title_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->title.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null title in ClipboardHost.WriteBookmark request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("WriteBookmark");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ClipboardHostProxy::WriteImage(
    const ::SkBitmap& in_image) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ClipboardHost::WriteImage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("image"), in_image,
                        "<value of type const ::SkBitmap&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kWriteImage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_WriteImage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->image)::BaseType> image_fragment(
          params.message());
  
  mojo::internal::Serialize<::skia::mojom::BitmapN32DataView>(
    in_image,
    image_fragment);

  params->image.Set(
      image_fragment.is_null() ? nullptr : image_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->image.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null image in ClipboardHost.WriteImage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("WriteImage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ClipboardHostProxy::WriteUnsanitizedCustomFormat(
    const ::blink::String& in_format, ::mojo_base::BigBuffer in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ClipboardHost::WriteUnsanitizedCustomFormat", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("format"), in_format,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type ::mojo_base::BigBuffer>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kWriteUnsanitizedCustomFormat), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_WriteUnsanitizedCustomFormat_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->format)::BaseType> format_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_format,
    format_fragment);

  params->format.Set(
      format_fragment.is_null() ? nullptr : format_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->format.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null format in ClipboardHost.WriteUnsanitizedCustomFormat request");
  mojo::internal::MessageFragment<decltype(params->data)>
      data_fragment(params.message());
  data_fragment.Claim(&params->data);
  
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
    in_data,
    data_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in ClipboardHost.WriteUnsanitizedCustomFormat request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("WriteUnsanitizedCustomFormat");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ClipboardHostProxy::CommitWrite(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::ClipboardHost::CommitWrite");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kCommitWrite), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_CommitWrite_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("CommitWrite");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ClipboardHostProxy::BeginCopyWithCompletion(
    int32_t in_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ClipboardHost::BeginCopyWithCompletion", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kBeginCopyWithCompletion), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_BeginCopyWithCompletion_Params_Data> params(
          message);
  params.Allocate();

  params->token = in_token;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("BeginCopyWithCompletion");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ClipboardHostProxy::EndCopyWithCompletion(
    int32_t in_token, EndCopyWithCompletionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ClipboardHost::EndCopyWithCompletion", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kEndCopyWithCompletion), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_EndCopyWithCompletion_Params_Data> params(
          message);
  params.Allocate();

  params->token = in_token;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("EndCopyWithCompletion");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ClipboardHost_EndCopyWithCompletion_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ClipboardHostProxy::BeginPasteWithCompletion(
    int32_t in_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ClipboardHost::BeginPasteWithCompletion", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kBeginPasteWithCompletion), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_BeginPasteWithCompletion_Params_Data> params(
          message);
  params.Allocate();

  params->token = in_token;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("BeginPasteWithCompletion");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ClipboardHostProxy::EndPasteWithCompletion(
    int32_t in_token, EndPasteWithCompletionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ClipboardHost::EndPasteWithCompletion", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kEndPasteWithCompletion), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_EndPasteWithCompletion_Params_Data> params(
          message);
  params.Allocate();

  params->token = in_token;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("EndPasteWithCompletion");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ClipboardHost_EndPasteWithCompletion_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ClipboardHostProxy::WriteStringToFindPboard(
    const ::blink::String& in_text) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ClipboardHost::WriteStringToFindPboard", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text"), in_text,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kWriteStringToFindPboard), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_WriteStringToFindPboard_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->text)::BaseType> text_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_text,
    text_fragment);

  params->text.Set(
      text_fragment.is_null() ? nullptr : text_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->text.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null text in ClipboardHost.WriteStringToFindPboard request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("WriteStringToFindPboard");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ClipboardHostProxy::GetPlatformPermissionState(
    GetPlatformPermissionStateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::ClipboardHost::GetPlatformPermissionState");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kGetPlatformPermissionState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_GetPlatformPermissionState_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("GetPlatformPermissionState");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ClipboardHost_GetPlatformPermissionState_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ClipboardHostProxy::RegisterClipboardListener(
    ::mojo::PendingRemote<ClipboardListener> in_listener) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ClipboardHost::RegisterClipboardListener", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("listener"), in_listener,
                        "<value of type ::mojo::PendingRemote<ClipboardListener>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kRegisterClipboardListener), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_RegisterClipboardListener_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::ClipboardListenerInterfaceBase>>(
    in_listener,
    &params->listener,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->listener)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid listener in ClipboardHost.RegisterClipboardListener request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("RegisterClipboardListener");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class ClipboardHost_GetSequenceNumber_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ClipboardHost::GetSequenceNumberCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ClipboardHost_GetSequenceNumber_ProxyToResponder> proxy(
        new ClipboardHost_GetSequenceNumber_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ClipboardHost_GetSequenceNumber_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ClipboardHost_GetSequenceNumber_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ClipboardHost_GetSequenceNumber_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ClipboardHost::GetSequenceNumberCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::blink::ClipboardSequenceNumberToken& in_result);
};

bool ClipboardHost_GetSequenceNumber_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ClipboardHost_GetSequenceNumber_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ClipboardHost_GetSequenceNumber_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ClipboardHost.0
  bool success = true;
  ::blink::ClipboardSequenceNumberToken p_result{};
  ClipboardHost_GetSequenceNumber_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ClipboardHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void ClipboardHost_GetSequenceNumber_ProxyToResponder::Run(
    const ::blink::ClipboardSequenceNumberToken& in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ClipboardHost::GetSequenceNumber", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type const ::blink::ClipboardSequenceNumberToken&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kGetSequenceNumber), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_GetSequenceNumber_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ClipboardSequenceNumberTokenDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("GetSequenceNumber");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool ClipboardHost_GetSequenceNumber_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ClipboardHost_GetSequenceNumber_ResponseParams_Data* params =
      reinterpret_cast<internal::ClipboardHost_GetSequenceNumber_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for ClipboardHost.0
  bool success = true;
  ::blink::ClipboardSequenceNumberToken p_result{};
  ClipboardHost_GetSequenceNumber_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ClipboardHost::Name_, 0, true);
    return false;
  }
  *out_result_ = std::move(p_result);
  *result_ = true;
  return true;
}
class ClipboardHost_IsFormatAvailable_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ClipboardHost::IsFormatAvailableCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ClipboardHost_IsFormatAvailable_ProxyToResponder> proxy(
        new ClipboardHost_IsFormatAvailable_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ClipboardHost_IsFormatAvailable_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ClipboardHost_IsFormatAvailable_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ClipboardHost_IsFormatAvailable_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ClipboardHost::IsFormatAvailableCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_result);
};

bool ClipboardHost_IsFormatAvailable_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ClipboardHost_IsFormatAvailable_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ClipboardHost_IsFormatAvailable_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ClipboardHost.1
  bool success = true;
  bool p_result{};
  ClipboardHost_IsFormatAvailable_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ClipboardHost::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void ClipboardHost_IsFormatAvailable_ProxyToResponder::Run(
    bool in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ClipboardHost::IsFormatAvailable", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kIsFormatAvailable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_IsFormatAvailable_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->result = in_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("IsFormatAvailable");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool ClipboardHost_IsFormatAvailable_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ClipboardHost_IsFormatAvailable_ResponseParams_Data* params =
      reinterpret_cast<internal::ClipboardHost_IsFormatAvailable_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for ClipboardHost.1
  bool success = true;
  bool p_result{};
  ClipboardHost_IsFormatAvailable_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ClipboardHost::Name_, 1, true);
    return false;
  }
  *out_result_ = std::move(p_result);
  *result_ = true;
  return true;
}
class ClipboardHost_ReadAvailableTypes_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ClipboardHost::ReadAvailableTypesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ClipboardHost_ReadAvailableTypes_ProxyToResponder> proxy(
        new ClipboardHost_ReadAvailableTypes_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ClipboardHost_ReadAvailableTypes_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ClipboardHost_ReadAvailableTypes_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ClipboardHost_ReadAvailableTypes_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ClipboardHost::ReadAvailableTypesCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::blink::Vector<::blink::String>& in_types);
};

bool ClipboardHost_ReadAvailableTypes_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ClipboardHost_ReadAvailableTypes_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ClipboardHost_ReadAvailableTypes_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ClipboardHost.2
  bool success = true;
  ::blink::Vector<::blink::String> p_types{};
  ClipboardHost_ReadAvailableTypes_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadTypes(&p_types))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ClipboardHost::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_types));
  }
  return true;
}

void ClipboardHost_ReadAvailableTypes_ProxyToResponder::Run(
    const ::blink::Vector<::blink::String>& in_types) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ClipboardHost::ReadAvailableTypes", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("types"), in_types,
                        "<value of type const ::blink::Vector<::blink::String>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kReadAvailableTypes), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_ReadAvailableTypes_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->types)::BaseType>
      types_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& types_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>(
    in_types,
    types_fragment,
    &types_validate_params);

  params->types.Set(
      types_fragment.is_null() ? nullptr : types_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->types.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null types in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("ReadAvailableTypes");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool ClipboardHost_ReadAvailableTypes_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ClipboardHost_ReadAvailableTypes_ResponseParams_Data* params =
      reinterpret_cast<internal::ClipboardHost_ReadAvailableTypes_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for ClipboardHost.2
  bool success = true;
  ::blink::Vector<::blink::String> p_types{};
  ClipboardHost_ReadAvailableTypes_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadTypes(&p_types))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ClipboardHost::Name_, 2, true);
    return false;
  }
  *out_types_ = std::move(p_types);
  *result_ = true;
  return true;
}
class ClipboardHost_ReadText_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ClipboardHost::ReadTextCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ClipboardHost_ReadText_ProxyToResponder> proxy(
        new ClipboardHost_ReadText_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ClipboardHost_ReadText_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ClipboardHost_ReadText_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ClipboardHost_ReadText_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ClipboardHost::ReadTextCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::blink::String& in_result);
};

bool ClipboardHost_ReadText_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ClipboardHost_ReadText_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ClipboardHost_ReadText_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ClipboardHost.3
  bool success = true;
  ::blink::String p_result{};
  ClipboardHost_ReadText_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ClipboardHost::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void ClipboardHost_ReadText_ProxyToResponder::Run(
    const ::blink::String& in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ClipboardHost::ReadText", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type const ::blink::String&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kReadText), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_ReadText_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::BigString16DataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("ReadText");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool ClipboardHost_ReadText_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ClipboardHost_ReadText_ResponseParams_Data* params =
      reinterpret_cast<internal::ClipboardHost_ReadText_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for ClipboardHost.3
  bool success = true;
  ::blink::String p_result{};
  ClipboardHost_ReadText_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ClipboardHost::Name_, 3, true);
    return false;
  }
  *out_result_ = std::move(p_result);
  *result_ = true;
  return true;
}
class ClipboardHost_ReadHtml_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ClipboardHost::ReadHtmlCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ClipboardHost_ReadHtml_ProxyToResponder> proxy(
        new ClipboardHost_ReadHtml_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ClipboardHost_ReadHtml_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ClipboardHost_ReadHtml_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ClipboardHost_ReadHtml_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ClipboardHost::ReadHtmlCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::blink::String& in_markup, const ::blink::KURL& in_url, uint32_t in_fragment_start, uint32_t in_fragment_end);
};

bool ClipboardHost_ReadHtml_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ClipboardHost_ReadHtml_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ClipboardHost_ReadHtml_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ClipboardHost.4
  bool success = true;
  ::blink::String p_markup{};
  ::blink::KURL p_url{};
  uint32_t p_fragment_start{};
  uint32_t p_fragment_end{};
  ClipboardHost_ReadHtml_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadMarkup(&p_markup))
    success = false;
  if (success && !input_data_view.ReadUrl(&p_url))
    success = false;
  if (success)
    p_fragment_start = input_data_view.fragment_start();
  if (success)
    p_fragment_end = input_data_view.fragment_end();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ClipboardHost::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_markup), 
std::move(p_url), 
std::move(p_fragment_start), 
std::move(p_fragment_end));
  }
  return true;
}

void ClipboardHost_ReadHtml_ProxyToResponder::Run(
    const ::blink::String& in_markup, const ::blink::KURL& in_url, uint32_t in_fragment_start, uint32_t in_fragment_end) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ClipboardHost::ReadHtml", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("markup"), in_markup,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("fragment_start"), in_fragment_start,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("fragment_end"), in_fragment_end,
                        "<value of type uint32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kReadHtml), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_ReadHtml_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->markup)::BaseType> markup_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::BigString16DataView>(
    in_markup,
    markup_fragment);

  params->markup.Set(
      markup_fragment.is_null() ? nullptr : markup_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->markup.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null markup in ");
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in ");

  params->fragment_start = in_fragment_start;

  params->fragment_end = in_fragment_end;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("ReadHtml");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool ClipboardHost_ReadHtml_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ClipboardHost_ReadHtml_ResponseParams_Data* params =
      reinterpret_cast<internal::ClipboardHost_ReadHtml_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for ClipboardHost.4
  bool success = true;
  ::blink::String p_markup{};
  ::blink::KURL p_url{};
  uint32_t p_fragment_start{};
  uint32_t p_fragment_end{};
  ClipboardHost_ReadHtml_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadMarkup(&p_markup))
    success = false;
  if (success && !input_data_view.ReadUrl(&p_url))
    success = false;
  if (success)
    p_fragment_start = input_data_view.fragment_start();
  if (success)
    p_fragment_end = input_data_view.fragment_end();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ClipboardHost::Name_, 4, true);
    return false;
  }
  *out_markup_ = std::move(p_markup);
  *out_url_ = std::move(p_url);
  *out_fragment_start_ = std::move(p_fragment_start);
  *out_fragment_end_ = std::move(p_fragment_end);
  *result_ = true;
  return true;
}
class ClipboardHost_ReadSvg_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ClipboardHost::ReadSvgCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ClipboardHost_ReadSvg_ProxyToResponder> proxy(
        new ClipboardHost_ReadSvg_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ClipboardHost_ReadSvg_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ClipboardHost_ReadSvg_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ClipboardHost_ReadSvg_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ClipboardHost::ReadSvgCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::blink::String& in_result);
};

bool ClipboardHost_ReadSvg_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ClipboardHost_ReadSvg_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ClipboardHost_ReadSvg_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ClipboardHost.5
  bool success = true;
  ::blink::String p_result{};
  ClipboardHost_ReadSvg_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ClipboardHost::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void ClipboardHost_ReadSvg_ProxyToResponder::Run(
    const ::blink::String& in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ClipboardHost::ReadSvg", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type const ::blink::String&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kReadSvg), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_ReadSvg_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::BigString16DataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("ReadSvg");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ClipboardHost_ReadRtf_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ClipboardHost::ReadRtfCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ClipboardHost_ReadRtf_ProxyToResponder> proxy(
        new ClipboardHost_ReadRtf_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ClipboardHost_ReadRtf_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ClipboardHost_ReadRtf_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ClipboardHost_ReadRtf_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ClipboardHost::ReadRtfCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::blink::String& in_result);
};

bool ClipboardHost_ReadRtf_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ClipboardHost_ReadRtf_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ClipboardHost_ReadRtf_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ClipboardHost.6
  bool success = true;
  ::blink::String p_result{};
  ClipboardHost_ReadRtf_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ClipboardHost::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void ClipboardHost_ReadRtf_ProxyToResponder::Run(
    const ::blink::String& in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ClipboardHost::ReadRtf", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type const ::blink::String&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kReadRtf), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_ReadRtf_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::BigStringDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("ReadRtf");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool ClipboardHost_ReadRtf_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ClipboardHost_ReadRtf_ResponseParams_Data* params =
      reinterpret_cast<internal::ClipboardHost_ReadRtf_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for ClipboardHost.6
  bool success = true;
  ::blink::String p_result{};
  ClipboardHost_ReadRtf_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ClipboardHost::Name_, 6, true);
    return false;
  }
  *out_result_ = std::move(p_result);
  *result_ = true;
  return true;
}
class ClipboardHost_ReadPng_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ClipboardHost::ReadPngCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ClipboardHost_ReadPng_ProxyToResponder> proxy(
        new ClipboardHost_ReadPng_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ClipboardHost_ReadPng_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ClipboardHost_ReadPng_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ClipboardHost_ReadPng_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ClipboardHost::ReadPngCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo_base::BigBuffer in_png);
};

bool ClipboardHost_ReadPng_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ClipboardHost_ReadPng_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ClipboardHost_ReadPng_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ClipboardHost.7
  bool success = true;
  ::mojo_base::BigBuffer p_png{};
  ClipboardHost_ReadPng_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadPng(&p_png))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ClipboardHost::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_png));
  }
  return true;
}

void ClipboardHost_ReadPng_ProxyToResponder::Run(
    ::mojo_base::BigBuffer in_png) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ClipboardHost::ReadPng", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("png"), in_png,
                        "<value of type ::mojo_base::BigBuffer>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kReadPng), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_ReadPng_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->png)>
      png_fragment(params.message());
  png_fragment.Claim(&params->png);
  
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
    in_png,
    png_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->png.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null png in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("ReadPng");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool ClipboardHost_ReadPng_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ClipboardHost_ReadPng_ResponseParams_Data* params =
      reinterpret_cast<internal::ClipboardHost_ReadPng_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for ClipboardHost.7
  bool success = true;
  ::mojo_base::BigBuffer p_png{};
  ClipboardHost_ReadPng_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadPng(&p_png))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ClipboardHost::Name_, 7, true);
    return false;
  }
  *out_png_ = std::move(p_png);
  *result_ = true;
  return true;
}
class ClipboardHost_ReadFiles_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ClipboardHost::ReadFilesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ClipboardHost_ReadFiles_ProxyToResponder> proxy(
        new ClipboardHost_ReadFiles_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ClipboardHost_ReadFiles_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ClipboardHost_ReadFiles_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ClipboardHost_ReadFiles_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ClipboardHost::ReadFilesCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ClipboardFilesPtr in_result);
};

bool ClipboardHost_ReadFiles_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ClipboardHost_ReadFiles_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ClipboardHost_ReadFiles_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ClipboardHost.8
  bool success = true;
  ClipboardFilesPtr p_result{};
  ClipboardHost_ReadFiles_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ClipboardHost::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void ClipboardHost_ReadFiles_ProxyToResponder::Run(
    ClipboardFilesPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ClipboardHost::ReadFiles", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ClipboardFilesPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kReadFiles), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_ReadFiles_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ClipboardFilesDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("ReadFiles");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool ClipboardHost_ReadFiles_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ClipboardHost_ReadFiles_ResponseParams_Data* params =
      reinterpret_cast<internal::ClipboardHost_ReadFiles_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for ClipboardHost.8
  bool success = true;
  ClipboardFilesPtr p_result{};
  ClipboardHost_ReadFiles_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ClipboardHost::Name_, 8, true);
    return false;
  }
  *out_result_ = std::move(p_result);
  *result_ = true;
  return true;
}
class ClipboardHost_ReadDataTransferCustomData_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ClipboardHost::ReadDataTransferCustomDataCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ClipboardHost_ReadDataTransferCustomData_ProxyToResponder> proxy(
        new ClipboardHost_ReadDataTransferCustomData_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ClipboardHost_ReadDataTransferCustomData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ClipboardHost_ReadDataTransferCustomData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ClipboardHost_ReadDataTransferCustomData_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ClipboardHost::ReadDataTransferCustomDataCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::blink::String& in_result);
};

bool ClipboardHost_ReadDataTransferCustomData_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ClipboardHost_ReadDataTransferCustomData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ClipboardHost_ReadDataTransferCustomData_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ClipboardHost.9
  bool success = true;
  ::blink::String p_result{};
  ClipboardHost_ReadDataTransferCustomData_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ClipboardHost::Name_, 9, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void ClipboardHost_ReadDataTransferCustomData_ProxyToResponder::Run(
    const ::blink::String& in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ClipboardHost::ReadDataTransferCustomData", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type const ::blink::String&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kReadDataTransferCustomData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_ReadDataTransferCustomData_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::BigString16DataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("ReadDataTransferCustomData");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool ClipboardHost_ReadDataTransferCustomData_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ClipboardHost_ReadDataTransferCustomData_ResponseParams_Data* params =
      reinterpret_cast<internal::ClipboardHost_ReadDataTransferCustomData_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for ClipboardHost.9
  bool success = true;
  ::blink::String p_result{};
  ClipboardHost_ReadDataTransferCustomData_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ClipboardHost::Name_, 9, true);
    return false;
  }
  *out_result_ = std::move(p_result);
  *result_ = true;
  return true;
}
class ClipboardHost_ReadAvailableCustomAndStandardFormats_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ClipboardHost::ReadAvailableCustomAndStandardFormatsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ClipboardHost_ReadAvailableCustomAndStandardFormats_ProxyToResponder> proxy(
        new ClipboardHost_ReadAvailableCustomAndStandardFormats_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ClipboardHost_ReadAvailableCustomAndStandardFormats_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ClipboardHost_ReadAvailableCustomAndStandardFormats_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ClipboardHost_ReadAvailableCustomAndStandardFormats_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ClipboardHost::ReadAvailableCustomAndStandardFormatsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::blink::Vector<::blink::String>& in_format_types);
};

bool ClipboardHost_ReadAvailableCustomAndStandardFormats_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ClipboardHost_ReadAvailableCustomAndStandardFormats_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ClipboardHost_ReadAvailableCustomAndStandardFormats_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ClipboardHost.10
  bool success = true;
  ::blink::Vector<::blink::String> p_format_types{};
  ClipboardHost_ReadAvailableCustomAndStandardFormats_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadFormatTypes(&p_format_types))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ClipboardHost::Name_, 10, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_format_types));
  }
  return true;
}

void ClipboardHost_ReadAvailableCustomAndStandardFormats_ProxyToResponder::Run(
    const ::blink::Vector<::blink::String>& in_format_types) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ClipboardHost::ReadAvailableCustomAndStandardFormats", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("format_types"), in_format_types,
                        "<value of type const ::blink::Vector<::blink::String>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kReadAvailableCustomAndStandardFormats), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_ReadAvailableCustomAndStandardFormats_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->format_types)::BaseType>
      format_types_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& format_types_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>(
    in_format_types,
    format_types_fragment,
    &format_types_validate_params);

  params->format_types.Set(
      format_types_fragment.is_null() ? nullptr : format_types_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->format_types.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null format_types in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("ReadAvailableCustomAndStandardFormats");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool ClipboardHost_ReadAvailableCustomAndStandardFormats_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ClipboardHost_ReadAvailableCustomAndStandardFormats_ResponseParams_Data* params =
      reinterpret_cast<internal::ClipboardHost_ReadAvailableCustomAndStandardFormats_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for ClipboardHost.10
  bool success = true;
  ::blink::Vector<::blink::String> p_format_types{};
  ClipboardHost_ReadAvailableCustomAndStandardFormats_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadFormatTypes(&p_format_types))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ClipboardHost::Name_, 10, true);
    return false;
  }
  *out_format_types_ = std::move(p_format_types);
  *result_ = true;
  return true;
}
class ClipboardHost_ReadUnsanitizedCustomFormat_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ClipboardHost::ReadUnsanitizedCustomFormatCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ClipboardHost_ReadUnsanitizedCustomFormat_ProxyToResponder> proxy(
        new ClipboardHost_ReadUnsanitizedCustomFormat_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ClipboardHost_ReadUnsanitizedCustomFormat_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ClipboardHost_ReadUnsanitizedCustomFormat_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ClipboardHost_ReadUnsanitizedCustomFormat_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ClipboardHost::ReadUnsanitizedCustomFormatCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo_base::BigBuffer in_data);
};

bool ClipboardHost_ReadUnsanitizedCustomFormat_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ClipboardHost_ReadUnsanitizedCustomFormat_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ClipboardHost_ReadUnsanitizedCustomFormat_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ClipboardHost.11
  bool success = true;
  ::mojo_base::BigBuffer p_data{};
  ClipboardHost_ReadUnsanitizedCustomFormat_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ClipboardHost::Name_, 11, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_data));
  }
  return true;
}

void ClipboardHost_ReadUnsanitizedCustomFormat_ProxyToResponder::Run(
    ::mojo_base::BigBuffer in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ClipboardHost::ReadUnsanitizedCustomFormat", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type ::mojo_base::BigBuffer>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kReadUnsanitizedCustomFormat), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_ReadUnsanitizedCustomFormat_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->data)>
      data_fragment(params.message());
  data_fragment.Claim(&params->data);
  
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
    in_data,
    data_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("ReadUnsanitizedCustomFormat");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ClipboardHost_EndCopyWithCompletion_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ClipboardHost::EndCopyWithCompletionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ClipboardHost_EndCopyWithCompletion_ProxyToResponder> proxy(
        new ClipboardHost_EndCopyWithCompletion_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ClipboardHost_EndCopyWithCompletion_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ClipboardHost_EndCopyWithCompletion_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ClipboardHost_EndCopyWithCompletion_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ClipboardHost::EndCopyWithCompletionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_token);
};

bool ClipboardHost_EndCopyWithCompletion_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ClipboardHost_EndCopyWithCompletion_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ClipboardHost_EndCopyWithCompletion_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ClipboardHost.22
  bool success = true;
  int32_t p_token{};
  ClipboardHost_EndCopyWithCompletion_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_token = input_data_view.token();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ClipboardHost::Name_, 22, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_token));
  }
  return true;
}

void ClipboardHost_EndCopyWithCompletion_ProxyToResponder::Run(
    int32_t in_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ClipboardHost::EndCopyWithCompletion", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kEndCopyWithCompletion), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_EndCopyWithCompletion_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->token = in_token;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("EndCopyWithCompletion");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ClipboardHost_EndPasteWithCompletion_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ClipboardHost::EndPasteWithCompletionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ClipboardHost_EndPasteWithCompletion_ProxyToResponder> proxy(
        new ClipboardHost_EndPasteWithCompletion_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ClipboardHost_EndPasteWithCompletion_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ClipboardHost_EndPasteWithCompletion_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ClipboardHost_EndPasteWithCompletion_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ClipboardHost::EndPasteWithCompletionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_token);
};

bool ClipboardHost_EndPasteWithCompletion_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ClipboardHost_EndPasteWithCompletion_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ClipboardHost_EndPasteWithCompletion_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ClipboardHost.24
  bool success = true;
  int32_t p_token{};
  ClipboardHost_EndPasteWithCompletion_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_token = input_data_view.token();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ClipboardHost::Name_, 24, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_token));
  }
  return true;
}

void ClipboardHost_EndPasteWithCompletion_ProxyToResponder::Run(
    int32_t in_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ClipboardHost::EndPasteWithCompletion", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kEndPasteWithCompletion), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_EndPasteWithCompletion_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->token = in_token;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("EndPasteWithCompletion");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ClipboardHost_GetPlatformPermissionState_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ClipboardHost::GetPlatformPermissionStateCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ClipboardHost_GetPlatformPermissionState_ProxyToResponder> proxy(
        new ClipboardHost_GetPlatformPermissionState_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ClipboardHost_GetPlatformPermissionState_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ClipboardHost_GetPlatformPermissionState_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ClipboardHost_GetPlatformPermissionState_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ClipboardHost::GetPlatformPermissionStateCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      PlatformClipboardPermissionState in_state);
};

bool ClipboardHost_GetPlatformPermissionState_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ClipboardHost_GetPlatformPermissionState_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ClipboardHost_GetPlatformPermissionState_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ClipboardHost.26
  bool success = true;
  PlatformClipboardPermissionState p_state{};
  ClipboardHost_GetPlatformPermissionState_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadState(&p_state))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ClipboardHost::Name_, 26, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_state));
  }
  return true;
}

void ClipboardHost_GetPlatformPermissionState_ProxyToResponder::Run(
    PlatformClipboardPermissionState in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ClipboardHost::GetPlatformPermissionState", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type PlatformClipboardPermissionState>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClipboardHost::kGetPlatformPermissionState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ClipboardHost_GetPlatformPermissionState_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::PlatformClipboardPermissionState>(
    in_state,
    &params->state);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClipboardHost::Name_);
  message.set_method_name("GetPlatformPermissionState");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ClipboardHostStubDispatch::Accept(
    ClipboardHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ClipboardHost>(message->header()->name)) {
    case messages::ClipboardHost::kGetSequenceNumber: {
      break;
    }
    case messages::ClipboardHost::kIsFormatAvailable: {
      break;
    }
    case messages::ClipboardHost::kReadAvailableTypes: {
      break;
    }
    case messages::ClipboardHost::kReadText: {
      break;
    }
    case messages::ClipboardHost::kReadHtml: {
      break;
    }
    case messages::ClipboardHost::kReadSvg: {
      break;
    }
    case messages::ClipboardHost::kReadRtf: {
      break;
    }
    case messages::ClipboardHost::kReadPng: {
      break;
    }
    case messages::ClipboardHost::kReadFiles: {
      break;
    }
    case messages::ClipboardHost::kReadDataTransferCustomData: {
      break;
    }
    case messages::ClipboardHost::kReadAvailableCustomAndStandardFormats: {
      break;
    }
    case messages::ClipboardHost::kReadUnsanitizedCustomFormat: {
      break;
    }
    case messages::ClipboardHost::kWriteText: {
      DCHECK(message->is_serialized());
      internal::ClipboardHost_WriteText_Params_Data* params =
          reinterpret_cast<internal::ClipboardHost_WriteText_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ClipboardHost.12
      bool success = true;
      ::blink::String p_text{};
      ClipboardHost_WriteText_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadText(&p_text))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClipboardHost::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WriteText(        
        std::move(p_text));
      return true;
    }
    case messages::ClipboardHost::kWriteHtml: {
      DCHECK(message->is_serialized());
      internal::ClipboardHost_WriteHtml_Params_Data* params =
          reinterpret_cast<internal::ClipboardHost_WriteHtml_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ClipboardHost.13
      bool success = true;
      ::blink::String p_markup{};
      ::blink::KURL p_url{};
      ClipboardHost_WriteHtml_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMarkup(&p_markup))
        success = false;
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClipboardHost::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WriteHtml(        
        std::move(p_markup), 
        std::move(p_url));
      return true;
    }
    case messages::ClipboardHost::kWriteSvg: {
      DCHECK(message->is_serialized());
      internal::ClipboardHost_WriteSvg_Params_Data* params =
          reinterpret_cast<internal::ClipboardHost_WriteSvg_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ClipboardHost.14
      bool success = true;
      ::blink::String p_markup{};
      ClipboardHost_WriteSvg_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMarkup(&p_markup))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClipboardHost::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WriteSvg(        
        std::move(p_markup));
      return true;
    }
    case messages::ClipboardHost::kWriteSmartPasteMarker: {
      DCHECK(message->is_serialized());
      internal::ClipboardHost_WriteSmartPasteMarker_Params_Data* params =
          reinterpret_cast<internal::ClipboardHost_WriteSmartPasteMarker_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ClipboardHost.15
      bool success = true;
      ClipboardHost_WriteSmartPasteMarker_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClipboardHost::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WriteSmartPasteMarker(        );
      return true;
    }
    case messages::ClipboardHost::kWriteDataTransferCustomData: {
      DCHECK(message->is_serialized());
      internal::ClipboardHost_WriteDataTransferCustomData_Params_Data* params =
          reinterpret_cast<internal::ClipboardHost_WriteDataTransferCustomData_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ClipboardHost.16
      bool success = true;
      ::blink::HashMap<::blink::String, ::blink::String> p_data{};
      ClipboardHost_WriteDataTransferCustomData_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClipboardHost::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WriteDataTransferCustomData(        
        std::move(p_data));
      return true;
    }
    case messages::ClipboardHost::kWriteBookmark: {
      DCHECK(message->is_serialized());
      internal::ClipboardHost_WriteBookmark_Params_Data* params =
          reinterpret_cast<internal::ClipboardHost_WriteBookmark_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ClipboardHost.17
      bool success = true;
      ::blink::String p_url{};
      ::blink::String p_title{};
      ClipboardHost_WriteBookmark_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadTitle(&p_title))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClipboardHost::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WriteBookmark(        
        std::move(p_url), 
        std::move(p_title));
      return true;
    }
    case messages::ClipboardHost::kWriteImage: {
      DCHECK(message->is_serialized());
      internal::ClipboardHost_WriteImage_Params_Data* params =
          reinterpret_cast<internal::ClipboardHost_WriteImage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ClipboardHost.18
      bool success = true;
      ::SkBitmap p_image{};
      ClipboardHost_WriteImage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadImage(&p_image))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClipboardHost::Name_, 18, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WriteImage(        
        std::move(p_image));
      return true;
    }
    case messages::ClipboardHost::kWriteUnsanitizedCustomFormat: {
      DCHECK(message->is_serialized());
      internal::ClipboardHost_WriteUnsanitizedCustomFormat_Params_Data* params =
          reinterpret_cast<internal::ClipboardHost_WriteUnsanitizedCustomFormat_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ClipboardHost.19
      bool success = true;
      ::blink::String p_format{};
      ::mojo_base::BigBuffer p_data{};
      ClipboardHost_WriteUnsanitizedCustomFormat_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFormat(&p_format))
        success = false;
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClipboardHost::Name_, 19, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WriteUnsanitizedCustomFormat(        
        std::move(p_format), 
        std::move(p_data));
      return true;
    }
    case messages::ClipboardHost::kCommitWrite: {
      DCHECK(message->is_serialized());
      internal::ClipboardHost_CommitWrite_Params_Data* params =
          reinterpret_cast<internal::ClipboardHost_CommitWrite_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ClipboardHost.20
      bool success = true;
      ClipboardHost_CommitWrite_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClipboardHost::Name_, 20, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CommitWrite(        );
      return true;
    }
    case messages::ClipboardHost::kBeginCopyWithCompletion: {
      DCHECK(message->is_serialized());
      internal::ClipboardHost_BeginCopyWithCompletion_Params_Data* params =
          reinterpret_cast<internal::ClipboardHost_BeginCopyWithCompletion_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ClipboardHost.21
      bool success = true;
      int32_t p_token{};
      ClipboardHost_BeginCopyWithCompletion_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_token = input_data_view.token();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClipboardHost::Name_, 21, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BeginCopyWithCompletion(        
        std::move(p_token));
      return true;
    }
    case messages::ClipboardHost::kEndCopyWithCompletion: {
      break;
    }
    case messages::ClipboardHost::kBeginPasteWithCompletion: {
      DCHECK(message->is_serialized());
      internal::ClipboardHost_BeginPasteWithCompletion_Params_Data* params =
          reinterpret_cast<internal::ClipboardHost_BeginPasteWithCompletion_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ClipboardHost.23
      bool success = true;
      int32_t p_token{};
      ClipboardHost_BeginPasteWithCompletion_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_token = input_data_view.token();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClipboardHost::Name_, 23, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BeginPasteWithCompletion(        
        std::move(p_token));
      return true;
    }
    case messages::ClipboardHost::kEndPasteWithCompletion: {
      break;
    }
    case messages::ClipboardHost::kWriteStringToFindPboard: {
      DCHECK(message->is_serialized());
      internal::ClipboardHost_WriteStringToFindPboard_Params_Data* params =
          reinterpret_cast<internal::ClipboardHost_WriteStringToFindPboard_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ClipboardHost.25
      bool success = true;
      ::blink::String p_text{};
      ClipboardHost_WriteStringToFindPboard_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadText(&p_text))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClipboardHost::Name_, 25, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WriteStringToFindPboard(        
        std::move(p_text));
      return true;
    }
    case messages::ClipboardHost::kGetPlatformPermissionState: {
      break;
    }
    case messages::ClipboardHost::kRegisterClipboardListener: {
      DCHECK(message->is_serialized());
      internal::ClipboardHost_RegisterClipboardListener_Params_Data* params =
          reinterpret_cast<internal::ClipboardHost_RegisterClipboardListener_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ClipboardHost.27
      bool success = true;
      ::mojo::PendingRemote<ClipboardListener> p_listener{};
      ClipboardHost_RegisterClipboardListener_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_listener =
            input_data_view.TakeListener<decltype(p_listener)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClipboardHost::Name_, 27, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterClipboardListener(        
        std::move(p_listener));
      return true;
    }
  }
  return false;
}

// static
bool ClipboardHostStubDispatch::AcceptWithResponder(
    ClipboardHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ClipboardHost>(message->header()->name)) {
    case messages::ClipboardHost::kGetSequenceNumber: {
      internal::ClipboardHost_GetSequenceNumber_Params_Data* params =
          reinterpret_cast<
              internal::ClipboardHost_GetSequenceNumber_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ClipboardHost.0
      bool success = true;
      ClipboardBuffer p_buffer{};
      ClipboardHost_GetSequenceNumber_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBuffer(&p_buffer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClipboardHost::Name_, 0, false);
        return false;
      }
      auto callback =
          ClipboardHost_GetSequenceNumber_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetSequenceNumber(        
        std::move(p_buffer), std::move(callback));
      return true;
    }
    case messages::ClipboardHost::kIsFormatAvailable: {
      internal::ClipboardHost_IsFormatAvailable_Params_Data* params =
          reinterpret_cast<
              internal::ClipboardHost_IsFormatAvailable_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ClipboardHost.1
      bool success = true;
      ClipboardFormat p_format{};
      ClipboardBuffer p_buffer{};
      ClipboardHost_IsFormatAvailable_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFormat(&p_format))
        success = false;
      if (success && !input_data_view.ReadBuffer(&p_buffer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClipboardHost::Name_, 1, false);
        return false;
      }
      auto callback =
          ClipboardHost_IsFormatAvailable_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IsFormatAvailable(        
        std::move(p_format), 
        std::move(p_buffer), std::move(callback));
      return true;
    }
    case messages::ClipboardHost::kReadAvailableTypes: {
      internal::ClipboardHost_ReadAvailableTypes_Params_Data* params =
          reinterpret_cast<
              internal::ClipboardHost_ReadAvailableTypes_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ClipboardHost.2
      bool success = true;
      ClipboardBuffer p_buffer{};
      ClipboardHost_ReadAvailableTypes_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBuffer(&p_buffer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClipboardHost::Name_, 2, false);
        return false;
      }
      auto callback =
          ClipboardHost_ReadAvailableTypes_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReadAvailableTypes(        
        std::move(p_buffer), std::move(callback));
      return true;
    }
    case messages::ClipboardHost::kReadText: {
      internal::ClipboardHost_ReadText_Params_Data* params =
          reinterpret_cast<
              internal::ClipboardHost_ReadText_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ClipboardHost.3
      bool success = true;
      ClipboardBuffer p_buffer{};
      ClipboardHost_ReadText_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBuffer(&p_buffer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClipboardHost::Name_, 3, false);
        return false;
      }
      auto callback =
          ClipboardHost_ReadText_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReadText(        
        std::move(p_buffer), std::move(callback));
      return true;
    }
    case messages::ClipboardHost::kReadHtml: {
      internal::ClipboardHost_ReadHtml_Params_Data* params =
          reinterpret_cast<
              internal::ClipboardHost_ReadHtml_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ClipboardHost.4
      bool success = true;
      ClipboardBuffer p_buffer{};
      ClipboardHost_ReadHtml_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBuffer(&p_buffer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClipboardHost::Name_, 4, false);
        return false;
      }
      auto callback =
          ClipboardHost_ReadHtml_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReadHtml(        
        std::move(p_buffer), std::move(callback));
      return true;
    }
    case messages::ClipboardHost::kReadSvg: {
      internal::ClipboardHost_ReadSvg_Params_Data* params =
          reinterpret_cast<
              internal::ClipboardHost_ReadSvg_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ClipboardHost.5
      bool success = true;
      ClipboardBuffer p_buffer{};
      ClipboardHost_ReadSvg_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBuffer(&p_buffer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClipboardHost::Name_, 5, false);
        return false;
      }
      auto callback =
          ClipboardHost_ReadSvg_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReadSvg(        
        std::move(p_buffer), std::move(callback));
      return true;
    }
    case messages::ClipboardHost::kReadRtf: {
      internal::ClipboardHost_ReadRtf_Params_Data* params =
          reinterpret_cast<
              internal::ClipboardHost_ReadRtf_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ClipboardHost.6
      bool success = true;
      ClipboardBuffer p_buffer{};
      ClipboardHost_ReadRtf_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBuffer(&p_buffer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClipboardHost::Name_, 6, false);
        return false;
      }
      auto callback =
          ClipboardHost_ReadRtf_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReadRtf(        
        std::move(p_buffer), std::move(callback));
      return true;
    }
    case messages::ClipboardHost::kReadPng: {
      internal::ClipboardHost_ReadPng_Params_Data* params =
          reinterpret_cast<
              internal::ClipboardHost_ReadPng_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ClipboardHost.7
      bool success = true;
      ClipboardBuffer p_buffer{};
      ClipboardHost_ReadPng_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBuffer(&p_buffer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClipboardHost::Name_, 7, false);
        return false;
      }
      auto callback =
          ClipboardHost_ReadPng_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReadPng(        
        std::move(p_buffer), std::move(callback));
      return true;
    }
    case messages::ClipboardHost::kReadFiles: {
      internal::ClipboardHost_ReadFiles_Params_Data* params =
          reinterpret_cast<
              internal::ClipboardHost_ReadFiles_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ClipboardHost.8
      bool success = true;
      ClipboardBuffer p_buffer{};
      ClipboardHost_ReadFiles_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBuffer(&p_buffer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClipboardHost::Name_, 8, false);
        return false;
      }
      auto callback =
          ClipboardHost_ReadFiles_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReadFiles(        
        std::move(p_buffer), std::move(callback));
      return true;
    }
    case messages::ClipboardHost::kReadDataTransferCustomData: {
      internal::ClipboardHost_ReadDataTransferCustomData_Params_Data* params =
          reinterpret_cast<
              internal::ClipboardHost_ReadDataTransferCustomData_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ClipboardHost.9
      bool success = true;
      ClipboardBuffer p_buffer{};
      ::blink::String p_type{};
      ClipboardHost_ReadDataTransferCustomData_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBuffer(&p_buffer))
        success = false;
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClipboardHost::Name_, 9, false);
        return false;
      }
      auto callback =
          ClipboardHost_ReadDataTransferCustomData_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReadDataTransferCustomData(        
        std::move(p_buffer), 
        std::move(p_type), std::move(callback));
      return true;
    }
    case messages::ClipboardHost::kReadAvailableCustomAndStandardFormats: {
      internal::ClipboardHost_ReadAvailableCustomAndStandardFormats_Params_Data* params =
          reinterpret_cast<
              internal::ClipboardHost_ReadAvailableCustomAndStandardFormats_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ClipboardHost.10
      bool success = true;
      ClipboardHost_ReadAvailableCustomAndStandardFormats_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClipboardHost::Name_, 10, false);
        return false;
      }
      auto callback =
          ClipboardHost_ReadAvailableCustomAndStandardFormats_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReadAvailableCustomAndStandardFormats(std::move(callback));
      return true;
    }
    case messages::ClipboardHost::kReadUnsanitizedCustomFormat: {
      internal::ClipboardHost_ReadUnsanitizedCustomFormat_Params_Data* params =
          reinterpret_cast<
              internal::ClipboardHost_ReadUnsanitizedCustomFormat_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ClipboardHost.11
      bool success = true;
      ::blink::String p_format{};
      ClipboardHost_ReadUnsanitizedCustomFormat_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFormat(&p_format))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClipboardHost::Name_, 11, false);
        return false;
      }
      auto callback =
          ClipboardHost_ReadUnsanitizedCustomFormat_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReadUnsanitizedCustomFormat(        
        std::move(p_format), std::move(callback));
      return true;
    }
    case messages::ClipboardHost::kWriteText: {
      break;
    }
    case messages::ClipboardHost::kWriteHtml: {
      break;
    }
    case messages::ClipboardHost::kWriteSvg: {
      break;
    }
    case messages::ClipboardHost::kWriteSmartPasteMarker: {
      break;
    }
    case messages::ClipboardHost::kWriteDataTransferCustomData: {
      break;
    }
    case messages::ClipboardHost::kWriteBookmark: {
      break;
    }
    case messages::ClipboardHost::kWriteImage: {
      break;
    }
    case messages::ClipboardHost::kWriteUnsanitizedCustomFormat: {
      break;
    }
    case messages::ClipboardHost::kCommitWrite: {
      break;
    }
    case messages::ClipboardHost::kBeginCopyWithCompletion: {
      break;
    }
    case messages::ClipboardHost::kEndCopyWithCompletion: {
      internal::ClipboardHost_EndCopyWithCompletion_Params_Data* params =
          reinterpret_cast<
              internal::ClipboardHost_EndCopyWithCompletion_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ClipboardHost.22
      bool success = true;
      int32_t p_token{};
      ClipboardHost_EndCopyWithCompletion_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_token = input_data_view.token();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClipboardHost::Name_, 22, false);
        return false;
      }
      auto callback =
          ClipboardHost_EndCopyWithCompletion_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EndCopyWithCompletion(        
        std::move(p_token), std::move(callback));
      return true;
    }
    case messages::ClipboardHost::kBeginPasteWithCompletion: {
      break;
    }
    case messages::ClipboardHost::kEndPasteWithCompletion: {
      internal::ClipboardHost_EndPasteWithCompletion_Params_Data* params =
          reinterpret_cast<
              internal::ClipboardHost_EndPasteWithCompletion_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ClipboardHost.24
      bool success = true;
      int32_t p_token{};
      ClipboardHost_EndPasteWithCompletion_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_token = input_data_view.token();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClipboardHost::Name_, 24, false);
        return false;
      }
      auto callback =
          ClipboardHost_EndPasteWithCompletion_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EndPasteWithCompletion(        
        std::move(p_token), std::move(callback));
      return true;
    }
    case messages::ClipboardHost::kWriteStringToFindPboard: {
      break;
    }
    case messages::ClipboardHost::kGetPlatformPermissionState: {
      internal::ClipboardHost_GetPlatformPermissionState_Params_Data* params =
          reinterpret_cast<
              internal::ClipboardHost_GetPlatformPermissionState_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ClipboardHost.26
      bool success = true;
      ClipboardHost_GetPlatformPermissionState_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClipboardHost::Name_, 26, false);
        return false;
      }
      auto callback =
          ClipboardHost_GetPlatformPermissionState_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPlatformPermissionState(std::move(callback));
      return true;
    }
    case messages::ClipboardHost::kRegisterClipboardListener: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kClipboardHostValidationInfo[] = {
    { &internal::ClipboardHost_GetSequenceNumber_Params_Data::Validate,
     &internal::ClipboardHost_GetSequenceNumber_ResponseParams_Data::Validate},
    { &internal::ClipboardHost_IsFormatAvailable_Params_Data::Validate,
     &internal::ClipboardHost_IsFormatAvailable_ResponseParams_Data::Validate},
    { &internal::ClipboardHost_ReadAvailableTypes_Params_Data::Validate,
     &internal::ClipboardHost_ReadAvailableTypes_ResponseParams_Data::Validate},
    { &internal::ClipboardHost_ReadText_Params_Data::Validate,
     &internal::ClipboardHost_ReadText_ResponseParams_Data::Validate},
    { &internal::ClipboardHost_ReadHtml_Params_Data::Validate,
     &internal::ClipboardHost_ReadHtml_ResponseParams_Data::Validate},
    { &internal::ClipboardHost_ReadSvg_Params_Data::Validate,
     &internal::ClipboardHost_ReadSvg_ResponseParams_Data::Validate},
    { &internal::ClipboardHost_ReadRtf_Params_Data::Validate,
     &internal::ClipboardHost_ReadRtf_ResponseParams_Data::Validate},
    { &internal::ClipboardHost_ReadPng_Params_Data::Validate,
     &internal::ClipboardHost_ReadPng_ResponseParams_Data::Validate},
    { &internal::ClipboardHost_ReadFiles_Params_Data::Validate,
     &internal::ClipboardHost_ReadFiles_ResponseParams_Data::Validate},
    { &internal::ClipboardHost_ReadDataTransferCustomData_Params_Data::Validate,
     &internal::ClipboardHost_ReadDataTransferCustomData_ResponseParams_Data::Validate},
    { &internal::ClipboardHost_ReadAvailableCustomAndStandardFormats_Params_Data::Validate,
     &internal::ClipboardHost_ReadAvailableCustomAndStandardFormats_ResponseParams_Data::Validate},
    { &internal::ClipboardHost_ReadUnsanitizedCustomFormat_Params_Data::Validate,
     &internal::ClipboardHost_ReadUnsanitizedCustomFormat_ResponseParams_Data::Validate},
    { &internal::ClipboardHost_WriteText_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ClipboardHost_WriteHtml_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ClipboardHost_WriteSvg_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ClipboardHost_WriteSmartPasteMarker_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ClipboardHost_WriteDataTransferCustomData_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ClipboardHost_WriteBookmark_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ClipboardHost_WriteImage_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ClipboardHost_WriteUnsanitizedCustomFormat_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ClipboardHost_CommitWrite_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ClipboardHost_BeginCopyWithCompletion_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ClipboardHost_EndCopyWithCompletion_Params_Data::Validate,
     &internal::ClipboardHost_EndCopyWithCompletion_ResponseParams_Data::Validate},
    { &internal::ClipboardHost_BeginPasteWithCompletion_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ClipboardHost_EndPasteWithCompletion_Params_Data::Validate,
     &internal::ClipboardHost_EndPasteWithCompletion_ResponseParams_Data::Validate},
    { &internal::ClipboardHost_WriteStringToFindPboard_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ClipboardHost_GetPlatformPermissionState_Params_Data::Validate,
     &internal::ClipboardHost_GetPlatformPermissionState_ResponseParams_Data::Validate},
    { &internal::ClipboardHost_RegisterClipboardListener_Params_Data::Validate,
     nullptr /* no response */},
};

bool ClipboardHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::ClipboardHost::Name_,
    kClipboardHostValidationInfo);
}

bool ClipboardHostResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::ClipboardHost::Name_,
    kClipboardHostValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::ClipboardFiles::DataView, ::blink::mojom::blink::ClipboardFilesPtr>::Read(
    ::blink::mojom::blink::ClipboardFiles::DataView input,
    ::blink::mojom::blink::ClipboardFilesPtr* output) {
  bool success = true;
  ::blink::mojom::blink::ClipboardFilesPtr result(::blink::mojom::blink::ClipboardFiles::New());
  
      if (success && !input.ReadFiles(&result->files))
        success = false;
      if (success && !input.ReadFileSystemId(&result->file_system_id))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void ClipboardListenerInterceptorForTesting::OnClipboardDataChanged() {
  GetForwardingInterface()->OnClipboardDataChanged();
}
ClipboardListenerAsyncWaiter::ClipboardListenerAsyncWaiter(
    ClipboardListener* proxy) : proxy_(proxy) {}

ClipboardListenerAsyncWaiter::~ClipboardListenerAsyncWaiter() = default;





void ClipboardHostInterceptorForTesting::GetSequenceNumber(ClipboardBuffer buffer, GetSequenceNumberCallback callback) {
  GetForwardingInterface()->GetSequenceNumber(
    std::move(buffer)
    , std::move(callback));
}
void ClipboardHostInterceptorForTesting::IsFormatAvailable(ClipboardFormat format, ClipboardBuffer buffer, IsFormatAvailableCallback callback) {
  GetForwardingInterface()->IsFormatAvailable(
    std::move(format)
    , 
    std::move(buffer)
    , std::move(callback));
}
void ClipboardHostInterceptorForTesting::ReadAvailableTypes(ClipboardBuffer buffer, ReadAvailableTypesCallback callback) {
  GetForwardingInterface()->ReadAvailableTypes(
    std::move(buffer)
    , std::move(callback));
}
void ClipboardHostInterceptorForTesting::ReadText(ClipboardBuffer buffer, ReadTextCallback callback) {
  GetForwardingInterface()->ReadText(
    std::move(buffer)
    , std::move(callback));
}
void ClipboardHostInterceptorForTesting::ReadHtml(ClipboardBuffer buffer, ReadHtmlCallback callback) {
  GetForwardingInterface()->ReadHtml(
    std::move(buffer)
    , std::move(callback));
}
void ClipboardHostInterceptorForTesting::ReadSvg(ClipboardBuffer buffer, ReadSvgCallback callback) {
  GetForwardingInterface()->ReadSvg(
    std::move(buffer)
    , std::move(callback));
}
void ClipboardHostInterceptorForTesting::ReadRtf(ClipboardBuffer buffer, ReadRtfCallback callback) {
  GetForwardingInterface()->ReadRtf(
    std::move(buffer)
    , std::move(callback));
}
void ClipboardHostInterceptorForTesting::ReadPng(ClipboardBuffer buffer, ReadPngCallback callback) {
  GetForwardingInterface()->ReadPng(
    std::move(buffer)
    , std::move(callback));
}
void ClipboardHostInterceptorForTesting::ReadFiles(ClipboardBuffer buffer, ReadFilesCallback callback) {
  GetForwardingInterface()->ReadFiles(
    std::move(buffer)
    , std::move(callback));
}
void ClipboardHostInterceptorForTesting::ReadDataTransferCustomData(ClipboardBuffer buffer, const ::blink::String& type, ReadDataTransferCustomDataCallback callback) {
  GetForwardingInterface()->ReadDataTransferCustomData(
    std::move(buffer)
    , 
    std::move(type)
    , std::move(callback));
}
void ClipboardHostInterceptorForTesting::ReadAvailableCustomAndStandardFormats(ReadAvailableCustomAndStandardFormatsCallback callback) {
  GetForwardingInterface()->ReadAvailableCustomAndStandardFormats(std::move(callback));
}
void ClipboardHostInterceptorForTesting::ReadUnsanitizedCustomFormat(const ::blink::String& format, ReadUnsanitizedCustomFormatCallback callback) {
  GetForwardingInterface()->ReadUnsanitizedCustomFormat(
    std::move(format)
    , std::move(callback));
}
void ClipboardHostInterceptorForTesting::WriteText(const ::blink::String& text) {
  GetForwardingInterface()->WriteText(
    std::move(text)
    );
}
void ClipboardHostInterceptorForTesting::WriteHtml(const ::blink::String& markup, const ::blink::KURL& url) {
  GetForwardingInterface()->WriteHtml(
    std::move(markup)
    , 
    std::move(url)
    );
}
void ClipboardHostInterceptorForTesting::WriteSvg(const ::blink::String& markup) {
  GetForwardingInterface()->WriteSvg(
    std::move(markup)
    );
}
void ClipboardHostInterceptorForTesting::WriteSmartPasteMarker() {
  GetForwardingInterface()->WriteSmartPasteMarker();
}
void ClipboardHostInterceptorForTesting::WriteDataTransferCustomData(const ::blink::HashMap<::blink::String, ::blink::String>& data) {
  GetForwardingInterface()->WriteDataTransferCustomData(
    std::move(data)
    );
}
void ClipboardHostInterceptorForTesting::WriteBookmark(const ::blink::String& url, const ::blink::String& title) {
  GetForwardingInterface()->WriteBookmark(
    std::move(url)
    , 
    std::move(title)
    );
}
void ClipboardHostInterceptorForTesting::WriteImage(const ::SkBitmap& image) {
  GetForwardingInterface()->WriteImage(
    std::move(image)
    );
}
void ClipboardHostInterceptorForTesting::WriteUnsanitizedCustomFormat(const ::blink::String& format, ::mojo_base::BigBuffer data) {
  GetForwardingInterface()->WriteUnsanitizedCustomFormat(
    std::move(format)
    , 
    std::move(data)
    );
}
void ClipboardHostInterceptorForTesting::CommitWrite() {
  GetForwardingInterface()->CommitWrite();
}
void ClipboardHostInterceptorForTesting::BeginCopyWithCompletion(int32_t token) {
  GetForwardingInterface()->BeginCopyWithCompletion(
    std::move(token)
    );
}
void ClipboardHostInterceptorForTesting::EndCopyWithCompletion(int32_t token, EndCopyWithCompletionCallback callback) {
  GetForwardingInterface()->EndCopyWithCompletion(
    std::move(token)
    , std::move(callback));
}
void ClipboardHostInterceptorForTesting::BeginPasteWithCompletion(int32_t token) {
  GetForwardingInterface()->BeginPasteWithCompletion(
    std::move(token)
    );
}
void ClipboardHostInterceptorForTesting::EndPasteWithCompletion(int32_t token, EndPasteWithCompletionCallback callback) {
  GetForwardingInterface()->EndPasteWithCompletion(
    std::move(token)
    , std::move(callback));
}
void ClipboardHostInterceptorForTesting::WriteStringToFindPboard(const ::blink::String& text) {
  GetForwardingInterface()->WriteStringToFindPboard(
    std::move(text)
    );
}
void ClipboardHostInterceptorForTesting::GetPlatformPermissionState(GetPlatformPermissionStateCallback callback) {
  GetForwardingInterface()->GetPlatformPermissionState(std::move(callback));
}
void ClipboardHostInterceptorForTesting::RegisterClipboardListener(::mojo::PendingRemote<ClipboardListener> listener) {
  GetForwardingInterface()->RegisterClipboardListener(
    std::move(listener)
    );
}
ClipboardHostAsyncWaiter::ClipboardHostAsyncWaiter(
    ClipboardHost* proxy) : proxy_(proxy) {}

ClipboardHostAsyncWaiter::~ClipboardHostAsyncWaiter() = default;


void ClipboardHostAsyncWaiter::GetSequenceNumber(
    ClipboardBuffer buffer, ::blink::ClipboardSequenceNumberToken* out_result) {
  base::RunLoop loop;
  proxy_->GetSequenceNumber(
      std::move(buffer),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::ClipboardSequenceNumberToken* out_result
,
             const ::blink::ClipboardSequenceNumberToken& result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

::blink::ClipboardSequenceNumberToken ClipboardHostAsyncWaiter::GetSequenceNumber(
    ClipboardBuffer buffer) {
  ::blink::ClipboardSequenceNumberToken async_wait_result;
  GetSequenceNumber(std::move(buffer),&async_wait_result);
  return async_wait_result;
}

void ClipboardHostAsyncWaiter::IsFormatAvailable(
    ClipboardFormat format, ClipboardBuffer buffer, bool* out_result) {
  base::RunLoop loop;
  proxy_->IsFormatAvailable(
      std::move(format),
      std::move(buffer),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_result
,
             bool result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

bool ClipboardHostAsyncWaiter::IsFormatAvailable(
    ClipboardFormat format, ClipboardBuffer buffer) {
  bool async_wait_result;
  IsFormatAvailable(std::move(format),std::move(buffer),&async_wait_result);
  return async_wait_result;
}

void ClipboardHostAsyncWaiter::ReadAvailableTypes(
    ClipboardBuffer buffer, ::blink::Vector<::blink::String>* out_types) {
  base::RunLoop loop;
  proxy_->ReadAvailableTypes(
      std::move(buffer),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::Vector<::blink::String>* out_types
,
             const ::blink::Vector<::blink::String>& types) {*out_types = std::move(types);
            loop->Quit();
          },
          &loop,
          out_types));
  loop.Run();
}

::blink::Vector<::blink::String> ClipboardHostAsyncWaiter::ReadAvailableTypes(
    ClipboardBuffer buffer) {
  ::blink::Vector<::blink::String> async_wait_result;
  ReadAvailableTypes(std::move(buffer),&async_wait_result);
  return async_wait_result;
}

void ClipboardHostAsyncWaiter::ReadText(
    ClipboardBuffer buffer, ::blink::String* out_result) {
  base::RunLoop loop;
  proxy_->ReadText(
      std::move(buffer),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::String* out_result
,
             const ::blink::String& result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

::blink::String ClipboardHostAsyncWaiter::ReadText(
    ClipboardBuffer buffer) {
  ::blink::String async_wait_result;
  ReadText(std::move(buffer),&async_wait_result);
  return async_wait_result;
}

void ClipboardHostAsyncWaiter::ReadHtml(
    ClipboardBuffer buffer, ::blink::String* out_markup, ::blink::KURL* out_url, uint32_t* out_fragment_start, uint32_t* out_fragment_end) {
  base::RunLoop loop;
  proxy_->ReadHtml(
      std::move(buffer),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::String* out_markup
,
             ::blink::KURL* out_url
,
             uint32_t* out_fragment_start
,
             uint32_t* out_fragment_end
,
             const ::blink::String& markup,
             const ::blink::KURL& url,
             uint32_t fragment_start,
             uint32_t fragment_end) {*out_markup = std::move(markup);*out_url = std::move(url);*out_fragment_start = std::move(fragment_start);*out_fragment_end = std::move(fragment_end);
            loop->Quit();
          },
          &loop,
          out_markup,
          out_url,
          out_fragment_start,
          out_fragment_end));
  loop.Run();
}



void ClipboardHostAsyncWaiter::ReadSvg(
    ClipboardBuffer buffer, ::blink::String* out_result) {
  base::RunLoop loop;
  proxy_->ReadSvg(
      std::move(buffer),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::String* out_result
,
             const ::blink::String& result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

::blink::String ClipboardHostAsyncWaiter::ReadSvg(
    ClipboardBuffer buffer) {
  ::blink::String async_wait_result;
  ReadSvg(std::move(buffer),&async_wait_result);
  return async_wait_result;
}

void ClipboardHostAsyncWaiter::ReadRtf(
    ClipboardBuffer buffer, ::blink::String* out_result) {
  base::RunLoop loop;
  proxy_->ReadRtf(
      std::move(buffer),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::String* out_result
,
             const ::blink::String& result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

::blink::String ClipboardHostAsyncWaiter::ReadRtf(
    ClipboardBuffer buffer) {
  ::blink::String async_wait_result;
  ReadRtf(std::move(buffer),&async_wait_result);
  return async_wait_result;
}

void ClipboardHostAsyncWaiter::ReadPng(
    ClipboardBuffer buffer, ::mojo_base::BigBuffer* out_png) {
  base::RunLoop loop;
  proxy_->ReadPng(
      std::move(buffer),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::mojo_base::BigBuffer* out_png
,
             ::mojo_base::BigBuffer png) {*out_png = std::move(png);
            loop->Quit();
          },
          &loop,
          out_png));
  loop.Run();
}

::mojo_base::BigBuffer ClipboardHostAsyncWaiter::ReadPng(
    ClipboardBuffer buffer) {
  ::mojo_base::BigBuffer async_wait_result;
  ReadPng(std::move(buffer),&async_wait_result);
  return async_wait_result;
}

void ClipboardHostAsyncWaiter::ReadFiles(
    ClipboardBuffer buffer, ClipboardFilesPtr* out_result) {
  base::RunLoop loop;
  proxy_->ReadFiles(
      std::move(buffer),
      base::BindOnce(
          [](base::RunLoop* loop,
             ClipboardFilesPtr* out_result
,
             ClipboardFilesPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

ClipboardFilesPtr ClipboardHostAsyncWaiter::ReadFiles(
    ClipboardBuffer buffer) {
  ClipboardFilesPtr async_wait_result;
  ReadFiles(std::move(buffer),&async_wait_result);
  return async_wait_result;
}

void ClipboardHostAsyncWaiter::ReadDataTransferCustomData(
    ClipboardBuffer buffer, const ::blink::String& type, ::blink::String* out_result) {
  base::RunLoop loop;
  proxy_->ReadDataTransferCustomData(
      std::move(buffer),
      std::move(type),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::String* out_result
,
             const ::blink::String& result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

::blink::String ClipboardHostAsyncWaiter::ReadDataTransferCustomData(
    ClipboardBuffer buffer, const ::blink::String& type) {
  ::blink::String async_wait_result;
  ReadDataTransferCustomData(std::move(buffer),std::move(type),&async_wait_result);
  return async_wait_result;
}

void ClipboardHostAsyncWaiter::ReadAvailableCustomAndStandardFormats(
    ::blink::Vector<::blink::String>* out_format_types) {
  base::RunLoop loop;
  proxy_->ReadAvailableCustomAndStandardFormats(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::Vector<::blink::String>* out_format_types
,
             const ::blink::Vector<::blink::String>& format_types) {*out_format_types = std::move(format_types);
            loop->Quit();
          },
          &loop,
          out_format_types));
  loop.Run();
}

::blink::Vector<::blink::String> ClipboardHostAsyncWaiter::ReadAvailableCustomAndStandardFormats(
    ) {
  ::blink::Vector<::blink::String> async_wait_result;
  ReadAvailableCustomAndStandardFormats(&async_wait_result);
  return async_wait_result;
}

void ClipboardHostAsyncWaiter::ReadUnsanitizedCustomFormat(
    const ::blink::String& format, ::mojo_base::BigBuffer* out_data) {
  base::RunLoop loop;
  proxy_->ReadUnsanitizedCustomFormat(
      std::move(format),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::mojo_base::BigBuffer* out_data
,
             ::mojo_base::BigBuffer data) {*out_data = std::move(data);
            loop->Quit();
          },
          &loop,
          out_data));
  loop.Run();
}

::mojo_base::BigBuffer ClipboardHostAsyncWaiter::ReadUnsanitizedCustomFormat(
    const ::blink::String& format) {
  ::mojo_base::BigBuffer async_wait_result;
  ReadUnsanitizedCustomFormat(std::move(format),&async_wait_result);
  return async_wait_result;
}

void ClipboardHostAsyncWaiter::EndCopyWithCompletion(
    int32_t token, int32_t* out_token) {
  base::RunLoop loop;
  proxy_->EndCopyWithCompletion(
      std::move(token),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_token
,
             int32_t token) {*out_token = std::move(token);
            loop->Quit();
          },
          &loop,
          out_token));
  loop.Run();
}

int32_t ClipboardHostAsyncWaiter::EndCopyWithCompletion(
    int32_t token) {
  int32_t async_wait_result;
  EndCopyWithCompletion(std::move(token),&async_wait_result);
  return async_wait_result;
}

void ClipboardHostAsyncWaiter::EndPasteWithCompletion(
    int32_t token, int32_t* out_token) {
  base::RunLoop loop;
  proxy_->EndPasteWithCompletion(
      std::move(token),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_token
,
             int32_t token) {*out_token = std::move(token);
            loop->Quit();
          },
          &loop,
          out_token));
  loop.Run();
}

int32_t ClipboardHostAsyncWaiter::EndPasteWithCompletion(
    int32_t token) {
  int32_t async_wait_result;
  EndPasteWithCompletion(std::move(token),&async_wait_result);
  return async_wait_result;
}

void ClipboardHostAsyncWaiter::GetPlatformPermissionState(
    PlatformClipboardPermissionState* out_state) {
  base::RunLoop loop;
  proxy_->GetPlatformPermissionState(
      base::BindOnce(
          [](base::RunLoop* loop,
             PlatformClipboardPermissionState* out_state
,
             PlatformClipboardPermissionState state) {*out_state = std::move(state);
            loop->Quit();
          },
          &loop,
          out_state));
  loop.Run();
}

PlatformClipboardPermissionState ClipboardHostAsyncWaiter::GetPlatformPermissionState(
    ) {
  PlatformClipboardPermissionState async_wait_result;
  GetPlatformPermissionState(&async_wait_result);
  return async_wait_result;
}






}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif