// third_party/blink/public/mojom/buckets/bucket_manager_host.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/buckets/bucket_manager_host.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/buckets/bucket_manager_host.mojom-params-data.h"
#include "third_party/blink/public/mojom/buckets/bucket_manager_host.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/buckets/bucket_manager_host.mojom-import-headers.h"
#include "third_party/blink/public/mojom/buckets/bucket_manager_host.mojom-test-utils.h"


namespace blink::mojom {
BucketPolicies::BucketPolicies()
    : persisted(),
      has_persisted(false),
      durability(),
      has_durability(false),
      quota(),
      has_quota(false),
      expires() {}

BucketPolicies::BucketPolicies(
    bool persisted_in,
    bool has_persisted_in,
    ::blink::mojom::BucketDurability durability_in,
    bool has_durability_in,
    int64_t quota_in,
    bool has_quota_in,
    std::optional<::base::Time> expires_in)
    : persisted(std::move(persisted_in)),
      has_persisted(std::move(has_persisted_in)),
      durability(std::move(durability_in)),
      has_durability(std::move(has_durability_in)),
      quota(std::move(quota_in)),
      has_quota(std::move(has_quota_in)),
      expires(std::move(expires_in)) {}

BucketPolicies::~BucketPolicies() = default;

void BucketPolicies::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "persisted"), this->persisted,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_persisted"), this->has_persisted,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "durability"), this->durability,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::BucketDurability>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_durability"), this->has_durability,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "quota"), this->quota,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_quota"), this->has_quota,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "expires"), this->expires,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::Time>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BucketPolicies::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

BucketHost::IPCStableHashFunction BucketHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::BucketHost>(message.name())) {
    case messages::BucketHost::kPersist: {
      return &BucketHost::Persist_Sym::IPCStableHash;
    }
    case messages::BucketHost::kPersisted: {
      return &BucketHost::Persisted_Sym::IPCStableHash;
    }
    case messages::BucketHost::kEstimate: {
      return &BucketHost::Estimate_Sym::IPCStableHash;
    }
    case messages::BucketHost::kDurability: {
      return &BucketHost::Durability_Sym::IPCStableHash;
    }
    case messages::BucketHost::kSetExpires: {
      return &BucketHost::SetExpires_Sym::IPCStableHash;
    }
    case messages::BucketHost::kExpires: {
      return &BucketHost::Expires_Sym::IPCStableHash;
    }
    case messages::BucketHost::kGetIdbFactory: {
      return &BucketHost::GetIdbFactory_Sym::IPCStableHash;
    }
    case messages::BucketHost::kGetLockManager: {
      return &BucketHost::GetLockManager_Sym::IPCStableHash;
    }
    case messages::BucketHost::kGetCaches: {
      return &BucketHost::GetCaches_Sym::IPCStableHash;
    }
    case messages::BucketHost::kGetDirectory: {
      return &BucketHost::GetDirectory_Sym::IPCStableHash;
    }
    case messages::BucketHost::kGetDirectoryForDevtools: {
      return &BucketHost::GetDirectoryForDevtools_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* BucketHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::BucketHost>(message.name())) {
      case messages::BucketHost::kPersist:
            return "Receive blink::mojom::BucketHost::Persist";
      case messages::BucketHost::kPersisted:
            return "Receive blink::mojom::BucketHost::Persisted";
      case messages::BucketHost::kEstimate:
            return "Receive blink::mojom::BucketHost::Estimate";
      case messages::BucketHost::kDurability:
            return "Receive blink::mojom::BucketHost::Durability";
      case messages::BucketHost::kSetExpires:
            return "Receive blink::mojom::BucketHost::SetExpires";
      case messages::BucketHost::kExpires:
            return "Receive blink::mojom::BucketHost::Expires";
      case messages::BucketHost::kGetIdbFactory:
            return "Receive blink::mojom::BucketHost::GetIdbFactory";
      case messages::BucketHost::kGetLockManager:
            return "Receive blink::mojom::BucketHost::GetLockManager";
      case messages::BucketHost::kGetCaches:
            return "Receive blink::mojom::BucketHost::GetCaches";
      case messages::BucketHost::kGetDirectory:
            return "Receive blink::mojom::BucketHost::GetDirectory";
      case messages::BucketHost::kGetDirectoryForDevtools:
            return "Receive blink::mojom::BucketHost::GetDirectoryForDevtools";
    }
  } else {
    switch (static_cast<messages::BucketHost>(message.name())) {
      case messages::BucketHost::kPersist:
            return "Receive reply blink::mojom::BucketHost::Persist";
      case messages::BucketHost::kPersisted:
            return "Receive reply blink::mojom::BucketHost::Persisted";
      case messages::BucketHost::kEstimate:
            return "Receive reply blink::mojom::BucketHost::Estimate";
      case messages::BucketHost::kDurability:
            return "Receive reply blink::mojom::BucketHost::Durability";
      case messages::BucketHost::kSetExpires:
            return "Receive reply blink::mojom::BucketHost::SetExpires";
      case messages::BucketHost::kExpires:
            return "Receive reply blink::mojom::BucketHost::Expires";
      case messages::BucketHost::kGetIdbFactory:
            return "Receive reply blink::mojom::BucketHost::GetIdbFactory";
      case messages::BucketHost::kGetLockManager:
            return "Receive reply blink::mojom::BucketHost::GetLockManager";
      case messages::BucketHost::kGetCaches:
            return "Receive reply blink::mojom::BucketHost::GetCaches";
      case messages::BucketHost::kGetDirectory:
            return "Receive reply blink::mojom::BucketHost::GetDirectory";
      case messages::BucketHost::kGetDirectoryForDevtools:
            return "Receive reply blink::mojom::BucketHost::GetDirectoryForDevtools";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t BucketHost::Persist_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x40a52227;  // IPCStableHash for blink::mojom::BucketHost::Persist
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BucketHost::Persisted_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xedfabd62;  // IPCStableHash for blink::mojom::BucketHost::Persisted
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BucketHost::Estimate_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb2f30ef3;  // IPCStableHash for blink::mojom::BucketHost::Estimate
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BucketHost::Durability_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7777560a;  // IPCStableHash for blink::mojom::BucketHost::Durability
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BucketHost::SetExpires_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x414155e6;  // IPCStableHash for blink::mojom::BucketHost::SetExpires
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BucketHost::Expires_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc3e425a3;  // IPCStableHash for blink::mojom::BucketHost::Expires
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BucketHost::GetIdbFactory_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x31c16804;  // IPCStableHash for blink::mojom::BucketHost::GetIdbFactory
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BucketHost::GetLockManager_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x49b4acc2;  // IPCStableHash for blink::mojom::BucketHost::GetLockManager
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BucketHost::GetCaches_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xba8c3218;  // IPCStableHash for blink::mojom::BucketHost::GetCaches
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BucketHost::GetDirectory_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf9ad108c;  // IPCStableHash for blink::mojom::BucketHost::GetDirectory
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BucketHost::GetDirectoryForDevtools_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xedeb2b14;  // IPCStableHash for blink::mojom::BucketHost::GetDirectoryForDevtools
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class BucketHost_Persist_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BucketHost_Persist_ForwardToCallback(
      BucketHost::PersistCallback callback
      ) : callback_(std::move(callback)) {
  }

  BucketHost_Persist_ForwardToCallback(const BucketHost_Persist_ForwardToCallback&) = delete;
  BucketHost_Persist_ForwardToCallback& operator=(const BucketHost_Persist_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  BucketHost::PersistCallback callback_;
};

class BucketHost_Persisted_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BucketHost_Persisted_ForwardToCallback(
      BucketHost::PersistedCallback callback
      ) : callback_(std::move(callback)) {
  }

  BucketHost_Persisted_ForwardToCallback(const BucketHost_Persisted_ForwardToCallback&) = delete;
  BucketHost_Persisted_ForwardToCallback& operator=(const BucketHost_Persisted_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  BucketHost::PersistedCallback callback_;
};

class BucketHost_Estimate_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BucketHost_Estimate_ForwardToCallback(
      BucketHost::EstimateCallback callback
      ) : callback_(std::move(callback)) {
  }

  BucketHost_Estimate_ForwardToCallback(const BucketHost_Estimate_ForwardToCallback&) = delete;
  BucketHost_Estimate_ForwardToCallback& operator=(const BucketHost_Estimate_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  BucketHost::EstimateCallback callback_;
};

class BucketHost_Durability_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BucketHost_Durability_ForwardToCallback(
      BucketHost::DurabilityCallback callback
      ) : callback_(std::move(callback)) {
  }

  BucketHost_Durability_ForwardToCallback(const BucketHost_Durability_ForwardToCallback&) = delete;
  BucketHost_Durability_ForwardToCallback& operator=(const BucketHost_Durability_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  BucketHost::DurabilityCallback callback_;
};

class BucketHost_SetExpires_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BucketHost_SetExpires_ForwardToCallback(
      BucketHost::SetExpiresCallback callback
      ) : callback_(std::move(callback)) {
  }

  BucketHost_SetExpires_ForwardToCallback(const BucketHost_SetExpires_ForwardToCallback&) = delete;
  BucketHost_SetExpires_ForwardToCallback& operator=(const BucketHost_SetExpires_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  BucketHost::SetExpiresCallback callback_;
};

class BucketHost_Expires_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BucketHost_Expires_ForwardToCallback(
      BucketHost::ExpiresCallback callback
      ) : callback_(std::move(callback)) {
  }

  BucketHost_Expires_ForwardToCallback(const BucketHost_Expires_ForwardToCallback&) = delete;
  BucketHost_Expires_ForwardToCallback& operator=(const BucketHost_Expires_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  BucketHost::ExpiresCallback callback_;
};

class BucketHost_GetDirectory_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BucketHost_GetDirectory_ForwardToCallback(
      BucketHost::GetDirectoryCallback callback
      ) : callback_(std::move(callback)) {
  }

  BucketHost_GetDirectory_ForwardToCallback(const BucketHost_GetDirectory_ForwardToCallback&) = delete;
  BucketHost_GetDirectory_ForwardToCallback& operator=(const BucketHost_GetDirectory_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  BucketHost::GetDirectoryCallback callback_;
};

class BucketHost_GetDirectoryForDevtools_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BucketHost_GetDirectoryForDevtools_ForwardToCallback(
      BucketHost::GetDirectoryForDevtoolsCallback callback
      ) : callback_(std::move(callback)) {
  }

  BucketHost_GetDirectoryForDevtools_ForwardToCallback(const BucketHost_GetDirectoryForDevtools_ForwardToCallback&) = delete;
  BucketHost_GetDirectoryForDevtools_ForwardToCallback& operator=(const BucketHost_GetDirectoryForDevtools_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  BucketHost::GetDirectoryForDevtoolsCallback callback_;
};

BucketHostProxy::BucketHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BucketHostProxy::Persist(
    PersistCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::BucketHost::Persist");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BucketHost::kPersist), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BucketHost_Persist_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BucketHost::Name_);
  message.set_method_name("Persist");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BucketHost_Persist_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void BucketHostProxy::Persisted(
    PersistedCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::BucketHost::Persisted");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BucketHost::kPersisted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BucketHost_Persisted_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BucketHost::Name_);
  message.set_method_name("Persisted");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BucketHost_Persisted_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void BucketHostProxy::Estimate(
    EstimateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::BucketHost::Estimate");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BucketHost::kEstimate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BucketHost_Estimate_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BucketHost::Name_);
  message.set_method_name("Estimate");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BucketHost_Estimate_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void BucketHostProxy::Durability(
    DurabilityCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::BucketHost::Durability");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BucketHost::kDurability), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BucketHost_Durability_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BucketHost::Name_);
  message.set_method_name("Durability");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BucketHost_Durability_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void BucketHostProxy::SetExpires(
    ::base::Time in_expires, SetExpiresCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::BucketHost::SetExpires", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("expires"), in_expires,
                        "<value of type ::base::Time>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BucketHost::kSetExpires), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BucketHost_SetExpires_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->expires)::BaseType> expires_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
    in_expires,
    expires_fragment);

  params->expires.Set(
      expires_fragment.is_null() ? nullptr : expires_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->expires.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null expires in BucketHost.SetExpires request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BucketHost::Name_);
  message.set_method_name("SetExpires");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BucketHost_SetExpires_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void BucketHostProxy::Expires(
    ExpiresCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::BucketHost::Expires");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BucketHost::kExpires), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BucketHost_Expires_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BucketHost::Name_);
  message.set_method_name("Expires");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BucketHost_Expires_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void BucketHostProxy::GetIdbFactory(
    ::mojo::PendingReceiver<::blink::mojom::IDBFactory> in_idb_factory) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::BucketHost::GetIdbFactory", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("idb_factory"), in_idb_factory,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::IDBFactory>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BucketHost::kGetIdbFactory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BucketHost_GetIdbFactory_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::IDBFactoryInterfaceBase>>(
    in_idb_factory,
    &params->idb_factory,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->idb_factory)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid idb_factory in BucketHost.GetIdbFactory request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BucketHost::Name_);
  message.set_method_name("GetIdbFactory");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void BucketHostProxy::GetLockManager(
    ::mojo::PendingReceiver<::blink::mojom::LockManager> in_lock_manager) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::BucketHost::GetLockManager", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("lock_manager"), in_lock_manager,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::LockManager>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BucketHost::kGetLockManager), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BucketHost_GetLockManager_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::LockManagerInterfaceBase>>(
    in_lock_manager,
    &params->lock_manager,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->lock_manager)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid lock_manager in BucketHost.GetLockManager request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BucketHost::Name_);
  message.set_method_name("GetLockManager");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void BucketHostProxy::GetCaches(
    ::mojo::PendingReceiver<::blink::mojom::CacheStorage> in_cache_storage) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::BucketHost::GetCaches", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cache_storage"), in_cache_storage,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::CacheStorage>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BucketHost::kGetCaches), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BucketHost_GetCaches_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::CacheStorageInterfaceBase>>(
    in_cache_storage,
    &params->cache_storage,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->cache_storage)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid cache_storage in BucketHost.GetCaches request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BucketHost::Name_);
  message.set_method_name("GetCaches");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void BucketHostProxy::GetDirectory(
    GetDirectoryCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::BucketHost::GetDirectory");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BucketHost::kGetDirectory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BucketHost_GetDirectory_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BucketHost::Name_);
  message.set_method_name("GetDirectory");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BucketHost_GetDirectory_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void BucketHostProxy::GetDirectoryForDevtools(
    const std::vector<std::string>& in_directory_path_components, GetDirectoryForDevtoolsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::BucketHost::GetDirectoryForDevtools", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("directory_path_components"), in_directory_path_components,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BucketHost::kGetDirectoryForDevtools), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BucketHost_GetDirectoryForDevtools_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->directory_path_components)::BaseType>
      directory_path_components_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& directory_path_components_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_directory_path_components,
    directory_path_components_fragment,
    &directory_path_components_validate_params);

  params->directory_path_components.Set(
      directory_path_components_fragment.is_null() ? nullptr : directory_path_components_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->directory_path_components.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null directory_path_components in BucketHost.GetDirectoryForDevtools request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BucketHost::Name_);
  message.set_method_name("GetDirectoryForDevtools");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BucketHost_GetDirectoryForDevtools_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class BucketHost_Persist_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static BucketHost::PersistCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<BucketHost_Persist_ProxyToResponder> proxy(
        new BucketHost_Persist_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&BucketHost_Persist_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BucketHost_Persist_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  BucketHost_Persist_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "BucketHost::PersistCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_persisted, bool in_success);
};

bool BucketHost_Persist_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::BucketHost_Persist_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BucketHost_Persist_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for BucketHost.0
  bool success = true;
  bool p_persisted{};
  bool p_success{};
  BucketHost_Persist_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_persisted = input_data_view.persisted();
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BucketHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_persisted), 
std::move(p_success));
  }
  return true;
}

void BucketHost_Persist_ProxyToResponder::Run(
    bool in_persisted, bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::BucketHost::Persist", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("persisted"), in_persisted,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BucketHost::kPersist), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BucketHost_Persist_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->persisted = in_persisted;

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BucketHost::Name_);
  message.set_method_name("Persist");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class BucketHost_Persisted_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static BucketHost::PersistedCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<BucketHost_Persisted_ProxyToResponder> proxy(
        new BucketHost_Persisted_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&BucketHost_Persisted_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BucketHost_Persisted_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  BucketHost_Persisted_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "BucketHost::PersistedCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_persisted, bool in_success);
};

bool BucketHost_Persisted_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::BucketHost_Persisted_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BucketHost_Persisted_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for BucketHost.1
  bool success = true;
  bool p_persisted{};
  bool p_success{};
  BucketHost_Persisted_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_persisted = input_data_view.persisted();
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BucketHost::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_persisted), 
std::move(p_success));
  }
  return true;
}

void BucketHost_Persisted_ProxyToResponder::Run(
    bool in_persisted, bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::BucketHost::Persisted", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("persisted"), in_persisted,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BucketHost::kPersisted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BucketHost_Persisted_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->persisted = in_persisted;

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BucketHost::Name_);
  message.set_method_name("Persisted");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class BucketHost_Estimate_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static BucketHost::EstimateCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<BucketHost_Estimate_ProxyToResponder> proxy(
        new BucketHost_Estimate_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&BucketHost_Estimate_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BucketHost_Estimate_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  BucketHost_Estimate_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "BucketHost::EstimateCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      int64_t in_current_usage, int64_t in_current_quota, bool in_success);
};

bool BucketHost_Estimate_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::BucketHost_Estimate_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BucketHost_Estimate_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for BucketHost.2
  bool success = true;
  int64_t p_current_usage{};
  int64_t p_current_quota{};
  bool p_success{};
  BucketHost_Estimate_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_current_usage = input_data_view.current_usage();
  if (success)
    p_current_quota = input_data_view.current_quota();
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BucketHost::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_current_usage), 
std::move(p_current_quota), 
std::move(p_success));
  }
  return true;
}

void BucketHost_Estimate_ProxyToResponder::Run(
    int64_t in_current_usage, int64_t in_current_quota, bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::BucketHost::Estimate", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("current_usage"), in_current_usage,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("current_quota"), in_current_quota,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BucketHost::kEstimate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BucketHost_Estimate_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->current_usage = in_current_usage;

  params->current_quota = in_current_quota;

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BucketHost::Name_);
  message.set_method_name("Estimate");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class BucketHost_Durability_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static BucketHost::DurabilityCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<BucketHost_Durability_ProxyToResponder> proxy(
        new BucketHost_Durability_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&BucketHost_Durability_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BucketHost_Durability_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  BucketHost_Durability_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "BucketHost::DurabilityCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::BucketDurability in_durability, bool in_success);
};

bool BucketHost_Durability_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::BucketHost_Durability_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BucketHost_Durability_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for BucketHost.3
  bool success = true;
  ::blink::mojom::BucketDurability p_durability{};
  bool p_success{};
  BucketHost_Durability_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDurability(&p_durability))
    success = false;
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BucketHost::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_durability), 
std::move(p_success));
  }
  return true;
}

void BucketHost_Durability_ProxyToResponder::Run(
    ::blink::mojom::BucketDurability in_durability, bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::BucketHost::Durability", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("durability"), in_durability,
                        "<value of type ::blink::mojom::BucketDurability>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BucketHost::kDurability), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BucketHost_Durability_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::BucketDurability>(
    in_durability,
    &params->durability);

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BucketHost::Name_);
  message.set_method_name("Durability");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class BucketHost_SetExpires_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static BucketHost::SetExpiresCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<BucketHost_SetExpires_ProxyToResponder> proxy(
        new BucketHost_SetExpires_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&BucketHost_SetExpires_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BucketHost_SetExpires_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  BucketHost_SetExpires_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "BucketHost::SetExpiresCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool BucketHost_SetExpires_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::BucketHost_SetExpires_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BucketHost_SetExpires_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for BucketHost.4
  bool success = true;
  bool p_success{};
  BucketHost_SetExpires_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BucketHost::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void BucketHost_SetExpires_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::BucketHost::SetExpires", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BucketHost::kSetExpires), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BucketHost_SetExpires_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BucketHost::Name_);
  message.set_method_name("SetExpires");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class BucketHost_Expires_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static BucketHost::ExpiresCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<BucketHost_Expires_ProxyToResponder> proxy(
        new BucketHost_Expires_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&BucketHost_Expires_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BucketHost_Expires_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  BucketHost_Expires_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "BucketHost::ExpiresCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::optional<::base::Time> in_expires, bool in_success);
};

bool BucketHost_Expires_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::BucketHost_Expires_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BucketHost_Expires_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for BucketHost.5
  bool success = true;
  std::optional<::base::Time> p_expires{};
  bool p_success{};
  BucketHost_Expires_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadExpires(&p_expires))
    success = false;
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BucketHost::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_expires), 
std::move(p_success));
  }
  return true;
}

void BucketHost_Expires_ProxyToResponder::Run(
    std::optional<::base::Time> in_expires, bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::BucketHost::Expires", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("expires"), in_expires,
                        "<value of type std::optional<::base::Time>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BucketHost::kExpires), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BucketHost_Expires_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->expires)::BaseType> expires_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
    in_expires,
    expires_fragment);

  params->expires.Set(
      expires_fragment.is_null() ? nullptr : expires_fragment.data());

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BucketHost::Name_);
  message.set_method_name("Expires");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class BucketHost_GetDirectory_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static BucketHost::GetDirectoryCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<BucketHost_GetDirectory_ProxyToResponder> proxy(
        new BucketHost_GetDirectory_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&BucketHost_GetDirectory_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BucketHost_GetDirectory_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  BucketHost_GetDirectory_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "BucketHost::GetDirectoryCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::FileSystemAccessErrorPtr in_result, ::mojo::PendingRemote<::blink::mojom::FileSystemAccessDirectoryHandle> in_directory);
};

bool BucketHost_GetDirectory_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::BucketHost_GetDirectory_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BucketHost_GetDirectory_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for BucketHost.9
  bool success = true;
  ::blink::mojom::FileSystemAccessErrorPtr p_result{};
  ::mojo::PendingRemote<::blink::mojom::FileSystemAccessDirectoryHandle> p_directory{};
  BucketHost_GetDirectory_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success) {
    p_directory =
        input_data_view.TakeDirectory<decltype(p_directory)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BucketHost::Name_, 9, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_directory));
  }
  return true;
}

void BucketHost_GetDirectory_ProxyToResponder::Run(
    ::blink::mojom::FileSystemAccessErrorPtr in_result, ::mojo::PendingRemote<::blink::mojom::FileSystemAccessDirectoryHandle> in_directory) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::BucketHost::GetDirectory", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::blink::mojom::FileSystemAccessErrorPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("directory"), in_directory,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::FileSystemAccessDirectoryHandle>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BucketHost::kGetDirectory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BucketHost_GetDirectory_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessErrorDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessDirectoryHandleInterfaceBase>>(
    in_directory,
    &params->directory,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BucketHost::Name_);
  message.set_method_name("GetDirectory");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class BucketHost_GetDirectoryForDevtools_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static BucketHost::GetDirectoryForDevtoolsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<BucketHost_GetDirectoryForDevtools_ProxyToResponder> proxy(
        new BucketHost_GetDirectoryForDevtools_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&BucketHost_GetDirectoryForDevtools_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BucketHost_GetDirectoryForDevtools_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  BucketHost_GetDirectoryForDevtools_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "BucketHost::GetDirectoryForDevtoolsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::FileSystemAccessErrorPtr in_result, ::mojo::PendingRemote<::blink::mojom::FileSystemAccessDirectoryHandle> in_directory);
};

bool BucketHost_GetDirectoryForDevtools_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::BucketHost_GetDirectoryForDevtools_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BucketHost_GetDirectoryForDevtools_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for BucketHost.10
  bool success = true;
  ::blink::mojom::FileSystemAccessErrorPtr p_result{};
  ::mojo::PendingRemote<::blink::mojom::FileSystemAccessDirectoryHandle> p_directory{};
  BucketHost_GetDirectoryForDevtools_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success) {
    p_directory =
        input_data_view.TakeDirectory<decltype(p_directory)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BucketHost::Name_, 10, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_directory));
  }
  return true;
}

void BucketHost_GetDirectoryForDevtools_ProxyToResponder::Run(
    ::blink::mojom::FileSystemAccessErrorPtr in_result, ::mojo::PendingRemote<::blink::mojom::FileSystemAccessDirectoryHandle> in_directory) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::BucketHost::GetDirectoryForDevtools", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::blink::mojom::FileSystemAccessErrorPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("directory"), in_directory,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::FileSystemAccessDirectoryHandle>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BucketHost::kGetDirectoryForDevtools), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BucketHost_GetDirectoryForDevtools_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessErrorDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessDirectoryHandleInterfaceBase>>(
    in_directory,
    &params->directory,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BucketHost::Name_);
  message.set_method_name("GetDirectoryForDevtools");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool BucketHostStubDispatch::Accept(
    BucketHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::BucketHost>(message->header()->name)) {
    case messages::BucketHost::kPersist: {
      break;
    }
    case messages::BucketHost::kPersisted: {
      break;
    }
    case messages::BucketHost::kEstimate: {
      break;
    }
    case messages::BucketHost::kDurability: {
      break;
    }
    case messages::BucketHost::kSetExpires: {
      break;
    }
    case messages::BucketHost::kExpires: {
      break;
    }
    case messages::BucketHost::kGetIdbFactory: {
      DCHECK(message->is_serialized());
      internal::BucketHost_GetIdbFactory_Params_Data* params =
          reinterpret_cast<internal::BucketHost_GetIdbFactory_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BucketHost.6
      bool success = true;
      ::mojo::PendingReceiver<::blink::mojom::IDBFactory> p_idb_factory{};
      BucketHost_GetIdbFactory_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_idb_factory =
            input_data_view.TakeIdbFactory<decltype(p_idb_factory)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BucketHost::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetIdbFactory(        
        std::move(p_idb_factory));
      return true;
    }
    case messages::BucketHost::kGetLockManager: {
      DCHECK(message->is_serialized());
      internal::BucketHost_GetLockManager_Params_Data* params =
          reinterpret_cast<internal::BucketHost_GetLockManager_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BucketHost.7
      bool success = true;
      ::mojo::PendingReceiver<::blink::mojom::LockManager> p_lock_manager{};
      BucketHost_GetLockManager_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_lock_manager =
            input_data_view.TakeLockManager<decltype(p_lock_manager)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BucketHost::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetLockManager(        
        std::move(p_lock_manager));
      return true;
    }
    case messages::BucketHost::kGetCaches: {
      DCHECK(message->is_serialized());
      internal::BucketHost_GetCaches_Params_Data* params =
          reinterpret_cast<internal::BucketHost_GetCaches_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BucketHost.8
      bool success = true;
      ::mojo::PendingReceiver<::blink::mojom::CacheStorage> p_cache_storage{};
      BucketHost_GetCaches_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_cache_storage =
            input_data_view.TakeCacheStorage<decltype(p_cache_storage)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BucketHost::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetCaches(        
        std::move(p_cache_storage));
      return true;
    }
    case messages::BucketHost::kGetDirectory: {
      break;
    }
    case messages::BucketHost::kGetDirectoryForDevtools: {
      break;
    }
  }
  return false;
}

// static
bool BucketHostStubDispatch::AcceptWithResponder(
    BucketHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::BucketHost>(message->header()->name)) {
    case messages::BucketHost::kPersist: {
      internal::BucketHost_Persist_Params_Data* params =
          reinterpret_cast<
              internal::BucketHost_Persist_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for BucketHost.0
      bool success = true;
      BucketHost_Persist_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BucketHost::Name_, 0, false);
        return false;
      }
      auto callback =
          BucketHost_Persist_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Persist(std::move(callback));
      return true;
    }
    case messages::BucketHost::kPersisted: {
      internal::BucketHost_Persisted_Params_Data* params =
          reinterpret_cast<
              internal::BucketHost_Persisted_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for BucketHost.1
      bool success = true;
      BucketHost_Persisted_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BucketHost::Name_, 1, false);
        return false;
      }
      auto callback =
          BucketHost_Persisted_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Persisted(std::move(callback));
      return true;
    }
    case messages::BucketHost::kEstimate: {
      internal::BucketHost_Estimate_Params_Data* params =
          reinterpret_cast<
              internal::BucketHost_Estimate_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for BucketHost.2
      bool success = true;
      BucketHost_Estimate_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BucketHost::Name_, 2, false);
        return false;
      }
      auto callback =
          BucketHost_Estimate_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Estimate(std::move(callback));
      return true;
    }
    case messages::BucketHost::kDurability: {
      internal::BucketHost_Durability_Params_Data* params =
          reinterpret_cast<
              internal::BucketHost_Durability_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for BucketHost.3
      bool success = true;
      BucketHost_Durability_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BucketHost::Name_, 3, false);
        return false;
      }
      auto callback =
          BucketHost_Durability_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Durability(std::move(callback));
      return true;
    }
    case messages::BucketHost::kSetExpires: {
      internal::BucketHost_SetExpires_Params_Data* params =
          reinterpret_cast<
              internal::BucketHost_SetExpires_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for BucketHost.4
      bool success = true;
      ::base::Time p_expires{};
      BucketHost_SetExpires_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExpires(&p_expires))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BucketHost::Name_, 4, false);
        return false;
      }
      auto callback =
          BucketHost_SetExpires_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetExpires(        
        std::move(p_expires), std::move(callback));
      return true;
    }
    case messages::BucketHost::kExpires: {
      internal::BucketHost_Expires_Params_Data* params =
          reinterpret_cast<
              internal::BucketHost_Expires_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for BucketHost.5
      bool success = true;
      BucketHost_Expires_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BucketHost::Name_, 5, false);
        return false;
      }
      auto callback =
          BucketHost_Expires_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Expires(std::move(callback));
      return true;
    }
    case messages::BucketHost::kGetIdbFactory: {
      break;
    }
    case messages::BucketHost::kGetLockManager: {
      break;
    }
    case messages::BucketHost::kGetCaches: {
      break;
    }
    case messages::BucketHost::kGetDirectory: {
      internal::BucketHost_GetDirectory_Params_Data* params =
          reinterpret_cast<
              internal::BucketHost_GetDirectory_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for BucketHost.9
      bool success = true;
      BucketHost_GetDirectory_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BucketHost::Name_, 9, false);
        return false;
      }
      auto callback =
          BucketHost_GetDirectory_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDirectory(std::move(callback));
      return true;
    }
    case messages::BucketHost::kGetDirectoryForDevtools: {
      internal::BucketHost_GetDirectoryForDevtools_Params_Data* params =
          reinterpret_cast<
              internal::BucketHost_GetDirectoryForDevtools_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for BucketHost.10
      bool success = true;
      std::vector<std::string> p_directory_path_components{};
      BucketHost_GetDirectoryForDevtools_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDirectoryPathComponents(&p_directory_path_components))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BucketHost::Name_, 10, false);
        return false;
      }
      auto callback =
          BucketHost_GetDirectoryForDevtools_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDirectoryForDevtools(        
        std::move(p_directory_path_components), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kBucketHostValidationInfo[] = {
    { &internal::BucketHost_Persist_Params_Data::Validate,
     &internal::BucketHost_Persist_ResponseParams_Data::Validate},
    { &internal::BucketHost_Persisted_Params_Data::Validate,
     &internal::BucketHost_Persisted_ResponseParams_Data::Validate},
    { &internal::BucketHost_Estimate_Params_Data::Validate,
     &internal::BucketHost_Estimate_ResponseParams_Data::Validate},
    { &internal::BucketHost_Durability_Params_Data::Validate,
     &internal::BucketHost_Durability_ResponseParams_Data::Validate},
    { &internal::BucketHost_SetExpires_Params_Data::Validate,
     &internal::BucketHost_SetExpires_ResponseParams_Data::Validate},
    { &internal::BucketHost_Expires_Params_Data::Validate,
     &internal::BucketHost_Expires_ResponseParams_Data::Validate},
    { &internal::BucketHost_GetIdbFactory_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::BucketHost_GetLockManager_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::BucketHost_GetCaches_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::BucketHost_GetDirectory_Params_Data::Validate,
     &internal::BucketHost_GetDirectory_ResponseParams_Data::Validate},
    { &internal::BucketHost_GetDirectoryForDevtools_Params_Data::Validate,
     &internal::BucketHost_GetDirectoryForDevtools_ResponseParams_Data::Validate},
};

bool BucketHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::BucketHost::Name_,
    kBucketHostValidationInfo);
}

bool BucketHostResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::BucketHost::Name_,
    kBucketHostValidationInfo);
}
// The declaration includes the definition on other builds.

BucketManagerHost::IPCStableHashFunction BucketManagerHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::BucketManagerHost>(message.name())) {
    case messages::BucketManagerHost::kOpenBucket: {
      return &BucketManagerHost::OpenBucket_Sym::IPCStableHash;
    }
    case messages::BucketManagerHost::kGetBucketForDevtools: {
      return &BucketManagerHost::GetBucketForDevtools_Sym::IPCStableHash;
    }
    case messages::BucketManagerHost::kKeys: {
      return &BucketManagerHost::Keys_Sym::IPCStableHash;
    }
    case messages::BucketManagerHost::kDeleteBucket: {
      return &BucketManagerHost::DeleteBucket_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* BucketManagerHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::BucketManagerHost>(message.name())) {
      case messages::BucketManagerHost::kOpenBucket:
            return "Receive blink::mojom::BucketManagerHost::OpenBucket";
      case messages::BucketManagerHost::kGetBucketForDevtools:
            return "Receive blink::mojom::BucketManagerHost::GetBucketForDevtools";
      case messages::BucketManagerHost::kKeys:
            return "Receive blink::mojom::BucketManagerHost::Keys";
      case messages::BucketManagerHost::kDeleteBucket:
            return "Receive blink::mojom::BucketManagerHost::DeleteBucket";
    }
  } else {
    switch (static_cast<messages::BucketManagerHost>(message.name())) {
      case messages::BucketManagerHost::kOpenBucket:
            return "Receive reply blink::mojom::BucketManagerHost::OpenBucket";
      case messages::BucketManagerHost::kGetBucketForDevtools:
            return "Receive reply blink::mojom::BucketManagerHost::GetBucketForDevtools";
      case messages::BucketManagerHost::kKeys:
            return "Receive reply blink::mojom::BucketManagerHost::Keys";
      case messages::BucketManagerHost::kDeleteBucket:
            return "Receive reply blink::mojom::BucketManagerHost::DeleteBucket";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t BucketManagerHost::OpenBucket_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x59a80cb5;  // IPCStableHash for blink::mojom::BucketManagerHost::OpenBucket
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BucketManagerHost::GetBucketForDevtools_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe609c637;  // IPCStableHash for blink::mojom::BucketManagerHost::GetBucketForDevtools
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BucketManagerHost::Keys_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb5f99e30;  // IPCStableHash for blink::mojom::BucketManagerHost::Keys
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BucketManagerHost::DeleteBucket_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9f10f7e8;  // IPCStableHash for blink::mojom::BucketManagerHost::DeleteBucket
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class BucketManagerHost_OpenBucket_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BucketManagerHost_OpenBucket_ForwardToCallback(
      BucketManagerHost::OpenBucketCallback callback
      ) : callback_(std::move(callback)) {
  }

  BucketManagerHost_OpenBucket_ForwardToCallback(const BucketManagerHost_OpenBucket_ForwardToCallback&) = delete;
  BucketManagerHost_OpenBucket_ForwardToCallback& operator=(const BucketManagerHost_OpenBucket_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  BucketManagerHost::OpenBucketCallback callback_;
};

class BucketManagerHost_Keys_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BucketManagerHost_Keys_ForwardToCallback(
      BucketManagerHost::KeysCallback callback
      ) : callback_(std::move(callback)) {
  }

  BucketManagerHost_Keys_ForwardToCallback(const BucketManagerHost_Keys_ForwardToCallback&) = delete;
  BucketManagerHost_Keys_ForwardToCallback& operator=(const BucketManagerHost_Keys_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  BucketManagerHost::KeysCallback callback_;
};

class BucketManagerHost_DeleteBucket_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BucketManagerHost_DeleteBucket_ForwardToCallback(
      BucketManagerHost::DeleteBucketCallback callback
      ) : callback_(std::move(callback)) {
  }

  BucketManagerHost_DeleteBucket_ForwardToCallback(const BucketManagerHost_DeleteBucket_ForwardToCallback&) = delete;
  BucketManagerHost_DeleteBucket_ForwardToCallback& operator=(const BucketManagerHost_DeleteBucket_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  BucketManagerHost::DeleteBucketCallback callback_;
};

BucketManagerHostProxy::BucketManagerHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BucketManagerHostProxy::OpenBucket(
    const std::string& in_name, BucketPoliciesPtr in_policy, OpenBucketCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::BucketManagerHost::OpenBucket", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("policy"), in_policy,
                        "<value of type BucketPoliciesPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BucketManagerHost::kOpenBucket), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BucketManagerHost_OpenBucket_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_name,
    name_fragment);

  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null name in BucketManagerHost.OpenBucket request");
  mojo::internal::MessageFragment<
      typename decltype(params->policy)::BaseType> policy_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::BucketPoliciesDataView>(
    in_policy,
    policy_fragment);

  params->policy.Set(
      policy_fragment.is_null() ? nullptr : policy_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->policy.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null policy in BucketManagerHost.OpenBucket request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BucketManagerHost::Name_);
  message.set_method_name("OpenBucket");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BucketManagerHost_OpenBucket_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void BucketManagerHostProxy::GetBucketForDevtools(
    const std::string& in_name, ::mojo::PendingReceiver<BucketHost> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::BucketManagerHost::GetBucketForDevtools", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<BucketHost>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BucketManagerHost::kGetBucketForDevtools), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BucketManagerHost_GetBucketForDevtools_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_name,
    name_fragment);

  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null name in BucketManagerHost.GetBucketForDevtools request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::BucketHostInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in BucketManagerHost.GetBucketForDevtools request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BucketManagerHost::Name_);
  message.set_method_name("GetBucketForDevtools");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void BucketManagerHostProxy::Keys(
    KeysCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::BucketManagerHost::Keys");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BucketManagerHost::kKeys), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BucketManagerHost_Keys_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BucketManagerHost::Name_);
  message.set_method_name("Keys");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BucketManagerHost_Keys_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void BucketManagerHostProxy::DeleteBucket(
    const std::string& in_name, DeleteBucketCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::BucketManagerHost::DeleteBucket", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BucketManagerHost::kDeleteBucket), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BucketManagerHost_DeleteBucket_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_name,
    name_fragment);

  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null name in BucketManagerHost.DeleteBucket request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BucketManagerHost::Name_);
  message.set_method_name("DeleteBucket");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BucketManagerHost_DeleteBucket_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class BucketManagerHost_OpenBucket_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static BucketManagerHost::OpenBucketCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<BucketManagerHost_OpenBucket_ProxyToResponder> proxy(
        new BucketManagerHost_OpenBucket_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&BucketManagerHost_OpenBucket_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BucketManagerHost_OpenBucket_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  BucketManagerHost_OpenBucket_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "BucketManagerHost::OpenBucketCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo::PendingRemote<BucketHost> in_remote, BucketError in_error);
};

bool BucketManagerHost_OpenBucket_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::BucketManagerHost_OpenBucket_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BucketManagerHost_OpenBucket_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for BucketManagerHost.0
  bool success = true;
  ::mojo::PendingRemote<BucketHost> p_remote{};
  BucketError p_error{};
  BucketManagerHost_OpenBucket_ResponseParamsDataView input_data_view(params, message);
  
  if (success) {
    p_remote =
        input_data_view.TakeRemote<decltype(p_remote)>();
  }
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BucketManagerHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_remote), 
std::move(p_error));
  }
  return true;
}

void BucketManagerHost_OpenBucket_ProxyToResponder::Run(
    ::mojo::PendingRemote<BucketHost> in_remote, BucketError in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::BucketManagerHost::OpenBucket", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("remote"), in_remote,
                        "<value of type ::mojo::PendingRemote<BucketHost>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type BucketError>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BucketManagerHost::kOpenBucket), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BucketManagerHost_OpenBucket_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BucketHostInterfaceBase>>(
    in_remote,
    &params->remote,
    &params.message());

  
  mojo::internal::Serialize<::blink::mojom::BucketError>(
    in_error,
    &params->error);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BucketManagerHost::Name_);
  message.set_method_name("OpenBucket");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class BucketManagerHost_Keys_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static BucketManagerHost::KeysCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<BucketManagerHost_Keys_ProxyToResponder> proxy(
        new BucketManagerHost_Keys_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&BucketManagerHost_Keys_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BucketManagerHost_Keys_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  BucketManagerHost_Keys_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "BucketManagerHost::KeysCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<std::string>& in_buckets, bool in_success);
};

bool BucketManagerHost_Keys_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::BucketManagerHost_Keys_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BucketManagerHost_Keys_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for BucketManagerHost.2
  bool success = true;
  std::vector<std::string> p_buckets{};
  bool p_success{};
  BucketManagerHost_Keys_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadBuckets(&p_buckets))
    success = false;
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BucketManagerHost::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_buckets), 
std::move(p_success));
  }
  return true;
}

void BucketManagerHost_Keys_ProxyToResponder::Run(
    const std::vector<std::string>& in_buckets, bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::BucketManagerHost::Keys", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buckets"), in_buckets,
                        "<value of type const std::vector<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BucketManagerHost::kKeys), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BucketManagerHost_Keys_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->buckets)::BaseType>
      buckets_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& buckets_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_buckets,
    buckets_fragment,
    &buckets_validate_params);

  params->buckets.Set(
      buckets_fragment.is_null() ? nullptr : buckets_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->buckets.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null buckets in ");

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BucketManagerHost::Name_);
  message.set_method_name("Keys");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class BucketManagerHost_DeleteBucket_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static BucketManagerHost::DeleteBucketCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<BucketManagerHost_DeleteBucket_ProxyToResponder> proxy(
        new BucketManagerHost_DeleteBucket_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&BucketManagerHost_DeleteBucket_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BucketManagerHost_DeleteBucket_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  BucketManagerHost_DeleteBucket_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "BucketManagerHost::DeleteBucketCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool BucketManagerHost_DeleteBucket_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::BucketManagerHost_DeleteBucket_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BucketManagerHost_DeleteBucket_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for BucketManagerHost.3
  bool success = true;
  bool p_success{};
  BucketManagerHost_DeleteBucket_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BucketManagerHost::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void BucketManagerHost_DeleteBucket_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::BucketManagerHost::DeleteBucket", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BucketManagerHost::kDeleteBucket), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BucketManagerHost_DeleteBucket_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BucketManagerHost::Name_);
  message.set_method_name("DeleteBucket");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool BucketManagerHostStubDispatch::Accept(
    BucketManagerHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::BucketManagerHost>(message->header()->name)) {
    case messages::BucketManagerHost::kOpenBucket: {
      break;
    }
    case messages::BucketManagerHost::kGetBucketForDevtools: {
      DCHECK(message->is_serialized());
      internal::BucketManagerHost_GetBucketForDevtools_Params_Data* params =
          reinterpret_cast<internal::BucketManagerHost_GetBucketForDevtools_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BucketManagerHost.1
      bool success = true;
      std::string p_name{};
      ::mojo::PendingReceiver<BucketHost> p_receiver{};
      BucketManagerHost_GetBucketForDevtools_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BucketManagerHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetBucketForDevtools(        
        std::move(p_name), 
        std::move(p_receiver));
      return true;
    }
    case messages::BucketManagerHost::kKeys: {
      break;
    }
    case messages::BucketManagerHost::kDeleteBucket: {
      break;
    }
  }
  return false;
}

// static
bool BucketManagerHostStubDispatch::AcceptWithResponder(
    BucketManagerHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::BucketManagerHost>(message->header()->name)) {
    case messages::BucketManagerHost::kOpenBucket: {
      internal::BucketManagerHost_OpenBucket_Params_Data* params =
          reinterpret_cast<
              internal::BucketManagerHost_OpenBucket_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for BucketManagerHost.0
      bool success = true;
      std::string p_name{};
      BucketPoliciesPtr p_policy{};
      BucketManagerHost_OpenBucket_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (success && !input_data_view.ReadPolicy(&p_policy))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BucketManagerHost::Name_, 0, false);
        return false;
      }
      auto callback =
          BucketManagerHost_OpenBucket_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenBucket(        
        std::move(p_name), 
        std::move(p_policy), std::move(callback));
      return true;
    }
    case messages::BucketManagerHost::kGetBucketForDevtools: {
      break;
    }
    case messages::BucketManagerHost::kKeys: {
      internal::BucketManagerHost_Keys_Params_Data* params =
          reinterpret_cast<
              internal::BucketManagerHost_Keys_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for BucketManagerHost.2
      bool success = true;
      BucketManagerHost_Keys_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BucketManagerHost::Name_, 2, false);
        return false;
      }
      auto callback =
          BucketManagerHost_Keys_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Keys(std::move(callback));
      return true;
    }
    case messages::BucketManagerHost::kDeleteBucket: {
      internal::BucketManagerHost_DeleteBucket_Params_Data* params =
          reinterpret_cast<
              internal::BucketManagerHost_DeleteBucket_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for BucketManagerHost.3
      bool success = true;
      std::string p_name{};
      BucketManagerHost_DeleteBucket_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BucketManagerHost::Name_, 3, false);
        return false;
      }
      auto callback =
          BucketManagerHost_DeleteBucket_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteBucket(        
        std::move(p_name), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kBucketManagerHostValidationInfo[] = {
    { &internal::BucketManagerHost_OpenBucket_Params_Data::Validate,
     &internal::BucketManagerHost_OpenBucket_ResponseParams_Data::Validate},
    { &internal::BucketManagerHost_GetBucketForDevtools_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::BucketManagerHost_Keys_Params_Data::Validate,
     &internal::BucketManagerHost_Keys_ResponseParams_Data::Validate},
    { &internal::BucketManagerHost_DeleteBucket_Params_Data::Validate,
     &internal::BucketManagerHost_DeleteBucket_ResponseParams_Data::Validate},
};

bool BucketManagerHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::BucketManagerHost::Name_,
    kBucketManagerHostValidationInfo);
}

bool BucketManagerHostResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::BucketManagerHost::Name_,
    kBucketManagerHostValidationInfo);
}


}  // blink::mojom


namespace mojo {


// static
bool StructTraits<::blink::mojom::BucketPolicies::DataView, ::blink::mojom::BucketPoliciesPtr>::Read(
    ::blink::mojom::BucketPolicies::DataView input,
    ::blink::mojom::BucketPoliciesPtr* output) {
  bool success = true;
  ::blink::mojom::BucketPoliciesPtr result(::blink::mojom::BucketPolicies::New());
  
      if (success)
        result->persisted = input.persisted();
      if (success)
        result->has_persisted = input.has_persisted();
      if (success && !input.ReadDurability(&result->durability))
        success = false;
      if (success)
        result->has_durability = input.has_durability();
      if (success)
        result->quota = input.quota();
      if (success)
        result->has_quota = input.has_quota();
      if (success && !input.ReadExpires(&result->expires))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void BucketHostInterceptorForTesting::Persist(PersistCallback callback) {
  GetForwardingInterface()->Persist(std::move(callback));
}
void BucketHostInterceptorForTesting::Persisted(PersistedCallback callback) {
  GetForwardingInterface()->Persisted(std::move(callback));
}
void BucketHostInterceptorForTesting::Estimate(EstimateCallback callback) {
  GetForwardingInterface()->Estimate(std::move(callback));
}
void BucketHostInterceptorForTesting::Durability(DurabilityCallback callback) {
  GetForwardingInterface()->Durability(std::move(callback));
}
void BucketHostInterceptorForTesting::SetExpires(::base::Time expires, SetExpiresCallback callback) {
  GetForwardingInterface()->SetExpires(
    std::move(expires)
    , std::move(callback));
}
void BucketHostInterceptorForTesting::Expires(ExpiresCallback callback) {
  GetForwardingInterface()->Expires(std::move(callback));
}
void BucketHostInterceptorForTesting::GetIdbFactory(::mojo::PendingReceiver<::blink::mojom::IDBFactory> idb_factory) {
  GetForwardingInterface()->GetIdbFactory(
    std::move(idb_factory)
    );
}
void BucketHostInterceptorForTesting::GetLockManager(::mojo::PendingReceiver<::blink::mojom::LockManager> lock_manager) {
  GetForwardingInterface()->GetLockManager(
    std::move(lock_manager)
    );
}
void BucketHostInterceptorForTesting::GetCaches(::mojo::PendingReceiver<::blink::mojom::CacheStorage> cache_storage) {
  GetForwardingInterface()->GetCaches(
    std::move(cache_storage)
    );
}
void BucketHostInterceptorForTesting::GetDirectory(GetDirectoryCallback callback) {
  GetForwardingInterface()->GetDirectory(std::move(callback));
}
void BucketHostInterceptorForTesting::GetDirectoryForDevtools(const std::vector<std::string>& directory_path_components, GetDirectoryForDevtoolsCallback callback) {
  GetForwardingInterface()->GetDirectoryForDevtools(
    std::move(directory_path_components)
    , std::move(callback));
}
BucketHostAsyncWaiter::BucketHostAsyncWaiter(
    BucketHost* proxy) : proxy_(proxy) {}

BucketHostAsyncWaiter::~BucketHostAsyncWaiter() = default;


void BucketHostAsyncWaiter::Persist(
    bool* out_persisted, bool* out_success) {
  base::RunLoop loop;
  proxy_->Persist(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_persisted
,
             bool* out_success
,
             bool persisted,
             bool success) {*out_persisted = std::move(persisted);*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_persisted,
          out_success));
  loop.Run();
}



void BucketHostAsyncWaiter::Persisted(
    bool* out_persisted, bool* out_success) {
  base::RunLoop loop;
  proxy_->Persisted(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_persisted
,
             bool* out_success
,
             bool persisted,
             bool success) {*out_persisted = std::move(persisted);*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_persisted,
          out_success));
  loop.Run();
}



void BucketHostAsyncWaiter::Estimate(
    int64_t* out_current_usage, int64_t* out_current_quota, bool* out_success) {
  base::RunLoop loop;
  proxy_->Estimate(
      base::BindOnce(
          [](base::RunLoop* loop,
             int64_t* out_current_usage
,
             int64_t* out_current_quota
,
             bool* out_success
,
             int64_t current_usage,
             int64_t current_quota,
             bool success) {*out_current_usage = std::move(current_usage);*out_current_quota = std::move(current_quota);*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_current_usage,
          out_current_quota,
          out_success));
  loop.Run();
}



void BucketHostAsyncWaiter::Durability(
    ::blink::mojom::BucketDurability* out_durability, bool* out_success) {
  base::RunLoop loop;
  proxy_->Durability(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::BucketDurability* out_durability
,
             bool* out_success
,
             ::blink::mojom::BucketDurability durability,
             bool success) {*out_durability = std::move(durability);*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_durability,
          out_success));
  loop.Run();
}



void BucketHostAsyncWaiter::SetExpires(
    ::base::Time expires, bool* out_success) {
  base::RunLoop loop;
  proxy_->SetExpires(
      std::move(expires),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool BucketHostAsyncWaiter::SetExpires(
    ::base::Time expires) {
  bool async_wait_result;
  SetExpires(std::move(expires),&async_wait_result);
  return async_wait_result;
}

void BucketHostAsyncWaiter::Expires(
    std::optional<::base::Time>* out_expires, bool* out_success) {
  base::RunLoop loop;
  proxy_->Expires(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<::base::Time>* out_expires
,
             bool* out_success
,
             std::optional<::base::Time> expires,
             bool success) {*out_expires = std::move(expires);*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_expires,
          out_success));
  loop.Run();
}



void BucketHostAsyncWaiter::GetDirectory(
    ::blink::mojom::FileSystemAccessErrorPtr* out_result, ::mojo::PendingRemote<::blink::mojom::FileSystemAccessDirectoryHandle>* out_directory) {
  base::RunLoop loop;
  proxy_->GetDirectory(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::FileSystemAccessErrorPtr* out_result
,
             ::mojo::PendingRemote<::blink::mojom::FileSystemAccessDirectoryHandle>* out_directory
,
             ::blink::mojom::FileSystemAccessErrorPtr result,
             ::mojo::PendingRemote<::blink::mojom::FileSystemAccessDirectoryHandle> directory) {*out_result = std::move(result);*out_directory = std::move(directory);
            loop->Quit();
          },
          &loop,
          out_result,
          out_directory));
  loop.Run();
}



void BucketHostAsyncWaiter::GetDirectoryForDevtools(
    const std::vector<std::string>& directory_path_components, ::blink::mojom::FileSystemAccessErrorPtr* out_result, ::mojo::PendingRemote<::blink::mojom::FileSystemAccessDirectoryHandle>* out_directory) {
  base::RunLoop loop;
  proxy_->GetDirectoryForDevtools(
      std::move(directory_path_components),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::FileSystemAccessErrorPtr* out_result
,
             ::mojo::PendingRemote<::blink::mojom::FileSystemAccessDirectoryHandle>* out_directory
,
             ::blink::mojom::FileSystemAccessErrorPtr result,
             ::mojo::PendingRemote<::blink::mojom::FileSystemAccessDirectoryHandle> directory) {*out_result = std::move(result);*out_directory = std::move(directory);
            loop->Quit();
          },
          &loop,
          out_result,
          out_directory));
  loop.Run();
}






void BucketManagerHostInterceptorForTesting::OpenBucket(const std::string& name, BucketPoliciesPtr policy, OpenBucketCallback callback) {
  GetForwardingInterface()->OpenBucket(
    std::move(name)
    , 
    std::move(policy)
    , std::move(callback));
}
void BucketManagerHostInterceptorForTesting::GetBucketForDevtools(const std::string& name, ::mojo::PendingReceiver<BucketHost> receiver) {
  GetForwardingInterface()->GetBucketForDevtools(
    std::move(name)
    , 
    std::move(receiver)
    );
}
void BucketManagerHostInterceptorForTesting::Keys(KeysCallback callback) {
  GetForwardingInterface()->Keys(std::move(callback));
}
void BucketManagerHostInterceptorForTesting::DeleteBucket(const std::string& name, DeleteBucketCallback callback) {
  GetForwardingInterface()->DeleteBucket(
    std::move(name)
    , std::move(callback));
}
BucketManagerHostAsyncWaiter::BucketManagerHostAsyncWaiter(
    BucketManagerHost* proxy) : proxy_(proxy) {}

BucketManagerHostAsyncWaiter::~BucketManagerHostAsyncWaiter() = default;


void BucketManagerHostAsyncWaiter::OpenBucket(
    const std::string& name, BucketPoliciesPtr policy, ::mojo::PendingRemote<BucketHost>* out_remote, BucketError* out_error) {
  base::RunLoop loop;
  proxy_->OpenBucket(
      std::move(name),
      std::move(policy),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::mojo::PendingRemote<BucketHost>* out_remote
,
             BucketError* out_error
,
             ::mojo::PendingRemote<BucketHost> remote,
             BucketError error) {*out_remote = std::move(remote);*out_error = std::move(error);
            loop->Quit();
          },
          &loop,
          out_remote,
          out_error));
  loop.Run();
}



void BucketManagerHostAsyncWaiter::Keys(
    std::vector<std::string>* out_buckets, bool* out_success) {
  base::RunLoop loop;
  proxy_->Keys(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<std::string>* out_buckets
,
             bool* out_success
,
             const std::vector<std::string>& buckets,
             bool success) {*out_buckets = std::move(buckets);*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_buckets,
          out_success));
  loop.Run();
}



void BucketManagerHostAsyncWaiter::DeleteBucket(
    const std::string& name, bool* out_success) {
  base::RunLoop loop;
  proxy_->DeleteBucket(
      std::move(name),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool BucketManagerHostAsyncWaiter::DeleteBucket(
    const std::string& name) {
  bool async_wait_result;
  DeleteBucket(std::move(name),&async_wait_result);
  return async_wait_result;
}






}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif